/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["89"],{90688:function(e){e.exports="---\ntitle: Working with Vertica in Metabase\nredirect_from:\n  - /docs/latest/administration-guide/databases/vertica\n---\n\n# Working with Vertica in Metabase\n\nStarting in v0.20.0, Metabase provides a driver for connecting to Vertica databases. Under the hood, Metabase uses Vertica's JDBC driver;\ndue to licensing restrictions, we can't include it as part of Metabase. Luckily, downloading it yourself and making it available to Metabase\nis straightforward and only takes a few minutes.\n\n## Downloading the Vertica JDBC Driver JAR\n\nYou can download the JDBC driver from [Vertica's JDBC driver downloads page](https://my.vertica.com/download/vertica/client-drivers/).\nHead to this page, log in to your account, accept the license agreement, and download `vertica-jdbc-8.0.0-0.jar` (for Vertica DB version 8.0)\nor whatever driver version most closely matches the version of Vertica you're running.\n\nIt's important to make sure you use the correct version of the JDBC driver; version\n8.0 of the driver won't work with Vertica version 7.2; version 7.2 of the driver won't work with Vertica version 7.1, and so forth. If in doubt,\nconsult Vertica's documentation to find the correct version of the JDBC driver for your version of Vertica.\n\n## Adding the Vertica JDBC Driver JAR to the Metabase Plugins Directory\n\nMetabase will automatically make the Vertica driver available if it finds the Vertica JDBC driver JAR in the Metabase plugins directory when it starts up.\nAll you need to do is create the directory, move the JAR you just downloaded into it, and restart Metabase.\n\n### When running from a JAR\n\nBy default, the plugins directory is called `plugins`, and lives in the same directory as the Metabase JAR.\n\nFor example, if you're running Metabase from a directory called `/app/`, you should move the Vertica JDBC driver JAR to `/app/plugins/`:\n\n```txt\n# example directory structure for running Metabase with Vertica support\n/app/metabase.jar\n/app/plugins/vertica-jdbc-8.0.0-0.jar\n```\n\n### When running from Docker\n\nThe process for adding plugins when running via Docker is similar, but you'll need to mount the `plugins` directory. Refer to instructions [here](../../installation-and-operation/running-metabase-on-docker.md#adding-external-dependencies-or-plugins) for more details.\n\n## Model features\n\nThere aren't (yet) any model features for Vertica.\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n"}}]);