/**********************************************************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
 * other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
 * applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
 * EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
 * SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO
 * THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 *
 * Copyright (C) 2020 Renesas Electronics Corporation. All rights reserved.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * File Name    : s_flash.c
 * Version      : 1.01
 * Description  : Key information file.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * History : DD.MM.YYYY Version  Description
 *         : 05.10.2020 1.00        First Release.
 *         : 02.12.2020 1.01        Added new functions such as the Brainpool curve.
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Includes   <System Includes> , "Project Includes"
 *********************************************************************************************************************/
#include "r_sce_if.h"

/**********************************************************************************************************************
 Macro definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Typedef definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Exported global variables
 *********************************************************************************************************************/

uint32_t const S_FLASH[] =
{
#ifndef __ARMEB__   /* Little endian */
    0x19c65dd9, 0xf7ae8f0c, 0x8547ad91, 0x7b72b52c,
    0x0f3230fd, 0xf6392795, 0x9aa261d1, 0x74268596,
    0xbecc4bb1, 0xb2c24076, 0xa5b8632c, 0xc0039ffa,
    0x216e5781, 0xe395d17c, 0xf758dbc4, 0x80a4b099,
    0xf34d5b9a, 0x8921721c, 0xb415335e, 0x1dd664cd,
    0xd20dfdec, 0x539fb6d3, 0x2b1179e6, 0x0401566a,
    0x7ca95554, 0xee8e9350, 0x035f25c2, 0xa0336495,
    0x613dd519, 0x620c4f27, 0x3b72be50, 0x7126173d,
    0x2aa75f85, 0x004cbcf6, 0x85be601d, 0x082eeef1,
    0x57a3c02a, 0xcaa70020, 0xe7c91ed7, 0x0344f90b,
    0x5a8ae1e8, 0xa37cc1dd, 0xa1c39637, 0x8926909b,
    0x358733fa, 0xd4ffb1e3, 0xec7b9511, 0xc4ddc1a5,
    0x97526f88, 0x723cb608, 0x06cde9b0, 0xb0d2e560,
    0xbc8f8784, 0x1e921c64, 0x3d12c592, 0x8fa9d78c,
    0x82a1959a, 0x0301ad23, 0xb168ecfd, 0xd4a93ea7,
    0x72171f72, 0xb979c9ba, 0x0776ed1b, 0x82b64194,
    0xf90520f2, 0x316c47c2, 0x204ee6ab, 0x41418f29,
    0xe235cd7c, 0xe684602c, 0x668d54b8, 0x13d05de7,
    0x80226cce, 0x9ca540ad, 0xff8ba779, 0x426f6494,
    0xe78a108f, 0xe04b90b2, 0x8c57c067, 0x11292e67,
    0xa0a158c4, 0x2f77d0a8, 0x8437554c, 0x77837dbf,
    0xc9110111, 0xc809dbd3, 0x6e71dfa9, 0x208aa96f,
    0x7b6f2ce6, 0x85e2f291, 0xb5cd7fa3, 0xf6b2ae17,
    0x3c53aa18, 0x11d11ba3, 0xd44bc869, 0x78e9ed83,
    0x23bc555d, 0xcfaadd5f, 0xd469640f, 0x552ced08,
    0x66fbb34c, 0x7eea685b, 0x8be76838, 0x49b22ae8,
    0x9ac17766, 0x6deb07b1, 0xb461889d, 0x3ca05bde,
    0x96f10ca1, 0x34332ee8, 0xbec25e60, 0xb0601a2e,
    0xd6bea5a9, 0x9d979a17, 0x81b20a19, 0x177459e1,
    0x65d631b7, 0xf0a2119a, 0x2b9dea68, 0xf4906ae9,
    0x0a3bc948, 0x44d28534, 0xf65c7490, 0xb4a1bdc2,
    0xb9a4a882, 0x4f3af3f2, 0xeed46217, 0xa0b473d3,
    0xd5c63d07, 0xb9619563, 0xf28a7df0, 0xa8300068,
    0x69082293, 0x700a8047, 0xa19afb49, 0xa7b9ff95,
    0xa53849ff, 0x6df0d0e4, 0x546af49b, 0x8551a7c7,
    0x1aae5248, 0x6f98ad78, 0x037e409d, 0xc2b84165,
    0x61e51e8f, 0x4c26d8b6, 0x12131036, 0x8f1bd478,
    0x57592224, 0x6d1a6761, 0x749e9ad5, 0xcc69bb52,
    0x73a78059, 0xf4b53dbe, 0xf5d1f104, 0xb2508ac6,
    0x15130399, 0x638f1700, 0x04e46339, 0x0f52d1b9,
    0x31fc1dcd, 0x78071410, 0xfa801575, 0xfff3b806,
    0xc795523a, 0xd54c15ad, 0x410a12c2, 0xf8834721,
    0x3f826379, 0x6ccb1b70, 0x06b6a23c, 0xe3bb2401,
    0xb854245b, 0xc299a550, 0x57561336, 0xbc2cd00f,
    0x63f51c2a, 0x8f92499f, 0xee0aeb34, 0xe2b21385,
    0x5c909105, 0x87f1d446, 0x5d29610a, 0xd7c53442,
    0xdedc5934, 0x4ebab486, 0x46143aff, 0x8bfda984,
    0xf048ffd3, 0xa95843e8, 0x13bbaea0, 0x27f04b5e,
    0xb334dff4, 0x1965abd5, 0x0b829d6c, 0x04a0ba42,
    0xf9ff4f5a, 0xe5386563, 0xef87a278, 0x82db82ea,
    0x35d9e58f, 0xbb8f355c, 0x0804fce4, 0xb2e9d0e1,
    0xbf449182, 0x601b79f9, 0x8a0473d9, 0x0e934459,
    0x84aa5043, 0x5f1f6f3c, 0x324d34a1, 0xaa68945d,
    0xa1a8659e, 0x15f51550, 0x77eb641b, 0x9bdbadf3,
    0x2219cdb7, 0x4703c92f, 0xc32f2fab, 0x2e6da944,
    0x93d4d9ce, 0xd8e64407, 0xeb4c835b, 0x6c6c654a,
    0x75091822, 0xddd54367, 0xbde4bd46, 0x8e70cfb4,
    0x68fc8807, 0x5da706bc, 0xc2011fb3, 0x72937438,
    0xc02e5ac5, 0x8b83f813, 0xd61db568, 0x68bcb657,
    0xd3e7bf3c, 0x34c61402, 0xefc19207, 0x86c4b23f,
    0xfb853a19, 0x735a3383, 0x5f7e0db5, 0xdc2fe14d,
    0x0edc6353, 0x77fd2ef2, 0xd518441c, 0x9e2a5c71,
    0x061d7df0, 0x73c80357, 0x9445bdd4, 0x4ab75b73,
    0x2152e6a9, 0x2bb5cc40, 0xffa024d4, 0x3934ccc4,
    0xe0b743cc, 0x09af024d, 0x2b81922f, 0x04372797,
    0x1e21a13b, 0x1e0f981b, 0xa53ad88e, 0xc7b12719,
    0x49cbd466, 0xe8de3f89, 0x1ea0921a, 0xb3d77b98,
    0x609c7e29, 0x4113f5ea, 0x22dd7972, 0xdd817060,
    0x9954714d, 0xe0a6336c, 0xd24892a8, 0x8184ef79,
    0xa7d98457, 0xd7b577cb, 0xa683c239, 0x4aaddb7a,
    0xcbee6c24, 0x139b5c72, 0xc769c68e, 0xd83d0bbf,
    0xb4dbc06c, 0x1f31629b, 0xc0f2af88, 0x52be72ff,
    0x69689661, 0x449c42a5, 0xa8731771, 0x7cfb63a6,
    0xaa4dcd6a, 0x2192f5bb, 0xd64a016a, 0x213e2d46,
    0xb9ffc561, 0x4628fb46, 0x3f38f0ef, 0xf3884c62,
    0x966d878f, 0xe3a88b4b, 0xc556d8ca, 0x6c5ce269,
    0xc18196e8, 0x86554726, 0x694177de, 0x9ed8e019,
    0x2109e7cb, 0xa737d26e, 0x54a8efaf, 0xae636eec,
    0xbca03b4c, 0x121255f3, 0xc12ab0dc, 0xfd09ce08,
    0x9e6475b7, 0x4f1853bb, 0xb4898c31, 0x45d99693,
    0x585070c8, 0x1abee076, 0xb9d8aa51, 0x823fb550,
    0xc48a2352, 0x7dcd1a9a, 0xbc38642e, 0xe5c29875,
    0x4429cbbd, 0x8326afa4, 0x41374b15, 0x573488ef,
    0x1b7d51e2, 0x21afec59, 0x5828755a, 0x7f20b5d7,
    0xeb83ce65, 0x0d422c16, 0x98e586b3, 0x2c14b91b,
    0x1e4adb39, 0x5195d85e, 0x7aab99de, 0xe783541e,
    0xe72752ea, 0x9cdf6c2f, 0x010f90c5, 0x1d41a856,
    0x303a2a39, 0xfc98ded8, 0xb8df937a, 0x3da63aa4,
    0xcb4c87e4, 0x0f9361a2, 0x5182fad8, 0xf65fe80a,
    0x2a93363e, 0x7cb1d020, 0x3e7a7a9c, 0x0a70da03,
    0x0555a2df, 0xe3ae55fb, 0x3528e66a, 0xd530b649,
    0x82ffe137, 0x8ca2b44c, 0xae6da15f, 0x32463301,
    0xbfba60bd, 0x7552e283, 0x61a5c705, 0x04d28d13,
    0xbae5b25f, 0x7452f319, 0x43319b11, 0xd80c91b6,
    0xe9f9935b, 0x40554d0b, 0xfa66be11, 0xcb202b3f,
    0x8fc0a1a5, 0xb9eb72d6, 0xfbe7052d, 0x7ad8def1,
    0x01d4447e, 0xa81482bf, 0x4cdfb227, 0x5652bfe4,
    0xc3dcd821, 0x7f050c21, 0xa78e3a8a, 0x388d7339,
    0xcfefd171, 0x1844abc3, 0xb279c5c8, 0x38d4206e,
    0xae61ff8b, 0x82e435a5, 0x956bbfbd, 0xe0ca1baf,
    0xa0108350, 0x12c3356b, 0xcad50459, 0xd442926a,
    0x39a73c47, 0x34717c4d, 0xc59a46a3, 0x0708504c,
    0xd57473fe, 0xdb15107b, 0x421f1464, 0xe44be480,
    0x3db63cae, 0x52948b97, 0x37b69438, 0xee34f625,
    0xbb8db726, 0xa409d239, 0xd36948e7, 0x59ada516,
    0x4126977d, 0xc1523007, 0xf354c740, 0x7ce40fb4,
    0x229c794b, 0x195cb1f9, 0x7a4bbab3, 0x974c43a0,
    0xe397e325, 0x908c5588, 0x6198cbc6, 0x6f89aece,
    0x68368035, 0x528821dc, 0x2bed5a48, 0xa3d95eaa,
    0x7847b8fe, 0x64b836ca, 0x65ec4487, 0x1686b391,
    0x5cd3957f, 0xec0b1e5a, 0x0ede2877, 0x54e70a94,
    0xc1f9c70d, 0xf6969cfd, 0xaa31276c, 0x73fd3e1f,
    0x77f37843, 0x113873ba, 0xc4ab9845, 0x95474cec,
    0xabe34835, 0x6ef80abb, 0xc99aca26, 0x4d8d32f2,
    0x0f8aefc8, 0x5fadac1a, 0x420fe4fd, 0xc890264b,
    0x7c4cdaab, 0x4928a4c7, 0x6014015c, 0x4d387cd3,
    0x5afc28fe, 0x06658a7a, 0x81c0373c, 0xbc81a7b8,
    0xdd6560ae, 0x6d6cc176, 0x4cf2522d, 0x8d1c3447,
    0xae552d07, 0x976a6dc5, 0x3bf8c16e, 0xaf3631cb,
    0x4af7c8af, 0x7cf2704c, 0x6d64a28f, 0x5090a33a,
    0x470b693f, 0xe1ab4415, 0x4f12233f, 0x8c039e04,
    0x5c8238d4, 0x3cd75a5c, 0xb76653b6, 0x01962c47,
    0xe6e3fea5, 0x79186fb4, 0x9a2a882f, 0xacff2ff6,
    0xc75340ef, 0x89fa6ce5, 0xde581d9c, 0x5a173d83,
    0x388a4ed0, 0x77163510, 0x61e7c526, 0x2d75c9f3,
    0x14eb89d1, 0xd7d63474, 0x973ef588, 0x0490686f,
    0x6dc917a6, 0x9bf8d7ca, 0xc4989e67, 0x8da90f32,
    0x902d3a82, 0x05c17982, 0x1777e815, 0x0cb8e8d3,
    0xe8722b6d, 0x878d8818, 0x3a0c80f0, 0x427483fc,
    0x62211584, 0xf7fdae96, 0xe9fdc995, 0x98a42466,
    0x2d9b04f5, 0x0e8965d8, 0x9c14be49, 0xc5afaed7,
    0x6d7446f5, 0xc99a58e5, 0xec37d57f, 0xb32865ed,
    0xc898e13d, 0x8e73e892, 0xe9c8639e, 0xc7516afe,
    0x92585b57, 0x864cbb7f, 0x0a60b79a, 0xc736bf70,
    0x11bd3332, 0x9c3723fd, 0xaad22e0f, 0x75d1a5f5,
    0xaaeb8a56, 0x02233e2f, 0x435bd786, 0xff804747,
    0x58f2be96, 0x761d9773, 0x2384ec4c, 0x1dd9da98,
    0xc917a104, 0x1df24172, 0x491eda94, 0xc63692e2,
    0xc4457db2, 0x33ec290d, 0xab3a87c8, 0x292f4ac9,
    0xa9eac997, 0x1eda4700, 0x506c6579, 0x61310862,
    0xecbc1e14, 0xeaafd7b2, 0x0d30ec87, 0x374b4c6f,
    0x8c1c1ba7, 0xbe84ba99, 0x2dfd66c1, 0x8890d276,
    0x3c39ff47, 0x913a2386, 0xe6e0faaa, 0xd1fc4187,
    0x81a34d63, 0xa81e0dae, 0xfed967dc, 0x18d7cf6a,
    0xdfec7646, 0x82858213, 0x2f04ebff, 0x7a9c0191,
    0xc1de6b00, 0x3faf6c53, 0x419a2962, 0xd05bad13,
    0x7d54bcf9, 0x11cb7366, 0xfdb60e81, 0x900f9eef,
    0x559df9bb, 0x9b9a799a, 0xc82a4cc7, 0xf76504fb,
    0x4a01e462, 0xc1d89e13, 0x6813722c, 0x63984689,
    0xd5f7f865, 0x3704bd36, 0x2ea4cefd, 0x8bb419a5,
    0x81f03757, 0xab562508, 0xf7702829, 0x82bee62b,
    0x572772f3, 0xe2001a1e, 0xa78d3304, 0xd3d39c29,
    0x485b9832, 0x57d0ac30, 0xe81c4f98, 0x93df5e81,
    0x628fd013, 0x6f4bd641, 0x73240f6b, 0x45784b21,
    0xcf041140, 0xd1183f69, 0x5d734ee7, 0x60aa8e69,
    0x5e4de66c, 0x514a376b, 0xf4a17767, 0xbe0a9130,
    0xb8f788cf, 0x488d7910, 0x580d9136, 0x9f25273a,
    0xdaaad126, 0xbc28c6c8, 0x67529e67, 0x89af3044,
    0x951477c3, 0xd88e0b84, 0x47be9aa3, 0x5f937c98,
    0xbc3fb7e4, 0x359bcb5b, 0xaed29afe, 0x8b0e5bb1,
    0xe5e4633b, 0x0ba3749c, 0xc61c9260, 0x2d5cdc1f,
    0xd86be07f, 0xba205716, 0xf94694c5, 0x156bc911,
    0xdf3c2bb1, 0x5840ac0c, 0x8baded84, 0xa4562abb,
    0x83836f57, 0xbdcc4271, 0x3f5b090e, 0x118389d1,
    0x6bf16adf, 0xcf71e6bc, 0xc11614b4, 0xa96bf780,
    0x2c205a2f, 0x8e037891, 0x4d4c3f97, 0xadb0d7bc,
    0x7766e9af, 0x76772df4, 0x59db0faf, 0x8a6ab4e0,
    0xc73dbbd7, 0x2b7e7159, 0x4cf79004, 0xa328f950,
    0x99518c71, 0x8d94c994, 0x633521aa, 0xa042469e,
    0xbdd353b1, 0x5f8a26ef, 0x4bdaa57e, 0x5d3dc9ee,
    0x22c52893, 0x42938f8b, 0xb7f6f102, 0x7a3169fc,
    0x9418278b, 0x0dddbbe6, 0x6e605548, 0xf889939f,
    0xde912172, 0xb752747f, 0xa0490134, 0x709bb297,
    0x9cc32857, 0xda6beec0, 0x583cabab, 0x7567d11a,
    0x295d0feb, 0xe0e1dd25, 0x023927de, 0xdf55c126,
    0xa1f436a5, 0x8fd3a91e, 0xa5436c59, 0xba57765a,
    0x06ec4a39, 0xe741c2a1, 0x94886f10, 0x337da70a,
    0x7fb7ecd7, 0xe6ce2b9a, 0x027df38e, 0x30288776,
    0x51e00852, 0x7f1f2e58, 0x6483e067, 0x3eeefd76,
    0xf48c9725, 0xa76058e7, 0x9aec2462, 0x6b692fc7,
    0x9d756b1f, 0x3e36387f, 0xeb89c9b4, 0xf9d194ab,
    0x1a17c57e, 0x09412db7, 0xf6d3957e, 0x15acabbb,
    0x113f426c, 0x4e542c5b, 0xa79ee329, 0xe40191ea,
    0xbb0aed99, 0xf4971042, 0x5456d181, 0xd8850795,
    0x40e7d08c, 0x0bb28e13, 0x6bfb9034, 0xa37b4f2e,
    0xbe8dff10, 0x9e045e35, 0x8a0f1e48, 0x114f8289,
    0x5a81e9b0, 0x8585eef8, 0xb2e8ece2, 0x0f806781,
    0x49bec798, 0xe9240e70, 0x2a1c06ac, 0x86b54e67,
    0x8545b42c, 0xad6a94bc, 0xd8040155, 0x9b58475d,
    0xf2e10da8, 0xb33f67c5, 0x904ecb31, 0x540416e0,
    0x3cd84ea9, 0x54460383, 0xbc659dd2, 0x1f454282,
    0x513c5504, 0x19d49a34, 0x60aa667a, 0xc10ad618,
    0x0f3b4301, 0x55a8f3b2, 0x142286d8, 0x4d62539e,
    0x2cefa7f4, 0xc085a906, 0x29b553bd, 0xe200f099,
    0xe043d9d7, 0xb2df324c, 0x47f7c692, 0x38b4460a,
    0xcea856da, 0x7e5482cf, 0x8f594bf4, 0xfdf9e67d,
    0x072907bd, 0x05e84507, 0xb409f764, 0x5685ac37,
    0x2f616d20, 0xa921a806, 0x2fcd7c60, 0x3537b690,
    0x4cd7fc2b, 0x28874399, 0x99c03bf2, 0x08d08351,
    0xd3c2b3c3, 0x41764935, 0x8f9a0b39, 0x03b3d7ba,
    0x3d94148d, 0xc8e9701a, 0xa709e699, 0xef630c59,
    0x27c2e7d7, 0xdb862878, 0xdd5f31f6, 0x5f71c787,
    0x3477afc6, 0x54a5878f, 0x46b8bb2c, 0x477657a7,
    0x71d69dab, 0x00b387ce, 0x997e23ca, 0xa0bb52c7,
    0x5e6a4121, 0xa177e918, 0x8db59c0d, 0x01170c0c,
    0x781b3f87, 0xd2581c6f, 0x80f04ac9, 0x0e05591b,
    0x066516c8, 0x47639b03, 0x5a942b8b, 0x3d2e8bfd,
    0xa2f8e050, 0x13ede956, 0x16c2d150, 0x25ef0382,
    0x48c4c98a, 0x9746a253, 0x2e8caa2e, 0x26c126bb,
    0x311af3cf, 0x574fe5e3, 0x8cacf126, 0x76383227,
    0x827d636d, 0x1363f34c, 0x9f07655a, 0xf18d89ac,
    0x5a50c00d, 0xcfac930f, 0x2c5ff37e, 0x43b48e28,
    0xb59e400d, 0x1d37cc46, 0x2d22b556, 0x87be9cc9,
    0x75e0fd8e, 0x590c557c, 0x3511111e, 0x2e1a9cb6,
    0xdcd52f84, 0x90e2fb48, 0xa30e65ee, 0xf29b98dc,
    0x410b48fb, 0x480dca67, 0xd4fc295f, 0xccb53112,
    0xa6276e42, 0xdb28bfcf, 0x82454cfa, 0x7ef63fe0,
    0x275f89c7, 0xa80ad52c, 0x75ec4f71, 0x988ee1fd,
    0x1a201b13, 0x3fee0140, 0xf2103c42, 0x97bda735,
    0x94ba7201, 0xd3d6403a, 0x6f931edb, 0x4896ff67,
    0x6454649a, 0x39b46375, 0x263f48dc, 0x7375a319,
    0x0a905733, 0x3cadedd1, 0xecfba061, 0x1dfdcbda,
    0xf55659d9, 0x783aa14f, 0xf99879f5, 0x3dda87fa,
    0x42e5b2e0, 0xa7059461, 0xe053a85b, 0xa499b36f,
    0x1006714f, 0x077077eb, 0xf1be6d1a, 0x385386e5,
    0xd9ec5776, 0xce87bb5a, 0x89614c6c, 0x934f2174,
    0x15bb3ee6, 0xcf41016b, 0x7bfbf14f, 0x5e5c05ed,
    0x4c2e035d, 0x78af694a, 0xcd322fb4, 0x0df776b4,
    0xb95629e1, 0x491e5130, 0x1ce907c3, 0x0ac71eeb,
    0x872fdab0, 0x584a37c0, 0xb95415c5, 0xbefea0c2,
    0xd1ce604b, 0xb75c56ef, 0x70096956, 0x02e7eaaa,
    0xb3201523, 0x544850ea, 0xc1fb70a1, 0xd203dd59,
    0x7e68157f, 0x57997278, 0xeac02007, 0xf5a71f82,
    0xc553aca6, 0xb0a19086, 0x5b9b830e, 0xbde45b00,
    0xe9b1bdfb, 0x7c101324, 0x826024eb, 0x2306f7ff,
    0x55b431f2, 0xc6eb4a9e, 0x49a3e530, 0x9b5bff5e,
    0x1824e962, 0x83d76953, 0x8921c0b5, 0xcc085ab8,
    0x5572365c, 0x796a81d5, 0x95e20539, 0xe2579a2a,
    0x0b815aa4, 0xebba12c6, 0xc3e97ed4, 0x3e41e902,
    0xe15035f7, 0x58361fbd, 0xa64acc30, 0xb02a4760,
    0x3f273a1c, 0xa8a93ff1, 0x851fe400, 0x5ef449df,
    0xd99d3485, 0xd0b83dff, 0x3e5dda5c, 0xb2fe2fb8,
    0xdfe06486, 0xcf19b96c, 0x41eabc1f, 0x5b4c5af2,
    0x7a447c5d, 0x5be2bbb7, 0x02429689, 0x00905d32,
    0xbc60be14, 0x6e21cb21, 0x561e42b6, 0x322da4eb,
    0x8dbd29df, 0x0bee27a9, 0xb94d9440, 0x5b4721a5,
    0xf989cf6f, 0xd27f2ed5, 0x1db502f5, 0x9a743c1e,
    0x11aa77b3, 0x356a5330, 0x4cc9e1cc, 0x40882da6,
    0xf0bef598, 0x24eb068f, 0xc5b09c19, 0xaca1b049,
    0xb0cf3e7f, 0x94e4c7ce, 0x6671fdad, 0xde602cdc,
    0x96598e34, 0x3aa72431, 0xf4104bc5, 0x91b0df3d,
    0x21242934, 0xf461a11d, 0xe0d3aee0, 0x984ffad1,
    0x10630574, 0x853ac0d9, 0xac4618f5, 0x990c9e97,
    0x6f82be89, 0x699dd700, 0x2079761b, 0xaf6b9ef0,
    0xa54d105d, 0x9964d718, 0x08c041fd, 0x450652bd,
    0x9fd9b70e, 0x4ce8cec7, 0x4496de51, 0xfc01f943,
    0x6bed7c17, 0x49bca669, 0x73dd9231, 0x3565605a,
    0x564aa20a, 0xfd8a5f7b, 0x8bd94f94, 0xf45481f6,
    0xc81127bb, 0xa92a8d39, 0x0aa6a2dd, 0x459ca6c3,
    0x2f5ad28a, 0x43cbc3bf, 0x072a1beb, 0x447986d8,
    0x811fb0f3, 0x2675e8b8, 0x978a1b07, 0x003370e4,
    0x928a2383, 0x453da03f, 0x8c7cd4ef, 0x9e9ee7f3,
    0x63e27da5, 0x5f21f83c, 0x4f6d7d0e, 0x80b6f7eb,
    0x9412023e, 0xd8749e6b, 0x4a1b9778, 0x7d96ca3d,
    0x96b5748b, 0x143517c6, 0x8e0e3c19, 0xdd155885,
    0x7724f7e4, 0x8c59ca7a, 0x4edb4318, 0x0954b029,
    0xf0eb18e2, 0x512d6ec1, 0xa09bb70a, 0x516b6fca,
    0xb3d52b6f, 0xd7bd01d2, 0xe9368649, 0x2b14b2fd,
    0xc68ba3ba, 0xc4499777, 0x3a9abfcb, 0x8b8f6651,
    0xf019ba77, 0x0bfed248, 0x34c81adb, 0x278e668e,
    0xcbd8c7e8, 0x7a084bad, 0x396c5aea, 0xafda91e7,
    0xf5d33ee2, 0xd5a7b19a, 0xd70dcd40, 0xa4cab26b,
    0xedc03bcb, 0xeaefea21, 0xdc2ad701, 0x6c354eb5,
    0x2a4530f3, 0x066b1d31, 0x42ffbf98, 0x1622d2fd,
    0x2b9e4029, 0xe2ed19fd, 0x33494288, 0x7cee5b13,
    0xa87b1265, 0x8589ee1b, 0xbb9ef46d, 0x72548ef6,
    0xa817256b, 0x8a5c015c, 0x5551ddd2, 0xa7910899,
    0xc7138a2d, 0x427053df, 0xa59b68fc, 0x86946d5a,
    0x46dcba19, 0xbf8e571c, 0xecfbdf6e, 0x39d98528,
    0x205ffe16, 0xd2d33d57, 0x6ed57a75, 0xcfbaae42,
    0x10dd31ed, 0x15db0be5, 0x5abd1972, 0xa2be8270,
    0x2ad3306a, 0xfbbfbd55, 0x1d29d40d, 0x77134c54,
    0xd735fc72, 0x63acef9a, 0x58580b85, 0x20aaf950,
    0x3d8ee30c, 0x454faad4, 0xb2c95d3b, 0x9fb71efc,
    0x6606d962, 0x2483600f, 0x6d6bf0b3, 0x24a02da2,
    0x61cbea21, 0xf32608c7, 0x6c88e99c, 0x2413efec,
    0xbe02c68d, 0xf7f38124, 0x5c4e703f, 0x79fad2be,
    0xbe537e7b, 0x32c04d98, 0xe0259f85, 0xee96b4b5,
    0x8188bbf2, 0xd81de985, 0x52faf0ab, 0x7201cddb,
    0xadd630f2, 0x8c0ed899, 0x1fda534c, 0xe2680ec0,
    0x4e3c3f7c, 0x3a3701dc, 0x35bdceb1, 0xa955335d,
    0x76917569, 0x2802fdb3, 0x5fe5013b, 0xe99b5f0b,
    0x74723d34, 0x71f2b8db, 0xc254392f, 0x7bcec3d0,
    0x34897913, 0x2a3a0f29, 0x880a3ca4, 0xfa25e0c6,
    0x2dbf63bf, 0xb3340210, 0xf835bbfa, 0x7402b194,
    0x7a19eff7, 0x0406c772, 0x977226c8, 0x70ce3d81,
    0x5e739739, 0xd6e2ab97, 0x153f6b1f, 0x2008e75f,
    0x481ed665, 0x23c06ba5, 0x4e22b1da, 0xbd402cce,
    0x47348c95, 0x843b33a1, 0x026a2347, 0x76a6ea94,
    0x7c0c1b6d, 0x7b9c4e32, 0xa4d15c42, 0xe1804ae0,
    0xb162724f, 0x6ce108c8, 0x7b312a3a, 0x45ca3caa,
    0xf308719f, 0xe7704b1d, 0xe049ce96, 0xec851fbb,
    0x707271c9, 0x82d75add, 0x66b2f84d, 0xa2934aaa,
    0x63e94362, 0x8b684706, 0x39c28c4a, 0xb4a9147e,
    0xf2384427, 0x44a862e6, 0x3e59700c, 0xd2fc9834,
    0x4cff2c76, 0x1ade587a, 0x625d179f, 0x5608159a,
    0xedd41fac, 0xd651a52f, 0x987d970b, 0x8aff493d,
    0x6934b11a, 0x32c47218, 0xd55809c5, 0xffdcbd6a,
    0x5a62bdcf, 0x264a85b7, 0x2fd6d4e8, 0xe194fb16,
    0x523b61ff, 0xf2db6abc, 0xe908fedb, 0x820115a1,
    0x4c474d60, 0xe464afd4, 0x250ac753, 0x5c85f7c8,
    0x5ad96286, 0x83a5f507, 0xc7d1f6f8, 0x2acb6910,
    0x24edc5a7, 0x508bba94, 0x7547aa3a, 0x367ad48a,
    0x9259da6b, 0xf8ac81c6, 0xebf126ca, 0x2e0ee6a6,
    0x0534240d, 0x83af8db6, 0x6ac466e1, 0xd627795a,
    0x1763b9ba, 0x2f77f955, 0x0009c686, 0x6eb4541e,
    0x674da68c, 0x0533e750, 0xf58f7eaf, 0xb9a8e790,
    0x6fe55003, 0x88a3e9a7, 0x26602404, 0x70bf245d,
    0x454281a1, 0xc1fcab34, 0xc19d3de7, 0x239748f5,
    0x412e937f, 0x922c5fd8, 0x800e48a1, 0x570c5c0b,
    0x59b45f12, 0x7979ead9, 0xe67c803c, 0xea2eeb3b,
    0xe6290ce9, 0xbdbb1d3e, 0xffa23986, 0xeb0b16cd,
    0x218639b5, 0xd151e24f, 0x4c34ada5, 0x5c69ec12,
    0x6ddc5cba, 0xe4e9556a, 0xd10d55ce, 0x1bd99a11,
    0x85e09e86, 0x8697be1a, 0x14ef3ce9, 0x5ad52dfd,
    0xbe65f785, 0x831f2a16, 0x045555aa, 0x580bb7df,
    0x96657464, 0x9fb47a09, 0xfe996e23, 0x14030b6b,
    0x2209a34e, 0x10d3e533, 0x4b12517b, 0xb45ef85d,
    0x2937a4a0, 0xf9b7348b, 0x813c431b, 0xdbf30d6f,
    0x26c5c83c, 0x096f7ad4, 0x82ac0fcc, 0x37c2735f,
    0xdf4b33cb, 0xa8a3b563, 0x2c728d3b, 0x40c5e445,
    0xd1f8d6c7, 0xd352c859, 0x14511e49, 0x36dbc3e2,
    0x3739d44d, 0x5584ffe7, 0x55e82ece, 0x40daca41,
    0x933d4ca3, 0xe19199e0, 0x278ab905, 0x98801d94,
    0x73367db1, 0x2fcf37d1, 0x65e166d9, 0x6219b703,
    0x96e1f9ce, 0xc0cec0c5, 0x556be575, 0x74a07408,
    0xb0fce1f3, 0x1163bd27, 0x7fe07783, 0x05deb10f,
    0xf5c62a68, 0x07790d32, 0xa8a35c98, 0xed40b5c6,
    0x3fb50744, 0xf2bd588e, 0x667749b3, 0x9a7bb402,
    0x987ba780, 0xfdc6adfb, 0x1fd8e9d5, 0xd54b5870,
    0xee630780, 0x22ebc07f, 0x7c0c4b72, 0xf8aee545,
    0xa4e0449c, 0xfd966dec, 0xeb5c4544, 0x1f11036b,
    0x7ad37564, 0xb3bd2ecf, 0x633ed8f9, 0x37214afb,
    0x90c5bfe2, 0x709ea398, 0xc2e1d293, 0x45c29e1c,
    0x9f8c207c, 0xa16493c8, 0xc768a5a8, 0xde265cc8,
    0xa9d922f6, 0xa0d74050, 0x5b7bd9da, 0x2afbc1f5,
    0x4d4bdfb9, 0xc60752ae, 0xe0c8719a, 0xe89095f9,
    0x1cc906cd, 0x529a8bdc, 0x5aaecc78, 0xd5744538,
    0x01882bf5, 0x085aab3b, 0x7efb1ca9, 0x08a20a99,
    0x0777eb54, 0xc1ce03f8, 0x57a4d87c, 0x2bdcb094,
    0x3ad62701, 0xd3f43ba0, 0x09396203, 0x844476ae,
    0x3c0ffd6e, 0xda7c282d, 0xaab6a1a5, 0xe13f8539,
    0x2a089d0c, 0x4ec2ce78, 0x0ef75f5b, 0x4ece9d35
#else               /* Big endian */
    0xd95dc619, 0x0c8faef7, 0x91ad4785, 0x2cb5727b,
    0xfd30320f, 0x952739f6, 0xd161a29a, 0x96852674,
    0xb14bccbe, 0x7640c2b2, 0x2c63b8a5, 0xfa9f03c0,
    0x81576e21, 0x7cd195e3, 0xc4db58f7, 0x99b0a480,
    0x9a5b4df3, 0x1c722189, 0x5e3315b4, 0xcd64d61d,
    0xecfd0dd2, 0xd3b69f53, 0xe679112b, 0x6a560104,
    0x5455a97c, 0x50938eee, 0xc2255f03, 0x956433a0,
    0x19d53d61, 0x274f0c62, 0x50be723b, 0x3d172671,
    0x855fa72a, 0xf6bc4c00, 0x1d60be85, 0xf1ee2e08,
    0x2ac0a357, 0x2000a7ca, 0xd71ec9e7, 0x0bf94403,
    0xe8e18a5a, 0xddc17ca3, 0x3796c3a1, 0x9b902689,
    0xfa338735, 0xe3b1ffd4, 0x11957bec, 0xa5c1ddc4,
    0x886f5297, 0x08b63c72, 0xb0e9cd06, 0x60e5d2b0,
    0x84878fbc, 0x641c921e, 0x92c5123d, 0x8cd7a98f,
    0x9a95a182, 0x23ad0103, 0xfdec68b1, 0xa73ea9d4,
    0x721f1772, 0xbac979b9, 0x1bed7607, 0x9441b682,
    0xf22005f9, 0xc2476c31, 0xabe64e20, 0x298f4141,
    0x7ccd35e2, 0x2c6084e6, 0xb8548d66, 0xe75dd013,
    0xce6c2280, 0xad40a59c, 0x79a78bff, 0x94646f42,
    0x8f108ae7, 0xb2904be0, 0x67c0578c, 0x672e2911,
    0xc458a1a0, 0xa8d0772f, 0x4c553784, 0xbf7d8377,
    0x110111c9, 0xd3db09c8, 0xa9df716e, 0x6fa98a20,
    0xe62c6f7b, 0x91f2e285, 0xa37fcdb5, 0x17aeb2f6,
    0x18aa533c, 0xa31bd111, 0x69c84bd4, 0x83ede978,
    0x5d55bc23, 0x5fddaacf, 0x0f6469d4, 0x08ed2c55,
    0x4cb3fb66, 0x5b68ea7e, 0x3868e78b, 0xe82ab249,
    0x6677c19a, 0xb107eb6d, 0x9d8861b4, 0xde5ba03c,
    0xa10cf196, 0xe82e3334, 0x605ec2be, 0x2e1a60b0,
    0xa9a5bed6, 0x179a979d, 0x190ab281, 0xe1597417,
    0xb731d665, 0x9a11a2f0, 0x68ea9d2b, 0xe96a90f4,
    0x48c93b0a, 0x3485d244, 0x90745cf6, 0xc2bda1b4,
    0x82a8a4b9, 0xf2f33a4f, 0x1762d4ee, 0xd373b4a0,
    0x073dc6d5, 0x639561b9, 0xf07d8af2, 0x680030a8,
    0x93220869, 0x47800a70, 0x49fb9aa1, 0x95ffb9a7,
    0xff4938a5, 0xe4d0f06d, 0x9bf46a54, 0xc7a75185,
    0x4852ae1a, 0x78ad986f, 0x9d407e03, 0x6541b8c2,
    0x8f1ee561, 0xb6d8264c, 0x36101312, 0x78d41b8f,
    0x24225957, 0x61671a6d, 0xd59a9e74, 0x52bb69cc,
    0x5980a773, 0xbe3db5f4, 0x04f1d1f5, 0xc68a50b2,
    0x99031315, 0x00178f63, 0x3963e404, 0xb9d1520f,
    0xcd1dfc31, 0x10140778, 0x751580fa, 0x06b8f3ff,
    0x3a5295c7, 0xad154cd5, 0xc2120a41, 0x214783f8,
    0x7963823f, 0x701bcb6c, 0x3ca2b606, 0x0124bbe3,
    0x5b2454b8, 0x50a599c2, 0x36135657, 0x0fd02cbc,
    0x2a1cf563, 0x9f49928f, 0x34eb0aee, 0x8513b2e2,
    0x0591905c, 0x46d4f187, 0x0a61295d, 0x4234c5d7,
    0x3459dcde, 0x86b4ba4e, 0xff3a1446, 0x84a9fd8b,
    0xd3ff48f0, 0xe84358a9, 0xa0aebb13, 0x5e4bf027,
    0xf4df34b3, 0xd5ab6519, 0x6c9d820b, 0x42baa004,
    0x5a4ffff9, 0x636538e5, 0x78a287ef, 0xea82db82,
    0x8fe5d935, 0x5c358fbb, 0xe4fc0408, 0xe1d0e9b2,
    0x829144bf, 0xf9791b60, 0xd973048a, 0x5944930e,
    0x4350aa84, 0x3c6f1f5f, 0xa1344d32, 0x5d9468aa,
    0x9e65a8a1, 0x5015f515, 0x1b64eb77, 0xf3addb9b,
    0xb7cd1922, 0x2fc90347, 0xab2f2fc3, 0x44a96d2e,
    0xced9d493, 0x0744e6d8, 0x5b834ceb, 0x4a656c6c,
    0x22180975, 0x6743d5dd, 0x46bde4bd, 0xb4cf708e,
    0x0788fc68, 0xbc06a75d, 0xb31f01c2, 0x38749372,
    0xc55a2ec0, 0x13f8838b, 0x68b51dd6, 0x57b6bc68,
    0x3cbfe7d3, 0x0214c634, 0x0792c1ef, 0x3fb2c486,
    0x193a85fb, 0x83335a73, 0xb50d7e5f, 0x4de12fdc,
    0x5363dc0e, 0xf22efd77, 0x1c4418d5, 0x715c2a9e,
    0xf07d1d06, 0x5703c873, 0xd4bd4594, 0x735bb74a,
    0xa9e65221, 0x40ccb52b, 0xd424a0ff, 0xc4cc3439,
    0xcc43b7e0, 0x4d02af09, 0x2f92812b, 0x97273704,
    0x3ba1211e, 0x1b980f1e, 0x8ed83aa5, 0x1927b1c7,
    0x66d4cb49, 0x893fdee8, 0x1a92a01e, 0x987bd7b3,
    0x297e9c60, 0xeaf51341, 0x7279dd22, 0x607081dd,
    0x4d715499, 0x6c33a6e0, 0xa89248d2, 0x79ef8481,
    0x5784d9a7, 0xcb77b5d7, 0x39c283a6, 0x7adbad4a,
    0x246ceecb, 0x725c9b13, 0x8ec669c7, 0xbf0b3dd8,
    0x6cc0dbb4, 0x9b62311f, 0x88aff2c0, 0xff72be52,
    0x61966869, 0xa5429c44, 0x711773a8, 0xa663fb7c,
    0x6acd4daa, 0xbbf59221, 0x6a014ad6, 0x462d3e21,
    0x61c5ffb9, 0x46fb2846, 0xeff0383f, 0x624c88f3,
    0x8f876d96, 0x4b8ba8e3, 0xcad856c5, 0x69e25c6c,
    0xe89681c1, 0x26475586, 0xde774169, 0x19e0d89e,
    0xcbe70921, 0x6ed237a7, 0xafefa854, 0xec6e63ae,
    0x4c3ba0bc, 0xf3551212, 0xdcb02ac1, 0x08ce09fd,
    0xb775649e, 0xbb53184f, 0x318c89b4, 0x9396d945,
    0xc8705058, 0x76e0be1a, 0x51aad8b9, 0x50b53f82,
    0x52238ac4, 0x9a1acd7d, 0x2e6438bc, 0x7598c2e5,
    0xbdcb2944, 0xa4af2683, 0x154b3741, 0xef883457,
    0xe2517d1b, 0x59ecaf21, 0x5a752858, 0xd7b5207f,
    0x65ce83eb, 0x162c420d, 0xb386e598, 0x1bb9142c,
    0x39db4a1e, 0x5ed89551, 0xde99ab7a, 0x1e5483e7,
    0xea5227e7, 0x2f6cdf9c, 0xc5900f01, 0x56a8411d,
    0x392a3a30, 0xd8de98fc, 0x7a93dfb8, 0xa43aa63d,
    0xe4874ccb, 0xa261930f, 0xd8fa8251, 0x0ae85ff6,
    0x3e36932a, 0x20d0b17c, 0x9c7a7a3e, 0x03da700a,
    0xdfa25505, 0xfb55aee3, 0x6ae62835, 0x49b630d5,
    0x37e1ff82, 0x4cb4a28c, 0x5fa16dae, 0x01334632,
    0xbd60babf, 0x83e25275, 0x05c7a561, 0x138dd204,
    0x5fb2e5ba, 0x19f35274, 0x119b3143, 0xb6910cd8,
    0x5b93f9e9, 0x0b4d5540, 0x11be66fa, 0x3f2b20cb,
    0xa5a1c08f, 0xd672ebb9, 0x2d05e7fb, 0xf1ded87a,
    0x7e44d401, 0xbf8214a8, 0x27b2df4c, 0xe4bf5256,
    0x21d8dcc3, 0x210c057f, 0x8a3a8ea7, 0x39738d38,
    0x71d1efcf, 0xc3ab4418, 0xc8c579b2, 0x6e20d438,
    0x8bff61ae, 0xa535e482, 0xbdbf6b95, 0xaf1bcae0,
    0x508310a0, 0x6b35c312, 0x5904d5ca, 0x6a9242d4,
    0x473ca739, 0x4d7c7134, 0xa3469ac5, 0x4c500807,
    0xfe7374d5, 0x7b1015db, 0x64141f42, 0x80e44be4,
    0xae3cb63d, 0x978b9452, 0x3894b637, 0x25f634ee,
    0x26b78dbb, 0x39d209a4, 0xe74869d3, 0x16a5ad59,
    0x7d972641, 0x073052c1, 0x40c754f3, 0xb40fe47c,
    0x4b799c22, 0xf9b15c19, 0xb3ba4b7a, 0xa0434c97,
    0x25e397e3, 0x88558c90, 0xc6cb9861, 0xceae896f,
    0x35803668, 0xdc218852, 0x485aed2b, 0xaa5ed9a3,
    0xfeb84778, 0xca36b864, 0x8744ec65, 0x91b38616,
    0x7f95d35c, 0x5a1e0bec, 0x7728de0e, 0x940ae754,
    0x0dc7f9c1, 0xfd9c96f6, 0x6c2731aa, 0x1f3efd73,
    0x4378f377, 0xba733811, 0x4598abc4, 0xec4c4795,
    0x3548e3ab, 0xbb0af86e, 0x26ca9ac9, 0xf2328d4d,
    0xc8ef8a0f, 0x1aacad5f, 0xfde40f42, 0x4b2690c8,
    0xabda4c7c, 0xc7a42849, 0x5c011460, 0xd37c384d,
    0xfe28fc5a, 0x7a8a6506, 0x3c37c081, 0xb8a781bc,
    0xae6065dd, 0x76c16c6d, 0x2d52f24c, 0x47341c8d,
    0x072d55ae, 0xc56d6a97, 0x6ec1f83b, 0xcb3136af,
    0xafc8f74a, 0x4c70f27c, 0x8fa2646d, 0x3aa39050,
    0x3f690b47, 0x1544abe1, 0x3f23124f, 0x049e038c,
    0xd438825c, 0x5c5ad73c, 0xb65366b7, 0x472c9601,
    0xa5fee3e6, 0xb46f1879, 0x2f882a9a, 0xf62fffac,
    0xef4053c7, 0xe56cfa89, 0x9c1d58de, 0x833d175a,
    0xd04e8a38, 0x10351677, 0x26c5e761, 0xf3c9752d,
    0xd189eb14, 0x7434d6d7, 0x88f53e97, 0x6f689004,
    0xa617c96d, 0xcad7f89b, 0x679e98c4, 0x320fa98d,
    0x823a2d90, 0x8279c105, 0x15e87717, 0xd3e8b80c,
    0x6d2b72e8, 0x18888d87, 0xf0800c3a, 0xfc837442,
    0x84152162, 0x96aefdf7, 0x95c9fde9, 0x6624a498,
    0xf5049b2d, 0xd865890e, 0x49be149c, 0xd7aeafc5,
    0xf546746d, 0xe5589ac9, 0x7fd537ec, 0xed6528b3,
    0x3de198c8, 0x92e8738e, 0x9e63c8e9, 0xfe6a51c7,
    0x575b5892, 0x7fbb4c86, 0x9ab7600a, 0x70bf36c7,
    0x3233bd11, 0xfd23379c, 0x0f2ed2aa, 0xf5a5d175,
    0x568aebaa, 0x2f3e2302, 0x86d75b43, 0x474780ff,
    0x96bef258, 0x73971d76, 0x4cec8423, 0x98dad91d,
    0x04a117c9, 0x7241f21d, 0x94da1e49, 0xe29236c6,
    0xb27d45c4, 0x0d29ec33, 0xc8873aab, 0xc94a2f29,
    0x97c9eaa9, 0x0047da1e, 0x79656c50, 0x62083161,
    0x141ebcec, 0xb2d7afea, 0x87ec300d, 0x6f4c4b37,
    0xa71b1c8c, 0x99ba84be, 0xc166fd2d, 0x76d29088,
    0x47ff393c, 0x86233a91, 0xaafae0e6, 0x8741fcd1,
    0x634da381, 0xae0d1ea8, 0xdc67d9fe, 0x6acfd718,
    0x4676ecdf, 0x13828582, 0xffeb042f, 0x91019c7a,
    0x006bdec1, 0x536caf3f, 0x62299a41, 0x13ad5bd0,
    0xf9bc547d, 0x6673cb11, 0x810eb6fd, 0xef9e0f90,
    0xbbf99d55, 0x9a799a9b, 0xc74c2ac8, 0xfb0465f7,
    0x62e4014a, 0x139ed8c1, 0x2c721368, 0x89469863,
    0x65f8f7d5, 0x36bd0437, 0xfdcea42e, 0xa519b48b,
    0x5737f081, 0x082556ab, 0x292870f7, 0x2be6be82,
    0xf3722757, 0x1e1a00e2, 0x04338da7, 0x299cd3d3,
    0x32985b48, 0x30acd057, 0x984f1ce8, 0x815edf93,
    0x13d08f62, 0x41d64b6f, 0x6b0f2473, 0x214b7845,
    0x401104cf, 0x693f18d1, 0xe74e735d, 0x698eaa60,
    0x6ce64d5e, 0x6b374a51, 0x6777a1f4, 0x30910abe,
    0xcf88f7b8, 0x10798d48, 0x36910d58, 0x3a27259f,
    0x26d1aada, 0xc8c628bc, 0x679e5267, 0x4430af89,
    0xc3771495, 0x840b8ed8, 0xa39abe47, 0x987c935f,
    0xe4b73fbc, 0x5bcb9b35, 0xfe9ad2ae, 0xb15b0e8b,
    0x3b63e4e5, 0x9c74a30b, 0x60921cc6, 0x1fdc5c2d,
    0x7fe06bd8, 0x165720ba, 0xc59446f9, 0x11c96b15,
    0xb12b3cdf, 0x0cac4058, 0x84edad8b, 0xbb2a56a4,
    0x576f8383, 0x7142ccbd, 0x0e095b3f, 0xd1898311,
    0xdf6af16b, 0xbce671cf, 0xb41416c1, 0x80f76ba9,
    0x2f5a202c, 0x9178038e, 0x973f4c4d, 0xbcd7b0ad,
    0xafe96677, 0xf42d7776, 0xaf0fdb59, 0xe0b46a8a,
    0xd7bb3dc7, 0x59717e2b, 0x0490f74c, 0x50f928a3,
    0x718c5199, 0x94c9948d, 0xaa213563, 0x9e4642a0,
    0xb153d3bd, 0xef268a5f, 0x7ea5da4b, 0xeec93d5d,
    0x9328c522, 0x8b8f9342, 0x02f1f6b7, 0xfc69317a,
    0x8b271894, 0xe6bbdd0d, 0x4855606e, 0x9f9389f8,
    0x722191de, 0x7f7452b7, 0x340149a0, 0x97b29b70,
    0x5728c39c, 0xc0ee6bda, 0xabab3c58, 0x1ad16775,
    0xeb0f5d29, 0x25dde1e0, 0xde273902, 0x26c155df,
    0xa536f4a1, 0x1ea9d38f, 0x596c43a5, 0x5a7657ba,
    0x394aec06, 0xa1c241e7, 0x106f8894, 0x0aa77d33,
    0xd7ecb77f, 0x9a2bcee6, 0x8ef37d02, 0x76872830,
    0x5208e051, 0x582e1f7f, 0x67e08364, 0x76fdee3e,
    0x25978cf4, 0xe75860a7, 0x6224ec9a, 0xc72f696b,
    0x1f6b759d, 0x7f38363e, 0xb4c989eb, 0xab94d1f9,
    0x7ec5171a, 0xb72d4109, 0x7e95d3f6, 0xbbabac15,
    0x6c423f11, 0x5b2c544e, 0x29e39ea7, 0xea9101e4,
    0x99ed0abb, 0x421097f4, 0x81d15654, 0x950785d8,
    0x8cd0e740, 0x138eb20b, 0x3490fb6b, 0x2e4f7ba3,
    0x10ff8dbe, 0x355e049e, 0x481e0f8a, 0x89824f11,
    0xb0e9815a, 0xf8ee8585, 0xe2ece8b2, 0x8167800f,
    0x98c7be49, 0x700e24e9, 0xac061c2a, 0x674eb586,
    0x2cb44585, 0xbc946aad, 0x550104d8, 0x5d47589b,
    0xa80de1f2, 0xc5673fb3, 0x31cb4e90, 0xe0160454,
    0xa94ed83c, 0x83034654, 0xd29d65bc, 0x8242451f,
    0x04553c51, 0x349ad419, 0x7a66aa60, 0x18d60ac1,
    0x01433b0f, 0xb2f3a855, 0xd8862214, 0x9e53624d,
    0xf4a7ef2c, 0x06a985c0, 0xbd53b529, 0x99f000e2,
    0xd7d943e0, 0x4c32dfb2, 0x92c6f747, 0x0a46b438,
    0xda56a8ce, 0xcf82547e, 0xf44b598f, 0x7de6f9fd,
    0xbd072907, 0x0745e805, 0x64f709b4, 0x37ac8556,
    0x206d612f, 0x06a821a9, 0x607ccd2f, 0x90b63735,
    0x2bfcd74c, 0x99438728, 0xf23bc099, 0x5183d008,
    0xc3b3c2d3, 0x35497641, 0x390b9a8f, 0xbad7b303,
    0x8d14943d, 0x1a70e9c8, 0x99e609a7, 0x590c63ef,
    0xd7e7c227, 0x782886db, 0xf6315fdd, 0x87c7715f,
    0xc6af7734, 0x8f87a554, 0x2cbbb846, 0xa7577647,
    0xab9dd671, 0xce87b300, 0xca237e99, 0xc752bba0,
    0x21416a5e, 0x18e977a1, 0x0d9cb58d, 0x0c0c1701,
    0x873f1b78, 0x6f1c58d2, 0xc94af080, 0x1b59050e,
    0xc8166506, 0x039b6347, 0x8b2b945a, 0xfd8b2e3d,
    0x50e0f8a2, 0x56e9ed13, 0x50d1c216, 0x8203ef25,
    0x8ac9c448, 0x53a24697, 0x2eaa8c2e, 0xbb26c126,
    0xcff31a31, 0xe3e54f57, 0x26f1ac8c, 0x27323876,
    0x6d637d82, 0x4cf36313, 0x5a65079f, 0xac898df1,
    0x0dc0505a, 0x0f93accf, 0x7ef35f2c, 0x288eb443,
    0x0d409eb5, 0x46cc371d, 0x56b5222d, 0xc99cbe87,
    0x8efde075, 0x7c550c59, 0x1e111135, 0xb69c1a2e,
    0x842fd5dc, 0x48fbe290, 0xee650ea3, 0xdc989bf2,
    0xfb480b41, 0x67ca0d48, 0x5f29fcd4, 0x1231b5cc,
    0x426e27a6, 0xcfbf28db, 0xfa4c4582, 0xe03ff67e,
    0xc7895f27, 0x2cd50aa8, 0x714fec75, 0xfde18e98,
    0x131b201a, 0x4001ee3f, 0x423c10f2, 0x35a7bd97,
    0x0172ba94, 0x3a40d6d3, 0xdb1e936f, 0x67ff9648,
    0x9a645464, 0x7563b439, 0xdc483f26, 0x19a37573,
    0x3357900a, 0xd1edad3c, 0x61a0fbec, 0xdacbfd1d,
    0xd95956f5, 0x4fa13a78, 0xf57998f9, 0xfa87da3d,
    0xe0b2e542, 0x619405a7, 0x5ba853e0, 0x6fb399a4,
    0x4f710610, 0xeb777007, 0x1a6dbef1, 0xe5865338,
    0x7657ecd9, 0x5abb87ce, 0x6c4c6189, 0x74214f93,
    0xe63ebb15, 0x6b0141cf, 0x4ff1fb7b, 0xed055c5e,
    0x5d032e4c, 0x4a69af78, 0xb42f32cd, 0xb476f70d,
    0xe12956b9, 0x30511e49, 0xc307e91c, 0xeb1ec70a,
    0xb0da2f87, 0xc0374a58, 0xc51554b9, 0xc2a0febe,
    0x4b60ced1, 0xef565cb7, 0x56690970, 0xaaeae702,
    0x231520b3, 0xea504854, 0xa170fbc1, 0x59dd03d2,
    0x7f15687e, 0x78729957, 0x0720c0ea, 0x821fa7f5,
    0xa6ac53c5, 0x8690a1b0, 0x0e839b5b, 0x005be4bd,
    0xfbbdb1e9, 0x2413107c, 0xeb246082, 0xfff70623,
    0xf231b455, 0x9e4aebc6, 0x30e5a349, 0x5eff5b9b,
    0x62e92418, 0x5369d783, 0xb5c02189, 0xb85a08cc,
    0x5c367255, 0xd5816a79, 0x3905e295, 0x2a9a57e2,
    0xa45a810b, 0xc612baeb, 0xd47ee9c3, 0x02e9413e,
    0xf73550e1, 0xbd1f3658, 0x30cc4aa6, 0x60472ab0,
    0x1c3a273f, 0xf13fa9a8, 0x00e41f85, 0xdf49f45e,
    0x85349dd9, 0xff3db8d0, 0x5cda5d3e, 0xb82ffeb2,
    0x8664e0df, 0x6cb919cf, 0x1fbcea41, 0xf25a4c5b,
    0x5d7c447a, 0xb7bbe25b, 0x89964202, 0x325d9000,
    0x14be60bc, 0x21cb216e, 0xb6421e56, 0xeba42d32,
    0xdf29bd8d, 0xa927ee0b, 0x40944db9, 0xa521475b,
    0x6fcf89f9, 0xd52e7fd2, 0xf502b51d, 0x1e3c749a,
    0xb377aa11, 0x30536a35, 0xcce1c94c, 0xa62d8840,
    0x98f5bef0, 0x8f06eb24, 0x199cb0c5, 0x49b0a1ac,
    0x7f3ecfb0, 0xcec7e494, 0xadfd7166, 0xdc2c60de,
    0x348e5996, 0x3124a73a, 0xc54b10f4, 0x3ddfb091,
    0x34292421, 0x1da161f4, 0xe0aed3e0, 0xd1fa4f98,
    0x74056310, 0xd9c03a85, 0xf51846ac, 0x979e0c99,
    0x89be826f, 0x00d79d69, 0x1b767920, 0xf09e6baf,
    0x5d104da5, 0x18d76499, 0xfd41c008, 0xbd520645,
    0x0eb7d99f, 0xc7cee84c, 0x51de9644, 0x43f901fc,
    0x177ced6b, 0x69a6bc49, 0x3192dd73, 0x5a606535,
    0x0aa24a56, 0x7b5f8afd, 0x944fd98b, 0xf68154f4,
    0xbb2711c8, 0x398d2aa9, 0xdda2a60a, 0xc3a69c45,
    0x8ad25a2f, 0xbfc3cb43, 0xeb1b2a07, 0xd8867944,
    0xf3b01f81, 0xb8e87526, 0x071b8a97, 0xe4703300,
    0x83238a92, 0x3fa03d45, 0xefd47c8c, 0xf3e79e9e,
    0xa57de263, 0x3cf8215f, 0x0e7d6d4f, 0xebf7b680,
    0x3e021294, 0x6b9e74d8, 0x78971b4a, 0x3dca967d,
    0x8b74b596, 0xc6173514, 0x193c0e8e, 0x855815dd,
    0xe4f72477, 0x7aca598c, 0x1843db4e, 0x29b05409,
    0xe218ebf0, 0xc16e2d51, 0x0ab79ba0, 0xca6f6b51,
    0x6f2bd5b3, 0xd201bdd7, 0x498636e9, 0xfdb2142b,
    0xbaa38bc6, 0x779749c4, 0xcbbf9a3a, 0x51668f8b,
    0x77ba19f0, 0x48d2fe0b, 0xdb1ac834, 0x8e668e27,
    0xe8c7d8cb, 0xad4b087a, 0xea5a6c39, 0xe791daaf,
    0xe23ed3f5, 0x9ab1a7d5, 0x40cd0dd7, 0x6bb2caa4,
    0xcb3bc0ed, 0x21eaefea, 0x01d72adc, 0xb54e356c,
    0xf330452a, 0x311d6b06, 0x98bfff42, 0xfdd22216,
    0x29409e2b, 0xfd19ede2, 0x88424933, 0x135bee7c,
    0x65127ba8, 0x1bee8985, 0x6df49ebb, 0xf68e5472,
    0x6b2517a8, 0x5c015c8a, 0xd2dd5155, 0x990891a7,
    0x2d8a13c7, 0xdf537042, 0xfc689ba5, 0x5a6d9486,
    0x19badc46, 0x1c578ebf, 0x6edffbec, 0x2885d939,
    0x16fe5f20, 0x573dd3d2, 0x757ad56e, 0x42aebacf,
    0xed31dd10, 0xe50bdb15, 0x7219bd5a, 0x7082bea2,
    0x6a30d32a, 0x55bdbffb, 0x0dd4291d, 0x544c1377,
    0x72fc35d7, 0x9aefac63, 0x850b5858, 0x50f9aa20,
    0x0ce38e3d, 0xd4aa4f45, 0x3b5dc9b2, 0xfc1eb79f,
    0x62d90666, 0x0f608324, 0xb3f06b6d, 0xa22da024,
    0x21eacb61, 0xc70826f3, 0x9ce9886c, 0xecef1324,
    0x8dc602be, 0x2481f3f7, 0x3f704e5c, 0xbed2fa79,
    0x7b7e53be, 0x984dc032, 0x859f25e0, 0xb5b496ee,
    0xf2bb8881, 0x85e91dd8, 0xabf0fa52, 0xdbcd0172,
    0xf230d6ad, 0x99d80e8c, 0x4c53da1f, 0xc00e68e2,
    0x7c3f3c4e, 0xdc01373a, 0xb1cebd35, 0x5d3355a9,
    0x69759176, 0xb3fd0228, 0x3b01e55f, 0x0b5f9be9,
    0x343d7274, 0xdbb8f271, 0x2f3954c2, 0xd0c3ce7b,
    0x13798934, 0x290f3a2a, 0xa43c0a88, 0xc6e025fa,
    0xbf63bf2d, 0x100234b3, 0xfabb35f8, 0x94b10274,
    0xf7ef197a, 0x72c70604, 0xc8267297, 0x813dce70,
    0x3997735e, 0x97abe2d6, 0x1f6b3f15, 0x5fe70820,
    0x65d61e48, 0xa56bc023, 0xdab1224e, 0xce2c40bd,
    0x958c3447, 0xa1333b84, 0x47236a02, 0x94eaa676,
    0x6d1b0c7c, 0x324e9c7b, 0x425cd1a4, 0xe04a80e1,
    0x4f7262b1, 0xc808e16c, 0x3a2a317b, 0xaa3cca45,
    0x9f7108f3, 0x1d4b70e7, 0x96ce49e0, 0xbb1f85ec,
    0xc9717270, 0xdd5ad782, 0x4df8b266, 0xaa4a93a2,
    0x6243e963, 0x0647688b, 0x4a8cc239, 0x7e14a9b4,
    0x274438f2, 0xe662a844, 0x0c70593e, 0x3498fcd2,
    0x762cff4c, 0x7a58de1a, 0x9f175d62, 0x9a150856,
    0xac1fd4ed, 0x2fa551d6, 0x0b977d98, 0x3d49ff8a,
    0x1ab13469, 0x1872c432, 0xc50958d5, 0x6abddcff,
    0xcfbd625a, 0xb7854a26, 0xe8d4d62f, 0x16fb94e1,
    0xff613b52, 0xbc6adbf2, 0xdbfe08e9, 0xa1150182,
    0x604d474c, 0xd4af64e4, 0x53c70a25, 0xc8f7855c,
    0x8662d95a, 0x07f5a583, 0xf8f6d1c7, 0x1069cb2a,
    0xa7c5ed24, 0x94ba8b50, 0x3aaa4775, 0x8ad47a36,
    0x6bda5992, 0xc681acf8, 0xca26f1eb, 0xa6e60e2e,
    0x0d243405, 0xb68daf83, 0xe166c46a, 0x5a7927d6,
    0xbab96317, 0x55f9772f, 0x86c60900, 0x1e54b46e,
    0x8ca64d67, 0x50e73305, 0xaf7e8ff5, 0x90e7a8b9,
    0x0350e56f, 0xa7e9a388, 0x04246026, 0x5d24bf70,
    0xa1814245, 0x34abfcc1, 0xe73d9dc1, 0xf5489723,
    0x7f932e41, 0xd85f2c92, 0xa1480e80, 0x0b5c0c57,
    0x125fb459, 0xd9ea7979, 0x3c807ce6, 0x3beb2eea,
    0xe90c29e6, 0x3e1dbbbd, 0x8639a2ff, 0xcd160beb,
    0xb5398621, 0x4fe251d1, 0xa5ad344c, 0x12ec695c,
    0xba5cdc6d, 0x6a55e9e4, 0xce550dd1, 0x119ad91b,
    0x869ee085, 0x1abe9786, 0xe93cef14, 0xfd2dd55a,
    0x85f765be, 0x162a1f83, 0xaa555504, 0xdfb70b58,
    0x64746596, 0x097ab49f, 0x236e99fe, 0x6b0b0314,
    0x4ea30922, 0x33e5d310, 0x7b51124b, 0x5df85eb4,
    0xa0a43729, 0x8b34b7f9, 0x1b433c81, 0x6f0df3db,
    0x3cc8c526, 0xd47a6f09, 0xcc0fac82, 0x5f73c237,
    0xcb334bdf, 0x63b5a3a8, 0x3b8d722c, 0x45e4c540,
    0xc7d6f8d1, 0x59c852d3, 0x491e5114, 0xe2c3db36,
    0x4dd43937, 0xe7ff8455, 0xce2ee855, 0x41cada40,
    0xa34c3d93, 0xe09991e1, 0x05b98a27, 0x941d8098,
    0xb17d3673, 0xd137cf2f, 0xd966e165, 0x03b71962,
    0xcef9e196, 0xc5c0cec0, 0x75e56b55, 0x0874a074,
    0xf3e1fcb0, 0x27bd6311, 0x8377e07f, 0x0fb1de05,
    0x682ac6f5, 0x320d7907, 0x985ca3a8, 0xc6b540ed,
    0x4407b53f, 0x8e58bdf2, 0xb3497766, 0x02b47b9a,
    0x80a77b98, 0xfbadc6fd, 0xd5e9d81f, 0x70584bd5,
    0x800763ee, 0x7fc0eb22, 0x724b0c7c, 0x45e5aef8,
    0x9c44e0a4, 0xec6d96fd, 0x44455ceb, 0x6b03111f,
    0x6475d37a, 0xcf2ebdb3, 0xf9d83e63, 0xfb4a2137,
    0xe2bfc590, 0x98a39e70, 0x93d2e1c2, 0x1c9ec245,
    0x7c208c9f, 0xc89364a1, 0xa8a568c7, 0xc85c26de,
    0xf622d9a9, 0x5040d7a0, 0xdad97b5b, 0xf5c1fb2a,
    0xb9df4b4d, 0xae5207c6, 0x9a71c8e0, 0xf99590e8,
    0xcd06c91c, 0xdc8b9a52, 0x78ccae5a, 0x384574d5,
    0xf52b8801, 0x3bab5a08, 0xa91cfb7e, 0x990aa208,
    0x54eb7707, 0xf803cec1, 0x7cd8a457, 0x94b0dc2b,
    0x0127d63a, 0xa03bf4d3, 0x03623909, 0xae764484,
    0x6efd0f3c, 0x2d287cda, 0xa5a1b6aa, 0x39853fe1,
    0x0c9d082a, 0x78cec24e, 0x5b5ff70e, 0x359dce4e
#endif  /* defined __ARMEB__ */
};



/**********************************************************************************************************************
 Private (static) variables and functions
 *********************************************************************************************************************/

