# - Try to find cwipi
# Once done this will define
#  CWIPI_FOUND - System has cwipi
#  CWIPI_INCLUDE_DIRS - The cwipi include directories
#  CWIPI_LIBRARIES - The libraries needed to use cwipi
#  CWIPI_DEFINITIONS - Compiler switches required for using cwipi


SET(CWIPI_SEARCH_PATHS
    ${CMAKE_SOURCE_DIR}/ThirdParty/cwipi/build/lib
    ${CMAKE_SOURCE_DIR}/../ThirdParty/cwipi/build/lib
    ${CMAKE_SOURCE_DIR}/ThirdParty/dist/build/lib
    ${CMAKE_SOURCE_DIR}/../ThirdParty/dist/build/lib)

FIND_PATH(CWIPI_INCLUDE_DIR NAMES cwipi.h PATHS ${CWIPI_SEARCH_PATHS})
FIND_LIBRARY(CWIPI_LIBRARY NAMES cwipi PATHS ${CWIPI_SEARCH_PATHS})
FIND_LIBRARY(CWIPI_LIBRARY_FVMC NAMES fvmc PATHS ${CWIPI_SEARCH_PATHS})
FIND_LIBRARY(CWIPI_LIBRARY_BFTC NAMES BFTC PATHS ${CWIPI_SEARCH_PATHS})


SET(CWIPI_FOUND FALSE)
IF (CWIPI_LIBRARY)
  SET(CWIPI_FOUND TRUE)
  INCLUDE_DIRECTORIES(${CWIPI_INCLUDE_DIR})
  MARK_AS_ADVANCED(CWIPI_LIBRARY)
  MARK_AS_ADVANCED(CWIPI_LIBRARY_FVMC)
  MARK_AS_ADVANCED(CWIPI_LIBRARY_BFTC)
  MARK_AS_ADVANCED(CWIPI_INCLUDE_DIR)
ENDIF (CWIPI_LIBRARY)

IF (CWIPI_FOUND)
  IF (NOT CWIPI_FIND_QUIETLY)
     MESSAGE(STATUS "Found CWIPI: ${CWIPI_INCLUDE_DIR}")
  ENDIF (NOT CWIPI_FIND_QUIETLY)
ELSE(CWIPI_FOUND)
  IF (CWIPI_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find CWIPI")
  ENDIF (CWIPI_FIND_REQUIRED)
ENDIF (CWIPI_FOUND)
