////////////////////////////////////////////////////////////////////////////////
//
//  File: Point.cpp
//
//  For more information, please see: http://www.nektar.info/
//
//  The MIT License
//
//  Copyright (c) 2006 Division of Applied Mathematics, Brown University (USA),
//  Department of Aeronautics, Imperial College London (UK), and Scientific
//  Computing and Imaging Institute, University of Utah (USA).
//
//  Permission is hereby granted, free of charge, to any person obtaining a
//  copy of this software and associated documentation files (the "Software"),
//  to deal in the Software without restriction, including without limitation
//  the rights to use, copy, modify, merge, publish, distribute, sublicense,
//  and/or sell copies of the Software, and to permit persons to whom the
//  Software is furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included
//  in all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
//  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
//  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
//  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
//  DEALINGS IN THE SOFTWARE.
//
//  Description: Mesh point object.
//
////////////////////////////////////////////////////////////////////////////////

#include <NekMesh/MeshElements/Point.h>

using namespace std;

namespace Nektar::NekMesh
{

LibUtilities::ShapeType Point::m_type =
    GetElementFactory().RegisterCreatorFunction(LibUtilities::ePoint,
                                                Point::create, "Point");

/**
 * @brief Create a point element.
 */
Point::Point(ElmtConfig pConf, vector<NodeSharedPtr> pNodeList,
             vector<int> pTagList)
    : Element(pConf, GetNumNodes(pConf), pNodeList.size())
{
    m_tag     = "";
    m_dim     = 0;
    m_taglist = pTagList;
    m_vertex.push_back(pNodeList[0]);
}

/**
 * @brief Return the number of nodes defining a point (i.e. return 1).
 */
unsigned int Point::GetNumNodes([[maybe_unused]] ElmtConfig pConf)
{
    return 1;
}
} // namespace Nektar::NekMesh
