/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.com.sun.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openjsse.com.sun.net.ssl.SSLSecurity;
import org.openjsse.com.sun.net.ssl.TrustManager;
import org.openjsse.com.sun.net.ssl.TrustManagerFactorySpi;
import org.openjsse.com.sun.net.ssl.X509TrustManagerComSunWrapper;

final class TrustManagerFactorySpiWrapper
extends TrustManagerFactorySpi {
    private TrustManagerFactory theTrustManagerFactory;

    TrustManagerFactorySpiWrapper(String algName, Provider prov) throws NoSuchAlgorithmException {
        this.theTrustManagerFactory = TrustManagerFactory.getInstance(algName, prov);
    }

    @Override
    protected void engineInit(KeyStore ks) throws KeyStoreException {
        this.theTrustManagerFactory.init(ks);
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        int src;
        javax.net.ssl.TrustManager[] tma = this.theTrustManagerFactory.getTrustManagers();
        Object[] tmaw = new TrustManager[tma.length];
        int dst = 0;
        for (src = 0; src < tma.length; ++src) {
            if (!(tma[src] instanceof TrustManager)) {
                if (!(tma[src] instanceof X509TrustManager)) continue;
                tmaw[dst] = new X509TrustManagerComSunWrapper((X509TrustManager)tma[src]);
                ++dst;
                continue;
            }
            tmaw[dst] = (TrustManager)((Object)tma[src]);
            ++dst;
        }
        if (dst != src) {
            tmaw = (TrustManager[])SSLSecurity.truncateArray(tmaw, new TrustManager[dst]);
        }
        return tmaw;
    }
}

