/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static final Color DEFAULT_BORDER_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.25f);

    FileDrop(Component c, Listener listener) throws TooManyListenersException {
        this(c, BorderFactory.createMatteBorder(2, 2, 2, 2, DEFAULT_BORDER_COLOR), true, listener);
    }

    FileDrop(Component c, Border dragBorder, boolean recursive, Listener listener) throws TooManyListenersException {
        this.dropListener = new FileDropTargetListener(c, dragBorder, listener);
        this.makeDropTarget(c, recursive);
    }

    private void makeDropTarget(final Component c, boolean recursive) throws TooManyListenersException {
        DropTarget dt = new DropTarget();
        dt.addDropTargetListener(this.dropListener);
        c.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent evt) {
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(comps[i], recursive);
            }
        }
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (int i = 0; !ok && i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            ok = true;
        }
        return ok;
    }

    static void remove(Component c) {
        FileDrop.remove(c, true);
    }

    static void remove(Component c, boolean recursive) {
        c.setDropTarget(null);
        if (recursive && c instanceof Container) {
            Component[] comps = ((Container)c).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                FileDrop.remove(comps[i], recursive);
            }
        }
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private final Component mC;
        private final Border mDragBorder;
        private final Listener mListener;

        public void dragEnter(DropTargetDragEvent evt) {
            if (FileDrop.this.isDragOk(evt)) {
                if (this.mC instanceof JComponent) {
                    JComponent jc = (JComponent)this.mC;
                    FileDrop.this.normalBorder = jc.getBorder();
                    jc.setBorder(this.mDragBorder);
                }
                evt.acceptDrag(1);
            } else {
                evt.rejectDrag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent evt) {
            try {
                Transferable tr = evt.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    evt.acceptDrop(1);
                    List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    File[] files = new File[fileList.size()];
                    fileList.toArray(files);
                    if (this.mListener != null) {
                        this.mListener.filesDropped(files);
                    }
                    evt.getDropTargetContext().dropComplete(true);
                } else {
                    evt.rejectDrop();
                }
            }
            catch (IOException io) {
                evt.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                evt.rejectDrop();
            }
            finally {
                if (this.mC instanceof JComponent) {
                    JComponent jc = (JComponent)this.mC;
                    jc.setBorder(FileDrop.this.normalBorder);
                }
            }
        }

        public void dragExit(DropTargetEvent evt) {
            if (this.mC instanceof JComponent) {
                JComponent jc = (JComponent)this.mC;
                jc.setBorder(FileDrop.this.normalBorder);
            }
        }

        public void dropActionChanged(DropTargetDragEvent evt) {
            if (FileDrop.this.isDragOk(evt)) {
                evt.acceptDrag(1);
            } else {
                evt.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public FileDropTargetListener(Component aC, Border aDragBorder, Listener aListener) {
            this.mC = aC;
            this.mDragBorder = aDragBorder;
            this.mListener = aListener;
        }
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

