#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 103 => 0x69 },
	'about' => { 463 => 'about' },
	'aboutcvterm' => { 455 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 455 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 455 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 455 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 455 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 110 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 469 => 'absPeakAudioFilePath' },
	'academicfield' => { 459 => 'academicField' },
	'acceleration' => { 113 => 0x9404, 450 => 'Acceleration' },
	'accelerationtracking' => { 78 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 364 => 0x3 },
	'accelerometerx' => { 300 => 0x8d },
	'accelerometery' => { 300 => 0x8e },
	'accelerometerz' => { 300 => 0x8c },
	'accessoryserialnumber' => { 300 => 0x54 },
	'accessorytype' => { 300 => 0x53 },
	'actionadvised' => { 125 => 0x2a },
	'activearea' => { 113 => 0xc68d },
	'actived-lighting' => { 214 => 0x22, 251 => 0x24 },
	'actived-lightingmode' => { 251 => 0x25 },
	'adaptervoltage' => { 131 => 0x407 },
	'addaspectratioinfo' => { 78 => 0x80e },
	'addiptcinformation' => { 78 => 0x815 },
	'additionalmodelinformation' => { 455 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 78 => 0x80f, 79 => 0x11, 80 => 0x13, 83 => 0x14 },
	'address' => { 152 => 'Address' },
	'adjustmentmode' => { 371 => 0x15 },
	'adlbracketingstep' => { 232 => 0x883 },
	'adlbracketingtype' => { 232 => 0x884 },
	'adobe' => { 114 => 'Adobe' },
	'adultcontentwarning' => { 287 => 'AdultContentWarning', 462 => 'adultContentWarning' },
	'advancedfilter' => { 121 => 0x1201 },
	'advancedraw' => { 253 => 0x76a43203 },
	'advancedscenetype' => { 300 => 0x3d },
	'advisory' => { 467 => 'Advisory' },
	'ae_iso' => { 308 => 0x2, 309 => 0x4, 310 => 0x12 },
	'aeaperture' => { 308 => 0x1, 309 => 0x3, 310 => 0x11 },
	'aeaperturesteps' => { 308 => 0x8, 309 => 0xb },
	'aebautocancel' => { 78 => 0x104 },
	'aebbracketvalue' => { 72 => 0x11 },
	'aebracketingsteps' => { 231 => 0x174c, 232 => 0x87b, 240 => 0x1756 },
	'aebsequence' => { 78 => 0x105 },
	'aebsequenceautocancel' => { 76 => 0x9, 77 => 0x9, 79 => 0x8, 80 => 0x9, 83 => 0x9, 84 => 0x7 },
	'aebshotcount' => { 78 => 0x106 },
	'aebxv' => { 308 => 0x4, 309 => 0x6 },
	'aeerror' => { 309 => 0x8 },
	'aeexposuretime' => { 308 => 0x0, 309 => 0x2, 310 => 0x10 },
	'aelbutton' => { 174 => 0x45 },
	'aelexposureindicator' => { 174 => 0x51 },
	'aelock' => { 174 => 0x5b, 262 => '4.2', 271 => '4.2', 277 => 0x201, 335 => 0x48, 379 => 0x40, 380 => 0x40, 381 => [0x86,0x286] },
	'aelockbutton' => { 260 => '16.1', 262 => '4.1', 265 => '15.1', 266 => '16.1', 267 => '16.1', 269 => '30.1', 270 => '16.1', 271 => '4.1', 273 => '17.1', 275 => '17.1' },
	'aelockbuttonplusdials' => { 260 => '16.2', 269 => '32.1', 273 => '44.1' },
	'aelockformb-d80' => { 275 => '3.1' },
	'aelockmetermodeafterfocus' => { 78 => 0x114 },
	'aemaxaperture' => { 308 => 0x9, 309 => 0x10, 310 => 0x1c },
	'aemaxaperture2' => { 308 => 0xa, 309 => 0x11, 310 => 0x1d },
	'aemeteringmode' => { 308 => 0xc },
	'aemeteringmode2' => { 308 => '13.1' },
	'aemeteringsegments' => { 177 => 0x628, 335 => 0x209 },
	'aemicroadjustment' => { 78 => 0x110 },
	'aeminaperture' => { 308 => 0xb, 309 => 0x12, 310 => 0x1e },
	'aeminexposuretime' => { 308 => 0x5, 309 => 0x13, 310 => 0x1f },
	'aeprogrammode' => { 308 => 0x6 },
	'aeprojectlink' => { 444 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 444 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 444 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 444 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 444 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 444 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 308 => 0xd },
	'aexv' => { 308 => 0x3, 309 => 0x5 },
	'af-cpriority' => { 122 => '0.2' },
	'af-cpriorityselection' => { 260 => '1.1', 261 => '1.1', 263 => '1.1', 264 => '1.1', 266 => '0.1', 267 => '0.1', 268 => '0.1', 269 => '1.1', 270 => '0.1', 273 => '1.1', 274 => '1.1' },
	'af-csetting' => { 118 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 118 => '0.2' },
	'af-ctrackingsensitivity' => { 118 => '0.1' },
	'af-czoneareaswitching' => { 118 => '0.3' },
	'af-onbutton' => { 263 => '70.1', 264 => '70.1', 274 => '70.1' },
	'af-onformb-d10' => { 260 => '3.3', 269 => '3.2' },
	'af-onformb-d11' => { 270 => '2.2' },
	'af-onformb-d12' => { 273 => '50.1' },
	'af-spriority' => { 122 => '0.1' },
	'af-spriorityselection' => { 260 => '1.2', 261 => '1.2', 263 => '1.4', 264 => '1.4', 268 => '0.2', 269 => '1.2', 270 => '0.2', 273 => '1.2', 274 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 260 => '2.1', 261 => '2.1', 263 => '78.3', 264 => '78.3', 269 => '2.1', 273 => '2.1', 274 => '78.3' },
	'afadjustment' => { 335 => 0x72, 344 => 0x267 },
	'afandmeteringbuttons' => { 78 => 0x701 },
	'afaperture' => { 207 => 0x5, 208 => 0x5, 212 => 0x5 },
	'afareaheight' => { 183 => [0x1a,0x50] },
	'afareaillumination' => { 174 => 0x4b, 271 => '15.3' },
	'afareamode' => { 120 => '0.2', 170 => 0x33, 174 => 0xe, 182 => 0x0, 183 => 0x5, 300 => 0xf, 361 => 0x1205, 372 => [0xa,0x3a], 379 => 0x11, 380 => 0x10, 381 => 0x24, 391 => 0xb043, 414 => 0x17 },
	'afareamodesetting' => { 262 => '11.1', 265 => '0.1', 271 => '16.1', 275 => '2.1', 391 => 0x201c },
	'afareapointsize' => { 120 => '0.3' },
	'afareas' => { 277 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 78 => 0x51b },
	'afareawidth' => { 183 => [0x18,0x4e] },
	'afareaxposition' => { 183 => [0x14,0x4a], 361 => 0x1203 },
	'afareaxposition1' => { 361 => 0x1201 },
	'afareayposition' => { 183 => [0x16,0x4c], 361 => 0x1204 },
	'afareayposition1' => { 361 => 0x1202 },
	'afareazonesize' => { 120 => '0.4' },
	'afassist' => { 76 => 0x5, 84 => 0x5, 174 => 0x48, 260 => '2.5', 262 => '0.2', 265 => '0.2', 266 => '1.1', 267 => '1.1', 268 => '1.3', 269 => '2.4', 270 => '1.3', 271 => '0.2', 273 => '2.4', 275 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 78 => 0x50e, 79 => 0x4, 80 => 0x5, 81 => 0x4, 82 => 0x4, 83 => 0x5 },
	'afassistlamp' => { 300 => 0x31 },
	'afbuttonpressed' => { 381 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 311 => 0x6 },
	'afduringliveview' => { 78 => 0x511 },
	'affinea' => { 438 => 'AffineA' },
	'affineb' => { 438 => 'AffineB' },
	'affinec' => { 438 => 'AffineC' },
	'affined' => { 438 => 'AffineD' },
	'affinetune' => { 184 => 0x0, 277 => 0x306 },
	'affinetuneadj' => { 184 => 0x2, 224 => 0x2d1, 225 => 0x2dc, 277 => 0x307 },
	'affinetuneindex' => { 184 => 0x1 },
	'affinex' => { 438 => 'AffineX' },
	'affiney' => { 438 => 'AffineY' },
	'afhold' => { 311 => 0x1fd },
	'afilluminator' => { 379 => 0x29, 391 => 0xb044 },
	'afimageheight' => { 183 => [0x12,0x48] },
	'afimagewidth' => { 183 => [0x10,0x46] },
	'afintegrationtime' => { 311 => 0x7 },
	'afmicroadj' => { 372 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 376 => 0x131 },
	'afmicroadjregisteredlenses' => { 376 => '305.1' },
	'afmicroadjustment' => { 78 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 376 => 0x130 },
	'afmode' => { 107 => 0x3009, 121 => 0x1022, 170 => 0x16, 371 => 0x5 },
	'afmoderestrictions' => { 261 => '50.3', 263 => '48.3', 264 => '48.3', 273 => '48.3', 274 => '48.3' },
	'afonaelockbuttonswitch' => { 78 => 0x702 },
	'afonbutton' => { 260 => '3.1', 261 => '47.1' },
	'afpoint' => { 33 => 0x13, 106 => 0x18, 170 => 0x15, 182 => 0x1, 280 => 0x308, 371 => 0x1f, 372 => [0x37,0x7], 376 => 0x19, 377 => 0x18, 378 => [0x18,0x20] },
	'afpointactivationarea' => { 77 => 0x11, 83 => 0x11 },
	'afpointareaexpansion' => { 78 => 0x508 },
	'afpointatshutterrelease' => { 372 => [0x39,0x9] },
	'afpointautoselection' => { 78 => 0x50b },
	'afpointbrightness' => { 78 => 0x50d, 260 => '2.4', 261 => '46.5', 263 => '2.2', 264 => '2.2', 273 => '2.3', 274 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 78 => 0x50c },
	'afpointillumination' => { 77 => 0xa, 260 => '2.3', 261 => '46.2', 263 => '47.2', 264 => '47.2', 268 => '1.2', 269 => '2.3', 270 => '1.2', 273 => '47.2', 274 => '47.2', 275 => '2.4' },
	'afpointinfocus' => { 372 => [0x38,0x8] },
	'afpointmode' => { 316 => 0x3 },
	'afpointposition' => { 107 => 0x2021, 300 => 0x4d },
	'afpointregistration' => { 76 => 0x7 },
	'afpoints' => { 173 => 0x10 },
	'afpointselected' => { 174 => 0xd, 277 => 0x305, 335 => 0xe, 376 => 0x15, 377 => 0x14, 378 => [0x14,0x1c], 391 => 0x201e },
	'afpointselected2' => { 316 => 0x4 },
	'afpointselection' => { 77 => 0xb, 260 => '1.3', 261 => '1.3', 269 => '1.3', 273 => '1.3', 274 => '1.3' },
	'afpointselectionmethod' => { 78 => 0x50f, 79 => 0xc, 80 => 0xd, 83 => 0xd },
	'afpointsetting' => { 379 => 0x12, 380 => 0x11 },
	'afpointsinfocus' => { 72 => 0xe, 182 => 0x2, 311 => 0xb, 312 => 0x4, 335 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 77 => 0xd },
	'afpointsselected' => { 312 => '4.1', 422 => 0x4 },
	'afpointsspecial' => { 312 => '4.2' },
	'afpointsunknown1' => { 311 => 0x0 },
	'afpointsunknown2' => { 311 => 0x2 },
	'afpointsused' => { 183 => 0x8, 372 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 311 => 0x4 },
	'afresponse' => { 214 => 0xad },
	'afresult' => { 282 => 0x1038 },
	'afsearch' => { 277 => 0x303 },
	'afsensoractive' => { 170 => 0x1 },
	'afstatus' => { 361 => 0x1200 },
	'afstatus_00_b4' => { 375 => 0x0 },
	'afstatus_01_c4' => { 375 => 0x2 },
	'afstatus_02_d4' => { 375 => 0x4 },
	'afstatus_03_e4' => { 375 => 0x6 },
	'afstatus_04_f4' => { 375 => 0x8 },
	'afstatus_05_g4' => { 375 => 0xa },
	'afstatus_06_h4' => { 375 => 0xc },
	'afstatus_07_b3' => { 375 => 0xe },
	'afstatus_08_c3' => { 375 => 0x10 },
	'afstatus_09_d3' => { 375 => 0x12 },
	'afstatus_10_e3' => { 375 => 0x14 },
	'afstatus_11_f3' => { 375 => 0x16 },
	'afstatus_12_g3' => { 375 => 0x18 },
	'afstatus_13_h3' => { 375 => 0x1a },
	'afstatus_14_b2' => { 375 => 0x1c },
	'afstatus_15_c2' => { 375 => 0x1e },
	'afstatus_16_d2' => { 375 => 0x20 },
	'afstatus_17_e2' => { 375 => 0x22 },
	'afstatus_18_f2' => { 375 => 0x24 },
	'afstatus_19_g2' => { 375 => 0x26 },
	'afstatus_20_h2' => { 375 => 0x28 },
	'afstatus_21_c1' => { 375 => 0x2a },
	'afstatus_22_d1' => { 375 => 0x2c },
	'afstatus_23_e1' => { 375 => 0x2e },
	'afstatus_24_f1' => { 375 => 0x30 },
	'afstatus_25_g1' => { 375 => 0x32 },
	'afstatus_26_a7_vertical' => { 375 => 0x34 },
	'afstatus_27_a6_vertical' => { 375 => 0x36 },
	'afstatus_28_a5_vertical' => { 375 => 0x38 },
	'afstatus_29_c7_vertical' => { 375 => 0x3a },
	'afstatus_30_c6_vertical' => { 375 => 0x3c },
	'afstatus_31_c5_vertical' => { 375 => 0x3e },
	'afstatus_32_e7_vertical' => { 375 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 375 => 0x42 },
	'afstatus_34_e5_vertical' => { 375 => 0x44 },
	'afstatus_35_g7_vertical' => { 375 => 0x46 },
	'afstatus_36_g6_vertical' => { 375 => 0x48 },
	'afstatus_37_g5_vertical' => { 375 => 0x4a },
	'afstatus_38_i7_vertical' => { 375 => 0x4c },
	'afstatus_39_i6_vertical' => { 375 => 0x4e },
	'afstatus_40_i5_vertical' => { 375 => 0x50 },
	'afstatus_41_a7' => { 375 => 0x52 },
	'afstatus_42_b7' => { 375 => 0x54 },
	'afstatus_43_c7' => { 375 => 0x56 },
	'afstatus_44_d7' => { 375 => 0x58 },
	'afstatus_45_e7' => { 375 => 0x5a },
	'afstatus_46_f7' => { 375 => 0x5c },
	'afstatus_47_g7' => { 375 => 0x5e },
	'afstatus_48_h7' => { 375 => 0x60 },
	'afstatus_49_i7' => { 375 => 0x62 },
	'afstatus_50_a6' => { 375 => 0x64 },
	'afstatus_51_b6' => { 375 => 0x66 },
	'afstatus_52_c6' => { 375 => 0x68 },
	'afstatus_53_d6' => { 375 => 0x6a },
	'afstatus_54_e6_center' => { 375 => 0x6c },
	'afstatus_55_f6' => { 375 => 0x6e },
	'afstatus_56_g6' => { 375 => 0x70 },
	'afstatus_57_h6' => { 375 => 0x72 },
	'afstatus_58_i6' => { 375 => 0x74 },
	'afstatus_59_a5' => { 375 => 0x76 },
	'afstatus_60_b5' => { 375 => 0x78 },
	'afstatus_61_c5' => { 375 => 0x7a },
	'afstatus_62_d5' => { 375 => 0x7c },
	'afstatus_63_e5' => { 375 => 0x7e },
	'afstatus_64_f5' => { 375 => 0x80 },
	'afstatus_65_g5' => { 375 => 0x82 },
	'afstatus_66_h5' => { 375 => 0x84 },
	'afstatus_67_i5' => { 375 => 0x86 },
	'afstatus_68_c11' => { 375 => 0x88 },
	'afstatus_69_d11' => { 375 => 0x8a },
	'afstatus_70_e11' => { 375 => 0x8c },
	'afstatus_71_f11' => { 375 => 0x8e },
	'afstatus_72_g11' => { 375 => 0x90 },
	'afstatus_73_b10' => { 375 => 0x92 },
	'afstatus_74_c10' => { 375 => 0x94 },
	'afstatus_75_d10' => { 375 => 0x96 },
	'afstatus_76_e10' => { 375 => 0x98 },
	'afstatus_77_f10' => { 375 => 0x9a },
	'afstatus_78_g10' => { 375 => 0x9c },
	'afstatus_79_h10' => { 375 => 0x9e },
	'afstatus_80_b9' => { 375 => 0xa0 },
	'afstatus_81_c9' => { 375 => 0xa2 },
	'afstatus_82_d9' => { 375 => 0xa4 },
	'afstatus_83_e9' => { 375 => 0xa6 },
	'afstatus_84_f9' => { 375 => 0xa8 },
	'afstatus_85_g9' => { 375 => 0xaa },
	'afstatus_86_h9' => { 375 => 0xac },
	'afstatus_87_b8' => { 375 => 0xae },
	'afstatus_88_c8' => { 375 => 0xb0 },
	'afstatus_89_d8' => { 375 => 0xb2 },
	'afstatus_90_e8' => { 375 => 0xb4 },
	'afstatus_91_f8' => { 375 => 0xb6 },
	'afstatus_92_g8' => { 375 => 0xb8 },
	'afstatus_93_h8' => { 375 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 375 => 0xbc },
	'afstatusactivesensor' => { 170 => 0x2, 372 => [0x4,0x3b], 376 => 0x1e, 377 => 0x1b, 378 => [0x1b,0x21] },
	'afstatusbottom' => { 170 => 0x8, 376 => 0x2a, 377 => 0x21, 378 => 0x21 },
	'afstatusbottom-left' => { 170 => 0x12, 377 => 0x2b, 378 => 0x2b },
	'afstatusbottom-right' => { 170 => 0x6, 377 => 0x1f, 378 => 0x1f },
	'afstatusbottomassist-left' => { 376 => 0x28 },
	'afstatusbottomassist-right' => { 376 => 0x2c },
	'afstatusbottomhorizontal' => { 373 => 0x10, 374 => 0x1c },
	'afstatusbottomvertical' => { 373 => 0x16, 374 => 0x26 },
	'afstatuscenter-10' => { 376 => 0x34 },
	'afstatuscenter-11' => { 376 => 0x36 },
	'afstatuscenter-12' => { 376 => 0x38 },
	'afstatuscenter-14' => { 376 => 0x3c },
	'afstatuscenter-7' => { 376 => 0x2e },
	'afstatuscenter-9' => { 376 => 0x32 },
	'afstatuscenter-horizontal' => { 376 => 0x30 },
	'afstatuscenter-vertical' => { 376 => 0x3a },
	'afstatuscenterf2-8' => { 376 => 0x4c },
	'afstatuscenterhorizontal' => { 170 => 0x2f, 373 => 0xc, 374 => 0x18, 377 => 0x2f, 378 => 0x2f },
	'afstatuscentervertical' => { 170 => 0xc, 373 => 0x14, 374 => 0x22, 377 => 0x25, 378 => 0x25 },
	'afstatusfarleft' => { 373 => 0x6, 376 => 0x26 },
	'afstatusfarlefthorizontal' => { 374 => 0x4 },
	'afstatusfarleftvertical' => { 374 => 0x12 },
	'afstatusfarright' => { 373 => 0x18, 376 => 0x44 },
	'afstatusfarrighthorizontal' => { 374 => 0x2c },
	'afstatusfarrightvertical' => { 374 => 0x34 },
	'afstatusleft' => { 170 => 0x2d, 373 => 0x2, 376 => 0x22, 377 => 0x2d, 378 => 0x2d },
	'afstatuslefthorizontal' => { 374 => 0x6 },
	'afstatusleftvertical' => { 374 => 0xe },
	'afstatuslower-left' => { 373 => 0x4, 376 => 0x24 },
	'afstatuslower-lefthorizontal' => { 374 => 0xa },
	'afstatuslower-leftvertical' => { 374 => 0x10 },
	'afstatuslower-middle' => { 373 => 0x22, 374 => 0x24 },
	'afstatuslower-right' => { 373 => 0x1e, 376 => 0x4a },
	'afstatuslower-righthorizontal' => { 374 => 0x32 },
	'afstatuslower-rightvertical' => { 374 => 0x3a },
	'afstatuslowerfarleft' => { 374 => 0x8 },
	'afstatuslowerfarright' => { 374 => 0x30 },
	'afstatusmiddlehorizontal' => { 170 => 0xa, 377 => 0x23, 378 => 0x23 },
	'afstatusnearleft' => { 373 => 0xe, 374 => 0x1a },
	'afstatusnearright' => { 373 => 0xa, 374 => 0x16 },
	'afstatusright' => { 170 => 0x31, 373 => 0x1c, 376 => 0x48, 377 => 0x31, 378 => 0x31 },
	'afstatusrighthorizontal' => { 374 => 0x2e },
	'afstatusrightvertical' => { 374 => 0x38 },
	'afstatustop' => { 170 => 0xe, 376 => 0x40, 377 => 0x27, 378 => 0x27 },
	'afstatustop-left' => { 170 => 0x10, 377 => 0x29, 378 => 0x29 },
	'afstatustop-right' => { 170 => 0x4, 377 => 0x1d, 378 => 0x1d },
	'afstatustopassist-left' => { 376 => 0x3e },
	'afstatustopassist-right' => { 376 => 0x42 },
	'afstatustophorizontal' => { 373 => 0x8, 374 => 0x14 },
	'afstatustopvertical' => { 373 => 0x12, 374 => 0x1e },
	'afstatusupper-left' => { 373 => 0x0, 376 => 0x20 },
	'afstatusupper-lefthorizontal' => { 374 => 0x2 },
	'afstatusupper-leftvertical' => { 374 => 0xc },
	'afstatusupper-middle' => { 373 => 0x20, 374 => 0x20 },
	'afstatusupper-right' => { 373 => 0x1a, 376 => 0x46 },
	'afstatusupper-righthorizontal' => { 374 => 0x2a },
	'afstatusupper-rightvertical' => { 374 => 0x36 },
	'afstatusupperfarleft' => { 374 => 0x0 },
	'afstatusupperfarright' => { 374 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 391 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 372 => 0x2 },
	'afwithshutter' => { 379 => 0x2a },
	'aggregateissuenumber' => { 459 => 'aggregateIssueNumber' },
	'aggregationtype' => { 459 => 'aggregationType' },
	'agreement' => { 462 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 131 => 0xe4e },
	'aiservocontinuousshooting' => { 77 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 78 => 0x519 },
	'aiservoimagepriority' => { 78 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 78 => 0x51a },
	'aiservotrackingmethod' => { 78 => 0x504 },
	'aiservotrackingsensitivity' => { 77 => 0x14, 78 => 0x502 },
	'album' => { 469 => 'album' },
	'alreadyapplied' => { 445 => 'AlreadyApplied' },
	'alternatetitle' => { 459 => 'alternateTitle' },
	'alternatetitlea-lang' => { 459 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 459 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 459 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 185 => 0x6 },
	'alttapename' => { 469 => 'altTapeName' },
	'alttimecode' => { 469 => 'altTimecode' },
	'alttimecodetimeformat' => { 469 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 469 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 469 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 113 => 0x9400, 356 => 0x14, 357 => 0x46, 414 => 0x4, 450 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 356 => 0x13, 357 => 0x44 },
	'analogbalance' => { 113 => 0xc627 },
	'analogcaptureiso' => { 131 => 0x89e },
	'analogisotable' => { 131 => 0x89d },
	'angleadj' => { 97 => 0x10003, 103 => 0x8b },
	'angleinforoll' => { 440 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 440 => 'AngleInfoYaw' },
	'anti-blur' => { 391 => 0xb04b },
	'antialiasstrength' => { 113 => 0xc632 },
	'aperturelock' => { 261 => '38.2', 263 => '38.2', 264 => '38.2', 273 => '38.2', 274 => '38.2' },
	'aperturerange' => { 78 => 0x10d },
	'apertureringuse' => { 316 => '1.4' },
	'aperturesetting' => { 174 => 0x7, 379 => 0x30, 380 => 0x29, 381 => 0x1 },
	'aperturevalue' => { 87 => 0x2, 113 => 0x9202, 282 => 0x1002, 344 => 0x401, 449 => 'ApertureValue' },
	'applekeywords' => { 286 => 'AAPL:Keywords' },
	'applicationkeystring' => { 131 => 0x400 },
	'applicationnotes' => { 113 => 0x2bc, 305 => 0x2bc },
	'applicationrecordversion' => { 125 => 0x0 },
	'applyshootingmeteringmode' => { 78 => 0x10e },
	'approved' => { 451 => 'Approved' },
	'approvedby' => { 451 => 'ApprovedBy' },
	'approximatefnumber' => { 295 => 0x313, 302 => 0x3406 },
	'approximatefocusdistance' => { 441 => 'ApproximateFocusDistance' },
	'appversion' => { 453 => 'AppVersion' },
	'aquahsl' => { 97 => 0x20914 },
	'armidentifier' => { 126 => 0x78 },
	'armversion' => { 126 => 0x7a },
	'artfilter' => { 277 => 0x529 },
	'artfiltereffect' => { 277 => 0x52f },
	'artist' => { 113 => 0x13b, 290 => 'Artist', 335 => 0x22e, 465 => 'Artist', 469 => 'artist' },
	'artmode' => { 107 => 0x301b },
	'artmodeparameters' => { 107 => 0x310b },
	'artworkcircadatecreated' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 455 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 455 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 281 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 281 => 0x1112, 335 => 0x80, 379 => 0x55, 380 => 0x55, 381 => 0xa },
	'assetid' => { 434 => 'AssetID' },
	'asshoticcprofile' => { 113 => 0xc68f },
	'asshotneutral' => { 113 => 0xc628 },
	'asshotpreprofilematrix' => { 113 => 0xc690 },
	'asshotprofilename' => { 113 => 0xc6f6 },
	'asshotwhitexy' => { 113 => 0xc629 },
	'assignbktbutton' => { 260 => '4.2', 261 => '16.1', 263 => '16.1', 264 => '16.1', 273 => '16.1', 274 => '16.1' },
	'assignfuncbutton' => { 78 => 0x70b },
	'assignmb-d17af-onbutton' => { 264 => '79.1' },
	'assignmb-d17funcbutton' => { 264 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 264 => '68.1' },
	'assignmb-d18af-onbutton' => { 274 => '79.1' },
	'assignmb-d18funcbutton' => { 274 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 274 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 263 => '75.1', 264 => '75.1', 274 => '75.1' },
	'assignmoviefunc2button' => { 263 => '82.1', 264 => '82.1', 274 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 263 => '75.2', 264 => '75.2', 274 => '75.2' },
	'assignmovierecordbutton' => { 261 => '43.2', 273 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 263 => '45.1', 264 => '45.1', 274 => '45.1' },
	'assignmoviesubselector' => { 263 => '74.1', 264 => '74.1', 274 => '74.1' },
	'assignmoviesubselectorplusdials' => { 263 => '76.1', 264 => '76.1', 274 => '76.1' },
	'assignremotefnbutton' => { 261 => '54.1', 273 => '51.1' },
	'assistbuttonfunction' => { 76 => 0xd },
	'atcaptureusercrop' => { 131 => 0x943 },
	'attributionname' => { 442 => 'attributionName' },
	'attributionurl' => { 442 => 'attributionURL' },
	'audio' => { 300 => 0x20 },
	'audiobitrate' => { 63 => 0x6c, 455 => 'audioBitRate' },
	'audiobitratemode' => { 455 => 'audioBitRateMode' },
	'audiobitspersample' => { 455 => 'audioBitsPerSample' },
	'audiochannelcount' => { 455 => 'audioChannelCount' },
	'audiochannels' => { 63 => 0x70 },
	'audiochanneltype' => { 469 => 'audioChannelType' },
	'audiocompression' => { 146 => 'Compression' },
	'audiocompressor' => { 469 => 'audioCompressor' },
	'audiodata' => { 428 => 'Data' },
	'audioduration' => { 125 => 0x99 },
	'audiomimetype' => { 428 => 'Mime' },
	'audiomoddate' => { 469 => 'audioModDate' },
	'audiooutcue' => { 125 => 0x9a },
	'audiosamplerate' => { 63 => 0x6e, 469 => 'audioSampleRate' },
	'audiosampletype' => { 469 => 'audioSampleType' },
	'audiosamplingrate' => { 125 => 0x97 },
	'audiosamplingresolution' => { 125 => 0x98 },
	'audiotype' => { 125 => 0x96 },
	'author' => { 148 => 'Author', 286 => 'Author', 290 => 'Author', 351 => 'Author', 439 => 'author', 456 => 'Author', 467 => 'Author' },
	'authorsposition' => { 457 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 78 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 326 => '0.1' },
	'autobracket' => { 371 => 0x19 },
	'autobracketing' => { 121 => 0x1100, 335 => 0x18, 361 => 0x1007 },
	'autobracketingmode' => { 272 => '12.3' },
	'autobracketingset' => { 272 => '12.1' },
	'autobracketmodem' => { 260 => '21.2', 261 => '13.3', 263 => '13.2', 264 => '13.2', 269 => '26.2', 273 => '13.3', 274 => '13.2' },
	'autobracketorder' => { 174 => 0x43, 260 => '21.3', 261 => '13.2', 263 => '13.1', 264 => '13.1', 269 => '26.3', 270 => '12.2', 271 => '2.2', 272 => '12.2', 273 => '13.2', 274 => '13.1', 275 => '13.2' },
	'autobracketset' => { 260 => '21.1', 261 => '13.1', 265 => '11.1', 266 => '12.1', 267 => '12.1', 269 => '26.1', 270 => '12.1', 271 => '2.1', 273 => '13.1', 275 => '13.1' },
	'autobrightness' => { 445 => 'AutoBrightness' },
	'autocontrast' => { 445 => 'AutoContrast' },
	'autodistortioncontrol' => { 195 => 0x4 },
	'autodynamicrange' => { 121 => 0x140b },
	'autoexposure' => { 445 => 'AutoExposure' },
	'autoexposurebracketing' => { 72 => 0x10 },
	'autoflashisosensitivity' => { 263 => '38.5', 264 => '38.5', 274 => '38.5' },
	'autofocus' => { 280 => 0x209 },
	'autofp' => { 271 => '7.3', 275 => '31.4' },
	'autoiso' => { 72 => 0x1, 107 => 0x3008, 262 => '1.1', 271 => '1.1' },
	'autoisomax' => { 262 => '1.2', 271 => '1.2' },
	'autoisominshutterspeed' => { 262 => '1.3', 271 => '1.3' },
	'autolateralca' => { 445 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 59 => 0x2, 78 => 0x204, 97 => 0x20500, 103 => 0x6f },
	'autolightingoptimizeron' => { 97 => '0x20500.0', 103 => 0x6e },
	'autoportraitframed' => { 391 => 0x2016 },
	'autoredeye' => { 253 => 0xfe28a44f },
	'autorotate' => { 72 => 0x1b },
	'autoshadows' => { 445 => 'AutoShadows' },
	'autowhiteversion' => { 445 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 214 => 0x82 },
	'avaperturesetting' => { 316 => 0x13 },
	'averageblacklevel' => { 42 => 0xe7, 44 => 0xfb, 45 => 0x114, 46 => 0x146 },
	'averagelv' => { 177 => 0x38 },
	'avsettingwithoutlens' => { 78 => 0x707 },
	'azimuth' => { 156 => 'Azimuth' },
	'babyage' => { 300 => [0x8010,0x33] },
	'babyname' => { 300 => 0x66 },
	'backgroundalpha' => { 464 => 'bgalpha' },
	'baseexposurecompensation' => { 316 => 0x15 },
	'baseiso' => { 72 => 0x2, 91 => 0x101c, 131 => 0x903, 302 => 0x312a, 420 => 0x6 },
	'baseisodaylight' => { 131 => 0x910 },
	'baseisoflash' => { 131 => 0x913 },
	'baseisofluorescent' => { 131 => 0x912 },
	'baseisotungsten' => { 131 => 0x911 },
	'baselineexposure' => { 113 => 0xc62a },
	'baselineexposureoffset' => { 113 => 0xc7a5 },
	'baselinenoise' => { 113 => 0xc62b },
	'baselinesharpness' => { 113 => 0xc62c },
	'baseurl' => { 467 => 'BaseURL' },
	'batterylevel' => { 379 => 0x51, 383 => 0xc, 384 => 0x4, 385 => 0x4, 421 => 0x7 },
	'batterylevelgrip1' => { 421 => 0x6 },
	'batterylevelgrip2' => { 421 => 0x8 },
	'batteryorder' => { 260 => '12.5', 269 => '13.2', 270 => '2.1', 273 => '3.1' },
	'batterystate' => { 174 => 0x60, 379 => 0x50, 385 => 0x14 },
	'batterytemperature' => { 383 => 0x1, 385 => 0x2, 421 => 0x5 },
	'batterytype' => { 60 => 0x38 },
	'batteryunknown' => { 383 => 0x2, 385 => 0x0 },
	'batteryvoltage' => { 131 => 0x408, 356 => 0x2a, 357 => 0x49, 383 => 0x8 },
	'batteryvoltage1' => { 385 => 0x6 },
	'batteryvoltage2' => { 385 => 0x8 },
	'bayergreensplit' => { 113 => 0xc62d },
	'bayerpattern' => { 130 => 0xf902, 178 => 0x17 },
	'beatspliceparams' => { 469 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 469 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 469 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 469 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 469 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 469 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 260 => '13.1', 261 => '5.4', 262 => '0.1', 265 => '2.1', 266 => '3.1', 267 => '3.1', 269 => '10.1', 271 => '0.1', 273 => '5.5', 275 => '4.1' },
	'beeppitch' => { 270 => '3.1' },
	'beepvolume' => { 270 => '4.5' },
	'bestqualityscale' => { 113 => 0xc65c },
	'bestshotmode' => { 107 => 0x3007 },
	'bitdepth' => { 153 => 'BitDepth', 178 => 0x11, 221 => 0x41 },
	'bitspercomponent' => { 127 => 0x87 },
	'bitspersample' => { 113 => 0x102, 305 => 0xa, 465 => 'BitsPerSample' },
	'blackacquirerows' => { 131 => 0x18ba },
	'blacklevel' => { 113 => 0xc61a, 193 => 0x20, 214 => 0x3d, 282 => [0x401,0x1012], 344 => 0x21d },
	'blacklevel2' => { 281 => 0x600, 285 => 0x600 },
	'blacklevelblue' => { 305 => 0x1e },
	'blacklevelbottom' => { 131 => 0x3f0 },
	'blackleveldata' => { 344 => 0x223 },
	'blackleveldeltah' => { 113 => 0xc61b },
	'blackleveldeltav' => { 113 => 0xc61c },
	'blacklevelgreen' => { 305 => 0x1d },
	'blacklevelred' => { 305 => 0x1c },
	'blacklevelrepeatdim' => { 113 => 0xc619 },
	'blacklevelrough' => { 131 => 0x40e },
	'blacklevelroughafter' => { 131 => 0x416 },
	'blackleveltop' => { 131 => 0x3ef },
	'blackpoint' => { 335 => 0x200 },
	'blacks2012' => { 445 => 'Blacks2012' },
	'blacksadj' => { 424 => 0x9018 },
	'bleachbypasstoning' => { 335 => 0x7f },
	'blockshotafresponse' => { 263 => '1.5', 264 => '1.5', 274 => '1.5' },
	'blogtitle' => { 459 => 'blogTitle' },
	'blogurl' => { 459 => 'blogURL' },
	'bluebalance' => { 282 => 0x1018, 305 => 0x12, 335 => 0x1b },
	'bluecurvelimits' => { 102 => 0x1fe },
	'bluecurvepoints' => { 101 => 0x79, 102 => 0x1d4 },
	'bluehsl' => { 97 => 0x20915 },
	'bluehue' => { 445 => 'BlueHue' },
	'bluesaturation' => { 445 => 'BlueSaturation' },
	'bluratinfinity' => { 430 => 'BlurAtInfinity' },
	'blurcontrol' => { 335 => 0x82 },
	'blurwarning' => { 121 => 0x1300 },
	'bodybatteryadload' => { 314 => 0x3 },
	'bodybatteryadnoload' => { 314 => 0x2 },
	'bodybatterystate' => { 314 => '1.1' },
	'bodybatteryvoltage1' => { 314 => 0x2 },
	'bodybatteryvoltage2' => { 314 => 0x4 },
	'bodybatteryvoltage3' => { 314 => 0x6 },
	'bodybatteryvoltage4' => { 314 => 0x8 },
	'bodyfirmware' => { 362 => 0x0 },
	'bodyfirmwareversion' => { 278 => 0x104, 279 => 0x100, 282 => 0x104 },
	'bodyserialnumber' => { 362 => 0x10 },
	'bookedition' => { 459 => 'bookEdition' },
	'bootloaderversion' => { 357 => 0x26 },
	'bracketmode' => { 54 => 0x3 },
	'bracketsequence' => { 107 => 0x301d },
	'bracketsettings' => { 300 => 0x45 },
	'bracketshotnumber' => { 54 => 0x5, 316 => 0x9, 390 => 0x2b },
	'bracketshotnumber2' => { 390 => 0x2d },
	'bracketstep' => { 171 => 0xe },
	'bracketvalue' => { 54 => 0x4 },
	'brightness' => { 113 => 0xfe53, 147 => 'Brightness', 167 => 'Brightness', 171 => 0x2c, 216 => 0x34, 217 => 0x39, 356 => 0x25, 379 => 0x22, 391 => 0x2007, 445 => 'Brightness' },
	'brightnessadj' => { 102 => 0x114, 246 => 0x0, 256 => 0x2d, 424 => 0x8018 },
	'brightnessvalue' => { 113 => 0x9203, 177 => [0x691,0x49c3], 282 => 0x1003, 396 => 0x1e, 399 => 0x1140, 400 => 0x1140, 401 => 0x111c, 402 => 0x1198, 403 => 0x1174, 404 => 0x102c, 405 => 0x224, 406 => 0x224, 407 => 0x219, 449 => 'BrightnessValue' },
	'bulbduration' => { 72 => 0x18 },
	'burstcount' => { 131 => 0x40d },
	'burstmode' => { 133 => 0xa, 300 => 0x2a },
	'burstmode2' => { 133 => 0x18 },
	'burstshot' => { 371 => 0x34 },
	'burstspeed' => { 300 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 78 => 0x70a },
	'bwadjustment' => { 121 => 0x1049 },
	'bwfilter' => { 171 => 0x2a, 179 => 0x39 },
	'bwmode' => { 282 => 0x203 },
	'by-line' => { 125 => 0x50 },
	'by-linetitle' => { 125 => 0x55 },
	'bytecount' => { 459 => 'byteCount' },
	'c14configuration' => { 131 => 0x1964 },
	'cacheversion' => { 113 => 0xc7aa },
	'calibration' => { 371 => [0x24,0x30] },
	'calibrationhistory' => { 131 => 0x9c9 },
	'calibrationilluminant1' => { 113 => 0xc65a },
	'calibrationilluminant2' => { 113 => 0xc65b },
	'calibrationversion' => { 131 => 0x9c6 },
	'callforimage' => { 434 => 'CallForImage' },
	'cameraangle' => { 469 => 'cameraAngle' },
	'cameracalibration1' => { 113 => 0xc623 },
	'cameracalibration2' => { 113 => 0xc624 },
	'cameracalibrationsig' => { 113 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 36 => 0x0 },
	'cameracolorcalibration02' => { 35 => 0x4, 36 => 0x5 },
	'cameracolorcalibration03' => { 35 => 0x8, 36 => 0xa },
	'cameracolorcalibration04' => { 35 => 0xc, 36 => 0xf },
	'cameracolorcalibration05' => { 35 => 0x10, 36 => 0x14 },
	'cameracolorcalibration06' => { 35 => 0x14, 36 => 0x19 },
	'cameracolorcalibration07' => { 35 => 0x18, 36 => 0x1e },
	'cameracolorcalibration08' => { 35 => 0x1c, 36 => 0x23 },
	'cameracolorcalibration09' => { 35 => 0x20, 36 => 0x28 },
	'cameracolorcalibration10' => { 35 => 0x24, 36 => 0x2d },
	'cameracolorcalibration11' => { 35 => 0x28, 36 => 0x32 },
	'cameracolorcalibration12' => { 35 => 0x2c, 36 => 0x37 },
	'cameracolorcalibration13' => { 35 => 0x30, 36 => 0x3c },
	'cameracolorcalibration14' => { 35 => 0x34, 36 => 0x41 },
	'cameracolorcalibration15' => { 35 => 0x38, 36 => 0x46 },
	'camerae-mountversion' => { 423 => 0xb },
	'cameraelevationangle' => { 113 => 0x9405, 450 => 'CameraElevationAngle' },
	'camerafilename' => { 434 => 'CameraFilename' },
	'cameraid' => { 282 => 0x209, 370 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 113 => 0xc7a1, 469 => 'cameraLabel' },
	'cameramakemodel' => { 434 => 'CameraMakeModel' },
	'cameramodel' => { 344 => 0x410, 469 => 'cameraModel' },
	'cameramodelid' => { 167 => 'CameraModelID' },
	'cameramove' => { 469 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 300 => 0x8f, 339 => 0x1, 344 => 0x100, 385 => [0x16,0x18], 411 => 0x28, 412 => 0x24, 413 => 0x29 },
	'cameraowner' => { 134 => 0xc353 },
	'cameraparameters' => { 282 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 109 => 0x9 },
	'cameraprofile' => { 445 => 'CameraProfile' },
	'cameraprofiledigest' => { 445 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 103 => 0xe1 },
	'camerarawcontrast' => { 103 => 0xe3 },
	'camerarawhighlightpoint' => { 103 => 0xe6 },
	'camerarawlinear' => { 103 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 103 => 0xe8 },
	'camerarawoutputshadowpoint' => { 103 => 0xe9 },
	'camerarawsaturation' => { 103 => 0xe2 },
	'camerarawshadowpoint' => { 103 => 0xe7 },
	'camerarawsharpness' => { 103 => 0xe5 },
	'cameraroll' => { 109 => 0xb },
	'cameraserialnumber' => { 113 => 0xc62f, 169 => 'CameraSerialNumber', 434 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 277 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 72 => 0xc, 131 => 0x406, 281 => 0x1306, 295 => 0x320, 302 => 0x3402, 335 => 0x47, 368 => 0x43, 415 => 0x5 },
	'cameratemperature4' => { 340 => 0x14 },
	'cameratemperature5' => { 340 => 0x16 },
	'cameratemperaturerangemax' => { 115 => 0x5 },
	'cameratemperaturerangemin' => { 115 => 0x6 },
	'cameratype' => { 72 => 0x1a, 282 => 0x207 },
	'cameratype2' => { 278 => 0x100 },
	'camerayaw' => { 109 => 0xa },
	'canondr4' => { 114 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 91 => 0x805 },
	'canonfilelength' => { 60 => 0xe },
	'canonfirmwareversion' => { 60 => 0x7, 91 => 0x80b },
	'canonflashinfo' => { 91 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 60 => 0x6, 91 => 0x815 },
	'canonmodelid' => { 60 => 0x10, 91 => 0x1834 },
	'canonvrd' => { 114 => 'CanonVRD' },
	'caption' => { 439 => 'caption' },
	'caption-abstract' => { 125 => 0x78 },
	'captionsauthornames' => { 448 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 448 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 457 => 'CaptionWriter' },
	'captureframerate' => { 107 => 0x4001 },
	'captureheightnormal' => { 131 => 0x1839 },
	'capturelook' => { 131 => 0xc48 },
	'capturesoftware' => { 432 => 'CaptureSoftware' },
	'capturewidthnormal' => { 131 => 0x1838 },
	'capturewidthtest' => { 131 => 0x1842 },
	'cardshutterlock' => { 174 => 0x49 },
	'casioimagesize' => { 107 => 0x9 },
	'catalogsets' => { 125 => 0xff, 427 => 'CatalogSets', 437 => 'CatalogSets' },
	'categories' => { 60 => 0x23, 439 => 'categories' },
	'category' => { 125 => 0xf, 276 => 0x30, 457 => 'Category' },
	'cbcrgain' => { 368 => 0xa036 },
	'cbcrgaindefault' => { 368 => 0xa035 },
	'cbcrmatrix' => { 368 => 0xa034 },
	'cbcrmatrixdefault' => { 368 => 0xa033 },
	'ccdboardversion' => { 295 => 0x331 },
	'ccdscanmode' => { 282 => 0x1039 },
	'ccdsensitivity' => { 243 => 0x6 },
	'ccdversion' => { 295 => 0x330 },
	'cellglobalid' => { 443 => 'cgi' },
	'celllength' => { 113 => 0x109 },
	'cellr' => { 443 => 'r' },
	'celltowerid' => { 443 => 'cellid' },
	'cellwidth' => { 113 => 0x108 },
	'centerafarea' => { 271 => '15.1' },
	'centerfocuspoint' => { 275 => '2.2' },
	'centerpixel' => { 131 => 0x40c },
	'centerweightedareasize' => { 260 => '7.1', 261 => '8.1', 263 => '8.1', 264 => '8.1', 268 => '7.1', 269 => '5.1', 270 => '7.1', 271 => '6.3', 273 => '8.1', 274 => '8.1', 275 => '8.1' },
	'certificate' => { 473 => 'Certificate' },
	'cfainterpolationalgorithm' => { 131 => 0xe60 },
	'cfainterpolationmetric' => { 131 => 0xe61 },
	'cfaoffsetcols' => { 131 => 0xc71 },
	'cfaoffsetrows' => { 131 => 0xc6f },
	'cfapattern' => { 113 => 0xa302, 305 => 0x9, 449 => 'CFAPattern' },
	'cfapattern2' => { 113 => 0x828e },
	'cfapatterncolumns' => { 449 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 449 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 449 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 113 => 0x828d },
	'cfazipperfixthreshold' => { 131 => 0xe62 },
	'channel' => { 459 => 'channel' },
	'channela-lang' => { 459 => [\'channel','channelA-lang'] },
	'channelchannel' => { 459 => [\'channel','channelChannel'] },
	'channels' => { 146 => 'Channels' },
	'channelsubchannel1' => { 459 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 459 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 459 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 459 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 97 => 0x10101, 102 => 0x26a },
	'checkmark2' => { 103 => 0x8e },
	'childfontfiles' => { 474 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 260 => '10.3', 261 => '11.2' },
	'chromablurradius' => { 113 => 0xc631 },
	'chromanoisecolorspace' => { 131 => 0xe6d },
	'chromanoiseedgemapthresh' => { 131 => 0xe6c },
	'chromanoisehighfthresh' => { 131 => 0xe6a },
	'chromanoiselowfthresh' => { 131 => 0xe6b },
	'chromaticaberration' => { 97 => 0x20703, 103 => 0x66, 368 => 0xa051 },
	'chromaticaberrationb' => { 445 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 97 => 0x20708, 103 => 0x6b },
	'chromaticaberrationcorr' => { 74 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 113 => 0x7034, 325 => 0x1, 424 => 0x900d },
	'chromaticaberrationcorrparams' => { 113 => 0x7035, 419 => 0x66a, 420 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 97 => '0x20703.0', 103 => 0x62 },
	'chromaticaberrationr' => { 445 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 97 => 0x20707, 103 => 0x6a },
	'chromaticaberrationsetting' => { 75 => 0x6 },
	'chrominancenoisereduction' => { 97 => 0x20601, 103 => 0x5e, 371 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 103 => 0x60 },
	'circadatecreated' => { 455 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 445 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 445 => 'CircularGradientBasedCorrections' },
	'city' => { 125 => 0x5a, 152 => 'City', 300 => 0x6d, 457 => 'City' },
	'city2' => { 300 => 0x80 },
	'clarity' => { 217 => 0x35, 445 => 'Clarity' },
	'clarity2012' => { 445 => 'Clarity2012' },
	'claritycontrol' => { 335 => 0x96 },
	'classifystate' => { 125 => 0xe1 },
	'clearretouch' => { 300 => 0x7c },
	'clearretouchvalue' => { 300 => 0xa3 },
	'client' => { 469 => 'client' },
	'clientname' => { 451 => 'ClientName' },
	'clmodeshootingspeed' => { 260 => '10.2', 261 => '11.3', 263 => '11.2', 264 => '11.2', 269 => '11.2', 270 => '10.2', 273 => '11.2', 274 => '11.2', 275 => '11.1' },
	'cmcontrast' => { 285 => 0x2022 },
	'cmexposurecompensation' => { 285 => 0x2000 },
	'cmhue' => { 285 => 0x2021 },
	'cmsaturation' => { 285 => 0x2020 },
	'cmsharpness' => { 285 => 0x2023 },
	'cmwhitebalance' => { 285 => 0x2001 },
	'cmwhitebalancecomp' => { 285 => 0x2002 },
	'cmwhitebalancegraypoint' => { 285 => 0x2010 },
	'codec' => { 160 => 'Codec' },
	'codedcharacterset' => { 126 => 0x5a },
	'collection' => { 290 => 'Collection' },
	'collectionname' => { 161 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 161 => 'Collections', 439 => 'collections' },
	'collectionuri' => { 161 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 458 => 'color' },
	'coloraberrationcontrol' => { 253 => 0xc89224b },
	'coloradjustment' => { 371 => 0x14 },
	'coloradjustmentmode' => { 370 => 0x210 },
	'coloranta' => { 474 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 474 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 474 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 474 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 474 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 474 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 474 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 474 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 474 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 474 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 474 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 474 => 'Colorants' },
	'colorantswatchname' => { 474 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 474 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 474 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 474 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 147 => 'ColorBalance' },
	'colorbalanceadj' => { 253 => 0x76a43202 },
	'colorbalanceblue' => { 171 => 0x1e },
	'colorbalancegreen' => { 171 => 0x1d },
	'colorbalancered' => { 171 => 0x1c },
	'colorbalanceversion' => { 192 => 0x4, 193 => 0x4, 194 => 0x0 },
	'colorblur' => { 103 => 0x65 },
	'colorbluron' => { 97 => 0x20704 },
	'colorbooster' => { 253 => 0x5f0e7d23 },
	'colorboostlevel' => { 247 => 0x1 },
	'colorboosttype' => { 247 => 0x0 },
	'colorchromeeffect' => { 121 => 0x1048 },
	'colorclass' => { 346 => 0xde, 347 => 'ColorClass' },
	'colorcompensationfilter' => { 174 => [0x3a,0x5f], 176 => 0x111, 391 => 0xb022 },
	'colorcompensationfiltercustom' => { 379 => 0xd, 380 => 0xc },
	'colorcompensationfilterset' => { 379 => 0x8, 380 => 0x7, 381 => 0x18, 396 => 0xf },
	'colorcontrol' => { 282 => 0x102b },
	'colorcorrection' => { 424 => 0x8015 },
	'colorcreatoreffect' => { 277 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0 },
	'coloreffect' => { 300 => 0x28 },
	'colorfilter' => { 106 => 0x17, 107 => 0x3017, 171 => 0x29, 179 => [0x38,0x4d,0x4f], 342 => 0x17 },
	'colorgain' => { 221 => 0x51 },
	'colorhue' => { 97 => 0x20900, 214 => 0x8d },
	'colorimetricreference' => { 113 => 0xc6bf },
	'colorlabel' => { 448 => 'ColorLabel' },
	'colormatrix' => { 281 => 0x200, 282 => 0x1011, 368 => 0xa030 },
	'colormatrix1' => { 113 => 0xc621, 344 => 0x106 },
	'colormatrix2' => { 113 => 0xc622, 285 => 0x200, 344 => 0x226 },
	'colormatrixa' => { 335 => 0x203 },
	'colormatrixadobergb' => { 368 => 0xa032 },
	'colormatrixb' => { 335 => 0x204 },
	'colormatrixnumber' => { 282 => 0x1019 },
	'colormatrixsrgb' => { 368 => 0xa031 },
	'colormode' => { 107 => 0x3015, 121 => 0x1210, 133 => 0x66, 171 => 0x28, 174 => 0x16, 176 => 0x101, 177 => 0x36, 179 => 0x7, 214 => 0x3, 243 => 0x4, 300 => 0x32, 371 => 0x2c, 391 => 0xb029, 457 => 'ColorMode' },
	'colormoirereduction' => { 97 => 0x20670, 254 => 0x15 },
	'colormoirereductionmode' => { 254 => 0x5 },
	'colormoirereductionon' => { 97 => '0x20670.0' },
	'colornoisereduction' => { 424 => 0x8029, 445 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 445 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 254 => 0x18 },
	'colornoisereductionsharpness' => { 254 => 0x1c },
	'colornoisereductionsmoothness' => { 445 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 117 => 0x2 },
	'colorprofile' => { 171 => 0x33 },
	'colorprofilesettings' => { 277 => 0x539 },
	'colorrepresentation' => { 127 => 0x3c },
	'colorsaturationadj' => { 97 => 0x20305 },
	'colorsequence' => { 127 => 0x41 },
	'colorspace' => { 48 => 0x3, 60 => 0xb4, 91 => 0x10b4, 113 => 0xa001, 153 => 'ColorSpace', 172 => 0x2f, 173 => 0x25, 174 => 0x17, 214 => 0x1e, 277 => 0x507, 335 => 0x37, 368 => 0xa011, 371 => 0xb, 379 => 0x1b, 380 => 0x83, 381 => 0xe, 396 => 0x6, 449 => 'ColorSpace' },
	'colortempasshot' => { 37 => 0x4, 38 => 0x7, 39 => 0x1d, 40 => 0x26, 41 => 0x43, 44 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x4b },
	'colortempauto' => { 37 => 0x9, 38 => 0xf, 39 => 0x22, 40 => 0x1c, 41 => 0x48, 44 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x50 },
	'colortempcloudy' => { 37 => 0x22, 38 => 0x37, 39 => 0x31, 40 => 0x35, 41 => 0x5c, 44 => 0x75, 45 => 0x8e, 46 => 0x93, 47 => 0x96, 335 => 0x55 },
	'colortempcustom' => { 41 => 0x84 },
	'colortempcustom1' => { 39 => 0x45 },
	'colortempcustom2' => { 39 => 0x4a },
	'colortempdaylight' => { 37 => 0x18, 38 => 0x27, 39 => 0x27, 40 => 0x2b, 41 => 0x52, 44 => 0x6b, 45 => 0x84, 46 => 0x89, 47 => 0x8c, 335 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 60 => 0xae, 70 => 0x9, 91 => 0x10ae, 121 => 0x1005, 131 => 0x846, 147 => 'ColorTemperature', 172 => [0x6e,0x49], 173 => 0x3f, 174 => [0x39,0x5e], 176 => 0x10b, 179 => [0x3c,0x4c,0x4e], 295 => 0x321, 335 => 0x50, 361 => 0x1308, 391 => 0xb021, 445 => 'Temperature' },
	'colortemperatureadj' => { 424 => 0x8013 },
	'colortemperatureauto' => { 214 => 0x4f },
	'colortemperaturebg' => { 282 => 0x1013 },
	'colortemperaturecustom' => { 379 => 0xc, 380 => 0xb },
	'colortemperaturerg' => { 282 => 0x1014 },
	'colortemperatureset' => { 379 => 0x7, 380 => 0x6 },
	'colortemperaturesetting' => { 174 => 0x25, 381 => 0x17, 396 => 0xe },
	'colortempflash' => { 37 => 0x36, 38 => 0x57, 39 => 0x40, 40 => 0x49, 41 => 0x70, 44 => 0x89, 45 => 0xa2, 46 => 0xa7, 47 => 0xaa, 335 => 0x5a },
	'colortempflashdata' => { 41 => 0x24a },
	'colortempfluorescent' => { 37 => 0x2c, 38 => 0x47, 39 => 0x3b, 40 => 0x3f, 41 => 0x66, 44 => 0x7f, 45 => 0x98, 46 => 0x9d, 47 => 0xa0 },
	'colortempfluorescentd' => { 335 => 0x57 },
	'colortempfluorescentn' => { 335 => 0x58 },
	'colortempfluorescentw' => { 335 => 0x59 },
	'colortempkelvin' => { 37 => 0x31, 38 => 0x4f, 40 => 0x44, 41 => 0x6b, 44 => 0x84, 45 => 0x9d, 46 => 0xa2, 47 => 0xa5, 300 => 0x44, 361 => 0x1307 },
	'colortempmeasured' => { 37 => 0xe, 38 => 0x17, 41 => 0x4d, 44 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x55 },
	'colortemppc1' => { 40 => 0x94, 41 => 0x75 },
	'colortemppc2' => { 40 => 0x99, 41 => 0x7a },
	'colortemppc3' => { 40 => 0x9e, 41 => 0x7f },
	'colortempshade' => { 37 => 0x1d, 38 => 0x2f, 39 => 0x2c, 40 => 0x30, 41 => 0x57, 44 => 0x70, 45 => 0x89, 46 => 0x8e, 47 => 0x91, 335 => 0x54 },
	'colortemptungsten' => { 37 => 0x27, 38 => 0x3f, 39 => 0x36, 40 => 0x3a, 41 => 0x61, 44 => 0x7a, 45 => 0x93, 46 => 0x98, 47 => 0x9b, 335 => 0x56 },
	'colortempunknown' => { 37 => 0x13, 38 => 0x1f, 40 => 0x21, 44 => 0x52, 45 => 0x52, 46 => 0x52, 47 => 0x5a },
	'colortempunknown10' => { 37 => 0x63, 38 => 0x9f, 40 => 0x76, 44 => 0xa2, 45 => 0x7f, 46 => 0x7f, 47 => 0x87 },
	'colortempunknown11' => { 37 => 0x68, 38 => 0xa7, 40 => 0x7b, 44 => 0xa7, 45 => 0xa7, 46 => 0x84, 47 => 0xaf },
	'colortempunknown12' => { 37 => 0x6d, 38 => 0xaf, 40 => 0x80, 44 => 0xac, 45 => 0xac, 46 => 0xac, 47 => 0xb4 },
	'colortempunknown13' => { 37 => 0x72, 38 => 0xb7, 40 => 0x85, 44 => 0xb1, 45 => 0xb1, 46 => 0xb1, 47 => 0xb9 },
	'colortempunknown14' => { 40 => 0x8a, 44 => 0xb6, 45 => 0xb6, 46 => 0xb6, 47 => 0xbe },
	'colortempunknown15' => { 40 => 0x8f, 44 => 0xbb, 45 => 0xbb, 46 => 0xbb, 47 => 0xc3 },
	'colortempunknown16' => { 40 => 0xa3, 45 => 0xc0, 46 => 0xc0, 47 => 0xc8 },
	'colortempunknown17' => { 45 => 0xc5, 46 => 0xc5, 47 => 0xcd },
	'colortempunknown18' => { 45 => 0xca, 46 => 0xca, 47 => 0xd2 },
	'colortempunknown19' => { 45 => 0xcf, 46 => 0xcf, 47 => 0xd7 },
	'colortempunknown2' => { 37 => 0x3b, 38 => 0x5f, 40 => 0x4e, 44 => 0x57, 45 => 0x57, 46 => 0x57, 47 => 0x5f },
	'colortempunknown20' => { 45 => 0xd4, 46 => 0xd4, 47 => 0xdc },
	'colortempunknown21' => { 46 => 0xd9, 47 => 0xe1 },
	'colortempunknown22' => { 46 => 0xde, 47 => 0xe6 },
	'colortempunknown23' => { 46 => 0xe3, 47 => 0xeb },
	'colortempunknown24' => { 46 => 0xe8, 47 => 0xf0 },
	'colortempunknown25' => { 46 => 0xed, 47 => 0xf5 },
	'colortempunknown26' => { 46 => 0xf2, 47 => 0xfa },
	'colortempunknown27' => { 46 => 0xf7, 47 => 0xff },
	'colortempunknown28' => { 46 => 0xfc, 47 => 0x104 },
	'colortempunknown29' => { 46 => 0x101, 47 => 0x109 },
	'colortempunknown3' => { 37 => 0x40, 38 => 0x67, 40 => 0x53, 44 => 0x5c, 45 => 0x5c, 46 => 0x5c, 47 => 0x64 },
	'colortempunknown30' => { 46 => 0x106 },
	'colortempunknown4' => { 37 => 0x45, 38 => 0x6f, 40 => 0x58, 44 => 0x61, 45 => 0x61, 46 => 0x61, 47 => 0x69 },
	'colortempunknown5' => { 37 => 0x4a, 38 => 0x77, 40 => 0x5d, 44 => 0x66, 45 => 0x66, 46 => 0x66, 47 => 0x6e },
	'colortempunknown6' => { 37 => 0x4f, 38 => 0x7f, 40 => 0x62, 44 => 0x8e, 45 => 0x6b, 46 => 0x6b, 47 => 0x73 },
	'colortempunknown7' => { 37 => 0x54, 38 => 0x87, 40 => 0x67, 44 => 0x93, 45 => 0x70, 46 => 0x70, 47 => 0x78 },
	'colortempunknown8' => { 37 => 0x59, 38 => 0x8f, 40 => 0x6c, 44 => 0x98, 45 => 0x75, 46 => 0x75, 47 => 0x7d },
	'colortempunknown9' => { 37 => 0x5e, 38 => 0x97, 40 => 0x71, 44 => 0x9d, 45 => 0x7a, 46 => 0x7a, 47 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 48 => 0x2 },
	'colortoneadj' => { 97 => 0x20304, 102 => 0x11e },
	'colortoneauto' => { 67 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 66 => 0x6c, 67 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 66 => 0x3c, 67 => 0x3c },
	'colortonemonochrome' => { 66 => 0x84, 67 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 66 => 0x54, 67 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 66 => 0x24, 67 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 66 => 0xc, 67 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 66 => 0x9c, 67 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 66 => 0xb4, 67 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 66 => 0xcc, 67 => 0xe4 },
	'comlenblksize' => { 131 => 0xfde8 },
	'commanddials' => { 271 => '5.1' },
	'commanddialsaperturesetting' => { 260 => '17.3', 261 => '18.3', 263 => '18.3', 264 => '18.3', 269 => '33.3', 270 => '17.3', 273 => '18.3', 274 => '18.3' },
	'commanddialschangemainsub' => { 260 => '17.2', 261 => '18.1', 263 => '18.1', 264 => '18.1', 269 => '33.2', 270 => '17.2', 273 => '18.1', 274 => '18.1' },
	'commanddialsmenuandplayback' => { 260 => '17.4', 261 => '18.2', 263 => '18.2', 264 => '18.2', 269 => '33.4', 270 => '17.4', 273 => '18.2', 274 => '18.2' },
	'commanddialsreverserotation' => { 260 => '17.1', 261 => '6.4', 263 => '6.2', 264 => '6.2', 265 => '16.2', 266 => '17.2', 269 => '33.1', 270 => '17.1', 273 => '6.2', 274 => '6.2', 275 => '18.1' },
	'commanderchannel' => { 271 => '10.2', 272 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 271 => '13.1', 272 => '31.1' },
	'commandergroupa_ttlcomp' => { 275 => '32.1' },
	'commandergroupamanualoutput' => { 271 => '13.2', 272 => '28.2' },
	'commandergroupamode' => { 271 => '11.2', 272 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 271 => '14.1', 272 => '32.1' },
	'commandergroupb_ttlcomp' => { 275 => '33.1' },
	'commandergroupbmanualoutput' => { 271 => '14.2', 272 => '29.2' },
	'commandergroupbmode' => { 271 => '11.3', 272 => '29.1' },
	'commanderinternalflash' => { 271 => '11.1', 272 => '27.1' },
	'commanderinternalmanualoutput' => { 271 => '12.2', 272 => '27.2' },
	'commanderinternalttlchannel' => { 269 => '18.2' },
	'commanderinternalttlcomp' => { 271 => '12.1', 272 => '30.2', 275 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 269 => '20.1', 270 => '26.1' },
	'commanderinternalttlcompgroupa' => { 269 => '21.1', 270 => '27.1' },
	'commanderinternalttlcompgroupb' => { 269 => '22.1', 270 => '28.1' },
	'comment' => { 0 => 0x2, 114 => 'Comment', 148 => 'Comment', 290 => 'Comment' },
	'compass' => { 364 => 0x4 },
	'complianceprofile' => { 459 => 'complianceProfile' },
	'componentsconfiguration' => { 113 => 0x9101, 153 => 'Components', 449 => 'ComponentsConfiguration' },
	'componentversion' => { 91 => 0x80c },
	'composer' => { 469 => 'composer' },
	'composition' => { 434 => 'Composition' },
	'compositionadjust' => { 334 => '0.1' },
	'compositionadjustrotation' => { 334 => 0x7 },
	'compositionadjustx' => { 334 => 0x5 },
	'compositionadjusty' => { 334 => 0x6 },
	'compressedbitsperpixel' => { 113 => 0x9102, 449 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 176 => 0x40, 282 => 0x40 },
	'compression' => { 113 => 0x103, 305 => 0xb, 465 => 'Compression' },
	'compressionfactor' => { 277 => 0x50d },
	'compressionratio' => { 153 => 'Compression', 282 => 0x1034 },
	'condadobvfactor' => { 131 => 0xf3e },
	'condadodaybvthresh' => { 131 => 0xf3c },
	'condadodayoffsets' => { 131 => 0xf42 },
	'condadofluoffsets' => { 131 => 0xf44 },
	'condadofluthresh' => { 131 => 0xf41 },
	'condadoillfactor' => { 131 => 0xf3f },
	'condadoneurange' => { 131 => 0xf3d },
	'condadotunoffsets' => { 131 => 0xf43 },
	'condadotunthresh' => { 131 => 0xf40 },
	'confidence' => { 429 => 'Confidence' },
	'confidencelevel' => { 440 => 'ConfidenceLevel' },
	'confidencemime' => { 429 => 'ConfidenceMime' },
	'constrainedcropheight' => { 102 => 0x266, 346 => 0xd6 },
	'constrainedcropwidth' => { 102 => 0x262, 346 => 0xd5 },
	'contact' => { 125 => 0x76 },
	'contactinfo' => { 458 => 'contactInfo' },
	'containerformat' => { 455 => 'ContainerFormat' },
	'containerformatidentifier' => { 455 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 455 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 125 => 0x1a },
	'contentlocationname' => { 125 => 0x1b },
	'contenttype' => { 459 => 'contentType' },
	'continuousbracketing' => { 174 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 274 => '77.2' },
	'continuousshootingspeed' => { 78 => 0x610 },
	'continuousshotlimit' => { 78 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 106 => 0xc, 107 => [0x3012,0x20], 113 => [0xa408,0xfe54], 121 => [0x1004,0x1006], 147 => 'Contrast', 167 => 'Contrast', 171 => 0x20, 172 => 0x31, 173 => 0x27, 174 => 0x19, 179 => 0x2, 216 => 0x33, 217 => 0x37, 282 => 0x1029, 300 => 0x39, 302 => 0x300a, 335 => 0x20, 342 => 0xc, 356 => 0x24, 361 => 0x1012, 371 => 0xd, 379 => 0x1d, 380 => 0x1a, 391 => 0x2004, 445 => 'Contrast', 449 => 'Contrast' },
	'contrast2012' => { 445 => 'Contrast2012' },
	'contrastadj' => { 97 => 0x20303, 102 => 0x115, 256 => 0x2c, 424 => 0x8017 },
	'contrastauto' => { 67 => 0x90 },
	'contrastcurve' => { 214 => 0x8c },
	'contrastdetectaf' => { 183 => 0x4 },
	'contrastdetectafarea' => { 335 => 0x231 },
	'contrastdetectafinfocus' => { 183 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 66 => 0x60, 67 => 0x60 },
	'contrasthighlight' => { 335 => 0x6d },
	'contrasthighlightshadowadj' => { 335 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 66 => 0x30, 67 => 0x30 },
	'contrastmode' => { 300 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 66 => 0x78, 67 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 66 => 0x48, 67 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 66 => 0x18, 67 => 0x18 },
	'contrastsetting' => { 277 => 0x505, 285 => 0x1012, 381 => 0x10, 396 => 0x8 },
	'contrastshadow' => { 335 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 66 => 0x0, 67 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 66 => 0x90, 67 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 66 => 0xa8, 67 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 66 => 0xc0, 67 => 0xd8 },
	'contributedmedia' => { 469 => 'contributedMedia' },
	'contributedmediaduration' => { 469 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 469 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 469 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 469 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 469 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 469 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 469 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 469 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 469 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 469 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 446 => 'contributor', 455 => 'Contributor' },
	'contributoridentifier' => { 455 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 455 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 455 => [\'Contributor','ContributorRole'] },
	'contributors' => { 148 => 'Contributors' },
	'controldialset' => { 174 => 0x46 },
	'controlledvocabularyterm' => { 455 => 'CVterm' },
	'controllerboardversion' => { 295 => 0x332 },
	'controlmode' => { 72 => 0x12 },
	'controlringrotation' => { 78 => 0x712 },
	'conversionlens' => { 278 => 0x403, 300 => 0x35 },
	'converter' => { 113 => 0xfe4d, 243 => 0xb, 445 => 'Converter' },
	'converttograyscale' => { 445 => 'ConvertToGrayscale' },
	'cookingequipment' => { 461 => 'cookingEquipment' },
	'cookingmethod' => { 461 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 113 => 0x8298, 148 => 'Copyright', 290 => 'Copyright', 335 => 0x22f, 351 => 'Copyright', 456 => 'Copyright', 462 => 'copyright', 465 => 'Copyright', 469 => 'copyright' },
	'copyrightflag' => { 349 => 0x40a },
	'copyrightnotice' => { 125 => 0x74 },
	'copyrightowner' => { 287 => 'CopyrightOwner' },
	'copyrightownerid' => { 287 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 287 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 287 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 287 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 287 => 'CopyrightStatus' },
	'copyrightyear' => { 455 => 'CopyrightYear', 459 => 'copyrightYear' },
	'coringfilter' => { 281 => 0x310, 282 => 0x102d, 285 => 0x310 },
	'coringvalues' => { 281 => 0x311, 285 => 0x311 },
	'corporateentity' => { 459 => 'corporateEntity' },
	'country' => { 152 => 'Country', 300 => 0x69, 457 => 'Country' },
	'country-primarylocationcode' => { 125 => 0x64 },
	'country-primarylocationname' => { 125 => 0x65 },
	'countrycode' => { 213 => 0x5, 347 => 'CountryCode', 454 => 'CountryCode' },
	'course' => { 461 => 'course' },
	'coverage' => { 446 => 'coverage' },
	'coverdate' => { 459 => 'coverDate' },
	'coverdisplaydate' => { 459 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 335 => 0x28 },
	'crc32' => { 447 => 'crc32' },
	'createdate' => { 113 => 0x9004, 148 => 'CreateDate', 286 => 'CreationDate', 290 => 'create-date', 351 => 'CreationDate', 353 => 0x1, 467 => 'CreateDate' },
	'creationdate' => { 456 => 'CreationDate', 459 => 'creationDate' },
	'creationtime' => { 290 => 'Creation Time' },
	'creativestyle' => { 379 => 0x1a, 380 => 0x18, 390 => 0x41, 391 => 0xb020, 420 => 0x4a },
	'creativestylesetting' => { 381 => 0xf, 396 => 0x7 },
	'creativestylewaschanged' => { 424 => 0x8001 },
	'creator' => { 286 => 'Creator', 351 => 'Creator', 446 => 'creator', 455 => 'Creator', 456 => 'Creator' },
	'creatoraddress' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 169 => 'CreatorAppId' },
	'creatorcity' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 454 => 'CreatorContactInfo' },
	'creatorcountry' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 455 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 455 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 169 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 455 => [\'Creator','CreatorRole'] },
	'creatortool' => { 467 => 'CreatorTool' },
	'creatorworkemail' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 454 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 125 => 0x6e, 457 => 'Credit' },
	'creditline' => { 462 => 'creditLine' },
	'creditlinereq' => { 472 => 'CreditLineReq' },
	'creditlinerequired' => { 287 => 'CreditLineRequired' },
	'cropactive' => { 95 => 0x0, 102 => 0x244 },
	'cropangle' => { 445 => 'CropAngle' },
	'croparea' => { 424 => 0x9011 },
	'cropaspectratio' => { 97 => 0x30101, 102 => 0x260 },
	'cropaspectratiocustom' => { 97 => 0x30102 },
	'cropbottom' => { 117 => 0x9, 248 => 0x36, 305 => 0x31, 346 => 0xdc, 445 => 'CropBottom' },
	'cropbottommargin' => { 50 => 0x3 },
	'cropcircleactive' => { 103 => 0xd6 },
	'cropcircleradius' => { 103 => 0xd9 },
	'cropcirclex' => { 103 => 0xd7 },
	'cropcircley' => { 103 => 0xd8 },
	'cropconstraintowarp' => { 445 => 'CropConstrainToWarp' },
	'croph' => { 438 => 'CropH' },
	'cropheight' => { 95 => 0x6, 102 => 0x24c, 281 => 0x615, 285 => 0x615, 445 => 'CropHeight' },
	'crophispeed' => { 214 => 0x1b },
	'cropleft' => { 102 => 0x246, 117 => 0x6, 248 => 0x1e, 281 => 0x612, 285 => 0x612, 305 => 0x30, 346 => 0xd9, 445 => 'CropLeft' },
	'cropleftmargin' => { 50 => 0x0 },
	'cropmode' => { 121 => 0x104d },
	'cropmode35mm' => { 361 => 0x1018 },
	'croporiginalheight' => { 95 => 0xb },
	'croporiginalwidth' => { 95 => 0xa },
	'cropoutputheight' => { 248 => 0xce },
	'cropoutputheightinches' => { 248 => 0x96 },
	'cropoutputpixels' => { 248 => 0xd6 },
	'cropoutputresolution' => { 248 => 0xb6 },
	'cropoutputscale' => { 248 => 0xbe },
	'cropoutputwidth' => { 248 => 0xc6 },
	'cropoutputwidthinches' => { 248 => 0x8e },
	'croppedareaimageheightpixels' => { 432 => 'CroppedAreaImageHeightPixels', 433 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 432 => 'CroppedAreaImageWidthPixels', 433 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 432 => 'CroppedAreaLeftPixels', 433 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 432 => 'CroppedAreaTopPixels', 433 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 361 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 361 => 0x1603 },
	'cropping' => { 424 => 0x9010 },
	'cropright' => { 117 => 0x8, 248 => 0x2e, 305 => 0x32, 346 => 0xdb, 445 => 'CropRight' },
	'croprightmargin' => { 50 => 0x1 },
	'croprotatedoriginalheight' => { 95 => 0x2 },
	'croprotatedoriginalwidth' => { 95 => 0x1 },
	'croprotation' => { 95 => 0x8, 117 => 0xb },
	'cropscaledresolution' => { 248 => 0x9e },
	'cropsourceresolution' => { 248 => 0xae },
	'croptop' => { 102 => 0x248, 117 => 0x7, 248 => 0x26, 281 => 0x613, 285 => 0x613, 305 => 0x2f, 346 => 0xda, 445 => 'CropTop' },
	'croptopmargin' => { 50 => 0x2 },
	'cropunit' => { 445 => 'CropUnit' },
	'cropunits' => { 445 => 'CropUnits' },
	'cropw' => { 438 => 'CropW' },
	'cropwidth' => { 95 => 0x5, 102 => 0x24a, 281 => 0x614, 285 => 0x614, 445 => 'CropWidth' },
	'cropx' => { 95 => 0x3, 438 => 'CropX' },
	'cropy' => { 95 => 0x4, 438 => 'CropY' },
	'crossprocess' => { 335 => 0x7b },
	'crossprocessparams' => { 335 => 0x235 },
	'cuisine' => { 461 => 'cuisine' },
	'currenticcprofile' => { 113 => 0xc691 },
	'currentpreprofilematrix' => { 113 => 0xc692 },
	'currentversion' => { 424 => 0xd000 },
	'curve0x' => { 438 => 'Curve0x' },
	'curve0y' => { 438 => 'Curve0y' },
	'curve1x' => { 438 => 'Curve1x' },
	'curve1y' => { 438 => 'Curve1y' },
	'curve2x' => { 438 => 'Curve2x' },
	'curve2y' => { 438 => 'Curve2y' },
	'curve3x' => { 438 => 'Curve3x' },
	'curve3y' => { 438 => 'Curve3y' },
	'curve4x' => { 438 => 'Curve4x' },
	'curve4y' => { 438 => 'Curve4y' },
	'curves' => { 253 => 0x76a43201 },
	'custom1' => { 287 => 'Custom1' },
	'custom10' => { 287 => 'Custom10' },
	'custom2' => { 287 => 'Custom2' },
	'custom3' => { 287 => 'Custom3' },
	'custom4' => { 287 => 'Custom4' },
	'custom5' => { 287 => 'Custom5' },
	'custom6' => { 287 => 'Custom6' },
	'custom7' => { 287 => 'Custom7' },
	'custom8' => { 287 => 'Custom8' },
	'custom9' => { 287 => 'Custom9' },
	'customcolortone' => { 103 => 0x4c },
	'customcontrast' => { 103 => 0x4e },
	'customcontrols' => { 78 => 0x70c },
	'customdefaultunsharpfineness' => { 103 => 0xbe },
	'customdefaultunsharpstrength' => { 103 => 0xbc },
	'customdefaultunsharpthreshold' => { 103 => 0xc0 },
	'customilluminant' => { 131 => 0x405 },
	'customizedials' => { 78 => 0x715 },
	'customlinear' => { 103 => 0x4f },
	'customoutputhighlightpoint' => { 103 => 0x53 },
	'customoutputshadowpoint' => { 103 => 0x54 },
	'custompicturestyle' => { 97 => 0x10021 },
	'custompicturestyledata' => { 97 => 0xf0500 },
	'custompicturestylefilename' => { 60 => 0x4010 },
	'customrawhighlight' => { 103 => 0x7c },
	'customrawhighlightpoint' => { 103 => 0x51 },
	'customrawshadow' => { 103 => 0x85 },
	'customrawshadowpoint' => { 103 => 0x52 },
	'customrendered' => { 113 => 0xa401, 449 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x4d, 277 => 0x503 },
	'customsettingsalldefault' => { 260 => '0.2', 269 => '0.2' },
	'customsettingsbank' => { 260 => '0.1', 261 => '0.1', 263 => '0.1', 264 => '0.1', 269 => '0.1', 273 => '0.2', 274 => '0.2' },
	'customsharpness' => { 103 => 0x50 },
	'customunsharpmaskfineness' => { 103 => 0xb8 },
	'customunsharpmaskstrength' => { 103 => 0xb6 },
	'customunsharpmaskthreshold' => { 103 => 0xba },
	'customwb_rblevels' => { 396 => 0x1a },
	'customwb_rgblevels' => { 380 => 0x8, 381 => 0x19 },
	'customwbbluelevel' => { 174 => 0x36 },
	'customwberror' => { 174 => 0x37 },
	'customwbgreenlevel' => { 174 => 0x35 },
	'customwbredlevel' => { 174 => 0x34 },
	'customwbsetting' => { 174 => 0x26 },
	'd-lightinghq' => { 253 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 249 => 0x2 },
	'd-lightinghqhighlight' => { 249 => 0x1 },
	'd-lightinghqselected' => { 253 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 249 => 0x0 },
	'd-lightinghs' => { 253 => 0xce5554aa },
	'd-lightinghsadjustment' => { 250 => 0x0 },
	'd-lightinghscolorboost' => { 250 => 0x1 },
	'd-rangeoptimizerhighlight' => { 424 => 0x8024 },
	'd-rangeoptimizermode' => { 424 => 0x8022 },
	'd-rangeoptimizershadow' => { 424 => 0x802d },
	'd-rangeoptimizervalue' => { 424 => 0x8023 },
	'd810meteringmode' => { 240 => 0x175e },
	'darkblacksegrows' => { 131 => 0x18d8 },
	'darkfocusenvironment' => { 300 => 0x8003 },
	'darkframecountfactor' => { 131 => 0xc85 },
	'darkframelongexposure' => { 131 => 0xc84 },
	'darkframeshortexposure' => { 131 => 0xc83 },
	'darkpedestal' => { 131 => 0xc7f },
	'data' => { 429 => 'Data' },
	'datacompressionmethod' => { 127 => 0x6e },
	'dataimprint' => { 171 => 0x34 },
	'dataonscreen' => { 455 => 'DataOnScreen' },
	'dataonscreenregion' => { 455 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 455 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 455 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 455 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 455 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 455 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 455 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 455 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 335 => 0x3d },
	'date' => { 335 => 0x6, 446 => 'date' },
	'dateacquired' => { 169 => 'DateAcquired' },
	'datecreated' => { 125 => 0x37, 457 => 'DateCreated' },
	'datedisplayformat' => { 245 => 0x3 },
	'dateidentified' => { 112 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 265 => '4.2' },
	'daterecieved' => { 459 => 'dateRecieved' },
	'datesent' => { 126 => 0x46 },
	'datestampmode' => { 60 => 0x1c },
	'datetime' => { 439 => 'datetime', 465 => 'DateTime' },
	'datetimedigitized' => { 449 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 94 => 0x0, 113 => 0x9003, 145 => 0x14, 148 => 'OriginalDate', 356 => 0xb, 357 => 0x3b, 449 => 'DateTimeOriginal' },
	'datetimestamp' => { 133 => 0x64 },
	'datetimeutc' => { 277 => 0x908 },
	'daylightsavings' => { 73 => 0x3, 245 => 0x2 },
	'dayofweek' => { 357 => 0x42 },
	'dccontinent' => { 112 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 112 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 112 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 112 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 112 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 112 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 112 => 'Event' },
	'dcfootprintspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 112 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 112 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 112 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 112 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 112 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 112 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 112 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 112 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 112 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 112 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 112 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 112 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 156 => 'Declination' },
	'decposition' => { 171 => 0x32 },
	'defaultautogray' => { 445 => 'DefaultAutoGray' },
	'defaultautotone' => { 445 => 'DefaultAutoTone' },
	'defaultblackrender' => { 113 => 0xc7a6 },
	'defaultcroporigin' => { 113 => 0xc61f },
	'defaultcropsize' => { 113 => 0xc620 },
	'defaulteraseoption' => { 78 => 0x813 },
	'defaultscale' => { 113 => 0xc61e },
	'defaultsspecifictoiso' => { 445 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 445 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 113 => 0xc7b5 },
	'defectisocode' => { 131 => 0x90f },
	'defringe' => { 445 => 'Defringe' },
	'defringegreenamount' => { 445 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 445 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 445 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 445 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 445 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 445 => 'DefringePurpleHueLo' },
	'dehaze' => { 445 => 'Dehaze' },
	'deletedimagecount' => { 214 => 0xa6, 222 => 0x6e },
	'deprecatedon' => { 442 => 'deprecatedOn' },
	'derivedfrom' => { 470 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 470 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 470 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 470 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 470 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 470 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 470 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 470 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 470 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 470 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 470 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 470 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 470 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 470 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 470 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 470 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 470 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 470 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 470 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 470 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 470 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 470 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 470 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 470 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 290 => 'Description', 446 => 'description', 467 => 'Description' },
	'destination' => { 126 => 0x5 },
	'destinationcity' => { 335 => 0x24, 341 => 0x3 },
	'destinationcitycode' => { 342 => 0x1001 },
	'destinationdst' => { 335 => 0x26, 341 => '0.3' },
	'developmentdynamicrange' => { 121 => 0x1403 },
	'deviantmatrixcustom' => { 131 => 0x7de },
	'deviantmatrixdaylight' => { 131 => 0x7da },
	'deviantmatrixflash' => { 131 => 0x7dd },
	'deviantmatrixfluorescent' => { 131 => 0x7dc },
	'deviantmatrixtungsten' => { 131 => 0x7db },
	'deviantwhitecustom' => { 131 => 0x842 },
	'deviantwhitedaylight' => { 131 => 0x83e },
	'deviantwhiteflash' => { 131 => 0x841 },
	'deviantwhitefluorescent' => { 131 => 0x840 },
	'deviantwhitetungsten' => { 131 => 0x83f },
	'device' => { 459 => 'device' },
	'devicesettingdescription' => { 449 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 449 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 449 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 449 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 368 => 0x2 },
	'dialdirectiontvav' => { 78 => 0x706 },
	'dietaryneeds' => { 461 => 'dietaryNeeds' },
	'diffractioncorrection' => { 300 => 0xbc, 325 => 0x3 },
	'diffractioncorrectionon' => { 97 => 0x2070b },
	'digitalcreationdate' => { 125 => 0x3e },
	'digitalcreationtime' => { 125 => 0x3f },
	'digitaldeehighlightadj' => { 221 => 0x202 },
	'digitaldeeshadowadj' => { 221 => 0x200 },
	'digitaldeethreshold' => { 221 => 0x201 },
	'digitalfilter' => { 371 => 0x59 },
	'digitalfilter01' => { 322 => 0x5 },
	'digitalfilter02' => { 322 => 0x16 },
	'digitalfilter03' => { 322 => 0x27 },
	'digitalfilter04' => { 322 => 0x38 },
	'digitalfilter05' => { 322 => 0x49 },
	'digitalfilter06' => { 322 => 0x5a },
	'digitalfilter07' => { 322 => 0x6b },
	'digitalfilter08' => { 322 => 0x7c },
	'digitalfilter09' => { 322 => 0x8d },
	'digitalfilter10' => { 322 => 0x9e },
	'digitalfilter11' => { 322 => 0xaf },
	'digitalfilter12' => { 322 => 0xc0 },
	'digitalfilter13' => { 322 => 0xd1 },
	'digitalfilter14' => { 322 => 0xe2 },
	'digitalfilter15' => { 322 => 0xf3 },
	'digitalfilter16' => { 322 => 0x104 },
	'digitalfilter17' => { 322 => 0x115 },
	'digitalfilter18' => { 322 => 0x126 },
	'digitalfilter19' => { 322 => 0x137 },
	'digitalfilter20' => { 322 => 0x148 },
	'digitalgain' => { 70 => 0xb },
	'digitalgem' => { 203 => 0x0 },
	'digitalice' => { 221 => 0x100 },
	'digitalimageguid' => { 455 => 'DigImageGUID' },
	'digitalroc' => { 219 => 0x0 },
	'digitalsourcefiletype' => { 455 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 455 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 106 => 0xa, 121 => 0x1044, 133 => 0x68, 147 => 'DigitalZoom', 171 => 0xc, 214 => 0x86, 243 => 0xa, 282 => 0x204, 335 => 0x1e, 342 => 0xa, 370 => 0x204, 411 => 0x12, 412 => 0x12 },
	'digitalzoomon' => { 370 => 0x21b },
	'digitalzoomratio' => { 113 => 0xa404, 401 => 0x200, 403 => 0x21c, 449 => 'DigitalZoomRatio' },
	'director' => { 469 => 'director' },
	'directorphotography' => { 469 => 'directorPhotography' },
	'directory' => { 114 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 197 => 0x3 },
	'disclaimer' => { 290 => 'Disclaimer' },
	'discnumber' => { 469 => 'discNumber' },
	'dishtype' => { 461 => 'dishType' },
	'displayallafpoints' => { 78 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 350 => 0x2 },
	'displayedunitsy' => { 350 => 0x6 },
	'displayname' => { 458 => 'displayName' },
	'distance1' => { 133 => 0x28 },
	'distance2' => { 133 => 0x2c },
	'distance3' => { 133 => 0x30 },
	'distance4' => { 133 => 0x34 },
	'distortion' => { 368 => 0xa050 },
	'distortioncompensation' => { 424 => 0x8040 },
	'distortioncontrol' => { 222 => 0x10 },
	'distortioncorrection' => { 97 => 0x20705, 103 => 0x67, 113 => 0x7036, 277 => 0x50b, 304 => '7.1', 325 => 0x0, 419 => 0x601, 420 => 0x5b },
	'distortioncorrection2' => { 281 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 441 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 97 => '0x20705.0', 103 => 0x63 },
	'distortioncorrectionsetting' => { 391 => 0x2013 },
	'distortioncorrparams' => { 113 => 0x7037, 400 => 0x1a23, 403 => 0x1870, 405 => 0x189c, 406 => 0x18cc, 407 => 0x17d0, 419 => 0x6ca, 420 => 0x64 },
	'distortioncorrparamsnumber' => { 403 => 0x1899, 405 => 0x18c5, 406 => 0x18f5, 407 => 0x17f9 },
	'distortioncorrparamspresent' => { 403 => 0x1898, 405 => 0x18c4, 406 => 0x18f4, 407 => 0x17f8, 409 => 0x10b, 410 => 0x10b, 419 => 0x600, 420 => 0x5a },
	'distortioneffect' => { 97 => 0x20709 },
	'distortionn' => { 304 => 0xc },
	'distortionparam02' => { 304 => 0x2 },
	'distortionparam04' => { 304 => 0x4 },
	'distortionparam08' => { 304 => 0x8 },
	'distortionparam09' => { 304 => 0x9 },
	'distortionparam11' => { 304 => 0xb },
	'distortionscale' => { 304 => 0x5 },
	'distributor' => { 459 => 'distributor' },
	'distributorproductid' => { 458 => 'distributorProductID' },
	'dloon' => { 97 => '0x20706.0', 103 => 0xdc },
	'dlosetting' => { 97 => 0x20706, 103 => 0xdd },
	'dlosettingapplied' => { 96 => 0x4 },
	'dloshootingdistance' => { 103 => 0xde },
	'dloversion' => { 96 => 0x5 },
	'dmcomment' => { 469 => 'comment' },
	'dmdithermatrix' => { 131 => 0xc7a },
	'dmdithermatrixheight' => { 131 => 0xc7c },
	'dmdithermatrixwidth' => { 131 => 0xc7b },
	'dngadobedata' => { 113 => 0xc634 },
	'dngbackwardversion' => { 113 => 0xc613 },
	'dngignoresidecars' => { 445 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 113 => 0xc630 },
	'dngprivatedata' => { 113 => 0xc634 },
	'dngversion' => { 113 => 0xc612 },
	'document' => { 290 => 'Document' },
	'documentancestors' => { 457 => 'DocumentAncestors' },
	'documenthistory' => { 125 => 0xe7 },
	'documentid' => { 470 => 'DocumentID' },
	'documentname' => { 113 => 0x10d },
	'documentnotes' => { 125 => 0xe6 },
	'doi' => { 459 => 'doi' },
	'dopesheet' => { 455 => 'Dopesheet' },
	'dopesheetlink' => { 455 => 'DopesheetLink' },
	'dopesheetlinklink' => { 455 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 455 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 131 => 0xc82 },
	'dpp' => { 439 => 'dpp' },
	'dr4cameramodel' => { 98 => 0x3 },
	'drangepriority' => { 121 => 0x1443 },
	'drangepriorityauto' => { 121 => 0x1444 },
	'drangepriorityfixed' => { 121 => 0x1445 },
	'drivemode' => { 107 => 0x3103, 119 => '0.1', 171 => 0x6, 174 => 0x1e, 177 => 0xe, 277 => 0x600, 335 => 0x34, 361 => 0x1002, 371 => 0x3, 379 => 0x4, 380 => 0x7e, 381 => 0x34 },
	'drivemode2' => { 174 => 0xa, 316 => 0x7, 390 => 0xe, 396 => 0x1 },
	'drivemodesetting' => { 381 => 0x4 },
	'drivespeed' => { 119 => '0.2' },
	'dspfirmwareversion' => { 335 => 0x27 },
	'duration' => { 63 => 0x6a, 146 => 'Duration', 160 => 'Duration', 461 => 'duration', 469 => 'duration' },
	'durationscale' => { 469 => [\'duration','durationScale'] },
	'durationvalue' => { 469 => [\'duration','durationValue'] },
	'dustremovaldata' => { 60 => 0x97 },
	'dynamicafarea' => { 260 => '1.4', 269 => '1.4' },
	'dynamicareaafdisplay' => { 261 => '46.1', 263 => '47.1', 264 => '47.1', 273 => '47.1', 274 => '47.1' },
	'dynamicrange' => { 121 => 0x1400 },
	'dynamicrangeexpansion' => { 335 => 0x69, 361 => 0x100e },
	'dynamicrangemax' => { 102 => 0x7c },
	'dynamicrangemin' => { 102 => 0x7a },
	'dynamicrangeoptimizer' => { 174 => 0x15, 391 => [0xb025,0xb04f], 399 => 0x1144, 400 => [0x1144,0x324], 401 => [0x1120,0x300], 402 => [0x119c,0x37c], 403 => [0x1178,0x328], 404 => [0x1030,0x50], 405 => [0x228,0x50], 406 => [0x228,0x50], 407 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 390 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 379 => 0x19, 380 => 0x17, 381 => 0xd, 390 => 0x79, 396 => 0x5 },
	'dynamicrangeoptimizermode' => { 177 => 0x15, 379 => 0x18, 380 => 0x16, 390 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 174 => 0x27, 381 => 0xc, 396 => 0x4 },
	'dynamicrangesetting' => { 121 => 0x1402 },
	'e-dialinprogram' => { 316 => '1.3' },
	'earliestageorloweststage' => { 112 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 275 => '6.1' },
	'easyexposurecompensation' => { 260 => '6.4', 261 => '6.5', 263 => '6.3', 264 => '6.3', 268 => '5.1', 269 => '4.4', 270 => '5.2', 273 => '6.3', 274 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgemapslope' => { 131 => 0x930 },
	'edgemapx1' => { 131 => 0x931 },
	'edgemapx2' => { 131 => 0x932 },
	'edgemapx3' => { 131 => 0x934 },
	'edgemapx4' => { 131 => 0x935 },
	'edgenoisereduction' => { 254 => 0x4, 424 => 0x8028 },
	'edition' => { 459 => 'edition' },
	'editorialupdate' => { 125 => 0x8 },
	'editstatus' => { 125 => 0x7, 347 => 'EditStatus', 439 => 'EditStatus' },
	'editversionname' => { 253 => 0x3d136244 },
	'effectivelv' => { 335 => 0x2d },
	'effectivemaxaperture' => { 207 => 0x12, 208 => 0x13, 212 => 0x14 },
	'eissn' => { 459 => 'eIssn' },
	'electricalblackcolumns' => { 131 => 0x1810 },
	'electronicfront-curtainshutter' => { 263 => '5.2', 264 => '5.2', 273 => '5.3', 274 => '5.2' },
	'electronicfrontcurtainshutter' => { 391 => 0x201a },
	'elevation' => { 156 => 'Elevation' },
	'email' => { 148 => 'EMail' },
	'embargodate' => { 462 => 'embargoDate' },
	'embdencrightsexpr' => { 455 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 455 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 455 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 455 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 457 => 'EmbeddedXMPDigest' },
	'emissivity' => { 115 => 0x3 },
	'enablechromanoisereduction' => { 131 => 0xe6e },
	'enablesharpening' => { 131 => 0x92e },
	'encryptionkey' => { 368 => 0xa020 },
	'endingpage' => { 459 => 'endingPage' },
	'enduser' => { 287 => 'EndUser' },
	'enduserid' => { 287 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 287 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 469 => 'engineer' },
	'enhancedarktones' => { 246 => 0x8 },
	'enhancement' => { 106 => 0x16, 107 => 0x3016 },
	'enhancer' => { 281 => 0x300 },
	'enhancervalues' => { 281 => 0x301 },
	'envelopenumber' => { 126 => 0x28 },
	'envelopepriority' => { 126 => 0x3c },
	'enveloperecordversion' => { 126 => 0x0 },
	'episode' => { 455 => 'Episode' },
	'episodeidentifier' => { 455 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 455 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 455 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 282 => 0x20c },
	'epsonimagewidth' => { 282 => 0x20b },
	'epsonsoftware' => { 282 => 0x20d },
	'equipmentinstitution' => { 426 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 426 => 'EquipmentManufacturer' },
	'equipmentversion' => { 278 => 0x0 },
	'ettlii' => { 78 => 0x304, 79 => 0xd, 80 => 0xe, 81 => 0x7, 82 => 0x7, 83 => 0xe },
	'event' => { 427 => 'Event', 437 => 'Event', 455 => 'Event', 459 => 'event' },
	'eventalias' => { 458 => 'eventAlias' },
	'eventdate' => { 112 => [\'Event','EventEventDate'] },
	'eventday' => { 112 => [\'Event','EventDay'] },
	'eventearliestdate' => { 112 => [\'Event','EventEarliestDate'] },
	'eventend' => { 458 => 'eventEnd' },
	'eventenddayofyear' => { 112 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 112 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 112 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 112 => [\'Event','EventHabitat'] },
	'eventid' => { 112 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 112 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 112 => [\'Event','EventMonth'] },
	'eventnumber' => { 356 => 0x9, 357 => 0x37 },
	'eventparenteventid' => { 112 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 112 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 112 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 112 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 112 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 112 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 458 => 'eventStart' },
	'eventstartdayofyear' => { 112 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 458 => 'eventSubtype' },
	'eventtime' => { 112 => [\'Event','EventEventTime'] },
	'eventtype' => { 458 => 'eventType' },
	'eventverbatimeventdate' => { 112 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 112 => [\'Event','EventYear'] },
	'evsteps' => { 316 => '1.2', 318 => 0x0 },
	'evstepsize' => { 265 => '5.1', 266 => '6.1', 267 => '6.1', 271 => '0.7' },
	'exclusivecoverage' => { 434 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 462 => 'exclusivityEndDate' },
	'excursiontolerance' => { 127 => 0x82 },
	'exif' => { 114 => 'EXIF' },
	'exifbyteorder' => { 114 => 'ExifByteOrder' },
	'exifcamerainfo' => { 125 => 0xe8 },
	'exifimageheight' => { 113 => 0xa003, 449 => 'PixelYDimension' },
	'exifimagewidth' => { 113 => 0xa002, 449 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 114 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 113 => 0x9000, 449 => 'ExifVersion' },
	'exitpupilposition' => { 207 => 0x4, 208 => 0x4, 212 => 0x4 },
	'expirationdate' => { 125 => 0x25, 462 => 'expirationDate' },
	'expirationtime' => { 125 => 0x26 },
	'exposure' => { 113 => 0xfe51, 445 => 'Exposure' },
	'exposure2012' => { 445 => 'Exposure2012' },
	'exposureadj' => { 251 => 0x0 },
	'exposureadj2' => { 251 => 0x12 },
	'exposureadjust' => { 371 => 0xc },
	'exposurebracketingindicatorlast' => { 174 => 0x52 },
	'exposurebracketshotnumber' => { 177 => 0x2d, 390 => 0x2f },
	'exposurebracketstepsize' => { 316 => 0x8 },
	'exposurebracketvalue' => { 214 => 0x19 },
	'exposurecompautocancel' => { 78 => 0x113 },
	'exposurecompensation' => { 72 => 0x6, 87 => 0x0, 113 => 0x9204, 133 => 0x24, 147 => 'ExposureComp', 167 => 'ExposureCompensation', 171 => 0xd, 172 => 0x53, 173 => 0x1e, 177 => 0x49c0, 282 => 0x1006, 335 => 0x16, 344 => 0x402, 368 => 0xa013, 371 => [0xc,0x35,0x4d], 399 => 0x114c, 400 => 0x114c, 401 => 0x1128, 403 => 0x1180, 404 => 0x1038, 405 => 0x230, 406 => 0x230, 407 => 0x223, 449 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 396 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 174 => 0x47, 177 => 0x2a },
	'exposurecompensationset' => { 379 => 0x3, 380 => 0x3, 381 => 0x3, 396 => 0x1e },
	'exposurecompensationsetting' => { 174 => 0x1 },
	'exposurecompstepsize' => { 260 => '6.3', 261 => '7.3', 263 => '7.3', 264 => '7.3', 269 => '4.3', 273 => '7.3', 274 => '7.3' },
	'exposurecontrolstep' => { 268 => '6.1', 270 => '6.1' },
	'exposurecontrolstepsize' => { 260 => '6.2', 261 => '7.1', 263 => '7.1', 264 => '7.1', 269 => '4.2', 273 => '7.1', 274 => '7.1', 275 => '7.1' },
	'exposurecount' => { 121 => 0x1032 },
	'exposuredelaymode' => { 260 => '10.1', 261 => '11.1', 263 => '11.1', 264 => '11.1', 265 => '9.1', 266 => '10.1', 267 => '10.1', 269 => '10.4', 270 => '10.1', 271 => '6.4', 273 => '11.1', 274 => '11.1', 275 => '11.2' },
	'exposuredifference' => { 214 => 0xe },
	'exposuregaincustom' => { 131 => 0x89c },
	'exposuregaindaylight' => { 131 => 0x898 },
	'exposuregainflash' => { 131 => 0x89b },
	'exposuregainfluorescent' => { 131 => 0x89a },
	'exposuregaintungsten' => { 131 => 0x899 },
	'exposureindex' => { 113 => 0xa215, 449 => 'ExposureIndex' },
	'exposureindicator' => { 174 => 0x50 },
	'exposurelevelincrements' => { 76 => 0x6, 77 => 0x6, 78 => 0x101, 79 => 0x5, 80 => 0x6, 81 => 0x5, 82 => 0x5, 83 => 0x6, 84 => 0x4, 379 => 0x58, 380 => 0x58 },
	'exposurelockused' => { 432 => 'ExposureLockUsed' },
	'exposuremode' => { 113 => 0xa402, 147 => 'ExposureMode', 171 => 0x1, 172 => 0xa, 173 => 0x0, 174 => 0x0, 177 => 0x34, 277 => 0x200, 297 => 0x40d, 371 => 0x8, 391 => 0xb041, 449 => 'ExposureMode' },
	'exposuremodeinmanual' => { 78 => 0x10b },
	'exposureprogram' => { 113 => 0x8822, 361 => 0x1001, 372 => [0x17e,0x43], 379 => 0x3c, 380 => 0x3c, 381 => 0x5, 385 => 0x14, 390 => 0x3f, 396 => 0x2, 399 => 0x1175, 400 => 0x1179, 401 => 0x1155, 402 => 0x11d1, 403 => 0x11ad, 404 => 0x1065, 405 => 0x25d, 406 => 0x25d, 407 => 0x24c, 416 => 0xb, 417 => 0xc, 418 => 0xb, 420 => 0x48, 449 => 'ExposureProgram' },
	'exposureshift' => { 277 => 0x203 },
	'exposurestandardadjustment' => { 391 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 72 => 0x16, 113 => 0x829a, 130 => 0xfd05, 133 => 0x20, 135 => 0xfa24, 137 => 0xf104, 140 => 0x12, 142 => 0x38, 145 => 0x10, 147 => 'ExposureTime', 171 => 0x9, 172 => 0x35, 173 => 0x48, 174 => 0x8, 177 => 0x49b8, 335 => 0x12, 368 => 0xa018, 371 => [0x32,0x4a], 379 => 0x0, 380 => 0x0, 396 => [0x21,0x23,0x27], 420 => 0x10, 449 => 'ExposureTime' },
	'exposuretime2' => { 371 => [0x33,0x4b] },
	'exposuretuning' => { 214 => 0x1c },
	'exposurevalue' => { 131 => 0x3 },
	'exposurewarning' => { 121 => 0x1302 },
	'exrauto' => { 121 => 0x1033 },
	'exrmode' => { 121 => 0x1034 },
	'extendedwbdetect' => { 277 => 0x902 },
	'extender' => { 278 => 0x301 },
	'extenderfirmwareversion' => { 278 => 0x304 },
	'extendermagnification' => { 149 => 'Magnification' },
	'extendermake' => { 149 => 'Make' },
	'extendermodel' => { 149 => 'Model', 278 => 0x303 },
	'extenderserialnumber' => { 149 => 'SerialNumber', 278 => 0x302 },
	'extenderstatus' => { 333 => 0x3 },
	'externalflash' => { 280 => 0x1201 },
	'externalflashae1' => { 282 => 0x101f },
	'externalflashae1_0' => { 282 => 0x101b },
	'externalflashae2' => { 282 => 0x1020 },
	'externalflashae2_0' => { 282 => 0x101c },
	'externalflashbounce' => { 280 => 0x1204, 282 => 0x1026, 323 => 0x1a },
	'externalflashcompensation' => { 200 => 0x1b },
	'externalflashexposurecomp' => { 214 => 0x17, 323 => 0x19 },
	'externalflashfirmware' => { 198 => 0x6, 199 => 0x6, 200 => 0x6, 201 => 0x6, 202 => 0x6 },
	'externalflashflags' => { 198 => 0x8, 199 => 0x8, 200 => 0x8, 201 => 0x8 },
	'externalflashguidenumber' => { 280 => 0x1203, 323 => '24.1' },
	'externalflashgvalue' => { 282 => 0x1025 },
	'externalflashmode' => { 282 => 0x1028, 323 => 0x2 },
	'externalflashreadystate' => { 202 => '9.1' },
	'externalflashstatus' => { 202 => '8.2' },
	'externalflashzoom' => { 280 => 0x1205, 282 => 0x1027 },
	'externalflashzoomoverride' => { 202 => '8.1' },
	'externalmetadatalink' => { 455 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 295 => 0x311, 298 => 0x311, 299 => 0x311, 302 => 0x3408 },
	'extrainfoversion' => { 383 => 0x1a },
	'eyestartaf' => { 174 => 0x40 },
	'fac100per' => { 131 => 0xe94 },
	'fac170per' => { 131 => 0xe93 },
	'fac18per' => { 131 => 0xe92 },
	'face10position' => { 104 => 0x3f4, 105 => 0x1ec, 196 => 0x28, 320 => 0x12 },
	'face10size' => { 321 => 0x12 },
	'face11position' => { 196 => 0x2c, 320 => 0x14 },
	'face11size' => { 321 => 0x14 },
	'face12position' => { 196 => 0x30, 320 => 0x16 },
	'face12size' => { 321 => 0x16 },
	'face13position' => { 320 => 0x18 },
	'face13size' => { 321 => 0x18 },
	'face14position' => { 320 => 0x1a },
	'face14size' => { 321 => 0x1a },
	'face15position' => { 320 => 0x1c },
	'face15size' => { 321 => 0x1c },
	'face16position' => { 320 => 0x1e },
	'face16size' => { 321 => 0x1e },
	'face17position' => { 320 => 0x20 },
	'face17size' => { 321 => 0x20 },
	'face18position' => { 320 => 0x22 },
	'face18size' => { 321 => 0x22 },
	'face19position' => { 320 => 0x24 },
	'face19size' => { 321 => 0x24 },
	'face1position' => { 51 => 0x8, 104 => 0xd, 105 => 0x18, 196 => 0x4, 292 => 0x1, 320 => 0x0, 358 => 0xbc, 386 => 0x1, 387 => 0x0, 388 => 0x0, 389 => 0x5b },
	'face1size' => { 321 => 0x0 },
	'face20position' => { 320 => 0x26 },
	'face20size' => { 321 => 0x26 },
	'face21position' => { 320 => 0x28 },
	'face21size' => { 321 => 0x28 },
	'face22position' => { 320 => 0x2a },
	'face22size' => { 321 => 0x2a },
	'face23position' => { 320 => 0x2c },
	'face23size' => { 321 => 0x2c },
	'face24position' => { 320 => 0x2e },
	'face24size' => { 321 => 0x2e },
	'face25position' => { 320 => 0x30 },
	'face25size' => { 321 => 0x30 },
	'face26position' => { 320 => 0x32 },
	'face26size' => { 321 => 0x32 },
	'face27position' => { 320 => 0x34 },
	'face27size' => { 321 => 0x34 },
	'face28position' => { 320 => 0x36 },
	'face28size' => { 321 => 0x36 },
	'face29position' => { 320 => 0x38 },
	'face29size' => { 321 => 0x38 },
	'face2position' => { 51 => 0xa, 104 => 0x7c, 105 => 0x4c, 196 => 0x8, 292 => 0x5, 320 => 0x2, 358 => 0xc8, 386 => 0x6, 387 => 0x20, 388 => 0x25, 389 => 0x65 },
	'face2size' => { 321 => 0x2 },
	'face30position' => { 320 => 0x3a },
	'face30size' => { 321 => 0x3a },
	'face31position' => { 320 => 0x3c },
	'face31size' => { 321 => 0x3c },
	'face32position' => { 320 => 0x3e },
	'face32size' => { 321 => 0x3e },
	'face3position' => { 51 => 0xc, 104 => 0xeb, 105 => 0x80, 196 => 0xc, 292 => 0x9, 320 => 0x4, 358 => 0xd4, 386 => 0xb, 387 => 0x40, 388 => 0x4a, 389 => 0x6f },
	'face3size' => { 321 => 0x4 },
	'face4position' => { 51 => 0xe, 104 => 0x15a, 105 => 0xb4, 196 => 0x10, 292 => 0xd, 320 => 0x6, 358 => 0xe0, 386 => 0x10, 387 => 0x60, 388 => 0x6f, 389 => 0x79 },
	'face4size' => { 321 => 0x6 },
	'face5position' => { 51 => 0x10, 104 => 0x1c9, 105 => 0xe8, 196 => 0x14, 292 => 0x11, 320 => 0x8, 358 => 0xec, 386 => 0x15, 387 => 0x80, 388 => 0x94 },
	'face5size' => { 321 => 0x8 },
	'face6position' => { 51 => 0x12, 104 => 0x238, 105 => 0x11c, 196 => 0x18, 320 => 0xa, 358 => 0xf8, 386 => 0x1a, 387 => 0xa0, 388 => 0xb9 },
	'face6size' => { 321 => 0xa },
	'face7position' => { 51 => 0x14, 104 => 0x2a7, 105 => 0x150, 196 => 0x1c, 320 => 0xc, 358 => 0x104, 386 => 0x1f, 387 => 0xc0, 388 => 0xde },
	'face7size' => { 321 => 0xc },
	'face8position' => { 51 => 0x16, 104 => 0x316, 105 => 0x184, 196 => 0x20, 320 => 0xe, 358 => 0x110, 386 => 0x24, 387 => 0xe0, 388 => 0x103 },
	'face8size' => { 321 => 0xe },
	'face9position' => { 51 => 0x18, 104 => 0x385, 105 => 0x1b8, 196 => 0x24, 320 => 0x10 },
	'face9size' => { 321 => 0x10 },
	'facebalanceorigi' => { 438 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 438 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 438 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 438 => 'FaceBalanceWarmth' },
	'facedetect' => { 335 => 0x76, 368 => 0x100 },
	'facedetectarea' => { 281 => 0x1201 },
	'facedetectframecrop' => { 281 => 0x1207 },
	'facedetectframesize' => { 51 => 0x3, 104 => 0x1, 105 => 0x4, 196 => 0x1, 281 => 0x1203, 335 => 0x77, 358 => 0xb6 },
	'facedetection' => { 381 => 0x30, 396 => 0x19 },
	'faceelementpositions' => { 121 => 0x4203 },
	'faceelementselected' => { 121 => 0x4005 },
	'faceelementtypes' => { 121 => 0x4201 },
	'faceid' => { 440 => 'FaceID' },
	'faceinfounknown' => { 107 => 0x2089 },
	'facename' => { 368 => 0x123 },
	'faceorientation' => { 105 => 0x8 },
	'faceposition' => { 319 => 0x2, 369 => 0x4 },
	'facepositions' => { 121 => 0x4103 },
	'facerecognition' => { 368 => 0x120 },
	'facesdetected' => { 51 => 0x2, 52 => 0x2, 53 => 0x3, 104 => 0x0, 105 => 0x2, 107 => 0x211c, 121 => 0x4100, 196 => 0x3, 281 => 0x1200, 300 => 0x3f, 319 => 0x0, 358 => 0xb5, 369 => 0x0, 386 => 0x0, 389 => 0x3, 398 => 0x30 },
	'facesrecognized' => { 293 => 0x0 },
	'facewidth' => { 52 => 0x1 },
	'faithfuloutputhighlightpoint' => { 103 => 0x38 },
	'faithfuloutputshadowpoint' => { 103 => 0x39 },
	'faithfulrawcolortone' => { 103 => 0x31 },
	'faithfulrawcontrast' => { 103 => 0x33 },
	'faithfulrawhighlight' => { 103 => 0x79 },
	'faithfulrawhighlightpoint' => { 103 => 0x36 },
	'faithfulrawlinear' => { 103 => 0x34 },
	'faithfulrawsaturation' => { 103 => 0x32 },
	'faithfulrawshadow' => { 103 => 0x82 },
	'faithfulrawshadowpoint' => { 103 => 0x37 },
	'faithfulrawsharpness' => { 103 => 0x35 },
	'faithfulunsharpmaskfineness' => { 103 => 0xac },
	'faithfulunsharpmaskstrength' => { 103 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 103 => 0xae },
	'far' => { 429 => 'Far' },
	'fastresetlinetime' => { 131 => 0x1860 },
	'feedidentifier' => { 455 => 'FeedIdentifier' },
	'femicroadjustment' => { 78 => 0x111 },
	'ffid' => { 447 => 'ffid' },
	'field' => { 458 => 'field' },
	'fieldcount' => { 282 => 0x103f },
	'fifoenonepixeldelay' => { 131 => 0x1901 },
	'filecreatedate' => { 114 => 'FileCreateDate' },
	'filedatarate' => { 469 => 'fileDataRate' },
	'fileformat' => { 89 => 0x0, 126 => 0x14, 371 => [0x22,0x26], 391 => 0xb000 },
	'filegroupid' => { 114 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 301 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 114 => 'FileModifyDate' },
	'filename' => { 114 => 'FileName' },
	'filenameasdelivered' => { 287 => 'FileNameAsDelivered' },
	'filenumber' => { 54 => 0x1, 60 => 0x8, 91 => 0x1817, 108 => 'FileNumber', 197 => 0x4 },
	'filenumbermemory' => { 171 => 0x1a },
	'filenumbersequence' => { 260 => '12.2', 265 => '3.1', 266 => '4.1', 267 => '4.1', 269 => '11.1', 270 => '4.3', 275 => '5.2' },
	'filepermissions' => { 114 => 'FilePermissions' },
	'filesource' => { 113 => 0xa300, 121 => 0x8000, 449 => 'FileSource' },
	'fileuserid' => { 114 => 'FileUserID' },
	'fileversion' => { 126 => 0x16 },
	'fillflashautoreduction' => { 76 => 0xe, 77 => 0xe, 84 => 0xa },
	'filllight' => { 445 => 'FillLight' },
	'fillorder' => { 113 => 0x10a },
	'filmgraineffect' => { 277 => 0x538 },
	'filmmode' => { 121 => 0x1401, 297 => 0x412, 300 => 0x42 },
	'filmtype' => { 221 => 0x2 },
	'filtereffect' => { 54 => 0xe, 216 => 0x37, 217 => 0x3f },
	'filtereffectauto' => { 67 => 0xa0 },
	'filtereffectfaithful' => { 66 => 0x70, 67 => 0x70 },
	'filtereffectlandscape' => { 66 => 0x40, 67 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 66 => 0x88, 67 => 0x88 },
	'filtereffectneutral' => { 66 => 0x58, 67 => 0x58 },
	'filtereffectportrait' => { 66 => 0x28, 67 => 0x28 },
	'filtereffectstandard' => { 66 => 0x10, 67 => 0x10 },
	'filtereffectuserdef1' => { 66 => 0xa0, 67 => 0xb8 },
	'filtereffectuserdef2' => { 66 => 0xb8, 67 => 0xd0 },
	'filtereffectuserdef3' => { 66 => 0xd0, 67 => 0xe8 },
	'finderdisplayduringexposure' => { 77 => 0x1 },
	'finesharpness' => { 335 => 0x70 },
	'finetuneoptcenterweighted' => { 260 => '7.2', 261 => '9.1', 263 => '9.1', 264 => '9.1', 268 => '8.1', 273 => '9.1', 274 => '9.1', 275 => '9.1' },
	'finetuneopthighlightweighted' => { 263 => '46.1', 264 => '46.1', 273 => '46.1', 274 => '46.1' },
	'finetuneoptmatrixmetering' => { 260 => '8.1', 261 => '8.2', 263 => '8.2', 264 => '8.2', 268 => '7.2', 269 => '6.1', 273 => '8.2', 274 => '8.2', 275 => '8.2' },
	'finetuneoptspotmetering' => { 260 => '8.2', 261 => '9.2', 263 => '9.2', 264 => '9.2', 268 => '8.2', 269 => '6.2', 273 => '9.2', 274 => '9.2', 275 => '9.2' },
	'finishexposure' => { 131 => 0xdbd },
	'finishfiletype' => { 131 => 0xdb8 },
	'finishlook' => { 131 => 0xdbc },
	'finishnoise' => { 131 => 0xdba },
	'finishresolution' => { 131 => 0xdb9 },
	'finishsharpening' => { 131 => 0xdbb },
	'firmware' => { 282 => 0x405, 371 => [0x17,0x3b,0x57], 441 => 'Firmware' },
	'firmwaredate' => { 106 => 0x15, 107 => 0x2001, 356 => 0x4 },
	'firmwareid' => { 178 => 0x0 },
	'firmwarename' => { 368 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 60 => 0x1e, 359 => 0x0 },
	'firmwarerevision2' => { 359 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 131 => [0x415,0xce5], 145 => 0x57, 147 => 'FirmwareVersion', 298 => 0x320, 300 => 0x2, 302 => 0x3109, 335 => 0x230, 357 => 0x18, 361 => 0x2 },
	'firmwareversions' => { 344 => 0x301 },
	'firstphotodate' => { 432 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 287 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 125 => 0x16, 439 => 'FixtureIdentifier' },
	'flash' => { 108 => 'Flash', 113 => 0x9209, 172 => 0x1f, 173 => 0x15, 449 => 'Flash' },
	'flashaction' => { 379 => 0x3e, 380 => 0x3e, 391 => 0x2017, 396 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 379 => 0x4c, 380 => 0x4c, 396 => 0x77 },
	'flashactionexternal' => { 396 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 41 => 0x249 },
	'flashbias' => { 300 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 78 => 0x70e },
	'flashchargelevel' => { 282 => 0x1010 },
	'flashcolorfilter' => { 200 => 0x10, 201 => 0x10 },
	'flashcommandermode' => { 198 => '9.1', 199 => '9.1', 200 => '9.1', 201 => '9.1' },
	'flashcompensation' => { 131 => 0x3f3, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27, 202 => 0xa, 441 => 'FlashCompensation' },
	'flashcontrol' => { 379 => 0x23, 380 => 0x1f, 381 => 0x21 },
	'flashcontrolbuilt-in' => { 269 => '16.1', 270 => '23.1', 272 => '23.1', 273 => '24.1' },
	'flashcontrolmode' => { 198 => '9.2', 199 => '9.2', 200 => '9.2', 201 => '9.2', 277 => 0x404 },
	'flashcurtain' => { 300 => 0x48 },
	'flashdefault' => { 174 => 0x42 },
	'flashdevice' => { 282 => 0x1005 },
	'flashdistance' => { 107 => 0x2034 },
	'flashenergy' => { 113 => 0xa20b, 449 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 214 => 0x18 },
	'flashexposurecomp' => { 72 => 0xf, 121 => 0x1011, 150 => 'ExposureComp', 171 => 0x23, 176 => 0x104, 177 => 0x49c1, 214 => 0x12, 277 => 0x401, 282 => 0x1023, 335 => 0x4d, 361 => 0x100b, 371 => [0x3a,0x56], 391 => 0x104 },
	'flashexposurecomp2' => { 239 => 0x4d2 },
	'flashexposurecomp3' => { 200 => 0x1d },
	'flashexposurecomp4' => { 200 => 0x27 },
	'flashexposurecomparea' => { 261 => '38.4', 263 => '38.4', 264 => '38.4', 273 => '38.4', 274 => '38.4' },
	'flashexposurecompset' => { 174 => 0x10, 308 => 0xe, 379 => 0x14, 380 => 0x12, 381 => 0x23, 396 => 0x1f },
	'flashexposurecompset2' => { 396 => [0x26,0x2c] },
	'flashexposureindicator' => { 174 => 0x54 },
	'flashexposureindicatorlast' => { 174 => 0x56 },
	'flashexposureindicatornext' => { 174 => 0x55 },
	'flashexposurelock' => { 54 => 0x19 },
	'flashfired' => { 133 => 0x5d, 150 => 'Fired', 171 => 0x14, 238 => '590.3', 449 => [\'Flash','FlashFired'] },
	'flashfiring' => { 78 => 0x306, 79 => 0x6, 80 => 0x7, 83 => 0x7 },
	'flashfirmwareversion' => { 278 => 0x1002 },
	'flashfocallength' => { 198 => 0xb, 199 => 0xc, 200 => 0xc, 201 => 0xc, 202 => 0xc },
	'flashfunction' => { 177 => 0x31, 449 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 198 => 0xe, 199 => 0xf, 200 => 0xf, 201 => 0xf, 202 => 0xf },
	'flashgroupacompensation' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupacontrolmode' => { 198 => 0xf, 199 => '16.1', 200 => '17.1', 201 => '17.1', 202 => '17.1' },
	'flashgroupaoutput' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupbcompensation' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupbcontrolmode' => { 198 => 0x10, 199 => '17.1', 200 => '18.1', 201 => '18.1', 202 => '18.1' },
	'flashgroupboutput' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupccompensation' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashgroupccontrolmode' => { 199 => '17.2', 200 => '18.2', 201 => '18.2', 202 => '18.2' },
	'flashgroupcoutput' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashguidenumber' => { 72 => 0xd, 88 => 0x0, 150 => 'GuideNumber' },
	'flashintensity' => { 106 => [0x19,0x5], 277 => 0x405 },
	'flashlevel' => { 262 => 0x9, 391 => 0xb048 },
	'flashmake' => { 150 => 'Make' },
	'flashmanufacturer' => { 169 => 'FlashManufacturer' },
	'flashmetering' => { 171 => 0x3f, 174 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 335 => 0x20a },
	'flashmode' => { 106 => 0x4, 131 => 0x3f2, 133 => 0x5c, 150 => 'Mode', 171 => 0x2, 172 => 0x20, 173 => 0x16, 174 => 0xf, 214 => 0x87, 277 => 0x400, 282 => 0x1004, 335 => 0xc, 342 => 0x4, 360 => 0x20, 361 => 0x100a, 370 => 0x225, 379 => 0x13, 380 => 0x7f, 381 => 0x20, 396 => 0x10, 399 => 0x1138, 400 => 0x1138, 401 => 0x1114, 402 => 0x1190, 403 => 0x116c, 404 => 0x1024, 405 => 0x21c, 406 => 0x21c, 407 => 0x211, 449 => [\'Flash','FlashMode'] },
	'flashmodel' => { 150 => 'Model', 169 => 'FlashModel', 278 => 0x1001 },
	'flashoptions' => { 316 => 0x2 },
	'flashoptions2' => { 316 => 0x10 },
	'flashoutput' => { 41 => 0x248, 72 => 0x21, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27 },
	'flashpixversion' => { 113 => 0xa000, 449 => 'FlashpixVersion' },
	'flashredeyemode' => { 449 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 277 => 0x403 },
	'flashreturn' => { 449 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 150 => 'SerialNumber', 278 => 0x1003 },
	'flashsetting' => { 214 => 0x8 },
	'flashshutterspeed' => { 260 => '20.2', 261 => '23.2', 263 => '23.2', 264 => '23.2', 269 => '15.2', 270 => '22.2', 271 => '7.2', 272 => '22.2', 273 => '23.2', 274 => '23.2', 275 => '23.1' },
	'flashsource' => { 198 => 0x4, 199 => 0x4, 200 => 0x4, 201 => 0x4, 202 => 0x4 },
	'flashstatus' => { 323 => 0x0, 396 => [0x82,0x86], 409 => 0x31, 410 => 0x39 },
	'flashstatusbuilt-in' => { 381 => [0x87,0x287] },
	'flashstatusexternal' => { 381 => [0x88,0x288] },
	'flashsyncspeed' => { 260 => '20.1', 261 => '23.1', 263 => '23.1', 264 => '23.1', 269 => '15.1', 270 => '22.1', 272 => '22.1', 273 => '23.1', 274 => '23.1' },
	'flashsyncspeedav' => { 76 => 0x3, 78 => 0x10f, 79 => 0x2, 80 => 0x3, 81 => 0x2, 82 => 0x2, 83 => 0x3, 84 => 0x6 },
	'flashthreshold' => { 88 => 0x1 },
	'flashtype' => { 150 => 'Type', 174 => 0x59, 214 => 0x9, 278 => 0x1000 },
	'flashwarning' => { 270 => '30.1', 271 => '7.1', 275 => '31.1', 300 => 0x62 },
	'flexiblespotposition' => { 391 => 0x201d },
	'flickerreduce' => { 370 => 0x218 },
	'flickerreduction' => { 121 => 0x1446, 232 => 0xe84 },
	'flickerreductionindicator' => { 232 => 0x5e2 },
	'flightpitchdegree' => { 110 => 'FlightPitchDegree' },
	'flightrolldegree' => { 110 => 'FlightRollDegree' },
	'flightyawdegree' => { 110 => 'FlightYawDegree' },
	'fliphorizontal' => { 253 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 72 => 0x15, 113 => 0x829d, 130 => 0xfd04, 133 => 0x1e, 135 => 0xfa23, 137 => 0xf103, 140 => 0x13, 142 => 0x3c, 145 => 0xc, 154 => 'FNumber', 171 => 0xa, 172 => 0x36, 173 => 0x47, 174 => 0x9, 177 => 0x49c7, 212 => 0x38, 335 => 0x13, 368 => 0xa019, 371 => [0x31,0x49], 379 => 0x1, 380 => 0x1, 396 => [0x20,0x22,0x26], 449 => 'FNumber' },
	'focaldistance' => { 430 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 56 => 0x1, 107 => 0x1d, 113 => 0x920a, 140 => 0x1d, 154 => 'FocalLength', 171 => 0x12, 207 => 0xa, 208 => 0xb, 212 => [0xc,0x3c], 294 => 0x1, 335 => 0x1d, 344 => 0x403, 361 => 0x1500, 378 => 0xe, 403 => 0x1278, 404 => 0x1134, 405 => 0x32c, 406 => 0x32c, 407 => 0x30a, 449 => 'FocalLength' },
	'focallength2' => { 396 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 113 => 0xa405, 368 => 0xa01a, 449 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 378 => 0x10 },
	'focalplaneafpointarea' => { 408 => 0x2 },
	'focalplaneafpointlocation1' => { 408 => 0x6 },
	'focalplaneafpointlocation10' => { 408 => 0x2a },
	'focalplaneafpointlocation11' => { 408 => 0x2e },
	'focalplaneafpointlocation12' => { 408 => 0x32 },
	'focalplaneafpointlocation13' => { 408 => 0x36 },
	'focalplaneafpointlocation14' => { 408 => 0x3a },
	'focalplaneafpointlocation15' => { 408 => 0x3e },
	'focalplaneafpointlocation2' => { 408 => 0xa },
	'focalplaneafpointlocation3' => { 408 => 0xe },
	'focalplaneafpointlocation4' => { 408 => 0x12 },
	'focalplaneafpointlocation5' => { 408 => 0x16 },
	'focalplaneafpointlocation6' => { 408 => 0x1a },
	'focalplaneafpointlocation7' => { 408 => 0x1e },
	'focalplaneafpointlocation8' => { 408 => 0x22 },
	'focalplaneafpointlocation9' => { 408 => 0x26 },
	'focalplaneafpointsused' => { 408 => 0x1 },
	'focalplanediagonal' => { 278 => 0x103, 282 => 0x205 },
	'focalplaneresolutionunit' => { 113 => 0xa210, 449 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 113 => 0xa20e, 449 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 56 => 0x2 },
	'focalplanexunknown' => { 56 => 0x2 },
	'focalplaneyresolution' => { 113 => 0xa20f, 449 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 56 => 0x3 },
	'focalplaneyunknown' => { 56 => 0x3 },
	'focalpointx' => { 430 => 'FocalPointX' },
	'focalpointy' => { 430 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 56 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 243 => 0x8 },
	'focusarea' => { 171 => 0x31 },
	'focusareaselection' => { 271 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 78 => 0x515 },
	'focusdistance' => { 154 => 'FocusDistance', 171 => 0x13, 177 => 0x49bb, 207 => 0x9, 208 => 0xa, 212 => 0xb, 280 => 0x305, 294 => 0x0, 298 => 0x304, 299 => 0x304 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 54 => 0x15, 72 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 54 => 0x14, 72 => 0x13 },
	'focusholdbutton' => { 174 => 0x44 },
	'focusinfoversion' => { 280 => 0x0 },
	'focusingscreen' => { 77 => 0x0, 78 => 0x80b, 83 => 0x0 },
	'focuslocation' => { 391 => 0x2027 },
	'focuslocked' => { 170 => 0x14 },
	'focusmode' => { 33 => 0x7, 106 => 0x3, 107 => [0x3003,0xd], 121 => 0x1021, 131 => 0x3f5, 133 => 0x38, 147 => 'FocusMode', 171 => 0x30, 173 => 0xe, 174 => 0xc, 214 => 0x7, 277 => 0x301, 282 => 0x100b, 300 => 0x7, 335 => 0xd, 342 => 0x3, 361 => 0x1006, 372 => [0xb,0x5], 378 => [0x15,0x1d], 379 => 0x4d, 380 => 0x4d, 391 => [0xb042,0xb04e,0x201b], 396 => 0x13, 414 => 0x16 },
	'focusmode2' => { 120 => '0.1', 316 => '3.1', 396 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 262 => '10.1', 376 => 0x14, 377 => 0x15, 379 => 0x10, 380 => 0xf, 381 => 0x6 },
	'focusmodeswitch' => { 174 => 0x58, 379 => 0x2e },
	'focuspixel' => { 121 => 0x1023 },
	'focuspointwrap' => { 260 => '2.2', 261 => '2.2', 263 => '2.1', 264 => '2.1', 268 => '1.1', 269 => '2.2', 270 => '1.1', 273 => '2.2', 274 => '2.1', 275 => '2.5' },
	'focusposition' => { 207 => 0x8, 208 => 0x8, 212 => 0x9, 335 => 0x10, 390 => 0x9bb },
	'focusposition2' => { 396 => [0x29,0x2b,0x2f], 414 => 0x2d, 417 => 0x20 },
	'focusprocess' => { 277 => 0x302 },
	'focusrange' => { 33 => 0x12, 282 => 0x100a },
	'focusrangeindex' => { 326 => '3.1' },
	'focusringrotation' => { 78 => 0x713 },
	'focussetting' => { 371 => 0x6 },
	'focusstatus' => { 378 => 0x19, 379 => 0x53, 380 => 0x53 },
	'focusstepcount' => { 280 => 0x301, 282 => 0x100e },
	'focusstepinfinity' => { 280 => 0x303, 282 => 0x103b },
	'focusstepnear' => { 280 => 0x304, 282 => 0x103c },
	'focustrackinglockon' => { 260 => ['1.5','4.1'], 261 => '1.4', 268 => '0.4', 269 => '3.1', 270 => '0.4', 273 => '1.4' },
	'focuswarning' => { 121 => 0x1301 },
	'foldername' => { 171 => 0x27 },
	'foldernumber' => { 379 => 0x9a, 381 => [0x402,0x114,0x316] },
	'fontcomposite' => { 474 => [\'Fonts','FontsComposite'] },
	'fontface' => { 474 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 474 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 474 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 474 => [\'Fonts','FontsFontName'] },
	'fonts' => { 474 => 'Fonts' },
	'fonttype' => { 474 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 474 => [\'Fonts','FontsVersionString'] },
	'for' => { 351 => 'For' },
	'forcewrite' => { 114 => 'ForceWrite' },
	'format' => { 429 => 'Format', 446 => 'format', 467 => 'Format' },
	'forwardlock' => { 464 => 'forwardlock' },
	'forwardmatrix1' => { 113 => 0xc714 },
	'forwardmatrix2' => { 113 => 0xc715 },
	'fossilspecimen' => { 112 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 112 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 63 => [0x2,0x4] },
	'frameheight' => { 121 => 0x3822 },
	'framenum' => { 346 => 0xd7 },
	'framenumber' => { 121 => 0x8003, 177 => 0x3c, 335 => 0x29 },
	'framerate' => { 63 => [0x1,0x6], 113 => 0xc764, 121 => 0x3820 },
	'framewidth' => { 121 => 0x3821 },
	'framing' => { 458 => 'framing' },
	'freebytes' => { 91 => 0x1 },
	'freememorycardimages' => { 172 => [0x37,0x54], 173 => [0x2d,0x4a], 174 => 0x32 },
	'fujiflashmode' => { 121 => 0x1010 },
	'fullimagesize' => { 391 => 0xb02b },
	'fullpanoheightpixels' => { 432 => 'FullPanoHeightPixels', 433 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 432 => 'FullPanoWidthPixels', 433 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 361 => 0x100d },
	'fullsizeimage' => { 153 => 'data' },
	'fullsizeimagename' => { 153 => '1Name' },
	'fullsizeimagetype' => { 153 => '0Type' },
	'func1button' => { 263 => '14.1', 264 => '14.1', 274 => '14.1' },
	'func1buttonplusdials' => { 263 => '42.1', 264 => '42.1', 274 => '42.1' },
	'func2button' => { 263 => '80.1', 264 => '80.1', 274 => '80.1' },
	'func2buttonplusdials' => { 263 => '81.1' },
	'func3button' => { 263 => '83.1' },
	'funcbutton' => { 260 => ['14.1','15.1'], 261 => '14.1', 269 => '28.1', 270 => '13.1', 273 => '14.1', 275 => '14.1' },
	'funcbuttonplusdials' => { 260 => ['14.2','15.2'], 261 => '14.2', 269 => '31.1', 273 => '42.1' },
	'functionbutton' => { 267 => '13.1', 271 => '5.2' },
	'gainbase' => { 281 => 0x610 },
	'gaincontrol' => { 113 => 0xa407, 449 => 'GainControl' },
	'gamma' => { 113 => 0xa500, 131 => 0x8fe, 305 => 0x11c, 450 => 'Gamma' },
	'gammablackpoint' => { 99 => 0xc },
	'gammacolortone' => { 99 => 0x3 },
	'gammacompensatedvalue' => { 127 => 0x91 },
	'gammacontrast' => { 99 => 0x2 },
	'gammacurveoutputrange' => { 99 => 0xf },
	'gammahighlight' => { 99 => 0xa },
	'gammalinear' => { 97 => 0x20200 },
	'gammamidpoint' => { 99 => 0xe },
	'gammasaturation' => { 99 => 0x4 },
	'gammashadow' => { 99 => 0x9 },
	'gammasharpnessstrength' => { 99 => 0x8 },
	'gammaunsharpmaskfineness' => { 99 => 0x6 },
	'gammaunsharpmaskstrength' => { 99 => 0x5 },
	'gammaunsharpmaskthreshold' => { 99 => 0x7 },
	'gammawhitepoint' => { 99 => 0xd },
	'geimagesize' => { 121 => 0x1304 },
	'gemake' => { 123 => 0x300 },
	'gemodel' => { 123 => 0x207 },
	'genre' => { 455 => 'Genre', 459 => 'genre', 469 => 'genre' },
	'genrecvid' => { 455 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 455 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 455 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 455 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 460 => 'geography' },
	'geologicalcontext' => { 112 => 'GeologicalContext' },
	'geologicalcontextbed' => { 112 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 112 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 112 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 112 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 112 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 114 => 'Geosync' },
	'geotag' => { 114 => 'Geotag' },
	'geotiffasciiparams' => { 113 => 0x87b1 },
	'geotiffdirectory' => { 113 => 0x87af },
	'geotiffdoubleparams' => { 113 => 0x87b0 },
	'geotime' => { 114 => 'Geotime' },
	'giftftppriority' => { 434 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 110 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 110 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 110 => 'GimbalYawDegree' },
	'globalaltitude' => { 349 => 0x419 },
	'globalangle' => { 349 => 0x40d },
	'good' => { 469 => 'good' },
	'googleplusuploadcode' => { 113 => 0x9009 },
	'gpsaltitude' => { 124 => 0x6, 151 => 'Altitude', 449 => 'GPSAltitude' },
	'gpsaltituderef' => { 124 => 0x5, 449 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 124 => 0x1c, 449 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 124 => 0x1d },
	'gpsdatetime' => { 151 => 'DateTime', 449 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 124 => 0x18, 151 => 'Bearing', 449 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 124 => 0x17, 449 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 124 => 0x1a, 151 => 'Distance', 449 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 124 => 0x19, 449 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 124 => 0x14, 449 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 124 => 0x13 },
	'gpsdestlongitude' => { 124 => 0x16, 449 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 124 => 0x15 },
	'gpsdifferential' => { 124 => 0x1e, 151 => 'Differential', 449 => 'GPSDifferential' },
	'gpsdop' => { 124 => 0xb, 449 => 'GPSDOP' },
	'gpshpositioningerror' => { 124 => 0x1f, 449 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 124 => 0x11, 449 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 124 => 0x10, 449 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 124 => 0x2, 151 => 'Latitude', 449 => 'GPSLatitude' },
	'gpslatituderef' => { 124 => 0x1 },
	'gpslongitude' => { 124 => 0x4, 151 => 'Longitude', 449 => 'GPSLongitude' },
	'gpslongituderef' => { 124 => 0x3 },
	'gpsmapdatum' => { 124 => 0x12, 151 => 'Datum', 449 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 124 => 0xa, 151 => 'MeasureMode', 449 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 124 => 0x1b, 449 => 'GPSProcessingMethod' },
	'gpssatellites' => { 124 => 0x8, 151 => 'Satellites', 449 => 'GPSSatellites' },
	'gpsspeed' => { 124 => 0xd, 151 => 'Speed', 449 => 'GPSSpeed' },
	'gpsspeedref' => { 124 => 0xc, 449 => 'GPSSpeedRef' },
	'gpsstatus' => { 124 => 0x9, 449 => 'GPSStatus' },
	'gpsstring' => { 131 => 0x402 },
	'gpstimestamp' => { 124 => 0x7 },
	'gpstrack' => { 124 => 0xf, 151 => 'Heading', 449 => 'GPSTrack' },
	'gpstrackref' => { 124 => 0xe, 449 => 'GPSTrackRef' },
	'gpsversionid' => { 124 => 0x0, 449 => 'GPSVersionID' },
	'gradation' => { 277 => 0x50f },
	'gradientbasedcorractive' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 445 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 445 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 445 => 'GrainAmount' },
	'graineffect' => { 121 => 0x1047 },
	'grainfrequency' => { 445 => 'GrainFrequency' },
	'grainsize' => { 445 => 'GrainSize' },
	'graymixeraqua' => { 445 => 'GrayMixerAqua' },
	'graymixerblue' => { 445 => 'GrayMixerBlue' },
	'graymixergreen' => { 445 => 'GrayMixerGreen' },
	'graymixermagenta' => { 445 => 'GrayMixerMagenta' },
	'graymixerorange' => { 445 => 'GrayMixerOrange' },
	'graymixerpurple' => { 445 => 'GrayMixerPurple' },
	'graymixerred' => { 445 => 'GrayMixerRed' },
	'graymixeryellow' => { 445 => 'GrayMixerYellow' },
	'graypoint' => { 424 => 0x8021 },
	'grayresponseunit' => { 113 => 0x122 },
	'greencurvelimits' => { 102 => 0x1c4 },
	'greencurvepoints' => { 101 => 0x53, 102 => 0x19a },
	'greenhsl' => { 97 => 0x20913 },
	'greenhue' => { 445 => 'GreenHue' },
	'greensaturation' => { 445 => 'GreenSaturation' },
	'griddisplay' => { 260 => '13.3', 261 => '4.3', 263 => '4.2', 264 => '4.2', 265 => '2.2', 269 => '10.5', 270 => '3.4', 271 => '6.1', 273 => '4.4', 274 => '4.2', 275 => '4.2' },
	'gripbatteryadload' => { 314 => 0x5 },
	'gripbatteryadnoload' => { 314 => 0x4 },
	'gripbatterystate' => { 314 => '1.2' },
	'groupareaafillumination' => { 261 => '46.4', 264 => '47.4', 273 => '47.4' },
	'h2resetblackpixels' => { 131 => 0x18a6 },
	'h3resetblackcolumns' => { 131 => 0x18ce },
	'h3resetblackpixels' => { 131 => 0x18b0 },
	'halftonehints' => { 113 => 0x141 },
	'hardlink' => { 114 => 'HardLink' },
	'hasalternative' => { 459 => 'hasAlternative' },
	'hascorrection' => { 459 => 'hasCorrection' },
	'hascorrectiona-lang' => { 459 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 459 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 459 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 445 => 'HasCrop' },
	'hasextendedxmp' => { 471 => 'HasExtendedXMP' },
	'hassettings' => { 445 => 'HasSettings' },
	'hastranslation' => { 459 => 'hasTranslation' },
	'hasvisibleoverprint' => { 474 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 474 => 'HasVisibleTransparency' },
	'hdr' => { 57 => 0x1, 204 => 0x4, 300 => 0x9e, 335 => 0x85, 391 => 0x200a },
	'hdreffect' => { 57 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 204 => 0x0 },
	'hdrlevel' => { 204 => 0x5, 381 => 0x2e, 396 => 0x17 },
	'hdrlevel2' => { 204 => 0x7 },
	'hdrsetting' => { 381 => 0x2d, 396 => 0x16, 399 => 0x1148, 400 => 0x1148, 401 => 0x1124, 402 => 0x11a0, 403 => 0x117c, 404 => 0x1034, 405 => 0x22c, 406 => 0x22c, 407 => 0x21f },
	'hdrshot' => { 300 => 0x76 },
	'hdrsmoothing' => { 204 => 0x6 },
	'headline' => { 125 => 0x69, 455 => 'Headline', 457 => 'Headline' },
	'hierarchicalkeywords' => { 162 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 162 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 162 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 162 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 162 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 436 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 305 => 0x1a },
	'highisomultipliergreen' => { 305 => 0x19 },
	'highisomultiplierred' => { 305 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 59 => 0x5, 78 => 0x202, 214 => 0xb1, 335 => 0x71, 379 => 0x2c, 380 => 0x26, 381 => 0x26, 391 => 0x2009, 396 => 0x12, 420 => 0x42 },
	'highisonoisereduction2' => { 391 => 0xb050 },
	'highlight' => { 371 => 0xf },
	'highlightadj' => { 97 => 0x2030c },
	'highlightcolordistortreduct' => { 424 => 0x8026 },
	'highlightlinearitylimit' => { 368 => 0xa025 },
	'highlightprotection' => { 252 => 0x6 },
	'highlightrecovery' => { 445 => 'HighlightRecovery' },
	'highlights' => { 438 => 'Highlights' },
	'highlights2012' => { 445 => 'Highlights2012' },
	'highlightsadj' => { 424 => 0x9019 },
	'highlightshadow' => { 300 => 0xad },
	'highlighttone' => { 121 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 59 => 0x3, 78 => 0x203 },
	'highlightwarning' => { 300 => 0x8002 },
	'highlowkeyadj' => { 335 => 0x6c },
	'highspeedsync' => { 174 => 0x5, 379 => 0x2, 380 => 0x2 },
	'histogramxml' => { 253 => 0x83a1a25 },
	'history' => { 457 => 'History', 470 => 'History' },
	'historyaction' => { 470 => [\'History','HistoryAction'] },
	'historychanged' => { 470 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 470 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 470 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 470 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 470 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 131 => 0xc88 },
	'holefilldeltathreshold' => { 131 => 0xc7e },
	'hometowncity' => { 107 => 0x3006, 335 => 0x23, 341 => 0x2 },
	'hometowncitycode' => { 342 => 0x1000 },
	'hometowndst' => { 335 => 0x25, 341 => '0.2' },
	'hostcomputer' => { 113 => 0x13c },
	'hostsoftwarerendering' => { 131 => 0xce7 },
	'hue' => { 179 => 0x3b, 217 => 0x3d, 335 => 0x67 },
	'hueadj' => { 256 => 0x2f, 424 => 0x8019 },
	'hueadjust' => { 361 => 0x1016 },
	'hueadjustment' => { 172 => 0x4a, 173 => 0x40, 214 => 0x92, 216 => 0x36 },
	'hueadjustmentaqua' => { 445 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 445 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 445 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 445 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 445 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 445 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 445 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 445 => 'HueAdjustmentYellow' },
	'huesetting' => { 285 => 0x1011 },
	'humanobservation' => { 112 => 'HumanObservation' },
	'humanobservationday' => { 112 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 112 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 112 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 112 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 112 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 112 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 112 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 112 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 112 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 112 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 112 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 112 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 112 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 112 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 112 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 112 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 112 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 112 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 112 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 112 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 113 => 0x9401, 450 => 'Humidity' },
	'icc_profile' => { 114 => 'ICC_Profile' },
	'iccprofilename' => { 457 => 'ICCProfile' },
	'idccreativestyle' => { 424 => 0x8000 },
	'idcpreviewlength' => { 424 => 0x202 },
	'idcpreviewstart' => { 424 => 0x201 },
	'identification' => { 112 => 'Identification' },
	'identificationid' => { 112 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 112 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 112 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 112 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 112 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 112 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 446 => 'identifier', 467 => 'Identifier' },
	'ifcameramodel' => { 131 => 0x9c8 },
	'illumination' => { 271 => '0.5', 357 => 0x48 },
	'imageabsolutex' => { 131 => 0x3fe },
	'imageabsolutey' => { 131 => 0x3ff },
	'imageadjustment' => { 214 => 0x80, 243 => 0x5 },
	'imagealterationconstraints' => { 287 => 'ImageAlterationConstraints' },
	'imagearea' => { 226 => 0x10, 229 => 0x10 },
	'imageareaoffset' => { 335 => 0x38 },
	'imageauthentication' => { 214 => 0x20 },
	'imageboundary' => { 214 => 0x16 },
	'imagecount' => { 121 => 0x1438, 214 => 0xa5, 394 => 0x11b, 409 => 0x32, 410 => 0x3a },
	'imagecount2' => { 409 => 0x4c, 410 => [0x52,0x58] },
	'imagecount3' => { 409 => [0x1a0,0x1aa,0x1bd], 410 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 287 => 'ImageCreator' },
	'imagecreatorid' => { 287 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 287 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 287 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 131 => 0x41f },
	'imagecropy' => { 131 => 0x420 },
	'imagedata' => { 431 => 'Data' },
	'imagedatasize' => { 214 => 0xa2 },
	'imagedescription' => { 113 => 0x10e, 465 => 'ImageDescription' },
	'imageduplicationconstraints' => { 287 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 253 => 0xfe443a45 },
	'imageeditcount' => { 335 => 0x41 },
	'imageediting' => { 335 => 0x32 },
	'imageeffects' => { 361 => 0x1010 },
	'imagefileconstraints' => { 287 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 287 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 287 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 121 => 0x1436 },
	'imageheight' => { 113 => 0x101, 178 => 0xc, 344 => 0x10d, 429 => 'ImageHeight', 465 => 'ImageLength' },
	'imagehistory' => { 113 => 0x9213, 448 => 'ImageHistory' },
	'imageidnumber' => { 295 => 0x340 },
	'imagemimetype' => { 431 => 'Mime' },
	'imagenumber' => { 113 => 0x9211, 147 => 'ImageNumber', 172 => 0xae, 173 => 0x5e, 344 => 0x113, 379 => 0x9b, 381 => [0x400,'276.1',0x314], 441 => 'ImageNumber' },
	'imagenumber2' => { 173 => 0x62 },
	'imageoptimization' => { 214 => 0xa9 },
	'imageorientation' => { 125 => 0x83 },
	'imageprocessing' => { 214 => 0x1a },
	'imageprocessingfiledatecreated' => { 131 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 131 => 0xc80 },
	'imageprocessingversion' => { 281 => 0x0 },
	'imagequality' => { 147 => 'ImageQuality', 228 => '723.2', 229 => '732.2', 238 => '708.1', 300 => 0x1 },
	'imagequality2' => { 277 => 0x603 },
	'imagerank' => { 434 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 131 => 0x600 },
	'imagerboardversion' => { 131 => 0x439 },
	'imagercols' => { 131 => 0x17d4 },
	'imageref' => { 453 => 'ImageRef' },
	'imageresolution' => { 131 => 0x944 },
	'imageresolutionjpg' => { 131 => 0x945 },
	'imagereview' => { 262 => '0.4', 271 => '0.4' },
	'imagereviewmonitorofftime' => { 261 => '21.1', 263 => '21.1', 264 => '21.1', 268 => '20.1', 273 => '21.1', 274 => '21.1' },
	'imagereviewtime' => { 260 => '25.1', 262 => '2.1', 265 => '19.1', 266 => '20.1', 267 => '20.1', 269 => '9.2', 270 => '20.1', 275 => '21.2' },
	'imagerfiledatecreated' => { 131 => 0x9c5 },
	'imagerfileproductionlevel' => { 131 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 131 => 0x9c7 },
	'imagerpowerondelaymsec' => { 131 => 0x5fd },
	'imagerrows' => { 131 => 0x17de },
	'imagesegmentlines' => { 131 => 0x184d },
	'imagesegmentstartline' => { 131 => 0x184c },
	'imagesize' => { 153 => 'ImageSize' },
	'imagesizerestriction' => { 462 => 'imageSizeRestriction' },
	'imagesourcedata' => { 113 => 0x935c },
	'imagespace' => { 131 => 0x909 },
	'imagestabilization' => { 33 => 0x22, 107 => 0x3020, 121 => 0x1422, 147 => 'ImageStabilization', 172 => 0xbd, 173 => 0x71, 174 => 0x57, 175 => 0x0, 176 => [0x18,0x107,0x113], 177 => 0x49c2, 214 => 0xac, 277 => 0x604, 280 => 0x1600, 300 => 0x1a, 384 => 0x12, 385 => 0x11, 391 => 0xb026 },
	'imagestabilization2' => { 383 => 0xa },
	'imagestabilizationsetting' => { 177 => 0x14, 379 => 0x3d, 380 => 0x3d, 390 => 0x14 },
	'imagestyle' => { 379 => 0x2d, 380 => 0x27 },
	'imagesupplier' => { 287 => 'ImageSupplier' },
	'imagesupplierid' => { 287 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 287 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 287 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 115 => 0x1 },
	'imagetemperaturemin' => { 115 => 0x2 },
	'imagetone' => { 335 => 0x4f },
	'imagetype' => { 125 => 0x82, 287 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 60 => 0x28, 113 => 0xa420, 448 => 'ImageUniqueID', 449 => 'ImageUniqueID' },
	'imagewidth' => { 113 => 0x100, 178 => 0xe, 344 => 0x10c, 429 => 'ImageWidth', 465 => 'ImageWidth' },
	'inclinationangle' => { 424 => 0x900f },
	'inclinationcorrection' => { 424 => 0x900e },
	'incrementaltemperature' => { 445 => 'IncrementalTemperature' },
	'incrementaltint' => { 445 => 'IncrementalTint' },
	'industry' => { 459 => 'industry', 460 => 'industry' },
	'infobuttonwhenshooting' => { 78 => 0x409 },
	'infraredilluminator' => { 356 => 0x28 },
	'ingredientexclusion' => { 461 => 'ingredientExclusion' },
	'ingredients' => { 470 => 'Ingredients' },
	'ingredientsalternatepaths' => { 470 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 470 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 470 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 470 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 470 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 470 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 470 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 470 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 470 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 470 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 470 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 470 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 470 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 470 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 470 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 470 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 470 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 470 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 470 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 470 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 470 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 470 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 470 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 78 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 432 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 432 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 432 => 'InitialViewHeadingDegrees', 433 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 432 => 'InitialViewPitchDegrees', 433 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 432 => 'InitialViewRollDegrees', 433 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 260 => '4.4' },
	'initialzoomsetting' => { 260 => '9.3', 269 => '27.3' },
	'inkset' => { 113 => 0x14c },
	'inputprofile' => { 131 => 0x1389 },
	'instanceid' => { 470 => 'InstanceID' },
	'instantplaybacksetup' => { 174 => 0x3e },
	'instantplaybacktime' => { 174 => 0x3d },
	'instructions' => { 457 => 'Instructions' },
	'instrument' => { 469 => 'instrument' },
	'integrationtime' => { 131 => 0x423 },
	'intellectualgenre' => { 454 => 'IntellectualGenre' },
	'intelligentauto' => { 391 => 0xb052, 416 => 0xd, 417 => 0xe, 418 => 0xd },
	'intelligentcontrast' => { 49 => 0x4 },
	'intelligentd-range' => { 300 => 0x79 },
	'intelligentexposure' => { 300 => 0x5d },
	'intelligentresolution' => { 300 => 0x70 },
	'interchangecolorspace' => { 127 => 0x40 },
	'internalflash' => { 171 => 0x2b, 260 => '23.1', 262 => '8.1', 265 => '22.1', 267 => '23.1', 271 => '8.1', 275 => '24.1', 280 => 0x1208 },
	'internalflashae1' => { 282 => 0x1021 },
	'internalflashae1_0' => { 282 => 0x101d },
	'internalflashae2' => { 282 => 0x1022 },
	'internalflashae2_0' => { 282 => 0x101e },
	'internalflashmode' => { 323 => 0x1 },
	'internalflashstrength' => { 323 => 0x3 },
	'internalflashtable' => { 282 => 0x1024 },
	'internallensserialnumber' => { 368 => 0xa005 },
	'internalndfilter' => { 300 => 0x9d },
	'internalserialnumber' => { 60 => 0x96, 71 => 0x9, 121 => 0x10, 177 => 0x49dc, 276 => 0x18, 278 => 0x102, 297 => 0x500, 300 => 0x25, 315 => 0x4, 361 => 0x5, 409 => [0x7c,0xf0], 410 => 0x88 },
	'interopindex' => { 113 => 0x1, 450 => 'InteroperabilityIndex' },
	'interopversion' => { 113 => 0x2 },
	'intervallength' => { 171 => 0x10 },
	'intervalmode' => { 171 => 0x26 },
	'intervalnumber' => { 171 => 0x11 },
	'intervalshooting' => { 335 => 0x92 },
	'introtime' => { 469 => 'introTime' },
	'introtimescale' => { 469 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 469 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 131 => 0xdae },
	'ipfcameramodel' => { 131 => 0xe4d },
	'iptc' => { 114 => 'IPTC' },
	'iptc-naa' => { 113 => 0x83bb, 305 => 0x83bb },
	'iptcbitspersample' => { 127 => 0x56 },
	'iptcdigest' => { 349 => 0x425 },
	'iptcimageheight' => { 127 => 0x1e },
	'iptcimagerotation' => { 127 => 0x66 },
	'iptcimagewidth' => { 127 => 0x14 },
	'iptclastedited' => { 455 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 127 => 0xa },
	'iptcpixelheight' => { 127 => 0x32 },
	'iptcpixelwidth' => { 127 => 0x28 },
	'isalternativeof' => { 459 => 'isAlternativeOf' },
	'isbn' => { 459 => 'isbn' },
	'iscorrectionof' => { 459 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 103 => 0x3 },
	'ismergedhdr' => { 441 => 'IsMergedHDR' },
	'ismergedpanorama' => { 441 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 106 => 0x14, 107 => [0x3014,0x14], 113 => 0x8827, 130 => 0xfd06, 131 => 0x1784, 133 => 0x60, 135 => [0xfa2e,0xfa46], 136 => [0x27,0x28], 137 => 0xf105, 140 => 0x14, 142 => 0x4e, 145 => 0x34, 147 => 'ISO', 171 => 0x8, 177 => 0x49ba, 205 => 0x0, 214 => 0x2, 305 => 0x17, 335 => [0x8b,0x14], 342 => 0x14, 344 => 0x105, 368 => 0xa014, 390 => 0x6f, 396 => [0x1f,0x21,0x25], 449 => 'ISOSpeedRatings' },
	'iso2' => { 205 => 0x6, 223 => 0x265, 224 => 0x25c, 225 => 0x265, 226 => 0x221, 227 => 0x25d, 228 => 0x256, 229 => 0x25d, 233 => 0x2b5, 236 => 0x265, 242 => 0x2b5 },
	'isoauto' => { 316 => '14.4' },
	'isoautohilimit' => { 231 => 0x18eb, 232 => 0xe82, 240 => 0x185d },
	'isoautoparameters' => { 335 => 0x7a },
	'isoautoshuttertime' => { 231 => 0x18ea, 232 => 0xe81, 240 => 0x185c },
	'isocalibrationgain' => { 131 => 0x89f },
	'isodisplay' => { 263 => '4.1', 264 => '4.1', 265 => '2.3', 266 => '3.3', 267 => '3.3', 270 => '3.3', 273 => '4.3', 274 => '4.1', 275 => '4.3' },
	'isoexpansion' => { 78 => 0x103, 79 => 0x7, 80 => 0x8, 83 => 0x8, 205 => 0x4 },
	'isoexpansion2' => { 205 => 0xa },
	'isofloor' => { 316 => 0x6 },
	'isoselection' => { 214 => 0xf },
	'isosensitivitystep' => { 268 => '6.2', 270 => '6.2' },
	'isosetting' => { 133 => 0x5e, 147 => 'ISOSetting', 171 => 0x24, 172 => 0x26, 173 => 0x1c, 174 => 0x13, 179 => 0x6, 214 => 0x13, 316 => '17.3', 360 => 0x27, 379 => 0x16, 380 => 0x14, 381 => 0x2, 390 => 0x6d },
	'isospeed' => { 113 => 0x8833, 450 => 'ISOSpeed' },
	'isospeedexpansion' => { 77 => 0x3 },
	'isospeedincrements' => { 78 => 0x102 },
	'isospeedlatitudeyyy' => { 113 => 0x8834, 450 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 113 => 0x8835, 450 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 78 => 0x103 },
	'isostepsize' => { 260 => '6.1', 261 => '7.2', 263 => '7.2', 264 => '7.2', 269 => '4.1', 273 => '7.2', 274 => '7.2' },
	'isovalue' => { 282 => 0x1001 },
	'issn' => { 459 => 'issn' },
	'issueidentifier' => { 459 => 'issueIdentifier' },
	'issuename' => { 459 => 'issueName' },
	'issueteaser' => { 459 => 'issueTeaser' },
	'issuetype' => { 459 => 'issueType' },
	'istranslationof' => { 459 => 'isTranslationOf' },
	'itemsubtype' => { 169 => 'ItemSubType' },
	'jobid' => { 125 => 0xb8 },
	'jobname' => { 451 => 'JobName' },
	'jobref' => { 468 => 'JobRef' },
	'jobrefid' => { 468 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 468 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 468 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 451 => 'JobStatus' },
	'jpeghandling' => { 445 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 300 => 0x43, 302 => 0x3034, 391 => 0xb047 },
	'jpegsize' => { 302 => 0x303a },
	'jpgcompression' => { 232 => 0x7d4 },
	'jpgfromraw' => { 91 => 0x2007, 108 => 'JpgFromRaw', 305 => 0x2e },
	'jpgfromrawlength' => { 113 => [0x117,0x202] },
	'jpgfromrawstart' => { 113 => [0x111,0x201] },
	'jpgrecordedpixels' => { 316 => '14.1' },
	'jurisdiction' => { 442 => 'jurisdiction' },
	'kelvinwb_01' => { 324 => 0x5 },
	'kelvinwb_02' => { 324 => 0x9 },
	'kelvinwb_03' => { 324 => 0xd },
	'kelvinwb_04' => { 324 => 0x11 },
	'kelvinwb_05' => { 324 => 0x15 },
	'kelvinwb_06' => { 324 => 0x19 },
	'kelvinwb_07' => { 324 => 0x1d },
	'kelvinwb_08' => { 324 => 0x21 },
	'kelvinwb_09' => { 324 => 0x25 },
	'kelvinwb_10' => { 324 => 0x29 },
	'kelvinwb_11' => { 324 => 0x2d },
	'kelvinwb_12' => { 324 => 0x31 },
	'kelvinwb_13' => { 324 => 0x35 },
	'kelvinwb_14' => { 324 => 0x39 },
	'kelvinwb_15' => { 324 => 0x3d },
	'kelvinwb_16' => { 324 => 0x41 },
	'kelvinwb_daylight' => { 324 => 0x1 },
	'kerneldenominators' => { 131 => 0x933 },
	'key' => { 469 => 'key' },
	'keystonecompensation' => { 281 => 0x1900 },
	'keystonedirection' => { 281 => 0x1901 },
	'keystonevalue' => { 281 => 0x1906 },
	'keyword' => { 459 => 'keyword' },
	'keywordinfo' => { 162 => 'Keywords' },
	'keywords' => { 125 => 0x19, 148 => 'Keywords', 286 => 'Keywords', 351 => 'Keywords', 439 => 'keywords', 456 => 'Keywords', 467 => 'Keywords' },
	'killdate' => { 459 => 'killDate' },
	'killdatea-platform' => { 459 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 459 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 130 => 0xf908, 133 => 0xe, 135 => [0xfa1e,0xfa52], 141 => 0x70 },
	'kodakimagewidth' => { 130 => 0xf907, 133 => 0xc, 135 => [0xfa1d,0xfa51], 141 => 0x6c },
	'kodakinfotype' => { 130 => 0xfa00 },
	'kodaklook' => { 131 => 0xe4c },
	'kodaklookprofile' => { 131 => 0x138a },
	'kodakmaker' => { 141 => 0x8 },
	'kodakmodel' => { 133 => 0x0, 141 => 0x28 },
	'kodaktag' => { 131 => 0x3ea },
	'kodakversion' => { 131 => 0x0 },
	'label' => { 290 => 'Label', 467 => 'Label' },
	'labelname1' => { 453 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 453 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 300 => 0x6f },
	'landscapeoutputhighlightpoint' => { 103 => 0x26 },
	'landscapeoutputshadowpoint' => { 103 => 0x27 },
	'landscaperawcolortone' => { 103 => 0x1f },
	'landscaperawcontrast' => { 103 => 0x21 },
	'landscaperawhighlight' => { 103 => 0x77 },
	'landscaperawhighlightpoint' => { 103 => 0x24 },
	'landscaperawlinear' => { 103 => 0x22 },
	'landscaperawsaturation' => { 103 => 0x20 },
	'landscaperawshadow' => { 103 => 0x80 },
	'landscaperawshadowpoint' => { 103 => 0x25 },
	'landscaperawsharpness' => { 103 => 0x23 },
	'landscapeunsharpmaskfineness' => { 103 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 103 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 103 => 0xa2 },
	'language' => { 446 => 'language' },
	'languageidentifier' => { 125 => 0x87 },
	'largestvalidinteriorrectheight' => { 432 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 432 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 432 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 432 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 171 => 0x1b },
	'lastkeywordiptc' => { 169 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 169 => 'LastKeywordXMP' },
	'lastphotodate' => { 432 => 'LastPhotoDate' },
	'lasturl' => { 470 => 'LastURL' },
	'lateralchromaticaberration' => { 391 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 441 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 112 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 112 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 112 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 326 => 0x2 },
	'lc10' => { 326 => 0xb },
	'lc11' => { 326 => 0xc },
	'lc12' => { 326 => 0xd },
	'lc14' => { 326 => 0xf },
	'lc15' => { 326 => 0x10 },
	'lc3' => { 326 => 0x4 },
	'lc4' => { 326 => 0x5 },
	'lc5' => { 326 => 0x6 },
	'lc6' => { 326 => 0x7 },
	'lc7' => { 326 => 0x8 },
	'lc8' => { 326 => 0x9 },
	'lcddisplayatpoweron' => { 78 => 0x811, 82 => 0xa },
	'lcddisplayreturntoshoot' => { 83 => 0x12 },
	'lcdillumination' => { 260 => '17.5', 261 => '5.2', 263 => '5.1', 264 => '5.1', 269 => '10.3', 270 => '4.2', 273 => '5.2', 274 => '5.1', 275 => '5.4' },
	'lcdilluminationduringbulb' => { 78 => 0x408 },
	'lcdmatrix' => { 131 => 0xe74 },
	'lcdmatrixchickfix' => { 131 => 0xe75 },
	'lcdmatrixmarvin' => { 131 => 0xe76 },
	'lcdpanels' => { 77 => 0x8 },
	'lcheditor' => { 253 => 0x8ae85e },
	'legacyiptcdigest' => { 457 => 'LegacyIPTCDigest' },
	'legalcode' => { 442 => 'legalcode' },
	'lens' => { 113 => 0xfdea, 214 => 0x84, 441 => 'Lens' },
	'lensafstopbutton' => { 76 => 0x11, 77 => 0x13, 78 => 0x506, 79 => 0x10, 80 => 0x12, 83 => 0x13, 84 => 0x9 },
	'lensaperturerange' => { 371 => [0x30,0x48] },
	'lenscorrectionsettings' => { 448 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 441 => 'LensDistortInfo' },
	'lensdistortionparams' => { 282 => 0x206 },
	'lensdrivenoaf' => { 78 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 381 => 0x3f0, 423 => 0xd },
	'lensfirmware' => { 362 => 0x20, 368 => 0xa004 },
	'lensfirmwareversion' => { 278 => 0x204, 300 => 0x60, 381 => 0x3f3, 423 => 0x14 },
	'lensfocallength' => { 97 => 0xf0512, 326 => 0x9 },
	'lensfocalrange' => { 371 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 261 => '55.1', 263 => '52.1', 264 => '52.1', 273 => '52.1', 274 => '52.1' },
	'lensformat' => { 403 => 0x1891, 405 => 0x18bd, 406 => 0x18ed, 407 => 0x17f1, 409 => 0x106, 410 => 0x106, 419 => 0x603, 420 => 0x5d },
	'lensfstops' => { 206 => 0x7, 207 => 0xc, 208 => 0xd, 212 => 0xe, 214 => 0x8b, 326 => '0.3' },
	'lensid' => { 441 => 'LensID' },
	'lensidnumber' => { 206 => 0x6, 207 => 0xb, 208 => 0xc, 212 => 0xd },
	'lensinfo' => { 113 => 0xa432, 332 => 0x2a, 441 => 'LensInfo', 450 => 'LensSpecification' },
	'lenskind' => { 326 => 0x1 },
	'lensmake' => { 113 => 0xa433, 154 => 'Make', 450 => 'LensMake' },
	'lensmanualdistortionamount' => { 445 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 169 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 371 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 60 => 0x95, 113 => 0xa434, 154 => 'Model', 169 => 'LensModel', 209 => 0x18a, 210 => 0x18b, 211 => 0x2ac, 278 => 0x203, 332 => 0xc, 344 => 0x412, 450 => 'LensModel' },
	'lensmodulationoptimizer' => { 121 => 0x1045 },
	'lensmount' => { 381 => 0x99, 403 => 0x1892, 405 => 0x18be, 406 => 0x18ee, 407 => 0x17f2, 409 => 0x105, 410 => 0x105, 419 => 0x604, 420 => 0x5e },
	'lensmount2' => { 423 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 445 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 445 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 445 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 445 => 'LensProfileEnable' },
	'lensprofilefilename' => { 445 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 445 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 445 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 445 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 445 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 445 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 445 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 445 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 445 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 445 => 'LensProfileName' },
	'lensprofilesetup' => { 445 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 445 => 'LensProfileVignettingScale' },
	'lensproperties' => { 278 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 58 => 0x0, 113 => 0xa435, 154 => 'SerialNumber', 278 => 0x202, 298 => 0x321, 300 => 0x52, 362 => 0x30, 441 => 'LensSerialNumber', 450 => 'LensSerialNumber' },
	'lensshutterlock' => { 174 => 0x4a },
	'lensspec' => { 376 => 0x0, 377 => 0x0, 378 => 0x0, 391 => 0xb02a },
	'lensspecfeatures' => { 409 => [0x115,0x116], 410 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 282 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 176 => 0x10c, 177 => 0x49bd, 214 => 0x83, 278 => 0x201, 291 => 0x16, 295 => 0x310, 297 => 0x303, 298 => 0x303, 300 => 0x51, 302 => 0x3405, 327 => 0x0, 328 => 0x0, 329 => 0x1, 330 => 0x1, 331 => 0x1, 333 => 0x0, 368 => 0xa003, 371 => 0x27, 391 => 0xb027, 403 => 0x1896, 405 => 0x18c2, 406 => 0x18f2, 407 => 0x17f6, 409 => 0x109, 410 => 0x109, 419 => 0x608, 420 => 0x62 },
	'lenstype2' => { 381 => 0x3f7, 403 => 0x1893, 405 => 0x18bf, 406 => 0x18ef, 407 => 0x17f3, 409 => 0x107, 410 => 0x107, 419 => 0x605, 420 => 0x60 },
	'lenstype3' => { 423 => 0x9 },
	'lenszoomposition' => { 416 => 0x19, 417 => 0x1e, 420 => [0x342,0x35a] },
	'levelindicator' => { 308 => 0x15 },
	'levelorientation' => { 334 => 0x0 },
	'license' => { 442 => 'license' },
	'licensee' => { 287 => 'Licensee' },
	'licenseeid' => { 287 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 287 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 287 => 'LicenseeImageNotes' },
	'licenseename' => { 287 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 287 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 287 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 287 => 'LicenseeTransactionID' },
	'licenseid' => { 287 => 'LicenseID' },
	'licensestartdate' => { 287 => 'LicenseStartDate' },
	'licensetransactiondate' => { 287 => 'LicenseTransactionDate' },
	'licensetype' => { 447 => 'licensetype' },
	'licensor' => { 287 => 'Licensor' },
	'licensorcity' => { 287 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 287 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 287 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 287 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 287 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 287 => 'LicensorImageID' },
	'licensorname' => { 287 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 287 => 'LicensorNotes' },
	'licensorpostalcode' => { 287 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 287 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 287 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 287 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 287 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 287 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 287 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 287 => 'LicensorTransactionID' },
	'licensorurl' => { 287 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 282 => 0x1009 },
	'lightingmode' => { 107 => 0x302a },
	'lightreading' => { 335 => 0x15 },
	'lightsource' => { 113 => 0x9208, 214 => 0x90, 285 => 0x1000, 449 => 'LightSource' },
	'lightsourcespecial' => { 370 => 0x21d },
	'lightswitch' => { 273 => '0.1', 275 => '0.1' },
	'lightvaluecenter' => { 282 => 0x103d },
	'lightvalueperiphery' => { 282 => 0x103e },
	'limitafareamodeselection' => { 261 => '51.1', 263 => '49.1', 264 => '49.1', 273 => '49.1', 274 => '49.1' },
	'linearitylimitblue' => { 305 => 0x10 },
	'linearitylimitgreen' => { 305 => 0xf },
	'linearitylimitred' => { 305 => 0xe },
	'linearityuppermargin' => { 42 => [0x2ba,0x2d1,0x2d5], 44 => 0x1e5, 45 => [0x1fe,0x2de], 46 => [0x232,0x310], 47 => 0x31e },
	'linearizationtable' => { 113 => 0xc618 },
	'linearresponselimit' => { 113 => 0xc62e },
	'link' => { 459 => 'link' },
	'linkaetoafpoint' => { 316 => '14.2' },
	'linkedencodedrightsexpr' => { 455 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 455 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 455 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 455 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 131 => 0x904 },
	'lithostratigraphicterms' => { 112 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 265 => '32.1', 275 => '34.1' },
	'liveviewafareamode' => { 270 => '34.1' },
	'liveviewafmethod' => { 396 => 0x20 },
	'liveviewafmode' => { 270 => '34.2' },
	'liveviewafsetting' => { 381 => 0x36 },
	'liveviewbuttonoptions' => { 261 => '50.2', 263 => '48.2', 264 => '48.2', 273 => '48.2', 274 => '48.2' },
	'liveviewexposuresimulation' => { 78 => 0x810 },
	'liveviewfocusmode' => { 381 => [0x8b,0x28b] },
	'liveviewmetering' => { 381 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 261 => '21.2', 263 => '21.2', 264 => '21.2', 266 => '20.2', 267 => '20.2', 268 => '20.2', 270 => '20.2', 273 => '21.2', 274 => '21.2' },
	'liveviewshooting' => { 54 => 0x13 },
	'livingspecimen' => { 112 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 112 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 125 => 0x79 },
	'localizedcameramodel' => { 113 => 0xc615 },
	'locallocationname' => { 368 => 0x30 },
	'location' => { 213 => 0x9, 300 => 0x67, 437 => 'Location', 454 => 'Location', 458 => 'location', 459 => 'location' },
	'locationareacode' => { 443 => 'lac' },
	'locationcreated' => { 455 => 'LocationCreated' },
	'locationcreatedcity' => { 455 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 455 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 455 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 455 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 455 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 455 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 455 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 455 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 455 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 455 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 455 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 455 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 213 => 0x0 },
	'locationname' => { 368 => 0x31 },
	'locationshown' => { 455 => 'LocationShown' },
	'locationshowncity' => { 455 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 455 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 455 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 455 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 455 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 455 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 455 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 455 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 455 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 455 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 455 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 455 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 78 => 0x709 },
	'logcomment' => { 469 => 'logComment' },
	'logscale' => { 131 => 0x902 },
	'longexposurenoisereduction' => { 59 => 0x4, 78 => 0x201, 79 => 0x1, 80 => 0x2, 81 => 0x1, 82 => 0x1, 83 => 0x2, 84 => 0x1, 300 => 0x49, 379 => 0x2b, 380 => 0x25, 381 => 0x25, 391 => 0x2008, 396 => 0x11, 420 => 0x44 },
	'longexposurenoisereduction2' => { 54 => 0x8 },
	'loop' => { 469 => 'loop' },
	'lowestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 445 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 445 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 445 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 445 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 445 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 445 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 445 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 445 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 102 => 0x150 },
	'luminancecurvepoints' => { 102 => 0x126 },
	'luminancenoisereduction' => { 97 => 0x20600, 103 => 0x5f, 371 => 0x1b },
	'luminancenoisereductioncontrast' => { 445 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 445 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 103 => 0x6d },
	'luminancesmoothing' => { 445 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 78 => [0x40b,0x40c] },
	'lyrics' => { 469 => 'lyrics' },
	'm16cversion' => { 295 => 0x333 },
	'macatom' => { 444 => 'macAtom' },
	'macatomapplicationcode' => { 444 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 444 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 444 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 112 => 'MachineObservation' },
	'machineobservationday' => { 112 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 112 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 112 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 112 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 112 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 112 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 112 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 112 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 112 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 112 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 112 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 112 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 112 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 112 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 112 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 112 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 112 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 112 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 112 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 112 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 121 => 0x1020, 123 => 0x202, 282 => 0x202, 360 => 0x21, 370 => 0x202, 391 => 0xb040 },
	'macroled' => { 280 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 54 => 0x10 },
	'macromode' => { 33 => 0x1, 171 => 0xb, 277 => 0x300, 300 => 0x1c, 361 => 0x1009 },
	'magentahsl' => { 97 => 0x20917 },
	'magicfilter' => { 277 => 0x52c },
	'magnifiedview' => { 80 => 0x11, 82 => 0x9 },
	'mainboardversion' => { 131 => 0x438 },
	'maindialexposurecomp' => { 271 => '0.6' },
	'mainingredient' => { 461 => 'mainIngredient' },
	'majorversion' => { 435 => 'MajorVersion' },
	'make' => { 92 => 0x0, 109 => 0x1, 113 => 0x10f, 147 => 'Make', 290 => 'Make', 305 => 0x10f, 458 => 'make', 465 => 'Make' },
	'makernote' => { 449 => 'MakerNote' },
	'makernoteapple' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecanon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotedji' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteflir' => { 111 => 'MakN', 113 => 0x927c },
	'makernotefujifilm' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehasselblad' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteisl' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvc' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvctext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak10' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak11' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak12' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak7' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8c' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak9' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodakunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekyocera' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica3' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica4' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica5' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica7' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica8' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica9' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotemotorola' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenintendo' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteoffset' => { 370 => 0xff },
	'makernoteolympus' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteolympus2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax6' => { 111 => 'MakN', 113 => 0x927c },
	'makernotephaseone' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohtext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesafety' => { 113 => 0xc635 },
	'makernotesamsung1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyo' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyoc4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyopatch' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesigma' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonyericsson' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonysrf' => { 111 => 'MakN', 113 => 0x927c },
	'makernotetype' => { 361 => 0x1 },
	'makernoteunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknownbinary' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknowntext' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteversion' => { 176 => 0x0, 214 => 0x1, 282 => 0x0, 300 => 0x8000, 365 => 0x0, 368 => 0x1, 371 => [0x1d,0x1f], 382 => 0x2000 },
	'managedfrom' => { 470 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 470 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 470 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 470 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 470 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 470 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 470 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 470 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 470 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 470 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 470 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 470 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 470 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 470 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 470 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 470 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 470 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 470 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 470 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 470 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 470 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 470 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 470 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 470 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 470 => 'Manager' },
	'managervariant' => { 470 => 'ManagerVariant' },
	'manageto' => { 470 => 'ManageTo' },
	'manageui' => { 470 => 'ManageUI' },
	'manifest' => { 470 => 'Manifest' },
	'manifestlinkform' => { 470 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 470 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 470 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 470 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 470 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 470 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 470 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 470 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 470 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 470 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 470 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 470 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 470 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 470 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 470 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 470 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 470 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 470 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 470 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 470 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 470 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 470 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 470 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 470 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 470 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 470 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 470 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 470 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 277 => 0x900, 300 => 0x86 },
	'manometerreading' => { 277 => 0x901 },
	'manualafpointselectpattern' => { 78 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 280 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 262 => '8.2', 265 => '22.2', 266 => '23.1', 267 => '23.2', 269 => '16.2', 270 => '23.2', 271 => '8.2', 272 => '23.2', 275 => '24.2', 361 => 0x100c },
	'manualflashstrength' => { 277 => 0x406 },
	'manualfocusdistance' => { 214 => 0x85, 282 => 0x100c, 370 => 0x223 },
	'manualtv' => { 77 => 0x5, 78 => 0x705 },
	'manufacturedate' => { 181 => 0x6705, 315 => 0x1 },
	'manufacturedate1' => { 363 => 0x4 },
	'manufacturedate2' => { 363 => 0x5 },
	'manufacturer' => { 429 => 'Manufacturer', 458 => 'manufacturer' },
	'mariahchromablursize' => { 131 => 0xf0d },
	'mariahmaphithreshold' => { 131 => 0xf0c },
	'mariahmaplothreshold' => { 131 => 0xf0b },
	'mariahsigmathreshold' => { 131 => 0xf0e },
	'mariahtexturethreshold' => { 131 => 0xf0a },
	'marked' => { 456 => 'Marked', 473 => 'Marked' },
	'markers' => { 469 => 'markers' },
	'markerscomment' => { 469 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 469 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 469 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 469 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 469 => [\'markers','markersCuePointType'] },
	'markersduration' => { 469 => [\'markers','markersDuration'] },
	'markerslocation' => { 469 => [\'markers','markersLocation'] },
	'markersname' => { 469 => [\'markers','markersName'] },
	'markersprobability' => { 469 => [\'markers','markersProbability'] },
	'markersspeaker' => { 469 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 469 => [\'markers','markersStartTime'] },
	'markerstarget' => { 469 => [\'markers','markersTarget'] },
	'markerstype' => { 469 => [\'markers','markersType'] },
	'maskedareas' => { 113 => 0xc68e },
	'masterdocumentid' => { 125 => 0xb9 },
	'mastergain' => { 221 => 0x50 },
	'materialsample' => { 112 => 'MaterialSample' },
	'materialsampleid' => { 112 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 261 => '50.1', 263 => '48.1', 264 => '48.1', 273 => '48.1', 274 => '48.1' },
	'matrixselectk' => { 131 => 0x91b },
	'matrixselectthreshold' => { 131 => 0x91a },
	'matrixselectthreshold1' => { 131 => 0x91e },
	'matrixselectthreshold2' => { 131 => 0x91f },
	'matrixstructure' => { 355 => 0xa },
	'maxaperture' => { 33 => 0x1a, 131 => 0x3f9, 137 => 0x6103, 154 => 'MaxAperture', 171 => 0x17, 177 => 0x49c5, 212 => 0x36, 278 => 0x20a, 326 => '14.1' },
	'maxapertureatmaxfocal' => { 121 => 0x1407, 154 => 'MaxApertureAtMaxFocal', 206 => 0xb, 207 => 0x10, 208 => 0x11, 212 => 0x12, 278 => 0x206 },
	'maxapertureatminfocal' => { 121 => 0x1406, 206 => 0xa, 207 => 0xf, 208 => 0x10, 212 => 0x11, 278 => 0x205 },
	'maxaperturevalue' => { 113 => 0x9205, 344 => 0x414, 449 => 'MaxApertureValue' },
	'maxavailheight' => { 455 => 'MaxAvailHeight' },
	'maxavailwidth' => { 455 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 260 => 0xb, 261 => 0xc, 263 => '12.1', 264 => '12.1', 269 => 0xc, 270 => 0xb, 273 => '12.1', 274 => '12.1' },
	'maxfaces' => { 281 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 121 => 0x1405, 154 => 'MaxFocalLength', 206 => 0x9, 207 => 0xe, 208 => 0xf, 212 => 0x10, 278 => 0x208, 403 => 0x127c, 404 => 0x1138, 405 => 0x330, 406 => 0x330, 407 => 0x30e },
	'maximumdensityrange' => { 127 => 0x8c },
	'maxpagesize' => { 474 => 'MaxPageSize' },
	'maxpagesizeh' => { 474 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 474 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 474 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 131 => 0xc7d },
	'maxsamplevalue' => { 113 => 0x119 },
	'maxstorage' => { 464 => 'maxstorage' },
	'mb-d10batteries' => { 260 => '12.6' },
	'mb-d10batterytype' => { 269 => '13.3' },
	'mb-d11batterytype' => { 270 => '2.3' },
	'mb-d12batterytype' => { 273 => '3.2' },
	'mb-d80batteries' => { 271 => '6.5' },
	'mb-d80batterytype' => { 275 => '3.2' },
	'mcuversion' => { 206 => 0xc, 207 => 0x11, 208 => 0x12, 212 => 0x13 },
	'md5digest' => { 155 => 'zmd5' },
	'mditemfindercomment' => { 164 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 164 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 164 => 'MDItemFSLabel' },
	'mditemusertags' => { 164 => 'MDItemUserTags' },
	'meal' => { 461 => 'meal' },
	'measuredev' => { 27 => 0x9, 72 => 0x3, 91 => 0x1814, 147 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 72 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 177 => 0x690, 295 => 0x312, 298 => 0x312, 299 => 0x312, 302 => 0x3407 },
	'measuredrggb' => { 61 => 0x1 },
	'measuredrggbdata' => { 41 => 0x287 },
	'measurementaccuracy' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 112 => 'MeasurementOrFact' },
	'measurementremarks' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 429 => 'MeasureType' },
	'mechanicalshuttercount' => { 214 => 0x37 },
	'mediaconstraints' => { 287 => 'MediaConstraints' },
	'mediacreatedate' => { 352 => 0x1 },
	'mediaeventiddate' => { 434 => 'MediaEventIdDate' },
	'mediamodifydate' => { 352 => 0x2 },
	'mediasummarycode' => { 287 => 'MediaSummaryCode' },
	'memoaudioquality' => { 78 => 0x812 },
	'memorycardconfiguration' => { 385 => 0x16 },
	'memorycardnumber' => { 197 => 0x2 },
	'menubuttondisplayposition' => { 76 => 0xb, 79 => 0xa, 80 => 0xb, 83 => 0xb },
	'menubuttonreturn' => { 84 => 0xb },
	'menumonitorofftime' => { 260 => '26.1', 261 => '22.1', 263 => '22.1', 264 => '22.1', 268 => '21.1', 269 => '8.2', 270 => '21.1', 273 => '22.1', 274 => '22.1', 275 => '22.1' },
	'metadatadate' => { 467 => 'MetadataDate' },
	'metadatamoddate' => { 469 => 'metadataModDate' },
	'metaversion' => { 398 => 0x34 },
	'meterinfo1row1' => { 392 => 0x0, 393 => 0x0 },
	'meterinfo1row2' => { 392 => 0x6c, 393 => 0x5a },
	'meterinfo1row3' => { 392 => 0xd8, 393 => 0xb4 },
	'meterinfo1row4' => { 392 => 0x144, 393 => 0x10e },
	'meterinfo1row5' => { 392 => 0x1b0, 393 => 0x168 },
	'meterinfo1row6' => { 392 => 0x21c, 393 => 0x1c2 },
	'meterinfo1row7' => { 392 => 0x288, 393 => 0x21c },
	'meterinfo2row1' => { 392 => 0x2f4, 393 => 0x276 },
	'meterinfo2row2' => { 392 => 0x378, 393 => 0x2e4 },
	'meterinfo2row3' => { 392 => 0x3fc, 393 => 0x352 },
	'meterinfo2row4' => { 392 => 0x480, 393 => 0x3c0 },
	'meterinfo2row5' => { 392 => 0x504, 393 => 0x42e },
	'meterinfo2row6' => { 392 => 0x588, 393 => 0x49c },
	'meterinfo2row7' => { 392 => 0x60c, 393 => 0x50a },
	'meterinfo2row8' => { 392 => 0x690, 393 => 0x578 },
	'meterinfo2row9' => { 392 => 0x714, 393 => 0x5e6 },
	'metering' => { 262 => '6.1' },
	'meteringmode' => { 33 => 0x11, 113 => 0x9207, 133 => 0x1c, 171 => 0x7, 172 => 0x25, 174 => 0x12, 277 => 0x202, 335 => 0x17, 371 => 0x9, 379 => 0x15, 380 => 0x13, 381 => 0x7, 396 => 0x3, 399 => 0x1174, 400 => 0x1178, 401 => 0x1154, 402 => 0x11d0, 403 => 0x11ac, 404 => 0x1064, 405 => 0x25c, 406 => 0x25c, 407 => 0x24b, 449 => 'MeteringMode' },
	'meteringmode2' => { 316 => '2.1', 391 => 0x202c },
	'meteringmode3' => { 316 => '16.1' },
	'meteringoffscaleindicator' => { 174 => 0x53 },
	'meteringtime' => { 260 => '22.2', 262 => '3.2', 265 => '17.1', 266 => '18.1', 269 => '7.3', 270 => '18.1', 271 => '3.2', 275 => '19.1' },
	'micro1version' => { 357 => 0x1f },
	'micro2version' => { 357 => 0x2d },
	'mieversion' => { 155 => '0Vers' },
	'mime' => { 429 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 131 => 0x3f8, 154 => 'MinAperture', 326 => '0.2' },
	'minaperturevalue' => { 344 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 121 => 0x1404, 154 => 'MinFocalLength', 206 => 0x8, 207 => 0xd, 208 => 0xe, 212 => 0xf, 278 => 0x207, 403 => 0x127a, 404 => 0x1136, 405 => 0x32e, 406 => 0x32e, 407 => 0x30c },
	'minfocusdistance' => { 326 => 0x3 },
	'minintegrationrows' => { 131 => 0x1874 },
	'minoltadate' => { 171 => 0x15 },
	'minoltaimagesize' => { 171 => 0x4, 172 => 0xc, 173 => 0x2, 176 => 0x103 },
	'minoltamodelid' => { 171 => 0x25 },
	'minoltaquality' => { 171 => 0x5, 172 => 0xd, 173 => 0x3, 176 => [0x102,0x103] },
	'minoltatime' => { 171 => 0x16 },
	'minormodelagedisclosure' => { 287 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 435 => 'MinorVersion' },
	'minsamplevalue' => { 113 => 0x118 },
	'mirrorlockup' => { 76 => 0xc, 77 => 0xc, 78 => 0x60f, 79 => 0xb, 80 => 0xc, 81 => 0x6, 82 => 0x6, 83 => 0xc, 84 => 0x3 },
	'mobilecountrycode' => { 443 => 'mcc' },
	'mobilenetworkcode' => { 443 => 'mnc' },
	'moddate' => { 290 => 'modify-date', 456 => 'ModDate' },
	'modedialposition' => { 385 => 0x14 },
	'model' => { 92 => 0x6, 113 => 0x110, 147 => 'Model', 290 => 'Model', 305 => 0x110, 335 => 0x23f, 371 => 0x84, 429 => 'Model', 458 => 'model', 465 => 'Model' },
	'modelage' => { 455 => 'ModelAge' },
	'modelid' => { 276 => 0x0 },
	'modelingflash' => { 260 => '21.4', 261 => '31.1', 263 => '31.1', 264 => '31.1', 269 => '26.4', 270 => '30.2', 271 => '7.4', 272 => '30.1', 273 => '31.1', 274 => '31.1', 275 => '31.3' },
	'modelreleaseid' => { 287 => 'ModelReleaseID' },
	'modelreleasestatus' => { 287 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 411 => 0x52, 412 => 0x46, 413 => 0x53 },
	'modelyear' => { 458 => 'modelYear' },
	'modificationdate' => { 459 => 'modificationDate' },
	'modifiedcolortemp' => { 62 => 0x9 },
	'modifieddigitalgain' => { 62 => 0xb },
	'modifiedparamflag' => { 55 => 0x1 },
	'modifiedpicturestyle' => { 62 => 0xa },
	'modifiedsaturation' => { 277 => 0x504 },
	'modifiedsensorbluelevel' => { 62 => 0x5 },
	'modifiedsensorredlevel' => { 62 => 0x4 },
	'modifiedsharpness' => { 62 => 0x2 },
	'modifiedsharpnessfreq' => { 62 => 0x3 },
	'modifiedtonecurve' => { 62 => 0x1 },
	'modifiedwhitebalance' => { 62 => 0x8 },
	'modifiedwhitebalanceblue' => { 62 => 0x7 },
	'modifiedwhitebalancered' => { 62 => 0x6 },
	'modifydate' => { 113 => 0x132, 148 => 'ModifyDate', 286 => 'ModDate', 288 => 'tIME', 351 => 'ModDate', 353 => 0x2, 467 => 'ModifyDate' },
	'moirefilter' => { 113 => 0xfe58, 445 => 'MoireFilter' },
	'monitordisplayoff' => { 174 => 0x4c },
	'monitormatrix' => { 131 => 0x8fc },
	'monitorofftime' => { 260 => '18.2', 262 => '3.1', 271 => '3.1' },
	'monochromecolor' => { 277 => 0x53b },
	'monochromecontrast' => { 103 => 0x3c },
	'monochromefiltereffect' => { 97 => 0x20307, 103 => 0x3a, 335 => 0x73 },
	'monochromelinear' => { 103 => 0x3d },
	'monochromeoutputhighlightpoint' => { 103 => 0x41 },
	'monochromeoutputshadowpoint' => { 103 => 0x42 },
	'monochromeprofilesettings' => { 277 => 0x537 },
	'monochromerawhighlight' => { 103 => 0x7a },
	'monochromerawhighlightpoint' => { 103 => 0x3f },
	'monochromerawshadow' => { 103 => 0x83 },
	'monochromerawshadowpoint' => { 103 => 0x40 },
	'monochromesharpness' => { 103 => 0x3e },
	'monochrometoning' => { 335 => 0x74 },
	'monochrometoningeffect' => { 97 => 0x20306, 103 => 0x3b },
	'monochromeunsharpmaskfineness' => { 103 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 103 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 103 => 0xb4 },
	'monochromevignetting' => { 277 => 0x53a },
	'monthdaycreated' => { 133 => 0x12, 142 => 0xe },
	'moonphase' => { 356 => 0x12, 357 => 0x43 },
	'morepermissions' => { 442 => 'morePermissions' },
	'motionsensitivity' => { 356 => 0x29 },
	'movieaelockbuttonassignment' => { 273 => '40.1' },
	'moviefunc1button' => { 263 => '41.1', 264 => '41.1', 274 => '41.1' },
	'moviefunctionbutton' => { 261 => '41.1', 273 => '41.1' },
	'moviefunctionbuttonplusdials' => { 261 => '52.1' },
	'moviepreviewbutton' => { 261 => '41.2', 263 => '41.2', 264 => '41.2', 273 => '41.2', 274 => '41.2' },
	'moviepreviewbuttonplusdials' => { 261 => '52.2' },
	'movieshutterbutton' => { 261 => '38.3', 263 => '38.3', 264 => '38.3', 273 => '38.3', 274 => '38.3' },
	'moviesubselectorassignment' => { 261 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 261 => '53.1' },
	'multiburstimageheight' => { 391 => 0x1002 },
	'multiburstimagewidth' => { 391 => 0x1001 },
	'multiburstmode' => { 391 => 0x1000 },
	'multicontrollerwhilemetering' => { 78 => 0x517 },
	'multiexposure' => { 64 => 0x1, 300 => 0xb4 },
	'multiexposureautogain' => { 215 => 0x3 },
	'multiexposurecontrol' => { 64 => 0x2 },
	'multiexposuremode' => { 215 => 0x1 },
	'multiexposureshots' => { 64 => 0x3, 215 => 0x2 },
	'multiframenoisereduction' => { 381 => 0x35, 391 => 0x200b, 396 => 0x15 },
	'multiframenreffect' => { 391 => 0x2023 },
	'multifunctionlock' => { 78 => 0x70f },
	'multipleexposuremode' => { 281 => 0x101c },
	'multipleexposureset' => { 316 => '10.1' },
	'multisample' => { 221 => 0x40 },
	'multiselector' => { 260 => '9.4', 261 => '10.3', 263 => '10.3', 264 => '10.3', 269 => '27.4', 273 => '10.3', 274 => '10.3' },
	'multiselectorliveview' => { 260 => '4.3', 263 => '37.1', 264 => '37.1', 273 => '37.1', 274 => '37.1' },
	'multiselectorliveviewmode' => { 231 => 0x18c2 },
	'multiselectorplaybackmode' => { 260 => ['13.5','9.2'], 261 => '10.2', 264 => '10.2', 269 => '27.2', 273 => '10.2', 274 => '10.2' },
	'multiselectorshootmode' => { 260 => '9.1', 261 => '10.1', 263 => '10.1', 264 => '10.1', 269 => '27.1', 273 => '10.1', 274 => '10.1' },
	'multishot' => { 305 => 0x121 },
	'mycolormode' => { 65 => 0x2 },
	'nationalcatalognumber' => { 459 => 'nationalCatalogNumber' },
	'nativedigest' => { 449 => 'NativeDigest', 465 => 'NativeDigest' },
	'ndfilter' => { 72 => 0x1c, 277 => 0x204, 361 => 0x1019 },
	'near' => { 429 => 'Near' },
	'nefbitdepth' => { 214 => 0xe22 },
	'nefcompression' => { 214 => 0x93 },
	'neflinearizationtable' => { 214 => 0x96 },
	'negativecachelargepreviewsize' => { 445 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 445 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 445 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 335 => 0x88 },
	'neutraloutputhighlightpoint' => { 103 => 0x2f },
	'neutraloutputshadowpoint' => { 103 => 0x30 },
	'neutralrawcolortone' => { 103 => 0x28 },
	'neutralrawcontrast' => { 103 => 0x2a },
	'neutralrawhighlight' => { 103 => 0x78 },
	'neutralrawhighlightpoint' => { 103 => 0x2d },
	'neutralrawlinear' => { 103 => 0x2b },
	'neutralrawsaturation' => { 103 => 0x29 },
	'neutralrawshadow' => { 103 => 0x81 },
	'neutralrawshadowpoint' => { 103 => 0x2e },
	'neutralrawsharpness' => { 103 => 0x2c },
	'neutralunsharpmaskfineness' => { 103 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 103 => 0xa8 },
	'neutraunsharpmaskstrength' => { 103 => 0xa4 },
	'newrawimagedigest' => { 113 => 0xc7a7 },
	'newsphotoversion' => { 127 => 0x0 },
	'nickname' => { 467 => 'Nickname' },
	'nikoncapturedata' => { 214 => 0xe01 },
	'nikoncaptureeditversions' => { 214 => 0xe13 },
	'nikoncaptureoutput' => { 214 => 0xe1e },
	'nikoncaptureversion' => { 214 => 0xe09 },
	'nikoniccprofile' => { 214 => 0xe1d },
	'nikonimagesize' => { 228 => '723.1', 229 => '732.1', 238 => 0x2c4 },
	'noisefilter' => { 277 => 0x527 },
	'noiseprofile' => { 113 => 0xc761 },
	'noisereduction' => { 121 => [0x100b,0x100e], 172 => 0xb0, 173 => 0x60, 174 => 0x3f, 214 => 0x95, 253 => 0x753dcbc0, 254 => 0x17, 277 => 0x50a, 282 => 0x103a, 300 => 0x2d, 335 => 0x49, 361 => 0x100f, 363 => 0x2a },
	'noisereduction2' => { 281 => 0x1010 },
	'noisereductionapplied' => { 113 => 0xc6f7 },
	'noisereductionintensity' => { 254 => 0x9 },
	'noisereductionmethod' => { 254 => 0x11 },
	'noisereductionmode' => { 424 => 0x801e },
	'noisereductionparametersatcapture' => { 131 => 0xe73 },
	'noisereductionparameterscamera' => { 131 => 0xe72 },
	'noisereductionparametershost3mp' => { 131 => 0xe71 },
	'noisereductionparametershost6mp' => { 131 => 0xe70 },
	'noisereductionparametershostrgb' => { 131 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 131 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 131 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 131 => 0xe63 },
	'noisereductionparams' => { 305 => 0x1b },
	'noisereductionsharpness' => { 254 => 0xd },
	'noisereductionvalue' => { 424 => 0x8027 },
	'nomemorycard' => { 260 => '22.1', 261 => '4.2', 262 => '0.3', 265 => '2.4', 266 => '3.2', 267 => '3.2', 269 => '33.7', 270 => '3.2', 271 => '0.3', 273 => '4.2', 275 => '4.5' },
	'nominalmaxaperture' => { 326 => 0xa },
	'nominalminaperture' => { 326 => '10.1' },
	'normallinetime' => { 131 => 0x186a },
	'normalwhitelevel' => { 42 => [0x2b8,0x2cf,0x2d3], 44 => 0x1e3, 45 => [0x1fc,0x2dc], 46 => [0x230,0x30e], 47 => 0x31c },
	'notes' => { 425 => 'Notes', 439 => 'notes' },
	'npages' => { 474 => 'NPages' },
	'nullrecord' => { 91 => 0x0 },
	'numafpoints' => { 312 => 0x2 },
	'number' => { 459 => 'number' },
	'numberofbeats' => { 469 => 'numberOfBeats' },
	'numberoffocuspoints' => { 263 => '1.2', 264 => '1.2', 267 => '0.2', 268 => '0.3', 270 => '0.3' },
	'numfaceelements' => { 121 => 0x4200 },
	'numfacepositions' => { 292 => 0x0 },
	'numindexentries' => { 127 => 0x54 },
	'numwbentries' => { 306 => 0x0, 307 => 0x0 },
	'object' => { 459 => 'object' },
	'objectattributereference' => { 125 => 0x4 },
	'objectcycle' => { 125 => 0x4b, 439 => 'ObjectCycle' },
	'objectdescription' => { 458 => 'objectDescription' },
	'objectdistance' => { 106 => 0x6, 107 => 0x2022 },
	'objectname' => { 125 => 0x5 },
	'objectpreviewdata' => { 125 => 0xca },
	'objectpreviewfileformat' => { 125 => 0xc8 },
	'objectpreviewfileversion' => { 125 => 0xc9 },
	'objectsubtype' => { 458 => 'objectSubtype' },
	'objecttype' => { 458 => 'objectType' },
	'objecttypereference' => { 125 => 0x3 },
	'occurrence' => { 112 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 112 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 112 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 112 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 112 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 112 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 112 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 112 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 112 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 112 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 112 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 112 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 112 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 112 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 112 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 112 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 112 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 112 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 112 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 112 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 112 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 112 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 112 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 112 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 112 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 112 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 449 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 449 => [\'OECF','OECFNames'] },
	'oecfrows' => { 449 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 449 => [\'OECF','OECFValues'] },
	'offsaledate' => { 459 => 'offSaleDate' },
	'offsaledatea-platform' => { 459 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 459 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 131 => 0x190a },
	'offsetschema' => { 113 => 0xea1d },
	'offsettime' => { 113 => 0x9010 },
	'offsettimedigitized' => { 113 => 0x9012 },
	'offsettimeoriginal' => { 113 => 0x9011 },
	'okbutton' => { 270 => '15.1', 275 => '16.1' },
	'oldsubfiletype' => { 113 => 0xff },
	'olympusimageheight' => { 282 => 0x102f },
	'olympusimagewidth' => { 282 => 0x102e },
	'omenatcapturestrength' => { 131 => 0xa60 },
	'omenautostrength' => { 131 => 0xa5f },
	'omenearlystrength' => { 131 => 0xa5e },
	'omenfocallengthlimit' => { 131 => 0xa62 },
	'omeninitialipfstrength' => { 131 => 0xa5d },
	'omensurfaceindex' => { 131 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 282 => 0x302 },
	'onsaledate' => { 459 => 'onSaleDate' },
	'onsaledatea-platform' => { 459 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 459 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 459 => 'onSaleDay' },
	'onsaledaya-platform' => { 459 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 459 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 113 => 0xc740 },
	'opcodelist2' => { 113 => 0xc741 },
	'opcodelist3' => { 113 => 0xc74e },
	'opticalzoom' => { 135 => 0xfa3d, 137 => [0x6006,0xf006], 138 => 0x1000, 139 => 0xf, 142 => 0x1e, 154 => 'OpticalZoom' },
	'opticalzoomcode' => { 72 => 0xa },
	'opticalzoommode' => { 300 => 0x34 },
	'opticalzoomon' => { 370 => 0x219 },
	'optionenddate' => { 462 => 'optionEndDate' },
	'opto-electricconvfactor' => { 449 => 'OECF' },
	'orangehsl' => { 97 => 0x20911 },
	'ordernumber' => { 121 => 0x8002 },
	'organisationinimagecode' => { 455 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 455 => 'OrganisationInImageName' },
	'organism' => { 112 => 'Organism' },
	'organismassociatedoccurrences' => { 112 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 112 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 112 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 112 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 112 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 112 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 112 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 459 => 'organization' },
	'orientation' => { 113 => 0x112, 305 => 0x112, 458 => 'orientation', 465 => 'Orientation' },
	'orientation2' => { 396 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 78 => 0x516 },
	'originalbestqualitysize' => { 113 => 0xc792 },
	'originalcreatedatetime' => { 434 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 108 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 60 => 0x83 },
	'originaldefaultcropsize' => { 113 => 0xc793 },
	'originaldefaultfinalsize' => { 113 => 0xc791 },
	'originaldirectory' => { 297 => 0x408 },
	'originaldocumentid' => { 470 => 'OriginalDocumentID' },
	'originalfilename' => { 91 => 0x816, 131 => 0x3e9, 143 => 0x20, 297 => 0x407, 434 => 'OriginalFilename' },
	'originalimageheight' => { 74 => 0xc, 117 => 0x1 },
	'originalimagewidth' => { 74 => 0xb, 117 => 0x0 },
	'originalrawfiledata' => { 113 => 0xc68c },
	'originalrawfiledigest' => { 113 => 0xc71d },
	'originalrawfilename' => { 113 => 0xc68b },
	'originaltransmissionreference' => { 125 => 0x67 },
	'originatingprogram' => { 125 => 0x41, 439 => 'OriginatingProgram' },
	'originplatform' => { 459 => 'originPlatform' },
	'os' => { 447 => 'os' },
	'otherconditions' => { 287 => 'OtherConditions' },
	'otherconstraints' => { 287 => 'OtherConstraints' },
	'otherimage' => { 108 => 'OtherImage' },
	'otherimageinfo' => { 287 => 'OtherImageInfo' },
	'otherimagelength' => { 113 => 0x202 },
	'otherimagestart' => { 113 => 0x201 },
	'otherlicensedocuments' => { 287 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 287 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 287 => 'OtherLicenseRequirements' },
	'outcue' => { 469 => 'outCue' },
	'outcuescale' => { 469 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 469 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 186 => 0x3 },
	'outputimagewidth' => { 186 => 0x2 },
	'outputlut' => { 300 => 0xa7 },
	'outputprofile' => { 131 => 0x138b },
	'outputresolution' => { 186 => 0x4 },
	'overclockcols' => { 131 => 0x189c },
	'overclockrows' => { 131 => 0x18c4 },
	'owner' => { 473 => 'Owner' },
	'ownerid' => { 125 => 0xbc },
	'ownername' => { 14 => 0x10f, 60 => 0x9, 91 => 0x810, 113 => [0xa430,0xfde8], 147 => 'OwnerName', 441 => 'OwnerName', 450 => 'CameraOwnerName' },
	'padding' => { 113 => 0xea1c },
	'pagecount' => { 459 => 'pageCount' },
	'pageimage' => { 467 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 467 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 467 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 467 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 467 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 467 => 'PageInfo' },
	'pagename' => { 113 => 0x11d },
	'pagenumber' => { 113 => 0x129 },
	'pageprogressiondirection' => { 459 => 'pageProgressionDirection' },
	'pagerange' => { 459 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 445 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 445 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 303 => 0x0 },
	'panasonicexifversion' => { 300 => 0x26 },
	'panasonicimageheight' => { 300 => 0x4c },
	'panasonicimagewidth' => { 300 => 0x4b },
	'panasonicrawversion' => { 305 => 0x1 },
	'panasonictitle' => { 113 => 0xc6d2 },
	'panasonictitle2' => { 113 => 0xc6d3 },
	'panoramaangle' => { 121 => 0x1153 },
	'panoramacropbottom' => { 397 => 0x7 },
	'panoramacropleft' => { 397 => 0x4 },
	'panoramacropright' => { 397 => 0x6 },
	'panoramacroptop' => { 397 => 0x5 },
	'panoramadirection' => { 68 => 0x5, 121 => 0x1154, 397 => 0x3 },
	'panoramaframeheight' => { 397 => 0x9 },
	'panoramaframenumber' => { 68 => 0x2 },
	'panoramaframewidth' => { 397 => 0x8 },
	'panoramafullheight' => { 397 => 0x2 },
	'panoramafullwidth' => { 397 => 0x1 },
	'panoramamode' => { 133 => 0x3c, 277 => 0x601 },
	'panoramasize3d' => { 381 => 0x38 },
	'panoramasourceheight' => { 397 => 0xb },
	'panoramasourcewidth' => { 397 => 0xa },
	'panoramicstitchcameramotion' => { 167 => 'PanoramicStitchCameraMotion', 168 => 0x1 },
	'panoramicstitchmaptype' => { 167 => 'PanoramicStitchMapType', 168 => 0x2 },
	'panoramicstitchphi0' => { 167 => 'PanoramicStitchPhi0', 168 => 0x5 },
	'panoramicstitchphi1' => { 167 => 'PanoramicStitchPhi1', 168 => 0x6 },
	'panoramicstitchtheta0' => { 167 => 'PanoramicStitchTheta0', 168 => 0x3 },
	'panoramicstitchtheta1' => { 167 => 'PanoramicStitchTheta1', 168 => 0x4 },
	'panoramicstitchversion' => { 168 => 0x0 },
	'pantry' => { 470 => 'Pantry' },
	'parallax' => { 121 => 0xb211, 276 => 0x28 },
	'parametricdarks' => { 445 => 'ParametricDarks' },
	'parametrichighlights' => { 445 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 445 => 'ParametricHighlightSplit' },
	'parametriclights' => { 445 => 'ParametricLights' },
	'parametricmidtonesplit' => { 445 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 445 => 'ParametricShadows' },
	'parametricshadowsplit' => { 445 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 434 => 'ParentMediaEventID' },
	'parentmeid' => { 434 => 'ParentMEID' },
	'parentreference1' => { 453 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 453 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partialactivecols1' => { 131 => 0x17e8 },
	'partialactivecols2' => { 131 => 0x17f2 },
	'partialactiverows1' => { 131 => 0x17fc },
	'partialactiverows2' => { 131 => 0x1806 },
	'partofcompilation' => { 469 => 'partOfCompilation' },
	'patientbirthdate' => { 426 => 'PatientDOB' },
	'patientid' => { 426 => 'PatientID' },
	'patientname' => { 426 => 'PatientName' },
	'patientsex' => { 426 => 'PatientSex' },
	'patternareaheight' => { 131 => 0x963 },
	'patternareawidth' => { 131 => 0x962 },
	'patterncorrectionfactorscale' => { 131 => 0x969 },
	'patterncropcols1' => { 131 => 0x96c },
	'patterncropcols2' => { 131 => 0x96d },
	'patterncroprows1' => { 131 => 0x96a },
	'patterncroprows2' => { 131 => 0x96b },
	'patternimagerheight' => { 131 => 0x961 },
	'patternimagerwidth' => { 131 => 0x960 },
	'patternx' => { 131 => 0x966 },
	'patterny' => { 131 => 0x967 },
	'pdfversion' => { 456 => 'PDFVersion' },
	'pentaximagesize' => { 335 => 0x9 },
	'pentaxmodelid' => { 315 => 0x0, 335 => 0x5 },
	'pentaxmodeltype' => { 335 => 0x1 },
	'pentaxversion' => { 335 => 0x0 },
	'people' => { 427 => 'People', 437 => 'People' },
	'perchannelblacklevel' => { 41 => 0xc4, 42 => [0x2b4,0x2cb,0x2cf], 43 => [0x108,0x14d], 44 => 0x1df, 45 => [0x1f8,0x2d8], 46 => [0x22c,0x30a], 47 => 0x149 },
	'peripheralillumcentralradius' => { 424 => 0x8030 },
	'peripheralillumcentralvalue' => { 424 => 0x8031 },
	'peripheralillumination' => { 97 => 0x20702, 103 => 0x68 },
	'peripheralilluminationcorr' => { 59 => 0x1, 325 => 0x2 },
	'peripheralilluminationon' => { 97 => '0x20702.0', 103 => 0x64 },
	'peripheralillumperiphvalue' => { 424 => 0x8032 },
	'peripherallighting' => { 74 => 0x2 },
	'peripherallightingsetting' => { 75 => 0x5 },
	'peripherallightingvalue' => { 74 => 0x6 },
	'permissions' => { 462 => 'permissions' },
	'permits' => { 442 => 'permits' },
	'person' => { 459 => 'person' },
	'personality' => { 434 => 'Personality' },
	'personheard' => { 455 => 'PersonHeard' },
	'personheardidentifier' => { 455 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 455 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 455 => 'PersonInImage' },
	'personinimagecharacteristic' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 455 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 455 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 445 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 445 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 445 => 'PerspectiveRotate' },
	'perspectivescale' => { 445 => 'PerspectiveScale' },
	'perspectiveupright' => { 445 => 'PerspectiveUpright' },
	'perspectivevertical' => { 445 => 'PerspectiveVertical' },
	'perspectivex' => { 445 => 'PerspectiveX' },
	'perspectivey' => { 445 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 86 => 0x1 },
	'pf10retainprogramshift' => { 86 => 0xb },
	'pf13drivepriority' => { 86 => 0xe },
	'pf14disablefocussearch' => { 86 => 0xf },
	'pf15disableafassistbeam' => { 86 => 0x10 },
	'pf16autofocuspointshoot' => { 86 => 0x11 },
	'pf17disableafpointsel' => { 86 => 0x12 },
	'pf18enableautoafpointsel' => { 86 => 0x13 },
	'pf19continuousshootspeed' => { 86 => 0x14 },
	'pf19shootingspeedhigh' => { 85 => 0xa },
	'pf19shootingspeedlow' => { 85 => 0x9 },
	'pf1disableshootingmodes' => { 86 => 0x2 },
	'pf1value' => { 85 => 0x1 },
	'pf20limitcontinousshots' => { 86 => 0x15 },
	'pf20maxcontinousshots' => { 85 => 0xb },
	'pf21enablequietoperation' => { 86 => 0x16 },
	'pf23felocktime' => { 85 => 0xd },
	'pf23postreleasetime' => { 85 => 0xe },
	'pf23settimerlengths' => { 86 => 0x18 },
	'pf23shutterbuttontime' => { 85 => 0xc },
	'pf24lightlcdduringbulb' => { 86 => 0x19 },
	'pf25aemode' => { 85 => 0xf },
	'pf25afmode' => { 85 => 0x12 },
	'pf25afpointsel' => { 85 => 0x13 },
	'pf25colormatrix' => { 85 => 0x17 },
	'pf25defaultclearsettings' => { 86 => 0x1a },
	'pf25drivemode' => { 85 => 0x11 },
	'pf25imagesize' => { 85 => 0x14 },
	'pf25meteringmode' => { 85 => 0x10 },
	'pf25parameters' => { 85 => 0x16 },
	'pf25wbmode' => { 85 => 0x15 },
	'pf26shortenreleaselag' => { 86 => 0x1b },
	'pf27reversedialrotation' => { 86 => 0x1c },
	'pf27value' => { 85 => 0x18 },
	'pf28noquickdialexpcomp' => { 86 => 0x1d },
	'pf29quickdialswitchoff' => { 86 => 0x1e },
	'pf2disablemeteringmodes' => { 86 => 0x3 },
	'pf2value' => { 85 => 0x2 },
	'pf30enlargementmode' => { 86 => 0x1f },
	'pf31originaldecisiondata' => { 86 => 0x20 },
	'pf3manualexposuremetering' => { 86 => 0x4 },
	'pf3value' => { 85 => 0x3 },
	'pf4exposuretimelimits' => { 86 => 0x5 },
	'pf4exposuretimemax' => { 85 => 0x5 },
	'pf4exposuretimemin' => { 85 => 0x4 },
	'pf5aperturelimits' => { 86 => 0x6 },
	'pf5aperturemax' => { 85 => 0x7 },
	'pf5aperturemin' => { 85 => 0x6 },
	'pf6presetshootingmodes' => { 86 => 0x7 },
	'pf7bracketcontinuousshoot' => { 86 => 0x8 },
	'pf8bracketshots' => { 85 => 0x8 },
	'pf8setbracketshots' => { 86 => 0x9 },
	'pf9changebracketsequence' => { 86 => 0xa },
	'phasedetectaf' => { 183 => 0x6 },
	'phonenumber' => { 148 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 253 => 0xe9651831 },
	'photoeffects' => { 253 => 0xab5eca5e },
	'photoeffectsblue' => { 255 => 0x8 },
	'photoeffectsgreen' => { 255 => 0x6 },
	'photoeffectsred' => { 255 => 0x4 },
	'photoeffectstype' => { 255 => 0x0 },
	'photographicsensitivity' => { 450 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 260 => '17.6', 269 => '33.6' },
	'photometricinterpretation' => { 113 => 0x106, 465 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 232 => 0xe7d, 241 => 0xfbd },
	'photoshootingmenubankimagearea' => { 232 => '3716.1', 241 => 0x791 },
	'photoshopbgrthumbnail' => { 349 => 0x409 },
	'photoshopquality' => { 348 => 0x0 },
	'photoshopthumbnail' => { 349 => 0x40c },
	'photostyle' => { 300 => 0x89 },
	'picklabel' => { 448 => 'PickLabel' },
	'pictinfo' => { 370 => 0x208 },
	'picturecontrol' => { 253 => 0xe2173c47 },
	'picturecontrolactive' => { 256 => 0x0 },
	'picturecontroladjust' => { 216 => 0x30, 217 => 0x30 },
	'picturecontrolbase' => { 216 => 0x18, 217 => 0x18 },
	'picturecontroldata' => { 214 => [0xbd,0x23] },
	'picturecontrolmode' => { 256 => 0x13 },
	'picturecontrolname' => { 216 => 0x4, 217 => 0x4 },
	'picturecontrolquickadjust' => { 216 => 0x31, 217 => 0x31 },
	'pictureeffect' => { 391 => 0x200e },
	'pictureeffect2' => { 399 => 0x1163, 400 => 0x1167, 401 => 0x1143, 402 => 0x11bf, 403 => 0x119b, 404 => 0x1053, 405 => 0x24b, 406 => 0x24b, 407 => 0x23c, 420 => 0x46 },
	'picturefinish' => { 172 => 0x71 },
	'picturemode' => { 121 => 0x1031, 277 => 0x520, 335 => [0xb,0x33], 371 => 0x3d },
	'picturemode2' => { 316 => 0x0 },
	'picturemodebwfilter' => { 277 => 0x525 },
	'picturemodecontrast' => { 277 => 0x523 },
	'picturemodeeffect' => { 277 => 0x52d },
	'picturemodehue' => { 277 => 0x522 },
	'picturemodesaturation' => { 277 => 0x521 },
	'picturemodesharpness' => { 277 => 0x524 },
	'picturemodetone' => { 277 => 0x526 },
	'pictureprofile' => { 399 => [0x115e,0x115f], 400 => [0x1162,0x1163], 401 => [0x113e,0x113f], 402 => [0x11ba,0x11bb], 403 => [0x1196,0x1197], 404 => [0x104e,0x104f], 405 => [0x246,0x247], 406 => [0x246,0x247], 407 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 70 => 0xa, 97 => 0x20301, 103 => 0x2 },
	'picturewizard' => { 368 => 0x21 },
	'picturewizardcolor' => { 367 => 0x1 },
	'picturewizardcontrast' => { 367 => 0x4 },
	'picturewizardmode' => { 367 => 0x0 },
	'picturewizardsaturation' => { 367 => 0x2 },
	'picturewizardsharpness' => { 367 => 0x3 },
	'pipelineversion' => { 167 => 'PipelineVersion' },
	'pitch' => { 109 => 0x6, 261 => '4.1', 273 => '4.1' },
	'pitchangle' => { 231 => 0x350f, 232 => 0x2c28, 240 => 0x36f8, 277 => 0x904, 300 => 0x91, 334 => 0x2, 366 => 0x1 },
	'pixelclockfrequency' => { 131 => 0x40b },
	'pixelcorrectionoffset' => { 131 => 0x972 },
	'pixelcorrectionscale' => { 131 => 0x971 },
	'pixelshiftinfo' => { 391 => 0x202f },
	'pixelshiftresolution' => { 336 => 0x0 },
	'pixelsperunitx' => { 289 => 0x0 },
	'pixelsperunity' => { 289 => 0x4 },
	'pixelunits' => { 289 => 0x8 },
	'planarconfiguration' => { 113 => 0x11c, 465 => 'PlanarConfiguration' },
	'planningref' => { 455 => 'PlanningRef' },
	'planningrefidentifier' => { 455 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 455 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 455 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 474 => 'PlateNames' },
	'platform' => { 459 => 'platform' },
	'playbackmenustime' => { 265 => '20.1', 266 => '21.1', 267 => '21.1' },
	'playbackmonitorofftime' => { 260 => '25.2', 261 => '36.1', 263 => '36.1', 264 => '36.1', 268 => '35.1', 269 => '8.1', 270 => '35.1', 273 => '36.1', 274 => '36.1', 275 => '21.1' },
	'playbackzoom' => { 261 => '37.1' },
	'playdisplay' => { 174 => 0x4e },
	'plusversion' => { 287 => 'Version' },
	'pmversion' => { 347 => 'PMVersion' },
	'pngwarning' => { 290 => 'Warning' },
	'poilevel' => { 213 => 0x8 },
	'portraitoutputhighlightpoint' => { 103 => 0x1d },
	'portraitoutputshadowpoint' => { 103 => 0x1e },
	'portraitrawcolortone' => { 103 => 0x16 },
	'portraitrawcontrast' => { 103 => 0x18 },
	'portraitrawhighlight' => { 103 => 0x76 },
	'portraitrawhighlightpoint' => { 103 => 0x1b },
	'portraitrawlinear' => { 103 => 0x19 },
	'portraitrawsaturation' => { 103 => 0x17 },
	'portraitrawshadow' => { 103 => 0x7f },
	'portraitrawshadowpoint' => { 103 => 0x1c },
	'portraitrawsharpness' => { 103 => 0x1a },
	'portraitrefiner' => { 107 => 0x302b },
	'portraitunsharpmaskfineness' => { 103 => 0x9a },
	'portraitunsharpmaskstrength' => { 103 => 0x98 },
	'portraitunsharpmaskthreshold' => { 103 => 0x9c },
	'poseheadingdegrees' => { 432 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 432 => 'PosePitchDegrees' },
	'poserolldegrees' => { 432 => 'PoseRollDegrees' },
	'positiondescriptor' => { 458 => 'positionDescriptor' },
	'postalcode' => { 152 => 'PostalCode' },
	'postcropvignetteamount' => { 445 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 445 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 445 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 445 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 445 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 445 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 389 => 0xb },
	'potentialface2position' => { 389 => 0x15 },
	'potentialface3position' => { 389 => 0x1f },
	'potentialface4position' => { 389 => 0x29 },
	'potentialface5position' => { 389 => 0x33 },
	'potentialface6position' => { 389 => 0x3d },
	'potentialface7position' => { 389 => 0x47 },
	'potentialface8position' => { 389 => 0x51 },
	'powersource' => { 314 => '0.1' },
	'poweruptime' => { 214 => 0xb6 },
	'precaptureframes' => { 282 => 0x300 },
	'predictor' => { 113 => 0x13d },
	'preflashreturnstrength' => { 229 => 0x28a },
	'prefs' => { 125 => 0xdd, 347 => 'Prefs' },
	'prereadfastresetcount' => { 131 => 0x187e },
	'preservedfilename' => { 470 => 'PreservedFileName' },
	'preservedspecimen' => { 112 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 112 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 174 => 0x24, 424 => 0x8002 },
	'presetwhitebalanceadj' => { 424 => 0x8014 },
	'pressure' => { 113 => 0x9402, 450 => 'Pressure' },
	'previewapplicationname' => { 113 => 0xc716 },
	'previewapplicationversion' => { 113 => 0xc717 },
	'previewbutton' => { 260 => ['14.1','15.1'], 261 => '15.1', 263 => '15.1', 264 => '15.1', 269 => '29.1', 270 => '14.1', 273 => '15.1', 274 => '15.1' },
	'previewbuttonplusdials' => { 260 => ['14.2','15.2'], 261 => '15.2', 263 => '43.1', 264 => '43.1', 269 => '31.2', 273 => '43.1', 274 => '43.1' },
	'previewcolorspace' => { 113 => 0xc71a },
	'previewcropbottom' => { 346 => 0xef },
	'previewcropleft' => { 346 => 0xec },
	'previewcropright' => { 346 => 0xee },
	'previewcroptop' => { 346 => 0xed },
	'previewdate' => { 354 => 0x0 },
	'previewdatetime' => { 113 => 0xc71b },
	'previewimage' => { 107 => 0x2000, 108 => 'PreviewImage', 114 => 'PreviewImage', 116 => 0x4, 157 => 'data', 176 => 0x81, 282 => 0x280, 298 => 0x300, 391 => 0x2001 },
	'previewimageborders' => { 335 => 0x3e },
	'previewimageheight' => { 69 => 0x4, 135 => 0xfa58 },
	'previewimagelength' => { 69 => 0x2, 107 => 0x3, 113 => [0x117,0x202], 176 => 0x89, 218 => 0x202, 277 => 0x102, 282 => 0x1037, 335 => 0x3, 360 => 0x1e, 365 => 0x3, 371 => [0x1b,0x1d], 382 => 0x202 },
	'previewimagename' => { 157 => '1Name' },
	'previewimagesize' => { 107 => 0x2, 140 => 0x2, 157 => 'ImageSize', 335 => 0x2, 371 => [0x1c,0x1e], 391 => 0xb02c, 424 => 0x9012 },
	'previewimagestart' => { 69 => 0x5, 107 => 0x4, 113 => [0x111,0x201], 176 => 0x88, 218 => 0x201, 277 => 0x101, 282 => 0x1036, 335 => 0x4, 360 => 0x1c, 365 => 0x2, 371 => [0x1a,0x1c], 382 => 0x201 },
	'previewimagetype' => { 157 => '0Type' },
	'previewimagevalid' => { 277 => 0x100, 282 => 0x1035 },
	'previewimagewidth' => { 69 => 0x3, 135 => 0xfa57 },
	'previewquality' => { 69 => 0x1 },
	'previewsettingsdigest' => { 113 => 0xc719 },
	'previewsettingsname' => { 113 => 0xc718 },
	'primaryafpoint' => { 183 => [0x44,0x7] },
	'primarychromaticities' => { 113 => 0x13f, 465 => 'PrimaryChromaticities' },
	'primaryftp' => { 434 => 'PrimaryFTP' },
	'primaryslot' => { 232 => 0xe7f, 241 => 0xfbf },
	'printim' => { 113 => 0xc4a5 },
	'prioritysetinawb' => { 391 => 0x202b },
	'prioritysetupshutterrelease' => { 174 => 0x1d, 379 => 0x28 },
	'privatertkinfo' => { 436 => 'privateRTKInfo' },
	'processbordercolsleft' => { 131 => 0xc61 },
	'processbordercolsright' => { 131 => 0xc62 },
	'processborderrowsbottom' => { 131 => 0xc64 },
	'processborderrowstop' => { 131 => 0xc63 },
	'processingsoftware' => { 113 => 0xb },
	'processversion' => { 445 => 'ProcessVersion' },
	'producer' => { 286 => 'Producer', 456 => 'Producer' },
	'productcode' => { 459 => 'productCode' },
	'productid' => { 126 => 0x32, 458 => 'productID' },
	'productidtype' => { 458 => 'productIDType' },
	'productinimage' => { 455 => 'ProductInImage' },
	'productinimagedescription' => { 455 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 455 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 455 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 315 => 0x2 },
	'productorserviceconstraints' => { 287 => 'ProductOrServiceConstraints' },
	'profession' => { 459 => 'profession' },
	'profilecalibrationsig' => { 113 => 0xc6f4 },
	'profilecopyright' => { 113 => 0xc6fe },
	'profileembedpolicy' => { 113 => 0xc6fd },
	'profilehuesatmapdata1' => { 113 => 0xc6fa },
	'profilehuesatmapdata2' => { 113 => 0xc6fb },
	'profilehuesatmapdims' => { 113 => 0xc6f9 },
	'profilehuesatmapencoding' => { 113 => 0xc7a3 },
	'profilelooktabledata' => { 113 => 0xc726 },
	'profilelooktabledims' => { 113 => 0xc725 },
	'profilelooktableencoding' => { 113 => 0xc7a4 },
	'profilename' => { 113 => 0xc6f8 },
	'profiletonecurve' => { 113 => 0xc6fc },
	'programiso' => { 300 => 0x3c },
	'programline' => { 316 => '1.1' },
	'programmode' => { 179 => 0x5 },
	'programshift' => { 214 => 0xd },
	'programversion' => { 125 => 0x46 },
	'prohibits' => { 442 => 'prohibits' },
	'projectiontype' => { 432 => 'ProjectionType', 433 => 'ProjectionType' },
	'projectname' => { 469 => 'projectName' },
	'projectref' => { 469 => 'projectRef' },
	'projectrefpath' => { 469 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 469 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 287 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 287 => 'PropertyReleaseStatus' },
	'province-state' => { 125 => 0x5f },
	'publicationdate' => { 459 => 'publicationDate' },
	'publicationdatea-platform' => { 459 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 459 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 459 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 459 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 459 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 455 => 'PublicationEvent' },
	'publicationeventdate' => { 455 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 455 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 455 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 459 => 'publicationName' },
	'publisher' => { 446 => 'publisher' },
	'publishingfrequency' => { 459 => 'publishingFrequency' },
	'pulldown' => { 469 => 'pullDown' },
	'purplehsl' => { 97 => 0x20916 },
	'pxshiftperiphedgenr' => { 424 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 424 => 0x9014 },
	'quality' => { 0 => 0x1, 33 => 0x3, 106 => 0x2, 107 => 0x3002, 121 => 0x1000, 133 => 0x9, 214 => 0x4, 243 => 0x3, 282 => 0x201, 295 => 0x300, 335 => 0x8, 342 => 0x2, 371 => 0x16, 379 => 0x56, 380 => 0x56, 381 => 0xb, 391 => [0x102,0x202e] },
	'quality2' => { 399 => 0x1170, 400 => 0x1174, 401 => 0x1150, 403 => 0x11a8, 404 => 0x1060, 405 => 0x258, 406 => 0x258, 407 => 0x247, 411 => 0x29, 412 => 0x25, 413 => 0x2a },
	'qualitymode' => { 107 => 0x8 },
	'quantizationmethod' => { 127 => 0x78 },
	'quickadjust' => { 256 => 0x2a },
	'quickcontroldialinmeter' => { 78 => 0x703 },
	'quickfix' => { 253 => 0x416391c6 },
	'quickshot' => { 370 => 0x213 },
	'quiettime' => { 131 => 0x188a },
	'rangefinder' => { 265 => '4.1', 266 => '5.1', 267 => '5.1' },
	'rasterizedcaption' => { 125 => 0x7d },
	'rating' => { 113 => 0x4746, 121 => 0x1431, 346 => 0xdf, 391 => 0x2002, 439 => 'rating', 447 => 'rating', 455 => 'Rating', 459 => 'rating', 467 => 'Rating' },
	'ratingpercent' => { 113 => 0x4749, 169 => 'Rating' },
	'ratingratingregion' => { 455 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 455 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 455 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 455 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 455 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 455 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 455 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 455 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 455 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 455 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 455 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 455 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 455 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 455 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 455 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 455 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 455 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 455 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 76 => 0x8, 176 => 0x109, 316 => 0xd },
	'rawbrightnessadj' => { 97 => 0x20001, 102 => 0x38 },
	'rawcoloradj' => { 102 => 0x2e },
	'rawcropbottom' => { 346 => 0xd4 },
	'rawcropleft' => { 346 => 0xd1 },
	'rawcropright' => { 346 => 0xd3 },
	'rawcroptop' => { 346 => 0xd2 },
	'rawcustomsaturation' => { 102 => 0x30 },
	'rawcustomtone' => { 102 => 0x34 },
	'rawdata' => { 368 => 0xa048 },
	'rawdatabyteorder' => { 368 => 0x40 },
	'rawdatacfapattern' => { 368 => 0x50 },
	'rawdatauniqueid' => { 113 => 0xc65d },
	'rawdepth' => { 178 => 0x10 },
	'rawdevartfilter' => { 284 => 0x121 },
	'rawdevautogradation' => { 284 => 0x119 },
	'rawdevcolorspace' => { 283 => 0x108, 284 => 0x109 },
	'rawdevcontrastvalue' => { 283 => 0x106, 284 => 0x105 },
	'rawdeveditstatus' => { 283 => 0x10b },
	'rawdevelopmentprocess' => { 335 => 0x62 },
	'rawdevengine' => { 283 => 0x109, 284 => 0x10b },
	'rawdevexposurebiasvalue' => { 283 => 0x100, 284 => 0x100 },
	'rawdevgradation' => { 284 => 0x112 },
	'rawdevgraypoint' => { 283 => 0x103, 284 => 0x104 },
	'rawdevmemorycoloremphasis' => { 283 => 0x105, 284 => 0x108 },
	'rawdevnoisereduction' => { 283 => 0x10a, 284 => 0x10a },
	'rawdevpicturemode' => { 284 => 0x10c },
	'rawdevpm_bwfilter' => { 284 => 0x110 },
	'rawdevpmcontrast' => { 284 => 0x10e },
	'rawdevpmnoisefilter' => { 284 => 0x120 },
	'rawdevpmpicturetone' => { 284 => 0x111 },
	'rawdevpmsaturation' => { 284 => 0x10d },
	'rawdevpmsharpness' => { 284 => 0x10f },
	'rawdevsaturation3' => { 284 => 0x113 },
	'rawdevsaturationemphasis' => { 283 => 0x104, 284 => 0x107 },
	'rawdevsettings' => { 283 => 0x10c },
	'rawdevsharpnessvalue' => { 283 => 0x107, 284 => 0x106 },
	'rawdevversion' => { 283 => 0x0, 284 => 0x0 },
	'rawdevwbfineadjustment' => { 283 => 0x102, 284 => 0x103 },
	'rawdevwhitebalance' => { 284 => 0x101 },
	'rawdevwhitebalancevalue' => { 283 => 0x101, 284 => 0x102 },
	'rawfile' => { 113 => 0xfe4c },
	'rawfilename' => { 445 => 'RawFileName' },
	'rawfiletype' => { 391 => 0x2029 },
	'rawformat' => { 305 => 0x2d, 344 => 0x10e },
	'rawimagecenter' => { 214 => 0x99 },
	'rawimagedigest' => { 113 => 0xc71c },
	'rawimagesize' => { 335 => 0x39 },
	'rawinfoversion' => { 285 => 0x0 },
	'rawjpgheight' => { 93 => 0x4 },
	'rawjpgquality' => { 54 => 0x6, 93 => 0x1 },
	'rawjpgsize' => { 54 => 0x7, 93 => 0x2 },
	'rawjpgwidth' => { 93 => 0x3 },
	'rawmeasuredrggb' => { 40 => 0x26a, 42 => 0x280, 44 => 0x194, 45 => [0x1ad,0x26b] },
	'rawrppused' => { 439 => 'rawrppused' },
	'rawtopreviewgain' => { 113 => 0xc7a8 },
	'readouttypeactual' => { 131 => 0x1903 },
	'readouttyperequested' => { 131 => 0x1902 },
	'reardisplay' => { 260 => '12.3', 261 => '6.2' },
	'recdevice' => { 455 => 'RecDevice' },
	'recdeviceattlensdescription' => { 455 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 455 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 455 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 455 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 455 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 461 => 'recipeEndingPage' },
	'recipepagerange' => { 461 => 'recipePageRange' },
	'recipesource' => { 461 => 'recipeSource' },
	'recipestartingpage' => { 461 => 'recipeStartingPage' },
	'recipetitle' => { 461 => 'recipeTitle' },
	'recognizedface1age' => { 293 => 0x20 },
	'recognizedface1name' => { 293 => 0x4 },
	'recognizedface1position' => { 293 => 0x18 },
	'recognizedface2age' => { 293 => 0x50 },
	'recognizedface2name' => { 293 => 0x34 },
	'recognizedface2position' => { 293 => 0x48 },
	'recognizedface3age' => { 293 => 0x80 },
	'recognizedface3name' => { 293 => 0x64 },
	'recognizedface3position' => { 293 => 0x78 },
	'recognizedfaceflags' => { 300 => 0x63 },
	'recommendedexposureindex' => { 113 => 0x8832, 450 => 'RecommendedExposureIndex' },
	'record' => { 112 => 'Record' },
	'recordbasisofrecord' => { 112 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 112 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 112 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 112 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 112 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 112 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 174 => 0x4d },
	'recorddynamicproperties' => { 112 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 91 => 0x1804 },
	'recordinformationwithheld' => { 112 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 361 => 0x1000 },
	'recordingmode' => { 106 => 0x1, 342 => 0x1 },
	'recordinstitutioncode' => { 112 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 112 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 107 => 0x3000 },
	'recordownerinstitutioncode' => { 112 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 370 => 0x217 },
	'redbalance' => { 282 => 0x1017, 305 => 0x11, 335 => 0x1c },
	'redcurvelimits' => { 102 => 0x18a },
	'redcurvepoints' => { 101 => 0x2d, 102 => 0x160 },
	'redeyecorrection' => { 257 => 0x0 },
	'redeyeinfo' => { 445 => 'RedEyeInfo' },
	'redeyereduction' => { 174 => 0x41, 379 => 0x6a, 381 => 0x28 },
	'redeyeremoval' => { 300 => 0xb9 },
	'redhsl' => { 97 => 0x20910 },
	'redhue' => { 445 => 'RedHue' },
	'redsaturation' => { 445 => 'RedSaturation' },
	'reductionmatrix1' => { 113 => 0xc625 },
	'reductionmatrix2' => { 113 => 0xc626 },
	'reelname' => { 113 => 0xc789 },
	'reference1' => { 453 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 453 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 113 => 0x214, 465 => 'ReferenceBlackWhite' },
	'referencedate' => { 125 => 0x2f },
	'referencenumber' => { 125 => 0x32 },
	'references' => { 148 => 'References' },
	'referenceservice' => { 125 => 0x2d },
	'regionappliedtodimensions' => { 163 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 163 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 163 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 163 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 163 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 163 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 163 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 163 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 163 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 163 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 163 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 163 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 287 => 'RegionConstraints' },
	'regiondescription' => { 163 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 163 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 163 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 163 => 'Regions' },
	'regioninfodateregionsvalid' => { 166 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 166 => 'RegionInfo' },
	'regioninforegions' => { 166 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 163 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 163 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 166 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 163 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 163 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 163 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 455 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 455 => 'RegistryId' },
	'registryitemid' => { 455 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 455 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 146 => 'data' },
	'relatedaudiofilename' => { 146 => '1Name' },
	'relatedaudiofiletype' => { 146 => '0Type' },
	'relatedimagefileformat' => { 113 => 0x1000 },
	'relatedimageheight' => { 113 => 0x1002 },
	'relatedimagewidth' => { 113 => 0x1001 },
	'relatedresourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 113 => 0xa004, 449 => 'RelatedSoundFile' },
	'relatedvideofile' => { 160 => 'data' },
	'relatedvideofilename' => { 160 => '1Name' },
	'relatedvideofiletype' => { 160 => '0Type' },
	'relation' => { 446 => 'relation' },
	'relationshipaccordingto' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 110 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 469 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 469 => 'relativeTimestamp' },
	'relativetimestampscale' => { 469 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 469 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 260 => '17.8', 261 => '18.5', 263 => '18.4', 264 => '18.4', 269 => '33.8', 270 => '17.6', 273 => '18.5', 274 => '18.4' },
	'releasedate' => { 125 => 0x1e, 439 => 'ReleaseDate', 469 => 'releaseDate' },
	'releasemode' => { 107 => 0x3001, 231 => 0x184d, 391 => 0xb049 },
	'releasemode2' => { 399 => 0x112c, 400 => [0x112c,0x8], 401 => [0x1108,0x8], 402 => [0x1184,0x8], 403 => [0x1160,0x8], 404 => [0x4,0x1018], 405 => [0x4,0x210], 406 => [0x4,0x210], 407 => [0x4,0x208], 409 => [0x67,0x3f], 410 => [0x73,0x4b], 411 => 0x10, 412 => 0x10, 413 => 0x9, 420 => 0x34 },
	'releasemode3' => { 399 => 0x1128, 400 => 0x1128, 401 => 0x1104, 402 => 0x1180, 403 => 0x115c, 404 => 0x1014, 405 => 0x20c, 406 => 0x20c, 407 => 0x204 },
	'releaseready' => { 455 => 'ReleaseReady' },
	'releasesetting' => { 91 => 0x1016 },
	'releasetime' => { 125 => 0x23, 439 => 'ReleaseTime' },
	'remoteonduration' => { 262 => '3.4', 265 => '17.2', 266 => '18.2', 267 => '18.2', 268 => '18.2', 270 => '18.2', 271 => '4.3', 275 => '19.2' },
	'renditionclass' => { 470 => 'RenditionClass' },
	'renditionof' => { 470 => 'RenditionOf' },
	'renditionofalternatepaths' => { 470 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 470 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 470 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 470 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 470 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 470 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 470 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 470 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 470 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 470 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 470 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 470 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 470 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 470 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 470 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 470 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 470 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 470 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 470 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 470 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 470 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 470 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 470 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 470 => 'RenditionParams' },
	'repeatingflashcount' => { 198 => 0xd, 199 => 0xe, 200 => 0xe, 201 => 0xe, 202 => 0xe, 269 => '17.2', 270 => '24.2', 271 => '9.2', 272 => '24.2', 275 => '25.2' },
	'repeatingflashcountbuilt-in' => { 239 => 0x4db },
	'repeatingflashcountexternal' => { 239 => 0x4c3 },
	'repeatingflashoutput' => { 269 => '17.1', 270 => '24.1', 271 => '9.1', 272 => '24.1', 275 => '25.1' },
	'repeatingflashoutputexternal' => { 239 => 0x4c0 },
	'repeatingflashrate' => { 198 => 0xc, 199 => 0xd, 200 => 0xd, 201 => 0xd, 202 => 0xd, 269 => '18.1', 270 => '25.1', 271 => '10.1', 272 => '25.1', 275 => '26.1' },
	'repeatingflashratebuilt-in' => { 239 => 0x4da },
	'repeatingflashrateexternal' => { 239 => 0x4c2 },
	'requires' => { 442 => 'requires' },
	'resampleparams' => { 469 => 'resampleParams' },
	'resampleparamsquality' => { 469 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 131 => 0xe50 },
	'resamplingkerneldenominators067' => { 131 => 0xe4f },
	'resamplingkerneldenominators100' => { 131 => 0xe51 },
	'resaved' => { 370 => 0x21e },
	'resetblacksegrows' => { 131 => 0x181a },
	'resolution' => { 153 => 'Resolution' },
	'resolutionmode' => { 371 => 0x4 },
	'resolutionunit' => { 113 => 0x128, 128 => 0x2, 465 => 'ResolutionUnit' },
	'resourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 112 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 78 => 0x612 },
	'restrictions' => { 462 => 'restrictions' },
	'retouchareafeather' => { 445 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 445 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 445 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 445 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 445 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 445 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 445 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 445 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 445 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 445 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 445 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 445 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 445 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 445 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 445 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 445 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 445 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 445 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 445 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 445 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 445 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 445 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 445 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 445 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 445 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 445 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 445 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 445 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 445 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 445 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 445 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 445 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 445 => 'RetouchAreas' },
	'retouchareaseed' => { 445 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 445 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 445 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 445 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 214 => 0x9e },
	'retouchinfo' => { 445 => 'RetouchInfo' },
	'retouchnefprocessing' => { 220 => 0x5 },
	'retractlensonpoweroff' => { 78 => 0x814 },
	'reuse' => { 287 => 'Reuse' },
	'reuseallowed' => { 472 => 'ReuseAllowed' },
	'reuseprohibited' => { 462 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 267 => '5.2' },
	'reverseindicators' => { 260 => '12.1', 261 => '6.1', 263 => '6.1', 264 => '6.1', 265 => '4.3', 266 => '5.2', 267 => '5.4', 269 => '33.5', 270 => '5.1', 273 => '6.1', 274 => '6.1', 275 => '6.2' },
	'reverseshutterspeedaperture' => { 267 => '5.3' },
	'revision' => { 447 => 'revision' },
	'rflensmffocusringsensitivity' => { 78 => 0x714 },
	'rgbcurvelimits' => { 102 => 0x238 },
	'rgbcurvepoints' => { 101 => 0x7, 102 => 0x20e },
	'richtextcomment' => { 452 => 'RichTextComment' },
	'ricohdate' => { 360 => 0x6 },
	'ricohimageheight' => { 360 => 0x2 },
	'ricohimagewidth' => { 360 => 0x0 },
	'rightalbedo' => { 435 => 'RightAlbedo' },
	'rightascension' => { 156 => 'RightAscension' },
	'rights' => { 446 => 'rights' },
	'rightsagent' => { 462 => 'rightsAgent' },
	'rightsowner' => { 462 => 'rightsOwner' },
	'roll' => { 109 => 0x8 },
	'rollangle' => { 231 => 0x350b, 232 => 0x2c24, 240 => 0x36f4, 277 => 0x903, 300 => 0x90, 334 => 0x1, 366 => 0x2 },
	'romoperationmode' => { 91 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 90 => 0x3, 97 => 0x10002, 102 => 0x26e, 108 => 'Rotation', 117 => 0x4, 156 => 'Rotation', 172 => [0x65,0x50], 173 => 0x46, 174 => 0x5a, 177 => 0x10, 231 => 0x3693, 232 => 0xca, 238 => '590.1', 253 => 0x76a43207, 300 => 0x30, 316 => '17.2', 346 => 0xd8, 379 => 0x3f, 380 => 0x3f, 390 => 0x10 },
	'routedto' => { 451 => 'RoutedTo' },
	'routing' => { 351 => 'Routing' },
	'routingdestinations' => { 434 => 'RoutingDestinations' },
	'routingexclusions' => { 434 => 'RoutingExclusions' },
	'routingnotes' => { 451 => 'RoutingNotes' },
	'rowsperstrip' => { 113 => 0x116 },
	'rpp' => { 439 => 'rpp' },
	'safetyshift' => { 78 => 0x108 },
	'safetyshiftinavortv' => { 76 => 0x10, 77 => 0x10, 79 => 0xf, 80 => 0x10, 83 => 0x10 },
	'sameexposurefornewaperture' => { 78 => 0x112 },
	'samplebits' => { 146 => 'SampleBits' },
	'samplepagerange' => { 459 => 'samplePageRange' },
	'samplerate' => { 146 => 'SampleRate' },
	'samplesperpixel' => { 113 => 0x115, 305 => 0x8, 465 => 'SamplesPerPixel' },
	'samplestructure' => { 127 => 0x5a },
	'samsungmodelid' => { 368 => 0x3 },
	'sanyoquality' => { 370 => 0x201 },
	'sanyothumbnail' => { 370 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 48 => 0x1, 106 => 0xd, 107 => [0x3013,0x1f], 113 => [0xa409,0xfe55], 121 => 0x1003, 147 => 'Saturation', 171 => 0x1f, 172 => 0x32, 173 => 0x28, 174 => 0x1a, 179 => 0x1, 214 => [0x94,0xaa], 216 => 0x35, 217 => 0x3b, 300 => 0x40, 302 => 0x300d, 335 => 0x1f, 342 => 0xd, 356 => 0x27, 360 => 0x28, 361 => 0x1013, 371 => 0x10, 379 => 0x1e, 380 => 0x1b, 391 => 0x2005, 445 => 'Saturation', 449 => 'Saturation' },
	'saturationadj' => { 97 => 0x20901, 102 => 0x116, 252 => 0x1, 256 => 0x2e, 424 => 0x8016 },
	'saturationadjustmentaqua' => { 445 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 445 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 445 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 445 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 445 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 445 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 445 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 445 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 67 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 66 => 0x68, 67 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 66 => 0x38, 67 => 0x38 },
	'saturationmonochrome' => { 66 => 0x80, 67 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 66 => 0x50, 67 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 66 => 0x20, 67 => 0x20 },
	'saturationsetting' => { 285 => 0x1010, 381 => 0x11, 396 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 66 => 0x8, 67 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 66 => 0x98, 67 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 66 => 0xb0, 67 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 66 => 0xc8, 67 => 0xe0 },
	'saveid' => { 470 => 'SaveID' },
	'sbaanalysiscomplete' => { 131 => 0xc35 },
	'sbablack' => { 131 => 0xc25 },
	'sbagmoffset' => { 131 => 0xc4a },
	'sbagray' => { 131 => 0xc26 },
	'sbagreenmagentabal' => { 131 => 0xc33 },
	'sbahighgray' => { 131 => 0xc46 },
	'sbailloffset' => { 131 => 0xc49 },
	'sbailluminantbal' => { 131 => 0xc34 },
	'sbalowgray' => { 131 => 0xc47 },
	'sbaneutralbal' => { 131 => 0xc32 },
	'sbawhite' => { 131 => 0xc27 },
	'scaletype' => { 469 => 'scaleType' },
	'scanimageenhancer' => { 221 => 0x60 },
	'scanningdirection' => { 127 => 0x64 },
	'scene' => { 454 => 'Scene', 469 => 'scene' },
	'scenearea' => { 280 => 0x211, 282 => 0x1031 },
	'sceneassist' => { 214 => 0x9c },
	'scenecapturetype' => { 113 => 0xa406, 449 => 'SceneCaptureType' },
	'scenedetect' => { 280 => 0x210, 282 => 0x1030 },
	'scenedetectdata' => { 280 => 0x212, 282 => 0x1033 },
	'scenemode' => { 135 => 0xfa02, 176 => 0x100, 214 => 0x8f, 277 => 0x509, 282 => 0x403, 300 => 0x8001, 309 => 0xf, 391 => 0xb023 },
	'scenemodeused' => { 137 => [0x6002,0xf002] },
	'scenerecognition' => { 121 => 0x1425 },
	'sceneselect' => { 370 => 0x21f },
	'scenetype' => { 113 => 0xa301, 449 => 'SceneType' },
	'screentips' => { 260 => '12.7', 261 => '5.3', 269 => '13.1', 270 => '4.4', 273 => '5.4', 275 => '5.1' },
	'scriptversion' => { 131 => 0x1770 },
	'season' => { 455 => 'Season', 458 => 'season' },
	'seasonidentifier' => { 455 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 455 => [\'Season','SeasonName'] },
	'seasonnumber' => { 455 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 434 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 231 => 0x1d0, 240 => 0x1d0 },
	'section' => { 459 => 'section' },
	'securityclassification' => { 113 => 0x9212 },
	'selectableafpoint' => { 78 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 78 => 0x512 },
	'selftimer' => { 33 => 0x2, 300 => 0x2e, 370 => 0x214, 399 => 0x1134, 400 => 0x1134, 401 => 0x1110, 402 => 0x118c, 403 => 0x1168, 404 => 0x1020, 405 => 0x218, 406 => 0x218, 407 => 0x210 },
	'selftimer2' => { 72 => 0x1d },
	'selftimerinterval' => { 270 => '19.2' },
	'selftimermode' => { 113 => 0x882b },
	'selftimershotcount' => { 261 => '20.2', 263 => '20.3', 264 => '20.3', 265 => '18.2', 266 => '19.2', 267 => '19.2', 268 => '19.3', 270 => '19.3', 273 => '20.3', 274 => '20.3', 275 => '20.2' },
	'selftimershotinterval' => { 261 => '20.3', 263 => '20.2', 264 => '20.2', 268 => '19.2', 273 => '20.2', 274 => '20.2' },
	'selftimertime' => { 91 => 0x1806, 174 => 0x1f, 260 => '18.1', 261 => '20.1', 262 => '3.3', 263 => '20.1', 264 => '20.1', 265 => '18.1', 266 => '19.1', 267 => '19.1', 268 => '19.1', 269 => '7.2', 270 => '19.1', 271 => '3.3', 273 => '20.1', 274 => '20.1', 275 => '20.1' },
	'sellingagency' => { 459 => 'sellingAgency' },
	'seminfo' => { 113 => 0x8546 },
	'sensingmethod' => { 113 => 0xa217, 449 => 'SensingMethod' },
	'sensitivityadjust' => { 335 => 0x40 },
	'sensitivitysteps' => { 316 => ['14.3','17.4'], 318 => 0x1 },
	'sensitivitytype' => { 113 => 0x8830, 450 => 'SensitivityType' },
	'sensor' => { 181 => 0x665e },
	'sensorareas' => { 368 => 0xa010 },
	'sensorbitdepth' => { 302 => 0x312d },
	'sensorbluelevel' => { 70 => 0x5 },
	'sensorcalibration' => { 281 => 0x805 },
	'sensorcleaning' => { 84 => 0xd },
	'sensorfullheight' => { 130 => 0xf904 },
	'sensorfullwidth' => { 130 => 0xf903 },
	'sensorheight' => { 130 => 0xf901, 135 => 0xfa21, 178 => 0x8, 302 => 0x312c, 344 => 0x109, 361 => 0x1602 },
	'sensorimageheight' => { 131 => 0x3ee },
	'sensorimagewidth' => { 131 => 0x3ed },
	'sensorleftborder' => { 131 => 0x3eb },
	'sensorleftmargin' => { 344 => 0x10a },
	'sensorpixelsize' => { 214 => 0x9a },
	'sensorredlevel' => { 70 => 0x4 },
	'sensorserialnumber' => { 131 => 0x9ce },
	'sensorsize' => { 147 => 'SensorSize', 335 => 0x35 },
	'sensortemperature' => { 280 => 0x1500, 282 => 0x1007, 340 => 0xc, 344 => 0x210, 371 => [0x39,0x55] },
	'sensortemperature2' => { 340 => 0xe, 344 => 0x211 },
	'sensortopborder' => { 131 => 0x3ec },
	'sensortopmargin' => { 344 => 0x10b },
	'sensorwidth' => { 130 => 0xf900, 135 => 0xfa20, 178 => 0xa, 302 => 0x312b, 344 => 0x108, 361 => 0x1601 },
	'sequence' => { 356 => 0x7, 357 => 0x35 },
	'sequencefilenumber' => { 400 => 0x4, 401 => 0x4, 402 => 0x4, 403 => 0x4, 411 => 0xc, 412 => 0xc, 413 => 0x1a },
	'sequenceimagenumber' => { 400 => 0x0, 401 => 0x0, 402 => 0x0, 403 => 0x0, 411 => 0x8, 412 => 0x8, 413 => 0x12, 420 => 0x24 },
	'sequencelength' => { 411 => 0x22, 412 => 0x1e, 413 => [0x16,0x1e] },
	'sequencename' => { 458 => 'sequenceName' },
	'sequencenumber' => { 72 => 0x9, 107 => 0x301c, 121 => 0x1101, 133 => 0x1d, 239 => 0x51c, 300 => 0x2b, 381 => [0x10c,0x30c], 391 => 0xb04a, 458 => 'sequenceNumber' },
	'sequenceshotinterval' => { 370 => 0x224 },
	'sequencetotalnumber' => { 458 => 'sequenceTotalNumber' },
	'sequentialshot' => { 370 => 0x20e },
	'serialnumber' => { 60 => 0xc, 91 => 0x180b, 113 => [0xa431,0xfde9], 130 => 0xfa04, 132 => 0xfa00, 134 => 0xc354, 135 => 0xfa19, 144 => 0x0, 147 => 'SerialNumber', 214 => [0xa0,0x1d], 278 => 0x101, 282 => [0x404,0x101a], 295 => 0x303, 297 => 0x305, 302 => 0x3103, 335 => 0x229, 344 => 0x102, 345 => 0x407, 356 => 0x15, 357 => 0x4b, 361 => 0x5, 368 => 0xa002, 371 => 0x2, 391 => 0x2031, 441 => 'SerialNumber', 450 => 'BodySerialNumber' },
	'serialnumberformat' => { 60 => 0x15, 91 => 0x183b },
	'series' => { 455 => 'Series' },
	'seriesdatetime' => { 426 => 'SeriesDateTime' },
	'seriesdescription' => { 426 => 'SeriesDescription' },
	'seriesidentifier' => { 455 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 426 => 'SeriesModality' },
	'seriesname' => { 455 => [\'Series','SeriesName'] },
	'seriesnumber' => { 426 => 'SeriesNumber', 459 => 'seriesNumber' },
	'seriestitle' => { 459 => 'seriesTitle' },
	'serviceidentifier' => { 126 => 0x1e },
	'servingsize' => { 461 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 81 => 0x0, 82 => 0x0 },
	'setbuttonwhenshooting' => { 76 => 0x1, 78 => 0x704, 84 => 0xc },
	'setfunctionwhenshooting' => { 79 => 0x0, 80 => 0x1, 83 => 0x1 },
	'setting' => { 458 => 'setting' },
	'shadingcompensation' => { 277 => 0x50c, 300 => 0x8a },
	'shadingcompensation2' => { 281 => 0x1012 },
	'shadow' => { 371 => 0xe },
	'shadowadj' => { 97 => 0x2030b },
	'shadowcorrection' => { 335 => 0x79 },
	'shadowprotection' => { 252 => 0x0 },
	'shadows' => { 113 => 0xfe52, 438 => 'Shadows', 445 => 'Shadows' },
	'shadows2012' => { 445 => 'Shadows2012' },
	'shadowsadj' => { 424 => 0x901a },
	'shadowscale' => { 113 => 0xc633 },
	'shadowtint' => { 445 => 'ShadowTint' },
	'shadowtone' => { 121 => 0x1040 },
	'shakereduction' => { 337 => 0x1, 338 => 0x1 },
	'sharpendetail' => { 445 => 'SharpenDetail' },
	'sharpenedgemasking' => { 445 => 'SharpenEdgeMasking' },
	'sharpening' => { 302 => 0x300b },
	'sharpeningadj' => { 256 => 0x2b },
	'sharpeningkernel' => { 131 => 0x92f },
	'sharpenradius' => { 445 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 70 => 0x2, 106 => 0xb, 107 => [0x3011,0x21], 113 => [0xa40a,0xfe56], 121 => 0x1001, 133 => 0x6b, 142 => 0x37, 147 => 'Sharpness', 171 => 0x21, 172 => 0x30, 173 => 0x26, 174 => 0x18, 179 => 0x3, 214 => 0x6, 216 => 0x32, 217 => 0x33, 282 => 0x100f, 300 => 0x41, 335 => 0x21, 342 => 0xb, 356 => 0x26, 360 => 0x22, 361 => [0x1003,0x1014], 371 => 0x11, 379 => 0x1c, 380 => 0x19, 391 => 0x2006, 420 => 0x52, 445 => 'Sharpness', 449 => 'Sharpness' },
	'sharpnessadj' => { 97 => 0x20310, 102 => 0x25a, 424 => 0x801a },
	'sharpnessadjon' => { 97 => '0x20310.0' },
	'sharpnessauto' => { 67 => 0x94 },
	'sharpnessfactor' => { 282 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 66 => 0x64, 67 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 70 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 66 => 0x34, 67 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 66 => 0x7c, 67 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 66 => 0x4c, 67 => 0x4c },
	'sharpnessovershoot' => { 424 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 66 => 0x1c, 67 => 0x1c },
	'sharpnesssetting' => { 277 => 0x506, 285 => 0x1013, 381 => 0x12, 396 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 66 => 0x4, 67 => 0x4 },
	'sharpnessstrength' => { 97 => 0x20311 },
	'sharpnessthreshold' => { 424 => 0x801d },
	'sharpnessundershoot' => { 424 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 66 => 0x94, 67 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 66 => 0xac, 67 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 66 => 0xc4, 67 => 0xdc },
	'shiftcols' => { 131 => 0xc70 },
	'shootid' => { 458 => 'shootID' },
	'shootingdistance' => { 97 => 0x20701 },
	'shootinginfodisplay' => { 260 => '13.2', 261 => '5.1', 269 => '10.2', 270 => '4.1', 273 => '5.1', 275 => '5.3' },
	'shootinginfomonitorofftime' => { 260 => '26.2', 261 => '22.2', 263 => '22.2', 264 => '22.2', 268 => '21.2', 269 => '9.1', 270 => '21.2', 273 => '22.2', 274 => '22.2', 275 => '22.2' },
	'shootingmode' => { 147 => 'ShootingMode', 214 => 0x89, 300 => 0x1f },
	'shootingmodesetting' => { 262 => '5.1' },
	'shortdescription' => { 447 => 'shortdescription' },
	'shortdocumentid' => { 125 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 78 => 0x80d },
	'shotdate' => { 469 => 'shotDate' },
	'shotday' => { 469 => 'shotDay' },
	'shotlocation' => { 469 => 'shotLocation' },
	'shotname' => { 469 => 'shotName' },
	'shotnumber' => { 469 => 'shotNumber' },
	'shotnumbersincepowerup' => { 395 => 0x44e, 411 => 0x1a, 412 => 0x16, 413 => 0xa },
	'shotnumbersincepowerup2' => { 381 => 0x200 },
	'shotsize' => { 469 => 'shotSize' },
	'shownevent' => { 455 => 'EventExt' },
	'showneventidentifier' => { 455 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 455 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 76 => 0x4, 78 => 0x701, 79 => 0x3, 80 => 0x4, 81 => 0x3, 82 => 0x3, 83 => 0x4, 84 => 0x2 },
	'shutteraelbutton' => { 77 => 0x4 },
	'shutterbuttonafonbutton' => { 78 => 0x701 },
	'shuttercount' => { 10 => 0x176, 54 => 0x1, 214 => 0xa7, 222 => [0x6a,0x157,0x24d], 223 => 0x286, 224 => 0x279, 225 => 0x284, 226 => 0x242, 227 => 0x280, 228 => 0x276, 229 => [0x27d,0x27f], 230 => 0x246, 233 => 0x2d6, 234 => 0x321, 235 => 0xbd8, 236 => 0x287, 237 => 0x320, 238 => 0x24a, 239 => 0x5fb, 242 => 0x2d5, 335 => 0x5d, 390 => 0x846, 394 => [0x125,0x14a] },
	'shuttercurtainsync' => { 76 => 0xf, 77 => 0xf, 78 => 0x305, 79 => 0xe, 80 => 0xf, 81 => 0x8, 82 => 0x8, 83 => 0xf, 84 => 0x8 },
	'shuttermode' => { 133 => 0x1b, 214 => 0x34 },
	'shutterreleasebuttonae-l' => { 260 => '17.7', 261 => '18.4', 263 => '78.4', 264 => '78.4', 265 => '16.1', 266 => '17.1', 267 => '17.1', 268 => '17.1', 269 => '7.1', 270 => '17.5', 273 => '18.4', 274 => '78.4', 275 => '18.2' },
	'shutterreleasemethod' => { 91 => 0x1010 },
	'shutterreleasenocfcard' => { 76 => 0x2, 77 => 0x2, 84 => 0xf },
	'shutterreleasetiming' => { 91 => 0x1011 },
	'shutterreleasewithoutlens' => { 78 => 0x711 },
	'shutterspeedlock' => { 261 => '38.1', 263 => '38.1', 264 => '38.1', 273 => '38.1', 274 => '38.1' },
	'shutterspeedrange' => { 78 => 0x10c },
	'shutterspeedsetting' => { 174 => 0x6, 379 => 0x2f, 380 => 0x28, 381 => 0x0 },
	'shutterspeedvalue' => { 87 => 0x1, 113 => 0x9201, 282 => 0x1000, 344 => 0x400, 449 => 'ShutterSpeedValue' },
	'shuttertype' => { 121 => 0x1050, 300 => 0x9f },
	'sidecarforextension' => { 457 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 131 => 0xe0d },
	'sigmascalingfactorcamera' => { 131 => 0xe0c },
	'sigmascalingfactorlowres' => { 131 => 0xe0b },
	'sigmasizetable' => { 131 => 0xe0f },
	'similarityindex' => { 125 => 0xe4 },
	'singleframebracketing' => { 174 => 0x21 },
	'skilllevel' => { 461 => 'skillLevel' },
	'skintonecorrection' => { 335 => 0x95 },
	'skiplinetime' => { 131 => 0x184e },
	'slaveflashmeteringsegments' => { 335 => 0x20b },
	'slideshowname' => { 458 => 'slideshowName' },
	'slideshownumber' => { 458 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 458 => 'slideshowTotalNumber' },
	'slowshutter' => { 72 => 0x8 },
	'slowsync' => { 121 => 0x1030 },
	'smartalbumcolor' => { 368 => 0x20 },
	'smartrange' => { 368 => 0xa012 },
	'smileshutter' => { 381 => 0x31 },
	'smileshuttermode' => { 381 => 0x27 },
	'smoothness' => { 113 => 0xfe57, 445 => 'Smoothness' },
	'snapshot' => { 455 => 'SnapshotLink' },
	'snapshotformat' => { 455 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 455 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 455 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 455 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 455 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 439 => 'Snapshots' },
	'snapshotusedvideoframe' => { 455 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 455 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 455 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 455 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 455 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 391 => 0x200f },
	'software' => { 113 => 0x131, 148 => 'Software', 290 => 'Software', 344 => 0x203, 371 => 0x18, 429 => 'Software', 465 => 'Software' },
	'softwareversion' => { 370 => 0x207 },
	'sonydatetime' => { 398 => 0x6, 400 => 0x1b6, 401 => 0x210, 402 => 0x1fe, 403 => 0x22c },
	'sonydatetime2' => { 409 => 0x51 },
	'sonyexposuretime' => { 409 => 0x3a, 410 => 0x46 },
	'sonyexposuretime2' => { 420 => 0xe },
	'sonyfnumber' => { 409 => 0x3c, 410 => 0x48, 420 => 0x14 },
	'sonyimageheight' => { 398 => 0x1a, 411 => 0x44, 412 => 0x3f, 413 => 0x47 },
	'sonyimageheightmax' => { 420 => 0x40 },
	'sonyimagesize' => { 174 => 0x3b, 379 => 0x54, 380 => 0x54, 381 => 0x9 },
	'sonyimagewidth' => { 398 => 0x1c },
	'sonyimagewidthmax' => { 420 => 0x3e },
	'sonyiso' => { 400 => 0x1218, 401 => 0x11f4, 402 => 0x1270, 403 => [0x1254,0x1258,0x1280], 404 => 0x113c, 405 => 0x344, 406 => 0x346, 407 => 0x320, 420 => 0x4 },
	'sonymaxaperture' => { 409 => 0x0, 410 => 0x0 },
	'sonymaxaperturevalue' => { 420 => 0x16 },
	'sonyminaperture' => { 409 => 0x1, 410 => 0x1 },
	'sonymodelid' => { 391 => 0xb001 },
	'sonyquality' => { 174 => 0x3c },
	'sonytimeminsec' => { 410 => 0x61 },
	'source' => { 125 => 0x73, 290 => 'Source', 446 => 'source', 447 => 'source', 457 => 'Source' },
	'sourcecount' => { 433 => 'SourceCount' },
	'sourcedirectoryindex' => { 322 => 0x0 },
	'sourcefileindex' => { 322 => 0x2 },
	'sourcephotoscount' => { 432 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 131 => 0x1390 },
	'spatialfrequencyresponse' => { 449 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 449 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 449 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 449 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 449 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 469 => 'speakerPlacement' },
	'specialeffectlevel' => { 107 => 0x3030 },
	'specialeffectmode' => { 107 => 0x2076 },
	'specialeffectsetting' => { 107 => 0x3031 },
	'specialinstructions' => { 125 => 0x28 },
	'specialmode' => { 282 => 0x200, 370 => 0x200 },
	'specialoccasion' => { 461 => 'specialOccasion' },
	'spectralsensitivity' => { 113 => 0x8824, 449 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => [0x2b9,0x2d0,0x2d4], 44 => 0x1e4, 45 => [0x1fd,0x2dd], 46 => [0x231,0x30f], 47 => 0x31d },
	'speedx' => { 109 => 0x3 },
	'speedy' => { 109 => 0x4 },
	'speedz' => { 109 => 0x5 },
	'spherical' => { 433 => 'Spherical' },
	'splitcolumn' => { 344 => 0x222 },
	'splittoningbalance' => { 445 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 445 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 445 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 445 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 445 => 'SplitToningShadowSaturation' },
	'sport' => { 459 => 'sport' },
	'spotfocuspointx' => { 171 => 0x2d },
	'spotfocuspointy' => { 171 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 78 => 0x107 },
	'sractive' => { 316 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 337 => 0x3 },
	'srhalfpresstime' => { 337 => 0x2 },
	'srresult' => { 337 => 0x0, 338 => 0x0 },
	'stackedimage' => { 277 => 0x804 },
	'standardmatrixcustom' => { 131 => 0x7d4 },
	'standardmatrixdaylight' => { 131 => 0x7d0 },
	'standardmatrixflash' => { 131 => 0x7d3 },
	'standardmatrixfluorescent' => { 131 => 0x7d2 },
	'standardmatrixtungsten' => { 131 => 0x7d1 },
	'standardoutputhighlightpoint' => { 103 => 0x14 },
	'standardoutputsensitivity' => { 113 => 0x8831, 450 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 103 => 0x15 },
	'standardrawcolortone' => { 103 => 0xd },
	'standardrawcontrast' => { 103 => 0xf },
	'standardrawhighlight' => { 103 => 0x75 },
	'standardrawhighlightpoint' => { 103 => 0x12 },
	'standardrawlinear' => { 103 => 0x10 },
	'standardrawsaturation' => { 103 => 0xe },
	'standardrawshadow' => { 103 => 0x7e },
	'standardrawshadowpoint' => { 103 => 0x13 },
	'standardrawsharpness' => { 103 => 0x11 },
	'standardunsharpmaskfineness' => { 103 => 0x94 },
	'standardunsharpmaskstrength' => { 103 => 0x92 },
	'standardunsharpmaskthreshold' => { 103 => 0x96 },
	'standardwhitecustom' => { 131 => 0x838 },
	'standardwhitedaylight' => { 131 => 0x834 },
	'standardwhiteflash' => { 131 => 0x837 },
	'standardwhitefluorescent' => { 131 => 0x836 },
	'standardwhitetungsten' => { 131 => 0x835 },
	'standbytimer' => { 261 => '19.1', 263 => '19.1', 264 => '19.1', 267 => '18.1', 268 => '18.1', 273 => '19.1', 274 => '19.1' },
	'startingpage' => { 459 => 'startingPage' },
	'startmovieshooting' => { 78 => 0x70d },
	'starttimecode' => { 469 => 'startTimecode' },
	'starttimecodetimeformat' => { 469 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 469 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 469 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 469 => 'startTimeSampleSize' },
	'starttimescale' => { 469 => 'startTimeScale' },
	'state' => { 152 => 'State', 300 => 0x6b, 457 => 'State' },
	'status' => { 427 => 'Status', 437 => 'Status' },
	'stereomode' => { 433 => 'StereoMode' },
	'stitched' => { 433 => 'Stitched' },
	'stitchingsoftware' => { 432 => 'StitchingSoftware', 433 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 399 => 0x113e, 400 => 0x113e, 401 => 0x111a, 402 => 0x1196, 403 => 0x1172, 404 => 0x102a, 405 => 0x222, 406 => 0x222, 407 => 0x217, 420 => 0xa },
	'storagemethod' => { 178 => 0x12 },
	'storebyorientation' => { 261 => '46.3', 263 => '47.3', 264 => '47.3', 273 => '47.3', 274 => '47.3' },
	'storylineidentifier' => { 455 => 'StorylineIdentifier' },
	'straightenangle' => { 253 => 0x2fc08431 },
	'streamready' => { 455 => 'StreamReady' },
	'streamtype' => { 167 => 'StreamType' },
	'stretchmode' => { 469 => 'stretchMode' },
	'studydatetime' => { 426 => 'StudyDateTime' },
	'studydescription' => { 426 => 'StudyDescription' },
	'studyid' => { 426 => 'StudyID' },
	'studyphysician' => { 426 => 'StudyPhysician' },
	'styleperiod' => { 455 => 'StylePeriod' },
	'sub-location' => { 125 => 0x5c },
	'subfiledata' => { 155 => 'data' },
	'subfiledirectory' => { 155 => '1Directory' },
	'subfilemimetype' => { 155 => '2MIME' },
	'subfilename' => { 155 => '1Name' },
	'subfileresource' => { 155 => 'rsrc' },
	'subfiletype' => { 113 => 0xfe, 155 => '0Type' },
	'subject' => { 286 => 'Subject', 351 => 'Subject', 446 => 'subject', 456 => 'Subject', 470 => 'subject' },
	'subjectarea' => { 113 => 0x9214, 449 => 'SubjectArea' },
	'subjectcode' => { 454 => 'SubjectCode' },
	'subjectdistance' => { 113 => 0x9206, 133 => 0x3e, 449 => 'SubjectDistance' },
	'subjectdistancerange' => { 113 => 0xa40c, 449 => 'SubjectDistanceRange' },
	'subjectlocation' => { 113 => 0xa214, 449 => 'SubjectLocation' },
	'subjectmotion' => { 263 => '78.2', 264 => '78.2', 274 => '78.2' },
	'subjectprogram' => { 171 => 0x22 },
	'subjectreference' => { 125 => 0xc },
	'sublabels4' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 453 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 453 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 108 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 108 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 108 => 'SubSecModifyDate' },
	'subsectime' => { 113 => 0x9290 },
	'subsectimedigitized' => { 113 => 0x9292 },
	'subsectimeoriginal' => { 113 => 0x9291 },
	'subsection1' => { 459 => 'subsection1' },
	'subsection2' => { 459 => 'subsection2' },
	'subsection3' => { 459 => 'subsection3' },
	'subsection4' => { 459 => 'subsection4' },
	'subselector' => { 261 => '49.1', 263 => '71.1', 264 => '71.1', 274 => '71.1' },
	'subselectorassignment' => { 261 => '48.1' },
	'subselectorcenter' => { 263 => '72.1', 264 => '72.1', 274 => '72.1' },
	'subselectorplusdials' => { 261 => '49.2', 263 => '73.1', 264 => '73.1', 274 => '73.1' },
	'subtitle' => { 459 => 'subtitle' },
	'subversionfilename' => { 453 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 453 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 453 => 'SubVersions' },
	'superimposeddisplay' => { 76 => 0xa, 78 => 0x510, 79 => 0x9, 80 => 0xa, 83 => 0xa, 84 => 0xe },
	'supermacro' => { 60 => 0x1a },
	'supplementalcategories' => { 125 => 0x14, 457 => 'SupplementalCategories' },
	'supplementaltype' => { 127 => 0x37 },
	'supplementdisplayid' => { 459 => 'supplementDisplayID' },
	'supplementstartingpage' => { 459 => 'supplementStartingPage' },
	'supplementtitle' => { 459 => 'supplementTitle' },
	'supplychainsource' => { 455 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 455 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 455 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 316 => 0x14 },
	'swatchcoloranta' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 474 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 474 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 474 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 474 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 474 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 300 => 0x93, 381 => 0x33 },
	'sweeppanoramafieldofview' => { 300 => 0x94 },
	'sweeppanoramasize' => { 381 => 0x32 },
	'switchtoregisteredafpoint' => { 77 => 0x12, 78 => 0x50a },
	'syncreleasemode' => { 263 => '77.1', 264 => '77.1', 274 => '77.1' },
	'system' => { 344 => 0x204 },
	'tagged' => { 346 => 0xdd, 347 => 'Tagged', 439 => 'tagged' },
	'tagslist' => { 448 => 'TagsList' },
	'tagstructure' => { 453 => 'TagStructure' },
	'takenumber' => { 469 => 'takeNumber' },
	'tapename' => { 469 => 'tapeName' },
	'targetaperture' => { 72 => 0x4 },
	'targetcompressionratio' => { 89 => 0x1 },
	'targetdistancesetting' => { 91 => 0x1807 },
	'targetexposuretime' => { 72 => 0x5 },
	'targetimagetype' => { 91 => 0x100a },
	'targetprinter' => { 113 => 0x151 },
	'taxon' => { 112 => 'Taxon' },
	'taxonacceptednameusage' => { 112 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 112 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 112 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 112 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 112 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 112 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 112 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 112 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 112 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 112 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 112 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 112 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 112 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 112 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 112 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 112 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 112 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 112 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 112 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 112 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 112 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 112 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 112 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 112 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 112 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 112 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 112 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 112 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 112 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 112 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 112 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 112 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 112 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 131 => 0x196f },
	'tda1edgepolarity' => { 131 => 0x1971 },
	'tda1gain' => { 131 => 0x1970 },
	'tda1offset' => { 131 => 0x196e },
	'tda2bandwidth' => { 131 => 0x1979 },
	'tda2edgepolarity' => { 131 => 0x197b },
	'tda2gain' => { 131 => 0x197a },
	'tda2offset' => { 131 => 0x1978 },
	'tda3bandwidth' => { 131 => 0x1983 },
	'tda3edgepolarity' => { 131 => 0x1985 },
	'tda3gain' => { 131 => 0x1984 },
	'tda3offset' => { 131 => 0x1982 },
	'tda4bandwidth' => { 131 => 0x198d },
	'tda4edgepolarity' => { 131 => 0x198f },
	'tda4gain' => { 131 => 0x198e },
	'tda4offset' => { 131 => 0x198c },
	'teaser' => { 459 => 'teaser' },
	'teleconverter' => { 176 => 0x105, 391 => 0x105 },
	'tempampgainx100' => { 131 => 0x1914 },
	'tempo' => { 469 => 'tempo' },
	'temporalcoverage' => { 455 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 455 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 455 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 287 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 287 => 'TermsAndConditionsURL' },
	'testname' => { 114 => 'TestName' },
	'textencoding' => { 213 => 0x4 },
	'textlayername' => { 457 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 457 => 'TextLayers' },
	'textlayertext' => { 457 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 300 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 263 => '1.3', 264 => '1.3', 274 => '1.4' },
	'three-dtrackingwatcharea' => { 263 => '78.1', 264 => '78.1', 274 => '78.1' },
	'thresholding' => { 113 => 0x107 },
	'thumbnailfilename' => { 91 => 0x817 },
	'thumbnailformat' => { 467 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 135 => 0xfa55, 467 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 91 => 0x2008, 108 => 'ThumbnailImage', 116 => 0x3, 158 => 'data', 282 => 0x100, 467 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 158 => '1Name' },
	'thumbnailimagesize' => { 158 => 'ImageSize' },
	'thumbnailimagetype' => { 158 => '0Type' },
	'thumbnailimagevalidarea' => { 60 => 0x13 },
	'thumbnaillength' => { 113 => 0x202 },
	'thumbnailoffset' => { 113 => 0x201 },
	'thumbnails' => { 467 => 'Thumbnails' },
	'thumbnailwidth' => { 135 => 0xfa54, 467 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 459 => 'ticker' },
	'tiffhandling' => { 445 => 'TIFFHandling' },
	'tiffmeteringimage' => { 177 => 0x104c, 390 => 0x1110 },
	'tilelength' => { 113 => 0x143 },
	'tilewidth' => { 113 => 0x142 },
	'time' => { 131 => 0x401, 335 => 0x7 },
	'timecodes' => { 113 => 0xc763 },
	'timecreated' => { 125 => 0x3c, 133 => 0x14, 142 => 0x10, 347 => 'TimeCreated' },
	'timelapseshotnumber' => { 303 => 0x10 },
	'timeperiod' => { 459 => 'timePeriod' },
	'timerfunctionbutton' => { 262 => '5.2', 265 => '12.1', 266 => '13.1' },
	'timerlength' => { 78 => 0x80c },
	'timerrecording' => { 300 => 0x96 },
	'timescaleparams' => { 469 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 469 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 469 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 469 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 126 => 0x50 },
	'timeshot' => { 434 => 'TimeShot' },
	'timesignature' => { 469 => 'timeSignature' },
	'timesincepoweron' => { 300 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 276 => 0x8, 290 => 'TimeStamp', 300 => 0xaf, 433 => 'Timestamp', 440 => 'Timestamp', 453 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 73 => 0x1, 245 => 0x0, 364 => 0xa },
	'timezonecity' => { 73 => 0x2 },
	'timezonecode' => { 94 => 0x1 },
	'timezoneinfo' => { 94 => 0x2 },
	'timezoneoffset' => { 113 => 0x882a },
	'tint' => { 445 => 'Tint' },
	'title' => { 148 => 'Title', 286 => 'Title', 290 => 'Title', 300 => 0x65, 351 => 'Title', 446 => 'title', 456 => 'Title', 467 => 'Title' },
	'tonecomp' => { 214 => 0x81 },
	'tonecurve' => { 70 => 0x1, 335 => 0x402, 445 => 'ToneCurve' },
	'tonecurveactive' => { 102 => 0x110 },
	'tonecurveadobergb' => { 368 => 0xa043 },
	'tonecurveadobergbdefault' => { 368 => 0xa041 },
	'tonecurveblue' => { 445 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 424 => 0x9003 },
	'tonecurvebluey' => { 424 => 0x9007 },
	'tonecurvebrightness' => { 97 => 0x20410 },
	'tonecurvebrightnessx' => { 424 => 0x9000 },
	'tonecurvebrightnessy' => { 424 => 0x9004 },
	'tonecurvecolorspace' => { 101 => 0x0 },
	'tonecurvecontrast' => { 97 => 0x20411 },
	'tonecurvegreen' => { 445 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 424 => 0x9002 },
	'tonecurvegreeny' => { 424 => 0x9006 },
	'tonecurveinputrange' => { 101 => 0x3 },
	'tonecurveinterpolation' => { 102 => 0x159 },
	'tonecurvemode' => { 102 => 0x113 },
	'tonecurvename' => { 445 => 'ToneCurveName' },
	'tonecurvename2012' => { 445 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 97 => '0x20400.1' },
	'tonecurveoutputrange' => { 101 => 0x5 },
	'tonecurveprofilename' => { 131 => 0x1391 },
	'tonecurveproperty' => { 102 => 0x3c },
	'tonecurvepv2012' => { 445 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 445 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 445 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 445 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 445 => 'ToneCurveRed' },
	'tonecurveredx' => { 424 => 0x9001 },
	'tonecurveredy' => { 424 => 0x9005 },
	'tonecurves' => { 335 => 0x403 },
	'tonecurveshape' => { 101 => 0x1 },
	'tonecurvesrgb' => { 368 => 0xa042 },
	'tonecurvesrgbdefault' => { 368 => 0xa040 },
	'tonecurvex' => { 101 => 0xa },
	'tonecurvey' => { 101 => 0xb },
	'tonelevel' => { 277 => 0x52e },
	'tonemapstrength' => { 445 => 'ToneMapStrength' },
	'toningeffect' => { 54 => 0xf, 214 => 0xb3, 216 => 0x38, 217 => 0x40, 361 => 0x1015 },
	'toningeffectauto' => { 67 => 0xa4 },
	'toningeffectfaithful' => { 66 => 0x74, 67 => 0x74 },
	'toningeffectlandscape' => { 66 => 0x44, 67 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 66 => 0x8c, 67 => 0x8c },
	'toningeffectneutral' => { 66 => 0x5c, 67 => 0x5c },
	'toningeffectportrait' => { 66 => 0x2c, 67 => 0x2c },
	'toningeffectstandard' => { 66 => 0x14, 67 => 0x14 },
	'toningeffectuserdef1' => { 66 => 0xa4, 67 => 0xbc },
	'toningeffectuserdef2' => { 66 => 0xbc, 67 => 0xd4 },
	'toningeffectuserdef3' => { 66 => 0xd4, 67 => 0xec },
	'toningsaturation' => { 216 => 0x39, 217 => 0x41 },
	'totalzoom' => { 133 => 0x62 },
	'touchae' => { 300 => 0xab },
	'trackcreatedate' => { 355 => 0x1 },
	'trackmodifydate' => { 355 => 0x2 },
	'tracknumber' => { 469 => 'trackNumber' },
	'tracks' => { 469 => 'Tracks' },
	'tracksframerate' => { 469 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 469 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 469 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 469 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 469 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 469 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 469 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 469 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 469 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 469 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 469 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 469 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 469 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 469 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 469 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 469 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 469 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 155 => 'zmie' },
	'transcript' => { 455 => 'Transcript' },
	'transcriptlink' => { 455 => 'TranscriptLink' },
	'transcriptlinklink' => { 455 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 455 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 113 => 0x12d, 465 => 'TransferFunction' },
	'transfertimenormal' => { 131 => 0x1888 },
	'transfertimetest' => { 131 => 0x1889 },
	'transform' => { 300 => [0x8012,0x59] },
	'transmissionreference' => { 457 => 'TransmissionReference' },
	'trapped' => { 286 => 'Trapped', 456 => 'Trapped' },
	'trashbuttonfunction' => { 78 => 0x710 },
	'travelday' => { 300 => 0x36 },
	'triggermode' => { 356 => 0x6, 357 => 0x34 },
	'tstop' => { 113 => 0xc772 },
	'ttl_da_adown' => { 323 => 0x5 },
	'ttl_da_aup' => { 323 => 0x4 },
	'ttl_da_bdown' => { 323 => 0x7 },
	'ttl_da_bup' => { 323 => 0x6 },
	'tungstenawb' => { 313 => 0x1 },
	'tvexposuretimesetting' => { 316 => 0x12 },
	'type' => { 446 => 'type', 464 => 'type' },
	'typestatus' => { 112 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 113 => 0xc614 },
	'uniquedocumentid' => { 125 => 0xbb },
	'uniquematrixauto' => { 131 => 0x7e9 },
	'uniquematrixcustom' => { 131 => 0x7e8 },
	'uniquematrixdaylight' => { 131 => 0x7e4 },
	'uniquematrixflash' => { 131 => 0x7e7 },
	'uniquematrixfluorescent' => { 131 => 0x7e6 },
	'uniquematrixtungsten' => { 131 => 0x7e5 },
	'uniqueobjectname' => { 126 => 0x64 },
	'units' => { 429 => 'Units' },
	'unknownblock' => { 335 => 0x405 },
	'unknownblock1' => { 281 => 0x635 },
	'unknownblock2' => { 281 => 0x636 },
	'unknownblock3' => { 281 => 0x1103 },
	'unknownblock4' => { 281 => 0x1104 },
	'unknowncontrast' => { 103 => 0x45 },
	'unknowndate' => { 344 => 0x212 },
	'unknownev' => { 131 => 0x1 },
	'unknownlinear' => { 103 => 0x46 },
	'unknownnumber' => { 91 => 0x180b },
	'unknownoutputhighlightpoint' => { 103 => 0x4a },
	'unknownoutputshadowpoint' => { 103 => 0x4b },
	'unknownrawhighlight' => { 103 => 0x7b },
	'unknownrawhighlightpoint' => { 103 => 0x48 },
	'unknownrawshadow' => { 103 => 0x84 },
	'unknownrawshadowpoint' => { 103 => 0x49 },
	'unknownsharpness' => { 103 => 0x47 },
	'unknowntemperature' => { 115 => 0x4 },
	'unsharp1color' => { 258 => 0x13 },
	'unsharp1halowidth' => { 258 => 0x19 },
	'unsharp1intensity' => { 258 => 0x17 },
	'unsharp1threshold' => { 258 => 0x1b },
	'unsharp2color' => { 258 => 0x2e },
	'unsharp2halowidth' => { 258 => 0x34 },
	'unsharp2intensity' => { 258 => 0x32 },
	'unsharp2threshold' => { 258 => 0x36 },
	'unsharp3color' => { 258 => 0x49 },
	'unsharp3halowidth' => { 258 => 0x4f },
	'unsharp3intensity' => { 258 => 0x4d },
	'unsharp3threshold' => { 258 => 0x51 },
	'unsharp4color' => { 258 => 0x64 },
	'unsharp4halowidth' => { 258 => 0x6a },
	'unsharp4intensity' => { 258 => 0x68 },
	'unsharp4threshold' => { 258 => 0x6c },
	'unsharpcount' => { 258 => 0x0 },
	'unsharpmask' => { 103 => 0x90, 253 => 0x76a43200 },
	'unsharpmaskfineness' => { 97 => 0x20309 },
	'unsharpmaskstrength' => { 97 => 0x20308 },
	'unsharpmaskthreshold' => { 97 => 0x2030a },
	'uprightcentermode' => { 445 => 'UprightCenterMode' },
	'uprightcenternormx' => { 445 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 445 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 445 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 445 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 445 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 445 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 445 => 'UprightPreview' },
	'uprighttransform_0' => { 445 => 'UprightTransform_0' },
	'uprighttransform_1' => { 445 => 'UprightTransform_1' },
	'uprighttransform_2' => { 445 => 'UprightTransform_2' },
	'uprighttransform_3' => { 445 => 'UprightTransform_3' },
	'uprighttransform_4' => { 445 => 'UprightTransform_4' },
	'uprighttransform_5' => { 445 => 'UprightTransform_5' },
	'uprighttransformcount' => { 445 => 'UprightTransformCount' },
	'uprightversion' => { 445 => 'UprightVersion' },
	'urgency' => { 125 => 0xa, 457 => 'Urgency' },
	'url' => { 148 => 'URL', 290 => 'URL', 349 => 0x40b, 459 => 'url' },
	'url_list' => { 349 => 0x41e },
	'urla-platform' => { 459 => [\'url','urlA-platform'] },
	'urlurl' => { 459 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 78 => 0x10a },
	'usableshootingmodes' => { 78 => 0x109 },
	'usage' => { 460 => 'usage' },
	'usageterms' => { 473 => 'UsageTerms' },
	'useguidelines' => { 442 => 'useGuidelines' },
	'usepanoramaviewer' => { 432 => 'UsePanoramaViewer' },
	'usercomment' => { 91 => 0x805, 113 => 0x9286, 449 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 66 => 0xd8, 67 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 66 => 0xda, 67 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 66 => 0xdc, 67 => 0xf4 },
	'userfields' => { 437 => 'UserFields' },
	'userlabel' => { 356 => 0x2b, 357 => 0x5a },
	'userprofile' => { 295 => 0x302, 302 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 77 => 0x7, 78 => 0x501 },
	'uspsnumber' => { 459 => 'uspsNumber' },
	'utmeasting' => { 159 => 'Easting' },
	'utmmapdatum' => { 159 => 'Datum' },
	'utmnorthing' => { 159 => 'Northing' },
	'utmzone' => { 159 => 'Zone' },
	'uv-irfiltercorrection' => { 295 => 0x325 },
	'validbits' => { 281 => 0x611, 282 => 0x102c },
	'validpixeldepth' => { 285 => 0x611 },
	'variablelowpassfilter' => { 391 => 0x2028 },
	'variousmodes' => { 133 => 0x26 },
	'variousmodes2' => { 133 => 0x3a },
	'variprogram' => { 214 => 0xab },
	'varraydacnominalvalues' => { 131 => 0x191e },
	'version' => { 121 => 0x0, 351 => 'Version', 445 => 'Version' },
	'versioncreatedate' => { 424 => 0xd100 },
	'versionid' => { 470 => 'VersionID' },
	'versionidentifier' => { 459 => 'versionIdentifier' },
	'versionmodifydate' => { 424 => 0xd101 },
	'versions' => { 470 => 'Versions' },
	'versionscomments' => { 470 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 470 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 470 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 470 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 470 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 470 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 470 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 470 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 470 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 470 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 470 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 260 => '3.2', 261 => '47.2', 263 => '79.1' },
	'verticalclockoverlaps' => { 131 => 0x412 },
	'verticalfuncbutton' => { 261 => '42.2', 263 => '67.1' },
	'verticalfuncbuttonplusdials' => { 261 => '43.1' },
	'verticalfuncplusdials' => { 263 => '68.1' },
	'verticalmultiselector' => { 261 => '42.1', 263 => '66.1', 264 => '66.1', 274 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 78 => [0x510,0x51d] },
	'vibrance' => { 438 => 'Vibrance', 445 => 'Vibrance' },
	'vibrationreduction' => { 222 => [0x75,0x82,0x1ae], 230 => '586.1', 238 => '590.2', 244 => 0x4 },
	'videoalphamode' => { 469 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 469 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 469 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 469 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 455 => 'videoBitRate' },
	'videobitratemode' => { 455 => 'videoBitRateMode' },
	'videoburstmode' => { 300 => 0xbb },
	'videocodec' => { 63 => 0x74 },
	'videocolorspace' => { 469 => 'videoColorSpace' },
	'videocompressor' => { 469 => 'videoCompressor' },
	'videodisplayaspectratio' => { 455 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 455 => 'videoEncodingProfile' },
	'videofieldorder' => { 469 => 'videoFieldOrder' },
	'videoframerate' => { 469 => 'videoFrameRate' },
	'videoframesize' => { 469 => 'videoFrameSize' },
	'videoframesizeh' => { 469 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 469 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 469 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 469 => 'videoModDate' },
	'videopixelaspectratio' => { 469 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 469 => 'videoPixelDepth' },
	'videoquality' => { 107 => 0x4003 },
	'videoshottype' => { 455 => 'VideoShotType' },
	'videoshottypeidentifier' => { 455 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 455 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 455 => 'videoStreamsCount' },
	'viewfinder' => { 344 => 0x455 },
	'viewfinderdisplay' => { 260 => '12.4', 261 => '6.3' },
	'viewfinderwarning' => { 260 => '13.4', 270 => '3.5', 271 => '6.2', 275 => '4.4' },
	'viewfinderwarnings' => { 78 => 0x40a },
	'viewinfoduringexposure' => { 78 => 0x407 },
	'viewingmode' => { 381 => 0x2f, 396 => 0x18 },
	'viewingmode2' => { 381 => [0x85,0x285] },
	'viewpoint' => { 458 => 'viewpoint' },
	'vignetteamount' => { 445 => 'VignetteAmount' },
	'vignettecontrol' => { 214 => 0x2a, 253 => 0x76a43205 },
	'vignettecontrolintensity' => { 253 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 441 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 445 => 'VignetteMidpoint' },
	'vignetting' => { 361 => 0x1011, 368 => 0xa052 },
	'vignettingcorrection' => { 113 => 0x7031, 368 => 0xa053, 391 => 0x2011 },
	'vignettingcorrparams' => { 113 => 0x7032, 419 => 0x64a, 420 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 368 => 0xa054 },
	'visualcolor' => { 455 => 'VisualColour' },
	'visualtechnique' => { 458 => 'visualTechnique' },
	'voicememo' => { 370 => 0x216 },
	'volume' => { 459 => 'volume' },
	'vr_0x66' => { 222 => 0x66 },
	'vrdoffset' => { 60 => 0xd0 },
	'vrmode' => { 244 => 0x6 },
	'waterdepth' => { 113 => 0x9403, 450 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 177 => 0x19a },
	'wb_bluelevel6500k' => { 177 => 0x18a },
	'wb_bluelevelcustom' => { 177 => 0x18e },
	'wb_bluelevelscloudy' => { 177 => 0x106 },
	'wb_bluelevelsdaylight' => { 177 => 0xea },
	'wb_bluelevelsflash' => { 177 => 0x122 },
	'wb_bluelevelsfluorescent' => { 177 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 177 => 0x254 },
	'wb_bluelevelsshade' => { 177 => 0x176 },
	'wb_bluelevelstungsten' => { 177 => 0xce },
	'wb_gbrglevels' => { 177 => 0xae, 180 => 0x4 },
	'wb_glevel' => { 281 => 0x11f },
	'wb_glevel3000k' => { 281 => 0x113 },
	'wb_glevel3300k' => { 281 => 0x114 },
	'wb_glevel3600k' => { 281 => 0x115 },
	'wb_glevel3900k' => { 281 => 0x116 },
	'wb_glevel4000k' => { 281 => 0x117 },
	'wb_glevel4300k' => { 281 => 0x118 },
	'wb_glevel4500k' => { 281 => 0x119 },
	'wb_glevel4800k' => { 281 => 0x11a },
	'wb_glevel5300k' => { 281 => 0x11b },
	'wb_glevel6000k' => { 281 => 0x11c },
	'wb_glevel6600k' => { 281 => 0x11d },
	'wb_glevel7500k' => { 281 => 0x11e },
	'wb_grbglevels' => { 190 => 0x0 },
	'wb_rbgglevels' => { 187 => 0x0 },
	'wb_rblevels' => { 191 => 0x270, 214 => 0xc, 281 => 0x100 },
	'wb_rblevels1' => { 306 => 0x2 },
	'wb_rblevels2' => { 306 => 0x5 },
	'wb_rblevels3' => { 306 => 0x8 },
	'wb_rblevels3000k' => { 281 => 0x102 },
	'wb_rblevels3300k' => { 281 => 0x103 },
	'wb_rblevels3500k' => { 177 => 0x430 },
	'wb_rblevels3600k' => { 281 => 0x104 },
	'wb_rblevels3900k' => { 281 => 0x105 },
	'wb_rblevels4' => { 306 => 0xb },
	'wb_rblevels4000k' => { 281 => 0x106 },
	'wb_rblevels4300k' => { 281 => 0x107 },
	'wb_rblevels4500k' => { 281 => 0x108 },
	'wb_rblevels4800k' => { 281 => 0x109 },
	'wb_rblevels5' => { 306 => 0xe },
	'wb_rblevels5300k' => { 281 => 0x10a },
	'wb_rblevels6' => { 306 => 0x11 },
	'wb_rblevels6000k' => { 281 => 0x10b },
	'wb_rblevels6500k' => { 177 => 0x420 },
	'wb_rblevels6600k' => { 281 => 0x10c },
	'wb_rblevels7' => { 306 => 0x14 },
	'wb_rblevels7500k' => { 281 => 0x10d },
	'wb_rblevelsauto' => { 191 => 0x272, 285 => 0x110 },
	'wb_rblevelscloudy' => { 177 => 0x3f0, 179 => 0x10, 191 => 0x296, 285 => 0x121 },
	'wb_rblevelscoolwhitef' => { 177 => 0x308, 179 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 285 => 0x132 },
	'wb_rblevelscustom' => { 177 => 0x424 },
	'wb_rblevelscwb1' => { 281 => 0x10e },
	'wb_rblevelscwb2' => { 281 => 0x10f },
	'wb_rblevelscwb3' => { 281 => 0x110 },
	'wb_rblevelscwb4' => { 281 => 0x111 },
	'wb_rblevelsdaylight' => { 177 => [0x3ec,0x528], 179 => 0xc, 191 => 0x274 },
	'wb_rblevelsdaylightf' => { 179 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 285 => 0x130 },
	'wb_rblevelsdaywhitef' => { 179 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 285 => 0x131 },
	'wb_rblevelseveningsunlight' => { 285 => 0x124 },
	'wb_rblevelsfineweather' => { 285 => 0x122 },
	'wb_rblevelsflash' => { 177 => [0x3f4,0x304], 179 => 0x18, 191 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 191 => 0x290 },
	'wb_rblevelsincandescent' => { 191 => 0x282 },
	'wb_rblevelsshade' => { 177 => 0x418, 179 => 0x20, 191 => 0x2b2, 285 => 0x120 },
	'wb_rblevelstungsten' => { 177 => 0x3e8, 179 => 0x8, 285 => 0x123 },
	'wb_rblevelsunknown' => { 179 => 0x1c },
	'wb_rblevelsused' => { 285 => 0x100 },
	'wb_rblevelswhitef' => { 179 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 285 => 0x133 },
	'wb_redlevel3500k' => { 177 => 0x198 },
	'wb_redlevel6500k' => { 177 => 0x188 },
	'wb_redlevelcustom' => { 177 => 0x18c },
	'wb_redlevelscloudy' => { 177 => 0xf8 },
	'wb_redlevelsdaylight' => { 177 => 0xdc },
	'wb_redlevelsflash' => { 177 => 0x114 },
	'wb_redlevelsfluorescent' => { 177 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 177 => 0x1be },
	'wb_redlevelsshade' => { 177 => 0x168 },
	'wb_redlevelstungsten' => { 177 => 0xc0 },
	'wb_rgbglevels' => { 189 => 0x0 },
	'wb_rgblevels' => { 177 => [0x546,0x96], 296 => 0xd, 297 => 0x413, 302 => 0x3036, 344 => 0x107, 399 => 0x117c, 400 => 0x1180, 401 => 0x115c, 402 => 0x11d8, 403 => 0x11b4, 404 => 0x106c, 405 => 0x264, 406 => 0x264, 407 => 0x252 },
	'wb_rgblevels1' => { 307 => 0x2 },
	'wb_rgblevels2' => { 307 => 0x6 },
	'wb_rgblevels3' => { 307 => 0xa },
	'wb_rgblevels4' => { 307 => 0xe },
	'wb_rgblevels5' => { 307 => 0x12 },
	'wb_rgblevels6' => { 307 => 0x16 },
	'wb_rgblevels7' => { 307 => 0x1a },
	'wb_rgbmuldaylight' => { 131 => 0x852 },
	'wb_rgbmulflash' => { 131 => 0x855 },
	'wb_rgbmulfluorescent' => { 131 => 0x854 },
	'wb_rgbmultungsten' => { 131 => 0x853 },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 180 => 0x4, 188 => 0x0, 192 => 0x13e8, 193 => 0x38 },
	'wb_rggblevelsasshot' => { 37 => 0x0, 38 => 0x0, 39 => 0x19, 40 => 0x22, 41 => 0x3f, 44 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 37 => 0x5, 38 => 0x8, 39 => 0x1e, 40 => 0x18, 41 => 0x44, 44 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x4c, 192 => 0x1478, 193 => 0x114, 368 => 0xa022 },
	'wb_rggblevelsblack' => { 368 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 37 => 0x1e, 38 => 0x30, 39 => 0x2d, 40 => 0x31, 41 => 0x58, 44 => 0x71, 45 => 0x8a, 46 => 0x8f, 47 => 0x92, 192 => 0x1408, 193 => 0x60, 335 => 0x20f, 343 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 41 => 0x80, 192 => 0x1468, 193 => 0x100 },
	'wb_rggblevelscustom1' => { 39 => 0x41 },
	'wb_rggblevelscustom2' => { 39 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 37 => 0x14, 38 => 0x20, 39 => 0x23, 40 => 0x27, 41 => 0x4e, 44 => 0x67, 45 => 0x80, 46 => 0x85, 47 => 0x88, 192 => 0x13f8, 193 => 0x4c, 335 => 0x20d, 343 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 37 => 0x32, 38 => 0x50, 39 => 0x3c, 40 => 0x45, 41 => 0x6c, 44 => 0x85, 45 => 0x9e, 46 => 0xa3, 47 => 0xa6, 192 => 0x1448, 335 => 0x214, 343 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 37 => 0x28, 38 => 0x40, 39 => 0x37, 40 => 0x3b, 41 => 0x62, 44 => 0x7b, 45 => 0x94, 46 => 0x99, 47 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 193 => 0xc4, 335 => 0x211, 343 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 343 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 193 => 0xb0, 335 => 0x212, 343 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 192 => 0x1438, 193 => 0x9c, 335 => 0x213, 343 => 0x38 },
	'wb_rggblevelshtmercury' => { 193 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 368 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 368 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 37 => 0x2d, 38 => 0x48, 40 => 0x40, 41 => 0x67, 44 => 0x80, 45 => 0x99, 46 => 0x9e, 47 => 0xa1 },
	'wb_rggblevelsmeasured' => { 37 => 0xa, 38 => 0x10, 41 => 0x49, 44 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x51 },
	'wb_rggblevelspc1' => { 40 => 0x90, 41 => 0x71 },
	'wb_rggblevelspc2' => { 40 => 0x95, 41 => 0x76 },
	'wb_rggblevelspc3' => { 40 => 0x9a, 41 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 37 => 0x19, 38 => 0x28, 39 => 0x28, 40 => 0x2c, 41 => 0x53, 44 => 0x6c, 45 => 0x85, 46 => 0x8a, 47 => 0x8d, 193 => 0x74, 335 => 0x20e, 343 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 37 => 0x23, 38 => 0x38, 39 => 0x32, 40 => 0x36, 41 => 0x5d, 44 => 0x76, 45 => 0x8f, 46 => 0x94, 47 => 0x97, 192 => 0x1428, 193 => 0x88, 335 => 0x210, 343 => 0x1d },
	'wb_rggblevelsuncorrected' => { 368 => 0xa021 },
	'wb_rggblevelsunknown' => { 37 => 0xf, 38 => 0x18, 40 => 0x1d, 44 => 0x4e, 45 => 0x4e, 46 => 0x4e, 47 => 0x56, 343 => 0x53 },
	'wb_rggblevelsunknown10' => { 37 => 0x5f, 38 => 0x98, 40 => 0x72, 44 => 0x9e, 45 => 0x7b, 46 => 0x7b, 47 => 0x83 },
	'wb_rggblevelsunknown11' => { 37 => 0x64, 38 => 0xa0, 40 => 0x77, 44 => 0xa3, 45 => 0xa3, 46 => 0x80, 47 => 0xab },
	'wb_rggblevelsunknown12' => { 37 => 0x69, 38 => 0xa8, 40 => 0x7c, 44 => 0xa8, 45 => 0xa8, 46 => 0xa8, 47 => 0xb0 },
	'wb_rggblevelsunknown13' => { 37 => 0x6e, 38 => 0xb0, 40 => 0x81, 44 => 0xad, 45 => 0xad, 46 => 0xad, 47 => 0xb5 },
	'wb_rggblevelsunknown14' => { 40 => 0x86, 44 => 0xb2, 45 => 0xb2, 46 => 0xb2, 47 => 0xba },
	'wb_rggblevelsunknown15' => { 40 => 0x8b, 44 => 0xb7, 45 => 0xb7, 46 => 0xb7, 47 => 0xbf },
	'wb_rggblevelsunknown16' => { 40 => 0x9f, 45 => 0xbc, 46 => 0xbc, 47 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xc1, 46 => 0xc1, 47 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xc6, 46 => 0xc6, 47 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xcb, 46 => 0xcb, 47 => 0xd3 },
	'wb_rggblevelsunknown2' => { 37 => 0x37, 38 => 0x58, 40 => 0x4a, 44 => 0x53, 45 => 0x53, 46 => 0x53, 47 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xd0, 46 => 0xd0, 47 => 0xd8 },
	'wb_rggblevelsunknown21' => { 46 => 0xd5, 47 => 0xdd },
	'wb_rggblevelsunknown22' => { 46 => 0xda, 47 => 0xe2 },
	'wb_rggblevelsunknown23' => { 46 => 0xdf, 47 => 0xe7 },
	'wb_rggblevelsunknown24' => { 46 => 0xe4, 47 => 0xec },
	'wb_rggblevelsunknown25' => { 46 => 0xe9, 47 => 0xf1 },
	'wb_rggblevelsunknown26' => { 46 => 0xee, 47 => 0xf6 },
	'wb_rggblevelsunknown27' => { 46 => 0xf3, 47 => 0xfb },
	'wb_rggblevelsunknown28' => { 46 => 0xf8, 47 => 0x100 },
	'wb_rggblevelsunknown29' => { 46 => 0xfd, 47 => 0x105 },
	'wb_rggblevelsunknown3' => { 37 => 0x3c, 38 => 0x60, 40 => 0x4f, 44 => 0x58, 45 => 0x58, 46 => 0x58, 47 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x102 },
	'wb_rggblevelsunknown4' => { 37 => 0x41, 38 => 0x68, 40 => 0x54, 44 => 0x5d, 45 => 0x5d, 46 => 0x5d, 47 => 0x65 },
	'wb_rggblevelsunknown5' => { 37 => 0x46, 38 => 0x70, 40 => 0x59, 44 => 0x62, 45 => 0x62, 46 => 0x62, 47 => 0x6a },
	'wb_rggblevelsunknown6' => { 37 => 0x4b, 38 => 0x78, 40 => 0x5e, 44 => 0x8a, 45 => 0x67, 46 => 0x67, 47 => 0x6f },
	'wb_rggblevelsunknown7' => { 37 => 0x50, 38 => 0x80, 40 => 0x63, 44 => 0x8f, 45 => 0x6c, 46 => 0x6c, 47 => 0x74 },
	'wb_rggblevelsunknown8' => { 37 => 0x55, 38 => 0x88, 40 => 0x68, 44 => 0x94, 45 => 0x71, 46 => 0x71, 47 => 0x79 },
	'wb_rggblevelsunknown9' => { 37 => 0x5a, 38 => 0x90, 40 => 0x6d, 44 => 0x99, 45 => 0x76, 46 => 0x76, 47 => 0x7e },
	'wb_rggblevelsuserselected' => { 343 => 0x5c },
	'wbadjblueamber' => { 97 => 0x20106 },
	'wbadjbluebalance' => { 259 => 0x8 },
	'wbadjcolortemp' => { 97 => 0x20102, 102 => 0x1a },
	'wbadjlighting' => { 259 => 0x14 },
	'wbadjmagentagreen' => { 97 => 0x20105 },
	'wbadjmode' => { 259 => 0x10 },
	'wbadjredbalance' => { 259 => 0x0 },
	'wbadjrggblevels' => { 97 => 0x20125, 102 => 0x6 },
	'wbadjtemperature' => { 259 => 0x18 },
	'wbadjtint' => { 259 => 0x25 },
	'wbbluelevel' => { 295 => 0x324, 300 => 0x8006, 305 => 0x26 },
	'wbbracketingsteps' => { 231 => 0x174d, 232 => 0x87c, 240 => 0x1757 },
	'wbbracketmode' => { 54 => 0x9 },
	'wbbracketshotnumber' => { 177 => 0x2b, 361 => 0x101a },
	'wbbracketvalueab' => { 54 => 0xc },
	'wbbracketvaluegm' => { 54 => 0xd },
	'wbfinetuneactive' => { 102 => 0x24 },
	'wbfinetunesaturation' => { 102 => 0x28 },
	'wbfinetunetone' => { 102 => 0x2c },
	'wbgreenlevel' => { 295 => 0x323, 300 => 0x8005, 305 => 0x25 },
	'wbmediaimagesizesetting' => { 78 => 0x708 },
	'wbmode' => { 179 => 0x4, 282 => 0x1015 },
	'wbredlevel' => { 295 => 0x322, 300 => 0x8004, 305 => 0x24 },
	'wbscale' => { 180 => 0x0 },
	'wbshiftab' => { 70 => 0xc, 300 => 0x46, 317 => 0x10 },
	'wbshiftab_gm' => { 391 => 0x2014 },
	'wbshiftab_gm_precise' => { 391 => 0x2026 },
	'wbshiftcreativecontrol' => { 300 => 0x92 },
	'wbshiftgm' => { 70 => 0xd, 300 => 0x47, 317 => 0x11 },
	'wbshiftintelligentauto' => { 300 => 0x8b },
	'wbtype1' => { 306 => 0x1, 307 => 0x1 },
	'wbtype2' => { 306 => 0x4, 307 => 0x5 },
	'wbtype3' => { 306 => 0x7, 307 => 0x9 },
	'wbtype4' => { 306 => 0xa, 307 => 0xd },
	'wbtype5' => { 306 => 0xd, 307 => 0x11 },
	'wbtype6' => { 306 => 0x10, 307 => 0x15 },
	'wbtype7' => { 306 => 0x13, 307 => 0x19 },
	'webstatement' => { 473 => 'WebStatement' },
	'what' => { 445 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 70 => 0x8, 72 => 0x7, 106 => 0x7, 107 => [0x19,0x2012], 113 => [0xa403,0xfe4e], 121 => 0x1002, 131 => 0x3fc, 132 => 0xfa0d, 133 => 0x40, 171 => 0x3, 172 => 0xe, 173 => 0x4, 174 => 0xb, 176 => 0x115, 214 => 0x5, 243 => 0x7, 295 => 0x304, 300 => 0x3, 302 => 0x3033, 335 => 0x19, 342 => 0x7, 360 => 0x26, 361 => 0x1003, 371 => [0x3c,0x7,0x58], 379 => 0xf, 380 => 0xe, 391 => [0x115,0xb054], 445 => 'WhiteBalance', 449 => 'WhiteBalance' },
	'whitebalance0' => { 167 => 'WhiteBalance0' },
	'whitebalance1' => { 167 => 'WhiteBalance1' },
	'whitebalance2' => { 167 => 'WhiteBalance2', 277 => 0x500 },
	'whitebalanceadj' => { 97 => 0x20101, 102 => 0x18, 253 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 313 => 0x0 },
	'whitebalancebias' => { 107 => 0x2011, 282 => 0x304, 300 => 0x23 },
	'whitebalanceblue' => { 70 => 0x7 },
	'whitebalancebracket' => { 277 => 0x502, 282 => 0x303 },
	'whitebalancebracketing' => { 174 => 0x22, 177 => 0x2c, 390 => 0x2c },
	'whitebalancecomp' => { 285 => 0x1001 },
	'whitebalancedetected' => { 131 => 0x3fb },
	'whitebalancefinetune' => { 121 => 0x100a, 174 => 0x38, 176 => 0x112, 214 => 0xb, 361 => 0x1004, 379 => 0x6, 380 => 0x5, 391 => 0x112 },
	'whitebalancemode' => { 131 => 0x3fa, 335 => 0x1a },
	'whitebalancered' => { 70 => 0x6 },
	'whitebalanceset' => { 316 => 0xa },
	'whitebalancesetting' => { 174 => 0x23, 379 => 0x5, 380 => 0x4, 381 => 0x16, 396 => 0xd },
	'whitebalancesetup' => { 368 => 0x41 },
	'whitebalancetemperature' => { 277 => 0x501 },
	'whiteboard' => { 282 => 0x301 },
	'whitelevel' => { 113 => 0xc61d, 335 => 0x7e },
	'whitepoint' => { 113 => 0x13e, 335 => 0x201, 465 => 'WhitePoint' },
	'whites2012' => { 445 => 'Whites2012' },
	'whitesadj' => { 424 => 0x9017 },
	'wideadapter' => { 361 => 0x1017 },
	'widefocuszone' => { 171 => 0x2f },
	'widerange' => { 370 => 0x20f },
	'windmode' => { 131 => 0x3f4 },
	'windowsatom' => { 444 => 'windowsAtom' },
	'windowsatomextension' => { 444 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 444 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 444 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 459 => 'wordCount' },
	'workcolorspace' => { 97 => 0x10200, 102 => 0x270 },
	'workflowtag' => { 455 => 'WorkflowTag' },
	'workflowtagcvid' => { 455 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 455 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 455 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 455 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 451 => 'WorkToDo' },
	'worldtimelocation' => { 300 => 0x3a, 335 => 0x22, 341 => '0.1' },
	'writer-editor' => { 125 => 0x7a },
	'x3filllight' => { 371 => 0x12 },
	'xattrquarantine' => { 165 => 'com.apple.quarantine' },
	'xilinxversion' => { 131 => 0x414 },
	'xml' => { 129 => 'xml ' },
	'xmp' => { 100 => 0xffff00f6, 114 => 'XMP' },
	'xmptoolkit' => { 466 => 'xmptk' },
	'xpauthor' => { 113 => 0x9c9d },
	'xpcomment' => { 113 => 0x9c9c },
	'xpkeywords' => { 113 => 0x9c9e },
	'xposition' => { 113 => 0x11e },
	'xpsubject' => { 113 => 0x9c9f },
	'xptitle' => { 113 => 0x9c9b },
	'xresolution' => { 113 => 0x11a, 128 => 0x3, 350 => 0x0, 465 => 'XResolution' },
	'xyresolution' => { 117 => 0x3 },
	'yaw' => { 109 => 0x7 },
	'yawangle' => { 231 => 0x3513, 232 => 0x2c2c, 240 => 0x36fc, 366 => 0x0 },
	'ycbcrcoefficients' => { 113 => 0x211, 465 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 113 => 0x213, 465 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 113 => 0x212, 465 => 'YCbCrSubSampling' },
	'yearcreated' => { 133 => 0x10, 142 => 0xc },
	'yellowhsl' => { 97 => 0x20912 },
	'yield' => { 461 => 'yield' },
	'yposition' => { 113 => 0x11f },
	'yresolution' => { 113 => 0x11b, 128 => 0x5, 350 => 0x4, 465 => 'YResolution' },
	'zonematching' => { 176 => 0x10a, 179 => [0x3a,0x4a], 391 => 0xb024 },
	'zonematchingmode' => { 174 => 0x14 },
	'zonematchingon' => { 173 => 0x75 },
	'zonematchingvalue' => { 379 => 0x1f },
	'zoomedpreviewlength' => { 282 => 0xf05 },
	'zoomedpreviewsize' => { 282 => 0xf06 },
	'zoomedpreviewstart' => { 282 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 280 => 0x300, 282 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketinginfooffset' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderid' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailpng' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2018, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
