#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFInfo2',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 91 => 0x69 },
	'about' => { 407 => 'about' },
	'aboutcvterm' => { 398 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 398 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 398 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 398 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 398 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 413 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 72 => 0x518 },
	'accelerometer' => { 320 => 0x3 },
	'accelerometerx' => { 262 => 0x8d },
	'accelerometery' => { 262 => 0x8e },
	'accelerometerz' => { 262 => 0x8c },
	'accessoryserialnumber' => { 262 => 0x54 },
	'accessorytype' => { 262 => 0x53 },
	'acedemicfield' => { 403 => 'acedemicField' },
	'actionadvised' => { 107 => 0x2a },
	'activearea' => { 99 => 0xc68d },
	'actived-lighting' => { 186 => 0x22, 220 => 0x24 },
	'actived-lightingmode' => { 220 => 0x25 },
	'adaptervoltage' => { 113 => 0x407 },
	'addaspectratioinfo' => { 72 => 0x80e },
	'additionalmodelinformation' => { 398 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 72 => 0x80f, 73 => 0x11, 74 => 0x13, 77 => 0x14 },
	'address' => { 134 => 'Address' },
	'adjustmentmode' => { 326 => 0x15 },
	'adobe' => { 100 => 'Adobe' },
	'adultcontentwarning' => { 401 => 'AdultContentWarning', 406 => 'adultContentWarning' },
	'advancedfilter' => { 104 => 0x1201 },
	'advancedraw' => { 222 => 0x76a43203 },
	'advancedscenetype' => { 262 => 0x3d },
	'advisory' => { 411 => 'Advisory' },
	'ae_iso' => { 269 => 0x2, 270 => 0x4, 271 => 0x12 },
	'aeaperture' => { 269 => 0x1, 270 => 0x3, 271 => 0x11 },
	'aeaperturesteps' => { 269 => 0x8, 270 => 0xb },
	'aebautocancel' => { 72 => 0x104 },
	'aebbracketvalue' => { 66 => 0x11 },
	'aebsequence' => { 72 => 0x105 },
	'aebsequenceautocancel' => { 70 => 0x9, 71 => 0x9, 73 => 0x8, 74 => 0x9, 77 => 0x9, 78 => 0x7 },
	'aebshotcount' => { 72 => 0x106 },
	'aebxv' => { 269 => 0x4, 270 => 0x6 },
	'aeerror' => { 270 => 0x8 },
	'aeexposuretime' => { 269 => 0x0, 270 => 0x2, 271 => 0x10 },
	'aelbutton' => { 154 => 0x45 },
	'aelexposureindicator' => { 154 => 0x51 },
	'aelock' => { 154 => 0x5b, 231 => '4.2', 237 => '4.2', 242 => 0x201, 295 => 0x48, 334 => 0x40, 335 => 0x40, 336 => [0x86,0x286] },
	'aelockbutton' => { 229 => '16.1', 231 => '4.1', 232 => '15.1', 233 => '16.1', 234 => '16.1', 235 => '30.1', 236 => '16.1', 237 => '4.1', 239 => '17.1', 240 => '17.1' },
	'aelockbuttonplusdials' => { 229 => '16.2', 235 => '32.1', 239 => '44.1' },
	'aelockformb-d80' => { 240 => '3.1' },
	'aemaxaperture' => { 269 => 0x9, 270 => 0x10, 271 => 0x1c },
	'aemaxaperture2' => { 269 => 0xa, 270 => 0x11, 271 => 0x1d },
	'aemeteringmode' => { 269 => 0xc },
	'aemeteringmode2' => { 269 => '13.1' },
	'aemeteringsegments' => { 157 => 0x628, 295 => 0x209 },
	'aemicroadjustment' => { 72 => 0x110 },
	'aeminaperture' => { 269 => 0xb, 270 => 0x12, 271 => 0x1e },
	'aeminexposuretime' => { 269 => 0x5, 270 => 0x13, 271 => 0x1f },
	'aeprogrammode' => { 269 => 0x6 },
	'aeprojectlink' => { 387 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 387 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 387 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 387 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 387 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 387 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 30 => 0x21 },
	'aewhitebalance' => { 269 => 0xd },
	'aexv' => { 269 => 0x3, 270 => 0x5 },
	'af-cpriorityselection' => { 229 => '1.1', 230 => '1.1', 233 => '0.1', 234 => '0.1', 235 => '1.1', 236 => '0.1', 239 => '1.1' },
	'af-onformb-d10' => { 229 => '3.3', 235 => '3.2' },
	'af-onformb-d11' => { 236 => '2.2' },
	'af-onformb-d12' => { 239 => '50.1' },
	'af-spriorityselection' => { 229 => '1.2', 230 => '1.2', 235 => '1.2', 236 => '0.2', 239 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 229 => '2.1', 230 => '2.1', 235 => '2.1', 239 => '2.1' },
	'afadjustment' => { 295 => 0x72 },
	'afandmeteringbuttons' => { 72 => 0x701 },
	'afaperture' => { 182 => 0x5, 183 => 0x5 },
	'afareaheight' => { 162 => 0x1a },
	'afareaillumination' => { 154 => 0x4b, 237 => '15.3' },
	'afareamode' => { 150 => 0x33, 154 => 0xe, 161 => 0x0, 162 => 0x5, 262 => 0xf, 317 => 0x1205, 327 => [0xa,0x3a], 334 => 0x11, 335 => 0x10, 336 => 0x24, 346 => 0xb043, 364 => 0x17 },
	'afareamodesetting' => { 231 => '11.1', 232 => '0.1', 237 => '16.1', 240 => '2.1', 346 => 0x201c },
	'afareas' => { 242 => 0x304 },
	'afareaselectmethod' => { 72 => 0x51b },
	'afareawidth' => { 162 => 0x18 },
	'afareaxposition' => { 162 => 0x14, 317 => 0x1203 },
	'afareaxposition1' => { 317 => 0x1201 },
	'afareayposition' => { 162 => 0x16, 317 => 0x1204 },
	'afareayposition1' => { 317 => 0x1202 },
	'afassist' => { 70 => 0x5, 78 => 0x5, 154 => 0x48, 229 => '2.5', 231 => '0.2', 232 => '0.2', 233 => '1.1', 234 => '1.1', 235 => '2.4', 236 => '1.4', 237 => '0.2', 239 => '2.4', 240 => '2.3' },
	'afassistbeam' => { 72 => 0x50e, 73 => 0x4, 74 => 0x5, 75 => 0x4, 76 => 0x4, 77 => 0x5 },
	'afassistlamp' => { 262 => 0x31 },
	'afbuttonpressed' => { 336 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 272 => 0x6 },
	'afduringliveview' => { 72 => 0x511 },
	'affinea' => { 381 => 'AffineA' },
	'affineb' => { 381 => 'AffineB' },
	'affinec' => { 381 => 'AffineC' },
	'affined' => { 381 => 'AffineD' },
	'affinetune' => { 163 => 0x0, 242 => 0x306 },
	'affinetuneadj' => { 163 => 0x2, 195 => 0x2d1, 196 => 0x2dc, 242 => 0x307 },
	'affinetuneindex' => { 163 => 0x1 },
	'affinex' => { 381 => 'AffineX' },
	'affiney' => { 381 => 'AffineY' },
	'afilluminator' => { 334 => 0x29, 346 => 0xb044 },
	'afimageheight' => { 162 => 0x12 },
	'afimagewidth' => { 162 => 0x10 },
	'afintegrationtime' => { 272 => 0x7 },
	'afmicroadj' => { 327 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 331 => 0x131 },
	'afmicroadjregisteredlenses' => { 331 => '305.1' },
	'afmicroadjustment' => { 72 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 331 => 0x130 },
	'afmode' => { 95 => 0x3009, 150 => 0x16, 326 => 0x5 },
	'afmoderestrictions' => { 230 => '50.3', 239 => '48.3' },
	'afonaelockbuttonswitch' => { 72 => 0x702 },
	'afonbutton' => { 229 => '3.1', 230 => '47.1' },
	'afpoint' => { 30 => 0x13, 94 => 0x18, 150 => 0x15, 161 => 0x1, 245 => 0x308, 326 => 0x1f, 327 => 0x7, 331 => 0x19, 332 => 0x18, 333 => [0x18,0x20] },
	'afpointactivationarea' => { 71 => 0x11, 77 => 0x11 },
	'afpointareaexpansion' => { 72 => 0x508 },
	'afpointatshutterrelease' => { 327 => 0x9 },
	'afpointautoselection' => { 72 => 0x50b },
	'afpointbrightness' => { 72 => 0x50d, 229 => '2.4', 230 => '46.5', 239 => '2.3' },
	'afpointdisplayduringfocus' => { 72 => 0x50c },
	'afpointillumination' => { 71 => 0xa, 229 => '2.3', 230 => '46.2', 235 => '2.3', 236 => '1.3', 239 => '47.2', 240 => '2.4' },
	'afpointinfocus' => { 327 => 0x8 },
	'afpointmode' => { 276 => 0x3 },
	'afpointposition' => { 95 => 0x2021, 262 => 0x4d },
	'afpointregistration' => { 70 => 0x7 },
	'afpoints' => { 153 => 0x10 },
	'afpointselected' => { 154 => 0xd, 242 => 0x305, 295 => 0xe, 331 => 0x15, 332 => 0x14, 333 => [0x14,0x1c], 346 => 0x201e },
	'afpointselected2' => { 276 => 0x4 },
	'afpointselection' => { 71 => 0xb, 229 => '1.3', 230 => '1.3', 235 => '1.3', 239 => '1.3' },
	'afpointselectionmethod' => { 72 => 0x50f, 73 => 0xc, 74 => 0xd, 77 => 0xd },
	'afpointset' => { 104 => 0x1022 },
	'afpointsetting' => { 334 => 0x12, 335 => 0x11 },
	'afpointsinfocus' => { 66 => 0xe, 161 => 0x2, 272 => 0xb, 295 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 71 => 0xd },
	'afpointsselected' => { 371 => 0x4 },
	'afpointsunknown1' => { 272 => 0x0 },
	'afpointsunknown2' => { 272 => 0x2 },
	'afpointsused' => { 162 => 0x8, 328 => 0x0 },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 272 => 0x4 },
	'afresponse' => { 186 => 0xad },
	'afresult' => { 247 => 0x1038 },
	'afsearch' => { 242 => 0x303 },
	'afsensoractive' => { 150 => 0x1 },
	'afstatus' => { 317 => 0x1200 },
	'afstatusactivesensor' => { 150 => 0x2, 327 => 0x4, 331 => 0x1e, 332 => 0x1b, 333 => [0x1b,0x21] },
	'afstatusbottom' => { 150 => 0x8, 331 => 0x2a, 332 => 0x21, 333 => 0x21 },
	'afstatusbottom-left' => { 150 => 0x12, 332 => 0x2b, 333 => 0x2b },
	'afstatusbottom-right' => { 150 => 0x6, 332 => 0x1f, 333 => 0x1f },
	'afstatusbottomassist-left' => { 331 => 0x28 },
	'afstatusbottomassist-right' => { 331 => 0x2c },
	'afstatusbottomhorizontal' => { 329 => 0x10, 330 => 0x1c },
	'afstatusbottomvertical' => { 329 => 0x16, 330 => 0x26 },
	'afstatuscenter-10' => { 331 => 0x34 },
	'afstatuscenter-11' => { 331 => 0x36 },
	'afstatuscenter-12' => { 331 => 0x38 },
	'afstatuscenter-14' => { 331 => 0x3c },
	'afstatuscenter-7' => { 331 => 0x2e },
	'afstatuscenter-9' => { 331 => 0x32 },
	'afstatuscenter-horizontal' => { 331 => 0x30 },
	'afstatuscenter-vertical' => { 331 => 0x3a },
	'afstatuscenterf2-8' => { 331 => 0x4c },
	'afstatuscenterhorizontal' => { 150 => 0x2f, 329 => 0xc, 330 => 0x18, 332 => 0x2f, 333 => 0x2f },
	'afstatuscentervertical' => { 150 => 0xc, 329 => 0x14, 330 => 0x22, 332 => 0x25, 333 => 0x25 },
	'afstatusfarleft' => { 329 => 0x6, 331 => 0x26 },
	'afstatusfarlefthorizontal' => { 330 => 0x4 },
	'afstatusfarleftvertical' => { 330 => 0x12 },
	'afstatusfarright' => { 329 => 0x18, 331 => 0x44 },
	'afstatusfarrighthorizontal' => { 330 => 0x2c },
	'afstatusfarrightvertical' => { 330 => 0x34 },
	'afstatusleft' => { 150 => 0x2d, 329 => 0x2, 331 => 0x22, 332 => 0x2d, 333 => 0x2d },
	'afstatuslefthorizontal' => { 330 => 0x6 },
	'afstatusleftvertical' => { 330 => 0xe },
	'afstatuslower-left' => { 329 => 0x4, 331 => 0x24 },
	'afstatuslower-lefthorizontal' => { 330 => 0xa },
	'afstatuslower-leftvertical' => { 330 => 0x10 },
	'afstatuslower-middle' => { 329 => 0x22, 330 => 0x24 },
	'afstatuslower-right' => { 329 => 0x1e, 331 => 0x4a },
	'afstatuslower-righthorizontal' => { 330 => 0x32 },
	'afstatuslower-rightvertical' => { 330 => 0x3a },
	'afstatuslowerfarleft' => { 330 => 0x8 },
	'afstatuslowerfarright' => { 330 => 0x30 },
	'afstatusmiddlehorizontal' => { 150 => 0xa, 332 => 0x23, 333 => 0x23 },
	'afstatusnearleft' => { 329 => 0xe, 330 => 0x1a },
	'afstatusnearright' => { 329 => 0xa, 330 => 0x16 },
	'afstatusright' => { 150 => 0x31, 329 => 0x1c, 331 => 0x48, 332 => 0x31, 333 => 0x31 },
	'afstatusrighthorizontal' => { 330 => 0x2e },
	'afstatusrightvertical' => { 330 => 0x38 },
	'afstatustop' => { 150 => 0xe, 331 => 0x40, 332 => 0x27, 333 => 0x27 },
	'afstatustop-left' => { 150 => 0x10, 332 => 0x29, 333 => 0x29 },
	'afstatustop-right' => { 150 => 0x4, 332 => 0x1d, 333 => 0x1d },
	'afstatustopassist-left' => { 331 => 0x3e },
	'afstatustopassist-right' => { 331 => 0x42 },
	'afstatustophorizontal' => { 329 => 0x8, 330 => 0x14 },
	'afstatustopvertical' => { 329 => 0x12, 330 => 0x1e },
	'afstatusupper-left' => { 329 => 0x0, 331 => 0x20 },
	'afstatusupper-lefthorizontal' => { 330 => 0x2 },
	'afstatusupper-leftvertical' => { 330 => 0xc },
	'afstatusupper-middle' => { 329 => 0x20, 330 => 0x20 },
	'afstatusupper-right' => { 329 => 0x1a, 331 => 0x46 },
	'afstatusupper-righthorizontal' => { 330 => 0x2a },
	'afstatusupper-rightvertical' => { 330 => 0x36 },
	'afstatusupperfarleft' => { 330 => 0x0 },
	'afstatusupperfarright' => { 330 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 327 => 0x2 },
	'afwithshutter' => { 334 => 0x2a },
	'aggregateissuenumber' => { 403 => 'aggregateIssueNumber' },
	'aggregationtype' => { 403 => 'aggregationType' },
	'agreement' => { 406 => 'agreement' },
	'aiservocontinuousshooting' => { 71 => 0x15 },
	'aiservofirstimagepriority' => { 72 => 0x519 },
	'aiservoimagepriority' => { 72 => 0x503 },
	'aiservosecondimagepriority' => { 72 => 0x51a },
	'aiservotrackingmethod' => { 72 => 0x504 },
	'aiservotrackingsensitivity' => { 71 => 0x14, 72 => 0x502 },
	'album' => { 413 => 'album' },
	'alreadyapplied' => { 388 => 'AlreadyApplied' },
	'alternatetitle' => { 403 => 'alternateTitle' },
	'alternatetitlea-lang' => { 403 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 403 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 403 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 164 => 0x6 },
	'alttapename' => { 413 => 'altTapeName' },
	'alttimecode' => { 413 => 'altTimecode' },
	'alttimecodetimeformat' => { 413 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 413 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 413 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 313 => 0x14, 364 => 0x4 },
	'ambienttemperaturefahrenheit' => { 313 => 0x13 },
	'analogbalance' => { 99 => 0xc627 },
	'angleadj' => { 91 => 0x8b },
	'angleinforoll' => { 383 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 383 => 'AngleInfoYaw' },
	'anti-blur' => { 346 => 0xb04b },
	'antialiasstrength' => { 99 => 0xc632 },
	'aperturelock' => { 230 => '38.2', 239 => '38.2' },
	'aperturerange' => { 72 => 0x10d },
	'apertureringuse' => { 276 => '1.4' },
	'aperturesetting' => { 154 => 0x7, 334 => 0x30, 335 => 0x29, 336 => 0x1 },
	'aperturevalue' => { 81 => 0x2, 99 => 0x9202, 247 => 0x1002, 392 => 'ApertureValue' },
	'applekeywords' => { 251 => 'AAPL:Keywords' },
	'applicationnotes' => { 99 => 0x2bc, 266 => 0x2bc },
	'applicationrecordversion' => { 107 => 0x0 },
	'applyshootingmeteringmode' => { 72 => 0x10e },
	'approved' => { 394 => 'Approved' },
	'approvedby' => { 394 => 'ApprovedBy' },
	'approximatefnumber' => { 258 => 0x313, 264 => 0x3406 },
	'approximatefocusdistance' => { 384 => 'ApproximateFocusDistance' },
	'armidentifier' => { 108 => 0x78 },
	'armversion' => { 108 => 0x7a },
	'artfilter' => { 242 => 0x529 },
	'artfiltereffect' => { 242 => 0x52f },
	'artist' => { 99 => 0x13b, 254 => 'Artist', 295 => 0x22e, 409 => 'Artist', 413 => 'artist' },
	'artmode' => { 95 => 0x301b },
	'artmodeparameters' => { 95 => 0x310b },
	'artworkcircadatecreated' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 398 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 398 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 246 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 246 => 0x1112, 295 => 0x80, 334 => 0x55, 335 => 0x55, 336 => 0xa },
	'asshoticcprofile' => { 99 => 0xc68f },
	'asshotneutral' => { 99 => 0xc628 },
	'asshotpreprofilematrix' => { 99 => 0xc690 },
	'asshotprofilename' => { 99 => 0xc6f6 },
	'asshotwhitexy' => { 99 => 0xc629 },
	'assignbktbutton' => { 229 => '4.2', 230 => '16.1', 239 => '16.1' },
	'assignfuncbutton' => { 72 => 0x70b },
	'assignmovierecordbutton' => { 230 => '43.2', 239 => '45.1' },
	'assignremotefnbutton' => { 230 => '54.1', 239 => '51.1' },
	'assistbuttonfunction' => { 70 => 0xd },
	'attributionname' => { 385 => 'attributionName' },
	'attributionurl' => { 385 => 'attributionURL' },
	'audio' => { 262 => 0x20 },
	'audiobitrate' => { 57 => 0x6c },
	'audiochannels' => { 57 => 0x70 },
	'audiochanneltype' => { 413 => 'audioChannelType' },
	'audiocompression' => { 128 => 'Compression' },
	'audiocompressor' => { 413 => 'audioCompressor' },
	'audioduration' => { 107 => 0x99 },
	'audiomoddate' => { 413 => 'audioModDate' },
	'audiooutcue' => { 107 => 0x9a },
	'audiosamplerate' => { 57 => 0x6e, 413 => 'audioSampleRate' },
	'audiosampletype' => { 413 => 'audioSampleType' },
	'audiosamplingrate' => { 107 => 0x97 },
	'audiosamplingresolution' => { 107 => 0x98 },
	'audiotype' => { 107 => 0x96 },
	'author' => { 130 => 'Author', 251 => 'Author', 254 => 'Author', 308 => 'Author', 382 => 'author', 399 => 'Author', 411 => 'Author' },
	'authorsposition' => { 400 => 'AuthorsPosition' },
	'autoaperture' => { 286 => '0.1' },
	'autobracket' => { 326 => 0x19 },
	'autobracketing' => { 104 => 0x1100, 295 => 0x18, 317 => 0x1007 },
	'autobracketingmode' => { 238 => '12.3' },
	'autobracketingset' => { 238 => '12.1' },
	'autobracketmodem' => { 229 => '21.2', 230 => '13.3', 235 => '26.2', 239 => '13.3' },
	'autobracketorder' => { 154 => 0x43, 229 => '21.3', 230 => '13.2', 235 => '26.3', 236 => '12.2', 237 => '2.2', 238 => '12.2', 239 => '13.2', 240 => '13.2' },
	'autobracketset' => { 229 => '21.1', 230 => '13.1', 232 => '11.1', 233 => '12.1', 234 => '12.1', 235 => '26.1', 236 => '12.1', 237 => '2.1', 239 => '13.1', 240 => '13.1' },
	'autobrightness' => { 388 => 'AutoBrightness' },
	'autocontrast' => { 388 => 'AutoContrast' },
	'autodistortioncontrol' => { 172 => 0x4 },
	'autodynamicrange' => { 104 => 0x140b },
	'autoexposure' => { 388 => 'AutoExposure' },
	'autoexposurebracketing' => { 66 => 0x10 },
	'autofocus' => { 245 => 0x209 },
	'autofp' => { 237 => '7.3', 240 => '31.4' },
	'autoiso' => { 66 => 0x1, 95 => 0x3008, 231 => '1.1', 237 => '1.1' },
	'autoisomax' => { 231 => '1.2', 237 => '1.2' },
	'autoisominshutterspeed' => { 231 => '1.3', 237 => '1.3' },
	'autolateralca' => { 388 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 53 => 0x2, 72 => 0x204, 91 => 0x6f },
	'autolightingoptimizeron' => { 91 => 0x6e },
	'autoportraitframed' => { 346 => 0x2016 },
	'autoredeye' => { 222 => 0xfe28a44f },
	'autorotate' => { 66 => 0x1b },
	'autoshadows' => { 388 => 'AutoShadows' },
	'autowhiteversion' => { 388 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 186 => 0x82 },
	'avaperturesetting' => { 276 => 0x13 },
	'averageblacklevel' => { 37 => 0xe7, 39 => 0xfb, 40 => 0x114, 41 => 0x146 },
	'averagelv' => { 157 => 0x38 },
	'avsettingwithoutlens' => { 72 => 0x707 },
	'azimuth' => { 138 => 'Azimuth' },
	'babyage' => { 262 => [0x8010,0x33] },
	'babyname' => { 262 => 0x66 },
	'backgroundalpha' => { 408 => 'bgalpha' },
	'baseexposurecompensation' => { 276 => 0x15 },
	'baseiso' => { 66 => 0x2, 85 => 0x101c, 113 => 0x903, 264 => 0x312a, 369 => 0x6 },
	'baselineexposure' => { 99 => 0xc62a },
	'baselineexposureoffset' => { 99 => 0xc7a5 },
	'baselinenoise' => { 99 => 0xc62b },
	'baselinesharpness' => { 99 => 0xc62c },
	'baseurl' => { 411 => 'BaseURL' },
	'batterylevel' => { 334 => 0x51, 338 => 0xc, 339 => 0x4, 340 => 0x4, 370 => 0x7 },
	'batterylevelgrip1' => { 370 => 0x6 },
	'batterylevelgrip2' => { 370 => 0x8 },
	'batteryorder' => { 229 => '12.5', 235 => '13.2', 236 => '2.1', 239 => '3.1' },
	'batterystate' => { 154 => 0x60, 334 => 0x50, 340 => 0x14 },
	'batterytemperature' => { 338 => 0x1, 340 => 0x2, 370 => 0x5 },
	'batteryunknown' => { 338 => 0x2, 340 => 0x0 },
	'batteryvoltage' => { 113 => 0x408, 313 => 0x2a, 338 => 0x8 },
	'batteryvoltage1' => { 340 => 0x6 },
	'batteryvoltage2' => { 340 => 0x8 },
	'bayergreensplit' => { 99 => 0xc62d },
	'bayerpattern' => { 112 => 0xf902, 158 => 0x17 },
	'beatspliceparams' => { 413 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 413 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 413 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 413 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 413 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 413 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 229 => '13.1', 230 => '5.4', 231 => '0.1', 232 => '2.1', 233 => '3.1', 234 => '3.1', 235 => '10.1', 237 => '0.1', 239 => '5.5', 240 => '4.1' },
	'beeppitch' => { 236 => '3.1' },
	'beepvolume' => { 236 => '4.5' },
	'bestqualityscale' => { 99 => 0xc65c },
	'bestshotmode' => { 95 => 0x3007 },
	'bitdepth' => { 135 => 'BitDepth', 158 => 0x11, 192 => 0x41 },
	'bitspercomponent' => { 109 => 0x87 },
	'bitspersample' => { 99 => 0x102, 409 => 'BitsPerSample' },
	'blacklevel' => { 99 => 0xc61a, 186 => 0x3d, 247 => [0x401,0x1012] },
	'blacklevel1' => { 266 => 0x8 },
	'blacklevel2' => { 246 => 0x600, 250 => 0x600, 266 => 0x9 },
	'blacklevel3' => { 266 => 0xa },
	'blacklevelblue' => { 266 => 0x1e },
	'blackleveldeltah' => { 99 => 0xc61b },
	'blackleveldeltav' => { 99 => 0xc61c },
	'blacklevelgreen' => { 266 => 0x1d },
	'blacklevelred' => { 266 => 0x1c },
	'blacklevelrepeatdim' => { 99 => 0xc619 },
	'blackpoint' => { 295 => 0x200 },
	'blacks2012' => { 388 => 'Blacks2012' },
	'bleachbypasstoning' => { 295 => 0x7f },
	'blogtitle' => { 403 => 'blogTitle' },
	'blogurl' => { 403 => 'blogURL' },
	'bluebalance' => { 170 => 0x271, 247 => 0x1018, 266 => 0x12, 295 => 0x1b },
	'bluecurvelimits' => { 90 => 0x1fe },
	'bluecurvepoints' => { 90 => 0x1d4 },
	'bluehue' => { 388 => 'BlueHue' },
	'bluesaturation' => { 388 => 'BlueSaturation' },
	'blurcontrol' => { 295 => 0x82 },
	'blurwarning' => { 104 => 0x1300 },
	'bodybatteryadload' => { 274 => 0x3 },
	'bodybatteryadnoload' => { 274 => 0x2 },
	'bodybatterystate' => { 274 => '1.1' },
	'bodybatteryvoltage1' => { 274 => 0x2 },
	'bodybatteryvoltage2' => { 274 => 0x4 },
	'bodybatteryvoltage3' => { 274 => 0x6 },
	'bodybatteryvoltage4' => { 274 => 0x8 },
	'bodyfirmware' => { 318 => 0x0 },
	'bodyfirmwareversion' => { 243 => 0x104, 244 => 0x100, 247 => 0x104 },
	'bodyserialnumber' => { 318 => 0x10 },
	'bookedition' => { 403 => 'bookEdition' },
	'bracketmode' => { 48 => 0x3 },
	'bracketsequence' => { 95 => 0x301d },
	'bracketsettings' => { 262 => 0x45 },
	'bracketshotnumber' => { 48 => 0x5, 276 => 0x9, 345 => 0x2b },
	'bracketshotnumber2' => { 345 => 0x2d },
	'bracketstep' => { 151 => 0xe },
	'bracketvalue' => { 48 => 0x4 },
	'brightness' => { 99 => 0xfe53, 129 => 'Brightness', 151 => 0x2c, 188 => 0x34, 313 => 0x25, 334 => 0x22, 346 => 0x2007, 388 => 'Brightness' },
	'brightnessadj' => { 90 => 0x114, 215 => 0x0, 225 => 0x2d, 373 => 0x8018 },
	'brightnessvalue' => { 99 => 0x9203, 157 => [0x691,0x49c3], 247 => 0x1003, 350 => 0x1e, 353 => 0x1140, 354 => 0x1140, 355 => 0x111c, 356 => 0x1198, 357 => 0x1174, 358 => 0x102c, 359 => 0x224, 392 => 'BrightnessValue' },
	'bulbduration' => { 66 => 0x18 },
	'burstmode' => { 115 => 0xa, 262 => 0x2a },
	'burstmode2' => { 115 => 0x18 },
	'burstshot' => { 326 => 0x34 },
	'burstspeed' => { 262 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 72 => 0x70a },
	'bwfilter' => { 151 => 0x2a, 159 => 0x39 },
	'bwmode' => { 247 => 0x203 },
	'by-line' => { 107 => 0x50 },
	'by-linetitle' => { 107 => 0x55 },
	'bytecount' => { 403 => 'byteCount' },
	'calibration' => { 326 => [0x24,0x30] },
	'calibrationilluminant1' => { 99 => 0xc65a },
	'calibrationilluminant2' => { 99 => 0xc65b },
	'cameraangle' => { 413 => 'cameraAngle' },
	'cameracalibration1' => { 99 => 0xc623 },
	'cameracalibration2' => { 99 => 0xc624 },
	'cameracalibrationsig' => { 99 => 0xc6f3 },
	'cameracolorcalibration01' => { 32 => 0x0, 38 => 0xba },
	'cameracolorcalibration02' => { 32 => 0x4, 38 => 0xbf },
	'cameracolorcalibration03' => { 32 => 0x8, 38 => 0xc4 },
	'cameracolorcalibration04' => { 32 => 0xc, 38 => 0xc9 },
	'cameracolorcalibration05' => { 32 => 0x10, 38 => 0xce },
	'cameracolorcalibration06' => { 32 => 0x14, 38 => 0xd3 },
	'cameracolorcalibration07' => { 32 => 0x18, 38 => 0xd8 },
	'cameracolorcalibration08' => { 32 => 0x1c, 38 => 0xdd },
	'cameracolorcalibration09' => { 32 => 0x20, 38 => 0xe2 },
	'cameracolorcalibration10' => { 32 => 0x24, 38 => 0xe7 },
	'cameracolorcalibration11' => { 32 => 0x28, 38 => 0xec },
	'cameracolorcalibration12' => { 32 => 0x2c, 38 => 0xf1 },
	'cameracolorcalibration13' => { 32 => 0x30, 38 => 0xf6 },
	'cameracolorcalibration14' => { 32 => 0x34, 38 => 0xfb },
	'cameracolorcalibration15' => { 32 => 0x38, 38 => 0x100 },
	'cameraid' => { 247 => 0x209, 325 => 0x209 },
	'cameraiso' => { 30 => 0x10 },
	'cameralabel' => { 99 => 0xc7a1, 413 => 'cameraLabel' },
	'cameramodel' => { 413 => 'cameraModel' },
	'cameramove' => { 413 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 262 => 0x8f, 298 => 0x1, 340 => [0x16,0x18], 361 => 0x28, 362 => 0x24, 363 => 0x29 },
	'cameraowner' => { 116 => 0xc353 },
	'cameraparameters' => { 247 => 0x2050 },
	'cameraprofile' => { 388 => 'CameraProfile' },
	'cameraprofiledigest' => { 388 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 99 => 0xc62f, 149 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 242 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 29 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 66 => 0xc, 113 => 0x406, 246 => 0x1306, 258 => 0x320, 264 => 0x3402, 295 => 0x47, 323 => 0x43, 365 => 0x5 },
	'cameratemperature2' => { 299 => 0xc },
	'cameratemperature3' => { 299 => 0xe },
	'cameratemperature4' => { 299 => 0x14 },
	'cameratemperature5' => { 299 => 0x16 },
	'cameratemperaturerangemax' => { 101 => 0x5 },
	'cameratemperaturerangemin' => { 101 => 0x6 },
	'cameratype' => { 66 => 0x1a, 247 => 0x207 },
	'cameratype2' => { 243 => 0x100 },
	'canonexposuremode' => { 30 => 0x14 },
	'canonfiledescription' => { 85 => 0x805 },
	'canonfilelength' => { 54 => 0xe },
	'canonfirmwareversion' => { 54 => 0x7, 85 => 0x80b },
	'canonflashinfo' => { 85 => 0x1028 },
	'canonflashmode' => { 30 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 30 => 0xa },
	'canonimagetype' => { 54 => 0x6, 85 => 0x815 },
	'canonmodelid' => { 54 => 0x10, 85 => 0x1834 },
	'canonvrd' => { 100 => 'CanonVRD' },
	'caption' => { 382 => 'caption' },
	'caption-abstract' => { 107 => 0x78 },
	'captionsauthornames' => { 391 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 391 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 400 => 'CaptionWriter' },
	'captureframerate' => { 95 => 0x4001 },
	'capturesoftware' => { 377 => 'CaptureSoftware' },
	'cardshutterlock' => { 154 => 0x49 },
	'casioimagesize' => { 95 => 0x9 },
	'catalogsets' => { 107 => 0xff, 376 => 'CatalogSets', 380 => 'CatalogSets' },
	'categories' => { 54 => 0x23, 382 => 'categories' },
	'category' => { 107 => 0xf, 241 => 0x30, 400 => 'Category' },
	'cbcrgain' => { 323 => 0xa036 },
	'cbcrgaindefault' => { 323 => 0xa035 },
	'cbcrmatrix' => { 323 => 0xa034 },
	'cbcrmatrixdefault' => { 323 => 0xa033 },
	'ccdboardversion' => { 258 => 0x331 },
	'ccdscanmode' => { 247 => 0x1039 },
	'ccdsensitivity' => { 212 => 0x6 },
	'ccdversion' => { 258 => 0x330 },
	'cellglobalid' => { 386 => 'cgi' },
	'celllength' => { 99 => 0x109 },
	'cellr' => { 386 => 'r' },
	'celltowerid' => { 386 => 'cellid' },
	'cellwidth' => { 99 => 0x108 },
	'centerafarea' => { 237 => '15.1' },
	'centerfocuspoint' => { 240 => '2.2' },
	'centerweightedareasize' => { 229 => '7.1', 230 => '8.1', 235 => '5.1', 236 => '7.1', 237 => '6.3', 239 => '8.1', 240 => '8.1' },
	'certificate' => { 417 => 'Certificate' },
	'cfapattern' => { 99 => 0xa302, 392 => 'CFAPattern' },
	'cfapattern2' => { 99 => 0x828e },
	'cfapatterncolumns' => { 392 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 392 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 392 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 99 => 0x828d },
	'channel' => { 403 => 'channel' },
	'channela-lang' => { 403 => [\'channel','channelA-lang'] },
	'channelchannel' => { 403 => [\'channel','channelChannel'] },
	'channels' => { 128 => 'Channels' },
	'channelsubchannel1' => { 403 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 403 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 403 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 403 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 90 => 0x26a },
	'checkmark2' => { 91 => 0x8e },
	'childfontfiles' => { 418 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 229 => '10.3', 230 => '11.2' },
	'chromablurradius' => { 99 => 0xc631 },
	'chromaticaberration' => { 91 => 0x66, 323 => 0xa051 },
	'chromaticaberrationb' => { 388 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 91 => 0x6b },
	'chromaticaberrationcorr' => { 68 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 285 => 0x1 },
	'chromaticaberrationon' => { 91 => 0x62 },
	'chromaticaberrationr' => { 388 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 91 => 0x6a },
	'chromaticaberrationsetting' => { 69 => 0x6 },
	'chrominancenoisereduction' => { 91 => 0x5e, 326 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 91 => 0x60 },
	'circgradbasedcorractive' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 388 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 388 => 'CircularGradientBasedCorrections' },
	'city' => { 107 => 0x5a, 134 => 'City', 262 => 0x6d, 400 => 'City' },
	'city2' => { 262 => 0x80 },
	'clarity' => { 388 => 'Clarity' },
	'clarity2012' => { 388 => 'Clarity2012' },
	'classifystate' => { 107 => 0xe1 },
	'clearretouch' => { 262 => 0x7c },
	'clearretouchvalue' => { 262 => 0xa3 },
	'client' => { 413 => 'client' },
	'clientname' => { 394 => 'ClientName' },
	'clmodeshootingspeed' => { 229 => '10.2', 230 => '11.3', 235 => '11.2', 236 => '10.2', 239 => '11.2', 240 => '11.1' },
	'cmcontrast' => { 250 => 0x2022 },
	'cmexposurecompensation' => { 250 => 0x2000 },
	'cmhue' => { 250 => 0x2021 },
	'cmsaturation' => { 250 => 0x2020 },
	'cmsharpness' => { 250 => 0x2023 },
	'cmwhitebalance' => { 250 => 0x2001 },
	'cmwhitebalancecomp' => { 250 => 0x2002 },
	'cmwhitebalancegraypoint' => { 250 => 0x2010 },
	'codec' => { 142 => 'Codec' },
	'codedcharacterset' => { 108 => 0x5a },
	'collectionname' => { 143 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 143 => 'Collections' },
	'collectionuri' => { 143 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 402 => 'color' },
	'coloraberrationcontrol' => { 222 => 0xc89224b },
	'coloradjustment' => { 326 => 0x14 },
	'coloradjustmentmode' => { 325 => 0x210 },
	'coloranta' => { 418 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 418 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 418 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 418 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 418 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 418 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 418 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 418 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 418 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 418 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 418 => 'Colorants' },
	'colorantswatchname' => { 418 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 418 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 418 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 418 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 129 => 'ColorBalance' },
	'colorbalanceadj' => { 222 => 0x76a43202 },
	'colorbalanceblue' => { 151 => 0x1e },
	'colorbalancegreen' => { 151 => 0x1d },
	'colorbalancered' => { 151 => 0x1c },
	'colorbalanceversion' => { 171 => 0x0 },
	'colorblur' => { 91 => 0x65 },
	'colorbooster' => { 222 => 0x5f0e7d23 },
	'colorboostlevel' => { 216 => 0x1 },
	'colorboosttype' => { 216 => 0x0 },
	'colorclass' => { 303 => 0xde, 304 => 'ColorClass' },
	'colorcompensationfilter' => { 154 => [0x3a,0x5f], 156 => 0x111, 346 => 0xb022 },
	'colorcompensationfiltercustom' => { 334 => 0xd, 335 => 0xc },
	'colorcompensationfilterset' => { 334 => 0x8, 335 => 0x7, 336 => 0x18, 350 => 0xf },
	'colorcontrol' => { 247 => 0x102b },
	'colorcorrection' => { 373 => 0x8015 },
	'colordataversion' => { 36 => 0x0, 37 => 0x0, 39 => 0x0, 40 => 0x0, 41 => 0x0 },
	'coloreffect' => { 262 => 0x28 },
	'colorfilter' => { 94 => 0x17, 95 => 0x3017, 151 => 0x29, 159 => [0x38,0x4d,0x4f], 301 => 0x17 },
	'colorgain' => { 192 => 0x51 },
	'colorhue' => { 186 => 0x8d },
	'colorimetricreference' => { 99 => 0xc6bf },
	'colorlabel' => { 391 => 'ColorLabel' },
	'colormatrix' => { 246 => 0x200, 247 => 0x1011, 323 => 0xa030 },
	'colormatrix1' => { 99 => 0xc621 },
	'colormatrix2' => { 99 => 0xc622, 250 => 0x200 },
	'colormatrixa' => { 295 => 0x203 },
	'colormatrixadobergb' => { 323 => 0xa032 },
	'colormatrixb' => { 295 => 0x204 },
	'colormatrixnumber' => { 247 => 0x1019 },
	'colormatrixsrgb' => { 323 => 0xa031 },
	'colormode' => { 95 => 0x3015, 104 => 0x1210, 115 => 0x66, 151 => 0x28, 154 => 0x16, 156 => 0x101, 157 => 0x36, 159 => 0x7, 186 => 0x3, 212 => 0x4, 262 => 0x32, 326 => 0x2c, 346 => 0xb029, 400 => 'ColorMode' },
	'colormoirereduction' => { 223 => 0x15 },
	'colormoirereductionmode' => { 223 => 0x5 },
	'colornoisereduction' => { 373 => 0x8029, 388 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 388 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 223 => 0x18 },
	'colornoisereductionsharpness' => { 223 => 0x1c },
	'colornoisereductionsmoothness' => { 388 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 103 => 0x2 },
	'colorprofile' => { 151 => 0x33 },
	'colorrepresentation' => { 109 => 0x3c },
	'colorsequence' => { 109 => 0x41 },
	'colorspace' => { 42 => 0x3, 54 => 0xb4, 85 => 0x10b4, 99 => 0xa001, 135 => 'ColorSpace', 152 => 0x2f, 153 => 0x25, 154 => 0x17, 186 => 0x1e, 242 => 0x507, 295 => 0x37, 323 => 0xa011, 326 => 0xb, 334 => 0x1b, 335 => 0x83, 336 => 0xe, 350 => 0x6, 392 => 'ColorSpace' },
	'colortempasshot' => { 33 => 0x4, 34 => 0x1d, 35 => 0x26, 36 => 0x43, 39 => 0x43, 40 => 0x43, 41 => 0x43 },
	'colortempauto' => { 33 => 0x9, 34 => 0x22, 35 => 0x1c, 36 => 0x48, 39 => 0x48, 40 => 0x48, 41 => 0x48 },
	'colortempcloudy' => { 33 => 0x22, 34 => 0x31, 35 => 0x35, 36 => 0x5c, 39 => 0x75, 40 => 0x8e, 41 => 0x93, 295 => 0x55 },
	'colortempcustom' => { 36 => 0x84 },
	'colortempcustom1' => { 34 => 0x45 },
	'colortempcustom2' => { 34 => 0x4a },
	'colortempdaylight' => { 33 => 0x18, 34 => 0x27, 35 => 0x2b, 36 => 0x52, 39 => 0x6b, 40 => 0x84, 41 => 0x89, 295 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 54 => 0xae, 64 => 0x9, 85 => 0x10ae, 104 => 0x1005, 113 => 0x846, 129 => 'ColorTemperature', 152 => [0x6e,0x49], 153 => 0x3f, 154 => [0x39,0x5e], 156 => 0x10b, 159 => [0x3c,0x4c,0x4e], 258 => 0x321, 295 => 0x50, 317 => 0x1308, 346 => 0xb021, 388 => 'Temperature' },
	'colortemperatureadj' => { 373 => 0x8013 },
	'colortemperaturebg' => { 247 => 0x1013 },
	'colortemperaturecustom' => { 334 => 0xc, 335 => 0xb },
	'colortemperaturerg' => { 247 => 0x1014 },
	'colortemperatureset' => { 334 => 0x7, 335 => 0x6 },
	'colortemperaturesetting' => { 154 => 0x25, 336 => 0x17, 350 => 0xe },
	'colortempflash' => { 33 => 0x36, 34 => 0x40, 35 => 0x49, 36 => 0x70, 39 => 0x89, 40 => 0xa2, 41 => 0xa7, 295 => 0x5a },
	'colortempflashdata' => { 36 => 0x24a },
	'colortempfluorescent' => { 33 => 0x2c, 34 => 0x3b, 35 => 0x3f, 36 => 0x66, 39 => 0x7f, 40 => 0x98, 41 => 0x9d },
	'colortempfluorescentd' => { 295 => 0x57 },
	'colortempfluorescentn' => { 295 => 0x58 },
	'colortempfluorescentw' => { 295 => 0x59 },
	'colortempkelvin' => { 33 => 0x31, 35 => 0x44, 36 => 0x6b, 39 => 0x84, 40 => 0x9d, 41 => 0xa2, 262 => 0x44, 317 => 0x1307 },
	'colortempmeasured' => { 33 => 0xe, 36 => 0x4d, 39 => 0x4d, 40 => 0x4d, 41 => 0x4d },
	'colortemppc1' => { 35 => 0x94, 36 => 0x75 },
	'colortemppc2' => { 35 => 0x99, 36 => 0x7a },
	'colortemppc3' => { 35 => 0x9e, 36 => 0x7f },
	'colortempshade' => { 33 => 0x1d, 34 => 0x2c, 35 => 0x30, 36 => 0x57, 39 => 0x70, 40 => 0x89, 41 => 0x8e, 295 => 0x54 },
	'colortemptungsten' => { 33 => 0x27, 34 => 0x36, 35 => 0x3a, 36 => 0x61, 39 => 0x7a, 40 => 0x93, 41 => 0x98, 295 => 0x56 },
	'colortempunknown' => { 33 => 0x13, 35 => 0x21, 39 => 0x52, 40 => 0x52, 41 => 0x52 },
	'colortempunknown10' => { 33 => 0x63, 35 => 0x76, 39 => 0xa2, 40 => 0x7f, 41 => 0x7f },
	'colortempunknown11' => { 33 => 0x68, 35 => 0x7b, 39 => 0xa7, 40 => 0xa7, 41 => 0x84 },
	'colortempunknown12' => { 33 => 0x6d, 35 => 0x80, 39 => 0xac, 40 => 0xac, 41 => 0xac },
	'colortempunknown13' => { 33 => 0x72, 35 => 0x85, 39 => 0xb1, 40 => 0xb1, 41 => 0xb1 },
	'colortempunknown14' => { 35 => 0x8a, 39 => 0xb6, 40 => 0xb6, 41 => 0xb6 },
	'colortempunknown15' => { 35 => 0x8f, 39 => 0xbb, 40 => 0xbb, 41 => 0xbb },
	'colortempunknown16' => { 35 => 0xa3, 40 => 0xc0, 41 => 0xc0 },
	'colortempunknown17' => { 40 => 0xc5, 41 => 0xc5 },
	'colortempunknown18' => { 40 => 0xca, 41 => 0xca },
	'colortempunknown19' => { 40 => 0xcf, 41 => 0xcf },
	'colortempunknown2' => { 33 => 0x3b, 35 => 0x4e, 39 => 0x57, 40 => 0x57, 41 => 0x57 },
	'colortempunknown20' => { 40 => 0xd4, 41 => 0xd4 },
	'colortempunknown21' => { 41 => 0xd9 },
	'colortempunknown22' => { 41 => 0xde },
	'colortempunknown23' => { 41 => 0xe3 },
	'colortempunknown24' => { 41 => 0xe8 },
	'colortempunknown25' => { 41 => 0xed },
	'colortempunknown26' => { 41 => 0xf2 },
	'colortempunknown27' => { 41 => 0xf7 },
	'colortempunknown28' => { 41 => 0xfc },
	'colortempunknown29' => { 41 => 0x101 },
	'colortempunknown3' => { 33 => 0x40, 35 => 0x53, 39 => 0x5c, 40 => 0x5c, 41 => 0x5c },
	'colortempunknown30' => { 41 => 0x106 },
	'colortempunknown4' => { 33 => 0x45, 35 => 0x58, 39 => 0x61, 40 => 0x61, 41 => 0x61 },
	'colortempunknown5' => { 33 => 0x4a, 35 => 0x5d, 39 => 0x66, 40 => 0x66, 41 => 0x66 },
	'colortempunknown6' => { 33 => 0x4f, 35 => 0x62, 39 => 0x8e, 40 => 0x6b, 41 => 0x6b },
	'colortempunknown7' => { 33 => 0x54, 35 => 0x67, 39 => 0x93, 40 => 0x70, 41 => 0x70 },
	'colortempunknown8' => { 33 => 0x59, 35 => 0x6c, 39 => 0x98, 40 => 0x75, 41 => 0x75 },
	'colortempunknown9' => { 33 => 0x5e, 35 => 0x71, 39 => 0x9d, 40 => 0x7a, 41 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 30 => 0x2a, 42 => 0x2 },
	'colortoneadj' => { 90 => 0x11e },
	'colortoneauto' => { 61 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 60 => 0x6c, 61 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 60 => 0x3c, 61 => 0x3c },
	'colortonemonochrome' => { 60 => 0x84, 61 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 60 => 0x54, 61 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 60 => 0x24, 61 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 60 => 0xc, 61 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 60 => 0x9c, 61 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 60 => 0xb4, 61 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 60 => 0xcc, 61 => 0xe4 },
	'commanddials' => { 237 => '5.1' },
	'commanddialsaperturesetting' => { 229 => '17.3', 230 => '18.3', 235 => '33.3', 236 => '17.3', 239 => '18.3' },
	'commanddialschangemainsub' => { 229 => '17.2', 230 => '18.1', 235 => '33.2', 236 => '17.2', 239 => '18.1' },
	'commanddialsmenuandplayback' => { 229 => '17.4', 230 => '18.2', 235 => '33.4', 236 => '17.4', 239 => '18.2' },
	'commanddialsreverserotation' => { 229 => '17.1', 230 => '6.4', 232 => '16.2', 233 => '17.2', 235 => '33.1', 236 => '17.1', 239 => '6.2', 240 => '18.1' },
	'commanderchannel' => { 237 => '10.2', 238 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 237 => '13.1', 238 => '31.1' },
	'commandergroupa_ttlcomp' => { 240 => '32.1' },
	'commandergroupamanualoutput' => { 237 => '13.2', 238 => '28.2' },
	'commandergroupamode' => { 237 => '11.2', 238 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 237 => '14.1', 238 => '32.1' },
	'commandergroupb_ttlcomp' => { 240 => '33.1' },
	'commandergroupbmanualoutput' => { 237 => '14.2', 238 => '29.2' },
	'commandergroupbmode' => { 237 => '11.3', 238 => '29.1' },
	'commanderinternalflash' => { 237 => '11.1', 238 => '27.1' },
	'commanderinternalmanualoutput' => { 237 => '12.2', 238 => '27.2' },
	'commanderinternalttlchannel' => { 235 => '18.2' },
	'commanderinternalttlcomp' => { 237 => '12.1', 238 => '30.2', 240 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 235 => '20.1', 236 => '26.1' },
	'commanderinternalttlcompgroupa' => { 235 => '21.1', 236 => '27.1' },
	'commanderinternalttlcompgroupb' => { 235 => '22.1', 236 => '28.1' },
	'comment' => { 0 => 0x2, 100 => 'Comment', 130 => 'Comment', 254 => 'Comment' },
	'compass' => { 320 => 0x4 },
	'complianceprofile' => { 403 => 'complianceProfile' },
	'componentsconfiguration' => { 99 => 0x9101, 135 => 'Components', 392 => 'ComponentsConfiguration' },
	'componentversion' => { 85 => 0x80c },
	'composer' => { 413 => 'composer' },
	'compositionadjust' => { 294 => '0.1' },
	'compositionadjustrotation' => { 294 => 0x7 },
	'compositionadjustx' => { 294 => 0x5 },
	'compositionadjusty' => { 294 => 0x6 },
	'compressedbitsperpixel' => { 99 => 0x9102, 392 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 156 => 0x40, 247 => 0x40 },
	'compression' => { 99 => 0x103, 409 => 'Compression' },
	'compressionfactor' => { 242 => 0x50d },
	'compressionratio' => { 135 => 'Compression', 247 => 0x1034 },
	'confidencelevel' => { 383 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 90 => 0x266, 303 => 0xd6 },
	'constrainedcropwidth' => { 90 => 0x262, 303 => 0xd5 },
	'contact' => { 107 => 0x76 },
	'contactinfo' => { 402 => 'contactInfo' },
	'contentlocationcode' => { 107 => 0x1a },
	'contentlocationname' => { 107 => 0x1b },
	'contenttype' => { 403 => 'contentType' },
	'continuousbracketing' => { 154 => 0x20 },
	'continuousdrive' => { 30 => 0x5 },
	'continuousshootingspeed' => { 72 => 0x610 },
	'continuousshotlimit' => { 72 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 30 => 0xd, 94 => 0xc, 95 => [0x3012,0x20], 99 => [0xa408,0xfe54], 104 => [0x1004,0x1006], 129 => 'Contrast', 151 => 0x20, 152 => 0x31, 153 => 0x27, 154 => 0x19, 159 => 0x2, 188 => 0x33, 247 => 0x1029, 262 => 0x39, 264 => 0x300a, 295 => 0x20, 301 => 0xc, 313 => 0x24, 317 => 0x1012, 326 => 0xd, 334 => 0x1d, 335 => 0x1a, 346 => 0x2004, 388 => 'Contrast', 392 => 'Contrast' },
	'contrast2012' => { 388 => 'Contrast2012' },
	'contrastadj' => { 90 => 0x115, 225 => 0x2c, 373 => 0x8017 },
	'contrastauto' => { 61 => 0x90 },
	'contrastcurve' => { 186 => 0x8c },
	'contrastdetectaf' => { 162 => 0x4 },
	'contrastdetectafarea' => { 295 => 0x231 },
	'contrastdetectafinfocus' => { 162 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 60 => 0x60, 61 => 0x60 },
	'contrasthighlight' => { 295 => 0x6d },
	'contrasthighlightshadowadj' => { 295 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 60 => 0x30, 61 => 0x30 },
	'contrastmode' => { 262 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 60 => 0x78, 61 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 60 => 0x48, 61 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 60 => 0x18, 61 => 0x18 },
	'contrastsetting' => { 242 => 0x505, 250 => 0x1012, 336 => 0x10, 350 => 0x8 },
	'contrastshadow' => { 295 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 60 => 0x0, 61 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 60 => 0x90, 61 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 60 => 0xa8, 61 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 60 => 0xc0, 61 => 0xd8 },
	'contributedmedia' => { 413 => 'contributedMedia' },
	'contributedmediaduration' => { 413 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 413 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 413 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 413 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 413 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 413 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 413 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 413 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 413 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 413 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 389 => 'contributor' },
	'contributors' => { 130 => 'Contributors' },
	'controldialset' => { 154 => 0x46 },
	'controlledvocabularyterm' => { 398 => 'CVterm' },
	'controllerboardversion' => { 258 => 0x332 },
	'controlmode' => { 66 => 0x12 },
	'conversionlens' => { 243 => 0x403, 262 => 0x35 },
	'converter' => { 99 => 0xfe4d, 212 => 0xb, 388 => 'Converter' },
	'converttograyscale' => { 388 => 'ConvertToGrayscale' },
	'cookingequipment' => { 405 => 'cookingEquipment' },
	'cookingmethod' => { 405 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 99 => 0x8298, 130 => 'Copyright', 254 => 'Copyright', 295 => 0x22f, 308 => 'Copyright', 399 => 'Copyright', 406 => 'copyright', 409 => 'Copyright', 413 => 'copyright' },
	'copyrightflag' => { 306 => 0x40a },
	'copyrightnotice' => { 107 => 0x74 },
	'copyrightowner' => { 401 => 'CopyrightOwner' },
	'copyrightownerid' => { 401 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 401 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 401 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 401 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 401 => 'CopyrightStatus' },
	'copyrightyear' => { 403 => 'copyrightYear' },
	'coringfilter' => { 246 => 0x310, 247 => 0x102d, 250 => 0x310 },
	'coringvalues' => { 246 => 0x311, 250 => 0x311 },
	'corporateentity' => { 403 => 'corporateEntity' },
	'country' => { 134 => 'Country', 262 => 0x69, 400 => 'Country' },
	'country-primarylocationcode' => { 107 => 0x64 },
	'country-primarylocationname' => { 107 => 0x65 },
	'countrycode' => { 185 => 0x5, 304 => 'CountryCode', 397 => 'CountryCode' },
	'course' => { 405 => 'course' },
	'coverage' => { 389 => 'coverage' },
	'coverdate' => { 403 => 'coverDate' },
	'coverdisplaydate' => { 403 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 295 => 0x28 },
	'crc32' => { 390 => 'crc32' },
	'createdate' => { 99 => 0x9004, 130 => 'CreateDate', 251 => 'CreationDate', 254 => 'create-date', 308 => 'CreationDate', 310 => 0x1, 411 => 'CreateDate' },
	'creationdate' => { 399 => 'CreationDate', 403 => 'creationDate' },
	'creationtime' => { 254 => 'Creation Time' },
	'creativestyle' => { 334 => 0x1a, 335 => 0x18, 345 => 0x41, 346 => 0xb020, 369 => 0x4a },
	'creativestylesetting' => { 336 => 0xf, 350 => 0x7 },
	'creativestylewaschanged' => { 373 => 0x8001 },
	'creator' => { 251 => 'Creator', 308 => 'Creator', 389 => 'creator', 399 => 'Creator' },
	'creatoraddress' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 397 => 'CreatorContactInfo' },
	'creatorcountry' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 411 => 'CreatorTool' },
	'creatorworkemail' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 397 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 107 => 0x6e, 400 => 'Credit' },
	'creditline' => { 406 => 'creditLine' },
	'creditlinereq' => { 416 => 'CreditLineReq' },
	'creditlinerequired' => { 401 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x244 },
	'cropangle' => { 388 => 'CropAngle' },
	'cropaspectratio' => { 90 => 0x260 },
	'cropbottom' => { 103 => 0x9, 217 => 0x36, 303 => 0xdc, 388 => 'CropBottom' },
	'cropbottommargin' => { 44 => 0x3 },
	'cropcircleactive' => { 91 => 0xd6 },
	'cropcircleradius' => { 91 => 0xd9 },
	'cropcirclex' => { 91 => 0xd7 },
	'cropcircley' => { 91 => 0xd8 },
	'cropconstraintowarp' => { 388 => 'CropConstrainToWarp' },
	'croph' => { 381 => 'CropH' },
	'cropheight' => { 90 => 0x24c, 246 => 0x615, 250 => 0x615, 388 => 'CropHeight' },
	'crophispeed' => { 186 => 0x1b },
	'cropleft' => { 90 => 0x246, 103 => 0x6, 217 => 0x1e, 246 => 0x612, 250 => 0x612, 303 => 0xd9, 388 => 'CropLeft' },
	'cropleftmargin' => { 44 => 0x0 },
	'cropmode35mm' => { 317 => 0x1018 },
	'cropoutputheight' => { 217 => 0xce },
	'cropoutputheightinches' => { 217 => 0x96 },
	'cropoutputpixels' => { 217 => 0xd6 },
	'cropoutputresolution' => { 217 => 0xb6 },
	'cropoutputscale' => { 217 => 0xbe },
	'cropoutputwidth' => { 217 => 0xc6 },
	'cropoutputwidthinches' => { 217 => 0x8e },
	'croppedareaimageheightpixels' => { 377 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 377 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 377 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 377 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 317 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 317 => 0x1603 },
	'cropright' => { 103 => 0x8, 217 => 0x2e, 303 => 0xdb, 388 => 'CropRight' },
	'croprightmargin' => { 44 => 0x1 },
	'croprotation' => { 103 => 0xb },
	'cropscaledresolution' => { 217 => 0x9e },
	'cropsourceresolution' => { 217 => 0xae },
	'croptop' => { 90 => 0x248, 103 => 0x7, 217 => 0x26, 246 => 0x613, 250 => 0x613, 303 => 0xda, 388 => 'CropTop' },
	'croptopmargin' => { 44 => 0x2 },
	'cropunit' => { 388 => 'CropUnit' },
	'cropunits' => { 388 => 'CropUnits' },
	'cropw' => { 381 => 'CropW' },
	'cropwidth' => { 90 => 0x24a, 246 => 0x614, 250 => 0x614, 388 => 'CropWidth' },
	'cropx' => { 381 => 'CropX' },
	'cropy' => { 381 => 'CropY' },
	'crossprocess' => { 295 => 0x7b },
	'crossprocessparams' => { 295 => 0x235 },
	'cuisine' => { 405 => 'cuisine' },
	'currenticcprofile' => { 99 => 0xc691 },
	'currentpreprofilematrix' => { 99 => 0xc692 },
	'currentversion' => { 373 => 0xd000 },
	'curve0x' => { 381 => 'Curve0x' },
	'curve0y' => { 381 => 'Curve0y' },
	'curve1x' => { 381 => 'Curve1x' },
	'curve1y' => { 381 => 'Curve1y' },
	'curve2x' => { 381 => 'Curve2x' },
	'curve2y' => { 381 => 'Curve2y' },
	'curve3x' => { 381 => 'Curve3x' },
	'curve3y' => { 381 => 'Curve3y' },
	'curve4x' => { 381 => 'Curve4x' },
	'curve4y' => { 381 => 'Curve4y' },
	'curves' => { 222 => 0x76a43201 },
	'custom1' => { 401 => 'Custom1' },
	'custom10' => { 401 => 'Custom10' },
	'custom2' => { 401 => 'Custom2' },
	'custom3' => { 401 => 'Custom3' },
	'custom4' => { 401 => 'Custom4' },
	'custom5' => { 401 => 'Custom5' },
	'custom6' => { 401 => 'Custom6' },
	'custom7' => { 401 => 'Custom7' },
	'custom8' => { 401 => 'Custom8' },
	'custom9' => { 401 => 'Custom9' },
	'customcontrast' => { 91 => 0x4e },
	'customcontrols' => { 72 => 0x70c },
	'customdefaultunsharpfineness' => { 91 => 0xbe },
	'customdefaultunsharpstrength' => { 91 => 0xbc },
	'customdefaultunsharpthreshold' => { 91 => 0xc0 },
	'customlinear' => { 91 => 0x4f },
	'customoutputhighlightpoint' => { 91 => 0x53 },
	'customoutputshadowpoint' => { 91 => 0x54 },
	'custompicturestylefilename' => { 54 => 0x4010 },
	'customrawhighlight' => { 91 => 0x7c },
	'customrawhighlightpoint' => { 91 => 0x51 },
	'customrawshadow' => { 91 => 0x85 },
	'customrawshadowpoint' => { 91 => 0x52 },
	'customrendered' => { 99 => 0xa401, 392 => 'CustomRendered' },
	'customsaturation' => { 242 => 0x503 },
	'customsettingsalldefault' => { 229 => '0.2', 235 => '0.2' },
	'customsettingsbank' => { 229 => '0.1', 230 => '0.1', 235 => '0.1', 239 => '0.2' },
	'customsharpness' => { 91 => 0x50 },
	'customunsharpmaskfineness' => { 91 => 0xb8 },
	'customunsharpmaskstrength' => { 91 => 0xb6 },
	'customunsharpmaskthreshold' => { 91 => 0xba },
	'customwb_rblevels' => { 350 => 0x1a },
	'customwb_rgblevels' => { 335 => 0x8, 336 => 0x19 },
	'customwbbluelevel' => { 154 => 0x36 },
	'customwberror' => { 154 => 0x37 },
	'customwbgreenlevel' => { 154 => 0x35 },
	'customwbredlevel' => { 154 => 0x34 },
	'customwbsetting' => { 154 => 0x26 },
	'd-lightinghq' => { 222 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 218 => 0x2 },
	'd-lightinghqhighlight' => { 218 => 0x1 },
	'd-lightinghqselected' => { 222 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 218 => 0x0 },
	'd-lightinghs' => { 222 => 0xce5554aa },
	'd-lightinghsadjustment' => { 219 => 0x0 },
	'd-lightinghscolorboost' => { 219 => 0x1 },
	'd-rangeoptimizerhighlight' => { 373 => 0x8024 },
	'd-rangeoptimizermode' => { 373 => 0x8022 },
	'd-rangeoptimizershadow' => { 373 => 0x802d },
	'd-rangeoptimizervalue' => { 373 => 0x8023 },
	'd810meteringmode' => { 210 => [0x16be,0x175e] },
	'datacompressionmethod' => { 109 => 0x6e },
	'dataimprint' => { 151 => 0x34 },
	'datascaling' => { 295 => 0x3d },
	'date' => { 295 => 0x6, 389 => 'date' },
	'dateacquired' => { 149 => 'DateAcquired' },
	'datecreated' => { 107 => 0x37, 400 => 'DateCreated' },
	'datedisplayformat' => { 214 => 0x3 },
	'dateidentified' => { 98 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 232 => '4.2' },
	'daterecieved' => { 403 => 'dateRecieved' },
	'datesent' => { 108 => 0x46 },
	'datestampmode' => { 54 => 0x1c },
	'datetime' => { 382 => 'datetime', 409 => 'DateTime' },
	'datetimedigitized' => { 392 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 88 => 0x0, 99 => 0x9003, 127 => 0x14, 130 => 'OriginalDate', 313 => 0xb, 392 => 'DateTimeOriginal' },
	'datetimestamp' => { 115 => 0x64 },
	'datetimeutc' => { 242 => 0x908 },
	'daylightsavings' => { 67 => 0x3, 214 => 0x2 },
	'dccontinent' => { 98 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 98 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 98 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 98 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 98 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 98 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 98 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 98 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 98 => 'Event' },
	'dcfootprintspatialfit' => { 98 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 98 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 98 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 98 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 98 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 98 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 98 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 98 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 98 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 98 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 98 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 98 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 98 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 98 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 98 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 98 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 98 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 98 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 98 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 98 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 138 => 'Declination' },
	'decposition' => { 151 => 0x32 },
	'defaultblackrender' => { 99 => 0xc7a6 },
	'defaultcroporigin' => { 99 => 0xc61f },
	'defaultcropsize' => { 99 => 0xc620 },
	'defaulteraseoption' => { 72 => 0x813 },
	'defaultscale' => { 99 => 0xc61e },
	'defaultusercrop' => { 99 => 0xc7b5 },
	'defringe' => { 388 => 'Defringe' },
	'defringegreenamount' => { 388 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 388 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 388 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 388 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 388 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 388 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 186 => 0xa6, 193 => 0x6e },
	'deprecatedon' => { 385 => 'deprecatedOn' },
	'derivedfrom' => { 414 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 414 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 414 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 414 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 414 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 414 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 414 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 414 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 414 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 414 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 414 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 414 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 414 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 414 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 414 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 414 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 414 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 414 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 254 => 'Description', 389 => 'description', 411 => 'Description' },
	'destination' => { 108 => 0x5 },
	'destinationcity' => { 295 => 0x24, 300 => 0x3 },
	'destinationcitycode' => { 301 => 0x1001 },
	'destinationdst' => { 295 => 0x26, 300 => '0.3' },
	'developmentdynamicrange' => { 104 => 0x1403 },
	'device' => { 403 => 'device' },
	'devicesettingdescription' => { 392 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 392 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 392 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 392 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 323 => 0x2 },
	'dialdirectiontvav' => { 72 => 0x706 },
	'dietaryneeds' => { 405 => 'dietaryNeeds' },
	'digitalcreationdate' => { 107 => 0x3e },
	'digitalcreationtime' => { 107 => 0x3f },
	'digitaldeehighlightadj' => { 192 => 0x202 },
	'digitaldeeshadowadj' => { 192 => 0x200 },
	'digitaldeethreshold' => { 192 => 0x201 },
	'digitalfilter' => { 326 => 0x59 },
	'digitalfilter01' => { 282 => 0x5 },
	'digitalfilter02' => { 282 => 0x16 },
	'digitalfilter03' => { 282 => 0x27 },
	'digitalfilter04' => { 282 => 0x38 },
	'digitalfilter05' => { 282 => 0x49 },
	'digitalfilter06' => { 282 => 0x5a },
	'digitalfilter07' => { 282 => 0x6b },
	'digitalfilter08' => { 282 => 0x7c },
	'digitalfilter09' => { 282 => 0x8d },
	'digitalfilter10' => { 282 => 0x9e },
	'digitalfilter11' => { 282 => 0xaf },
	'digitalfilter12' => { 282 => 0xc0 },
	'digitalfilter13' => { 282 => 0xd1 },
	'digitalfilter14' => { 282 => 0xe2 },
	'digitalfilter15' => { 282 => 0xf3 },
	'digitalfilter16' => { 282 => 0x104 },
	'digitalfilter17' => { 282 => 0x115 },
	'digitalfilter18' => { 282 => 0x126 },
	'digitalfilter19' => { 282 => 0x137 },
	'digitalfilter20' => { 282 => 0x148 },
	'digitalgain' => { 64 => 0xb },
	'digitalgem' => { 178 => 0x0 },
	'digitalice' => { 192 => 0x100 },
	'digitalimageguid' => { 398 => 'DigImageGUID' },
	'digitalroc' => { 190 => 0x0 },
	'digitalsourcefiletype' => { 398 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 398 => 'DigitalSourceType' },
	'digitalzoom' => { 30 => 0xc, 94 => 0xa, 115 => 0x68, 129 => 'DigitalZoom', 151 => 0xc, 186 => 0x86, 212 => 0xa, 247 => 0x204, 295 => 0x1e, 301 => 0xa, 325 => 0x204, 361 => 0x12, 362 => 0x12 },
	'digitalzoomon' => { 325 => 0x21b },
	'digitalzoomratio' => { 99 => 0xa404, 355 => 0x200, 357 => 0x21c, 392 => 'DigitalZoomRatio' },
	'director' => { 413 => 'director' },
	'directorphotography' => { 413 => 'directorPhotography' },
	'directory' => { 100 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 174 => 0x3 },
	'disclaimer' => { 254 => 'Disclaimer' },
	'discnumber' => { 413 => 'discNumber' },
	'dishtype' => { 405 => 'dishType' },
	'displayallafpoints' => { 72 => 0x514 },
	'displayaperture' => { 30 => 0x23 },
	'displayedunitsx' => { 307 => 0x2 },
	'displayedunitsy' => { 307 => 0x6 },
	'displayname' => { 402 => 'displayName' },
	'distance1' => { 115 => 0x28 },
	'distance2' => { 115 => 0x2c },
	'distance3' => { 115 => 0x30 },
	'distance4' => { 115 => 0x34 },
	'distortion' => { 323 => 0xa050 },
	'distortioncontrol' => { 193 => 0x10 },
	'distortioncorrection' => { 91 => 0x67, 242 => 0x50b, 265 => '7.1', 285 => 0x0, 368 => 0x601, 369 => 0x5b },
	'distortioncorrection2' => { 246 => 0x1011 },
	'distortioncorrectionon' => { 91 => 0x63 },
	'distortioncorrectionsetting' => { 346 => 0x2013 },
	'distortionn' => { 265 => 0xc },
	'distortionparam02' => { 265 => 0x2 },
	'distortionparam04' => { 265 => 0x4 },
	'distortionparam08' => { 265 => 0x8 },
	'distortionparam09' => { 265 => 0x9 },
	'distortionparam11' => { 265 => 0xb },
	'distortionscale' => { 265 => 0x5 },
	'distributor' => { 403 => 'distributor' },
	'distributorproductid' => { 402 => 'distributorProductID' },
	'dloon' => { 91 => 0xdc },
	'dlosetting' => { 91 => 0xdd },
	'dlosettingapplied' => { 91 => 0xe4 },
	'dloshootingdistance' => { 91 => 0xde },
	'dloversion' => { 91 => 0xe5 },
	'dmcomment' => { 413 => 'comment' },
	'dngadobedata' => { 99 => 0xc634 },
	'dngbackwardversion' => { 99 => 0xc613 },
	'dnglensinfo' => { 99 => 0xc630 },
	'dngprivatedata' => { 99 => 0xc634 },
	'dngversion' => { 99 => 0xc612 },
	'document' => { 254 => 'Document' },
	'documentancestorid' => { 400 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 400 => 'DocumentAncestors' },
	'documenthistory' => { 107 => 0xe7 },
	'documentid' => { 414 => 'DocumentID' },
	'documentname' => { 99 => 0x10d },
	'documentnotes' => { 107 => 0xe6 },
	'doi' => { 403 => 'doi' },
	'dotrange' => { 99 => 0x150 },
	'dpp' => { 382 => 'dpp' },
	'drivemode' => { 95 => 0x3103, 151 => 0x6, 154 => 0x1e, 157 => 0xe, 242 => 0x600, 295 => 0x34, 317 => 0x1002, 326 => 0x3, 334 => 0x4, 335 => 0x7e, 336 => 0x34 },
	'drivemode2' => { 154 => 0xa, 276 => 0x7, 345 => 0xe, 350 => 0x1 },
	'drivemodesetting' => { 336 => 0x4 },
	'dspfirmwareversion' => { 295 => 0x27 },
	'duration' => { 57 => 0x6a, 128 => 'Duration', 142 => 'Duration', 405 => 'duration', 413 => 'duration' },
	'durationscale' => { 413 => [\'duration','durationScale'] },
	'durationvalue' => { 413 => [\'duration','durationValue'] },
	'dustremovaldata' => { 54 => 0x97 },
	'dynamicafarea' => { 229 => '1.4', 235 => '1.4' },
	'dynamicareaafdisplay' => { 230 => '46.1', 239 => '47.1' },
	'dynamicrange' => { 104 => 0x1400 },
	'dynamicrangeexpansion' => { 295 => 0x69, 317 => 0x100e },
	'dynamicrangemax' => { 90 => 0x7c },
	'dynamicrangemin' => { 90 => 0x7a },
	'dynamicrangeoptimizer' => { 154 => 0x15, 346 => [0xb025,0xb04f], 353 => 0x1144, 354 => [0x1144,0x324], 355 => [0x1120,0x300], 356 => [0x119c,0x37c], 357 => [0x1178,0x328], 358 => [0x1030,0x50], 359 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 345 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 334 => 0x19, 335 => 0x17, 336 => 0xd, 345 => 0x79, 350 => 0x5 },
	'dynamicrangeoptimizermode' => { 157 => 0x15, 334 => 0x18, 335 => 0x16, 345 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 154 => 0x27, 336 => 0xc, 350 => 0x4 },
	'dynamicrangesetting' => { 104 => 0x1402 },
	'e-dialinprogram' => { 276 => '1.3' },
	'e-mountversioncamera' => { 336 => 0x3f3, 372 => 0xb },
	'e-mountversionlens' => { 336 => 0x3f0, 372 => 0xd },
	'earliestageorloweststage' => { 98 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 98 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 98 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 98 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 98 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 240 => '6.1' },
	'easyexposurecompensation' => { 229 => '6.4', 230 => '6.5', 235 => '4.4', 236 => '5.2', 239 => '6.3' },
	'easymode' => { 30 => 0xb },
	'edgenoisereduction' => { 223 => 0x4, 373 => 0x8028 },
	'edition' => { 403 => 'edition' },
	'editorialupdate' => { 107 => 0x8 },
	'editstatus' => { 107 => 0x7, 304 => 'EditStatus' },
	'editversionname' => { 222 => 0x3d136244 },
	'effectivelv' => { 295 => 0x2d },
	'effectivemaxaperture' => { 182 => 0x12, 183 => 0x13 },
	'eissn' => { 403 => 'eIssn' },
	'electronicfront-curtainshutter' => { 239 => '5.3' },
	'elevation' => { 138 => 'Elevation' },
	'email' => { 130 => 'EMail' },
	'embargodate' => { 406 => 'embargoDate' },
	'embdencrightsexpr' => { 398 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 398 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 398 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 398 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 400 => 'EmbeddedXMPDigest' },
	'emissivity' => { 101 => 0x3 },
	'encryptionkey' => { 323 => 0xa020 },
	'endingpage' => { 403 => 'endingPage' },
	'enduser' => { 401 => 'EndUser' },
	'enduserid' => { 401 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 401 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 413 => 'engineer' },
	'enhancedarktones' => { 215 => 0x8 },
	'enhancement' => { 94 => 0x16, 95 => 0x3016 },
	'enhancer' => { 246 => 0x300 },
	'enhancervalues' => { 246 => 0x301 },
	'envelopenumber' => { 108 => 0x28 },
	'envelopepriority' => { 108 => 0x3c },
	'enveloperecordversion' => { 108 => 0x0 },
	'epsonimageheight' => { 247 => 0x20c },
	'epsonimagewidth' => { 247 => 0x20b },
	'epsonsoftware' => { 247 => 0x20d },
	'equipmentinstitution' => { 375 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 375 => 'EquipmentManufacturer' },
	'equipmentversion' => { 243 => 0x0 },
	'ettlii' => { 72 => 0x304, 73 => 0xd, 74 => 0xe, 75 => 0x7, 76 => 0x7, 77 => 0xe },
	'event' => { 376 => 'Event', 380 => 'Event', 398 => 'Event', 403 => 'event' },
	'eventalias' => { 402 => 'eventAlias' },
	'eventday' => { 98 => [\'Event','EventDay'] },
	'eventearliestdate' => { 98 => [\'Event','EventEarliestDate'] },
	'eventend' => { 402 => 'eventEnd' },
	'eventenddayofyear' => { 98 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 98 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 98 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 98 => [\'Event','EventHabitat'] },
	'eventid' => { 98 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 98 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 98 => [\'Event','EventMonth'] },
	'eventnumber' => { 313 => 0x9 },
	'eventremarks' => { 98 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 98 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 98 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 402 => 'eventStart' },
	'eventstartdayofyear' => { 98 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 402 => 'eventSubtype' },
	'eventtime' => { 98 => [\'Event','EventEventTime'] },
	'eventtype' => { 402 => 'eventType' },
	'eventverbatimeventdate' => { 98 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 98 => [\'Event','EventYear'] },
	'evsteps' => { 276 => '1.2', 278 => 0x0 },
	'evstepsize' => { 232 => '5.1', 233 => '6.1', 234 => '6.1', 237 => '0.7' },
	'exclusivityenddate' => { 406 => 'exclusivityEndDate' },
	'excursiontolerance' => { 109 => 0x82 },
	'exif' => { 100 => 'EXIF' },
	'exifbyteorder' => { 100 => 'ExifByteOrder' },
	'exifcamerainfo' => { 107 => 0xe8 },
	'exifimageheight' => { 99 => 0xa003, 392 => 'PixelYDimension' },
	'exifimagewidth' => { 99 => 0xa002, 392 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 100 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 99 => 0x9000, 392 => 'ExifVersion' },
	'exitpupilposition' => { 182 => 0x4, 183 => 0x4 },
	'expirationdate' => { 107 => 0x25, 406 => 'expirationDate' },
	'expirationtime' => { 107 => 0x26 },
	'exposure' => { 99 => 0xfe51, 388 => 'Exposure' },
	'exposure2012' => { 388 => 'Exposure2012' },
	'exposureadj' => { 220 => 0x0 },
	'exposureadj2' => { 220 => 0x12 },
	'exposureadjust' => { 326 => 0xc },
	'exposurebracketingindicatorlast' => { 154 => 0x52 },
	'exposurebracketshotnumber' => { 157 => 0x2d, 345 => 0x2f },
	'exposurebracketstepsize' => { 276 => 0x8 },
	'exposurebracketvalue' => { 186 => 0x19 },
	'exposurecompensation' => { 66 => 0x6, 81 => 0x0, 99 => 0x9204, 115 => 0x24, 129 => 'ExposureComp', 151 => 0xd, 152 => 0x53, 153 => 0x1e, 157 => 0x49c0, 247 => 0x1006, 295 => 0x16, 323 => 0xa013, 326 => [0xc,0x35,0x4d], 353 => 0x114c, 354 => 0x114c, 355 => 0x1128, 357 => 0x1180, 358 => 0x1038, 359 => 0x230, 392 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 350 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 154 => 0x47, 157 => 0x2a },
	'exposurecompensationset' => { 334 => 0x3, 335 => 0x3, 336 => 0x3, 350 => 0x1e },
	'exposurecompensationsetting' => { 154 => 0x1 },
	'exposurecompstepsize' => { 229 => '6.3', 230 => '7.3', 235 => '4.3', 239 => '7.3' },
	'exposurecontrolstep' => { 236 => '6.1' },
	'exposurecontrolstepsize' => { 229 => '6.2', 230 => '7.1', 235 => '4.2', 239 => '7.1', 240 => '7.1' },
	'exposurecount' => { 104 => 0x1032 },
	'exposuredelaymode' => { 229 => '10.1', 230 => '11.1', 232 => '9.1', 233 => '10.1', 234 => '10.1', 235 => '10.4', 236 => '10.1', 237 => '6.4', 239 => '11.1', 240 => '11.2' },
	'exposuredifference' => { 186 => 0xe },
	'exposureindex' => { 99 => 0xa215, 392 => 'ExposureIndex' },
	'exposureindicator' => { 154 => 0x50 },
	'exposurelevelincrements' => { 70 => 0x6, 71 => 0x6, 72 => 0x101, 73 => 0x5, 74 => 0x6, 75 => 0x5, 76 => 0x5, 77 => 0x6, 78 => 0x4, 334 => 0x58, 335 => 0x58 },
	'exposurelockused' => { 377 => 'ExposureLockUsed' },
	'exposuremode' => { 99 => 0xa402, 129 => 'ExposureMode', 151 => 0x1, 152 => 0xa, 153 => 0x0, 154 => 0x0, 157 => 0x34, 242 => 0x200, 260 => 0x40d, 326 => 0x8, 346 => 0xb041, 392 => 'ExposureMode' },
	'exposuremodeinmanual' => { 72 => 0x10b },
	'exposureprogram' => { 99 => 0x8822, 317 => 0x1001, 327 => 0x17e, 334 => 0x3c, 335 => 0x3c, 336 => 0x5, 340 => 0x14, 345 => 0x3f, 350 => 0x2, 353 => 0x1175, 354 => 0x1179, 355 => 0x1155, 356 => 0x11d1, 357 => 0x11ad, 358 => 0x1065, 359 => 0x25d, 369 => 0x48, 392 => 'ExposureProgram' },
	'exposureshift' => { 242 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 66 => 0x16, 99 => 0x829a, 112 => 0xfd05, 115 => 0x20, 117 => 0xfa24, 119 => 0xf104, 122 => 0x12, 124 => 0x38, 127 => 0x10, 129 => 'ExposureTime', 151 => 0x9, 152 => 0x35, 153 => 0x48, 154 => 0x8, 157 => 0x49b8, 295 => 0x12, 323 => 0xa018, 326 => [0x32,0x4a], 334 => 0x0, 335 => 0x0, 350 => [0x21,0x23,0x27], 369 => 0x10, 392 => 'ExposureTime' },
	'exposuretime2' => { 326 => [0x33,0x4b] },
	'exposuretuning' => { 186 => 0x1c },
	'exposurevalue' => { 113 => 0x3 },
	'exposurewarning' => { 104 => 0x1302 },
	'exrauto' => { 104 => 0x1033 },
	'exrmode' => { 104 => 0x1034 },
	'extendedwbdetect' => { 242 => 0x902 },
	'extender' => { 243 => 0x301 },
	'extenderfirmwareversion' => { 243 => 0x304 },
	'extendermagnification' => { 131 => 'Magnification' },
	'extendermake' => { 131 => 'Make' },
	'extendermodel' => { 131 => 'Model', 243 => 0x303 },
	'extenderserialnumber' => { 131 => 'SerialNumber', 243 => 0x302 },
	'externalflash' => { 245 => 0x1201 },
	'externalflashae1' => { 247 => 0x101f },
	'externalflashae1_0' => { 247 => 0x101b },
	'externalflashae2' => { 247 => 0x1020 },
	'externalflashae2_0' => { 247 => 0x101c },
	'externalflashbounce' => { 245 => 0x1204, 247 => 0x1026, 283 => 0x1a },
	'externalflashcompensation' => { 177 => 0x1b },
	'externalflashexposurecomp' => { 186 => 0x17, 283 => 0x19 },
	'externalflashfirmware' => { 175 => 0x6, 176 => 0x6, 177 => 0x6 },
	'externalflashflags' => { 175 => 0x8, 176 => 0x8, 177 => 0x8 },
	'externalflashguidenumber' => { 245 => 0x1203, 283 => '24.1' },
	'externalflashgvalue' => { 247 => 0x1025 },
	'externalflashmode' => { 247 => 0x1028, 283 => 0x2 },
	'externalflashzoom' => { 245 => 0x1205, 247 => 0x1027 },
	'externalsensorbrightnessvalue' => { 258 => 0x311, 264 => 0x3408 },
	'extrainfoversion' => { 338 => 0x1a },
	'eyestartaf' => { 154 => 0x40 },
	'face10position' => { 92 => 0x3f4, 93 => 0x1ec, 173 => 0x28, 280 => 0x12 },
	'face10size' => { 281 => 0x12 },
	'face11position' => { 173 => 0x2c, 280 => 0x14 },
	'face11size' => { 281 => 0x14 },
	'face12position' => { 173 => 0x30, 280 => 0x16 },
	'face12size' => { 281 => 0x16 },
	'face13position' => { 280 => 0x18 },
	'face13size' => { 281 => 0x18 },
	'face14position' => { 280 => 0x1a },
	'face14size' => { 281 => 0x1a },
	'face15position' => { 280 => 0x1c },
	'face15size' => { 281 => 0x1c },
	'face16position' => { 280 => 0x1e },
	'face16size' => { 281 => 0x1e },
	'face17position' => { 280 => 0x20 },
	'face17size' => { 281 => 0x20 },
	'face18position' => { 280 => 0x22 },
	'face18size' => { 281 => 0x22 },
	'face19position' => { 280 => 0x24 },
	'face19size' => { 281 => 0x24 },
	'face1position' => { 45 => 0x8, 92 => 0xd, 93 => 0x18, 173 => 0x4, 256 => 0x1, 280 => 0x0, 314 => 0xbc, 341 => 0x1, 342 => 0x0, 343 => 0x0, 344 => 0x5b },
	'face1size' => { 281 => 0x0 },
	'face20position' => { 280 => 0x26 },
	'face20size' => { 281 => 0x26 },
	'face21position' => { 280 => 0x28 },
	'face21size' => { 281 => 0x28 },
	'face22position' => { 280 => 0x2a },
	'face22size' => { 281 => 0x2a },
	'face23position' => { 280 => 0x2c },
	'face23size' => { 281 => 0x2c },
	'face24position' => { 280 => 0x2e },
	'face24size' => { 281 => 0x2e },
	'face25position' => { 280 => 0x30 },
	'face25size' => { 281 => 0x30 },
	'face26position' => { 280 => 0x32 },
	'face26size' => { 281 => 0x32 },
	'face27position' => { 280 => 0x34 },
	'face27size' => { 281 => 0x34 },
	'face28position' => { 280 => 0x36 },
	'face28size' => { 281 => 0x36 },
	'face29position' => { 280 => 0x38 },
	'face29size' => { 281 => 0x38 },
	'face2position' => { 45 => 0xa, 92 => 0x7c, 93 => 0x4c, 173 => 0x8, 256 => 0x5, 280 => 0x2, 314 => 0xc8, 341 => 0x6, 342 => 0x20, 343 => 0x25, 344 => 0x65 },
	'face2size' => { 281 => 0x2 },
	'face30position' => { 280 => 0x3a },
	'face30size' => { 281 => 0x3a },
	'face31position' => { 280 => 0x3c },
	'face31size' => { 281 => 0x3c },
	'face32position' => { 280 => 0x3e },
	'face32size' => { 281 => 0x3e },
	'face3position' => { 45 => 0xc, 92 => 0xeb, 93 => 0x80, 173 => 0xc, 256 => 0x9, 280 => 0x4, 314 => 0xd4, 341 => 0xb, 342 => 0x40, 343 => 0x4a, 344 => 0x6f },
	'face3size' => { 281 => 0x4 },
	'face4position' => { 45 => 0xe, 92 => 0x15a, 93 => 0xb4, 173 => 0x10, 256 => 0xd, 280 => 0x6, 314 => 0xe0, 341 => 0x10, 342 => 0x60, 343 => 0x6f, 344 => 0x79 },
	'face4size' => { 281 => 0x6 },
	'face5position' => { 45 => 0x10, 92 => 0x1c9, 93 => 0xe8, 173 => 0x14, 256 => 0x11, 280 => 0x8, 314 => 0xec, 341 => 0x15, 342 => 0x80, 343 => 0x94 },
	'face5size' => { 281 => 0x8 },
	'face6position' => { 45 => 0x12, 92 => 0x238, 93 => 0x11c, 173 => 0x18, 280 => 0xa, 314 => 0xf8, 341 => 0x1a, 342 => 0xa0, 343 => 0xb9 },
	'face6size' => { 281 => 0xa },
	'face7position' => { 45 => 0x14, 92 => 0x2a7, 93 => 0x150, 173 => 0x1c, 280 => 0xc, 314 => 0x104, 341 => 0x1f, 342 => 0xc0, 343 => 0xde },
	'face7size' => { 281 => 0xc },
	'face8position' => { 45 => 0x16, 92 => 0x316, 93 => 0x184, 173 => 0x20, 280 => 0xe, 314 => 0x110, 341 => 0x24, 342 => 0xe0, 343 => 0x103 },
	'face8size' => { 281 => 0xe },
	'face9position' => { 45 => 0x18, 92 => 0x385, 93 => 0x1b8, 173 => 0x24, 280 => 0x10 },
	'face9size' => { 281 => 0x10 },
	'facedetect' => { 295 => 0x76, 323 => 0x100 },
	'facedetectarea' => { 246 => 0x1201 },
	'facedetectframecrop' => { 246 => 0x1207 },
	'facedetectframesize' => { 45 => 0x3, 92 => 0x1, 93 => 0x4, 173 => 0x1, 246 => 0x1203, 295 => 0x77, 314 => 0xb6 },
	'facedetection' => { 336 => 0x30, 350 => 0x19 },
	'faceid' => { 383 => 'FaceID' },
	'faceinfounknown' => { 95 => 0x2089 },
	'facename' => { 323 => 0x123 },
	'faceorientation' => { 93 => 0x8 },
	'faceposition' => { 279 => 0x2, 324 => 0x4 },
	'facepositions' => { 104 => 0x4103 },
	'facerecognition' => { 323 => 0x120 },
	'facesdetected' => { 45 => 0x2, 46 => 0x2, 47 => 0x3, 92 => 0x0, 93 => 0x2, 95 => 0x211c, 104 => 0x4100, 173 => 0x3, 246 => 0x1200, 262 => 0x3f, 279 => 0x0, 314 => 0xb5, 324 => 0x0, 341 => 0x0, 344 => 0x3, 352 => 0x30 },
	'facesrecognized' => { 257 => 0x0 },
	'facewidth' => { 46 => 0x1 },
	'faithfuloutputhighlightpoint' => { 91 => 0x38 },
	'faithfuloutputshadowpoint' => { 91 => 0x39 },
	'faithfulrawcolortone' => { 91 => 0x31 },
	'faithfulrawcontrast' => { 91 => 0x33 },
	'faithfulrawhighlight' => { 91 => 0x79 },
	'faithfulrawhighlightpoint' => { 91 => 0x36 },
	'faithfulrawlinear' => { 91 => 0x34 },
	'faithfulrawsaturation' => { 91 => 0x32 },
	'faithfulrawshadow' => { 91 => 0x82 },
	'faithfulrawshadowpoint' => { 91 => 0x37 },
	'faithfulrawsharpness' => { 91 => 0x35 },
	'faithfulunsharpmaskfineness' => { 91 => 0xac },
	'faithfulunsharpmaskstrength' => { 91 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 91 => 0xae },
	'femicroadjustment' => { 72 => 0x111 },
	'ffid' => { 390 => 'ffid' },
	'field' => { 402 => 'field' },
	'fieldcount' => { 247 => 0x103f },
	'filecreatedate' => { 100 => 'FileCreateDate' },
	'filedatarate' => { 413 => 'fileDataRate' },
	'fileformat' => { 83 => 0x0, 108 => 0x14, 326 => [0x22,0x26], 346 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 263 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 100 => 'FileModifyDate' },
	'filename' => { 100 => 'FileName' },
	'filenameasdelivered' => { 401 => 'FileNameAsDelivered' },
	'filenumber' => { 48 => 0x1, 54 => 0x8, 85 => 0x1817, 96 => 'FileNumber', 174 => 0x4 },
	'filenumbermemory' => { 151 => 0x1a },
	'filenumbersequence' => { 229 => '12.2', 232 => '3.1', 233 => '4.1', 234 => '4.1', 235 => '11.1', 236 => '4.3', 240 => '5.2' },
	'filesource' => { 99 => 0xa300, 104 => 0x8000, 392 => 'FileSource' },
	'fileversion' => { 108 => 0x16 },
	'fillflashautoreduction' => { 70 => 0xe, 71 => 0xe, 78 => 0xa },
	'filllight' => { 388 => 'FillLight' },
	'fillorder' => { 99 => 0x10a },
	'filmmode' => { 104 => 0x1401, 260 => 0x412, 262 => 0x42 },
	'filmtype' => { 192 => 0x2 },
	'filtereffect' => { 48 => 0xe, 188 => 0x37 },
	'filtereffectauto' => { 61 => 0xa0 },
	'filtereffectfaithful' => { 60 => 0x70, 61 => 0x70 },
	'filtereffectlandscape' => { 60 => 0x40, 61 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 60 => 0x88, 61 => 0x88 },
	'filtereffectneutral' => { 60 => 0x58, 61 => 0x58 },
	'filtereffectportrait' => { 60 => 0x28, 61 => 0x28 },
	'filtereffectstandard' => { 60 => 0x10, 61 => 0x10 },
	'filtereffectuserdef1' => { 60 => 0xa0, 61 => 0xb8 },
	'filtereffectuserdef2' => { 60 => 0xb8, 61 => 0xd0 },
	'filtereffectuserdef3' => { 60 => 0xd0, 61 => 0xe8 },
	'finderdisplayduringexposure' => { 71 => 0x1 },
	'finesharpness' => { 295 => 0x70 },
	'finetuneoptcenterweighted' => { 229 => '7.2', 230 => '9.1', 239 => '9.1', 240 => '9.1' },
	'finetuneopthighlightweighted' => { 239 => '46.1' },
	'finetuneoptmatrixmetering' => { 229 => '8.1', 230 => '8.2', 235 => '6.1', 239 => '8.2', 240 => '8.2' },
	'finetuneoptspotmetering' => { 229 => '8.2', 230 => '9.2', 235 => '6.2', 239 => '9.2', 240 => '9.2' },
	'firmware' => { 247 => 0x405, 326 => [0x17,0x3b,0x57], 384 => 'Firmware' },
	'firmwaredate' => { 94 => 0x15, 95 => 0x2001, 313 => 0x4 },
	'firmwareid' => { 158 => 0x0 },
	'firmwarename' => { 323 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 54 => 0x1e, 315 => 0x0 },
	'firmwarerevision2' => { 315 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 113 => 0xce5, 127 => 0x57, 129 => 'FirmwareVersion', 262 => 0x2, 264 => 0x3109, 295 => 0x230, 317 => 0x2 },
	'firstphotodate' => { 377 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 401 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 107 => 0x16 },
	'flash' => { 96 => 'Flash', 99 => 0x9209, 152 => 0x1f, 153 => 0x15, 392 => 'Flash' },
	'flashaction' => { 334 => 0x3e, 335 => 0x3e, 346 => 0x2017, 350 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 334 => 0x4c, 335 => 0x4c, 350 => 0x77 },
	'flashactionexternal' => { 350 => [0x78,0x7c] },
	'flashactivity' => { 30 => 0x1c },
	'flashbatterylevel' => { 36 => 0x249 },
	'flashbias' => { 262 => 0x24 },
	'flashbits' => { 30 => 0x1d },
	'flashbuttonfunction' => { 72 => 0x70e },
	'flashchargelevel' => { 247 => 0x1010 },
	'flashcolorfilter' => { 177 => 0x10 },
	'flashcommandermode' => { 175 => '9.1', 176 => '9.1', 177 => '9.1' },
	'flashcompensation' => { 175 => 0xa, 176 => 0xa, 177 => 0xa, 384 => 'FlashCompensation' },
	'flashcontrol' => { 334 => 0x23, 335 => 0x1f, 336 => 0x21 },
	'flashcontrolbuilt-in' => { 235 => '16.1', 236 => '23.1', 238 => '23.1', 239 => '24.1' },
	'flashcontrolmode' => { 175 => '9.2', 176 => '9.2', 177 => '9.2', 242 => 0x404 },
	'flashcurtain' => { 262 => 0x48 },
	'flashdefault' => { 154 => 0x42 },
	'flashdevice' => { 247 => 0x1005 },
	'flashdistance' => { 95 => 0x2034 },
	'flashenergy' => { 99 => 0xa20b, 392 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 186 => 0x18 },
	'flashexposurecomp' => { 66 => 0xf, 104 => 0x1011, 132 => 'ExposureComp', 151 => 0x23, 156 => 0x104, 157 => 0x49c1, 186 => 0x12, 242 => 0x401, 247 => 0x1023, 295 => 0x4d, 317 => 0x100b, 326 => [0x3a,0x56], 346 => 0x104 },
	'flashexposurecomp2' => { 209 => 0x4d2 },
	'flashexposurecomp3' => { 177 => 0x1d },
	'flashexposurecomp4' => { 177 => 0x27 },
	'flashexposurecomparea' => { 230 => '38.4', 239 => '38.4' },
	'flashexposurecompset' => { 154 => 0x10, 269 => 0xe, 334 => 0x14, 335 => 0x12, 336 => 0x23, 350 => 0x1f },
	'flashexposurecompset2' => { 350 => [0x26,0x2c] },
	'flashexposureindicator' => { 154 => 0x54 },
	'flashexposureindicatorlast' => { 154 => 0x56 },
	'flashexposureindicatornext' => { 154 => 0x55 },
	'flashexposurelock' => { 48 => 0x19 },
	'flashfired' => { 115 => 0x5d, 132 => 'Fired', 151 => 0x14, 208 => '590.3', 262 => 0x8007, 392 => [\'Flash','FlashFired'] },
	'flashfiring' => { 72 => 0x306, 73 => 0x6, 74 => 0x7, 77 => 0x7 },
	'flashfirmwareversion' => { 243 => 0x1002 },
	'flashfocallength' => { 175 => 0xb, 176 => 0xc, 177 => 0xc },
	'flashfunction' => { 157 => 0x31, 392 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 175 => 0xe, 176 => 0xf, 177 => 0xf },
	'flashgroupacompensation' => { 175 => 0x11, 176 => 0x12, 177 => 0x13 },
	'flashgroupacontrolmode' => { 175 => 0xf, 176 => '16.1', 177 => '17.1' },
	'flashgroupaoutput' => { 175 => 0x11, 176 => 0x12, 177 => 0x13 },
	'flashgroupbcompensation' => { 175 => 0x12, 176 => 0x13, 177 => 0x14 },
	'flashgroupbcontrolmode' => { 175 => 0x10, 176 => '17.1', 177 => '18.1' },
	'flashgroupboutput' => { 175 => 0x12, 176 => 0x13, 177 => 0x14 },
	'flashgroupccompensation' => { 176 => 0x14, 177 => 0x15 },
	'flashgroupccontrolmode' => { 176 => '17.2', 177 => '18.2' },
	'flashgroupcoutput' => { 176 => 0x14, 177 => 0x15 },
	'flashguidenumber' => { 66 => 0xd, 82 => 0x0, 132 => 'GuideNumber' },
	'flashintensity' => { 94 => [0x19,0x5], 242 => 0x405 },
	'flashlevel' => { 231 => 0x9, 346 => 0xb048 },
	'flashmake' => { 132 => 'Make' },
	'flashmanufacturer' => { 149 => 'FlashManufacturer' },
	'flashmetering' => { 151 => 0x3f, 154 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 295 => 0x20a },
	'flashmode' => { 94 => 0x4, 115 => 0x5c, 132 => 'Mode', 151 => 0x2, 152 => 0x20, 153 => 0x16, 154 => 0xf, 186 => 0x87, 242 => 0x400, 247 => 0x1004, 295 => 0xc, 301 => 0x4, 316 => 0x20, 317 => 0x100a, 325 => 0x225, 334 => 0x13, 335 => 0x7f, 336 => 0x20, 350 => 0x10, 353 => 0x1138, 354 => 0x1138, 355 => 0x1114, 356 => 0x1190, 357 => 0x116c, 358 => 0x1024, 359 => 0x21c, 392 => [\'Flash','FlashMode'] },
	'flashmodel' => { 132 => 'Model', 149 => 'FlashModel', 243 => 0x1001 },
	'flashoptions' => { 276 => 0x2 },
	'flashoptions2' => { 276 => 0x10 },
	'flashoutput' => { 36 => 0x248, 66 => 0x21, 175 => 0xa, 176 => 0xa, 177 => 0xa },
	'flashpixversion' => { 99 => 0xa000, 392 => 'FlashpixVersion' },
	'flashredeyemode' => { 392 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 242 => 0x403 },
	'flashreturn' => { 392 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 132 => 'SerialNumber', 243 => 0x1003 },
	'flashsetting' => { 186 => 0x8 },
	'flashshutterspeed' => { 229 => '20.2', 230 => '23.2', 235 => '15.2', 236 => '22.2', 237 => '7.2', 238 => '22.2', 239 => '23.2', 240 => '23.1' },
	'flashsource' => { 175 => 0x4, 176 => 0x4, 177 => 0x4 },
	'flashstatus' => { 283 => 0x0, 350 => [0x82,0x86], 360 => 0x31 },
	'flashstatusbuilt-in' => { 336 => [0x87,0x287] },
	'flashstatusexternal' => { 336 => [0x88,0x288] },
	'flashsyncspeed' => { 229 => '20.1', 230 => '23.1', 235 => '15.1', 236 => '22.1', 238 => '22.1', 239 => '23.1' },
	'flashsyncspeedav' => { 70 => 0x3, 72 => 0x10f, 73 => 0x2, 74 => 0x3, 75 => 0x2, 76 => 0x2, 77 => 0x3, 78 => 0x6 },
	'flashthreshold' => { 82 => 0x1 },
	'flashtype' => { 132 => 'Type', 154 => 0x59, 186 => 0x9, 243 => 0x1000 },
	'flashwarning' => { 236 => '30.1', 237 => '7.1', 240 => '31.1', 262 => 0x62 },
	'flexiblespotposition' => { 346 => 0x201d },
	'flickerreduce' => { 325 => 0x218 },
	'fliphorizontal' => { 222 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 66 => 0x15, 99 => 0x829d, 112 => 0xfd04, 115 => 0x1e, 117 => 0xfa23, 119 => 0xf103, 122 => 0x13, 124 => 0x3c, 127 => 0xc, 136 => 'FNumber', 151 => 0xa, 152 => 0x36, 153 => 0x47, 154 => 0x9, 157 => 0x49c7, 295 => 0x13, 323 => 0xa019, 326 => [0x31,0x49], 334 => 0x1, 335 => 0x1, 350 => [0x20,0x22,0x26], 392 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 50 => 0x1, 95 => 0x1d, 99 => 0x920a, 122 => 0x1d, 136 => 'FocalLength', 151 => 0x12, 182 => 0xa, 183 => 0xb, 286 => 0x9, 295 => 0x1d, 317 => 0x1500, 333 => 0xe, 357 => 0x1278, 358 => 0x1134, 359 => 0x32c, 392 => 'FocalLength' },
	'focallength2' => { 350 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 99 => 0xa405, 323 => 0xa01a, 392 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 333 => 0x10 },
	'focalplanediagonal' => { 243 => 0x103, 247 => 0x205 },
	'focalplaneresolutionunit' => { 99 => 0xa210, 392 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 99 => 0xa20e, 392 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 50 => 0x2 },
	'focalplanexunknown' => { 50 => 0x2 },
	'focalplaneyresolution' => { 99 => 0xa20f, 392 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 50 => 0x3 },
	'focalplaneyunknown' => { 50 => 0x3 },
	'focaltype' => { 9 => 0x2d, 50 => 0x0 },
	'focalunits' => { 30 => 0x19 },
	'focus' => { 212 => 0x8 },
	'focusarea' => { 151 => 0x31 },
	'focusareaselection' => { 237 => '15.2' },
	'focuscontinuous' => { 30 => 0x20 },
	'focusdisplayaiservoandmf' => { 72 => 0x515 },
	'focusdistance' => { 136 => 'FocusDistance', 151 => 0x13, 157 => 0x49bb, 182 => 0x9, 183 => 0xa, 245 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 48 => 0x15, 66 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 48 => 0x14, 66 => 0x13 },
	'focusholdbutton' => { 154 => 0x44 },
	'focusinfoversion' => { 245 => 0x0 },
	'focusingscreen' => { 71 => 0x0, 72 => 0x80b, 77 => 0x0 },
	'focuslocked' => { 150 => 0x14 },
	'focusmode' => { 30 => 0x7, 94 => 0x3, 95 => [0x3003,0xd], 104 => 0x1021, 115 => 0x38, 129 => 'FocusMode', 151 => 0x30, 153 => 0xe, 154 => 0xc, 186 => 0x7, 242 => 0x301, 247 => 0x100b, 262 => 0x7, 295 => 0xd, 301 => 0x3, 317 => 0x1006, 327 => [0xb,0x5], 333 => [0x15,0x1d], 334 => 0x4d, 335 => 0x4d, 346 => [0xb042,0xb04e,0x201b], 350 => 0x13, 364 => 0x16 },
	'focusmode2' => { 276 => '3.1', 350 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 231 => '10.1', 331 => 0x14, 332 => 0x15, 334 => 0x10, 335 => 0xf, 336 => 0x6 },
	'focusmodeswitch' => { 154 => 0x58, 334 => 0x2e },
	'focuspixel' => { 104 => 0x1023 },
	'focuspointwrap' => { 229 => '2.2', 230 => '2.2', 235 => '2.2', 236 => '1.2', 239 => '2.2', 240 => '2.5' },
	'focusposition' => { 182 => 0x8, 183 => 0x8, 295 => 0x10, 345 => 0x9bb },
	'focusposition2' => { 350 => [0x29,0x2b,0x2f], 364 => 0x2d, 367 => 0x20 },
	'focusprocess' => { 242 => 0x302 },
	'focusrange' => { 30 => 0x12, 247 => 0x100a },
	'focusrangeindex' => { 286 => '3.1' },
	'focussetting' => { 326 => 0x6 },
	'focusstatus' => { 333 => 0x19, 334 => 0x53, 335 => 0x53 },
	'focusstepcount' => { 245 => 0x301, 247 => 0x100e },
	'focusstepinfinity' => { 245 => 0x303, 247 => 0x103b },
	'focusstepnear' => { 245 => 0x304, 247 => 0x103c },
	'focustrackinglockon' => { 229 => ['1.5','4.1'], 230 => '1.4', 235 => '3.1', 236 => '0.4', 239 => '1.4' },
	'focuswarning' => { 104 => 0x1301 },
	'foldername' => { 151 => 0x27 },
	'foldernumber' => { 334 => 0x9a, 336 => [0x402,0x114,0x316] },
	'fontcomposite' => { 418 => [\'Fonts','FontsComposite'] },
	'fontface' => { 418 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 418 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 418 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 418 => [\'Fonts','FontsFontName'] },
	'fonts' => { 418 => 'Fonts' },
	'fonttype' => { 418 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 418 => [\'Fonts','FontsVersionString'] },
	'for' => { 308 => 'For' },
	'format' => { 389 => 'format', 411 => 'Format' },
	'forwardlock' => { 408 => 'forwardlock' },
	'forwardmatrix1' => { 99 => 0xc714 },
	'forwardmatrix2' => { 99 => 0xc715 },
	'framecount' => { 57 => [0x2,0x4] },
	'frameheight' => { 104 => 0x3822 },
	'framenum' => { 303 => 0xd7 },
	'framenumber' => { 104 => 0x8003, 157 => 0x3c, 295 => 0x29 },
	'framerate' => { 57 => [0x1,0x6], 99 => 0xc764, 104 => 0x3820 },
	'framewidth' => { 104 => 0x3821 },
	'framing' => { 402 => 'framing' },
	'freebytes' => { 85 => 0x1 },
	'freememorycardimages' => { 152 => [0x37,0x54], 153 => [0x2d,0x4a], 154 => 0x32 },
	'fujiflashmode' => { 104 => 0x1010 },
	'fullimagesize' => { 346 => 0xb02b },
	'fullpanoheightpixels' => { 377 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 377 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 317 => 0x100d },
	'fullsizeimage' => { 135 => 'data' },
	'fullsizeimagename' => { 135 => '1Name' },
	'fullsizeimagetype' => { 135 => '0Type' },
	'funcbutton' => { 229 => ['14.1','15.1'], 230 => '14.1', 235 => '28.1', 236 => '13.1', 239 => '14.1', 240 => '14.1' },
	'funcbuttonplusdials' => { 229 => ['14.2','15.2'], 230 => '14.2', 235 => '31.1', 239 => '42.1' },
	'functionbutton' => { 234 => '13.1', 237 => '5.2' },
	'gainbase' => { 246 => 0x610 },
	'gaincontrol' => { 99 => 0xa407, 392 => 'GainControl' },
	'gamma' => { 99 => 0xa500, 393 => 'Gamma' },
	'gammacompensatedvalue' => { 109 => 0x91 },
	'geimagesize' => { 104 => 0x1304 },
	'gemake' => { 105 => 0x300 },
	'gemodel' => { 105 => 0x207 },
	'genre' => { 403 => 'genre', 413 => 'genre' },
	'geography' => { 404 => 'geography' },
	'geologicalcontext' => { 98 => 'GeologicalContext' },
	'geologicalcontextbed' => { 98 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 98 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 98 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 98 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 98 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 100 => 'Geosync' },
	'geotag' => { 100 => 'Geotag' },
	'geotiffasciiparams' => { 99 => 0x87b1 },
	'geotiffdirectory' => { 99 => 0x87af },
	'geotiffdoubleparams' => { 99 => 0x87b0 },
	'geotime' => { 100 => 'Geotime' },
	'globalaltitude' => { 306 => 0x419 },
	'globalangle' => { 306 => 0x40d },
	'good' => { 413 => 'good' },
	'googleplusuploadcode' => { 99 => 0x9009 },
	'gpsaltitude' => { 106 => 0x6, 133 => 'Altitude', 392 => 'GPSAltitude' },
	'gpsaltituderef' => { 106 => 0x5, 392 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 106 => 0x1c, 392 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 106 => 0x1d },
	'gpsdatetime' => { 133 => 'DateTime', 392 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 106 => 0x18, 133 => 'Bearing', 392 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 106 => 0x17, 392 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 106 => 0x1a, 133 => 'Distance', 392 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 106 => 0x19, 392 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 106 => 0x14, 392 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 106 => 0x13 },
	'gpsdestlongitude' => { 106 => 0x16, 392 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 106 => 0x15 },
	'gpsdifferential' => { 106 => 0x1e, 133 => 'Differential', 392 => 'GPSDifferential' },
	'gpsdop' => { 106 => 0xb, 392 => 'GPSDOP' },
	'gpshpositioningerror' => { 106 => 0x1f, 392 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 106 => 0x11, 392 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 106 => 0x10, 392 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 106 => 0x2, 133 => 'Latitude', 392 => 'GPSLatitude' },
	'gpslatituderef' => { 106 => 0x1 },
	'gpslongitude' => { 106 => 0x4, 133 => 'Longitude', 392 => 'GPSLongitude' },
	'gpslongituderef' => { 106 => 0x3 },
	'gpsmapdatum' => { 106 => 0x12, 133 => 'Datum', 392 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 106 => 0xa, 133 => 'MeasureMode', 392 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 106 => 0x1b, 392 => 'GPSProcessingMethod' },
	'gpssatellites' => { 106 => 0x8, 133 => 'Satellites', 392 => 'GPSSatellites' },
	'gpsspeed' => { 106 => 0xd, 133 => 'Speed', 392 => 'GPSSpeed' },
	'gpsspeedref' => { 106 => 0xc, 392 => 'GPSSpeedRef' },
	'gpsstatus' => { 106 => 0x9, 392 => 'GPSStatus' },
	'gpstimestamp' => { 106 => 0x7 },
	'gpstrack' => { 106 => 0xf, 133 => 'Heading', 392 => 'GPSTrack' },
	'gpstrackref' => { 106 => 0xe, 392 => 'GPSTrackRef' },
	'gpsversionid' => { 106 => 0x0, 392 => 'GPSVersionID' },
	'gradation' => { 242 => 0x50f },
	'gradientbasedcorractive' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 388 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 388 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 388 => 'GrainAmount' },
	'grainfrequency' => { 388 => 'GrainFrequency' },
	'grainsize' => { 388 => 'GrainSize' },
	'graymixeraqua' => { 388 => 'GrayMixerAqua' },
	'graymixerblue' => { 388 => 'GrayMixerBlue' },
	'graymixergreen' => { 388 => 'GrayMixerGreen' },
	'graymixermagenta' => { 388 => 'GrayMixerMagenta' },
	'graymixerorange' => { 388 => 'GrayMixerOrange' },
	'graymixerpurple' => { 388 => 'GrayMixerPurple' },
	'graymixerred' => { 388 => 'GrayMixerRed' },
	'graymixeryellow' => { 388 => 'GrayMixerYellow' },
	'graypoint' => { 373 => 0x8021 },
	'grayresponseunit' => { 99 => 0x122 },
	'greencurvelimits' => { 90 => 0x1c4 },
	'greencurvepoints' => { 90 => 0x19a },
	'greenhue' => { 388 => 'GreenHue' },
	'greensaturation' => { 388 => 'GreenSaturation' },
	'griddisplay' => { 229 => '13.3', 230 => '4.3', 232 => '2.2', 235 => '10.5', 236 => '3.4', 237 => '6.1', 239 => '4.4', 240 => '4.2' },
	'gripbatteryadload' => { 274 => 0x5 },
	'gripbatteryadnoload' => { 274 => 0x4 },
	'gripbatterystate' => { 274 => '1.2' },
	'groupareaafillumination' => { 230 => '46.4', 239 => '47.4' },
	'halftonehints' => { 99 => 0x141 },
	'hardlink' => { 100 => 'HardLink' },
	'hasalternative' => { 403 => 'hasAlternative' },
	'hascorrection' => { 403 => 'hasCorrection' },
	'hascorrectiona-lang' => { 403 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 403 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 403 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 388 => 'HasCrop' },
	'hasextendedxmp' => { 415 => 'HasExtendedXMP' },
	'hassettings' => { 388 => 'HasSettings' },
	'hastranslation' => { 403 => 'hasTranslation' },
	'hdr' => { 51 => 0x1, 179 => 0x4, 262 => 0x9e, 295 => 0x85, 346 => 0x200a },
	'hdreffect' => { 51 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 179 => 0x0 },
	'hdrlevel' => { 179 => 0x5, 336 => 0x2e, 350 => 0x17 },
	'hdrlevel2' => { 179 => 0x7 },
	'hdrsetting' => { 336 => 0x2d, 350 => 0x16, 353 => 0x1148, 354 => 0x1148, 355 => 0x1124, 356 => 0x11a0, 357 => 0x117c, 358 => 0x1034, 359 => 0x22c },
	'hdrsmoothing' => { 179 => 0x6 },
	'headline' => { 107 => 0x69, 400 => 'Headline' },
	'hierarchicalkeywords' => { 144 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 144 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 144 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 144 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 144 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 144 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 144 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 379 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 98 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 266 => 0x1a },
	'highisomultipliergreen' => { 266 => 0x19 },
	'highisomultiplierred' => { 266 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 53 => 0x5, 72 => 0x202, 104 => 0x100e, 186 => 0xb1, 295 => 0x71, 334 => 0x2c, 335 => 0x26, 336 => 0x26, 346 => 0x2009, 350 => 0x12, 369 => 0x42 },
	'highisonoisereduction2' => { 346 => 0xb050 },
	'highlight' => { 326 => 0xf },
	'highlightcolordistortreduct' => { 373 => 0x8026 },
	'highlightprotection' => { 221 => 0x6 },
	'highlightrecovery' => { 388 => 'HighlightRecovery' },
	'highlights' => { 381 => 'Highlights' },
	'highlights2012' => { 388 => 'Highlights2012' },
	'highlighttone' => { 104 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 53 => 0x3, 72 => 0x203 },
	'highlowkeyadj' => { 295 => 0x6c },
	'highspeedsync' => { 154 => 0x5, 334 => 0x2, 335 => 0x2 },
	'histogramxml' => { 222 => 0x83a1a25 },
	'history' => { 400 => 'History', 414 => 'History' },
	'historyaction' => { 414 => [\'History','HistoryAction'] },
	'historychanged' => { 414 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 414 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 414 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 414 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 414 => [\'History','HistoryWhen'] },
	'hometowncity' => { 95 => 0x3006, 295 => 0x23, 300 => 0x2 },
	'hometowncitycode' => { 301 => 0x1000 },
	'hometowndst' => { 295 => 0x25, 300 => '0.2' },
	'hostcomputer' => { 99 => 0x13c },
	'hue' => { 159 => 0x3b, 295 => 0x67 },
	'hueadj' => { 225 => 0x2f, 373 => 0x8019 },
	'hueadjust' => { 317 => 0x1016 },
	'hueadjustment' => { 152 => 0x4a, 153 => 0x40, 186 => 0x92, 188 => 0x36 },
	'hueadjustmentaqua' => { 388 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 388 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 388 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 388 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 388 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 388 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 388 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 388 => 'HueAdjustmentYellow' },
	'huesetting' => { 250 => 0x1011 },
	'icc_profile' => { 100 => 'ICC_Profile' },
	'iccprofilename' => { 400 => 'ICCProfile' },
	'idccreativestyle' => { 373 => 0x8000 },
	'idcpreviewlength' => { 373 => 0x202 },
	'idcpreviewstart' => { 373 => 0x201 },
	'identification' => { 98 => 'Identification' },
	'identificationid' => { 98 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 98 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 98 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 98 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 98 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 98 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 389 => 'identifier', 411 => 'Identifier' },
	'illumination' => { 237 => '0.5' },
	'imageadjustment' => { 186 => 0x80, 212 => 0x5 },
	'imagealterationconstraints' => { 401 => 'ImageAlterationConstraints' },
	'imagearea' => { 197 => 0x10, 200 => 0x10 },
	'imageareaoffset' => { 295 => 0x38 },
	'imageauthentication' => { 186 => 0x20 },
	'imageboundary' => { 186 => 0x16 },
	'imagecount' => { 186 => 0xa5, 348 => 0x11b, 360 => 0x32 },
	'imagecount2' => { 360 => 0x4c },
	'imagecount3' => { 360 => [0x1a0,0x1aa,0x1bd] },
	'imagecreator' => { 401 => 'ImageCreator' },
	'imagecreatorid' => { 401 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 401 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 401 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 186 => 0xa2 },
	'imagedescription' => { 99 => 0x10e, 409 => 'ImageDescription' },
	'imageduplicationconstraints' => { 401 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 222 => 0xfe443a45 },
	'imageeditcount' => { 295 => 0x41 },
	'imageediting' => { 295 => 0x32 },
	'imageeffects' => { 317 => 0x1010 },
	'imagefileconstraints' => { 401 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 401 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 401 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 104 => 0x1436 },
	'imageheight' => { 99 => 0x101, 158 => 0xc, 409 => 'ImageLength' },
	'imagehistory' => { 99 => 0x9213 },
	'imageidnumber' => { 258 => 0x340 },
	'imagenumber' => { 99 => 0x9211, 129 => 'ImageNumber', 152 => 0xae, 153 => 0x5e, 334 => 0x9b, 336 => [0x400,'276.1',0x314], 384 => 'ImageNumber' },
	'imagenumber2' => { 153 => 0x62 },
	'imageoptimization' => { 186 => 0xa9 },
	'imageorientation' => { 107 => 0x83 },
	'imageprocessing' => { 186 => 0x1a },
	'imageprocessingversion' => { 246 => 0x0 },
	'imagequality' => { 129 => 'ImageQuality', 199 => '723.2', 200 => '732.2', 208 => '708.1', 262 => 0x1 },
	'imagequality2' => { 242 => 0x603 },
	'imageref' => { 396 => 'ImageRef' },
	'imagereview' => { 231 => '0.4', 237 => '0.4' },
	'imagereviewmonitorofftime' => { 230 => '21.1', 239 => '21.1' },
	'imagereviewtime' => { 229 => '25.1', 231 => '2.1', 232 => '19.1', 233 => '20.1', 234 => '20.1', 235 => '9.2', 236 => '20.1', 240 => '21.2' },
	'imagesize' => { 135 => 'ImageSize' },
	'imagesizerestriction' => { 406 => 'imageSizeRestriction' },
	'imagesourcedata' => { 99 => 0x935c },
	'imagestabilization' => { 30 => 0x22, 95 => 0x3020, 104 => 0x1422, 129 => 'ImageStabilization', 152 => 0xbd, 153 => 0x71, 154 => 0x57, 155 => 0x0, 156 => [0x18,0x107,0x113], 157 => 0x49c2, 186 => 0xac, 242 => 0x604, 245 => 0x1600, 262 => 0x1a, 339 => 0x12, 340 => 0x11, 346 => 0xb026 },
	'imagestabilization2' => { 338 => 0xa },
	'imagestabilizationsetting' => { 157 => 0x14, 334 => 0x3d, 335 => 0x3d, 345 => 0x14 },
	'imagestyle' => { 334 => 0x2d, 335 => 0x27 },
	'imagesupplier' => { 401 => 'ImageSupplier' },
	'imagesupplierid' => { 401 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 401 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 401 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 101 => 0x1 },
	'imagetemperaturemin' => { 101 => 0x2 },
	'imagetone' => { 295 => 0x4f },
	'imagetype' => { 107 => 0x82, 401 => 'ImageType' },
	'imageuniqueid' => { 54 => 0x28, 99 => 0xa420, 392 => 'ImageUniqueID' },
	'imagewidth' => { 99 => 0x100, 158 => 0xe, 409 => 'ImageWidth' },
	'incrementaltemperature' => { 388 => 'IncrementalTemperature' },
	'incrementaltint' => { 388 => 'IncrementalTint' },
	'industry' => { 403 => 'industry', 404 => 'industry' },
	'infobuttonwhenshooting' => { 72 => 0x409 },
	'infraredilluminator' => { 313 => 0x28 },
	'ingredientexclusion' => { 405 => 'ingredientExclusion' },
	'ingredients' => { 414 => 'Ingredients' },
	'ingredientsalternatepaths' => { 414 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 414 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 414 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 414 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 414 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 414 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 414 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 414 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 414 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 414 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 414 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 414 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 414 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 414 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 414 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 414 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 414 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 377 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 377 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 377 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 377 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 229 => '4.4' },
	'initialzoomsetting' => { 229 => '9.3', 235 => '27.3' },
	'inkset' => { 99 => 0x14c },
	'inputprofile' => { 113 => 0x1389 },
	'instanceid' => { 414 => 'InstanceID' },
	'instantplaybacksetup' => { 154 => 0x3e },
	'instantplaybacktime' => { 154 => 0x3d },
	'instructions' => { 400 => 'Instructions' },
	'instrument' => { 413 => 'instrument' },
	'intellectualgenre' => { 397 => 'IntellectualGenre' },
	'intelligentauto' => { 346 => 0xb052 },
	'intelligentcontrast' => { 43 => 0x4 },
	'intelligentd-range' => { 262 => 0x79 },
	'intelligentexposure' => { 262 => 0x5d },
	'intelligentresolution' => { 262 => 0x70 },
	'interchangecolorspace' => { 109 => 0x40 },
	'internalflash' => { 151 => 0x2b, 229 => '23.1', 231 => '8.1', 232 => '22.1', 234 => '23.1', 237 => '8.1', 240 => '24.1', 245 => 0x1208 },
	'internalflashae1' => { 247 => 0x1021 },
	'internalflashae1_0' => { 247 => 0x101d },
	'internalflashae2' => { 247 => 0x1022 },
	'internalflashae2_0' => { 247 => 0x101e },
	'internalflashmode' => { 283 => 0x1 },
	'internalflashstrength' => { 283 => 0x3 },
	'internalflashtable' => { 247 => 0x1024 },
	'internallensserialnumber' => { 323 => 0xa005 },
	'internalndfilter' => { 262 => 0x9d },
	'internalserialnumber' => { 54 => 0x96, 65 => 0x9, 104 => 0x10, 157 => 0x49dc, 241 => 0x18, 243 => 0x102, 262 => 0x25, 275 => 0x4, 317 => 0x5, 360 => [0x7c,0xf0] },
	'interopindex' => { 99 => 0x1, 393 => 'InteroperabilityIndex' },
	'interopversion' => { 99 => 0x2 },
	'intervallength' => { 151 => 0x10 },
	'intervalmode' => { 151 => 0x26 },
	'intervalnumber' => { 151 => 0x11 },
	'introtime' => { 413 => 'introTime' },
	'introtimescale' => { 413 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 413 => [\'introTime','introTimeValue'] },
	'iptc' => { 100 => 'IPTC' },
	'iptc-naa' => { 99 => 0x83bb, 266 => 0x83bb },
	'iptcbitspersample' => { 109 => 0x56 },
	'iptcdigest' => { 306 => 0x425 },
	'iptcimageheight' => { 109 => 0x1e },
	'iptcimagerotation' => { 109 => 0x66 },
	'iptcimagewidth' => { 109 => 0x14 },
	'iptclastedited' => { 398 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 109 => 0xa },
	'iptcpixelheight' => { 109 => 0x32 },
	'iptcpixelwidth' => { 109 => 0x28 },
	'isalternativeof' => { 403 => 'isAlternativeOf' },
	'isbn' => { 403 => 'isbn' },
	'iscorrectionof' => { 403 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 91 => 0x3 },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 94 => 0x14, 95 => [0x3014,0x14], 99 => 0x8827, 112 => 0xfd06, 113 => 0x1784, 115 => 0x60, 117 => [0xfa2e,0xfa46], 118 => [0x27,0x28], 119 => 0xf105, 122 => 0x14, 124 => 0x4e, 127 => 0x34, 129 => 'ISO', 151 => 0x8, 157 => 0x49ba, 180 => 0x0, 186 => 0x2, 266 => 0x17, 295 => [0x8b,0x14], 301 => 0x14, 323 => 0xa014, 345 => 0x6f, 350 => [0x1f,0x21,0x25], 392 => 'ISOSpeedRatings' },
	'iso2' => { 180 => 0x6, 194 => 0x265, 195 => 0x25c, 196 => 0x265, 197 => 0x221, 198 => 0x25d, 199 => 0x256, 200 => 0x25d, 203 => 0x2b5, 206 => 0x265, 211 => 0x2b5 },
	'isoauto' => { 276 => '14.4' },
	'isoautoparameters' => { 295 => 0x7a },
	'isodisplay' => { 232 => '2.3', 233 => '3.3', 234 => '3.3', 236 => '3.3', 239 => '4.3', 240 => '4.3' },
	'isoexpansion' => { 72 => 0x103, 73 => 0x7, 74 => 0x8, 77 => 0x8, 180 => 0x4 },
	'isoexpansion2' => { 180 => 0xa },
	'isofloor' => { 276 => 0x6 },
	'isoselection' => { 186 => 0xf },
	'isosensitivitystep' => { 236 => '6.2' },
	'isosetting' => { 115 => 0x5e, 129 => 'ISOSetting', 151 => 0x24, 152 => 0x26, 153 => 0x1c, 154 => 0x13, 159 => 0x6, 186 => 0x13, 276 => '17.3', 316 => 0x27, 334 => 0x16, 335 => 0x14, 336 => 0x2, 345 => 0x6d },
	'isospeed' => { 99 => 0x8833, 393 => 'ISOSpeed' },
	'isospeedexpansion' => { 71 => 0x3 },
	'isospeedincrements' => { 72 => 0x102 },
	'isospeedlatitudeyyy' => { 99 => 0x8834, 393 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 99 => 0x8835, 393 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 72 => 0x103 },
	'isostepsize' => { 229 => '6.1', 230 => '7.2', 235 => '4.1', 239 => '7.2' },
	'isovalue' => { 247 => 0x1001 },
	'issn' => { 403 => 'issn' },
	'issueidentifier' => { 403 => 'issueIdentifier' },
	'issuename' => { 403 => 'issueName' },
	'issueteaser' => { 403 => 'issueTeaser' },
	'issuetype' => { 403 => 'issueType' },
	'istranslationof' => { 403 => 'isTranslationOf' },
	'jobid' => { 107 => 0xb8 },
	'jobname' => { 394 => 'JobName' },
	'jobref' => { 412 => 'JobRef' },
	'jobrefid' => { 412 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 412 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 412 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 394 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 264 => 0x3034, 346 => 0xb047 },
	'jpegsize' => { 264 => 0x303a },
	'jpgfromraw' => { 85 => 0x2007, 96 => 'JpgFromRaw', 266 => 0x2e },
	'jpgfromrawlength' => { 99 => [0x117,0x202] },
	'jpgfromrawstart' => { 99 => [0x111,0x201] },
	'jpgrecordedpixels' => { 276 => '14.1' },
	'jurisdiction' => { 385 => 'jurisdiction' },
	'kelvinwb_01' => { 284 => 0x5 },
	'kelvinwb_02' => { 284 => 0x9 },
	'kelvinwb_03' => { 284 => 0xd },
	'kelvinwb_04' => { 284 => 0x11 },
	'kelvinwb_05' => { 284 => 0x15 },
	'kelvinwb_06' => { 284 => 0x19 },
	'kelvinwb_07' => { 284 => 0x1d },
	'kelvinwb_08' => { 284 => 0x21 },
	'kelvinwb_09' => { 284 => 0x25 },
	'kelvinwb_10' => { 284 => 0x29 },
	'kelvinwb_11' => { 284 => 0x2d },
	'kelvinwb_12' => { 284 => 0x31 },
	'kelvinwb_13' => { 284 => 0x35 },
	'kelvinwb_14' => { 284 => 0x39 },
	'kelvinwb_15' => { 284 => 0x3d },
	'kelvinwb_16' => { 284 => 0x41 },
	'kelvinwb_daylight' => { 284 => 0x1 },
	'key' => { 413 => 'key' },
	'keyword' => { 403 => 'keyword' },
	'keywordinfo' => { 144 => 'Keywords' },
	'keywords' => { 107 => 0x19, 130 => 'Keywords', 251 => 'Keywords', 308 => 'Keywords', 382 => 'keywords', 399 => 'Keywords', 411 => 'Keywords' },
	'killdate' => { 403 => 'killDate' },
	'killdatea-platform' => { 403 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 403 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 112 => 0xf908, 115 => 0xe, 117 => [0xfa1e,0xfa52], 123 => 0x70 },
	'kodakimagewidth' => { 112 => 0xf907, 115 => 0xc, 117 => [0xfa1d,0xfa51], 123 => 0x6c },
	'kodakinfotype' => { 112 => 0xfa00 },
	'kodaklook' => { 113 => 0xe4c },
	'kodaklookprofile' => { 113 => 0x138a },
	'kodakmaker' => { 123 => 0x8 },
	'kodakmodel' => { 115 => 0x0, 123 => 0x28 },
	'label' => { 254 => 'Label', 411 => 'Label' },
	'labelname1' => { 396 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 396 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 262 => 0x6f },
	'landscapeoutputhighlightpoint' => { 91 => 0x26 },
	'landscapeoutputshadowpoint' => { 91 => 0x27 },
	'landscaperawcolortone' => { 91 => 0x1f },
	'landscaperawcontrast' => { 91 => 0x21 },
	'landscaperawhighlight' => { 91 => 0x77 },
	'landscaperawhighlightpoint' => { 91 => 0x24 },
	'landscaperawlinear' => { 91 => 0x22 },
	'landscaperawsaturation' => { 91 => 0x20 },
	'landscaperawshadow' => { 91 => 0x80 },
	'landscaperawshadowpoint' => { 91 => 0x25 },
	'landscaperawsharpness' => { 91 => 0x23 },
	'landscapeunsharpmaskfineness' => { 91 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 91 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 91 => 0xa2 },
	'language' => { 389 => 'language' },
	'languageidentifier' => { 107 => 0x87 },
	'largestvalidinteriorrectheight' => { 377 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 377 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 377 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 377 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 151 => 0x1b },
	'lastkeywordiptc' => { 149 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 149 => 'LastKeywordXMP' },
	'lastphotodate' => { 377 => 'LastPhotoDate' },
	'lasturl' => { 414 => 'LastURL' },
	'lateralchromaticaberration' => { 346 => 0x2012 },
	'latestageorhigheststage' => { 98 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 98 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 98 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 98 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 98 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 286 => 0x2 },
	'lc10' => { 286 => 0xb },
	'lc11' => { 286 => 0xc },
	'lc12' => { 286 => 0xd },
	'lc14' => { 286 => 0xf },
	'lc15' => { 286 => 0x10 },
	'lc3' => { 286 => 0x4 },
	'lc4' => { 286 => 0x5 },
	'lc5' => { 286 => 0x6 },
	'lc6' => { 286 => 0x7 },
	'lc7' => { 286 => 0x8 },
	'lcddisplayatpoweron' => { 72 => 0x811, 76 => 0xa },
	'lcddisplayreturntoshoot' => { 77 => 0x12 },
	'lcdillumination' => { 229 => '17.5', 230 => '5.2', 235 => '10.3', 236 => '4.2', 239 => '5.2', 240 => '5.4' },
	'lcdilluminationduringbulb' => { 72 => 0x408 },
	'lcdpanels' => { 71 => 0x8 },
	'lcheditor' => { 222 => 0x8ae85e },
	'legacyiptcdigest' => { 400 => 'LegacyIPTCDigest' },
	'legalcode' => { 385 => 'legalcode' },
	'lens' => { 99 => 0xfdea, 186 => 0x84, 384 => 'Lens' },
	'lensafstopbutton' => { 70 => 0x11, 71 => 0x13, 72 => 0x506, 73 => 0x10, 74 => 0x12, 77 => 0x13, 78 => 0x9 },
	'lensaperturerange' => { 326 => [0x30,0x48] },
	'lensdistortionparams' => { 247 => 0x206 },
	'lensdrivenoaf' => { 72 => 0x505 },
	'lensfirmware' => { 318 => 0x20, 323 => 0xa004 },
	'lensfirmwareversion' => { 243 => 0x204, 262 => 0x60 },
	'lensfocalrange' => { 326 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 230 => '55.1', 239 => '52.1' },
	'lensformat' => { 357 => 0x1891, 359 => 0x18bd, 360 => 0x106, 368 => 0x603, 369 => 0x5d },
	'lensfstops' => { 181 => 0x7, 182 => 0xc, 183 => 0xd, 186 => 0x8b, 286 => '0.3' },
	'lensid' => { 384 => 'LensID' },
	'lensidnumber' => { 181 => 0x6, 182 => 0xb, 183 => 0xc },
	'lensinfo' => { 99 => 0xa432, 292 => 0x2a, 384 => 'LensInfo', 393 => 'LensSpecification' },
	'lenskind' => { 286 => 0x1 },
	'lensmake' => { 99 => 0xa433, 136 => 'Make', 393 => 'LensMake' },
	'lensmanualdistortionamount' => { 388 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 149 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 326 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 54 => 0x95, 99 => 0xa434, 136 => 'Model', 149 => 'LensModel', 184 => 0x18a, 243 => 0x203, 260 => 0x303, 292 => 0xc, 393 => 'LensModel' },
	'lensmount' => { 336 => 0x99, 357 => 0x1892, 359 => 0x18be, 360 => 0x105, 368 => 0x604, 369 => 0x5e, 372 => 0x8 },
	'lensparameters' => { 354 => 0x1a23, 357 => 0x1870, 359 => 0x189c, 368 => 0x6ca, 369 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 388 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 388 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 388 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 388 => 'LensProfileEnable' },
	'lensprofilefilename' => { 388 => 'LensProfileFilename' },
	'lensprofilename' => { 388 => 'LensProfileName' },
	'lensprofilesetup' => { 388 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 388 => 'LensProfileVignettingScale' },
	'lensproperties' => { 243 => 0x20b },
	'lensserialnumber' => { 52 => 0x0, 99 => 0xa435, 136 => 'SerialNumber', 243 => 0x202, 262 => 0x52, 318 => 0x30, 384 => 'LensSerialNumber', 393 => 'LensSerialNumber' },
	'lensshutterlock' => { 154 => 0x4a },
	'lensspec' => { 331 => 0x0, 332 => 0x0, 333 => 0x0, 346 => 0xb02a },
	'lensspecfeatures' => { 360 => [0x115,0x116] },
	'lenstemperature' => { 247 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 30 => 0x16, 156 => 0x10c, 157 => 0x49bd, 186 => 0x83, 243 => 0x201, 255 => 0x16, 258 => 0x310, 261 => 0x303, 262 => 0x51, 264 => 0x3405, 287 => 0x0, 288 => 0x0, 289 => 0x1, 290 => 0x1, 291 => 0x1, 293 => 0x0, 323 => 0xa003, 326 => 0x27, 346 => 0xb027, 357 => 0x1896, 359 => 0x18c2, 360 => 0x109, 368 => 0x608, 369 => 0x62 },
	'lenstype2' => { 336 => 0x3f7, 357 => 0x1893, 359 => 0x18bf, 360 => 0x107, 368 => 0x605, 369 => 0x60, 372 => 0x9 },
	'lenszoomposition' => { 366 => 0x19, 367 => 0x1e, 369 => 0x342 },
	'levelindicator' => { 269 => 0x15 },
	'levelorientation' => { 294 => 0x0 },
	'license' => { 385 => 'license' },
	'licensee' => { 401 => 'Licensee' },
	'licenseeid' => { 401 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 401 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 401 => 'LicenseeImageNotes' },
	'licenseename' => { 401 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 401 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 401 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 401 => 'LicenseeTransactionID' },
	'licenseid' => { 401 => 'LicenseID' },
	'licensestartdate' => { 401 => 'LicenseStartDate' },
	'licensetransactiondate' => { 401 => 'LicenseTransactionDate' },
	'licensetype' => { 390 => 'licensetype' },
	'licensor' => { 401 => 'Licensor' },
	'licensorcity' => { 401 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 401 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 401 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 401 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 401 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 401 => 'LicensorImageID' },
	'licensorname' => { 401 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 401 => 'LicensorNotes' },
	'licensorpostalcode' => { 401 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 401 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 401 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 401 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 401 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 401 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 401 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 401 => 'LicensorTransactionID' },
	'licensorurl' => { 401 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 247 => 0x1009 },
	'lightingmode' => { 95 => 0x302a },
	'lightreading' => { 295 => 0x15 },
	'lightsource' => { 99 => 0x9208, 186 => 0x90, 250 => 0x1000, 392 => 'LightSource' },
	'lightsourcespecial' => { 325 => 0x21d },
	'lightswitch' => { 239 => '0.1', 240 => '0.1' },
	'lightvaluecenter' => { 247 => 0x103d },
	'lightvalueperiphery' => { 247 => 0x103e },
	'limitafareamodeselection' => { 230 => '51.1', 239 => '49.1' },
	'linearitylimitblue' => { 266 => 0x10 },
	'linearitylimitgreen' => { 266 => 0xf },
	'linearitylimitred' => { 266 => 0xe },
	'linearityuppermargin' => { 37 => [0x2ba,0x2d1,0x2d5], 39 => 0x1e5, 40 => [0x1fe,0x2de], 41 => 0x310 },
	'linearizationtable' => { 99 => 0xc618 },
	'linearresponselimit' => { 99 => 0xc62e },
	'link' => { 403 => 'link' },
	'linkaetoafpoint' => { 276 => '14.2' },
	'linkedencodedrightsexpr' => { 398 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 398 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 398 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 398 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 98 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 232 => '32.1', 240 => '34.1' },
	'liveviewafareamode' => { 236 => '34.1' },
	'liveviewafmethod' => { 350 => 0x20 },
	'liveviewafmode' => { 236 => '34.2' },
	'liveviewafsetting' => { 336 => 0x36 },
	'liveviewbuttonoptions' => { 230 => '50.2', 239 => '48.2' },
	'liveviewexposuresimulation' => { 72 => 0x810 },
	'liveviewfocusmode' => { 336 => [0x8b,0x28b] },
	'liveviewmetering' => { 336 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 230 => '21.2', 233 => '20.2', 234 => '20.2', 236 => '20.2', 239 => '21.2' },
	'liveviewshooting' => { 48 => 0x13 },
	'localcaption' => { 107 => 0x79 },
	'localizedcameramodel' => { 99 => 0xc615 },
	'locallocationname' => { 323 => 0x30 },
	'location' => { 185 => 0x9, 262 => 0x67, 380 => 'Location', 397 => 'Location', 402 => 'location', 403 => 'location' },
	'locationareacode' => { 386 => 'lac' },
	'locationcreated' => { 398 => 'LocationCreated' },
	'locationcreatedcity' => { 398 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 398 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 398 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 398 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 398 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 398 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 398 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 185 => 0x0 },
	'locationname' => { 323 => 0x31 },
	'locationshown' => { 398 => 'LocationShown' },
	'locationshowncity' => { 398 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 398 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 398 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 398 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 398 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 398 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 398 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 72 => 0x709 },
	'logcomment' => { 413 => 'logComment' },
	'longexposurenoisereduction' => { 53 => 0x4, 72 => 0x201, 73 => 0x1, 74 => 0x2, 75 => 0x1, 76 => 0x1, 77 => 0x2, 78 => 0x1, 262 => 0x49, 334 => 0x2b, 335 => 0x25, 336 => 0x25, 346 => 0x2008, 350 => 0x11, 369 => 0x44 },
	'longexposurenoisereduction2' => { 48 => 0x8 },
	'loop' => { 413 => 'loop' },
	'lowestbiostratigraphiczone' => { 98 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 388 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 388 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 388 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 388 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 388 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 388 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 388 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 388 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 90 => 0x150 },
	'luminancecurvepoints' => { 90 => 0x126 },
	'luminancenoisereduction' => { 91 => 0x5f, 326 => 0x1b },
	'luminancenoisereductioncontrast' => { 388 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 388 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 91 => 0x6d },
	'luminancesmoothing' => { 388 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 72 => 0x40b },
	'lyrics' => { 413 => 'lyrics' },
	'm16cversion' => { 258 => 0x333 },
	'macatom' => { 387 => 'macAtom' },
	'macatomapplicationcode' => { 387 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 387 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 387 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 104 => 0x1020, 105 => 0x202, 247 => 0x202, 316 => 0x21, 325 => 0x202, 346 => 0xb040 },
	'macroled' => { 245 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 48 => 0x10 },
	'macromode' => { 30 => 0x1, 151 => 0xb, 242 => 0x300, 262 => 0x1c, 317 => 0x1009 },
	'magicfilter' => { 242 => 0x52c },
	'magnifiedview' => { 74 => 0x11, 76 => 0x9 },
	'maindialexposurecomp' => { 237 => '0.6' },
	'mainingredient' => { 405 => 'mainIngredient' },
	'make' => { 86 => 0x0, 99 => 0x10f, 129 => 'Make', 254 => 'Make', 266 => 0x10f, 402 => 'make', 409 => 'Make' },
	'makernote' => { 392 => 'MakerNote' },
	'makernoteapple' => { 97 => 'MakN', 99 => 0x927c },
	'makernotecanon' => { 97 => 'MakN', 99 => 0x927c },
	'makernotecasio' => { 97 => 'MakN', 99 => 0x927c },
	'makernotecasio2' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteflir' => { 97 => 'MakN', 99 => 0x927c },
	'makernotefujifilm' => { 97 => 'MakN', 99 => 0x927c },
	'makernotege' => { 97 => 'MakN', 99 => 0x927c },
	'makernotege2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotehasselblad' => { 97 => 'MakN', 99 => 0x927c },
	'makernotehp' => { 97 => 'MakN', 99 => 0x927c },
	'makernotehp2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotehp4' => { 97 => 'MakN', 99 => 0x927c },
	'makernotehp6' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteisl' => { 97 => 'MakN', 99 => 0x927c },
	'makernotejvc' => { 97 => 'MakN', 99 => 0x927c },
	'makernotejvctext' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak10' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak11' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak1a' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak1b' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak3' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak4' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak5' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak6a' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak6b' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak7' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak8a' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak8b' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak8c' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodak9' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekodakunknown' => { 97 => 'MakN', 99 => 0x927c },
	'makernotekyocera' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica2' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica3' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica4' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica5' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica6' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteleica7' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteminolta' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteminolta2' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteminolta3' => { 97 => 'MakN', 99 => 0x927c },
	'makernotenikon' => { 97 => 'MakN', 99 => 0x927c },
	'makernotenikon2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotenikon3' => { 97 => 'MakN', 99 => 0x927c },
	'makernotenintendo' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteoffset' => { 325 => 0xff },
	'makernoteolympus' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteolympus2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepanasonic' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepanasonic2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax3' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax4' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax5' => { 97 => 'MakN', 99 => 0x927c },
	'makernotepentax6' => { 97 => 'MakN', 99 => 0x927c },
	'makernotephaseone' => { 97 => 'MakN', 99 => 0x927c },
	'makernotereconyx' => { 97 => 'MakN', 99 => 0x927c },
	'makernotericoh' => { 97 => 'MakN', 99 => 0x927c },
	'makernotericoh2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotericohtext' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesafety' => { 99 => 0xc635 },
	'makernotesamsung1a' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesamsung1b' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesamsung2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesanyo' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesanyoc4' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesanyopatch' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesigma' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesony' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesony2' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesony3' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesony4' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesony5' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesonyericsson' => { 97 => 'MakN', 99 => 0x927c },
	'makernotesonysrf' => { 97 => 'MakN', 99 => 0x927c },
	'makernotetype' => { 317 => 0x1 },
	'makernoteunknown' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteunknownbinary' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteunknowntext' => { 97 => 'MakN', 99 => 0x927c },
	'makernoteversion' => { 156 => 0x0, 186 => 0x1, 247 => 0x0, 262 => 0x8000, 321 => 0x0, 323 => 0x1, 326 => [0x1d,0x1f], 337 => 0x2000 },
	'managedfrom' => { 414 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 414 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 414 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 414 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 414 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 414 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 414 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 414 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 414 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 414 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 414 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 414 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 414 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 414 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 414 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 414 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 414 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 414 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 414 => 'Manager' },
	'managervariant' => { 414 => 'ManagerVariant' },
	'manageto' => { 414 => 'ManageTo' },
	'manageui' => { 414 => 'ManageUI' },
	'manifest' => { 414 => 'Manifest' },
	'manifestlinkform' => { 414 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 414 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 414 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 414 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 414 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 414 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 414 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 414 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 414 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 414 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 414 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 414 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 414 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 414 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 414 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 414 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 414 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 414 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 414 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 414 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 414 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 414 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 242 => 0x900, 262 => 0x86 },
	'manometerreading' => { 242 => 0x901 },
	'manualafpointselectpattern' => { 72 => 0x513 },
	'manualflash' => { 245 => 0x1209 },
	'manualflashoutput' => { 30 => 0x29, 231 => '8.2', 232 => '22.2', 233 => '23.1', 234 => '23.2', 235 => '16.2', 236 => '23.2', 237 => '8.2', 238 => '23.2', 240 => '24.2', 317 => 0x100c },
	'manualflashstrength' => { 242 => 0x406 },
	'manualfocusdistance' => { 186 => 0x85, 247 => 0x100c, 325 => 0x223 },
	'manualtv' => { 71 => 0x5, 72 => 0x705 },
	'manufacturedate' => { 275 => 0x1 },
	'manufacturedate1' => { 319 => 0x4 },
	'manufacturedate2' => { 319 => 0x5 },
	'manufacturer' => { 402 => 'manufacturer' },
	'marked' => { 399 => 'Marked', 417 => 'Marked' },
	'markers' => { 413 => 'markers' },
	'markerscomment' => { 413 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 413 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 413 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 413 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 413 => [\'markers','markersCuePointType'] },
	'markersduration' => { 413 => [\'markers','markersDuration'] },
	'markerslocation' => { 413 => [\'markers','markersLocation'] },
	'markersname' => { 413 => [\'markers','markersName'] },
	'markersprobability' => { 413 => [\'markers','markersProbability'] },
	'markersspeaker' => { 413 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 413 => [\'markers','markersStartTime'] },
	'markerstarget' => { 413 => [\'markers','markersTarget'] },
	'markerstype' => { 413 => [\'markers','markersType'] },
	'maskedareas' => { 99 => 0xc68e },
	'masterdocumentid' => { 107 => 0xb9 },
	'mastergain' => { 192 => 0x50 },
	'matrixmetering' => { 230 => '50.1', 239 => '48.1' },
	'maxaperture' => { 30 => 0x1a, 119 => 0x6103, 136 => 'MaxAperture', 151 => 0x17, 157 => 0x49c5, 243 => 0x20a, 286 => '14.1', 360 => 0x0 },
	'maxapertureatmaxfocal' => { 104 => 0x1407, 136 => 'MaxApertureAtMaxFocal', 181 => 0xb, 182 => 0x10, 183 => 0x11, 243 => 0x206 },
	'maxapertureatminfocal' => { 104 => 0x1406, 181 => 0xa, 182 => 0xf, 183 => 0x10, 243 => 0x205 },
	'maxaperturevalue' => { 99 => 0x9205, 392 => 'MaxApertureValue' },
	'maxavailheight' => { 398 => 'MaxAvailHeight' },
	'maxavailwidth' => { 398 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 229 => 0xb, 230 => 0xc, 235 => 0xc, 236 => 0xb, 239 => '12.1' },
	'maxfaces' => { 246 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 30 => 0x17, 104 => 0x1405, 136 => 'MaxFocalLength', 181 => 0x9, 182 => 0xe, 183 => 0xf, 243 => 0x208, 357 => 0x127c, 358 => 0x1138, 359 => 0x330 },
	'maximumdensityrange' => { 109 => 0x8c },
	'maxpagesize' => { 418 => 'MaxPageSize' },
	'maxpagesizeh' => { 418 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 418 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 418 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 99 => 0x119 },
	'maxstorage' => { 408 => 'maxstorage' },
	'mb-d10batteries' => { 229 => '12.6' },
	'mb-d10batterytype' => { 235 => '13.3' },
	'mb-d11batterytype' => { 236 => '2.3' },
	'mb-d12batterytype' => { 239 => '3.2' },
	'mb-d80batteries' => { 237 => '6.5' },
	'mb-d80batterytype' => { 240 => '3.2' },
	'mcuversion' => { 181 => 0xc, 182 => 0x11, 183 => 0x12 },
	'md5digest' => { 137 => 'zmd5' },
	'meal' => { 405 => 'meal' },
	'measuredev' => { 26 => 0x9, 66 => 0x3, 85 => 0x1814, 129 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 66 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 157 => 0x690, 258 => 0x312, 264 => 0x3407 },
	'measuredrggb' => { 55 => 0x1 },
	'measuredrggbdata' => { 36 => 0x287 },
	'measurementaccuracy' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 98 => 'MeasurementOrFact' },
	'measurementremarks' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 98 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 401 => 'MediaConstraints' },
	'mediacreatedate' => { 309 => 0x1 },
	'mediamodifydate' => { 309 => 0x2 },
	'mediasummarycode' => { 401 => 'MediaSummaryCode' },
	'memoaudioquality' => { 72 => 0x812 },
	'memorycardconfiguration' => { 340 => 0x16 },
	'menubuttondisplayposition' => { 70 => 0xb, 73 => 0xa, 74 => 0xb, 77 => 0xb },
	'menubuttonreturn' => { 78 => 0xb },
	'menumonitorofftime' => { 229 => '26.1', 230 => '22.1', 235 => '8.2', 236 => '21.1', 239 => '22.1', 240 => '22.1' },
	'metadatadate' => { 411 => 'MetadataDate' },
	'metadatamoddate' => { 413 => 'metadataModDate' },
	'metaversion' => { 352 => 0x34 },
	'meterinfo1row1' => { 347 => 0x0 },
	'meterinfo1row2' => { 347 => 0x6c },
	'meterinfo1row3' => { 347 => 0xd8 },
	'meterinfo1row4' => { 347 => 0x144 },
	'meterinfo1row5' => { 347 => 0x1b0 },
	'meterinfo1row6' => { 347 => 0x21c },
	'meterinfo1row7' => { 347 => 0x288 },
	'meterinfo2row1' => { 347 => 0x2f4 },
	'meterinfo2row2' => { 347 => 0x378 },
	'meterinfo2row3' => { 347 => 0x3fc },
	'meterinfo2row4' => { 347 => 0x480 },
	'meterinfo2row5' => { 347 => 0x504 },
	'meterinfo2row6' => { 347 => 0x588 },
	'meterinfo2row7' => { 347 => 0x60c },
	'meterinfo2row8' => { 347 => 0x690 },
	'meterinfo2row9' => { 347 => 0x714 },
	'metering' => { 231 => '6.1' },
	'meteringmode' => { 30 => 0x11, 99 => 0x9207, 115 => 0x1c, 151 => 0x7, 152 => 0x25, 154 => 0x12, 242 => 0x202, 295 => 0x17, 326 => 0x9, 334 => 0x15, 335 => 0x13, 336 => 0x7, 350 => 0x3, 353 => 0x1174, 354 => 0x1178, 355 => 0x1154, 356 => 0x11d0, 357 => 0x11ac, 358 => 0x1064, 359 => 0x25c, 392 => 'MeteringMode' },
	'meteringmode2' => { 276 => '2.1' },
	'meteringmode3' => { 276 => '16.1' },
	'meteringoffscaleindicator' => { 154 => 0x53 },
	'meteringtime' => { 229 => '22.2', 231 => '3.2', 232 => '17.1', 233 => '18.1', 235 => '7.3', 236 => '18.1', 237 => '3.2', 240 => '19.1' },
	'mieversion' => { 137 => '0Vers' },
	'minaperture' => { 30 => 0x1b, 136 => 'MinAperture', 286 => '0.2', 360 => 0x1 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 30 => 0x18, 104 => 0x1404, 136 => 'MinFocalLength', 181 => 0x8, 182 => 0xd, 183 => 0xe, 243 => 0x207, 357 => 0x127a, 358 => 0x1136, 359 => 0x32e },
	'minfocusdistance' => { 286 => 0x3 },
	'minoltadate' => { 151 => 0x15 },
	'minoltaimagesize' => { 151 => 0x4, 152 => 0xc, 153 => 0x2, 156 => 0x103 },
	'minoltamodelid' => { 151 => 0x25 },
	'minoltaquality' => { 151 => 0x5, 152 => 0xd, 153 => 0x3, 156 => [0x102,0x103] },
	'minoltatime' => { 151 => 0x16 },
	'minormodelagedisclosure' => { 401 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 99 => 0x118 },
	'mirrorlockup' => { 70 => 0xc, 71 => 0xc, 72 => 0x60f, 73 => 0xb, 74 => 0xc, 75 => 0x6, 76 => 0x6, 77 => 0xc, 78 => 0x3 },
	'mobilecountrycode' => { 386 => 'mcc' },
	'mobilenetworkcode' => { 386 => 'mnc' },
	'moddate' => { 254 => 'modify-date', 399 => 'ModDate' },
	'modedialposition' => { 340 => 0x14 },
	'model' => { 86 => 0x6, 99 => 0x110, 129 => 'Model', 254 => 'Model', 266 => 0x110, 402 => 'model', 409 => 'Model' },
	'modelage' => { 398 => 'ModelAge' },
	'modelid' => { 241 => 0x0 },
	'modelingflash' => { 229 => '21.4', 230 => '31.1', 235 => '26.4', 236 => '30.2', 237 => '7.4', 238 => '30.1', 239 => '31.1', 240 => '31.3' },
	'modelreleaseid' => { 401 => 'ModelReleaseID' },
	'modelreleasestatus' => { 401 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 361 => 0x52, 362 => 0x46 },
	'modelyear' => { 402 => 'modelYear' },
	'modificationdate' => { 403 => 'modificationDate' },
	'modifiedcolortemp' => { 56 => 0x9 },
	'modifieddigitalgain' => { 56 => 0xb },
	'modifiedparamflag' => { 49 => 0x1 },
	'modifiedpicturestyle' => { 56 => 0xa },
	'modifiedsaturation' => { 242 => 0x504 },
	'modifiedsensorbluelevel' => { 56 => 0x5 },
	'modifiedsensorredlevel' => { 56 => 0x4 },
	'modifiedsharpness' => { 56 => 0x2 },
	'modifiedsharpnessfreq' => { 56 => 0x3 },
	'modifiedtonecurve' => { 56 => 0x1 },
	'modifiedwhitebalance' => { 56 => 0x8 },
	'modifiedwhitebalanceblue' => { 56 => 0x7 },
	'modifiedwhitebalancered' => { 56 => 0x6 },
	'modifydate' => { 99 => 0x132, 130 => 'ModifyDate', 251 => 'ModDate', 252 => 'tIME', 308 => 'ModDate', 310 => 0x2, 411 => 'ModifyDate' },
	'moirefilter' => { 99 => 0xfe58, 388 => 'MoireFilter' },
	'monitordisplayoff' => { 154 => 0x4c },
	'monitorofftime' => { 229 => '18.2', 231 => '3.1', 237 => '3.1' },
	'monochromecontrast' => { 91 => 0x3c },
	'monochromefiltereffect' => { 91 => 0x3a, 295 => 0x73 },
	'monochromelinear' => { 91 => 0x3d },
	'monochromeoutputhighlightpoint' => { 91 => 0x41 },
	'monochromeoutputshadowpoint' => { 91 => 0x42 },
	'monochromerawhighlight' => { 91 => 0x7a },
	'monochromerawhighlightpoint' => { 91 => 0x3f },
	'monochromerawshadow' => { 91 => 0x83 },
	'monochromerawshadowpoint' => { 91 => 0x40 },
	'monochromesharpness' => { 91 => 0x3e },
	'monochrometoning' => { 295 => 0x74 },
	'monochrometoningeffect' => { 91 => 0x3b },
	'monochromeunsharpmaskfineness' => { 91 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 91 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 91 => 0xb4 },
	'monthdaycreated' => { 115 => 0x12, 124 => 0xe },
	'moonphase' => { 313 => 0x12 },
	'morepermissions' => { 385 => 'morePermissions' },
	'motionsensitivity' => { 313 => 0x29 },
	'movieaelockbuttonassignment' => { 239 => '40.1' },
	'moviefunctionbutton' => { 230 => '41.1', 239 => '41.1' },
	'moviefunctionbuttonplusdials' => { 230 => '52.1' },
	'moviepreviewbutton' => { 230 => '41.2', 239 => '41.2' },
	'moviepreviewbuttonplusdials' => { 230 => '52.2' },
	'movieshutterbutton' => { 230 => '38.3', 239 => '38.3' },
	'moviesubselectorassignment' => { 230 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 230 => '53.1' },
	'multiburstimageheight' => { 346 => 0x1002 },
	'multiburstimagewidth' => { 346 => 0x1001 },
	'multiburstmode' => { 346 => 0x1000 },
	'multicontrollerwhilemetering' => { 72 => 0x517 },
	'multiexposure' => { 58 => 0x1 },
	'multiexposureautogain' => { 187 => 0x3 },
	'multiexposurecontrol' => { 58 => 0x2 },
	'multiexposuremode' => { 187 => 0x1 },
	'multiexposureshots' => { 58 => 0x3, 187 => 0x2 },
	'multiframenoisereduction' => { 336 => 0x35, 346 => 0x200b, 350 => 0x15 },
	'multifunctionlock' => { 72 => 0x70f },
	'multipleexposuremode' => { 246 => 0x101c },
	'multipleexposureset' => { 276 => '10.1' },
	'multisample' => { 192 => 0x40 },
	'multiselector' => { 229 => '9.4', 230 => '10.3', 235 => '27.4', 239 => '10.3' },
	'multiselectorliveview' => { 229 => '4.3', 239 => '37.1' },
	'multiselectorliveviewmode' => { 202 => 0x18c2 },
	'multiselectorplaybackmode' => { 229 => ['13.5','9.2'], 230 => '10.2', 235 => '27.2', 239 => '10.2' },
	'multiselectorshootmode' => { 229 => '9.1', 230 => '10.1', 235 => '27.1', 239 => '10.1' },
	'mycolormode' => { 59 => 0x2 },
	'nationalcatalognumber' => { 403 => 'nationalCatalogNumber' },
	'nativedigest' => { 392 => 'NativeDigest', 409 => 'NativeDigest' },
	'ncdfileinfo' => { 113 => 0x414 },
	'ndfilter' => { 66 => 0x1c, 242 => 0x204, 317 => 0x1019 },
	'nefbitdepth' => { 186 => 0xe22 },
	'nefcompression' => { 186 => 0x93 },
	'neflinearizationtable' => { 186 => 0x96 },
	'neutraldensityfilter' => { 295 => 0x88 },
	'neutraloutputhighlightpoint' => { 91 => 0x2f },
	'neutraloutputshadowpoint' => { 91 => 0x30 },
	'neutralrawcolortone' => { 91 => 0x28 },
	'neutralrawcontrast' => { 91 => 0x2a },
	'neutralrawhighlight' => { 91 => 0x78 },
	'neutralrawhighlightpoint' => { 91 => 0x2d },
	'neutralrawlinear' => { 91 => 0x2b },
	'neutralrawsaturation' => { 91 => 0x29 },
	'neutralrawshadow' => { 91 => 0x81 },
	'neutralrawshadowpoint' => { 91 => 0x2e },
	'neutralrawsharpness' => { 91 => 0x2c },
	'neutralunsharpmaskfineness' => { 91 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 91 => 0xa8 },
	'neutraunsharpmaskstrength' => { 91 => 0xa4 },
	'newrawimagedigest' => { 99 => 0xc7a7 },
	'newsphotoversion' => { 109 => 0x0 },
	'nickname' => { 411 => 'Nickname' },
	'nikoncapturedata' => { 186 => 0xe01 },
	'nikoncaptureeditversions' => { 186 => 0xe13 },
	'nikoncaptureoutput' => { 186 => 0xe1e },
	'nikoncaptureversion' => { 186 => 0xe09 },
	'nikoniccprofile' => { 186 => 0xe1d },
	'nikonimagesize' => { 199 => '723.1', 200 => '732.1', 208 => 0x2c4 },
	'noisefilter' => { 242 => 0x527 },
	'noiseprofile' => { 99 => 0xc761 },
	'noisereduction' => { 104 => 0x100b, 152 => 0xb0, 153 => 0x60, 154 => 0x3f, 186 => 0x95, 222 => 0x753dcbc0, 223 => 0x17, 242 => 0x50a, 247 => 0x103a, 262 => 0x2d, 295 => 0x49, 317 => 0x100f, 319 => 0x2a },
	'noisereduction2' => { 246 => 0x1010 },
	'noisereductionapplied' => { 99 => 0xc6f7 },
	'noisereductionintensity' => { 223 => 0x9 },
	'noisereductionmethod' => { 223 => 0x11 },
	'noisereductionmode' => { 373 => 0x801e },
	'noisereductionsharpness' => { 223 => 0xd },
	'noisereductionvalue' => { 373 => 0x8027 },
	'nomemorycard' => { 229 => '22.1', 230 => '4.2', 231 => '0.3', 232 => '2.4', 233 => '3.2', 234 => '3.2', 235 => '33.7', 236 => '3.2', 237 => '0.3', 239 => '4.2', 240 => '4.5' },
	'nominalmaxaperture' => { 286 => 0xa },
	'nominalminaperture' => { 286 => '10.1' },
	'normalwhitelevel' => { 37 => [0x2b8,0x2cf,0x2d3], 39 => 0x1e3, 40 => [0x1fc,0x2dc], 41 => 0x30e },
	'notes' => { 374 => 'Notes', 382 => 'notes' },
	'npages' => { 418 => 'NPages' },
	'nrwdata' => { 186 => 0x14 },
	'nullrecord' => { 85 => 0x0 },
	'number' => { 403 => 'number' },
	'numberofbeats' => { 413 => 'numberOfBeats' },
	'numberoffocuspoints' => { 234 => '0.2', 236 => '0.3' },
	'numfacepositions' => { 256 => 0x0 },
	'numindexentries' => { 109 => 0x54 },
	'numwbentries' => { 267 => 0x0, 268 => 0x0 },
	'object' => { 403 => 'object' },
	'objectattributereference' => { 107 => 0x4 },
	'objectcycle' => { 107 => 0x4b },
	'objectdescription' => { 402 => 'objectDescription' },
	'objectdistance' => { 94 => 0x6, 95 => 0x2022 },
	'objectname' => { 107 => 0x5 },
	'objectpreviewdata' => { 107 => 0xca },
	'objectpreviewfileformat' => { 107 => 0xc8 },
	'objectpreviewfileversion' => { 107 => 0xc9 },
	'objectsubtype' => { 402 => 'objectSubtype' },
	'objecttype' => { 402 => 'objectType' },
	'objecttypereference' => { 107 => 0x3 },
	'occurrence' => { 98 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 98 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 98 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 98 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 98 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 98 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 98 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 98 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 98 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 98 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 98 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 98 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 98 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 98 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 98 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 98 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 98 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 98 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 98 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 98 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 98 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 98 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 98 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 98 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 392 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 392 => [\'OECF','OECFNames'] },
	'oecfrows' => { 392 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 392 => [\'OECF','OECFValues'] },
	'offsaledate' => { 403 => 'offSaleDate' },
	'offsaledatea-platform' => { 403 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 403 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 99 => 0xea1d },
	'okbutton' => { 236 => '15.1', 240 => '16.1' },
	'oldsubfiletype' => { 99 => 0xff },
	'olympusimageheight' => { 247 => 0x102f },
	'olympusimagewidth' => { 247 => 0x102e },
	'onetouchwb' => { 247 => 0x302 },
	'onsaledate' => { 403 => 'onSaleDate' },
	'onsaledatea-platform' => { 403 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 403 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 403 => 'onSaleDay' },
	'onsaledaya-platform' => { 403 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 403 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 117 => 0xfa3d, 119 => [0x6006,0xf006], 120 => 0x1000, 121 => 0xf, 124 => 0x1e, 136 => 'OpticalZoom' },
	'opticalzoomcode' => { 66 => 0xa },
	'opticalzoommode' => { 262 => 0x34 },
	'opticalzoomon' => { 325 => 0x219 },
	'optionenddate' => { 406 => 'optionEndDate' },
	'opto-electricconvfactor' => { 392 => 'OECF' },
	'ordernumber' => { 104 => 0x8002 },
	'organisationinimagecode' => { 398 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 398 => 'OrganisationInImageName' },
	'organization' => { 403 => 'organization' },
	'orientation' => { 99 => 0x112, 266 => 0x112, 402 => 'orientation', 409 => 'Orientation' },
	'orientation2' => { 350 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 72 => 0x516 },
	'originalbestqualitysize' => { 99 => 0xc792 },
	'originaldecisiondata' => { 96 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 54 => 0x83 },
	'originaldefaultcropsize' => { 99 => 0xc793 },
	'originaldefaultfinalsize' => { 99 => 0xc791 },
	'originaldirectory' => { 260 => 0x408 },
	'originaldocumentid' => { 414 => 'OriginalDocumentID' },
	'originalfilename' => { 85 => 0x816, 113 => 0x3e9, 125 => 0x20, 260 => 0x407, 378 => 'OriginalFilename' },
	'originalimageheight' => { 68 => 0xc, 103 => 0x1 },
	'originalimagewidth' => { 68 => 0xb, 103 => 0x0 },
	'originalrawfiledata' => { 99 => 0xc68c },
	'originalrawfiledigest' => { 99 => 0xc71d },
	'originalrawfilename' => { 99 => 0xc68b },
	'originaltransmissionreference' => { 107 => 0x67 },
	'originatingprogram' => { 107 => 0x41 },
	'originplatform' => { 403 => 'originPlatform' },
	'os' => { 390 => 'os' },
	'otherconditions' => { 401 => 'OtherConditions' },
	'otherconstraints' => { 401 => 'OtherConstraints' },
	'otherimage' => { 96 => 'OtherImage' },
	'otherimageinfo' => { 401 => 'OtherImageInfo' },
	'otherimagelength' => { 99 => 0x202 },
	'otherimagestart' => { 99 => 0x201 },
	'otherlicensedocuments' => { 401 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 401 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 401 => 'OtherLicenseRequirements' },
	'outcue' => { 413 => 'outCue' },
	'outcuescale' => { 413 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 413 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 165 => 0x3 },
	'outputimagewidth' => { 165 => 0x2 },
	'outputprofile' => { 113 => 0x138b },
	'outputresolution' => { 165 => 0x4 },
	'owner' => { 417 => 'Owner' },
	'ownerid' => { 107 => 0xbc },
	'ownername' => { 14 => 0x10f, 54 => 0x9, 85 => 0x810, 99 => [0xa430,0xfde8], 129 => 'OwnerName', 384 => 'OwnerName', 393 => 'CameraOwnerName' },
	'padding' => { 99 => 0xea1c },
	'pagecount' => { 403 => 'pageCount' },
	'pageimage' => { 411 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 411 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 411 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 411 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 411 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 411 => 'PageInfo' },
	'pagename' => { 99 => 0x11d },
	'pagenumber' => { 99 => 0x129 },
	'pageprogressiondirection' => { 403 => 'pageProgressionDirection' },
	'pagerange' => { 403 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 388 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 388 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 262 => 0x26 },
	'panasonicimageheight' => { 262 => 0x4c },
	'panasonicimagewidth' => { 262 => 0x4b },
	'panasonicrawversion' => { 266 => 0x1 },
	'panasonictitle' => { 99 => 0xc6d2 },
	'panasonictitle2' => { 99 => 0xc6d3 },
	'panoramacropbottom' => { 351 => 0x7 },
	'panoramacropleft' => { 351 => 0x4 },
	'panoramacropright' => { 351 => 0x6 },
	'panoramacroptop' => { 351 => 0x5 },
	'panoramadirection' => { 62 => 0x5, 351 => 0x3 },
	'panoramaframeheight' => { 351 => 0x9 },
	'panoramaframenumber' => { 62 => 0x2 },
	'panoramaframewidth' => { 351 => 0x8 },
	'panoramafullheight' => { 351 => 0x2 },
	'panoramafullwidth' => { 351 => 0x1 },
	'panoramamode' => { 115 => 0x3c, 242 => 0x601 },
	'panoramasize3d' => { 336 => 0x38 },
	'panoramasourceheight' => { 351 => 0xb },
	'panoramasourcewidth' => { 351 => 0xa },
	'panoramicstitchcameramotion' => { 147 => 'PanoramicStitchCameraMotion', 148 => 0x1 },
	'panoramicstitchmaptype' => { 147 => 'PanoramicStitchMapType', 148 => 0x2 },
	'panoramicstitchphi0' => { 147 => 'PanoramicStitchPhi0', 148 => 0x5 },
	'panoramicstitchphi1' => { 147 => 'PanoramicStitchPhi1', 148 => 0x6 },
	'panoramicstitchtheta0' => { 147 => 'PanoramicStitchTheta0', 148 => 0x3 },
	'panoramicstitchtheta1' => { 147 => 'PanoramicStitchTheta1', 148 => 0x4 },
	'panoramicstitchversion' => { 148 => 0x0 },
	'pantry' => { 414 => 'Pantry' },
	'parallax' => { 104 => 0xb211, 241 => 0x28 },
	'parametricdarks' => { 388 => 'ParametricDarks' },
	'parametrichighlights' => { 388 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 388 => 'ParametricHighlightSplit' },
	'parametriclights' => { 388 => 'ParametricLights' },
	'parametricmidtonesplit' => { 388 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 388 => 'ParametricShadows' },
	'parametricshadowsplit' => { 388 => 'ParametricShadowSplit' },
	'parentmeid' => { 378 => 'ParentMEID' },
	'parentreference1' => { 396 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 396 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 413 => 'partOfCompilation' },
	'patientbirthdate' => { 375 => 'PatientDOB' },
	'patientid' => { 375 => 'PatientID' },
	'patientname' => { 375 => 'PatientName' },
	'patientsex' => { 375 => 'PatientSex' },
	'pdfversion' => { 399 => 'PDFVersion' },
	'pentaximagesize' => { 295 => 0x9 },
	'pentaxmodelid' => { 275 => 0x0, 295 => 0x5 },
	'pentaxmodeltype' => { 295 => 0x1 },
	'pentaxversion' => { 295 => 0x0 },
	'people' => { 376 => 'People', 380 => 'People' },
	'perchannelblacklevel' => { 36 => 0xc4, 37 => [0x2b4,0x2cb,0x2cf], 38 => 0x108, 39 => 0x1df, 40 => [0x1f8,0x2d8], 41 => 0x30a },
	'peripheralillumcentralradius' => { 373 => 0x8030 },
	'peripheralillumcentralvalue' => { 373 => 0x8031 },
	'peripheralillumination' => { 91 => 0x68 },
	'peripheralilluminationcorr' => { 53 => 0x1 },
	'peripheralilluminationon' => { 91 => 0x64 },
	'peripheralillumperiphvalue' => { 373 => 0x8032 },
	'peripherallighting' => { 68 => 0x2 },
	'peripherallightingsetting' => { 69 => 0x5 },
	'peripherallightingvalue' => { 68 => 0x6 },
	'permissions' => { 406 => 'permissions' },
	'permits' => { 385 => 'permits' },
	'person' => { 403 => 'person' },
	'personality' => { 378 => 'Personality' },
	'personinimage' => { 398 => 'PersonInImage' },
	'personinimagecharacteristic' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 398 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 398 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 388 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 388 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 388 => 'PerspectiveRotate' },
	'perspectivescale' => { 388 => 'PerspectiveScale' },
	'perspectiveupright' => { 388 => 'PerspectiveUpright' },
	'perspectivevertical' => { 388 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 80 => 0x1 },
	'pf10retainprogramshift' => { 80 => 0xb },
	'pf13drivepriority' => { 80 => 0xe },
	'pf14disablefocussearch' => { 80 => 0xf },
	'pf15disableafassistbeam' => { 80 => 0x10 },
	'pf16autofocuspointshoot' => { 80 => 0x11 },
	'pf17disableafpointsel' => { 80 => 0x12 },
	'pf18enableautoafpointsel' => { 80 => 0x13 },
	'pf19continuousshootspeed' => { 80 => 0x14 },
	'pf19shootingspeedhigh' => { 79 => 0xa },
	'pf19shootingspeedlow' => { 79 => 0x9 },
	'pf1disableshootingmodes' => { 80 => 0x2 },
	'pf1value' => { 79 => 0x1 },
	'pf20limitcontinousshots' => { 80 => 0x15 },
	'pf20maxcontinousshots' => { 79 => 0xb },
	'pf21enablequietoperation' => { 80 => 0x16 },
	'pf23felocktime' => { 79 => 0xd },
	'pf23postreleasetime' => { 79 => 0xe },
	'pf23settimerlengths' => { 80 => 0x18 },
	'pf23shutterbuttontime' => { 79 => 0xc },
	'pf24lightlcdduringbulb' => { 80 => 0x19 },
	'pf25aemode' => { 79 => 0xf },
	'pf25afmode' => { 79 => 0x12 },
	'pf25afpointsel' => { 79 => 0x13 },
	'pf25colormatrix' => { 79 => 0x17 },
	'pf25defaultclearsettings' => { 80 => 0x1a },
	'pf25drivemode' => { 79 => 0x11 },
	'pf25imagesize' => { 79 => 0x14 },
	'pf25meteringmode' => { 79 => 0x10 },
	'pf25parameters' => { 79 => 0x16 },
	'pf25wbmode' => { 79 => 0x15 },
	'pf26shortenreleaselag' => { 80 => 0x1b },
	'pf27reversedialrotation' => { 80 => 0x1c },
	'pf27value' => { 79 => 0x18 },
	'pf28noquickdialexpcomp' => { 80 => 0x1d },
	'pf29quickdialswitchoff' => { 80 => 0x1e },
	'pf2disablemeteringmodes' => { 80 => 0x3 },
	'pf2value' => { 79 => 0x2 },
	'pf30enlargementmode' => { 80 => 0x1f },
	'pf31originaldecisiondata' => { 80 => 0x20 },
	'pf3manualexposuremetering' => { 80 => 0x4 },
	'pf3value' => { 79 => 0x3 },
	'pf4exposuretimelimits' => { 80 => 0x5 },
	'pf4exposuretimemax' => { 79 => 0x5 },
	'pf4exposuretimemin' => { 79 => 0x4 },
	'pf5aperturelimits' => { 80 => 0x6 },
	'pf5aperturemax' => { 79 => 0x7 },
	'pf5aperturemin' => { 79 => 0x6 },
	'pf6presetshootingmodes' => { 80 => 0x7 },
	'pf7bracketcontinuousshoot' => { 80 => 0x8 },
	'pf8bracketshots' => { 79 => 0x8 },
	'pf8setbracketshots' => { 80 => 0x9 },
	'pf9changebracketsequence' => { 80 => 0xa },
	'phasedetectaf' => { 162 => 0x6 },
	'phonenumber' => { 130 => 'Phone' },
	'photoeffect' => { 30 => 0x28 },
	'photoeffecthistoryxml' => { 222 => 0xe9651831 },
	'photoeffects' => { 222 => 0xab5eca5e },
	'photoeffectsblue' => { 224 => 0x8 },
	'photoeffectsgreen' => { 224 => 0x6 },
	'photoeffectsred' => { 224 => 0x4 },
	'photoeffectstype' => { 224 => 0x0 },
	'photographicsensitivity' => { 393 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 229 => '17.6', 235 => '33.6' },
	'photometricinterpretation' => { 99 => 0x106, 409 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 306 => 0x409 },
	'photoshopquality' => { 305 => 0x0 },
	'photoshopthumbnail' => { 306 => 0x40c },
	'photostyle' => { 262 => 0x89 },
	'picklabel' => { 391 => 'PickLabel' },
	'pictinfo' => { 325 => 0x208 },
	'picturecontrol' => { 222 => 0xe2173c47 },
	'picturecontrolactive' => { 225 => 0x0 },
	'picturecontroladjust' => { 188 => 0x30 },
	'picturecontrolbase' => { 188 => 0x18 },
	'picturecontroldata' => { 186 => [0xbd,0x23] },
	'picturecontrolmode' => { 225 => 0x13 },
	'picturecontrolname' => { 188 => 0x4 },
	'picturecontrolquickadjust' => { 188 => 0x31 },
	'pictureeffect' => { 346 => 0x200e },
	'pictureeffect2' => { 353 => 0x1163, 354 => 0x1167, 355 => 0x1143, 356 => 0x11bf, 357 => 0x119b, 358 => 0x1053, 359 => 0x24b, 369 => 0x46 },
	'picturefinish' => { 152 => 0x71 },
	'picturemode' => { 104 => 0x1031, 242 => 0x520, 295 => [0xb,0x33], 326 => 0x3d },
	'picturemode2' => { 276 => 0x0 },
	'picturemodebwfilter' => { 242 => 0x525 },
	'picturemodecontrast' => { 242 => 0x523 },
	'picturemodeeffect' => { 242 => 0x52d },
	'picturemodehue' => { 242 => 0x522 },
	'picturemodesaturation' => { 242 => 0x521 },
	'picturemodesharpness' => { 242 => 0x524 },
	'picturemodetone' => { 242 => 0x526 },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 64 => 0xa, 91 => 0x2 },
	'picturewizard' => { 323 => 0x21 },
	'picturewizardcolor' => { 322 => 0x1 },
	'picturewizardcontrast' => { 322 => 0x4 },
	'picturewizardmode' => { 322 => 0x0 },
	'picturewizardsaturation' => { 322 => 0x2 },
	'picturewizardsharpness' => { 322 => 0x3 },
	'pitch' => { 230 => '4.1', 239 => '4.1' },
	'pitchangle' => { 202 => 0x350f, 242 => 0x904, 262 => 0x91, 294 => 0x2 },
	'pixelsperunitx' => { 253 => 0x0 },
	'pixelsperunity' => { 253 => 0x4 },
	'pixelunits' => { 253 => 0x8 },
	'planarconfiguration' => { 99 => 0x11c, 409 => 'PlanarConfiguration' },
	'platenames' => { 418 => 'PlateNames' },
	'platform' => { 403 => 'platform' },
	'playbackmenustime' => { 232 => '20.1', 233 => '21.1', 234 => '21.1' },
	'playbackmonitorofftime' => { 229 => '25.2', 230 => '36.1', 235 => '8.1', 236 => '35.1', 239 => '36.1', 240 => '21.1' },
	'playbackzoom' => { 230 => '37.1' },
	'playdisplay' => { 154 => 0x4e },
	'plusversion' => { 401 => 'Version' },
	'pmversion' => { 304 => 'PMVersion' },
	'pngwarning' => { 254 => 'Warning' },
	'poilevel' => { 185 => 0x8 },
	'portraitoutputhighlightpoint' => { 91 => 0x1d },
	'portraitoutputshadowpoint' => { 91 => 0x1e },
	'portraitrawcolortone' => { 91 => 0x16 },
	'portraitrawcontrast' => { 91 => 0x18 },
	'portraitrawhighlight' => { 91 => 0x76 },
	'portraitrawhighlightpoint' => { 91 => 0x1b },
	'portraitrawlinear' => { 91 => 0x19 },
	'portraitrawsaturation' => { 91 => 0x17 },
	'portraitrawshadow' => { 91 => 0x7f },
	'portraitrawshadowpoint' => { 91 => 0x1c },
	'portraitrawsharpness' => { 91 => 0x1a },
	'portraitrefiner' => { 95 => 0x302b },
	'portraitunsharpmaskfineness' => { 91 => 0x9a },
	'portraitunsharpmaskstrength' => { 91 => 0x98 },
	'portraitunsharpmaskthreshold' => { 91 => 0x9c },
	'poseheadingdegrees' => { 377 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 377 => 'PosePitchDegrees' },
	'poserolldegrees' => { 377 => 'PoseRollDegrees' },
	'positiondescriptor' => { 402 => 'positionDescriptor' },
	'postalcode' => { 134 => 'PostalCode' },
	'postcropvignetteamount' => { 388 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 388 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 388 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 388 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 388 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 388 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 344 => 0xb },
	'potentialface2position' => { 344 => 0x15 },
	'potentialface3position' => { 344 => 0x1f },
	'potentialface4position' => { 344 => 0x29 },
	'potentialface5position' => { 344 => 0x33 },
	'potentialface6position' => { 344 => 0x3d },
	'potentialface7position' => { 344 => 0x47 },
	'potentialface8position' => { 344 => 0x51 },
	'powersource' => { 274 => '0.1' },
	'poweruptime' => { 186 => 0xb6 },
	'precaptureframes' => { 247 => 0x300 },
	'predictor' => { 99 => 0x13d },
	'preflashreturnstrength' => { 200 => 0x28a },
	'prefs' => { 107 => 0xdd, 304 => 'Prefs' },
	'preservedfilename' => { 414 => 'PreservedFileName' },
	'presetwhitebalance' => { 154 => 0x24, 373 => 0x8002 },
	'presetwhitebalanceadj' => { 373 => 0x8014 },
	'previewapplicationname' => { 99 => 0xc716 },
	'previewapplicationversion' => { 99 => 0xc717 },
	'previewbutton' => { 229 => ['14.1','15.1'], 230 => '15.1', 235 => '29.1', 236 => '14.1', 239 => '15.1' },
	'previewbuttonplusdials' => { 229 => ['14.2','15.2'], 230 => '15.2', 235 => '31.2', 239 => '43.1' },
	'previewcolorspace' => { 99 => 0xc71a },
	'previewcropbottom' => { 303 => 0xef },
	'previewcropleft' => { 303 => 0xec },
	'previewcropright' => { 303 => 0xee },
	'previewcroptop' => { 303 => 0xed },
	'previewdate' => { 311 => 0x0 },
	'previewdatetime' => { 99 => 0xc71b },
	'previewimage' => { 95 => 0x2000, 96 => 'PreviewImage', 100 => 'PreviewImage', 102 => 0x4, 139 => 'data', 156 => 0x81, 247 => 0x280, 261 => 0x300, 346 => 0x2001 },
	'previewimageborders' => { 295 => 0x3e },
	'previewimageheight' => { 63 => 0x4, 117 => 0xfa58 },
	'previewimagelength' => { 63 => 0x2, 95 => 0x3, 99 => [0x117,0x202], 156 => 0x89, 189 => 0x202, 242 => 0x102, 247 => 0x1037, 295 => 0x3, 316 => 0x1e, 321 => 0x3, 326 => [0x1b,0x1d], 337 => 0x202 },
	'previewimagename' => { 139 => '1Name' },
	'previewimagesize' => { 95 => 0x2, 122 => 0x2, 139 => 'ImageSize', 295 => 0x2, 326 => [0x1c,0x1e], 346 => 0xb02c },
	'previewimagestart' => { 63 => 0x5, 95 => 0x4, 99 => [0x111,0x201], 156 => 0x88, 189 => 0x201, 242 => 0x101, 247 => 0x1036, 295 => 0x4, 316 => 0x1c, 321 => 0x2, 326 => [0x1a,0x1c], 337 => 0x201 },
	'previewimagetype' => { 139 => '0Type' },
	'previewimagevalid' => { 242 => 0x100, 247 => 0x1035 },
	'previewimagewidth' => { 63 => 0x3, 117 => 0xfa57 },
	'previewquality' => { 63 => 0x1 },
	'previewsettingsdigest' => { 99 => 0xc719 },
	'previewsettingsname' => { 99 => 0xc718 },
	'primaryafpoint' => { 162 => 0x7 },
	'primarychromaticities' => { 99 => 0x13f, 409 => 'PrimaryChromaticities' },
	'printim' => { 99 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 154 => 0x1d, 334 => 0x28 },
	'privatertkinfo' => { 379 => 'privateRTKInfo' },
	'processingsoftware' => { 99 => 0xb },
	'processversion' => { 388 => 'ProcessVersion' },
	'producer' => { 251 => 'Producer', 399 => 'Producer' },
	'productcode' => { 403 => 'productCode' },
	'productid' => { 108 => 0x32, 402 => 'productID' },
	'productidtype' => { 402 => 'productIDType' },
	'productinimage' => { 398 => 'ProductInImage' },
	'productinimagedescription' => { 398 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 398 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 398 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 275 => 0x2 },
	'productorserviceconstraints' => { 401 => 'ProductOrServiceConstraints' },
	'profession' => { 403 => 'profession' },
	'profilecalibrationsig' => { 99 => 0xc6f4 },
	'profilecopyright' => { 99 => 0xc6fe },
	'profileembedpolicy' => { 99 => 0xc6fd },
	'profilehuesatmapdata1' => { 99 => 0xc6fa },
	'profilehuesatmapdata2' => { 99 => 0xc6fb },
	'profilehuesatmapdims' => { 99 => 0xc6f9 },
	'profilehuesatmapencoding' => { 99 => 0xc7a3 },
	'profilelooktabledata' => { 99 => 0xc726 },
	'profilelooktabledims' => { 99 => 0xc725 },
	'profilelooktableencoding' => { 99 => 0xc7a4 },
	'profilename' => { 99 => 0xc6f8 },
	'profiletonecurve' => { 99 => 0xc6fc },
	'programiso' => { 262 => 0x3c },
	'programline' => { 276 => '1.1' },
	'programmode' => { 159 => 0x5 },
	'programshift' => { 186 => 0xd },
	'programversion' => { 107 => 0x46 },
	'prohibits' => { 385 => 'prohibits' },
	'projectiontype' => { 377 => 'ProjectionType' },
	'projectname' => { 413 => 'projectName' },
	'projectref' => { 413 => 'projectRef' },
	'projectrefpath' => { 413 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 413 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 401 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 401 => 'PropertyReleaseStatus' },
	'province-state' => { 107 => 0x5f },
	'publicationdate' => { 403 => 'publicationDate' },
	'publicationdatea-platform' => { 403 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 403 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 403 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 403 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 403 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 403 => 'publicationName' },
	'publisher' => { 389 => 'publisher' },
	'publishingfrequency' => { 403 => 'publishingFrequency' },
	'pulldown' => { 413 => 'pullDown' },
	'quality' => { 0 => 0x1, 30 => 0x3, 94 => 0x2, 95 => 0x3002, 104 => 0x1000, 115 => 0x9, 186 => 0x4, 212 => 0x3, 247 => 0x201, 258 => 0x300, 295 => 0x8, 301 => 0x2, 326 => 0x16, 334 => 0x56, 335 => 0x56, 336 => 0xb, 346 => 0x102 },
	'quality2' => { 353 => 0x1170, 354 => 0x1174, 355 => 0x1150, 357 => 0x11a8, 358 => 0x1060, 359 => 0x258, 361 => 0x29, 362 => 0x25, 363 => 0x2a },
	'qualitymode' => { 95 => 0x8 },
	'quantizationmethod' => { 109 => 0x78 },
	'quickadjust' => { 225 => 0x2a },
	'quickcontroldialinmeter' => { 72 => 0x703 },
	'quickfix' => { 222 => 0x416391c6 },
	'quickshot' => { 325 => 0x213 },
	'rangefinder' => { 232 => '4.1', 233 => '5.1', 234 => '5.1' },
	'rasterizedcaption' => { 107 => 0x7d },
	'rating' => { 99 => 0x4746, 104 => 0x1431, 303 => 0xdf, 346 => 0x2002, 382 => 'rating', 390 => 'rating', 403 => 'rating', 411 => 'Rating' },
	'ratingpercent' => { 99 => 0x4749, 149 => 'Rating' },
	'rawandjpgrecording' => { 70 => 0x8, 156 => 0x109, 276 => 0xd },
	'rawbrightnessadj' => { 90 => 0x38 },
	'rawcoloradj' => { 90 => 0x2e },
	'rawcompressionmode' => { 323 => 0x45 },
	'rawcropbottom' => { 303 => 0xd4 },
	'rawcropleft' => { 303 => 0xd1 },
	'rawcropright' => { 303 => 0xd3 },
	'rawcroptop' => { 303 => 0xd2 },
	'rawcustomsaturation' => { 90 => 0x30 },
	'rawcustomtone' => { 90 => 0x34 },
	'rawdata' => { 323 => 0xa048 },
	'rawdatauniqueid' => { 99 => 0xc65d },
	'rawdepth' => { 158 => 0x10 },
	'rawdevartfilter' => { 249 => 0x121 },
	'rawdevautogradation' => { 249 => 0x119 },
	'rawdevcolorspace' => { 248 => 0x108, 249 => 0x109 },
	'rawdevcontrastvalue' => { 248 => 0x106, 249 => 0x105 },
	'rawdeveditstatus' => { 248 => 0x10b },
	'rawdevelopmentprocess' => { 295 => 0x62 },
	'rawdevengine' => { 248 => 0x109, 249 => 0x10b },
	'rawdevexposurebiasvalue' => { 248 => 0x100, 249 => 0x100 },
	'rawdevgradation' => { 249 => 0x112 },
	'rawdevgraypoint' => { 248 => 0x103, 249 => 0x104 },
	'rawdevmemorycoloremphasis' => { 248 => 0x105, 249 => 0x108 },
	'rawdevnoisereduction' => { 248 => 0x10a, 249 => 0x10a },
	'rawdevpicturemode' => { 249 => 0x10c },
	'rawdevpm_bwfilter' => { 249 => 0x110 },
	'rawdevpmcontrast' => { 249 => 0x10e },
	'rawdevpmnoisefilter' => { 249 => 0x120 },
	'rawdevpmpicturetone' => { 249 => 0x111 },
	'rawdevpmsaturation' => { 249 => 0x10d },
	'rawdevpmsharpness' => { 249 => 0x10f },
	'rawdevsaturation3' => { 249 => 0x113 },
	'rawdevsaturationemphasis' => { 248 => 0x104, 249 => 0x107 },
	'rawdevsettings' => { 248 => 0x10c },
	'rawdevsharpnessvalue' => { 248 => 0x107, 249 => 0x106 },
	'rawdevversion' => { 248 => 0x0, 249 => 0x0 },
	'rawdevwbfineadjustment' => { 248 => 0x102, 249 => 0x103 },
	'rawdevwhitebalance' => { 249 => 0x101 },
	'rawdevwhitebalancevalue' => { 248 => 0x101, 249 => 0x102 },
	'rawfile' => { 99 => 0xfe4c },
	'rawfilename' => { 388 => 'RawFileName' },
	'rawimagecenter' => { 186 => 0x99 },
	'rawimagedigest' => { 99 => 0xc71c },
	'rawimagesize' => { 295 => 0x39 },
	'rawinfoversion' => { 250 => 0x0 },
	'rawjpgheight' => { 87 => 0x4 },
	'rawjpgquality' => { 48 => 0x6, 87 => 0x1 },
	'rawjpgsize' => { 48 => 0x7, 87 => 0x2 },
	'rawjpgwidth' => { 87 => 0x3 },
	'rawmeasuredrggb' => { 35 => 0x26a, 37 => 0x280, 39 => 0x194, 40 => [0x1ad,0x26b] },
	'rawrppused' => { 382 => 'rawrppused' },
	'rawtopreviewgain' => { 99 => 0xc7a8 },
	'reardisplay' => { 229 => '12.3', 230 => '6.2' },
	'recipeendingpage' => { 405 => 'recipeEndingPage' },
	'recipepagerange' => { 405 => 'recipePageRange' },
	'recipesource' => { 405 => 'recipeSource' },
	'recipestartingpage' => { 405 => 'recipeStartingPage' },
	'recipetitle' => { 405 => 'recipeTitle' },
	'recognizedface1age' => { 257 => 0x20 },
	'recognizedface1name' => { 257 => 0x4 },
	'recognizedface1position' => { 257 => 0x18 },
	'recognizedface2age' => { 257 => 0x50 },
	'recognizedface2name' => { 257 => 0x34 },
	'recognizedface2position' => { 257 => 0x48 },
	'recognizedface3age' => { 257 => 0x80 },
	'recognizedface3name' => { 257 => 0x64 },
	'recognizedface3position' => { 257 => 0x78 },
	'recognizedfaceflags' => { 262 => 0x63 },
	'recommendedexposureindex' => { 99 => 0x8832, 393 => 'RecommendedExposureIndex' },
	'record' => { 98 => 'Record' },
	'recordbasisofrecord' => { 98 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 98 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 98 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 98 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 98 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 98 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 154 => 0x4d },
	'recorddynamicproperties' => { 98 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 85 => 0x1804 },
	'recordinformationwithheld' => { 98 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 317 => 0x1000 },
	'recordingmode' => { 94 => 0x1, 301 => 0x1 },
	'recordinstitutioncode' => { 98 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 98 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 30 => 0x9, 95 => 0x3000 },
	'recordownerinstitutioncode' => { 98 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 325 => 0x217 },
	'redbalance' => { 170 => 0x270, 247 => 0x1017, 266 => 0x11, 295 => 0x1c },
	'redcurvelimits' => { 90 => 0x18a },
	'redcurvepoints' => { 90 => 0x160 },
	'redeyecorrection' => { 226 => 0x0 },
	'redeyeinfo' => { 388 => 'RedEyeInfo' },
	'redeyereduction' => { 154 => 0x41, 334 => 0x6a, 336 => 0x28 },
	'redhue' => { 388 => 'RedHue' },
	'redsaturation' => { 388 => 'RedSaturation' },
	'reductionmatrix1' => { 99 => 0xc625 },
	'reductionmatrix2' => { 99 => 0xc626 },
	'reelname' => { 99 => 0xc789 },
	'reference1' => { 396 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 396 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 99 => 0x214, 409 => 'ReferenceBlackWhite' },
	'referencedate' => { 107 => 0x2f },
	'referencenumber' => { 107 => 0x32 },
	'references' => { 130 => 'References' },
	'referenceservice' => { 107 => 0x2d },
	'regionappliedtodimensions' => { 145 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 145 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 145 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 145 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 145 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 145 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 145 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 145 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 145 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 145 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 145 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 145 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 401 => 'RegionConstraints' },
	'regiondescription' => { 145 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 145 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 145 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 145 => 'Regions' },
	'regioninfodateregionsvalid' => { 146 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 146 => 'RegionInfo' },
	'regioninforegions' => { 146 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 145 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 145 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 146 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 146 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 146 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 146 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 146 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 145 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 145 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 398 => 'RegistryId' },
	'registryitemid' => { 398 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 398 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 128 => 'data' },
	'relatedaudiofilename' => { 128 => '1Name' },
	'relatedaudiofiletype' => { 128 => '0Type' },
	'relatedimagefileformat' => { 99 => 0x1000 },
	'relatedimageheight' => { 99 => 0x1002 },
	'relatedimagewidth' => { 99 => 0x1001 },
	'relatedresourceid' => { 98 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 99 => 0xa004, 392 => 'RelatedSoundFile' },
	'relatedvideofile' => { 142 => 'data' },
	'relatedvideofilename' => { 142 => '1Name' },
	'relatedvideofiletype' => { 142 => '0Type' },
	'relation' => { 389 => 'relation' },
	'relationshipaccordingto' => { 98 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 98 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 98 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 98 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 413 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 413 => 'relativeTimestamp' },
	'relativetimestampscale' => { 413 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 413 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 229 => '17.8', 230 => '18.5', 235 => '33.8', 236 => '17.6', 239 => '18.5' },
	'releasedate' => { 107 => 0x1e, 413 => 'releaseDate' },
	'releasemode' => { 95 => 0x3001, 346 => 0xb049 },
	'releasemode2' => { 353 => 0x112c, 354 => [0x112c,0x8], 355 => [0x1108,0x8], 356 => [0x1184,0x8], 357 => [0x1160,0x8], 358 => [0x4,0x1018], 359 => [0x4,0x210], 360 => 0x3f, 361 => 0x10, 362 => 0x10, 363 => 0x9, 369 => 0x34 },
	'releasemode3' => { 353 => 0x1128, 354 => 0x1128, 355 => 0x1104, 356 => 0x1180, 357 => 0x115c, 358 => 0x1014, 359 => 0x20c },
	'releasesetting' => { 85 => 0x1016 },
	'releasetime' => { 107 => 0x23 },
	'remoteonduration' => { 231 => '3.4', 232 => '17.2', 233 => '18.2', 234 => '18.2', 236 => '18.2', 237 => '4.3', 240 => '19.2' },
	'renditionclass' => { 414 => 'RenditionClass' },
	'renditionof' => { 414 => 'RenditionOf' },
	'renditionofalternatepaths' => { 414 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 414 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 414 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 414 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 414 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 414 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 414 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 414 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 414 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 414 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 414 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 414 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 414 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 414 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 414 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 414 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 414 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 414 => 'RenditionParams' },
	'repeatingflashcount' => { 175 => 0xd, 176 => 0xe, 177 => 0xe, 235 => '17.2', 236 => '24.2', 237 => '9.2', 238 => '24.2', 240 => '25.2' },
	'repeatingflashcountbuilt-in' => { 209 => 0x4db },
	'repeatingflashcountexternal' => { 209 => 0x4c3 },
	'repeatingflashoutput' => { 235 => '17.1', 236 => '24.1', 237 => '9.1', 238 => '24.1', 240 => '25.1' },
	'repeatingflashoutputexternal' => { 209 => 0x4c0 },
	'repeatingflashrate' => { 175 => 0xc, 176 => 0xd, 177 => 0xd, 235 => '18.1', 236 => '25.1', 237 => '10.1', 238 => '25.1', 240 => '26.1' },
	'repeatingflashratebuilt-in' => { 209 => 0x4da },
	'repeatingflashrateexternal' => { 209 => 0x4c2 },
	'requires' => { 385 => 'requires' },
	'resampleparams' => { 413 => 'resampleParams' },
	'resampleparamsquality' => { 413 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 325 => 0x21e },
	'resolution' => { 135 => 'Resolution' },
	'resolutionmode' => { 326 => 0x4 },
	'resolutionunit' => { 99 => 0x128, 110 => 0x2, 409 => 'ResolutionUnit' },
	'resourceid' => { 98 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 98 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 98 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 72 => 0x612 },
	'restrictions' => { 406 => 'restrictions' },
	'retouchareafeather' => { 388 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 388 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 388 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 388 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 388 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 388 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 388 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 388 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 388 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 388 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 388 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 388 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 388 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 388 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 388 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 388 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 388 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 388 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 388 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 388 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 388 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 388 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 388 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 388 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 388 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 388 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 388 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 388 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 388 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 388 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 388 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 388 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 388 => 'RetouchAreas' },
	'retouchareaseed' => { 388 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 388 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 388 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 388 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 186 => 0x9e },
	'retouchinfo' => { 388 => 'RetouchInfo' },
	'retouchnefprocessing' => { 191 => 0x5 },
	'reuse' => { 401 => 'Reuse' },
	'reuseallowed' => { 416 => 'ReuseAllowed' },
	'reuseprohibited' => { 406 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 234 => '5.2' },
	'reverseindicators' => { 229 => '12.1', 230 => '6.1', 232 => '4.3', 233 => '5.2', 234 => '5.4', 235 => '33.5', 236 => '5.1', 239 => '6.1', 240 => '6.2' },
	'reverseshutterspeedaperture' => { 234 => '5.3' },
	'revision' => { 390 => 'revision' },
	'rgbcurvelimits' => { 90 => 0x238 },
	'rgbcurvepoints' => { 90 => 0x20e },
	'richtextcomment' => { 395 => 'RichTextComment' },
	'ricohdate' => { 316 => 0x6 },
	'ricohimageheight' => { 316 => 0x2 },
	'ricohimagewidth' => { 316 => 0x0 },
	'rightascension' => { 138 => 'RightAscension' },
	'rights' => { 389 => 'rights' },
	'rightsagent' => { 406 => 'rightsAgent' },
	'rightsowner' => { 406 => 'rightsOwner' },
	'rollangle' => { 202 => 0x350b, 242 => 0x903, 262 => 0x90, 294 => 0x1 },
	'romoperationmode' => { 85 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 84 => 0x3, 90 => 0x26e, 103 => 0x4, 138 => 'Rotation', 152 => [0x65,0x50], 153 => 0x46, 154 => 0x5a, 157 => 0x10, 208 => '590.1', 222 => 0x76a43207, 262 => 0x30, 276 => '17.2', 303 => 0xd8, 334 => 0x3f, 335 => 0x3f, 345 => 0x10 },
	'routedto' => { 394 => 'RoutedTo' },
	'routing' => { 308 => 'Routing' },
	'routingnotes' => { 394 => 'RoutingNotes' },
	'rowsperstrip' => { 99 => 0x116 },
	'rpp' => { 382 => 'rpp' },
	'safetyshift' => { 72 => 0x108 },
	'safetyshiftinavortv' => { 70 => 0x10, 71 => 0x10, 73 => 0xf, 74 => 0x10, 77 => 0x10 },
	'samplebits' => { 128 => 'SampleBits' },
	'samplepagerange' => { 403 => 'samplePageRange' },
	'samplerate' => { 128 => 'SampleRate' },
	'samplesperpixel' => { 99 => 0x115, 409 => 'SamplesPerPixel' },
	'samplestructure' => { 109 => 0x5a },
	'samsungmodelid' => { 323 => 0x3 },
	'sanyoquality' => { 325 => 0x201 },
	'sanyothumbnail' => { 325 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 30 => 0xe, 42 => 0x1, 94 => 0xd, 95 => [0x3013,0x1f], 99 => [0xa409,0xfe55], 104 => 0x1003, 129 => 'Saturation', 151 => 0x1f, 152 => 0x32, 153 => 0x28, 154 => 0x1a, 159 => 0x1, 186 => [0x94,0xaa], 188 => 0x35, 262 => 0x40, 264 => 0x300d, 295 => 0x1f, 301 => 0xd, 313 => 0x27, 316 => 0x28, 317 => 0x1013, 326 => 0x10, 334 => 0x1e, 335 => 0x1b, 346 => 0x2005, 388 => 'Saturation', 392 => 'Saturation' },
	'saturationadj' => { 90 => 0x116, 221 => 0x1, 225 => 0x2e, 373 => 0x8016 },
	'saturationadjustmentaqua' => { 388 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 388 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 388 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 388 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 388 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 388 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 388 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 388 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 61 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 60 => 0x68, 61 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 60 => 0x38, 61 => 0x38 },
	'saturationmonochrome' => { 60 => 0x80, 61 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 60 => 0x50, 61 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 60 => 0x20, 61 => 0x20 },
	'saturationsetting' => { 250 => 0x1010, 336 => 0x11, 350 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 60 => 0x8, 61 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 60 => 0x98, 61 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 60 => 0xb0, 61 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 60 => 0xc8, 61 => 0xe0 },
	'saveid' => { 414 => 'SaveID' },
	'scaletype' => { 413 => 'scaleType' },
	'scanimageenhancer' => { 192 => 0x60 },
	'scanningdirection' => { 109 => 0x64 },
	'scene' => { 397 => 'Scene', 413 => 'scene' },
	'scenearea' => { 245 => 0x211, 247 => 0x1031 },
	'sceneassist' => { 186 => 0x9c },
	'scenecapturetype' => { 99 => 0xa406, 392 => 'SceneCaptureType' },
	'scenedetect' => { 245 => 0x210, 247 => 0x1030 },
	'scenedetectdata' => { 245 => 0x212, 247 => 0x1033 },
	'scenemode' => { 117 => 0xfa02, 156 => 0x100, 186 => 0x8f, 242 => 0x509, 247 => 0x403, 262 => 0x8001, 270 => 0xf, 346 => 0xb023 },
	'scenemodeused' => { 119 => [0x6002,0xf002] },
	'sceneselect' => { 325 => 0x21f },
	'scenetype' => { 99 => 0xa301, 392 => 'SceneType' },
	'screentips' => { 229 => '12.7', 230 => '5.3', 235 => '13.1', 236 => '4.4', 239 => '5.4', 240 => '5.1' },
	'season' => { 402 => 'season' },
	'section' => { 403 => 'section' },
	'securityclassification' => { 99 => 0x9212 },
	'selectableafpoint' => { 72 => 0x509 },
	'selectafareaselectmode' => { 72 => 0x512 },
	'selftimer' => { 30 => 0x2, 262 => 0x2e, 325 => 0x214 },
	'selftimer2' => { 66 => 0x1d },
	'selftimerinterval' => { 236 => '19.2' },
	'selftimermode' => { 99 => 0x882b },
	'selftimershotcount' => { 230 => '20.2', 232 => '18.2', 233 => '19.2', 234 => '19.2', 236 => '19.3', 239 => '20.3', 240 => '20.2' },
	'selftimershotinterval' => { 230 => '20.3', 239 => '20.2' },
	'selftimertime' => { 85 => 0x1806, 154 => 0x1f, 229 => '18.1', 230 => '20.1', 231 => '3.3', 232 => '18.1', 233 => '19.1', 234 => '19.1', 235 => '7.2', 236 => '19.1', 237 => '3.3', 239 => '20.1', 240 => '20.1' },
	'sellingagency' => { 403 => 'sellingAgency' },
	'seminfo' => { 99 => 0x8546 },
	'sensingmethod' => { 99 => 0xa217, 392 => 'SensingMethod' },
	'sensitivityadjust' => { 295 => 0x40 },
	'sensitivitysteps' => { 276 => ['14.3','17.4'], 278 => 0x1 },
	'sensitivitytype' => { 99 => 0x8830, 393 => 'SensitivityType' },
	'sensorareas' => { 323 => 0xa010 },
	'sensorbitdepth' => { 264 => 0x312d },
	'sensorbluelevel' => { 64 => 0x5 },
	'sensorcalibration' => { 246 => 0x805 },
	'sensorcleaning' => { 78 => 0xd },
	'sensorfullheight' => { 112 => 0xf904 },
	'sensorfullwidth' => { 112 => 0xf903 },
	'sensorheight' => { 112 => 0xf901, 117 => 0xfa21, 158 => 0x8, 264 => 0x312c, 317 => 0x1602 },
	'sensorpixelsize' => { 186 => 0x9a },
	'sensorredlevel' => { 64 => 0x4 },
	'sensorserialnumber' => { 113 => 0x9ce },
	'sensorsize' => { 129 => 'SensorSize', 295 => 0x35 },
	'sensortemperature' => { 245 => 0x1500, 247 => 0x1007, 326 => [0x39,0x55] },
	'sensorwidth' => { 112 => 0xf900, 117 => 0xfa20, 158 => 0xa, 264 => 0x312b, 317 => 0x1601 },
	'sequence' => { 313 => 0x7 },
	'sequencefilenumber' => { 354 => 0x4, 355 => 0x4, 356 => 0x4, 357 => 0x4, 361 => 0xc, 362 => 0xc, 363 => 0x1a },
	'sequenceimagenumber' => { 354 => 0x0, 355 => 0x0, 356 => 0x0, 357 => 0x0, 361 => 0x8, 362 => 0x8, 363 => 0x12, 369 => 0x24 },
	'sequencelength' => { 361 => 0x22, 362 => 0x1e, 363 => [0x16,0x1e] },
	'sequencename' => { 402 => 'sequenceName' },
	'sequencenumber' => { 66 => 0x9, 95 => 0x301c, 104 => 0x1101, 115 => 0x1d, 209 => 0x51c, 262 => 0x2b, 336 => [0x10c,0x30c], 346 => 0xb04a, 402 => 'sequenceNumber' },
	'sequenceshotinterval' => { 325 => 0x224 },
	'sequencetotalnumber' => { 402 => 'sequenceTotalNumber' },
	'sequentialshot' => { 325 => 0x20e },
	'serialnumber' => { 54 => 0xc, 85 => 0x180b, 99 => [0xa431,0xfde9], 112 => 0xfa04, 114 => 0xfa00, 116 => 0xc354, 117 => 0xfa19, 126 => 0x0, 129 => 'SerialNumber', 186 => [0xa0,0x1d], 243 => 0x101, 247 => [0x404,0x101a], 258 => 0x303, 264 => 0x3103, 295 => 0x229, 313 => 0x15, 317 => 0x5, 326 => 0x2, 384 => 'SerialNumber', 393 => 'BodySerialNumber' },
	'serialnumberformat' => { 54 => 0x15, 85 => 0x183b },
	'seriesdatetime' => { 375 => 'SeriesDateTime' },
	'seriesdescription' => { 375 => 'SeriesDescription' },
	'seriesmodality' => { 375 => 'SeriesModality' },
	'seriesnumber' => { 375 => 'SeriesNumber', 403 => 'seriesNumber' },
	'seriestitle' => { 403 => 'seriesTitle' },
	'serviceidentifier' => { 108 => 0x1e },
	'servingsize' => { 405 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 75 => 0x0, 76 => 0x0 },
	'setbuttonwhenshooting' => { 70 => 0x1, 72 => 0x704, 78 => 0xc },
	'setfunctionwhenshooting' => { 73 => 0x0, 74 => 0x1, 77 => 0x1 },
	'setting' => { 402 => 'setting' },
	'shadingcompensation' => { 242 => 0x50c, 262 => 0x8a },
	'shadingcompensation2' => { 246 => 0x1012 },
	'shadow' => { 326 => 0xe },
	'shadowcorrection' => { 295 => 0x79 },
	'shadowprotection' => { 221 => 0x0 },
	'shadows' => { 99 => 0xfe52, 381 => 'Shadows', 388 => 'Shadows' },
	'shadows2012' => { 388 => 'Shadows2012' },
	'shadowscale' => { 99 => 0xc633 },
	'shadowtint' => { 388 => 'ShadowTint' },
	'shadowtone' => { 104 => 0x1040 },
	'shakereduction' => { 296 => 0x1, 297 => 0x1 },
	'sharpendetail' => { 388 => 'SharpenDetail' },
	'sharpenedgemasking' => { 388 => 'SharpenEdgeMasking' },
	'sharpening' => { 264 => 0x300b },
	'sharpeningadj' => { 225 => 0x2b },
	'sharpenradius' => { 388 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 30 => 0xf, 64 => 0x2, 94 => 0xb, 95 => [0x3011,0x21], 99 => [0xa40a,0xfe56], 104 => 0x1001, 115 => 0x6b, 124 => 0x37, 129 => 'Sharpness', 151 => 0x21, 152 => 0x30, 153 => 0x26, 154 => 0x18, 159 => 0x3, 186 => 0x6, 188 => 0x32, 247 => 0x100f, 262 => 0x41, 295 => 0x21, 301 => 0xb, 313 => 0x26, 316 => 0x22, 317 => [0x1003,0x1014], 326 => 0x11, 334 => 0x1c, 335 => 0x19, 346 => 0x2006, 369 => 0x52, 388 => 'Sharpness', 392 => 'Sharpness' },
	'sharpnessadj' => { 90 => 0x25a, 373 => 0x801a },
	'sharpnessauto' => { 61 => 0x94 },
	'sharpnessfactor' => { 247 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 60 => 0x64, 61 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 64 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 60 => 0x34, 61 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 60 => 0x7c, 61 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 60 => 0x4c, 61 => 0x4c },
	'sharpnessovershoot' => { 373 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 60 => 0x1c, 61 => 0x1c },
	'sharpnesssetting' => { 242 => 0x506, 250 => 0x1013, 336 => 0x12, 350 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 60 => 0x4, 61 => 0x4 },
	'sharpnessthreshold' => { 373 => 0x801d },
	'sharpnessundershoot' => { 373 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 60 => 0x94, 61 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 60 => 0xac, 61 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 60 => 0xc4, 61 => 0xdc },
	'shootid' => { 402 => 'shootID' },
	'shootinginfodisplay' => { 229 => '13.2', 230 => '5.1', 235 => '10.2', 236 => '4.1', 239 => '5.1', 240 => '5.3' },
	'shootinginfomonitorofftime' => { 229 => '26.2', 230 => '22.2', 235 => '9.1', 236 => '21.2', 239 => '22.2', 240 => '22.2' },
	'shootingmode' => { 129 => 'ShootingMode', 186 => 0x89, 262 => 0x1f },
	'shootingmodesetting' => { 231 => '5.1' },
	'shortdescription' => { 390 => 'shortdescription' },
	'shortdocumentid' => { 107 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 72 => 0x80d },
	'shotdate' => { 413 => 'shotDate' },
	'shotday' => { 413 => 'shotDay' },
	'shotlocation' => { 413 => 'shotLocation' },
	'shotname' => { 413 => 'shotName' },
	'shotnumber' => { 413 => 'shotNumber' },
	'shotnumbersincepowerup' => { 349 => 0x44e, 361 => 0x1a, 362 => 0x16, 363 => 0xa },
	'shotnumbersincepowerup2' => { 336 => 0x200 },
	'shotsize' => { 413 => 'shotSize' },
	'shutter-aelock' => { 70 => 0x4, 72 => 0x701, 73 => 0x3, 74 => 0x4, 75 => 0x3, 76 => 0x3, 77 => 0x4, 78 => 0x2 },
	'shutteraelbutton' => { 71 => 0x4 },
	'shutterbuttonafonbutton' => { 72 => 0x701 },
	'shuttercount' => { 10 => 0x176, 48 => 0x1, 186 => 0xa7, 193 => [0x6a,0x157,0x24d], 194 => 0x286, 195 => 0x279, 196 => 0x284, 197 => 0x242, 198 => 0x280, 199 => 0x276, 200 => [0x27d,0x27f], 201 => 0x246, 203 => 0x2d6, 204 => 0x321, 205 => 0xbd8, 206 => 0x287, 207 => 0x320, 208 => 0x24a, 209 => 0x5fb, 211 => 0x2d5, 295 => 0x5d, 345 => 0x846, 348 => [0x125,0x14a] },
	'shuttercurtainsync' => { 70 => 0xf, 71 => 0xf, 72 => 0x305, 73 => 0xe, 74 => 0xf, 75 => 0x8, 76 => 0x8, 77 => 0xf, 78 => 0x8 },
	'shuttermode' => { 115 => 0x1b },
	'shutterreleasebuttonae-l' => { 229 => '17.7', 230 => '18.4', 232 => '16.1', 233 => '17.1', 234 => '17.1', 235 => '7.1', 236 => '17.5', 239 => '18.4', 240 => '18.2' },
	'shutterreleasemethod' => { 85 => 0x1010 },
	'shutterreleasenocfcard' => { 70 => 0x2, 71 => 0x2, 78 => 0xf },
	'shutterreleasetiming' => { 85 => 0x1011 },
	'shutterreleasewithoutlens' => { 72 => 0x711 },
	'shutterspeedlock' => { 230 => '38.1', 239 => '38.1' },
	'shutterspeedrange' => { 72 => 0x10c },
	'shutterspeedsetting' => { 154 => 0x6, 334 => 0x2f, 335 => 0x28, 336 => 0x0 },
	'shutterspeedvalue' => { 81 => 0x1, 99 => 0x9201, 247 => 0x1000, 392 => 'ShutterSpeedValue' },
	'shuttertype' => { 104 => 0x1050, 262 => 0x9f },
	'sidecarforextension' => { 400 => 'SidecarForExtension' },
	'similarityindex' => { 107 => 0xe4 },
	'singleframebracketing' => { 154 => 0x21 },
	'skilllevel' => { 405 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 295 => 0x20b },
	'slideshowname' => { 402 => 'slideshowName' },
	'slideshownumber' => { 402 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 402 => 'slideshowTotalNumber' },
	'slowshutter' => { 66 => 0x8 },
	'slowsync' => { 104 => 0x1030 },
	'smartrange' => { 323 => 0xa012 },
	'smileshutter' => { 336 => 0x31 },
	'smileshuttermode' => { 336 => 0x27 },
	'smoothness' => { 99 => 0xfe57, 388 => 'Smoothness' },
	'softskineffect' => { 346 => 0x200f },
	'software' => { 99 => 0x131, 130 => 'Software', 254 => 'Software', 326 => 0x18, 409 => 'Software' },
	'softwareversion' => { 325 => 0x207 },
	'sonydatetime' => { 352 => 0x6, 354 => 0x1b6, 355 => 0x210, 356 => 0x1fe, 357 => 0x22c },
	'sonydatetime2' => { 360 => 0x51 },
	'sonyexposuretime' => { 360 => 0x3a },
	'sonyexposuretime2' => { 369 => 0xe },
	'sonyfnumber' => { 360 => 0x3c, 369 => 0x14 },
	'sonyimageheight' => { 352 => 0x1a, 361 => 0x44, 362 => 0x3f, 363 => 0x47 },
	'sonyimagesize' => { 154 => 0x3b, 334 => 0x54, 335 => 0x54, 336 => 0x9 },
	'sonyimagewidth' => { 352 => 0x1c },
	'sonyiso' => { 354 => 0x1218, 355 => 0x11f4, 356 => 0x1270, 357 => [0x1254,0x1258,0x1280], 358 => 0x113c, 359 => 0x344, 369 => 0x4 },
	'sonymaxaperturevalue' => { 369 => 0x16 },
	'sonymodelid' => { 346 => 0xb001 },
	'sonyquality' => { 154 => 0x3c },
	'source' => { 107 => 0x73, 254 => 'Source', 389 => 'source', 390 => 'source', 400 => 'Source' },
	'sourcedirectoryindex' => { 282 => 0x0 },
	'sourcefileindex' => { 282 => 0x2 },
	'sourcephotoscount' => { 377 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 392 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 392 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 392 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 392 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 392 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 413 => 'speakerPlacement' },
	'specialeffectlevel' => { 95 => 0x3030 },
	'specialeffectmode' => { 95 => 0x2076 },
	'specialeffectsetting' => { 95 => 0x3031 },
	'specialinstructions' => { 107 => 0x28 },
	'specialmode' => { 247 => 0x200, 325 => 0x200 },
	'specialoccasion' => { 405 => 'specialOccasion' },
	'spectralsensitivity' => { 99 => 0x8824, 392 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 37 => [0x2b9,0x2d0,0x2d4], 39 => 0x1e4, 40 => [0x1fd,0x2dd], 41 => 0x30f },
	'splittoningbalance' => { 388 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 388 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 388 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 388 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 388 => 'SplitToningShadowSaturation' },
	'sport' => { 403 => 'sport' },
	'spotfocuspointx' => { 151 => 0x2d },
	'spotfocuspointy' => { 151 => 0x2e },
	'spotmeteringmode' => { 30 => 0x27 },
	'spotmeterlinktoafpoint' => { 72 => 0x107 },
	'sractive' => { 276 => '17.1' },
	'srawquality' => { 30 => 0x2e },
	'srfocallength' => { 296 => 0x3 },
	'srhalfpresstime' => { 296 => 0x2 },
	'srresult' => { 296 => 0x0, 297 => 0x0 },
	'standardoutputhighlightpoint' => { 91 => 0x14 },
	'standardoutputsensitivity' => { 99 => 0x8831, 393 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 91 => 0x15 },
	'standardrawcolortone' => { 91 => 0xd },
	'standardrawcontrast' => { 91 => 0xf },
	'standardrawhighlight' => { 91 => 0x75 },
	'standardrawhighlightpoint' => { 91 => 0x12 },
	'standardrawlinear' => { 91 => 0x10 },
	'standardrawsaturation' => { 91 => 0xe },
	'standardrawshadow' => { 91 => 0x7e },
	'standardrawshadowpoint' => { 91 => 0x13 },
	'standardrawsharpness' => { 91 => 0x11 },
	'standardunsharpmaskfineness' => { 91 => 0x94 },
	'standardunsharpmaskstrength' => { 91 => 0x92 },
	'standardunsharpmaskthreshold' => { 91 => 0x96 },
	'standbytimer' => { 230 => '19.1', 234 => '18.1', 239 => '19.1' },
	'startingpage' => { 403 => 'startingPage' },
	'startmovieshooting' => { 72 => 0x70d },
	'starttimecode' => { 413 => 'startTimecode' },
	'starttimecodetimeformat' => { 413 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 413 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 413 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 413 => 'startTimeSampleSize' },
	'starttimescale' => { 413 => 'startTimeScale' },
	'state' => { 134 => 'State', 262 => 0x6b, 400 => 'State' },
	'status' => { 376 => 'Status', 380 => 'Status' },
	'stitchingsoftware' => { 377 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 353 => 0x113e, 354 => 0x113e, 355 => 0x111a, 356 => 0x1196, 357 => 0x1172, 358 => 0x102a, 359 => 0x222, 369 => 0xa },
	'storagemethod' => { 158 => 0x12 },
	'storebyorientation' => { 230 => '46.3', 239 => '47.3' },
	'straightenangle' => { 222 => 0x2fc08431 },
	'stretchmode' => { 413 => 'stretchMode' },
	'studydatetime' => { 375 => 'StudyDateTime' },
	'studydescription' => { 375 => 'StudyDescription' },
	'studyid' => { 375 => 'StudyID' },
	'studyphysician' => { 375 => 'StudyPhysician' },
	'sub-location' => { 107 => 0x5c },
	'subfiledata' => { 137 => 'data' },
	'subfiledirectory' => { 137 => '1Directory' },
	'subfilemimetype' => { 137 => '2MIME' },
	'subfilename' => { 137 => '1Name' },
	'subfileresource' => { 137 => 'rsrc' },
	'subfiletype' => { 99 => 0xfe, 137 => '0Type' },
	'subject' => { 251 => 'Subject', 308 => 'Subject', 389 => 'subject', 399 => 'Subject', 414 => 'subject' },
	'subjectarea' => { 99 => 0x9214, 392 => 'SubjectArea' },
	'subjectcode' => { 397 => 'SubjectCode' },
	'subjectdistance' => { 99 => 0x9206, 115 => 0x3e, 392 => 'SubjectDistance' },
	'subjectdistancerange' => { 99 => 0xa40c, 392 => 'SubjectDistanceRange' },
	'subjectlocation' => { 99 => 0xa214, 392 => 'SubjectLocation' },
	'subjectprogram' => { 151 => 0x22 },
	'subjectreference' => { 107 => 0xc },
	'sublabels4' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 396 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 396 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 99 => 0x9290 },
	'subsectimedigitized' => { 99 => 0x9292 },
	'subsectimeoriginal' => { 99 => 0x9291 },
	'subsection1' => { 403 => 'subsection1' },
	'subsection2' => { 403 => 'subsection2' },
	'subsection3' => { 403 => 'subsection3' },
	'subsection4' => { 403 => 'subsection4' },
	'subselector' => { 230 => '49.1' },
	'subselectorassignment' => { 230 => '48.1' },
	'subselectorplusdials' => { 230 => '49.2' },
	'subtitle' => { 403 => 'subtitle' },
	'subversionfilename' => { 396 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 396 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 396 => 'SubVersions' },
	'superimposeddisplay' => { 70 => 0xa, 72 => 0x510, 73 => 0x9, 74 => 0xa, 77 => 0xa, 78 => 0xe },
	'supermacro' => { 54 => 0x1a },
	'supplementalcategories' => { 107 => 0x14, 400 => 'SupplementalCategories' },
	'supplementaltype' => { 109 => 0x37 },
	'supplementdisplayid' => { 403 => 'supplementDisplayID' },
	'supplementstartingpage' => { 403 => 'supplementStartingPage' },
	'supplementtitle' => { 403 => 'supplementTitle' },
	'svisosetting' => { 276 => 0x14 },
	'sweeppanoramadirection' => { 262 => 0x93, 336 => 0x33 },
	'sweeppanoramafieldofview' => { 262 => 0x94 },
	'sweeppanoramasize' => { 336 => 0x32 },
	'switchtoregisteredafpoint' => { 71 => 0x12, 72 => 0x50a },
	'tagged' => { 303 => 0xdd, 304 => 'Tagged', 382 => 'tagged' },
	'tagslist' => { 391 => 'TagsList' },
	'tagstructure' => { 396 => 'TagStructure' },
	'takenumber' => { 413 => 'takeNumber' },
	'tapename' => { 413 => 'tapeName' },
	'targetaperture' => { 66 => 0x4 },
	'targetcompressionratio' => { 83 => 0x1 },
	'targetdistancesetting' => { 85 => 0x1807 },
	'targetexposuretime' => { 66 => 0x5 },
	'targetimagetype' => { 85 => 0x100a },
	'taxon' => { 98 => 'Taxon' },
	'taxonacceptednameusage' => { 98 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 98 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 98 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 98 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 98 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 98 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 98 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 98 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 98 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 98 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 98 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 98 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 98 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 98 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 98 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 98 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 98 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 98 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 98 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 98 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 98 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 98 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 98 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 98 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 98 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 98 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 98 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 98 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 98 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 98 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 98 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 98 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 98 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 403 => 'teaser' },
	'teleconverter' => { 156 => 0x105, 346 => 0x105 },
	'tempo' => { 413 => 'tempo' },
	'termsandconditionstext' => { 401 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 401 => 'TermsAndConditionsURL' },
	'testname' => { 100 => 'TestName' },
	'textencoding' => { 185 => 0x4 },
	'textlayername' => { 400 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 400 => 'TextLayers' },
	'textlayertext' => { 400 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 262 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 99 => 0x107 },
	'thumbnailfilename' => { 85 => 0x817 },
	'thumbnailformat' => { 411 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 117 => 0xfa55, 411 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 85 => 0x2008, 96 => 'ThumbnailImage', 102 => 0x3, 140 => 'data', 247 => 0x100, 411 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 140 => '1Name' },
	'thumbnailimagesize' => { 140 => 'ImageSize' },
	'thumbnailimagetype' => { 140 => '0Type' },
	'thumbnailimagevalidarea' => { 54 => 0x13 },
	'thumbnaillength' => { 99 => 0x202 },
	'thumbnailoffset' => { 99 => 0x201 },
	'thumbnails' => { 411 => 'Thumbnails' },
	'thumbnailwidth' => { 117 => 0xfa54, 411 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 403 => 'ticker' },
	'tiffmeteringimage' => { 157 => 0x104c, 345 => 0x1110 },
	'tilelength' => { 99 => 0x143 },
	'tilewidth' => { 99 => 0x142 },
	'time' => { 113 => 0x401, 295 => 0x7 },
	'timecodes' => { 99 => 0xc763 },
	'timecreated' => { 107 => 0x3c, 115 => 0x14, 124 => 0x10, 304 => 'TimeCreated' },
	'timeperiod' => { 403 => 'timePeriod' },
	'timerfunctionbutton' => { 231 => '5.2', 232 => '12.1', 233 => '13.1' },
	'timerlength' => { 72 => 0x80c },
	'timerrecording' => { 262 => 0x96 },
	'timescaleparams' => { 413 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 413 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 413 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 413 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 108 => 0x50 },
	'timesignature' => { 413 => 'timeSignature' },
	'timesincepoweron' => { 262 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 241 => 0x8, 254 => 'TimeStamp', 383 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 67 => 0x1, 214 => 0x0 },
	'timezonecity' => { 67 => 0x2 },
	'timezonecode' => { 88 => 0x1 },
	'timezoneinfo' => { 88 => 0x2 },
	'timezoneoffset' => { 99 => 0x882a },
	'tint' => { 388 => 'Tint' },
	'title' => { 130 => 'Title', 251 => 'Title', 254 => 'Title', 262 => 0x65, 308 => 'Title', 389 => 'title', 399 => 'Title', 411 => 'Title' },
	'tonecomp' => { 186 => 0x81 },
	'tonecurve' => { 64 => 0x1, 295 => 0x402, 388 => 'ToneCurve' },
	'tonecurveactive' => { 90 => 0x110 },
	'tonecurveadobergb' => { 323 => 0xa043 },
	'tonecurveadobergbdefault' => { 323 => 0xa041 },
	'tonecurveblue' => { 388 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 373 => 0x9003 },
	'tonecurvebluey' => { 373 => 0x9007 },
	'tonecurvebrightnessx' => { 373 => 0x9000 },
	'tonecurvebrightnessy' => { 373 => 0x9004 },
	'tonecurvefilename' => { 113 => 0x1391 },
	'tonecurvegreen' => { 388 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 373 => 0x9002 },
	'tonecurvegreeny' => { 373 => 0x9006 },
	'tonecurveinterpolation' => { 90 => 0x159 },
	'tonecurvemode' => { 90 => 0x113 },
	'tonecurvename' => { 388 => 'ToneCurveName' },
	'tonecurvename2012' => { 388 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 90 => 0x3c },
	'tonecurvepv2012' => { 388 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 388 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 388 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 388 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 388 => 'ToneCurveRed' },
	'tonecurveredx' => { 373 => 0x9001 },
	'tonecurveredy' => { 373 => 0x9005 },
	'tonecurves' => { 295 => 0x403 },
	'tonecurvesrgb' => { 323 => 0xa042 },
	'tonecurvesrgbdefault' => { 323 => 0xa040 },
	'tonelevel' => { 242 => 0x52e },
	'toningeffect' => { 48 => 0xf, 186 => 0xb3, 188 => 0x38, 317 => 0x1015 },
	'toningeffectauto' => { 61 => 0xa4 },
	'toningeffectfaithful' => { 60 => 0x74, 61 => 0x74 },
	'toningeffectlandscape' => { 60 => 0x44, 61 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 60 => 0x8c, 61 => 0x8c },
	'toningeffectneutral' => { 60 => 0x5c, 61 => 0x5c },
	'toningeffectportrait' => { 60 => 0x2c, 61 => 0x2c },
	'toningeffectstandard' => { 60 => 0x14, 61 => 0x14 },
	'toningeffectuserdef1' => { 60 => 0xa4, 61 => 0xbc },
	'toningeffectuserdef2' => { 60 => 0xbc, 61 => 0xd4 },
	'toningeffectuserdef3' => { 60 => 0xd4, 61 => 0xec },
	'toningsaturation' => { 188 => 0x39 },
	'totalzoom' => { 115 => 0x62 },
	'touchae' => { 262 => 0xab },
	'trackcreatedate' => { 312 => 0x1 },
	'trackmodifydate' => { 312 => 0x2 },
	'tracknumber' => { 413 => 'trackNumber' },
	'tracks' => { 413 => 'Tracks' },
	'tracksframerate' => { 413 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 413 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 413 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 413 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 413 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 413 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 413 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 413 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 413 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 413 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 413 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 413 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 413 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 413 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 413 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 413 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 413 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 137 => 'zmie' },
	'transferfunction' => { 99 => 0x12d, 409 => 'TransferFunction' },
	'transform' => { 262 => [0x8012,0x59] },
	'transmissionreference' => { 400 => 'TransmissionReference' },
	'trapped' => { 251 => 'Trapped', 399 => 'Trapped' },
	'trashbuttonfunction' => { 72 => 0x710 },
	'travelday' => { 262 => 0x36 },
	'triggermode' => { 313 => 0x6 },
	'tstop' => { 99 => 0xc772 },
	'ttl_da_adown' => { 283 => 0x5 },
	'ttl_da_aup' => { 283 => 0x4 },
	'ttl_da_bdown' => { 283 => 0x7 },
	'ttl_da_bup' => { 283 => 0x6 },
	'tungstenawb' => { 273 => 0x1 },
	'tvexposuretimesetting' => { 276 => 0x12 },
	'type' => { 389 => 'type', 408 => 'type' },
	'typestatus' => { 98 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 99 => 0xc614 },
	'uniquedocumentid' => { 107 => 0xbb },
	'uniqueobjectname' => { 108 => 0x64 },
	'unknownblock' => { 295 => 0x405 },
	'unknownblock1' => { 246 => 0x635 },
	'unknownblock2' => { 246 => 0x636 },
	'unknownblock3' => { 246 => 0x1103 },
	'unknownblock4' => { 246 => 0x1104 },
	'unknowncontrast' => { 91 => 0x45 },
	'unknownev' => { 113 => 0x1 },
	'unknownlinear' => { 91 => 0x46 },
	'unknownnumber' => { 85 => 0x180b },
	'unknownoutputhighlightpoint' => { 91 => 0x4a },
	'unknownoutputshadowpoint' => { 91 => 0x4b },
	'unknownrawhighlight' => { 91 => 0x7b },
	'unknownrawhighlightpoint' => { 91 => 0x48 },
	'unknownrawshadow' => { 91 => 0x84 },
	'unknownrawshadowpoint' => { 91 => 0x49 },
	'unknownsharpness' => { 91 => 0x47 },
	'unknowntemperature' => { 101 => 0x4 },
	'unsharp1color' => { 227 => 0x13 },
	'unsharp1halowidth' => { 227 => 0x19 },
	'unsharp1intensity' => { 227 => 0x17 },
	'unsharp1threshold' => { 227 => 0x1b },
	'unsharp2color' => { 227 => 0x2e },
	'unsharp2halowidth' => { 227 => 0x34 },
	'unsharp2intensity' => { 227 => 0x32 },
	'unsharp2threshold' => { 227 => 0x36 },
	'unsharp3color' => { 227 => 0x49 },
	'unsharp3halowidth' => { 227 => 0x4f },
	'unsharp3intensity' => { 227 => 0x4d },
	'unsharp3threshold' => { 227 => 0x51 },
	'unsharp4color' => { 227 => 0x64 },
	'unsharp4halowidth' => { 227 => 0x6a },
	'unsharp4intensity' => { 227 => 0x68 },
	'unsharp4threshold' => { 227 => 0x6c },
	'unsharpcount' => { 227 => 0x0 },
	'unsharpmask' => { 91 => 0x90, 222 => 0x76a43200 },
	'uprightcentermode' => { 388 => 'UprightCenterMode' },
	'uprightcenternormx' => { 388 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 388 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 388 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 388 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 388 => 'UprightFocalMode' },
	'uprightpreview' => { 388 => 'UprightPreview' },
	'uprighttransform_0' => { 388 => 'UprightTransform_0' },
	'uprighttransform_1' => { 388 => 'UprightTransform_1' },
	'uprighttransform_2' => { 388 => 'UprightTransform_2' },
	'uprighttransform_3' => { 388 => 'UprightTransform_3' },
	'uprighttransform_4' => { 388 => 'UprightTransform_4' },
	'uprighttransformcount' => { 388 => 'UprightTransformCount' },
	'uprightversion' => { 388 => 'UprightVersion' },
	'urgency' => { 107 => 0xa, 400 => 'Urgency' },
	'url' => { 130 => 'URL', 254 => 'URL', 306 => 0x40b, 403 => 'url' },
	'urla-platform' => { 403 => [\'url','urlA-platform'] },
	'urlurl' => { 403 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 72 => 0x10a },
	'usableshootingmodes' => { 72 => 0x109 },
	'usage' => { 404 => 'usage' },
	'usageterms' => { 417 => 'UsageTerms' },
	'useguidelines' => { 385 => 'useGuidelines' },
	'usepanoramaviewer' => { 377 => 'UsePanoramaViewer' },
	'usercomment' => { 85 => 0x805, 99 => 0x9286, 392 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 60 => 0xd8, 61 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 60 => 0xda, 61 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 60 => 0xdc, 61 => 0xf4 },
	'userfields' => { 380 => 'UserFields' },
	'userlabel' => { 313 => 0x2b },
	'userprofile' => { 258 => 0x302, 264 => 0x3038 },
	'usmlenselectronicmf' => { 71 => 0x7, 72 => 0x501 },
	'uspsnumber' => { 403 => 'uspsNumber' },
	'utmeasting' => { 141 => 'Easting' },
	'utmmapdatum' => { 141 => 'Datum' },
	'utmnorthing' => { 141 => 'Northing' },
	'utmzone' => { 141 => 'Zone' },
	'uv-irfiltercorrection' => { 258 => 0x325 },
	'validbits' => { 246 => 0x611, 247 => 0x102c },
	'validpixeldepth' => { 250 => 0x611 },
	'variousmodes' => { 115 => 0x26 },
	'variousmodes2' => { 115 => 0x3a },
	'variprogram' => { 186 => 0xab },
	'version' => { 104 => 0x0, 308 => 'Version', 388 => 'Version' },
	'versioncreatedate' => { 373 => 0xd100 },
	'versionid' => { 414 => 'VersionID' },
	'versionidentifier' => { 403 => 'versionIdentifier' },
	'versionmodifydate' => { 373 => 0xd101 },
	'versions' => { 414 => 'Versions' },
	'versionscomments' => { 414 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 414 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 414 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 414 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 414 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 414 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 414 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 414 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 414 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 414 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 414 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 229 => '3.2', 230 => '47.2' },
	'verticalfuncbutton' => { 230 => '42.2' },
	'verticalfuncbuttonplusdials' => { 230 => '43.1' },
	'verticalmultiselector' => { 230 => '42.1' },
	'vfdisplayillumination' => { 72 => 0x510 },
	'vibrance' => { 381 => 'Vibrance', 388 => 'Vibrance' },
	'vibrationreduction' => { 193 => [0x75,0x82,0x1ae], 201 => '586.1', 208 => '590.2', 213 => 0x4 },
	'videoalphamode' => { 413 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 413 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 413 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 413 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 57 => 0x74 },
	'videocolorspace' => { 413 => 'videoColorSpace' },
	'videocompressor' => { 413 => 'videoCompressor' },
	'videofieldorder' => { 413 => 'videoFieldOrder' },
	'videoframerate' => { 413 => 'videoFrameRate' },
	'videoframesize' => { 413 => 'videoFrameSize' },
	'videoframesizeh' => { 413 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 413 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 413 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 413 => 'videoModDate' },
	'videopixelaspectratio' => { 413 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 413 => 'videoPixelDepth' },
	'videoquality' => { 95 => 0x4003 },
	'viewfinderdisplay' => { 229 => '12.4', 230 => '6.3' },
	'viewfinderwarning' => { 229 => '13.4', 236 => '3.5', 237 => '6.2', 240 => '4.4' },
	'viewfinderwarnings' => { 72 => 0x40a },
	'viewinfoduringexposure' => { 72 => 0x407 },
	'viewingmode' => { 336 => 0x2f, 350 => 0x18 },
	'viewingmode2' => { 336 => [0x85,0x285] },
	'viewpoint' => { 402 => 'viewpoint' },
	'vignetteamount' => { 388 => 'VignetteAmount' },
	'vignettecontrol' => { 186 => 0x2a, 222 => 0x76a43205 },
	'vignettecontrolintensity' => { 222 => 0xac6bd5c0 },
	'vignettemidpoint' => { 388 => 'VignetteMidpoint' },
	'vignetting' => { 317 => 0x1011, 323 => 0xa052 },
	'vignettingcorrection' => { 285 => 0x2, 323 => 0xa053, 346 => 0x2011 },
	'vignettingsetting' => { 323 => 0xa054 },
	'visualtechnique' => { 402 => 'visualTechnique' },
	'voicememo' => { 325 => 0x216 },
	'volume' => { 403 => 'volume' },
	'vr_0x66' => { 193 => 0x66 },
	'vrdoffset' => { 54 => 0xd0 },
	'vrmode' => { 213 => 0x6 },
	'wb_bluelevel3500k' => { 157 => 0x19a },
	'wb_bluelevel6500k' => { 157 => 0x18a },
	'wb_bluelevelcustom' => { 157 => 0x18e },
	'wb_bluelevelscloudy' => { 157 => 0x106 },
	'wb_bluelevelsdaylight' => { 157 => 0xea },
	'wb_bluelevelsflash' => { 157 => 0x122 },
	'wb_bluelevelsfluorescent' => { 157 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 157 => 0x254 },
	'wb_bluelevelsshade' => { 157 => 0x176 },
	'wb_bluelevelstungsten' => { 157 => 0xce },
	'wb_gbrglevels' => { 157 => 0xae, 160 => 0x4 },
	'wb_glevel' => { 246 => 0x11f },
	'wb_glevel3000k' => { 246 => 0x113 },
	'wb_glevel3300k' => { 246 => 0x114 },
	'wb_glevel3600k' => { 246 => 0x115 },
	'wb_glevel3900k' => { 246 => 0x116 },
	'wb_glevel4000k' => { 246 => 0x117 },
	'wb_glevel4300k' => { 246 => 0x118 },
	'wb_glevel4500k' => { 246 => 0x119 },
	'wb_glevel4800k' => { 246 => 0x11a },
	'wb_glevel5300k' => { 246 => 0x11b },
	'wb_glevel6000k' => { 246 => 0x11c },
	'wb_glevel6600k' => { 246 => 0x11d },
	'wb_glevel7500k' => { 246 => 0x11e },
	'wb_grbglevels' => { 169 => 0x0 },
	'wb_rbgglevels' => { 166 => 0x0 },
	'wb_rblevels' => { 186 => 0xc, 246 => 0x100 },
	'wb_rblevels1' => { 267 => 0x2 },
	'wb_rblevels2' => { 267 => 0x5 },
	'wb_rblevels3' => { 267 => 0x8 },
	'wb_rblevels3000k' => { 246 => 0x102 },
	'wb_rblevels3300k' => { 246 => 0x103 },
	'wb_rblevels3500k' => { 157 => 0x430 },
	'wb_rblevels3600k' => { 246 => 0x104 },
	'wb_rblevels3900k' => { 246 => 0x105 },
	'wb_rblevels4' => { 267 => 0xb },
	'wb_rblevels4000k' => { 246 => 0x106 },
	'wb_rblevels4300k' => { 246 => 0x107 },
	'wb_rblevels4500k' => { 246 => 0x108 },
	'wb_rblevels4800k' => { 246 => 0x109 },
	'wb_rblevels5' => { 267 => 0xe },
	'wb_rblevels5300k' => { 246 => 0x10a },
	'wb_rblevels6' => { 267 => 0x11 },
	'wb_rblevels6000k' => { 246 => 0x10b },
	'wb_rblevels6500k' => { 157 => 0x420 },
	'wb_rblevels6600k' => { 246 => 0x10c },
	'wb_rblevels7' => { 267 => 0x14 },
	'wb_rblevels7500k' => { 246 => 0x10d },
	'wb_rblevelsauto' => { 250 => 0x110 },
	'wb_rblevelscloudy' => { 157 => 0x3f0, 159 => 0x10, 250 => 0x121 },
	'wb_rblevelscoolwhitef' => { 157 => 0x308, 159 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 250 => 0x132 },
	'wb_rblevelscustom' => { 157 => 0x424 },
	'wb_rblevelscwb1' => { 246 => 0x10e },
	'wb_rblevelscwb2' => { 246 => 0x10f },
	'wb_rblevelscwb3' => { 246 => 0x110 },
	'wb_rblevelscwb4' => { 246 => 0x111 },
	'wb_rblevelsdaylight' => { 157 => [0x3ec,0x528], 159 => 0xc },
	'wb_rblevelsdaylightf' => { 159 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 250 => 0x130 },
	'wb_rblevelsdaywhitef' => { 159 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 250 => 0x131 },
	'wb_rblevelseveningsunlight' => { 250 => 0x124 },
	'wb_rblevelsfineweather' => { 250 => 0x122 },
	'wb_rblevelsflash' => { 157 => [0x3f4,0x304], 159 => 0x18 },
	'wb_rblevelsshade' => { 157 => 0x418, 159 => 0x20, 250 => 0x120 },
	'wb_rblevelstungsten' => { 157 => 0x3e8, 159 => 0x8, 250 => 0x123 },
	'wb_rblevelsunknown' => { 159 => 0x1c },
	'wb_rblevelsused' => { 250 => 0x100 },
	'wb_rblevelswhitef' => { 159 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 250 => 0x133 },
	'wb_redlevel3500k' => { 157 => 0x198 },
	'wb_redlevel6500k' => { 157 => 0x188 },
	'wb_redlevelcustom' => { 157 => 0x18c },
	'wb_redlevelscloudy' => { 157 => 0xf8 },
	'wb_redlevelsdaylight' => { 157 => 0xdc },
	'wb_redlevelsflash' => { 157 => 0x114 },
	'wb_redlevelsfluorescent' => { 157 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 157 => 0x1be },
	'wb_redlevelsshade' => { 157 => 0x168 },
	'wb_redlevelstungsten' => { 157 => 0xc0 },
	'wb_rgbglevels' => { 168 => 0x0 },
	'wb_rgblevels' => { 157 => [0x546,0x96], 259 => 0xd, 260 => 0x413, 264 => 0x3036, 353 => 0x117c, 354 => 0x1180, 355 => 0x115c, 356 => 0x11d8, 357 => 0x11b4, 358 => 0x106c, 359 => 0x264 },
	'wb_rgblevels1' => { 268 => 0x2 },
	'wb_rgblevels2' => { 268 => 0x6 },
	'wb_rgblevels3' => { 268 => 0xa },
	'wb_rgblevels4' => { 268 => 0xe },
	'wb_rgblevels5' => { 268 => 0x12 },
	'wb_rgblevels6' => { 268 => 0x16 },
	'wb_rgblevels7' => { 268 => 0x1a },
	'wb_rggbblacklevels' => { 31 => 0x25 },
	'wb_rggblevels' => { 160 => 0x4, 167 => 0x0 },
	'wb_rggblevelsasshot' => { 33 => 0x0, 34 => 0x19, 35 => 0x22, 36 => 0x3f, 39 => 0x3f, 40 => 0x3f, 41 => 0x3f },
	'wb_rggblevelsauto' => { 31 => 0x1, 33 => 0x5, 34 => 0x1e, 35 => 0x18, 36 => 0x44, 39 => 0x44, 40 => 0x44, 41 => 0x44, 323 => 0xa022 },
	'wb_rggblevelsblack' => { 323 => 0xa028 },
	'wb_rggblevelscloudy' => { 31 => 0xd, 33 => 0x1e, 34 => 0x2d, 35 => 0x31, 36 => 0x58, 39 => 0x71, 40 => 0x8a, 41 => 0x8f, 295 => 0x20f, 302 => 0x14 },
	'wb_rggblevelscustom' => { 31 => 0x1d, 36 => 0x80 },
	'wb_rggblevelscustom1' => { 34 => 0x41 },
	'wb_rggblevelscustom2' => { 34 => 0x46 },
	'wb_rggblevelsdaylight' => { 31 => 0x5, 33 => 0x14, 34 => 0x23, 35 => 0x27, 36 => 0x4e, 39 => 0x67, 40 => 0x80, 41 => 0x85, 295 => 0x20d, 302 => 0x2 },
	'wb_rggblevelsflash' => { 31 => 0x19, 33 => 0x32, 34 => 0x3c, 35 => 0x45, 36 => 0x6c, 39 => 0x85, 40 => 0x9e, 41 => 0xa3, 295 => 0x214, 302 => 0x41 },
	'wb_rggblevelsfluorescent' => { 31 => 0x15, 33 => 0x28, 34 => 0x37, 35 => 0x3b, 36 => 0x62, 39 => 0x7b, 40 => 0x94, 41 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 295 => 0x211, 302 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 302 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 295 => 0x212, 302 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 295 => 0x213, 302 => 0x38 },
	'wb_rggblevelsilluminator1' => { 323 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 323 => 0xa024 },
	'wb_rggblevelskelvin' => { 31 => 0x21, 33 => 0x2d, 35 => 0x40, 36 => 0x67, 39 => 0x80, 40 => 0x99, 41 => 0x9e },
	'wb_rggblevelsmeasured' => { 33 => 0xa, 36 => 0x49, 39 => 0x49, 40 => 0x49, 41 => 0x49 },
	'wb_rggblevelspc1' => { 35 => 0x90, 36 => 0x71 },
	'wb_rggblevelspc2' => { 35 => 0x95, 36 => 0x76 },
	'wb_rggblevelspc3' => { 35 => 0x9a, 36 => 0x7b },
	'wb_rggblevelsshade' => { 31 => 0x9, 33 => 0x19, 34 => 0x28, 35 => 0x2c, 36 => 0x53, 39 => 0x6c, 40 => 0x85, 41 => 0x8a, 295 => 0x20e, 302 => 0xb },
	'wb_rggblevelstungsten' => { 31 => 0x11, 33 => 0x23, 34 => 0x32, 35 => 0x36, 36 => 0x5d, 39 => 0x76, 40 => 0x8f, 41 => 0x94, 295 => 0x210, 302 => 0x1d },
	'wb_rggblevelsuncorrected' => { 323 => 0xa021 },
	'wb_rggblevelsunknown' => { 33 => 0xf, 35 => 0x1d, 39 => 0x4e, 40 => 0x4e, 41 => 0x4e, 302 => 0x53 },
	'wb_rggblevelsunknown10' => { 33 => 0x5f, 35 => 0x72, 39 => 0x9e, 40 => 0x7b, 41 => 0x7b },
	'wb_rggblevelsunknown11' => { 33 => 0x64, 35 => 0x77, 39 => 0xa3, 40 => 0xa3, 41 => 0x80 },
	'wb_rggblevelsunknown12' => { 33 => 0x69, 35 => 0x7c, 39 => 0xa8, 40 => 0xa8, 41 => 0xa8 },
	'wb_rggblevelsunknown13' => { 33 => 0x6e, 35 => 0x81, 39 => 0xad, 40 => 0xad, 41 => 0xad },
	'wb_rggblevelsunknown14' => { 35 => 0x86, 39 => 0xb2, 40 => 0xb2, 41 => 0xb2 },
	'wb_rggblevelsunknown15' => { 35 => 0x8b, 39 => 0xb7, 40 => 0xb7, 41 => 0xb7 },
	'wb_rggblevelsunknown16' => { 35 => 0x9f, 40 => 0xbc, 41 => 0xbc },
	'wb_rggblevelsunknown17' => { 40 => 0xc1, 41 => 0xc1 },
	'wb_rggblevelsunknown18' => { 40 => 0xc6, 41 => 0xc6 },
	'wb_rggblevelsunknown19' => { 40 => 0xcb, 41 => 0xcb },
	'wb_rggblevelsunknown2' => { 33 => 0x37, 35 => 0x4a, 39 => 0x53, 40 => 0x53, 41 => 0x53 },
	'wb_rggblevelsunknown20' => { 40 => 0xd0, 41 => 0xd0 },
	'wb_rggblevelsunknown21' => { 41 => 0xd5 },
	'wb_rggblevelsunknown22' => { 41 => 0xda },
	'wb_rggblevelsunknown23' => { 41 => 0xdf },
	'wb_rggblevelsunknown24' => { 41 => 0xe4 },
	'wb_rggblevelsunknown25' => { 41 => 0xe9 },
	'wb_rggblevelsunknown26' => { 41 => 0xee },
	'wb_rggblevelsunknown27' => { 41 => 0xf3 },
	'wb_rggblevelsunknown28' => { 41 => 0xf8 },
	'wb_rggblevelsunknown29' => { 41 => 0xfd },
	'wb_rggblevelsunknown3' => { 33 => 0x3c, 35 => 0x4f, 39 => 0x58, 40 => 0x58, 41 => 0x58 },
	'wb_rggblevelsunknown30' => { 41 => 0x102 },
	'wb_rggblevelsunknown4' => { 33 => 0x41, 35 => 0x54, 39 => 0x5d, 40 => 0x5d, 41 => 0x5d },
	'wb_rggblevelsunknown5' => { 33 => 0x46, 35 => 0x59, 39 => 0x62, 40 => 0x62, 41 => 0x62 },
	'wb_rggblevelsunknown6' => { 33 => 0x4b, 35 => 0x5e, 39 => 0x8a, 40 => 0x67, 41 => 0x67 },
	'wb_rggblevelsunknown7' => { 33 => 0x50, 35 => 0x63, 39 => 0x8f, 40 => 0x6c, 41 => 0x6c },
	'wb_rggblevelsunknown8' => { 33 => 0x55, 35 => 0x68, 39 => 0x94, 40 => 0x71, 41 => 0x71 },
	'wb_rggblevelsunknown9' => { 33 => 0x5a, 35 => 0x6d, 39 => 0x99, 40 => 0x76, 41 => 0x76 },
	'wb_rggblevelsuserselected' => { 302 => 0x5c },
	'wbadjbluebalance' => { 228 => 0x8 },
	'wbadjcolortemp' => { 90 => 0x1a },
	'wbadjlighting' => { 228 => 0x14 },
	'wbadjmode' => { 228 => 0x10 },
	'wbadjredbalance' => { 228 => 0x0 },
	'wbadjrggblevels' => { 90 => 0x6 },
	'wbadjtemperature' => { 228 => 0x18 },
	'wbadjtint' => { 228 => 0x25 },
	'wbbluelevel' => { 258 => 0x324, 262 => 0x8006, 266 => 0x26 },
	'wbbracketmode' => { 48 => 0x9 },
	'wbbracketshotnumber' => { 157 => 0x2b, 317 => 0x101a },
	'wbbracketvalueab' => { 48 => 0xc },
	'wbbracketvaluegm' => { 48 => 0xd },
	'wbfinetuneactive' => { 90 => 0x24 },
	'wbfinetunesaturation' => { 90 => 0x28 },
	'wbfinetunetone' => { 90 => 0x2c },
	'wbgreenlevel' => { 258 => 0x323, 262 => 0x8005, 266 => 0x25 },
	'wbmediaimagesizesetting' => { 72 => 0x708 },
	'wbmode' => { 159 => 0x4, 247 => 0x1015 },
	'wbredlevel' => { 258 => 0x322, 262 => 0x8004, 266 => 0x24 },
	'wbscale' => { 160 => 0x0 },
	'wbshiftab' => { 64 => 0xc, 262 => 0x46, 277 => 0x10 },
	'wbshiftab_gm' => { 346 => 0x2014 },
	'wbshiftgm' => { 64 => 0xd, 262 => 0x47, 277 => 0x11 },
	'wbtype1' => { 267 => 0x1, 268 => 0x1 },
	'wbtype2' => { 267 => 0x4, 268 => 0x5 },
	'wbtype3' => { 267 => 0x7, 268 => 0x9 },
	'wbtype4' => { 267 => 0xa, 268 => 0xd },
	'wbtype5' => { 267 => 0xd, 268 => 0x11 },
	'wbtype6' => { 267 => 0x10, 268 => 0x15 },
	'wbtype7' => { 267 => 0x13, 268 => 0x19 },
	'webstatement' => { 417 => 'WebStatement' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 64 => 0x8, 66 => 0x7, 94 => 0x7, 95 => [0x19,0x2012], 99 => [0xa403,0xfe4e], 104 => 0x1002, 113 => 0x3fc, 114 => 0xfa0d, 115 => 0x40, 151 => 0x3, 152 => 0xe, 153 => 0x4, 154 => 0xb, 156 => 0x115, 186 => 0x5, 212 => 0x7, 258 => 0x304, 262 => 0x3, 264 => 0x3033, 295 => 0x19, 301 => 0x7, 316 => 0x26, 317 => 0x1003, 326 => [0x3c,0x7,0x58], 334 => 0xf, 335 => 0xe, 346 => [0x115,0xb054], 388 => 'WhiteBalance', 392 => 'WhiteBalance' },
	'whitebalance2' => { 242 => 0x500 },
	'whitebalanceadj' => { 90 => 0x18, 222 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 273 => 0x0 },
	'whitebalancebias' => { 95 => 0x2011, 247 => 0x304, 262 => 0x23 },
	'whitebalanceblue' => { 64 => 0x7 },
	'whitebalancebracket' => { 242 => 0x502, 247 => 0x303 },
	'whitebalancebracketing' => { 154 => 0x22, 157 => 0x2c, 345 => 0x2c },
	'whitebalancecomp' => { 250 => 0x1001 },
	'whitebalancefinetune' => { 104 => 0x100a, 154 => 0x38, 156 => 0x112, 186 => 0xb, 317 => 0x1004, 334 => 0x6, 335 => 0x5, 346 => 0x112 },
	'whitebalancemode' => { 295 => 0x1a },
	'whitebalancered' => { 64 => 0x6 },
	'whitebalanceset' => { 276 => 0xa },
	'whitebalancesetting' => { 154 => 0x23, 334 => 0x5, 335 => 0x4, 336 => 0x16, 350 => 0xd },
	'whitebalancetemperature' => { 242 => 0x501 },
	'whiteboard' => { 247 => 0x301 },
	'whitelevel' => { 99 => 0xc61d, 295 => 0x7e },
	'whitepoint' => { 99 => 0x13e, 295 => 0x201, 409 => 'WhitePoint' },
	'whites2012' => { 388 => 'Whites2012' },
	'wideadapter' => { 317 => 0x1017 },
	'widefocuszone' => { 151 => 0x2f },
	'widerange' => { 325 => 0x20f },
	'windowsatom' => { 387 => 'windowsAtom' },
	'windowsatomextension' => { 387 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 387 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 387 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 403 => 'wordCount' },
	'workcolorspace' => { 90 => 0x270 },
	'worktodo' => { 394 => 'WorkToDo' },
	'worldtimelocation' => { 262 => 0x3a, 295 => 0x22, 300 => '0.1' },
	'writer-editor' => { 107 => 0x7a },
	'x3filllight' => { 326 => 0x12 },
	'xml' => { 111 => 'xml ' },
	'xmp' => { 89 => 0xffff00f6, 100 => 'XMP' },
	'xmptoolkit' => { 410 => 'xmptk' },
	'xpauthor' => { 99 => 0x9c9d },
	'xpcomment' => { 99 => 0x9c9c },
	'xpkeywords' => { 99 => 0x9c9e },
	'xposition' => { 99 => 0x11e },
	'xpsubject' => { 99 => 0x9c9f },
	'xptitle' => { 99 => 0x9c9b },
	'xresolution' => { 99 => 0x11a, 110 => 0x3, 307 => 0x0, 409 => 'XResolution' },
	'xyresolution' => { 103 => 0x3 },
	'yawangle' => { 202 => 0x3513 },
	'ycbcrcoefficients' => { 99 => 0x211, 409 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 99 => 0x213, 409 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 99 => 0x212, 409 => 'YCbCrSubSampling' },
	'yearcreated' => { 115 => 0x10, 124 => 0xc },
	'yield' => { 405 => 'yield' },
	'yposition' => { 99 => 0x11f },
	'yresolution' => { 99 => 0x11b, 110 => 0x5, 307 => 0x4, 409 => 'YResolution' },
	'zonematching' => { 156 => 0x10a, 159 => [0x3a,0x4a], 346 => 0xb024 },
	'zonematchingmode' => { 154 => 0x14 },
	'zonematchingon' => { 153 => 0x75 },
	'zonematchingvalue' => { 334 => 0x1f },
	'zoomedpreviewlength' => { 247 => 0xf05 },
	'zoomedpreviewsize' => { 247 => 0xf06 },
	'zoomedpreviewstart' => { 247 => 0xf04 },
	'zoomsourcewidth' => { 30 => 0x24 },
	'zoomstepcount' => { 245 => 0x300, 247 => 0x100d },
	'zoomtargetwidth' => { 30 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'ab_uid' => 1,
	'abdate' => 1,
	'ablabel' => 1,
	'abovecolor' => 1,
	'abrelatednames' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acknowledged' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'action' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aim' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachment' => 1,
	'attachments' => 1,
	'attendee' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calendarscale' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercount' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecompleted' => 1,
	'datetimecreated' => 1,
	'datetimedue' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datetimestart' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exceptiondatetimes' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formattedname' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebusytime' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocation' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'icq' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'impp' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logo' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'method' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizer' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'percent-complete' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photo' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'recurrencedatetimes' => 1,
	'recurrenceid' => 1,
	'recurrencerule' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relatedto' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeat' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requeststatus' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'socialprofile' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'sound' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephone' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timetransparency' => 1,
	'timezoneid' => 1,
	'timezonename' => 1,
	'timezoneoffsetfrom' => 1,
	'timezoneoffsetto' => 1,
	'timezoneurl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'trigger' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vcalendarversion' => 1,
	'vcardversion' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2015, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
