<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2020 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class Fatdown extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function ba(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var ca=[""],da=[0,0,0],fa=["","t"],ha={flags:0},ia=["","id"],na={flags:514},oa=["","type"],pa={flags:3089},qa={flags:3201},ra=["","album_id"],ua=[32896,257,257],va=["","track_id"],wa=[32960,257,256],xa=[39819,65329,257],ya=[65424,65280,257],za=[65519,65313,257],Aa=[65519,65329,257],Ba=[65477,65281,257],Ca=[63463,65313,257],Da=[65408,65280,257],Ea=[65408,65288,257],Fa=["","playlist_id"],x={c:[],p:!1},Ga={c:[],p:!0},Ha={"class":x},z={C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,
"html:strong":1,"html:u":1};function Ia(a,b){var c={},d;for(d in b.b){var l=b.b[d],k=!1;if(d in a.b){k=l.c;var h=d,t=a.b[d];B.x=h;for(var p=0;p<k.length&&(t=k[p](t,h),!1!==t);++p);delete B.x;k=t}!1!==k?c[d]=k:l.p&&C(a)}Ja(a,c)}
var F=[Ia],La=[function(a){return Ka(a,/^[-0-9A-Za-z_]+$/)}],Ma={c:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],p:!1},Ra=[function(a){var b=Na.urlConfig,c=B,d=Oa(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Pa(b,d))?(c&&(d.attrValue=a,c.add("err",b,d)),a=!1):a=Qa(d);return a}],Ua={c:La,p:!0},Va={c:[function(a){return Ka(a,/^[- +,.0-9A-Za-z_]+$/)}],p:!1},Wa={c:Ra,p:!0},Xa={l:z,flags:268,m:z},
Ya={l:z,flags:3460,m:z},Za={d:da,b:{},h:0,c:F,f:10,e:{flags:66},g:5E3},$a={l:{C:1,EM:1,EMAIL:1,LI:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:li":1,"html:strong":1,"html:u":1},flags:264,m:z},ab={d:Ba,b:{},h:0,c:F,f:10,e:{flags:2},g:5E3},bb={d:Ba,b:{},h:0,c:F,f:10,e:ha,g:5E3},cb={d:Aa,b:{},h:0,c:F,f:10,e:{flags:512},g:5E3},db={l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:dd":1,"html:dt":1,"html:i":1,"html:strong":1,"html:u":1},flags:256,m:z},eb={l:{C:1,EM:1,EMAIL:1,
STRONG:1,TD:1,TH:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:u":1},flags:256,m:z},fb={d:wa,b:{id:x},h:2,c:F,f:10,e:pa,g:5E3},gb={d:ua,b:{"char":Ga},h:8,c:F,f:10,e:pa,g:5E3},hb={align:{c:[function(a){return a.toLowerCase()},function(a){return Ka(a,/^(?:center|justify|left|right)$/)}],p:!1}},mb={d:Ba,b:{},h:3,c:F,f:10,e:{l:z,flags:260,m:z},g:5E3},nb={d:ya,b:{},h:1,c:F,f:10,e:Ya,g:5E3},ob={d:[65408,65290,257],b:{},h:1,c:F,f:10,e:Ya,g:5E3},pb={d:Ea,b:{},h:9,
c:F,f:10,e:{l:z,flags:3456,m:z},g:5E3},qb={d:[65408,65284,257],b:{},h:11,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TD:1,TH:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:tr":1,"html:u":1},flags:3456,m:z},g:5E3},rb={d:Ea,b:{},h:9,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TBODY:1,TD:1,TH:1,THEAD:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:tbody":1,"html:td":1,"html:th":1,"html:thead":1,"html:tr":1,"html:u":1},flags:3456,m:z},g:5E3},
sb=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="urn:s9e:TextFormatter:html" exclude-result-prefixes="html"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$pTASKLISTS_EDITABLE"/>$aBANDCAMP"><$w$hbandcamp"$k$g400px"><$w$k$d100%"><$v$j"$q$x$ono"$k$f><$l$psrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$s><$u$m@album_id">album=$b@album_id"/><$t$m@track_num">/t=$b@track_num"/></$t></$u><$r>track=$b@track_id"/></$r></$s></$l></$v></$w></$w>$c$aC"><code>$e</code>$c$aCODE"><pre><code><$t$m@lang"><$l$pclass">language-$b@lang"/></$l></$t>$e</code></pre>$c$aDAILYMOTION"><$w$hdailymotion"$k$g640px"><$w$k$d56.25%"><$v$j"$q$x$ono"$k$f><$l$psrc">//www.dailymotion.com/embed/video/$b@id"/><$t$m@t">?start=$b@t"/></$t></$l></$v></$w></$w>$c$aDEL|EM|H1|H2|H3|H4|H5|H6|STRONG|SUB|SUP|TABLE|TBODY|THEAD|TR|html:b|html:br|html:code|html:dd|html:del|html:dl|html:dt|html:i|html:ins|html:li|html:ol|html:pre|html:rb|html:rp|html:rt|html:rtc|html:ruby|html:strong|html:sub|html:sup|html:table|html:tbody|html:tfoot|html:thead|html:tr|html:u|html:ul|p"><xsl:element$p{translate(local-name(),\\\'ABDEGHLMNOPRSTUY\\\',\\\'abdeghlmnoprstuy\\\')}">$e</xsl:element>$c$aEMAIL"><a href="mailto:{@email}">$e</a>$c$aESC">$e$c$aFACEBOOK"><$v$hfacebook"$j"$nstyle"$q$x onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$ono"$yhttps://s9e.github.io/$v/2/facebook.min.html#{@type}{@id}"$kborder:0;height:360px;max-width:640px;width:100%"/>$c$aFP|HE">$b@char"/>$c$aHC"><xsl:comment>$b@content"/></xsl:comment>$c$aHR"><hr/>$c$aIMG"><img$y{@src}">$ialt|@title"/></img>$c$aISPOILER"><$w class="spoiler"$nstyle" onclick="removeAttribute(\\\'style\\\')"$kbackground:#444;color:transparent">$e</$w>$c$aLI"><li><$t$mTASK"><$l$pdata-s9e-livepreview-ignore-attrs">data-task-id</$l><$l$pdata-task-id">$bTASK/@id"/></$l><$l$pdata-task-state">$bTASK/@state"/></$l></$t>$e</li>$c$aLIST"><$s><$u$mnot(@type)"><ul>$e</ul></$u><$r><ol>$istart"/>$e</ol></$r></$s>$c$aLIVELEAK"><$w$hliveleak"$k$g640px"><$w$k$d56.25%"><$v$j"$q$x$ono"$y//www.liveleak.com/e/{@id}"$k$f/></$w></$w>$c$aQUOTE"><blockquote>$e</blockquote>$c$aSOUNDCLOUD"><$v$hsoundcloud"$j"$q$x$ono"><$l$psrc">https://w.soundcloud.com/player/?url=<$s><$u$m$z">https%3A//api.soundcloud.com/playlists/$b$z"/></$u><$u$m@track_id">https%3A//api.soundcloud.com/tracks/$b@track_id"/>&amp;secret_token=$b@secret_token"/></$u><$r><$t$mnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$t>$b@id"/></$r></$s></$l><$l$pstyle">border:0;height:<$s><$u$m$z or contains(@id,\\\'/sets/\\\')">450</$u><$r>166</$r></$s>px;max-width:900px;width:100%</$l></$v>$c$aSPOILER"><details class="spoiler"$nopen">$e</details>$c$aSPOTIFY"><$s><$u$mstarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$v$hspotify" allow="encrypted-media"$j"$q$x$ono"$yhttps://open.spotify.com/embed/{@id}"$kborder:0;height:152px;max-width:900px;width:100%"/></$u><$r><$w$hspotify"$k$g320px"><$w$k$d125%;padding-bottom:calc(100% + 80px)"><$v allow="encrypted-media"$j"$q$x$ono"$yhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$k$f/></$w></$w></$r></$s>$c$aTASK"><input data-task-id="{@id}"$ndata-task-id" type="checkbox"><$t$m@state=\\\'checked\\\'"><$l$pchecked"/></$t><$t$mnot($TASKLISTS_EDITABLE)"><$l$pdisabled"/></$t></input>$c$aTD"><td><$t$m@align"><$l$pstyle">text-align:$b@align"/></$l></$t>$e</td>$c$aTH"><th><$t$m@align"><$l$pstyle">text-align:$b@align"/></$l></$t>$e</th>$c$aTWITCH"><$w$htwitch"$k$g640px"><$w$k$d56.25%"><$v$j"$q$x$ono"$k$f><$l$psrc">//<$s><$u$m@clip_id">clips.twitch.tv/embed?autoplay=false&amp;clip=<$t$m@channel">$b@channel"/>/</$t>$b@clip_id"/></$u><$r>player.twitch.tv/?autoplay=false&amp;<$s><$u$m@video_id">video=v$b@video_id"/></$u><$r>channel=$b@channel"/></$r></$s><$t$m@t">&amp;time=$b@t"/></$t></$r></$s></$l></$v></$w></$w>$c$aURL"><a href="{@url}">$ititle"/>$e</a>$c$aVIMEO"><$w$hvimeo"$k$g640px"><$w$k$d56.25%"><$v$j"$q$x$ono"$k$f><$l$psrc">//player.vimeo.com/video/$b@id"/><$t$m@t">#t=$b@t"/></$t></$l></$v></$w></$w>$c$aVINE"><$w$hvine"$k$g480px"><$w$k$d100%"><$v$j"$q$x$ono"$yhttps://vine.co/v/{@id}/embed/simple?audio=1"$k$f/></$w></$w>$c$aYOUTUBE"><$w$hyoutube"$k$g640px"><$w$k$d56.25%"><$v$j"$q$x$ono"$kbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$f><$l$psrc">https://www.youtube.com/embed/$b@id"/><$t$m@list">?list=$b@list"/></$t><$t$m@t"><$s><$u$m@list">&amp;</$u><$r>?</$r></$s>start=$b@t"/></$t></$l></$v></$w></$w>$c$abr"><br/>$c$ae|i|s"/>$ahtml:abbr"><abbr>$ititle"/>$e</abbr>$c$ahtml:div"><div>$iclass"/>$e</div>$c$ahtml:img"><img>$ialt|@height|@src|@title|@width"/>$e</img>$c$ahtml:$w"><$w>$iclass"/>$e</$w>$c$ahtml:td"><td>$icol$w|@row$w"/>$e</td>$c$ahtml:th"><th>$icol$w|@row$w|@scope"/>$e</th>$c</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:\'<xsl:template match="\',$b:\'<xsl:value-of select="\',$c:"</xsl:template>",$d:"display:block;overflow:hidden;position:relative;padding-bottom:",$e:"<xsl:apply-templates/>",$f:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$g:"display:inline-block;width:100%;max-width:",$h:\' data-s9e-mediaembed="\',$i:\'<xsl:copy-of select="@\',$j:\' allowfullscreen="\',$k:\' style="\',$l:"xsl:attribute",$m:\' test="\',$n:\' data-s9e-livepreview-ignore-attrs="\',$o:\' scrolling="\',$p:\' name="\',
$q:\' loading="\',$r:"xsl:otherwise",$s:"xsl:choose",$t:"xsl:if",$u:"xsl:when",$v:"iframe",$w:"span",$x:\'lazy"\',$y:\' src="\',$z:"@playlist_id"}[a]});function Ka(a,b){return b.test(a)?a:!1}
function Oa(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(d,l){c[d]=""<b[l+1]?b[l+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function Qa(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=tb(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+tb(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(d){return d.toUpperCase()},c);b+=c.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,escape);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));
return b}
function Pa(a,b){if(""!==b.scheme&&!a.Q.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var d=4,l=c.split(".");0<=--d;){if("0"===l[d][0]||255<l[d]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.S&&
a.S.test(b.host)||a.W&&!a.W.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function ub(a){var b=document.createElement("b");ub=function(c){b.innerHTML=c.replace(/</g,"&lt;");return b.textContent};return ub(a)}function vb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}
function wb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function tb(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}function xb(){this.o={};this.q=[]}xb.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.x||(c.attrName=this.x);"tag"in c||!this.k||(c.tag=this.k);this.o[a]&&this.o[a].forEach(function(d){d(b,c)});this.q.push([a,b,c])};xb.prototype.getLogs=function(){return this.q};
xb.prototype.on=function(a,b){this.o[a].push(b)};function yb(a,b){B.add("debug",a,b)}function zb(a,b,c,d,l){this.k=+a;this.name=b;this.i=+c;this.j=+d;this.q=+l||0;this.b={};this.M=[];isNaN(a+c+d)&&C(this)}zb.prototype.o=!1;function Ab(a,b){a.M.push(b);a.o&&C(b)}function C(a){a.o||(a.o=!0,a.M.forEach(function(b){C(b)}))}function Bb(a,b){Cb(a,b)?(a.y=b,b.F=a,Ab(a,b)):Cb(b,a)&&(a.F=b,b.y=a)}function Cb(a,b){return a.name===b.name&&1===a.k&&2===b.k&&a.i<=a.i}
function Db(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function Eb(a,b){return a.o||!Cb(b,a)||a.F&&a.F!==b||b.y&&b.y!==a?!1:!0}function Ja(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var Fb,Gb,G,Hb,I,Ib,B=new xb,Jb,J,K,Mb={Autoemail:{r:function(a,b){b.forEach(function(c){var d=L(1,"EMAIL",c[0][1],0,0);d.b.email=c[0][0];c=Kb("EMAIL",c[0][1]+c[0][0].length,0);Bb(d,c)})},u:"@",v:/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/ig,w:5E4},Autolink:{r:function(a,b){b.forEach(function(c){var d=c[0][1],l=c[0][0].replace(/(?:(?![-=)\\/_])[\\s!-.:-@[-`{-~])+$/,""),k=d+l.length,h=Kb("URL",k,0);"."===l[3]&&(l="http://"+l);c=L(1,"URL",d,0,1);c.b.url=l;Bb(c,h);d=L(3,"v",d,k-d,1E3);Ab(c,d)})},u:":",v:/\\b(?:ftp|https?|mailto):(?:[^\\s()\\[\\]\\uFF01-\\uFF0F\\uFF1A-\\uFF20\\uFF3B-\\uFF40\\uFF5B-\\uFF65]|\\([^\\s()]*\\)|\\[\\w*\\])+/ig,
w:5E4},Escaper:{r:function(a,b){b.forEach(function(c){M("ESC",c[0][1],1,c[0][1]+c[0][0].length,0)})},u:"\\\\",v:/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/g,w:5E4},FancyPants:{r:function(a){function b(g,n,m,w){g=L(3,r,g,n,w||0);g.b[e]=m;return g}function c(){if(!(0>a.indexOf("...")&&0>a.indexOf("--")))for(var g={"--":"\\u2013","---":"\\u2014","...":"\\u2026"},n=/---?|\\.\\.\\./g,m;m=n.exec(a);)b(m.index,m[0].length,g[m[0]])}function d(){if(!(0>a.indexOf("/")))for(var g={"0/3":"\\u2189","1/10":"\\u2152","1/2":"\\u00bd","1/3":"\\u2153",
"1/4":"\\u00bc","1/5":"\\u2155","1/6":"\\u2159","1/7":"\\u2150","1/8":"\\u215b","1/9":"\\u2151","2/3":"\\u2154","2/5":"\\u2156","3/4":"\\u00be","3/5":"\\u2157","3/8":"\\u215c","4/5":"\\u2158","5/6":"\\u215a","5/8":"\\u215d","7/8":"\\u215e"},n,m=/\\b(?:0\\/3|1\\/(?:[2-9]|10)|2\\/[35]|3\\/[458]|4\\/5|5\\/[68]|7\\/8)\\b/g;n=m.exec(a);)b(n.index,n[0].length,g[n[0]])}function l(){if(!(0>a.indexOf("<<")))for(var g,n=/<<( ?)(?! )[^\\n<>]*?[^\\n <>]\\1>>(?!>)/g;g=n.exec(a);){var m=b(g.index,2,"\\u00ab");g=b(g.index+g[0].length-2,2,
"\\u00bb");Ab(m,g)}}function k(){if(!(0>a.indexOf("!=")&&0>a.indexOf("=/=")))for(var g,n=/\\b (?:!|=\\/)=(?= \\b)/g;g=n.exec(a);)b(g.index+1,g[0].length-1,"\\u2260")}function h(g,n,m,w){for(var y;y=n.exec(a);){var D=b(y.index+y[0].indexOf(g),1,m);y=b(y.index+y[0].length-1,1,w);Ab(D,y)}}function t(){if(f)for(var g,n=/[a-z]\'|(?:^|\\s)\'(?=[a-z]|[0-9]{2})/gi;g=n.exec(a);)b(g.index+g[0].indexOf("\'"),1,"\\u2019",10)}function p(){if(f||q||!(0>a.indexOf("x")))for(var g={"\'s":"\\u2019","\'":"\\u2032","\' ":"\\u2032",
"\'x":"\\u2032",\'"\':"\\u2033",\'" \':"\\u2033",\'"x\':"\\u2033"},n,m=/[0-9](?:\'s|["\']? ?x(?= ?[0-9])|["\'])/g;n=m.exec(a);){"x"===n[0][n[0].length-1]&&b(n.index+n[0].length-1,1,"\\u00d7");var w=n[0].substr(1,2);g[w]&&b(n.index+1,1,g[w])}}function v(){if(!(0>a.indexOf("(")))for(var g={"(c)":"\\u00a9","(r)":"\\u00ae","(tm)":"\\u2122"},n=/\\((?:c|r|tm)\\)/gi,m;m=n.exec(a);)b(m.index,m[0].length,g[m[0].toLowerCase()])}var u={x:"char",I:"FP"},e=u.x,f=0<=a.indexOf("\'"),q=0<=a.indexOf(\'"\'),r=u.I;"undefined"===typeof u.aa&&
(t(),f&&h("\'",/(?:^|\\W)\'.+?\'(?!\\w)/g,"\\u2018","\\u2019"),q&&h(\'"\',/(?:^|\\W)".+?"(?!\\w)/g,"\\u201c","\\u201d"));"undefined"===typeof u.Y&&l();"undefined"===typeof u.Z&&(k(),p(),d());"undefined"===typeof u.$&&c();"undefined"===typeof u.ba&&v()}},HTMLComments:{r:function(a,b){b.forEach(function(c){var d=ub(c[0][0].substr(4,c[0][0].length-7));d=d.replace(/[<>]/g,"");d=d.replace(/-+$/,"");d=d.replace(/--/g,"");L(3,"HC",c[0][1],c[0][0].length,0).b.content=d})},u:"\\x3c!--",v:/\\x3c!--(?!\\[if)[\\s\\S]*?--\\x3e/ig,
w:5E4},HTMLElements:{r:function(a,b){var c={a:{"":"URL",href:"url"},em:{"":"EM"},hr:{"":"HR"},s:{"":"S"},strong:{"":"STRONG"},sup:{"":"SUP"}};b.forEach(function(d){var l="/"===a[d[0][1]+1],k=d[0][1],h=d[0][0].length,t=d[2-l][0].toLowerCase(),p=c&&c[t]&&c[t][""]?c[t][""]:"html:"+t;if(l)Kb(p,k,h);else for(l=/(<\\S+|[\'"\\s])\\/>$/.test(d[0][0])?M(p,k,h,k+h,0):L(1,p,k,h,0),d=d[3][0],k=/([a-z][-a-z0-9]*)(?:\\s*=\\s*("[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?/gi;p=k.exec(d);)h=p[1].toLowerCase(),p="undefined"!==typeof p[2]?
p[2]:h,c&&c[t]&&c[t][h]&&(h=c[t][h]),/^["\']/.test(p)&&(p=p.substr(1,p.length-2)),p=ub(p),l.b[h]=p})},u:"<",v:/<(?:\\/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?:\\s+[a-z][-a-z0-9]*(?:\\s*=\\s*(?:"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*)\\s*\\/?)\\s*>/ig,w:5E4},
HTMLEntities:{r:function(a,b){b.forEach(function(c){var d=c[0][0],l=ub(d);l===d||32>l.charCodeAt(0)||(L(3,"HE",c[0][1],d.length,0).b["char"]=l)})},u:"&",v:/&(?:[a-z]+|#(?:[0-9]+|x[0-9a-f]+));/ig,w:5E4},Litedown:{r:function(a){function b(e){-1<e.indexOf("&")&&(e=ub(e));e=e.replace(/\\x1A/g,"");p&&(e=e.replace(/\\x1B./g,function(f){return{"\\u001b0":"!","\\u001b1":\'"\',"\\u001b2":"\'","\\u001b3":"(","\\u001b4":")","\\u001b5":"*","\\u001b6":"<","\\u001b7":">","\\u001b8":"[","\\u001b9":"\\\\","\\u001bA":"]","\\u001bB":"^",
"\\u001bC":"_","\\u001bD":"`","\\u001bE":"~"}[f]}));return e}function c(e){return 0<" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(e)}function d(e){a=a.substr(0,e)+"\\u0017"+a.substr(e+1)}function l(e,f){0<f&&(a=a.substr(0,e)+Array(1+f).join("\\u001a")+a.substr(e+f))}function k(e,f,q){if(-1!==a.indexOf(e))for(var r;r=f.exec(a);)e=r.index,r=e+r[0].length-2,M(q,e,2,r,2),l(e,2),l(r,2)}function h(e,f,q,r){function g(m){m=a.indexOf(f+"(",m);if(-1!==m){var w;for(r.lastIndex=m;w=r.exec(a);){var y=
w[0];w=w.index;var D=y.length;M(e,w,2,w+D-1,1);l(w,D)}y&&g(m)}}var n=a.indexOf(f);-1!==n&&(function(m){var w;for(q.lastIndex=m;w=q.exec(a);){m=w[0];w=w.index;var y=m.substr(-1)===f?1:0;M(e,w,1,w+m.length-y,y)}}(n),g(n))}function t(e,f,q){var r=f.replace(/^\\s*/,"").replace(/\\s*$/,"");f="";var g=r.indexOf(" ");-1!==g&&(f=r.substr(g).replace(/^\\s*\\S/,"").replace(/\\S\\s*$/,""),r=r.substr(0,g));/^<.+>$/.test(r)&&(r=r.replace(/^<(.+)>$/,"$1").replace(/\\\\>/g,">"));r=b(r);e.b[q]=r;""<f&&(q=b(f),e.b.title=
q)}var p=!1,v=!1,u={};0<=a.indexOf("\\\\")&&(p=!0,a=a.replace(/\\\\[!"\'()*<>[\\\\\\]^_`~]/g,function(e){return{"\\\\!":"\\u001b0",\'\\\\"\':"\\u001b1","\\\\\'":"\\u001b2","\\\\(":"\\u001b3","\\\\)":"\\u001b4","\\\\*":"\\u001b5","\\\\<":"\\u001b6","\\\\>":"\\u001b7","\\\\[":"\\u001b8","\\\\\\\\":"\\u001b9","\\\\]":"\\u001bA","\\\\^":"\\u001bB","\\\\_":"\\u001bC","\\\\`":"\\u001bD","\\\\~":"\\u001bE"}[e]}));a+="\\n\\n\\u0017";(function(){function e(m,w){Bb(Kb("LIST",w,0),m.U);Bb(Kb("LI",w,0),m.G);m.O&&m.H.forEach(function(y){y.flags&=-9})}function f(m,w){for(var y=
m;0<=--w;)y=y.replace(/^ *>!? ?/,"");return m.length-y.length}function q(m,w){return/[ \\t]*#*[ \\t]*$/.exec(a.substr(m,w-m))[0].length}function r(m){for(var w=[],y=/>!?/g,D;D=y.exec(m);)w.push(D[0]);return w}function g(){if(-1!==a.indexOf("-")||-1!==a.indexOf("="))for(var m,w=/^(?=[-=>])(?:>!? ?)*(?=[-=])(?:-+|=+) *$/gm;m=w.exec(a);){var y=m[0];m=m.index;for(var D=m-1;0<D&&" "===a[D-1];)--D;n[m-1]={K:m+y.length-D,L:D,R:y.length-y.replace(/>/g,"").length,I:"="===y[0]?"H1":"H2"}}}var n={};(function(){g();
for(var m=[],w=0,y,D=4,A,H=!0,Q=[],N=0,ea=!1,S=0,ma,ja,Z,ib,Wb,U,P,jb,Sa,ka,la,sa,Xb=[],kb,Ta=/^(?:(?=[-*+\\d \\t>`~#_])((?: {0,3}>(?:(?!!)|!(?![^\\n>]*?!<)) ?)+)?([ \\t]+)?(\\* *\\* *\\*[* ]*$|- *- *-[- ]*$|_ *_ *_[_ ]*$)?((?:[-*+]|\\d+\\.)[ \\t]+(?=\\S))?[ \\t]*(#{1,6}[ \\t]+|```+[^`\\n]*$|~~~+[^~\\n]*$)?)?/gm;kb=Ta.exec(a);)Xb.push(kb),kb.index===Ta.lastIndex&&++Ta.lastIndex;Xb.forEach(function(E){var aa=[],V=E.index,ta=E[0].length,R;ka=Z=0;ja=!H;U=a.indexOf("\\n",V);H=U===V+ta&&!E[3]&&!E[4]&&!E[5];ta||++Ta.lastIndex;
ma=H&&ja;E[1]&&(aa=r(E[1]),ka=aa.length,Z=E[1].length,A&&"blockDepth"in A.b&&(ka=Math.min(ka,A.b.blockDepth),Z=f(E[1],ka)),l(V,Z));if(ka<w&&!ja){ea=!0;do{var W=m.pop();Bb(Kb(W.name,S,0),W)}while(ka<--w)}if(ka>w&&!H){ea=!0;do m.push(L(1,">!"===aa[w]?"SPOILER":"QUOTE",V,0,-999));while(ka>++w)}W=R=0;if(E[2]&&!y){ib=E[2];Wb=ib.length;do" "===ib[W]?++R:R=R+4&-4;while(++W<Wb&&R<D)}A&&!y&&R<D&&!H&&(ea=!0);ea&&(ea=!1,A&&(S>A.i?(l(A.i,S-A.i),Bb(A,Kb("CODE",S,0,-1))):C(A),y=A=null),Q.forEach(function(lb){e(lb,
S)}),Q=[],N=0,V&&d(V-1));if(R>=D){if(A||!ja)Z=(E[1]||"").length+W,A||(A=L(1,"CODE",V+Z,0,-999)),E={}}else{aa=!!E[4];if(R||ja||aa)if(ja&&!aa)P=N-1;else if(N)for(P=0;P<N&&R>Q[P].N;)++P;else P=aa?0:-1;else P=-1;for(;P<N-1;)e(Q.pop(),S),--N;P!==N||aa||--P;if(aa&&0<=P)if(ma=!0,la=V+Z+W,sa=E[4].length,W=L(1,"LI",la,sa,0),l(la,sa),P<N)Bb(Kb("LI",S,0),Q[P].G),Q[P].G=W,Q[P].H.push(W);else{++N;P?(Sa=Q[P-1].N+1,jb=Math.max(Sa,4*P)):(Sa=0,jb=R);R=L(1,"LIST",la,0,0);if(-1<E[4].indexOf(".")){R.b.type="decimal";
var Yb=+E[4];1!==Yb&&(R.b.start=Yb)}Q.push({U:R,G:W,H:[W],ca:Sa,N:jb,O:!0})}!N||ja||H||(1<Q[0].H.length||!aa)&&Q.forEach(function(lb){lb.O=!1});D=4*(N+1)}if(E[5])if("#"===E[5][0])W=E[5].length,aa=V+ta-W,R=q(V+ta,U),ta=U-R,M("H"+/#{1,6}/.exec(E[5])[0].length,aa,W,ta,R),d(aa),d(U),ja&&(ma=!0);else{if("`"===E[5][0]||"~"===E[5][0])la=V+Z,sa=U-la,A&&E[5]===y?(Bb(A,Kb("CODE",la,sa,-1)),Lb(S,la-S),l(A.i,la+sa-A.i),y=A=null):A||(A=L(1,"CODE",la,sa,0),y=E[5].replace(/[^`~]+/,""),A.b.blockDepth=ka,Lb(la+sa,
1),E=E[5].replace(/^[`~\\s]*/,"").replace(/\\s+$/,""),""!==E&&(A.b.lang=E))}else E[3]&&!N&&"\\u0017"!==a[V+ta]?(L(3,"HR",V+Z,ta-Z,0),ma=!0,d(U)):!n[U]||n[U].R!==ka||H||N||A||(M(n[U].I,V+Z,0,n[U].L,n[U].K),d(n[U].L+n[U].K));ma&&(L(3,"pb",S,0,0),d(S));H||(S=U);Z&&Lb(V,Z,1E3)})})()})();(function(){if(!(0>a.indexOf("]:")))for(var e,f=/^\\x1A* {0,3}\\[([^\\x17\\]]+)\\]: *([^[\\s\\x17]+ *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))?) *(?=$|\\x17)\\n?/gm;e=f.exec(a);){Lb(e.index,e[0].length);var q=e[1].toLowerCase();u[q]||
(v=!0,u[q]=e[2])}})();(function(){var e=a.indexOf("`");if(0>e)var f=[];else{f=/(`+)(\\s*)[^\\x17`]*/g;var q=0,r=[],g=a.replace(/\\x1BD/g,"\\\\`");for(f.lastIndex=e;e=f.exec(g);)r.push({i:e.index,j:e[1].length,P:q,X:e[2].length,next:e.index+e[0].length}),q=e[0].length-e[0].replace(/\\s+$/,"").length;f=r}g=-1;for(q=f.length;++g<q-1;)for(e=f[g].next,r=g,"`"!==a[f[g].i]&&(++f[g].i,--f[g].j);++r<q&&f[r].i===e;){if(f[r].j===f[g].j){g=f[g];var n=f[r];e=g.i;var m=n.i-n.P;n=n.j+n.P;M("C",e,g.j+g.X,m,n);l(e,m+n-
e);g=r;break}e=f[r].next}})();(function(){function e(f,q,r,g,n){var m=M("IMG",f,2,q,r);t(m,g,"src");g=b(n);m.b.alt=g;l(f,q+r-f)}(function(){var f=a.indexOf("![");if(-1!==f){if(0<a.indexOf("](",f))for(var q=/!\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:[^\\x17\\s()]|\\([^\\x17\\s()]*\\))*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;f=q.exec(a);){var r=f[1],g=f.index,n=3+r.length;e(g,g+f[0].length-n,n,r,f[0].substr(2,f[0].length-n-2))}if(v)for(q=/!\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\](?: ?\\[([^\\x17[\\]]+)\\])?/g;f=
q.exec(a);){r=f.index;g=r+2+f[1].length;n=1;var m=f[1],w=m;if(""<f[2]&&u[f[2]])n=f[0].length-m.length-2,w=f[2];else if(!u[w])continue;e(r,g,n,u[w],m)}}})()})();k(">!",/>![^\\x17]+?!</g,"ISPOILER");k("||",/\\|\\|[^\\x17]+?\\|\\|/g,"ISPOILER");(function(){function e(g,n,m,w){var y=M("URL",g,1,n,m,1===m?1:-1);t(y,w,"url");l(g,1);l(n,m)}function f(){for(var g,n=/<[-+.\\w]+([:@])[^\\x17\\s>]+?(?:>|\\x1B7)/g;g=n.exec(a);){var m=b(g[0].replace(/\\x1B/g,"\\\\\\u001b")).replace(/^<(.+)>$/,"$1"),w=g.index,y=":"===g[1]?"URL":
"EMAIL",D=y.toLowerCase();M(y,w,1,w+g[0].length-1,1).b[D]=m}}function q(){for(var g,n=/\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:\\([^\\x17\\s()]*\\)|[^\\x17\\s)])*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;g=n.exec(a);){var m=g[1],w=g.index,y=3+m.length;e(w,w+g[0].length-y,y,m)}}function r(){for(var g={},n,m=/\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\]/g;n=m.exec(a);)g[n.index]=n[1].toLowerCase();for(var w in g){n=g[w];m=+w+2+n.length;var y=m-1,D=1;" "===a[m]&&++m;""<g[m]&&u[g[m]]&&(n=g[m],
D=m+2+n.length-y);u[n]&&e(+w,y,D,u[n])}}-1!==a.indexOf("](")&&q();-1!==a.indexOf("<")&&f();v&&r()})();k("~~",/~~[^\\x17]+?~~(?!~)/g,"DEL");h("SUB","~",/~[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+~?/g,/~\\([^\\x17()]+\\)/g);h("SUP","^",/\\^[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+\\^?/g,/\\^\\([^\\x17()]+\\)/g);(function(){function e(D,A){var H=a.indexOf(D);if(-1!==H){D=[];var Q=[],N=a.indexOf("\\u0017",H),ea;for(A.lastIndex=H;ea=A.exec(a);){H=ea.index;ea=ea[0].length;H>N&&(Q.push(D),D=[],N=a.indexOf("\\u0017",
H));var S,ma=H,ja=ea;if(S="_"===a.charAt(ma)&&1===ja)S=0<ma&&c(a[ma-1])&&c(a[ma+ja]);S||D.push([H,ea])}Q.push(D);Q.forEach(f)}}function f(D){w=g=-1;D.forEach(function(A){var H=A[0];A=A[1];var Q=!(-1<" \\n\\t".indexOf(a[H+A-1+1])),N=0<H&&-1<" \\n\\t".indexOf(a.charAt(H-1))?0:Math.min(A,3);q=!!(N&1)&&0<=g;r=!!(N&2)&&0<=w;y=n=H;m=A;0<=g&&g===w&&(q?g+=2:++w);q&&r&&(g<w?n+=2:++y);q&&(--m,M("EM",g,1,n,1),g=-1);r&&(m-=2,M("STRONG",w,2,y,2),w=-1);m=Q?Math.min(m,3):0;H+=A;m&1&&(g=H-m);m&2&&(w=H-m)})}var q,r,g,
n,m,w,y;e("*",/\\*+/g);e("_",/_+/g)})();(function(){for(var e=a.indexOf("  \\n");0<e;)Ab(L(3,"br",e+2,0,0),L(3,"v",e+2,1,0)),e=a.indexOf("  \\n",e+3)})()}},MediaEmbed:{r:function(a,b){b.forEach(function(c){var d=c[0][0];L(3,"MEDIA",c[0][1],d.length,-10).b.url=d})},u:"://",v:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,w:5E4},PipeTables:{r:function(a){function b(u,e){k=e.i;e.D.split("|").forEach(function(f,q){0<q&&(Ab(t,Lb(k,1,1E3)),++k);q=h.J[q]?h.J[q]:"";var r=k,g=r+f.length;k=g;var n=/^( *).*?( *)$/.exec(f);n[1]&&(f=
n[1].length,Ab(t,Lb(r,f,1E3)),r+=f);n[2]&&(f=n[2].length,Ab(t,Lb(g-f,f,1E3)),g-=f);g=r===g?L(3,u,r,0,-101):M(u,r,0,g,0,-101);q&&(g.b.align=q)});M("TR",e.i,0,k,0,-102)}function c(){if(h&&2<h.n.length&&/^ *:?-+:?(?:(?:\\+| *\\| *):?-+:?)+ */.test(h.n[1].D)){for(var u=h,e=h.n[1].D,f=["","right","left","center"],q=[],r=/(:?)-+(:?)/g,g;g=r.exec(e);)q.push(f[(g[1]?2:0)+(g[2]?1:0)]);u.J=q;p.push(h)}h=null}function d(u){return u.replace(/[!>]/g," ")}function l(u){return u.replace(/\\|/g,".")}var k,h=null,t,
p,v=a;-1<v.indexOf("`")&&(v=v.replace(/`[^`]*`/g,l));-1<v.indexOf(">")&&(v=v.replace(/^(?:>!? ?)+/gm,d));-1<v.indexOf("\\\\|")&&(v=v.replace(/\\\\[\\\\|]/g,".."));(function(){h=null;p=[];k=0;v.split("\\n").forEach(function(u){if(0>u.indexOf("|"))c();else{var e=u,f=0;h||(h={n:[]},f=/^ */.exec(e)[0].length,e=e.substr(f));e=e.replace(/^( *)\\|/,"$1 ").replace(/\\|( *)$/," $1");h.n.push({D:e,i:k+f})}k+=1+u.length});c()})();(function(){for(var u=-1,e=p.length;++u<e;){h=p[u];var f=h.n[h.n.length-1];t=M("TABLE",
h.n[0].i,0,f.i+f.D.length,0,-104);b("TH",h.n[0]);M("THEAD",h.n[0].i,0,k,0,-103);f=h.n[1];Ab(t,Lb(f.i-1,1+f.D.length,1E3));f=1;for(var q=h.n.length;++f<q;)b("TD",h.n[f]);M("TBODY",h.n[2].i,0,k,0,-103)}})()},u:"|"}},O,Na={"MediaEmbed.hosts":{"bandcamp.com":"bandcamp","dai.ly":"dailymotion","dailymotion.com":"dailymotion","facebook.com":"facebook","liveleak.com":"liveleak","open.spotify.com":"spotify","play.spotify.com":"spotify","soundcloud.com":"soundcloud","twitch.tv":"twitch","vimeo.com":"vimeo",
"vine.co":"vine","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{bandcamp:[[],[{z:[[/\\/album=(\\d+)/,ra]],match:[[/bandcamp\\.com\\/album\\/./,ca]]},{z:[[/"album_id":(\\d+)/,ra],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,va]],match:[[/bandcamp\\.com\\/track\\/./,ca]]}]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,ia],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,ia],[/start=(\\d+)/,fa]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,
ia],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,oa],[/facebook\\.com\\/watch\\/\\?([pv])=/,oa]],[]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,ia]],[{z:[[/liveleak\\.com\\/e\\/(\\w+)/,ia]],match:[[/liveleak\\.com\\/view\\?t=/,ca]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,ia],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,Fa],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,
["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{z:[[/soundcloud:tracks:(\\d+)/,va]],T:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,ca]]},{z:[[/soundcloud:\\/\\/playlists:(\\d+)/,Fa]],T:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,ca]]}]],spotify:[[[/(?:open|play)\\.spotify\\.com\\/((?:user\\/[-.\\w]+\\/)?(?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,
ia]],[]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,["","video_id"]],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)/,["","channel"]],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,fa],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?(\\w+)/,["","channel","clip_id"]]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,ia],[/#t=([\\dhms]+)/,fa]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,ia]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,ia],[/youtu\\.be\\/([-\\w]+)/,ia],[/[#&?]t=(\\d[\\dhms]*)/,fa],
[/[&?]list=([-\\w]+)/,["","list"]]],[{z:[[/\\/vi\\/([-\\w]+)/,ia]],match:[[/\\/shared\\?ci=/,ca]]}]]},urlConfig:{Q:/^(?:ftp|https?|mailto)$/i}},Nb={d:Aa,flags:8},X={BANDCAMP:{d:wa,b:{album_id:x,track_id:x,track_num:x},h:2,c:F,f:10,e:pa,g:5E3},C:Za,CODE:{d:da,b:{lang:Va},h:1,c:F,f:10,e:{l:z,flags:4436,m:z},g:5E3},DAILYMOTION:{d:wa,b:{id:x,t:x},h:2,c:F,f:10,e:pa,g:5E3},DEL:cb,EM:ab,EMAIL:{d:xa,b:{email:{c:[function(a){return/^[-\\w.+]+@[-\\w.]+$/.test(a)?a:!1}],p:!0}},h:2,c:F,f:10,e:na,g:5E3},ESC:{d:da,b:{},
h:7,c:F,f:10,e:{flags:1616},g:5E3},FACEBOOK:{d:wa,b:{id:x,type:x,user:x},h:2,c:F,f:10,e:pa,g:5E3},FP:gb,H1:mb,H2:mb,H3:mb,H4:mb,H5:mb,H6:mb,HC:{d:da,b:{content:Ga},h:7,c:F,f:10,e:{flags:3153},g:5E3},HE:gb,HR:{d:ua,b:{},h:1,c:F,f:10,e:{l:z,flags:3349},g:5E3},IMG:{d:ua,b:{alt:x,src:Wa,title:x},h:0,c:F,f:10,e:pa,g:5E3},ISPOILER:bb,LI:{d:za,b:{},h:4,c:[Ia,function(a){for(var b=a.i+a.j;" "===T.charAt(b);)++b;var c=T.substr(b,3);if(/\\[[ Xx]\\]/.test(c)){var d=Math.random().toString(16).substr(2);c="[ ]"===
c?"unchecked":"checked";b=L(3,"TASK",b,3,0);b.b.id=d;b.b.state=c;Ab(a,b)}}],f:10,e:$a,g:5E3},LIST:{d:ya,b:{start:{c:[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],p:!1},type:Va},h:1,c:F,f:10,e:Ya,g:5E3},LIVELEAK:fb,MEDIA:{d:[65519,65329,256],b:{},h:16,c:[function(a){return function(b,c,d){function l(k,h,t){var p=!1;t.forEach(function(v){var u=v[1],e=v[0].exec(h);e&&(p=!0,u.forEach(function(f,q){""<e[q]&&""<f&&(k[f]=e[q])}))});return p}(function(k,h,t){C(k);if("url"in k.b){var p=k.b.url,v;a:{for(v=
/^https?:\\/\\/([^\\/]+)/.exec(p.toLowerCase())[1]||"";""<v;){if(h[v]){v=h[v];break a}v=v.replace(/^[^.]*./,"")}v=""}if(t[v]){h={};l(h,p,t[v][0]);a:{for(var u in h){t=!1;break a}t=!0}if(!t){t=k.i;var e=k.y;e?(p=k.j,u=e.i,e=e.j):(p=0,u=k.i+k.j,e=0);k=M(v.toUpperCase(),t,p,u,e,k.q);Ja(k,h)}}}})(b,c,d)}(a,Na["MediaEmbed.hosts"],Na["MediaEmbed.sites"],Na.cacheDir)}],f:10,e:{flags:513},g:5E3},QUOTE:{d:za,b:{},h:1,c:F,f:10,e:Xa,g:5E3},SOUNDCLOUD:{d:wa,b:{id:x,playlist_id:x,secret_token:x,track_id:x},h:2,c:F,
f:10,e:pa,g:5E3},SPOILER:{d:za,b:{},h:5,c:F,f:10,e:Xa,g:5E3},SPOTIFY:fb,STRONG:ab,SUB:bb,SUP:bb,TABLE:ob,TASK:{d:ua,b:{id:Ua,state:Ua},h:2,c:F,f:10,e:pa,g:5E3},TBODY:rb,TD:{d:za,b:hb,h:10,c:F,f:10,e:eb,g:5E3},TH:{d:Ca,b:hb,h:10,c:F,f:10,e:eb,g:5E3},THEAD:pb,TR:qb,TWITCH:{d:wa,b:{channel:x,clip_id:x,t:x,video_id:x},h:2,c:F,f:10,e:pa,g:5E3},URL:{d:xa,b:{title:x,url:Wa},h:6,c:F,f:10,e:na,g:5E3},VIMEO:{d:wa,b:{id:x,t:Ma},h:2,c:F,f:10,e:pa,g:5E3},VINE:fb,YOUTUBE:{d:wa,b:{id:{c:La,p:!1},list:x,t:Ma},h:2,
c:F,f:10,e:pa,g:5E3},"html:abbr":{d:Ba,b:{title:x},h:0,c:F,f:10,e:ha,g:5E3},"html:b":ab,"html:br":{d:Da,b:{},h:0,c:F,f:10,e:qa,g:5E3},"html:code":Za,"html:dd":{d:za,b:{},h:12,c:F,f:10,e:db,g:5E3},"html:del":cb,"html:div":{d:Aa,b:Ha,h:13,c:F,f:10,e:Xa,g:5E3},"html:dl":{d:[65408,65328,257],b:{},h:1,c:F,f:10,e:Ya,g:5E3},"html:dt":{d:Ca,b:{},h:12,c:F,f:10,e:db,g:5E3},"html:i":ab,"html:img":{d:Da,b:{alt:x,height:x,src:{c:Ra,p:!1},title:x,width:x},h:0,c:F,f:10,e:qa,g:5E3},"html:ins":cb,"html:li":{d:za,
b:{},h:4,c:F,f:10,e:$a,g:5E3},"html:ol":nb,"html:pre":{d:Ba,b:{},h:1,c:F,f:10,e:{l:z,flags:276,m:z},g:5E3},"html:rb":{d:Ba,b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rb":1,"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,m:z},g:5E3},"html:rp":{d:Ba,b:{},h:15,c:F,f:10,e:{l:z,flags:256,m:z},g:5E3},"html:rt":{d:Ba,b:{},h:15,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rb":1,"html:rt":1,"html:strong":1,
"html:u":1},flags:256,m:z},g:5E3},"html:rtc":{d:[65477,65409,257],b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,m:z},g:5E3},"html:ruby":{d:[65477,65473,257],b:{},h:0,c:F,f:10,e:ha,g:5E3},"html:span":{d:Ba,b:Ha,h:0,c:F,f:10,e:ha,g:5E3},"html:strong":ab,"html:sub":bb,"html:sup":bb,"html:table":ob,"html:tbody":rb,"html:td":{d:za,b:{colspan:x,rowspan:x},h:10,c:F,f:10,e:eb,g:5E3},"html:tfoot":rb,
"html:th":{d:Ca,b:{colspan:x,rowspan:x,scope:x},h:10,c:F,f:10,e:eb,g:5E3},"html:thead":pb,"html:tr":qb,"html:u":ab,"html:ul":nb},Y,Ob,T,Pb,Qb=0,Rb;
function Sb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=B;b.q=[];delete b.x;delete b.k;Fb={};Gb={};Hb=0;I=null;Ib=!1;Jb={};J=[];K="";O=0;Y=[];Ob=!1;T=a;Pb=T.length;Rb=0;G=Nb;G.A=!1;++Qb;a=Qb;for(var c in Mb)if(!Mb[c].B)a:{b=c;var d=Mb[b];if(!(d.u&&0>T.indexOf(d.u))){var l=[];if("undefined"!==typeof d.v&&"undefined"!==typeof d.w){l=void 0;var k=d.v;d=d.w;k.lastIndex=0;for(var h=[],t=0;++t<=d&&(l=k.exec(T));){for(var p=l.index,v=[[l[0],p]],u=0;++u<l.length;){var e=
l[u];void 0===e?v.push(["",-1]):(v.push([e,T.indexOf(e,p)]),p+=e.length)}h.push(v)}l=h;if(!l.length)break a}(0,Mb[b].r)(T,l)}}Tb();Ub(Pb,0,!0);do c=K,K=K.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(K!==c);K=K.replace(/<\\/i><i>/g,"");K=K.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");K=K.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Vb);b=Ib?"r":"t";c="<"+b;for(var f in Jb)c+=" xmlns:"+f+\'="urn:s9e:TextFormatter:\'+f+\'"\';K=c+">"+K+"</"+b+">";if(Qb!==a)throw"The parser has been reset during execution";1E4<Hb&&B.add("warn",
"Fixing cost limit exceeded",void 0);return K}function Zb(a){var b={},c;for(c in X[a])b[c]=X[a][c];return X[a]=b}function Vb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function $b(a){Ib=!0;var b=a.name,c=a.i,d=a.j,l=a.flags,k=0,h=0;l&256&&(k=1,h=a.k&2?2:1);var t=!1;a.k&1?l&4&&(t=!0):t=!0;Ub(c,k,t);k=d?wb(T.substr(c,d)):"";if(a.k&1){l&4||ac(c);l=b.indexOf(":");0<l&&(Jb[b.substr(0,l)]=0);K+="<"+b;var p=Db(a);l=[];for(var v in p)l.push(v);l.sort(function(u,e){return u>e?1:-1});l.forEach(function(u){K+=" "+u+\'="\'+vb(p[u].toString()).replace(/\\n/g,"&#10;")+\'"\'});K=3===a.k?d?K+(">"+k+"</"+b+">"):K+"/>":d?K+("><s>"+k+"</s>"):K+">"}else d&&(K+="<e>"+k+"</e>"),K+="</"+b+
">";for(Rb=O=c+d;h&&Rb<Pb&&"\\n"===T[Rb];)--h,++Rb}
function Ub(a,b,c){c&&(G.flags&8?b=-1:c=!1);O>=a&&c&&bc();if(Rb>O){var d=Math.min(a,Rb);K+=T.substr(O,d-O);O=d;O>=a&&c&&bc()}if(G.flags&128)d=a-O,b=T.substr(O,d),/^[ \\n\\t]*$/.test(b)||(b="<i>"+wb(b)+"</i>"),K+=b,O=a,c&&bc();else{var l=a;for(d=0;b&&--l>=O;){var k=T[l];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--b;++d}a-=d;if(G.flags&8)for(G.A||(cc(a),a>O&&ac(a)),b=T.indexOf("\\n\\n",O);-1<b&&b<a;)Ub(b,0,!0),ac(a),b=T.indexOf("\\n\\n",O);a>O&&(b=wb(T.substr(O,a-O)),K+=b);c&&bc();d&&(K+=T.substr(a,
d));O=a+d}}function dc(a){var b=a.i;a=a.j;var c=T.substr(b,a);Ub(b,0,!1);K+="<i>"+wb(c)+"</i>";Ib=!0;O=b+a}function ac(a){!G.A&&G.flags&8&&(cc(a),O<Pb&&(K+="<p>",G.A=!0))}function bc(){G.A&&(K+="</p>",G.A=!1)}function cc(a){for(;O<a&&-1<" \\n\\t".indexOf(T[O]);)K+=T[O],++O}function ec(a,b,c){var d=a.name;(I.flags|a.flags)&256&&(b=fc(b));b=Kb(d,b,0,c||0);Bb(b,a)}function fc(a){for(;a>O&&-1<" \\n\\t".indexOf(T[a-1]);)--a;return a}
function Tb(){if(Y.length){for(var a in X)Fb[a]=0,Gb[a]=0;do{for(;Y.length;)Ob||gc(),I=Y.pop(),hc();J.forEach(function(b){ec(b,Pb)})}while(Y.length)}}
function hc(){G.flags&64&&!Eb(I,J[J.length-1])&&!(-1<"br i pb v".indexOf(I.name))&&C(I);var a=I.i,b=I.j;if(O>a&&!I.o){var c;if((c=I.F)&&0<=J.indexOf(c)){Bb(Kb(c.name,O,Math.max(0,a+b-O)),c);return}if("i"===I.name&&(a=a+b-O,0<a)){Lb(O,a);return}C(I)}if(!I.o)if("i"===I.name)dc(I);else if("br"===I.name)G.flags&1024||(Ub(I.i,0,!1),K+="<br/>");else if("pb"===I.name)Ub(I.i,0,!0);else if("v"===I.name)a=G.flags,G.flags=I.flags,Ub(I.i+I.j,0,!1),G.flags=a;else if(I.k&1)if(a=I,b=a.name,c=X[b],Gb[b]>=c.g)B.add("err",
"Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.g}),C(a);else{var d=a,l=X[d.name];B.k=d;for(var k=0;k<l.c.length&&!d.o;++k)l.c[k](d,l);delete B.k;if(!(d=a.o)&&(d=1E4>Hb)){a:{d=a;if(J.length){k=d.name;var h=X[k];if(h.e.m){l=J[J.length-1];var t=l.name;if(h.e.m[t]){if(t!==k&&1E4>Hb){k=d.i+d.j;Y.length?(h=Y[Y.length-1],h=h.i):h=Pb+1;for(;k<h&&-1<" \\n\\t".indexOf(T[k]);)++k;k=ic(l,k);Ab(d,k)}Y.push(d);ec(l,d.i,d.q-1);Hb+=4;d=!0;break a}}}d=!1}if(!d)a:{d=a;if(J.length&&(l=X[d.name],l.e.l&&(k=J[J.length-
1],l.e.l[k.name]))){++Hb;Y.push(d);ec(k,d.i,d.q-1);d=!0;break a}d=!1}d=d||!1}d||(Fb[b]>=c.f?(B.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.f}),C(a)):(c=X[b].h,G.d[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.k)||a.y||Y.length&&Eb(Y[Y.length-1],a)||(b=new zb(3,b,a.i,a.j),Ja(b,Db(a)),b.flags=a.flags,a=b),a.flags&4096&&"\\n"===T[a.i+a.j]&&Lb(a.i+a.j,1),$b(a),jc(a)):(b={tag:a,tagName:b},0<a.j?B.add("warn","Tag is not allowed in this context",b):yb("Tag is not allowed in this context",b),C(a))))}else kc()}
function kc(){var a=I;if(Fb[a.name]){for(var b=[],c=J.length;0<=--c;){var d=J[c];if(Eb(a,d))break;b.push(d);++Hb}if(0>c)yb("Skipping end tag with no start tag",{tag:a});else{var l=a.flags;b.forEach(function(u){l|=u.flags});var k=l&256,h=1E4>Hb,t=[];b.forEach(function(u){var e=u.name;h&&(u.flags&2?t.push(u):h=!1);var f=a.i;k&&(f=fc(f));e=new zb(2,e,f,0);e.flags=u.flags;$b(e);lc()});$b(a);lc();if(b.length&&1E4>Hb){d=O;for(c=Y.length;0<=--c&&1E4>++Hb;){var p=Y[c];if(p.i>d||p.k&1)break;for(var v=b.length;0<=
--v&&1E4>++Hb;)if(Eb(p,b[v])){b.splice(v,1);t[v]&&t.splice(v,1);d=Math.max(d,p.i+p.j);break}}d>O&&dc(new zb(3,"i",O,d-O))}t.forEach(function(u){var e=ic(u,O);(u=u.y)&&Bb(e,u)})}}}function lc(){var a=J.pop();--Fb[a.name];G=G.V}function jc(a){var b=a.name,c=a.flags,d=X[b];++Gb[b];if(3!==a.k){var l=[];G.d.forEach(function(h,t){c&512||(h=h&65280|h>>8);l.push(d.d[t]&h)});var k=c|G.flags&32;k&16&&(k&=-33);++Fb[b];J.push(a);G={V:G};G.d=l;G.flags=k}}function Kb(a,b,c,d){return L(2,a,b,c,d||0)}
function Lb(a,b,c){return L(3,"i",a,Math.min(b,Pb-a),c||0)}function ic(a,b){b=L(a.k,a.name,b,0,a.q);Ja(b,Db(a));return b}function L(a,b,c,d,l){a=new zb(a,b,c,d,l||0);X[b]&&(a.flags=X[b].e.flags);if(!(X[b]||-1<"br i pb v".indexOf(a.name))||0>d||0>c||c+d>Pb||/[\\uDC00-\\uDFFF]/.test(T.substr(c,1)+T.substr(c+d,1)))C(a);else if(X[b]&&X[b].B)B.add("warn","Tag is disabled",{tag:a,tagName:b}),C(a);else if(Ob){b=Y.length;for(c=mc(a);0<b&&c>mc(Y[b-1]);)Y[b]=Y[b-1],--b;Y[b]=a}else Y.push(a);return a}
function M(a,b,c,d,l,k){d=Kb(a,d,l,-k||0);a=L(1,a,b,c,k||0);Bb(a,d);return a}function gc(){for(var a={},b=[],c=Y.length;0<=--c;){var d=Y[c],l=mc(d,c);b.push(l);a[l]=d}b.sort();c=b.length;for(Y=[];0<=--c;)Y.push(a[b[c]]);Ob=!0}function mc(a,b){var c=0<=a.q,d=a.q;c||(d+=1073741824);var l=0<a.j,k;l?k=Pb-a.j:k={2:0,3:1,1:2}[a.k];return nc(a.i)+ +c+nc(d)+ +l+nc(k)+nc(b||0)}function nc(a){a=a.toString(16);return"        ".substr(a.length)+a}var oc="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function pc(a){if(oc){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function qc(a,b){if(oc){var c=b.createElement("div");b=b.createDocumentFragment();rc.input=pc(a);rc.transform();for(c.innerHTML=rc.output;c.firstChild;)b.appendChild(c.firstChild);return b}return rc.transformToFragment(pc(a),b)}var rc,sc=pc(sb);
if(oc){var tc=new ActiveXObject("MSXML2.XSLTemplate.6.0");tc.stylesheet=sc;rc=tc.createProcessor()}else rc=new XSLTProcessor,rc.importStylesheet(sc);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){Mb[a]&&(Mb[a].B=!0)},disableTag:function(a){X[a]&&(Zb(a).B=!0)},enablePlugin:function(a){Mb[a]&&(Mb[a].B=!1)},enableTag:function(a){X[a]&&(Zb(a).B=!1)},getLogger:function(){return B},parse:Sb,preview:function(a,b){function c(h,t){var p=h.childNodes;t=t.childNodes;for(var v=p.length,u=t.length,e,f,q=0,r=0;q<v&&q<u;){e=p[q];f=t[q];if(!d(e,f))break;++q}for(var g=Math.min(v-q,u-q);r<g;){e=p[v-(r+1)];f=t[u-(r+1)];if(!d(e,f))break;++r}for(v-=r;--v>=q;)h.removeChild(p[v]),
k=h;p=u-r;if(!(q>=p)){u=l.createDocumentFragment();v=q;do f=t[v],k=u.appendChild(f);while(v<--p);r?h.insertBefore(u,h.childNodes[q]):h.appendChild(u)}}function d(h,t){if(h.nodeName!==t.nodeName||h.nodeType!==t.nodeType)return!1;if(h instanceof HTMLElement&&t instanceof HTMLElement){if(!h.isEqualNode(t)){for(var p=h.attributes,v=t.attributes,u=v.length,e=p.length,f=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--e;){var q=p[e],r=q.namespaceURI;q=q.name;-1<f.indexOf(" "+q+" ")||t.hasAttributeNS(r,
q)||(h.removeAttributeNS(r,q),k=h)}for(e=u;0<=--e;)p=v[e],r=p.namespaceURI,q=p.name,p=p.value,-1<f.indexOf(" "+q+" ")||p===h.getAttributeNS(r,q)||(h.setAttributeNS(r,q,p),k=h);c(h,t)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===t.nodeValue||(h.nodeValue=t.nodeValue,k=h);return!0}var l=b.ownerDocument;if(!l)throw"Target does not have a ownerDocument";a=qc(Sb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),l);var k=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(h){var t=
document.createElement("script");var p=h.attributes;var v="undefined"!=typeof Symbol&&Symbol.iterator&&p[Symbol.iterator];p=v?v.call(p):{next:ba(p)};for(v=p.next();!v.done;v=p.next())v=v.value,t.setAttribute(v.name,v.value);t.textContent=h.textContent;h.parentNode.replaceChild(t,h)});c(b,a);return k},registeredVars:Na,setNestingLimit:function(a,b){X[a]&&(Zb(a).f=b)},setParameter:function(a,b){oc?rc.addParameter(a,b,""):rc.setParameter(null,a,b)},setTagLimit:function(a,b){X[a]&&(Zb(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:10:{s:9:"Autoemail";a:5:{s:8:"attrName";s:5:"email";s:10:"quickMatch";s:1:"@";s:6:"regexp";s:39:"/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/Si";s:7:"tagName";s:5:"EMAIL";s:11:"regexpLimit";i:50000;}s:8:"Autolink";a:5:{s:8:"attrName";s:3:"url";s:6:"regexp";s:135:"#\\b(?:ftp|https?|mailto):(?>[^\\s()\\[\\]\\x{FF01}-\\x{FF0F}\\x{FF1A}-\\x{FF20}\\x{FF3B}-\\x{FF40}\\x{FF5B}-\\x{FF65}]|\\([^\\s()]*\\)|\\[\\w*\\])++#Siu";s:7:"tagName";s:3:"URL";s:10:"quickMatch";s:1:":";s:11:"regexpLimit";i:50000;}s:7:"Escaper";a:4:{s:10:"quickMatch";s:1:"\\";s:6:"regexp";s:30:"/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/";s:7:"tagName";s:3:"ESC";s:11:"regexpLimit";i:50000;}s:10:"FancyPants";a:2:{s:8:"attrName";s:4:"char";s:7:"tagName";s:2:"FP";}s:12:"HTMLComments";a:5:{s:8:"attrName";s:7:"content";s:10:"quickMatch";s:4:"<!--";s:6:"regexp";s:22:"/<!--(?!\\[if).*?-->/is";s:7:"tagName";s:2:"HC";s:11:"regexpLimit";i:50000;}s:12:"HTMLElements";a:5:{s:10:"quickMatch";s:1:"<";s:6:"prefix";s:4:"html";s:6:"regexp";s:385:"#<(?>/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?>\\s+[a-z][-a-z0-9]*(?>\\s*=\\s*(?>"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*+)\\s*/?)\\s*>#i";s:7:"aliases";a:6:{s:1:"a";a:2:{s:0:"";s:3:"URL";s:4:"href";s:3:"url";}s:2:"hr";a:1:{s:0:"";s:2:"HR";}s:2:"em";a:1:{s:0:"";s:2:"EM";}s:1:"s";a:1:{s:0:"";s:1:"S";}s:6:"strong";a:1:{s:0:"";s:6:"STRONG";}s:3:"sup";a:1:{s:0:"";s:3:"SUP";}}s:11:"regexpLimit";i:50000;}s:12:"HTMLEntities";a:5:{s:8:"attrName";s:4:"char";s:10:"quickMatch";s:1:"&";s:6:"regexp";s:38:"/&(?>[a-z]+|#(?>[0-9]+|x[0-9a-f]+));/i";s:7:"tagName";s:2:"HE";s:11:"regexpLimit";i:50000;}s:8:"Litedown";a:1:{s:18:"decodeHtmlEntities";b:1;}s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}s:10:"PipeTables";a:3:{s:16:"overwriteEscapes";b:1;s:17:"overwriteMarkdown";b:1;s:10:"quickMatch";s:1:"|";}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:27:"/^(?:ftp|https?|mailto)$/Di";}s:16:"MediaEmbed.hosts";a:13:{s:12:"bandcamp.com";s:8:"bandcamp";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:12:"facebook.com";s:8:"facebook";s:12:"liveleak.com";s:8:"liveleak";s:14:"soundcloud.com";s:10:"soundcloud";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:9:"twitch.tv";s:6:"twitch";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:10:{s:8:"bandcamp";a:2:{i:0;a:0:{}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:90;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:96;}}}}}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:119;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:84;}s:8:"facebook";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:119;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:141;}}i:1;R:84;}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:119;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:119;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:96;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:119;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:109;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:96;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:164;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:96;}}}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?\'id\'(?:user/[-.\\w]+/)?(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:119;}}i:1;R:84;}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:1;a:2:{i:0;s:44:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:7:"channel";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:126;}i:3;a:2:{i:0;s:56:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;R:84;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:119;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:126;}}i:1;R:84;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:119;}}i:1;R:84;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:119;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:119;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:126;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:119;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:96;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65329;i:2;i:257;}s:5:"flags";i:8;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:77:{s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:84;}s:8:"track_id";R:259;s:9:"track_num";R:259;}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:3:{i:0;i:32960;i:1;i:257;i:2;i:256;}}s:1:"C";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:66;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:0;i:1;i:0;i:2;i:0;}}s:4:"CODE";a:7:{s:10:"attributes";a:1:{s:4:"lang";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:23:"/^[- +,.0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:10:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:4436;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:284;}s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:259;s:1:"t";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:3:"DEL";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:512;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";R:251;}s:2:"EM";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:2;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65281;i:2;i:257;}}s:5:"EMAIL";a:7:{s:10:"attributes";a:1:{s:5:"email";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:61:"s9e\\TextFormatter\\Parser\\AttributeFilters\\EmailFilter::filter";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:514;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:3:{i:0;i:39819;i:1;i:65329;i:2;i:257;}}s:3:"ESC";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:1616;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:7;s:7:"allowed";R:284;}s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:259;s:4:"type";R:259;s:4:"user";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:2:"FP";a:7:{s:10:"attributes";a:1:{s:4:"char";a:2:{s:8:"required";b:1;s:11:"filterChain";R:84;}}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:8;s:7:"allowed";a:3:{i:0;i:32896;i:1;i:257;i:2;i:257;}}s:2:"H1";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:260;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:3;s:7:"allowed";R:331;}s:2:"H2";R:375;s:2:"H3";R:375;s:2:"H4";R:375;s:2:"H5";R:375;s:2:"H6";R:375;s:2:"HC";a:7:{s:10:"attributes";a:1:{s:7:"content";R:366;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3153;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:7;s:7:"allowed";R:284;}s:2:"HE";R:364;s:2:"HR";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:2:{s:11:"closeParent";R:300;s:5:"flags";i:3349;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:371;}s:3:"IMG";a:7:{s:10:"attributes";a:3:{s:3:"alt";R:259;s:3:"src";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:1;}s:5:"title";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:371;}s:8:"ISPOILER";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:0;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";R:331;}s:2:"LI";a:7:{s:11:"filterChain";a:2:{i:0;R:262;i:1;a:2:{s:8:"callback";s:58:"s9e\\TextFormatter\\Plugins\\TaskLists\\Helper::filterListItem";s:6:"params";a:3:{s:6:"parser";N;s:3:"tag";N;s:4:"text";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"LI";i:1;s:7:"html:li";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:264;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:4;s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65313;i:2;i:257;}}s:4:"LIST";a:7:{s:10:"attributes";a:2:{s:5:"start";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:341;}}s:8:"required";b:0;}s:4:"type";R:290;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:3460;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65424;i:1;i:65280;i:2;i:257;}}s:8:"LIVELEAK";a:7:{s:10:"attributes";a:1:{s:2:"id";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:16;s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65329;i:2;i:256;}}s:5:"QUOTE";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:268;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:440;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:259;s:11:"playlist_id";R:259;s:12:"secret_token";R:259;s:8:"track_id";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:7:"SPOILER";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:486;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:5;s:7:"allowed";R:440;}s:7:"SPOTIFY";R:460;s:6:"STRONG";R:325;s:3:"SUB";R:408;s:3:"SUP";R:408;s:5:"TABLE";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:452;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65290;i:2;i:257;}}s:4:"TASK";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:1;}s:5:"state";R:509;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:371;}s:5:"TBODY";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:20:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:5:"TBODY";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:5:"THEAD";i:1;s:2:"TR";i:1;s:10:"html:tbody";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:10:"html:thead";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:9;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65288;i:2;i:257;}}s:2:"TD";a:7:{s:10:"attributes";a:1:{s:5:"align";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:10:"strtolower";s:6:"params";R:341;}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"/^(?:center|justify|left|right)$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:14:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:440;}s:2:"TH";a:7:{s:10:"attributes";R:552;s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:564;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";a:3:{i:0;i:63463;i:1;i:65313;i:2;i:257;}}s:5:"THEAD";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:9;s:7:"allowed";R:547;}s:2:"TR";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:16:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:2:"TR";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:11;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65284;i:2;i:257;}}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:259;s:7:"clip_id";R:259;s:1:"t";R:259;s:8:"video_id";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:3:"URL";a:7:{s:10:"attributes";a:2:{s:5:"title";R:259;s:3:"url";R:396;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:345;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:349;}s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:259;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:341;}}s:8:"required";b:0;}}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:4:"VINE";R:460;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";R:510;s:8:"required";b:0;}s:4:"list";R:259;s:1:"t";R:636;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:270;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:274;}s:9:"html:abbr";a:7:{s:10:"attributes";a:1:{s:5:"title";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:410;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:331;}s:6:"html:b";R:325;s:7:"html:br";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3201;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65280;i:2;i:257;}}s:9:"html:code";R:278;s:7:"html:dd";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:dd";i:1;s:7:"html:dt";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:12;s:7:"allowed";R:440;}s:8:"html:del";R:319;s:8:"html:div";a:7:{s:10:"attributes";a:1:{s:5:"class";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:486;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:13;s:7:"allowed";R:251;}s:7:"html:dl";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:452;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65328;i:2;i:257;}}s:7:"html:dt";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:668;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:12;s:7:"allowed";R:587;}s:6:"html:i";R:325;s:8:"html:img";a:7:{s:10:"attributes";a:5:{s:3:"alt";R:259;s:6:"height";R:259;s:3:"src";a:2:{s:11:"filterChain";R:397;s:8:"required";b:0;}s:5:"title";R:259;s:5:"width";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:658;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:662;}s:8:"html:ins";R:319;s:7:"html:li";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:423;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:4;s:7:"allowed";R:440;}s:7:"html:ol";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:452;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:456;}s:8:"html:pre";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:276;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:331;}s:7:"html:rb";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:13:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:14;s:7:"allowed";R:331;}s:7:"html:rp";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:300;s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:15;s:7:"allowed";R:331;}s:7:"html:rt";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:15;s:7:"allowed";R:331;}s:8:"html:rtc";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:300;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:14;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65409;i:2;i:257;}}s:9:"html:ruby";a:7:{s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:410;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65473;i:2;i:257;}}s:9:"html:span";a:7:{s:10:"attributes";R:686;s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:410;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:331;}s:11:"html:strong";R:325;s:8:"html:sub";R:408;s:8:"html:sup";R:408;s:10:"html:table";R:499;s:10:"html:tbody";R:520;s:7:"html:td";a:7:{s:10:"attributes";a:2:{s:7:"colspan";R:259;s:7:"rowspan";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:564;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:440;}s:10:"html:tfoot";R:520;s:7:"html:th";a:7:{s:10:"attributes";a:3:{s:7:"colspan";R:259;s:7:"rowspan";R:259;s:5:"scope";R:259;}s:11:"filterChain";R:261;s:12:"nestingLimit";i:10;s:5:"rules";R:564;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:587;}s:10:"html:thead";R:591;s:7:"html:tr";R:597;s:6:"html:u";R:325;s:7:"html:ul";R:713;}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:42:"s9e\\TextFormatter\\Bundles\\Fatdown\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:1:{s:18:"TASKLISTS_EDITABLE";s:0:"";}}');
	}
}