//  Copyright (c) 2005-2014 Hartmut Kaiser
//  Copyright (c)      2011 Bryce Lelbach
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#pragma once

#include <pika/detail/filesystem.hpp>
#include <pika/ini/ini.hpp>

#include <map>
#include <memory>
#include <string>
#include <vector>

///////////////////////////////////////////////////////////////////////////////
namespace pika::util {
    ///////////////////////////////////////////////////////////////////////////
    bool handle_ini_file(pika::detail::section& ini, std::string const& loc);
    bool handle_ini_file_env(
        pika::detail::section& ini, char const* env_var, char const* file_suffix = nullptr);

    ///////////////////////////////////////////////////////////////////////////
    // read system and user specified ini files
    //
    // returns true if at least one alternative location has been read
    // successfully
    bool init_ini_data_base(pika::detail::section& ini, std::string& pika_ini_file);

    ///////////////////////////////////////////////////////////////////////////
    // global function to read component ini information
    void merge_component_inis(pika::detail::section& ini);
}    // namespace pika::util
