import { IEditorMimeTypeService } from '@jupyterlab/codeeditor';
import * as nbformat from '@jupyterlab/nbformat';
import { IEditorLanguageRegistry } from './token';
/**
 * The mime type service for CodeMirror.
 */
export declare class CodeMirrorMimeTypeService implements IEditorMimeTypeService {
    protected languages: IEditorLanguageRegistry;
    constructor(languages: IEditorLanguageRegistry);
    /**
     * Returns a mime type for the given language info.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     * There may be more than one mime type, but only the first one will be returned.
     * To access all mime types, use `IEditorLanguageRegistry` instead.
     */
    getMimeTypeByLanguage(info: nbformat.ILanguageInfoMetadata): string;
    /**
     * Returns a mime type for the given file path.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     * There may be more than one mime type, but only the first one will be returned.
     * To access all mime types, use `IEditorLanguageRegistry` instead.
     */
    getMimeTypeByFilePath(path: string): string;
}
