/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
import { ServiceManager } from '@jupyterlab/services';
import { UUID } from '@lumino/coreutils';
import { SessionContext } from './sessioncontext';
/**
 * Create a client session object.
 */
export async function createSessionContext(options = {}) {
    var _a, _b, _c, _d, _e;
    const manager = (_a = options.sessionManager) !== null && _a !== void 0 ? _a : Private.getManager().sessions;
    const specsManager = (_b = options.specsManager) !== null && _b !== void 0 ? _b : Private.getManager().kernelspecs;
    await Promise.all([manager.ready, specsManager.ready]);
    return new SessionContext({
        sessionManager: manager,
        specsManager,
        path: (_c = options.path) !== null && _c !== void 0 ? _c : UUID.uuid4(),
        name: options.name,
        type: options.type,
        kernelPreference: (_d = options.kernelPreference) !== null && _d !== void 0 ? _d : {
            shouldStart: true,
            canStart: true,
            name: (_e = specsManager.specs) === null || _e === void 0 ? void 0 : _e.default
        }
    });
}
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    let manager;
    /**
     * Get or create the service manager singleton.
     */
    function getManager() {
        if (!manager) {
            manager = new ServiceManager({ standby: 'never' });
        }
        return manager;
    }
    Private.getManager = getManager;
})(Private || (Private = {}));
//# sourceMappingURL=testutils.js.map