import { ServerConnection } from '../serverconnection';
import { PromiseDelegate } from '@lumino/coreutils';
/**
 * The nbconvert API service manager.
 */
export declare class NbConvertManager {
    /**
     * Create a new nbconvert manager.
     */
    constructor(options?: NbConvertManager.IOptions);
    /**
     * The server settings used to make API requests.
     */
    readonly serverSettings: ServerConnection.ISettings;
    /**
     * Fetch and cache the export formats from the expensive nbconvert handler.
     */
    protected fetchExportFormats(): Promise<NbConvertManager.IExportFormats>;
    /**
     * Get the list of export formats, preferring pre-cached ones.
     */
    getExportFormats(force?: boolean): Promise<NbConvertManager.IExportFormats>;
    protected _requestingFormats: PromiseDelegate<NbConvertManager.IExportFormats> | null;
    protected _exportFormats: NbConvertManager.IExportFormats | null;
}
/**
 * A namespace for `BuildManager` statics.
 */
export declare namespace NbConvertManager {
    /**
     * The instantiation options for a setting manager.
     */
    interface IOptions {
        /**
         * The server settings used to make API requests.
         */
        serverSettings?: ServerConnection.ISettings;
    }
    /**
     * A namespace for nbconvert API interfaces.
     */
    interface IExportFormats {
        /**
         * The list of supported export formats.
         */
        [key: string]: {
            output_mimetype: string;
        };
    }
}
/**
 * A namespace for builder API interfaces.
 */
export declare namespace NbConvert {
    /**
     * The interface for the build manager.
     */
    interface IManager extends NbConvertManager {
    }
}
