// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
/**
 * The notebook widget factory token.
 */
export const INotebookWidgetFactory = new Token('@jupyterlab/notebook:INotebookWidgetFactory', 'A service to create the notebook viewer.');
/**
 * The notebook tools token.
 */
export const INotebookTools = new Token('@jupyterlab/notebook:INotebookTools', `A service for the "Notebook Tools" panel in the
  right sidebar. Use this to add your own functionality to the panel.`);
/**
 * The notebook tracker token.
 */
export const INotebookTracker = new Token('@jupyterlab/notebook:INotebookTracker', `A widget tracker for notebooks.
  Use this if you want to be able to iterate over and interact with notebooks
  created by the application.`);
//# sourceMappingURL=tokens.js.map