# Руководство по стилю

На этой странице перечислены конкретные инструкции по форматированию для страниц `tldr`.

## Содержание

1.  [Общая структура](#общая-структура)
2.  [Страницы](#страницы)
3.  [Общие правила написания](#общие-правила-написания)
4.  [Заголовок](#заголовок)
5.  [Описания примеров](#описания-примеров)
6.  [Команды в примерах](#команды-в-примерах)
7.  [Правила для языков и переводов](#правила-для-языков-и-переводов)

## Общая структура

Основной формат каждой страницы должен соответствовать следующему шаблону и содержать не более 8 примеров команд:

```md
# имя-команды

> Краткое, емкое описание команды.
> Желательно в одну строку; две допустимы при необходимости.
> Больше информации: <https://example.com/command_name/help/page>.

- Описание кода:

`имя_команды опции`

- Описание кода:

`имя_команды опции`

...
```

Пример:

```md
# krita

> Программа для рисования и создания эскизов, предназначенная для цифровых художников.
> Смотрите также: `gimp`.
> Больше информации: <https://docs.krita.org/en/reference_manual/linux_command_line.html>.

- Запустить Krita:

`krita`

- Открыть определенные файлы:

`krita {{путь/к/изображению1 путь/к/изображению2 ...}}`

- Запустить без заставки:

`krita --nosplash`

- Запустить с определенным рабочим пространством:

`krita --workspace {{Анимация}}`

- Запустить в полноэкранном режиме:

`krita --fullscreen`
```

> [!NOTE]\
> Имя файла страницы и ее заголовок должны в точности совпадать с именем команды. Заголовок страницы может быть в любом регистре, тогда как имена файлов Markdown должны быть в нижнем регистре.

Существует линтер, который обеспечивает соблюдение вышеуказанного формата. Он запускается автоматически при каждом pull-request, но вы можете установить его для локальной проверки своих правок перед отправкой:

```sh
npm install --global tldr-lint
tldr-lint путь/к/tldr_page.md
```

Другие способы использования `tldr-lint`, например, для проверки целого каталога, описаны на
[`tldr странице о tldr-lint`](https://github.com/tldr-pages/tldr/blob/main/pages/common/tldr-lint.md). В качестве альтернативы можно использовать его псевдоним `tldrl`.

В зависимости от вашего клиента, вы можете просмотреть страницу локально, используя флаг `--render`:

```sh
tldr --render путь/к/tldr_page.md
```

### Правила для PowerShell

При документировании команд PowerShell, пожалуйста, обратите внимание на следующие соглашения об именовании.

- Имя файла должно быть написано в нижнем регистре, например, `invoke-webrequest.md` вместо `Invoke-WebRequest.md`.
- Заголовок страницы должен быть написан как есть (соответствуя написанию, задуманному Microsoft или автором модуля PowerShell), например, `Invoke-WebRequest` вместо `invoke-webrequest`.
- Имя команды и опции в примерах также должны быть написаны как есть, например, `Command-Name {{ввод}} -CommandParameter {{значение}}` вместо `command-name {{ввод}} -commandparameter {{значение}}`.

Из-за [различных отличий в совместимости](https://learn.microsoft.com/powershell/scripting/whats-new/differences-from-windows-powershell) и удаленных специфичных для Windows команд в PowerShell 6.x, убедитесь, что команда работает как в **PowerShell 5.1** (также известном как "Legacy Windows PowerShell", установленном в Windows 10 и 11), так и в **последней версии кроссплатформенного PowerShell** (ранее известного как PowerShell Core).

Таким образом, если команда или ее опции недоступны или имеют разное поведение в разных версиях, пожалуйста, отметьте это в описаниях. Например:

```md
# Clear-RecycleBin

> Очистить элементы из корзины.
> Примечание: Эта команда может использоваться только в PowerShell версий 5.1 и ниже, или 7.1 и выше.
> Больше информации: <https://learn.microsoft.com/powershell/module/microsoft.powershell.management/clear-recyclebin>.
```

## Страницы

### Различия между платформами

Если вы опасаетесь, что команды могут различаться между платформами или операционными системами (например, Windows и macOS), большинство [клиентов tldr-pages](https://github.com/tldr-pages/tldr/wiki/Clients) выберут наиболее подходящую версию команды для отображения конечному пользователю.

В этом случае информация о Windows-версии `cd` (хранящаяся в `pages/windows/cd.md`) будет по умолчанию отображаться пользователям Windows, а общая/универсальная версия (хранящаяся в `pages/common/cd.md`) будет отображаться пользователям Linux, macOS и других платформ.

Старайтесь, чтобы имя файла страницы соответствовало вызываемой команде. По возможности не используйте название проекта. Цель — быть как можно более прозрачным для пользователя, когда он интересуется командой.

### Псевдонимы (aliases)

Если команду можно вызвать под другим именем (например, `vim` можно вызвать как `vi`), можно создать страницы-псевдонимы, чтобы направить пользователя к оригинальному имени команды.

```md
# имя_команды

> Эта команда является псевдонимом для `оригинальное-имя-команды`.

- Посмотреть документацию для оригинальной команды:

`tldr оригинальное-имя-команды`
```

Пример:

```md
# vi

> Эта команда является псевдонимом для `vim`.

- Посмотреть документацию для оригинальной команды:

`tldr vim`

```

- Шаблоны для страниц-псевдонимов с готовыми переводами можно найти [здесь](https://github.com/tldr-pages/tldr/blob/main/contributing-guides/translation-templates/alias-pages.md).

#### Псевдонимы для PowerShell

Некоторые команды PowerShell могут вводить псевдонимы, которые делятся на три категории:

1. **Заменяет существующую команду командной строки Windows (`cmd`)**, например, `cd` является псевдонимом для `Set-Location` с другими опциями. В этом случае добавьте следующее примечание о псевдониме во вторую строку описания оригинальной команды `cmd`, например:

```md
# cd

> Показать текущий рабочий каталог или перейти в другой.
> В PowerShell эта команда является псевдонимом для `Set-Location`. Данная документация основана на версии `cd` для командной строки (`cmd`).
> Больше информации: <https://learn.microsoft.com/windows-server/administration/windows-commands/cd>.

- Посмотреть документацию для эквивалентной команды PowerShell:

`tldr set-location`
```

> [!NOTE]\
> Пример "Посмотреть документацию для эквивалентной команды PowerShell" является необязательным и должен быть исключен, если на странице уже достигнуто максимальное количество (8) примеров.

2. **Предоставляет новый псевдоним, но выполняемый только в PowerShell**, например, `ni` для `New-Item`. В этом случае используйте [стандартный шаблон псевдонима](https://github.com/tldr-pages/tldr/blob/main/contributing-guides/translation-templates/alias-pages.md), но добавьте фразу "В PowerShell," (или эквивалент), чтобы указать, что команда эксклюзивна для PowerShell. Например:

```md
# ni

> В PowerShell эта команда является псевдонимом для `New-Item`.
> Больше информации: <https://learn.microsoft.com/powershell/module/microsoft.powershell.management/new-item>.

- Посмотреть документацию для оригинальной команды:

`tldr new-item`
```

3. **Предоставляет новый псевдоним, который конфликтует с другими программами**, наиболее известный случай — включение `curl` и `wget` в качестве псевдонимов для `Invoke-WebRequest` (с несовместимым набором опций). Обратите внимание, что системные псевдонимы PowerShell, подпадающие под эту категорию, обычно эксклюзивны для Windows.

В этом случае предоставьте примечание и способ определить, относится ли текущая команда к команде PowerShell (через псевдоним) или к другой. Например:

```md
# curl

> В PowerShell эта команда может быть псевдонимом для `Invoke-WebRequest`, если оригинальная программа `curl` (<https://curl.se>) не установлена должным образом.
> Больше информации: <https://learn.microsoft.com/powershell/module/microsoft.powershell.utility/invoke-webrequest>.

- Проверить, правильно ли установлен `curl`, выведя номер его версии. Если эта команда приводит к ошибке, PowerShell, возможно, заменил эту команду на `Invoke-WebRequest`:

`curl --version`

- Посмотреть документацию для оригинальной команды `curl`:

`tldr curl -p common`

- Посмотреть документацию для команды PowerShell `Invoke-WebRequest`:

`tldr invoke-webrequest`
```

### Разрешение неоднозначностей (Disambiguations)

Если возникает конфликт имен между страницами на одной и той же платформе, можно использовать страницы для разрешения неоднозначностей, чтобы направить пользователей на разные страницы. Именуйте конфликтующие страницы с точкой и подходящим суффиксом. Если подходящего суффикса нет, можно использовать числа, начиная с 1. Если конфликтующая страница является акронимом, направьте пользователя на страницу с расшифрованным названием.

В следующем случае `just.md` — это имя файла страницы для разрешения неоднозначностей, в то время как `just.1.md` и `just.js.md` относятся к реальным страницам:

```md
# just

> `just` может относиться к нескольким командам с одинаковым названием.

- Посмотреть документацию для утилиты запуска команд:

`tldr just.1`

- Посмотреть документацию для среды выполнения V8 JavaScript:

`tldr just.js`
```

### Группировка команд

Иногда команды предназначены для использования в сочетании с другими. В таких случаях имеет смысл разместить их на одной странице.

Например, `adb disconnect` имеет единственный способ использования, но `adb` настолько обширна, что все не поместится на главной странице. Обычно `adb disconnect` используется в сочетании с `adb pair` и `adb connect`, поэтому имеет смысл сгруппировать их на одной странице. Например:

```md
# adb disconnect

> Эта команда была перенесена на страницу `adb connect`.

- Посмотреть документацию для `adb disconnect`:

`tldr adb connect`
```

## Общие правила написания

### Выделение

Не используйте *курсив*, **жирный шрифт** или любое другое стилистическое оформление текста на страницах. Они зарезервированы для выделения плейсхолдеров клиентами.

### Повелительное наклонение (Imperative Mood)

- **Все описания должны быть в повелительном наклонении.**
- Это правило по умолчанию применяется ко всем переводам, если иное не указано в разделе для конкретного языка ниже.

При написании описаний для примеров команд **проверяйте наличие грамматических ошибок**. Предпочтительнее `Перейти в указанный каталог`, чем:

- `Переход в указанный каталог` (не должно быть в форме отглагольного существительного)
- `Эта команда перейдет в указанный каталог` (очевидно, что этот пример относится к *этой* команде)
- `Давайте перейдем в указанный каталог!`
- `Смена каталога` (по возможности используйте активный залог вместо пассивного)

Например, вместо `Вывод списка всех файлов:` используйте следующее:

```md
- Показать все файлы:

 `ls`
```

### Серийная запятая (Оксфордская запятая)

> [!NOTE]\
> **Примечание для переводчиков:** Следующий раздел относится к правилам пунктуации в **английском языке**, которые важны для понимания при работе с оригинальными страницами или создании новых. В русской пунктуации эти правила не применяются.

- При перечислении 3 или более элементов в английских текстах используется [серийная запятая](https://en.wikipedia.org/wiki/Serial_comma), также известная как Оксфордская, поскольку ее отсутствие может создать двусмысленность.

Рассмотрим английский пример:

> Delete the Git branches, tags and remotes.
> (Удалить ветки, теги и удаленные репозитории Git.)

В примере выше не используется серийная запятая, что в английском языке может означать одно из двух:

- Удалить ветки Git с именами `tags` и `remotes`.
- Удалить все следующее: ветки Git, теги Git и удаленные репозитории Git.

Эту проблему решает запятая перед "and":

> Delete the Git branches, tags, and remotes.

> [!NOTE]\
> Названия брендов и проектов могут быть написаны с заглавной буквы в описании, где это применимо (например, используйте `Инструмент для взаимодействия с репозиторием Git.` вместо ``Инструмент для взаимодействия с репозиторием `git`.``).

### Особые случаи

Если команда выполняет необратимые изменения в файловой системе или на устройствах, пишите каждый пример так, чтобы его нельзя было бездумно скопировать и выполнить. Например, вместо `ddrescue --force --no-scrape /dev/sda /dev/sdb` пишите `ddrescue --force --no-scrape {{/dev/sdX}} {{/dev/sdY}}` и используйте плейсхолдер `{{/dev/sdXY}}` для *блочных устройств* вместо `/dev/sda1`.

В целом, плейсхолдеры должны делать использование команды и подстановку значений в нее максимально интуитивным.

Расшифровки акронимов (т.е. протоколов, инструментов и т.д.) не должны переводиться, если для них нет общепринятого эквивалента на родном языке.

Технические термины в строках описания должны использовать синтаксис `обратных кавычек`. Используйте обратные кавычки для следующего:

- Пути, например, `package.json`, `/etc/package.json`.
- Расширения, например, `.dll`.
- Команды, например, `ls`.
- Стандартные потоки: `stdout`, `stdin`, `stderr`. **Не** используйте полные названия (например, стандартный вывод).
- Алгоритмы сжатия, например, `zip`, `7z`, `xz`.

При описании клавиш или сочетаний клавиш для утилиты используйте тот же [синтаксис для клавиш](#синтаксис-для-клавиш), что и в примерах команд. Убедитесь, что он заключен в обратные кавычки, чтобы не быть невидимым в рендерах markdown (т.е. ``Вывести последние строки файла и продолжать чтение до нажатия `<Ctrl c>`:``).

Если для выполнения программы требуются права суперпользователя, и она не запрашивает пароль самостоятельно, добавьте в начало команды `sudo` (например, `sudo apt update`).

Избегайте объяснения общих концепций UNIX, которые могут применяться к любой команде (т.е. относительные/абсолютные пути, glob-шаблоны/wildcards, экранирование спецсимволов, возвращаемые значения программ и т.д.).

### Стандартизированные термины

Некоторые термины используются многократно на разных страницах и, следовательно, должны быть стандартизированы. К ним относятся:

| Термин | Стандарт | Объяснение |
| --- | --- | --- |
| Регулярное выражение | `` `regex` `` | `regex` определяет шаблон для поиска в строке символов (https://en.wikipedia.org/wiki/Regular_expression). |

## Заголовок

### Описание программы

- Избегайте использования названия страницы в описании (например, используйте `Программа для рисования и создания эскизов...` вместо `Krita — это программа для рисования и создания эскизов...`)
- Если название программы отличается от имени исполняемого файла, его можно указать в начале заголовка (например, `rg` и Ripgrep).
- Избегайте упоминания, что программа используется в командной строке (например, используйте `Ripgrep, инструмент для рекурсивного поиска по строкам` вместо `Ripgrep, CLI-инструмент для рекурсивного поиска по строкам`).

Например, при написании документации для `cd`, инструмента для перехода и работы в определенном каталоге в Терминале или Командной строке, **не** пишите длинное описание, такое как:

```md
> `cd` — это системный инструмент, доступный в Windows, macOS и Linux, для перехода в определенный каталог для выполнения задач в Командной строке, Терминале и PowerShell.
```

Вместо этого его следует упростить для облегчения чтения:

```md
> Изменить текущий рабочий каталог.
```

### Ссылки "Больше информации"

- В строке со ссылкой `Больше информации` предоставьте прямую ссылку на документацию, которая инструктирует по использованию команды. Мы предпочитаем ссылаться на документацию, предоставленную автором, но если она недоступна или содержит очень мало информации, используйте <https://manned.org> в качестве запасного варианта для всех платформ (кроме `osx` и платформ BSD, отличных от FreeBSD). Если страницу документации найти не удается, вы можете сослаться на сайт автора или стороннее руководство.
- Делайте ссылку "Больше информации" короткой. По возможности убирайте избыточный текст. Например, используйте https://manned.org/partclone вместо https://manned.org/man/partclone.8, если только нет двух разных man-страниц для команды в разных дистрибутивах/платформах, т.е. `command.1` и `command.8`.

- Для `osx`: Apple распространяет встроенные man-страницы [в Xcode](https://developer.apple.com/documentation/os/reading_unix_manual_pages). Для команд, документированных там, мы рекомендуем использовать <https://keith.github.io/xcode-man-pages/>, HTML-экспорт всех man-страниц Apple, поставляемых с Xcode.

> [!IMPORTANT]\
> Все ссылки должны быть заключены в угловые скобки (`<` и `>`).

- Рекомендуется использовать ссылку "Больше информации" с англоязычным контентом как в переводах, так и на английских страницах. Это связано с тем, что ссылки со временем могут меняться, а переводы часто отстают от английских страниц.

#### Ссылки с версиями

Когда у утилиты или дистрибутива есть версионированные ссылки на документацию, ссылайтесь на самую последнюю версию (т.е. `latest`) или не указывайте версию, если сайт автоматически перенаправляет на последнюю версию.

Например, используйте:

- <https://manpages.debian.org/latest/apt/apt.8.html> вместо <https://manpages.debian.org/bookworm/apt/apt.8.en.html>.
- <https://docs.aws.amazon.com/cdk/latest/guide/cli.html> вместо <https://docs.aws.amazon.com/cdk/v2/guide/cli.html>.

#### Ссылки на Microsoft Learn

При ссылке на страницы Microsoft Learn удаляйте из адреса локаль, так как сайт автоматически перенаправит на предпочитаемую локаль читателя. Например, используйте <https://learn.microsoft.com/windows-server/administration/windows-commands/cd> вместо <https://learn.microsoft.com/en-us/windows-server/administration/windows-commands/cd>.

Кроме того, если ссылка относится к документации команды PowerShell, удалите **индикатор версии документации** (указывающий версию PowerShell/модуля, из которой взята документация), т.е. часть адреса, которая начинается с `?view=`.

- Используйте <https://learn.microsoft.com/powershell/module/microsoft.powershell.utility/select-string> вместо <https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/select-string?view=powershell-7.4>.
- Используйте <https://learn.microsoft.com/powershell/module/powershellget/install-module> вместо <https://learn.microsoft.com/en-us/powershell/module/powershellget/install-module?view=powershellget-1.x>.

### Раздел "Смотрите также"

- Чтобы сослаться на связанную команду или подкоманду, используйте:

```md
> Смотрите также: `команда`.
```

- Чтобы сослаться на несколько связанных команд или подкоманд, используйте:

```md
> Смотрите также: `команда1`, `команда2`, `команда3`.
```

- При желании можно добавить краткое описание рядом со ссылками:

```md
> Смотрите также: `date` для информации Unix, `uname` для системной информации и `umount` для размонтирования разделов.
```

- Когда команда имеет подкоманды, на эти страницы можно сослаться следующей строкой. Обратите внимание, что указывается только имя подкоманды:

```md
> Некоторые подкоманды, такие как `commit`, `add`, `branch`, `switch`, `push` и др., имеют собственную документацию по использованию.
```

## Описания примеров

### Мнемоники для коротких опций

Мнемоники для коротких опций — это необязательные подсказки, которые можно добавить, чтобы помочь пользователям понять значение этих опций. Назначенные мнемоники должны совпадать с теми, что указаны в официальной документации команды (например, из `man` или `Get-Help`). Например:

```md
- Отобразить ([d]isplay) iD ([i]D) установки (ins[t]allation) для текущего устройства. Полезно для офлайн-активации лицензии:

`slmgr.vbs /dti`

- Отобразить дату и время иcтечения cрока (e[xp]i[r]ation) действия текущей лицензии:

`slmgr.vbs /xpr`
```
Обратите внимание, что в первом примере символы `[d]`, `[t]` и `[i]` заключены в квадратные скобки. Это указывает, что опция `/dti` является комбинацией слов, от которых взяты эти буквы: `[d]` от "display" (отобразить), `[t]` от "installation" (установка) и `[i]` от "ID" (идентификатор). Группируйте последовательные мнемонические символы в одних и тех же квадратных скобках, например: `e[xp]i[r]ation` вместо `e[x][p]i[r]ation`.

**Мнемонические символы должны быть написаны с учетом регистра**, даже если они стоят в начале предложения (т.е. используйте `[d]isplay` вместо `[D]isplay`). Это делается для избежания конфликтов с опциями в стиле GNU, которые могут по-разному интерпретировать опции в верхнем и нижнем регистре, например, `-v` для отображения `[v]ersion` команды и `-V` для запуска команды в `[V]erbose` режиме.

Мнемоники опций также могут использоваться в переводах, если выделенное слово имеет схожее значение с языком (обычно английским), для которого написана команда.
Например, `[d]ownload` в английском может быть переведено как `[d]escargar` на испанском, `[i]nstall` как `[i]nstallieren` на немецком, а `[a]pp` как `[a]plikasi` на индонезийском и малайском.

- При желании мнемоники и заключенные в них термины можно отделять скобками от остального описания (т.е. `([a]ll)`) в переводах и на определенных страницах для предоставления дополнительного контекста или упоминания слова, отсутствующего в описании.

> [!NOTE]\
> В случаях, когда символ отсутствует в переведенном слове, вы можете выделить опцию рядом с эквивалентным словом или добавить английское слово рядом с переводом в скобках.
> Например, `E[x]tract` на английском может быть переведено как `извлечь [x]` или `извлечь (E[x]tract)`.

## Команды в примерах

### Порядок аргументов

Старайтесь придерживаться следующего порядка:

- Имя программы
- Перенаправление ввода из файла
- Все подкоманды
- Позиционные аргументы/Пакеты/Данные/...
- Флаги опций
- Опции с аргументами
- Перенаправление вывода в файл

Например: `systemctl < входной_файл.txt status pipewire --user > выходной_файл.txt`

Это лишь рекомендация, и от нее следует отступать, если этого требует функциональность программы или читаемость. Например, если на странице в разных командах повторяются аргументы, старайтесь выравнивать их по вертикали.

Если команда выполняет несколько действий, старайтесь сохранять хронологический порядок их выполнения.

### Синтаксис опций

- Для удобства пользователя предпочитайте **длинные опции в стиле GNU** (например, `--help` вместо `-h`). Убедитесь, что опции кроссплатформенны (предназначены для одинаковой работы на разных платформах) для страниц в каталоге `common`.
- Чтобы клиент мог сам решать, показывать длинные или короткие опции в командах, используйте плейсхолдер опции, т.е. `{{[-o|--output]}}`.
- Если команда поддерживает только короткие опции или короткая опция сильно отличается от длинной, попытайтесь документировать, сокращением чего является буква, с помощью [мнемоники](#мнемоники-для-коротких-опций).
- Предпочитайте группировать флаги вместе, если программа это поддерживает (т.е. `{{[-it|--interactive --tty]}}` вместо `{{[-i|--interactive]}} {{[-t|--tty]}}`).
- Предпочитайте не группировать опции, принимающие аргументы (т.е. `{{[-it|--interactive --tty]}} {{[-w|--workdir]}} {{путь/к/каталогу}}` вместо `{{[-itw|--interactive --tty --workdir]}} {{путь/к/каталогу}}`)
- Предпочитайте использовать пробел вместо знака равенства (`=`) для разделения опций и их аргументов (т.е. используйте `--opt arg` вместо `--opt=arg`), если программа не поддерживает иное.
- Аналогично, предпочитайте отделять короткие опции от их аргументов пробелом (т.е. используйте `-o arg` вместо `-oarg`), если программа не поддерживает иное.
- Если команда поддерживает только `-oarg` и `--opt=arg`, плейсхолдер опции должен быть написан так: `{{[-o|--opt=]}}аргумент`. Учитывайте, как будет выглядеть команда, если клиент отобразит только короткие или только длинные опции.

### Синтаксис плейсхолдеров

Значения, предоставляемые пользователем, должны использовать синтаксис `{{плейсхолдер}}`, чтобы клиенты `tldr` могли их подсвечивать.

> [!TIP]\
> Рекомендуется заключать плейсхолдеры, принимающие строки, в кавычки. т.е. используйте `"{{плейсхолдер}}"` вместо `{{"плейсхолдер"}}`.

При выборе плейсхолдеров придерживайтесь следующих рекомендаций:

#### Именование

- Используйте короткие, но описательные плейсхолдеры, такие как `{{путь/к/исходному_файлу}}` или `{{путь/к/кошельку.txt}}`.
- Используйте [`snake_case`](https://wikipedia.org/wiki/snake_case) для плейсхолдеров из нескольких слов.

#### Пути

- Используйте `{{имя_файла}}`, когда ожидается только имя файла.
- Для любой ссылки на пути к файлам или каталогам используйте формат `{{путь/к/плейсхолдеру}}`, за исключением случаев, когда местоположение подразумевается.
- Когда путь не может быть относительным и должен начинаться с корня файловой системы, ставьте слэш перед плейсхолдером, например, `get /{{путь/к/удаленному_файлу}}`.
- В случае возможной ссылки как на файл, так и на каталог, используйте `{{путь/к/файлу_или_каталогу}}`.

> [!NOTE]\
> Если команда специфична для Windows, используйте обратные слэши (`\`), например, `{{путь\к\файлу_или_каталогу}}`. Буквы дисков, такие как `C:`, необязательны, если только ввод команды не требует абсолютного пути или определенного диапазона букв дисков, например, `cd /d {{C}}:{{путь\к\каталогу}}`.

#### Расширения

- Если для файла ожидается определенное расширение, добавьте его. Например, `unrar x {{путь/к/архиву.rar}}`.
- В случае, когда требуется общее расширение, используйте `{{.ext}}`, но **только** если расширение обязательно. Например, в примере "Найти файлы по расширению" на странице `find.md` (`find {{путь/к/корневому_каталогу}} -name '{{*.ext}}'`) использование `{{*.ext}}` объясняет команду, не будучи излишне конкретным; в то время как в `wc -l {{путь/к/файлу}}` достаточно использовать `{{путь/к/файлу}}` (без расширения).

#### Группировка плейсхолдеров

- Если команда может опционально принимать 1 или более аргументов одного типа, используйте многоточие: `{{плейсхолдер1 плейсхолдер2 ...}}`. Например, если ожидается несколько путей, используйте `{{путь/к/каталогу1 путь/к/каталогу2 ...}}`.
- Если возможен только один из нескольких вариантов, запишите его так: `{{плейсхолдер1|плейсхолдер2|плейсхолдер3}}`. Если возможных значений больше 3, можно использовать `|...` после последнего элемента.
- Используйте две точки для обозначения диапазона возможных значений, например, `{{1..5}}` или `{{a..z}}`.

#### Необязательные плейсхолдеры

При документировании необязательных плейсхолдеров, таких как пути или расширения файлов, рекомендуется указывать их в описании страницы или примера, а не в самом плейсхолдере. Например:

- Используйте `{{путь/к/источнику.ext}}` вместо `{{путь/к/источнику.tar[.gz|.bz2|.xz]}}`.

#### Исключения

- Не вставляйте плейсхолдеры внутрь других плейсхолдеров.

- Не используйте плейсхолдеры, когда значение явно указано в описании команды. Например:

```md
- Обновлять вывод каждые 2 секунды:

`free {{[-s|--seconds]}} 2`
```

### Синтаксис для клавиш

Для обозначения нажатий клавиш в TUI или GUI программах используйте угловые скобки `<` и `>`.

- Пример с одним символом: `<a>`.
- Специальные клавиши должны быть написаны в стиле [`PascalCase`](https://www.theserverside.com/definition/Pascal-case): `<Ctrl>`, `<Super>`, `<Alt>`, `<Shift>`, `<Cmd>`, `<Option>`, `<Windows>`, `<Enter>`, `<Home>`, `<Space>`, `<Esc>`, `<ArrowUp>`, `<ArrowLeft>`, `<ArrowKeys>`, `<PageUp>`, `<F5>`, `<F12>`, `<LeftClick>`, `<MiddleClick>`, ...
- Специальные клавиши могут быть переведены, если для них существуют общепринятые переводы.
- Когда программа принимает символы в верхнем регистре, обозначайте их как `<A>` вместо обозначения с `shift`. В остальных случаях всегда обозначайте символы в нижнем регистре.
- Обозначайте одновременные нажатия клавиш внутри одних угловых скобок, разделяя их одним пробелом: `<Ctrl c>`, `<Alt F4>`, `<Ctrl Shift k>`, `<Super Shift PrtSc>`.
- При написании одновременных нажатий клавиш придерживайтесь следующего порядка: `<Ctrl Super Windows Alt AltGr Shift все_остальное>`.
- Последовательные нажатия клавиш должны быть заключены в свои собственные угловые скобки без пробела между ними: `<Esc><u>`, `<Ctrl k><Ctrl s>`, `<Enter><~><.>`, `<d><o>`.
- Клавиши, которые вводятся в приглашение, не нужно обозначать как нажатия: `<:>help<Enter>`. Обратите внимание, что клавиша переключения контекста обозначена в угловых скобках, несмотря на то, что она печатается в приглашении.

### Команды help и version

- Мы обычно размещаем, **в таком порядке**, команды для получения справки и версии в качестве **двух последних** примеров на странице, чтобы выделить более практичные команды в начале. Их можно заменить для размещения других полезных примеров при необходимости.
- Для единообразия мы предпочитаем общие формулировки `Показать справку` и `Показать версию` для этих команд.
- Рекомендуется документировать примеры для справки и версии, если команда использует нестандартные флаги на таких платформах, как Windows.

## Правила для языков и переводов

Ниже приведены дополнительные правила, специфичные для языков и переводов:

### Общие

Не переводите `example.com`. Этот домен [зарезервирован IANA для целей документации](https://www.iana.org/help/example-domains) и никому не будет передан. Перевод имени сайта может подвергнуть риску неосторожных пользователей.

### Правила для английского языка

Обычный дефис (`-`) следует использовать в тех случаях, где различные руководства по стилю могут рекомендовать среднее (`–`) или длинное тире (`—`).

- Например, используйте `for lengths 3-12` вместо `for lengths 3–12`

Причин для этого четыре:

1. Нет общепринятого стандарта среди различных руководств по стилю о том, когда следует использовать каждый из этих видов тире.
2. Дефис (`-`) — единственный тире-подобный символ в ASCII, что снижает вероятность проблем с совместимостью.
3. Дефис (`-`) намного проще всего набирать.
4. Многие носители английского языка, особенно неродные, не знают о разнице.

*(Примечание: Разделы с правилами для китайского, индонезийского, французского, португальского и испанского языков были опущены, так как они не относятся к русскому переводу.)*
