' uBasic - Date functions - Copyright 2022 J.L. Bezemer
' You can redistribute this file and/or modify it under
' the terms of the GNU General Public License

Print Show (FUNC(_DateStr (Time())))
Print Show (FUNC(_TimeStr (Time())))
Print Show (FUNC(10*(1+FUNC(_Weekday (Time())))))
End

_DateStr                               ' convert epoch to date string
  Param (1)
  Local (6)

  a@ = a@ / 86400                      ' just get the number of days since epoch
  b@ = 1970+(a@/365)                   ' ball parking year, will not be accurate!

  d@ = 0
  For c@ = 1972 To b@ - 1 Step 4
    If (((c@%4) = 0) * ((c@%100) # 0)) + ((c@%400) = 0) Then d@ = d@+1
  Next

  b@ = 1970+((a@ - d@)/365)            ' calculating accurate current year by (x - extra leap days)
  e@ = ((a@ - d@)%365)+1               ' if current year is leap, set indicator to 1
  f@ = (((b@%4) = 0) * ((b@%100) # 0)) + ((b@%400) = 0)

  g@ = 0                               ' calculating current month
  For c@ = 0 To 11 Until e@ < (g@+1)
    g@ = g@ + FUNC(_Monthdays (c@, f@))
  Next
                                       ' calculating current date
  g@ = g@ - FUNC(_Monthdays (c@-1, f@))
                                       ' Print a@, d@, e@, f@
Return (Join (Str(b@), FUNC(_Format (c@, Dup("-"))), FUNC(_Format (e@ - g@, Dup("-")))))

_TimeStr                               ' convert epoch to time string
  Param (1)
Return (Join(Str((a@%86400)/3600), FUNC(_Format ((a@%3600)/60, Dup(":"))), FUNC(_Format (a@%60, Dup(":")))))

_Format    Param (2) : Return (Join (Iif (a@<10, Join(b@, "0"), b@), Str (a@)))
_Monthdays Param (2) : Return (((a@ + (a@<7)) % 2) + 30 - ((2 - b@) * (a@=1)))
_Weekday   Param (1) : Return (((a@/86400)+3)%7)

10 Return (Dup("Monday"))
20 Return (Dup("Tuesday"))
30 Return (Dup("Wednesday"))
40 Return (Dup("Thursday"))
50 Return (Dup("Friday"))
60 Return (Dup("Saturday"))
70 Return (Dup("Sunday"))

