\ 4tH library - FILTERING - Copyright 2021 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

[UNDEFINED] filtering [IF]
[UNDEFINED] c/string  [IF] include lib/cstring.4th [THEN]
[UNDEFINED] break?    [IF] include lib/breakq.4th  [THEN]
[UNDEFINED] ?not      [IF] include lib/yesno.4th   [THEN]

: (filter)                             ( a1 n1 a2 n2 -- a1 n3)
  2>r stow stow begin                  ( a1 a1 a1 n1)
    dup                                \ no more string?
  while                                \ if so, check character
    c/string dup true 2r@ bounds break? ?not
    if -rot 2>r over c! char+ 2r> else drop then
  repeat rdrop rdrop 2drop over -      \ keep it if it's a keeper
;                                      \ clean up, calculate length

: filtering ['] (yes) is ?not (filter) ;
: keepchar  ['] (no)  is ?not (filter) ;

[DEFINED] 4TH# [IF] hide (filter) [THEN]
[THEN]
 
\ s" a1b2c3d4e5f6g7h8i9j0k" s" 1234567890" keepchar type cr
\ s" She was a soul stripper. She took my heart!" s" aei" filtering type cr
\ depth .

