/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.HexDumpFileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.AppleCommander;
import com.webcodepro.applecommander.ui.DirectoryLister;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.ac;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import com.webcodepro.applecommander.util.TranslatorStream;
import io.github.applecommander.applesingle.AppleSingle;
import io.github.applecommander.applesingle.ProdosFileInfo;
import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Parser;
import io.github.applecommander.bastools.api.TokenReader;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.Program;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;

/*
 * Exception performing whole class analysis ignored.
 */
public class ac {
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ac.help();
            } else if ("-i".equalsIgnoreCase(args[0])) {
                ac.getDiskInfo((String[])args);
            } else if ("-ls".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.text((int)1), (String[])args);
            } else if ("-l".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.text((int)2), (String[])args);
            } else if ("-ll".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.text((int)3), (String[])args);
            } else if ("-lsv".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.csv((int)1), (String[])args);
            } else if ("-lv".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.csv((int)2), (String[])args);
            } else if ("-llv".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.csv((int)3), (String[])args);
            } else if ("-lsj".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.json((int)1), (String[])args);
            } else if ("-lj".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.json((int)2), (String[])args);
            } else if ("-llj".equalsIgnoreCase(args[0])) {
                ac.showDirectory((DirectoryLister)DirectoryLister.json((int)3), (String[])args);
            } else if ("-e".equalsIgnoreCase(args[0])) {
                ac.getFile((String)args[1], (String)args[2], (boolean)true, (PrintStream)(args.length > 3 ? new PrintStream(new FileOutputStream(args[3])) : System.out));
            } else if ("-x".equalsIgnoreCase(args[0])) {
                ac.getFiles((String)args[1], (String)(args.length > 2 ? args[2] : ""));
            } else if ("-g".equalsIgnoreCase(args[0])) {
                ac.getFile((String)args[1], (String)args[2], (boolean)false, (PrintStream)(args.length > 3 ? new PrintStream(new FileOutputStream(args[3])) : System.out));
            } else if ("-p".equalsIgnoreCase(args[0])) {
                ac.putFile((String)args[1], (Name)new Name(args[2]), (String)args[3], (String)(args.length > 4 ? args[4] : "0x2000"));
            } else if ("-pt".equalsIgnoreCase(args[0])) {
                ac.putTxtFileSetHighBit((String)args[1], (Name)new Name(args[2]));
            } else if ("-ptx".equalsIgnoreCase(args[0])) {
                ac.putTxtFileClearHighBit((String)args[1], (Name)new Name(args[2]));
            } else if ("-d".equalsIgnoreCase(args[0])) {
                ac.deleteFile((String)args[1], (String)args[2]);
            } else if ("-k".equalsIgnoreCase(args[0])) {
                ac.setFileLocked((String)args[1], (String)args[2], (boolean)true);
            } else if ("-u".equalsIgnoreCase(args[0])) {
                ac.setFileLocked((String)args[1], (String)args[2], (boolean)false);
            } else if ("-n".equalsIgnoreCase(args[0])) {
                ac.setDiskName((String)args[1], (String)args[2]);
            } else if ("-cc65".equalsIgnoreCase(args[0])) {
                System.err.println("Note: -cc65 is deprecated.  Please use -as or -dos as appropriate.");
                ac.putDOS((String)args[1], (Name)new Name(args[2]), (String)args[3]);
            } else if ("-dos".equalsIgnoreCase(args[0])) {
                ac.putDOS((String)args[1], (Name)new Name(args[2]), (String)args[3]);
            } else if ("-as".equalsIgnoreCase(args[0])) {
                ac.putAppleSingle((String)args[1], args.length >= 3 ? args[2] : null);
            } else if ("-geos".equalsIgnoreCase(args[0])) {
                ac.putGEOS((String)args[1]);
            } else if ("-dos140".equalsIgnoreCase(args[0])) {
                ac.createDosDisk((String)args[1], (int)143360);
            } else if ("-pas140".equalsIgnoreCase(args[0])) {
                ac.createPasDisk((String)args[1], (String)args[2], (int)143360);
            } else if ("-pas800".equalsIgnoreCase(args[0])) {
                ac.createPasDisk((String)args[1], (String)args[2], (int)819200);
            } else if ("-pro140".equalsIgnoreCase(args[0])) {
                ac.createProDisk((String)args[1], (String)args[2], (int)143360);
            } else if ("-pro800".equalsIgnoreCase(args[0])) {
                ac.createProDisk((String)args[1], (String)args[2], (int)819200);
            } else if ("-convert".equalsIgnoreCase(args[0])) {
                if (args.length > 3) {
                    ac.convert((String)args[1], (String)args[2], (int)Integer.parseInt(args[3]));
                } else {
                    ac.convert((String)args[1], (String)args[2]);
                }
            } else if ("-bas".equalsIgnoreCase(args[0])) {
                ac.putAppleSoft((String)args[1], (String)args[2]);
            } else {
                ac.help();
            }
        }
        catch (Exception ex) {
            System.err.println(textBundle.format("CommandLineErrorMessage", new Object[]{ex.getLocalizedMessage()}));
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void putAppleSoft(String imageName, String fileName) throws IOException, DiskException {
        File fakeTempSource = File.createTempFile("ac-", "bas");
        fakeTempSource.deleteOnExit();
        Configuration config = Configuration.builder().sourceFile(fakeTempSource).build();
        Queue tokens = TokenReader.tokenize((InputStream)System.in);
        Parser parser = new Parser(tokens);
        Program program = parser.parse();
        byte[] data = Visitors.byteVisitor((Configuration)config).dump(program);
        Name name = new Name(fileName);
        File file = new File(imageName);
        if (!file.canRead()) {
            throw new IOException("Unable to read input file named " + imageName + ".");
        }
        Disk disk = new Disk(imageName);
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDisks[0];
        String fileType = Arrays.asList(formattedDisk.getFiletypes()).stream().filter(ft -> "A".equalsIgnoreCase((String)ft) || "BAS".equalsIgnoreCase((String)ft)).findFirst().orElse("A");
        FileEntry entry = name.createEntry(formattedDisk);
        if (entry != null) {
            entry.setFiletype(fileType);
            entry.setFilename(formattedDisk.getSuggestedFilename(name.name));
            entry.setFileData(data);
            if (entry.needsAddress()) {
                entry.setAddress(config.startAddress);
            }
            formattedDisk.save();
        }
    }

    public static void putFile(String fileName, String imageName, String fileOnImageName, String fileType, String address) throws IOException, DiskException {
        Name name = new Name(fileOnImageName);
        File file = new File(fileName);
        if (!file.canRead()) {
            throw new IOException("Unable to read input file named " + fileName + ".");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] inb = new byte[1024];
        int byteCount = 0;
        try (FileInputStream is = new FileInputStream(file);){
            while ((byteCount = ((InputStream)is).read(inb)) > 0) {
                buf.write(inb, 0, byteCount);
            }
            Disk disk = new Disk(imageName);
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            FormattedDisk formattedDisk = formattedDisks[0];
            FileEntry entry = name.createEntry(formattedDisk);
            if (entry != null) {
                entry.setFiletype(fileType);
                entry.setFilename(formattedDisk.getSuggestedFilename(name.name));
                entry.setFileData(buf.toByteArray());
                if (entry.needsAddress()) {
                    entry.setAddress(ac.stringToInt((String)address));
                }
                formattedDisk.save();
            }
        }
    }

    static void putFile(String imageName, Name name, String fileType, String address) throws IOException, DiskException {
        ac.putFile((String)imageName, (Name)name, (String)fileType, (String)address, (InputStream)System.in);
    }

    static void putTxtFileSetHighBit(String imageName, Name name) throws IOException, DiskException {
        ac.putFile((String)imageName, (Name)name, (String)"TXT", (String)"0", (InputStream)TranslatorStream.builder((InputStream)System.in).lfToCr().setHighBit().get());
    }

    static void putTxtFileClearHighBit(String imageName, Name name) throws IOException, DiskException {
        ac.putFile((String)imageName, (Name)name, (String)"TXT", (String)"0", (InputStream)TranslatorStream.builder((InputStream)System.in).lfToCr().clearHighBit().get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void putFile(String imageName, Name name, String fileType, String address, InputStream inputStream) throws IOException, DiskException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        StreamUtil.copy((InputStream)inputStream, (OutputStream)buf);
        Disk disk = new Disk(imageName);
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        if (formattedDisks == null) {
            System.out.println("Dude, formattedDisks is null!");
        }
        FormattedDisk formattedDisk = formattedDisks[0];
        if (disk.isSDK() || disk.isDC42()) throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        FileEntry entry = name.createEntry(formattedDisk);
        if (entry == null) throw new IOException("Unable to create entry...");
        entry.setFiletype(fileType);
        entry.setFilename(formattedDisk.getSuggestedFilename(name.name));
        entry.setFileData(buf.toByteArray());
        if (entry.needsAddress()) {
            entry.setAddress(ac.stringToInt((String)address));
        }
        formattedDisk.save();
    }

    public static void putDOS(String fileName, String imageName, String fileOnImageName, String fileType) throws IOException, DiskException {
        byte[] header = new byte[4];
        if (System.in.read(header, 0, 4) == 4) {
            int address = AppleUtil.getWordValue((byte[])header, (int)0);
            ac.putFile((String)fileName, (String)imageName, (String)fileOnImageName, (String)fileType, (String)Integer.toString(address));
        }
    }

    static void putDOS(String imageName, Name name, String fileType) throws IOException, DiskException {
        byte[] header = new byte[4];
        if (System.in.read(header, 0, 4) == 4) {
            int address = AppleUtil.getWordValue((byte[])header, (int)0);
            ac.putFile((String)imageName, (Name)name, (String)fileType, (String)Integer.toString(address));
        }
    }

    public static void putAppleSingle(String imageName, String fileName) throws IOException, DiskException {
        ac.putAppleSingle((String)imageName, (String)fileName, (InputStream)System.in);
    }

    public static void putAppleSingle(String imageName, String fileName, InputStream inputStream) throws IOException, DiskException {
        AppleSingle as = AppleSingle.read((InputStream)inputStream);
        if (fileName == null) {
            fileName = as.getRealName();
        }
        if (fileName == null) {
            throw new IOException("Please specify a file name - this AppleSingle does not have one.");
        }
        if (as.getProdosFileInfo() == null) {
            throw new IOException("This AppleSingle does not contain a ProDOS file.");
        }
        if (as.getDataFork() == null || as.getDataFork().length == 0) {
            throw new IOException("This AppleSingle does not contain a data fork.");
        }
        Name name = new Name(fileName);
        ProdosFileInfo info = as.getProdosFileInfo();
        String fileType = ProdosFormatDisk.getFiletype((int)info.getFileType());
        ac.putFile((String)imageName, (Name)name, (String)fileType, (String)Integer.toString(info.getAuxType()), (InputStream)new ByteArrayInputStream(as.getDataFork()));
    }

    static void putGEOS(String imageName) throws IOException, DiskException {
        ac.putFile((String)imageName, (Name)new Name("GEOS-Should Be ProDOS"), (String)"GEO", (String)"0");
    }

    static void deleteFile(String imageName, String fileName) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        Name name = new Name(fileName);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                FileEntry entry = name.getEntry(formattedDisk);
                if (entry != null) {
                    entry.delete();
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", new Object[]{name.fullName}));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    static void getFile(String imageName, String fileName, boolean filter, PrintStream out) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        Name name = new Name(fileName);
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        if (out == null) {
            out = System.out;
        }
        for (int i = 0; i < formattedDisks.length; ++i) {
            FormattedDisk formattedDisk = formattedDisks[i];
            FileEntry entry = name.getEntry(formattedDisk);
            if (entry != null) {
                if (filter) {
                    FileFilter ff = entry.getSuggestedFilter();
                    if (ff instanceof BinaryFileFilter) {
                        ff = new HexDumpFileFilter();
                    }
                    byte[] buf = ff.filter(entry);
                    out.write(buf, 0, buf.length);
                    continue;
                }
                byte[] buf = entry.getFileData();
                out.write(buf, 0, buf.length);
                continue;
            }
            System.err.println(textBundle.format("CommandLineNoMatchMessage", new Object[]{name.fullName}));
        }
    }

    static void getFiles(String imageName, String directory) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (directory != null && ((String)directory).length() > 0) {
            if (!((String)directory).endsWith(File.separator)) {
                directory = (String)directory + File.separator;
            }
        } else {
            directory = "." + File.separator;
        }
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        for (int i = 0; i < formattedDisks.length; ++i) {
            FormattedDisk formattedDisk = formattedDisks[i];
            ac.writeFiles((List)formattedDisk.getFiles(), (String)directory);
        }
    }

    static void writeFiles(List<FileEntry> files, String directory) throws IOException, DiskException {
        for (FileEntry entry : files) {
            if (entry != null && !entry.isDeleted() && !entry.isDirectory()) {
                FileFilter ff = entry.getSuggestedFilter();
                if (ff instanceof BinaryFileFilter) {
                    ff = new HexDumpFileFilter();
                }
                byte[] buf = ff.filter(entry);
                String filename = ff.getSuggestedFileName(entry);
                File file = new File(directory + filename);
                File dir = new File(directory);
                dir.mkdirs();
                FileOutputStream output = new FileOutputStream(file);
                ((OutputStream)output).write(buf, 0, buf.length);
                ((OutputStream)output).close();
                continue;
            }
            if (!entry.isDirectory()) continue;
            ac.writeFiles((List)((DirectoryEntry)entry).getFiles(), (String)(directory + entry.getFilename() + File.separator));
        }
    }

    @Deprecated
    static FileEntry getEntry(List<FileEntry> files, String fileName) throws DiskException {
        if (files != null) {
            for (FileEntry entry : files) {
                String entryName = entry.getFilename();
                if (!entry.isDeleted() && fileName.equalsIgnoreCase(entryName)) {
                    return entry;
                }
                if (!entry.isDirectory() || (entry = ac.getEntry((List)((DirectoryEntry)entry).getFiles(), (String)fileName)) == null) continue;
                return entry;
            }
        }
        return null;
    }

    static void showDirectory(DirectoryLister dl, String[] args) throws IOException {
        for (String filename : Arrays.copyOfRange(args, 1, args.length)) {
            try {
                dl.list(filename);
            }
            catch (DiskException e) {
                throw new IOException(e);
            }
            catch (RuntimeException e) {
                System.out.println(filename + ": " + e.getMessage());
                System.out.println();
            }
        }
    }

    static void getDiskInfo(String[] args) throws IOException, DiskException {
        for (int d = 1; d < args.length; ++d) {
            Disk disk = new Disk(args[d]);
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                for (FormattedDisk.DiskInformation diskinfo : formattedDisk.getDiskInformation()) {
                    System.out.println(diskinfo.getLabel() + ": " + diskinfo.getValue());
                }
            }
            System.out.println();
        }
    }

    public static void setFileLocked(String imageName, String name, boolean lockState) throws IOException, DiskException {
        ac.setFileLocked((String)imageName, (Name)new Name(name), (boolean)lockState);
    }

    static void setFileLocked(String imageName, Name name, boolean lockState) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDisks = disk.getFormattedDisks();
            for (int i = 0; i < formattedDisks.length; ++i) {
                FormattedDisk formattedDisk = formattedDisks[i];
                FileEntry entry = name.getEntry(formattedDisk);
                if (entry != null) {
                    entry.setLocked(lockState);
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", new Object[]{name.fullName}));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    public static void setDiskName(String imageName, String volName) throws IOException, DiskException {
        Disk disk = new Disk(imageName);
        if (disk.isSDK() || disk.isDC42()) {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
        FormattedDisk[] formattedDisks = disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDisks[0];
        formattedDisk.setDiskName(volName);
        formattedDisks[0].save();
    }

    public static void createDosDisk(String fileName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        DosOrder imageOrder = new DosOrder(layout);
        DosFormatDisk[] disks = DosFormatDisk.create((String)fileName, (ImageOrder)imageOrder);
        disks[0].save();
    }

    public static void createPasDisk(String fileName, String volName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        PascalFormatDisk[] disks = PascalFormatDisk.create((String)fileName, (String)volName, (ImageOrder)imageOrder);
        disks[0].save();
    }

    public static void createProDisk(String fileName, String volName, int imageSize) throws IOException {
        ByteArrayImageLayout layout = new ByteArrayImageLayout(imageSize);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        ProdosFormatDisk[] disks = ProdosFormatDisk.create((String)fileName, (String)volName, (ImageOrder)imageOrder);
        disks[0].save();
    }

    static void convert(String shrinkName, String imageName) throws IOException {
        ac.convert((String)shrinkName, (String)imageName, (int)0);
    }

    static void convert(String shrinkName, String imageName, int imageSize) throws IOException {
        Disk disk = new Disk(shrinkName, imageSize);
        disk.setFilename(imageName);
        disk.save();
    }

    static int stringToInt(String s) {
        int i = 0;
        try {
            s = s.trim().toLowerCase();
            i = s.startsWith("$") ? Integer.parseInt(s.substring(1), 16) : (s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            i = 8192;
        }
        return i;
    }

    static void help() {
        System.err.println(textBundle.format("CommandLineHelp", new Object[]{AppleCommander.VERSION}));
    }
}

