/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx;

import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.DisassemblyFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.GutenbergFileFilter;
import com.webcodepro.applecommander.storage.filters.HexDumpFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import io.github.applecommander.filters.AppleSingleFileFilter;
import io.github.applecommander.filters.RawFileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public enum ExportMethod {
    APPLESINGLE(AppleSingleFileFilter::new, new String[]{"as", "applesingle"}),
    APPLESOFT(ApplesoftFileFilter::new, new String[]{"bas", "applesoft"}),
    APPLEWORKS_DATABASE(AppleWorksDataBaseFileFilter::new, new String[]{"adb"}),
    APPLEWORKS_SPREADSHEET(AppleWorksSpreadSheetFileFilter::new, new String[]{"asp"}),
    APPLEWORKS_WORDPROCESSOR(AppleWorksWordProcessorFileFilter::new, new String[]{"awp"}),
    ASSEMBLY_SOURCE(AssemblySourceFileFilter::new, new String[]{"asm", "assembly"}),
    BINARY(BinaryFileFilter::new, new String[]{"bin", "binary"}),
    BUSINESS_BASIC(BusinessBASICFileFilter::new, new String[]{"bbas", "business-basic"}),
    DISASSEMBLY(DisassemblyFileFilter::new, new String[]{"disasm", "disassembly"}),
    GRAPHICS(GraphicsFileFilter::new, new String[]{"gr", "graphics"}),
    GUTENBERG_FILE(GutenbergFileFilter::new, new String[]{"gutenberg"}),
    HEX_DUMP(HexDumpFileFilter::new, new String[]{"hex"}),
    INTEGER_BASIC(IntegerBasicFileFilter::new, new String[]{"int", "integer"}),
    PASCAL_TEXT(PascalTextFileFilter::new, new String[]{"ptext", "pascal-text"}),
    RAW(RawFileFilter::new, new String[]{"raw"}),
    TEXT(TextFileFilter::new, new String[]{"text"});

    private Supplier<FileFilter> constructor;
    private List<String> codes;

    private ExportMethod(Supplier<FileFilter> constructor, String ... codes) {
        this.constructor = constructor;
        this.codes = Arrays.asList(codes);
    }

    public FileFilter create() {
        return (FileFilter)this.constructor.get();
    }

    public List<String> getCodes() {
        return this.codes;
    }
}

