/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx;

import io.github.applecommander.acx.PrintExceptionMessageHandler;
import io.github.applecommander.acx.VersionProvider;
import io.github.applecommander.acx.command.CompareCommand;
import io.github.applecommander.acx.command.ConvertCommand;
import io.github.applecommander.acx.command.CopyFileCommand;
import io.github.applecommander.acx.command.CreateDiskCommand;
import io.github.applecommander.acx.command.DeleteCommand;
import io.github.applecommander.acx.command.DiskMapCommand;
import io.github.applecommander.acx.command.DumpCommand;
import io.github.applecommander.acx.command.ExportCommand;
import io.github.applecommander.acx.command.FindDuplicateFilesCommand;
import io.github.applecommander.acx.command.ImportCommand;
import io.github.applecommander.acx.command.InfoCommand;
import io.github.applecommander.acx.command.ListCommand;
import io.github.applecommander.acx.command.LockCommand;
import io.github.applecommander.acx.command.MkdirCommand;
import io.github.applecommander.acx.command.ReadCommand;
import io.github.applecommander.acx.command.RenameDiskCommand;
import io.github.applecommander.acx.command.RenameFileCommand;
import io.github.applecommander.acx.command.RmdirCommand;
import io.github.applecommander.acx.command.UnlockCommand;
import io.github.applecommander.acx.command.WriteCommand;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import picocli.CommandLine;

/*
 * Exception performing whole class analysis ignored.
 */
@CommandLine.Command(name="acx", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, descriptionHeading="%n", commandListHeading="%nCommands:%n", optionListHeading="%nOptions:%n", description={"'acx' experimental utility"}, subcommands={CompareCommand.class, ConvertCommand.class, CopyFileCommand.class, CreateDiskCommand.class, DeleteCommand.class, DiskMapCommand.class, DumpCommand.class, ExportCommand.class, FindDuplicateFilesCommand.class, CommandLine.HelpCommand.class, ImportCommand.class, InfoCommand.class, ListCommand.class, LockCommand.class, MkdirCommand.class, ReadCommand.class, RenameFileCommand.class, RenameDiskCommand.class, RmdirCommand.class, UnlockCommand.class, WriteCommand.class})
public class Main {
    private static Logger LOG = Logger.getLogger(Main.class.getName());
    private static final Level[] LOG_LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};
    @CommandLine.Option(names={"--debug"}, description={"Show detailed stack traces."})
    static boolean enableStackTrace;

    private static void setAllLogLevels(Level level) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(level);
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
        }
    }

    @CommandLine.Option(names={"-v", "--verbose"}, description={"Be verbose. Multiple occurrences increase logging."})
    public void setVerbosity(boolean[] flag) {
        int loglevel = Math.min(flag.length + 2, LOG_LEVELS.length);
        Level level = LOG_LEVELS[loglevel - 1];
        Main.setAllLogLevels((Level)level);
    }

    @CommandLine.Option(names={"--quiet"}, description={"Turn off all logging."})
    public void setQuiet(boolean flag) {
        Main.setAllLogLevels((Level)Level.OFF);
    }

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine((Object)new Main());
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PrintExceptionMessageHandler());
        cmd.setCaseInsensitiveEnumValuesAllowed(true);
        if (args.length == 0) {
            cmd.usage(System.out);
            System.exit(1);
        }
        LOG.info(() -> String.format("Log level set to %s.", Logger.getGlobal().getLevel()));
        int exitCode = cmd.execute(args);
        LOG.fine("Exiting with code " + exitCode);
        System.exit(exitCode);
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%4$s: %5$s%n");
        Main.setAllLogLevels((Level)Level.WARNING);
    }
}

