/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx;

import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import java.util.function.Function;
import java.util.logging.Logger;

public enum OrderType {
    DOS(OrderType::createDosImageOrder),
    NIBBLE(OrderType::create140kNibbleImageOrder),
    PRODOS(OrderType::createProdosImageOrder);

    private static Logger LOG;
    private Function<Integer, ImageOrder> createImageOrderFn;

    private OrderType(Function<Integer, ImageOrder> createImageOrderFn) {
        this.createImageOrderFn = createImageOrderFn;
    }

    public ImageOrder createImageOrder(int size) {
        return (ImageOrder)this.createImageOrderFn.apply(size);
    }

    static ImageOrder createDosImageOrder(int size) {
        if (size < 143360) {
            LOG.warning("Setting image size to 140KB.");
            size = 143360;
        } else if (size != 143360 && size != 819200) {
            LOG.warning("Setting image size to 800KB.");
            size = 819200;
        }
        ByteArrayImageLayout layout = new ByteArrayImageLayout(new byte[size]);
        return new DosOrder(layout);
    }

    static ImageOrder create140kNibbleImageOrder(int size) {
        if (size != 232960 && size != 143360) {
            LOG.warning("Setting image size to 140KB");
        }
        ByteArrayImageLayout layout = new ByteArrayImageLayout(new byte[232960]);
        return new NibbleOrder(layout);
    }

    static ImageOrder createProdosImageOrder(int size) {
        if (size < 143360) {
            LOG.warning("Setting image size to 140KB.");
            size = 143360;
        } else if (size != 143360) {
            if (size < 819200) {
                LOG.warning("Setting image size to 800KB.");
                size = 819200;
            } else if (size > 33553920) {
                LOG.warning("Setting image size to 32MB.");
                size = 33553920;
            }
        }
        ByteArrayImageLayout layout = new ByteArrayImageLayout(size);
        return new ProdosOrder(layout);
    }

    static {
        LOG = Logger.getLogger(OrderType.class.getName());
    }
}

