/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import io.github.applecommander.acx.OrderType;
import io.github.applecommander.acx.fileutil.FileUtils;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public enum SystemType {
    DOS(OrderType.DOS, SystemType::enforce140KbDisk, SystemType::copyDosSystemTracks),
    OZDOS(OrderType.PRODOS, SystemType::enforce800KbDisk, SystemType::copyDosSystemTracks),
    UNIDOS(OrderType.DOS, SystemType::enforce800KbDisk, SystemType::copyDosSystemTracks),
    PRODOS(OrderType.PRODOS, SystemType::enforce140KbOr800KbUpTo32MbDisk, SystemType::copyProdosSystemFiles),
    PASCAL(OrderType.PRODOS, SystemType::enforce140KbDisk, SystemType::copyPascalSystemFiles);

    static Logger LOG;
    private OrderType defaultOrderType;
    private Function<Integer, Integer> enforceDiskSizeFn;
    private BiConsumer<FormattedDisk, FormattedDisk> copySystemFn;

    private SystemType(OrderType defaultOrderType, Function<Integer, Integer> enforceDiskSizeFn, BiConsumer<FormattedDisk, FormattedDisk> copySystemFn) {
        this.defaultOrderType = defaultOrderType;
        this.enforceDiskSizeFn = enforceDiskSizeFn;
        this.copySystemFn = copySystemFn;
    }

    public OrderType defaultOrderType() {
        return this.defaultOrderType;
    }

    public int validateSize(int size) {
        return (Integer)this.enforceDiskSizeFn.apply(size);
    }

    public void copySystem(FormattedDisk target, FormattedDisk source) {
        this.copySystemFn.accept(target, source);
    }

    static int enforce140KbDisk(int size) {
        if (size != 143360) {
            LOG.warning("Setting image size to 140KB");
        }
        return 143360;
    }

    static int enforce800KbDisk(int size) {
        if (size != 819200) {
            LOG.warning("Setting image size to 800KB.");
        }
        return 819200;
    }

    static int enforce140KbOr800KbUpTo32MbDisk(int size) {
        if (size <= 143360) {
            return SystemType.enforce140KbDisk((int)size);
        }
        if (size <= 819200) {
            return SystemType.enforce800KbDisk((int)size);
        }
        if (size > 33553920) {
            LOG.warning("Setting image size to 32MB.");
            return 33553920;
        }
        return size;
    }

    static void copyDosSystemTracks(FormattedDisk targetDisk, FormattedDisk source) {
        DosFormatDisk target = (DosFormatDisk)targetDisk;
        byte[] vtoc = target.readVtoc();
        int sectorsPerTrack = vtoc[53];
        for (int t = 0; t < 3; ++t) {
            for (int s = 0; s < sectorsPerTrack; ++s) {
                target.writeSector(t, s, source.readSector(t, s));
                target.setSectorUsed(t, s, vtoc);
            }
        }
        target.writeVtoc(vtoc);
    }

    static void copyProdosSystemFiles(FormattedDisk target, FormattedDisk source) {
        target.writeBlock(0, source.readBlock(0));
        target.writeBlock(1, source.readBlock(1));
        try {
            FileUtils copier = new FileUtils(false);
            for (String filename : Arrays.asList("PRODOS", "BASIC.SYSTEM")) {
                FileEntry sourceFile = source.getFile(filename);
                copier.copy((DirectoryEntry)target, sourceFile);
            }
        }
        catch (DiskException e) {
            throw new RuntimeException(e);
        }
    }

    static void copyPascalSystemFiles(FormattedDisk target, FormattedDisk source) {
        target.writeBlock(0, source.readBlock(0));
        target.writeBlock(1, source.readBlock(1));
    }

    static {
        LOG = Logger.getLogger(SystemType.class.getName());
    }
}

