/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.arggroup;

import com.webcodepro.applecommander.storage.Disk;
import io.github.applecommander.acx.arggroup.CoordinateSelection;
import picocli.CommandLine;

public class CoordinateSelection {
    @CommandLine.ArgGroup(exclusive=false)
    private SectorCoordinateSelection sectorCoordinate;
    @CommandLine.ArgGroup(exclusive=false)
    private BlockCoordinateSelection blockCoordinate;

    public boolean includesBootSector() {
        if (this.sectorCoordinate != null) {
            return this.sectorCoordinate.isBootSector();
        }
        if (this.blockCoordinate != null) {
            return this.blockCoordinate.isBootBlock();
        }
        return false;
    }

    public byte[] read(Disk disk) {
        if (this.sectorCoordinate != null) {
            return this.sectorCoordinate.read(disk);
        }
        if (this.blockCoordinate != null) {
            return this.blockCoordinate.read(disk);
        }
        return disk.readSector(0, 0);
    }

    public void write(Disk disk, byte[] data) {
        if (this.sectorCoordinate != null) {
            this.sectorCoordinate.write(disk, data);
        } else if (this.blockCoordinate != null) {
            this.blockCoordinate.write(disk, data);
        }
        disk.writeSector(0, 0, data);
    }
}

