/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.base;

import com.webcodepro.applecommander.storage.Disk;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(descriptionHeading="%n", optionListHeading="%nOptions:%n", parameterListHeading="%nParameters:%n")
public abstract class ReusableCommandOptions
implements Callable<Integer> {
    private static Logger LOG = Logger.getLogger(ReusableCommandOptions.class.getName());
    @CommandLine.Option(names={"-h", "--help"}, description={"Show help for subcommand."}, usageHelp=true)
    private boolean helpFlag;

    @Override
    public Integer call() throws Exception {
        return this.handleCommand();
    }

    public abstract int handleCommand() throws Exception;

    public void saveDisk(Disk disk) {
        try {
            if (disk.getDiskImageManager().hasChanged()) {
                LOG.fine(() -> String.format("Saving disk '%s'", disk.getFilename()));
                disk.save();
            } else {
                LOG.fine(() -> String.format("Disk '%s' has not changed; not saving.", disk.getFilename()));
            }
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }
}

