/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.compare.ComparisonResult;
import com.webcodepro.applecommander.storage.compare.DiskDiff;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import io.github.applecommander.acx.command.CompareCommand;
import io.github.applecommander.acx.converter.DiskConverter;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="compare", description={"Compare two disk images."})
public class CompareCommand
extends ReadOnlyDiskImageCommandOptions {
    @CommandLine.Parameters(arity="1", converter={DiskConverter.class}, description={"Second image to compare to."})
    private Disk disk2;
    @CommandLine.ArgGroup(heading="%nComparison Strategy Selection:%n")
    private StrategySelection strategySelection = new StrategySelection();
    @CommandLine.Option(names={"-l", "--limit"}, description={"Set limit to messages displayed."})
    private Optional<Integer> limit = Optional.empty();

    public int handleCommand() throws Exception {
        DiskDiff.Builder builder = DiskDiff.create((Disk)this.disk, (Disk)this.disk2);
        this.strategySelection.strategy.accept(builder);
        ComparisonResult result = builder.compare();
        if (result.getDifferenceCount() != 0) {
            System.out.println("The disks do not match.");
            this.limit.map(arg_0 -> ((ComparisonResult)result).getLimitedMessages(arg_0)).orElseGet(() -> ((ComparisonResult)result).getAllMessages()).forEach(System.out::println);
            if (result.getDifferenceCount() > this.limit.orElse(Integer.MAX_VALUE)) {
                System.out.printf("There are %d more messages.\n", result.getDifferenceCount() - (Integer)this.limit.get());
            }
            return 1;
        }
        System.out.println("The disks match.");
        return 0;
    }
}

