/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import io.github.applecommander.acx.base.ReusableCommandOptions;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="convert", description={"Uncompress a ShrinkIt or Binary II file; or convert a DiskCopy 4.2 image into a ProDOS disk image."})
public class ConvertCommand
extends ReusableCommandOptions {
    @CommandLine.Option(names={"-d", "--disk"}, description={"Image to create [$ACX_DISK_NAME]."}, required=true, defaultValue="${ACX_DISK_NAME}")
    private String diskName;
    @CommandLine.Option(names={"-f", "--force"}, description={"Allow existing disk image to be replaced."})
    private boolean overwriteFlag;
    @CommandLine.Parameters(description={"Archive to convert."}, arity="1")
    private String archiveName;

    public int handleCommand() throws Exception {
        File targetFile = new File(this.diskName);
        if (targetFile.exists() && !this.overwriteFlag) {
            throw new RuntimeException("File exists and overwriting not enabled.");
        }
        Disk disk = new Disk(this.archiveName);
        disk.setFilename(this.diskName);
        this.saveDisk(disk);
        return 0;
    }
}

