/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.util.Name;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import io.github.applecommander.acx.converter.DiskConverter;
import io.github.applecommander.acx.fileutil.FileUtils;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="copy", description={"Copy files between disks."}, aliases={"cp"})
public class CopyFileCommand
extends ReadWriteDiskCommandOptions {
    private static Logger LOG = Logger.getLogger(CopyFileCommand.class.getName());
    @CommandLine.Option(names={"-r", "--recursive"}, description={"Copy files recursively."})
    private boolean recursiveFlag;
    @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing files."})
    private boolean overwriteFlag;
    @CommandLine.Option(names={"--to", "--directory"}, description={"Specify which directory to place files."})
    private String targetPath;
    @CommandLine.Option(names={"-s", "--from", "--source"}, description={"Source disk for files."}, converter={DiskConverter.class}, required=true)
    private Disk sourceDisk;
    @CommandLine.Parameters(arity="*", description={"File glob(s) to copy (default = '*')"}, defaultValue="*")
    private List<String> globs;

    public int handleCommand() throws Exception {
        List files = FileStreamer.forDisk((Disk)this.sourceDisk).ignoreErrors(true).includeTypeOfFile(TypeOfFile.BOTH).recursive(false).matchGlobs(this.globs).stream().collect(Collectors.toList());
        if (files.isEmpty()) {
            LOG.warning(() -> String.format("No matches found for %s.", String.join((CharSequence)",", this.globs)));
        } else {
            FormattedDisk targetDirectory = this.disk.getFormattedDisks()[0];
            if (this.targetPath != null) {
                Name name = new Name(this.targetPath);
                FileEntry found = name.getEntry((DirectoryEntry)targetDirectory);
                if (found == null || !found.isDirectory()) {
                    throw new RuntimeException("unable to find directory: " + this.targetPath);
                }
                targetDirectory = (DirectoryEntry)found;
            }
            for (FileTuple tuple : files) {
                this.fileHandler((DirectoryEntry)targetDirectory, tuple);
            }
        }
        return 0;
    }

    private void fileHandler(DirectoryEntry directoryEntry, FileTuple tuple) {
        try {
            if (!this.recursiveFlag && tuple.fileEntry.isDirectory()) {
                directoryEntry.createDirectory(tuple.fileEntry.getFilename());
            } else {
                FileUtils copier = new FileUtils(this.overwriteFlag);
                copier.copy(directoryEntry, tuple.fileEntry);
            }
        }
        catch (DiskException ex) {
            LOG.severe(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }
}

