/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.OzDosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.UniDosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import io.github.applecommander.acx.OrderType;
import io.github.applecommander.acx.SystemType;
import io.github.applecommander.acx.base.ReusableCommandOptions;
import io.github.applecommander.acx.command.CreateDiskCommand;
import io.github.applecommander.acx.converter.DataSizeConverter;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a disk image."}, aliases={"mkdisk"})
public class CreateDiskCommand
extends ReusableCommandOptions {
    private static Logger LOG = Logger.getLogger(CreateDiskCommand.class.getName());
    @CommandLine.Option(names={"-d", "--disk"}, description={"Image to create [$ACX_DISK_NAME]."}, required=true, defaultValue="${ACX_DISK_NAME}")
    private String imageName;
    @CommandLine.ArgGroup(multiplicity="1", heading="%nOperating System Selection:%n")
    private SystemSelection systemSelection;
    @CommandLine.ArgGroup(heading="%nDisk Sector Ordering Selection:%n")
    private OrderSelection orderSelection = new OrderSelection();
    @CommandLine.Option(names={"-s", "--size"}, defaultValue="140kb", converter={DataSizeConverter.class}, description={"Select disk size (examples: 140K, 800K, 10M)."})
    private int size;
    @CommandLine.Option(names={"-f", "--format"}, description={"Disk to copy system files/tracks/boot sector from."})
    private String formatSource;
    @CommandLine.Option(names={"-n", "--name"}, defaultValue="NEW.DISK", description={"Disk Volume name (ProDOS/Pascal)."})
    private String diskName;

    public int handleCommand() throws Exception {
        SystemType systemType = this.systemSelection.get();
        OrderType actualOrderType = this.orderSelection.get().orElse(systemType.defaultOrderType());
        int correctedSize = systemType.validateSize(this.size);
        LOG.info(() -> String.format("Creating %s image of type %s (%s).", DataSizeConverter.format((int)correctedSize), systemType, actualOrderType));
        ImageOrder order = actualOrderType.createImageOrder(correctedSize);
        DosFormatDisk[] disks = null;
        switch (1.$SwitchMap$io$github$applecommander$acx$SystemType[systemType.ordinal()]) {
            case 1: {
                disks = DosFormatDisk.create((String)this.imageName, (ImageOrder)order);
                break;
            }
            case 2: {
                disks = OzDosFormatDisk.create((String)this.imageName, (ImageOrder)order);
                break;
            }
            case 3: {
                disks = UniDosFormatDisk.create((String)this.imageName, (ImageOrder)order);
                break;
            }
            case 4: {
                disks = ProdosFormatDisk.create((String)this.imageName, (String)this.diskName, (ImageOrder)order);
                break;
            }
            case 5: {
                disks = PascalFormatDisk.create((String)this.imageName, (String)this.diskName, (ImageOrder)order);
            }
        }
        if (this.formatSource != null) {
            Disk systemSource = new Disk(this.formatSource);
            systemType.copySystem((FormattedDisk)disks[0], systemSource.getFormattedDisks()[0]);
        }
        this.saveDisk((Disk)disks[0]);
        return 0;
    }
}

