/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import io.github.applecommander.acx.base.ReadWriteDiskCommandWithGlobOptions;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete file(s) from a disk image."}, aliases={"del", "rm"})
public class DeleteCommand
extends ReadWriteDiskCommandWithGlobOptions {
    private static Logger LOG = Logger.getLogger(DeleteCommand.class.getName());
    @CommandLine.Parameters(arity="1..*", description={"File glob(s) to delete (default = '*') - be cautious of quoting!"})
    private List<String> globs = Arrays.asList("*");
    @CommandLine.Option(names={"-f", "--force"}, description={"Force delete locked files."})
    private boolean forceFlag;

    protected List<String> getGlobs() {
        return this.globs;
    }

    public void fileHandler(FileTuple tuple) {
        if (tuple.fileEntry.isLocked()) {
            if (this.forceFlag) {
                LOG.info(() -> String.format("File '%s' is locked, but 'force' specified; ignoring lock.", tuple.fileEntry.getFilename()));
            } else {
                LOG.warning(() -> String.format("File '%s' is locked.", tuple.fileEntry.getFilename()));
                return;
            }
        }
        tuple.fileEntry.delete();
        LOG.info(() -> String.format("File '%s' deleted.", tuple.fileEntry.getFilename()));
    }
}

