/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.FormattedDisk;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import java.util.Arrays;
import java.util.function.Function;
import picocli.CommandLine;

@CommandLine.Command(name="diskmap", description={"Show disk usage map."}, aliases={"map"})
public class DiskMapCommand
extends ReadOnlyDiskImageCommandOptions {
    public int handleCommand() throws Exception {
        Arrays.asList(this.disk.getFormattedDisks()).forEach(arg_0 -> this.showDiskMap(arg_0));
        return 0;
    }

    public void showDiskMap(FormattedDisk formattedDisk) {
        Function<Integer, Integer> leftNumFn;
        Function<Integer, Integer> rightNumFn;
        int width;
        int height;
        int[] dimensions = formattedDisk.getBitmapDimensions();
        int length = formattedDisk.getBitmapLength();
        if (dimensions != null && dimensions.length == 2) {
            height = dimensions[0];
            width = dimensions[1];
            rightNumFn = i -> i;
            leftNumFn = rightNumFn;
        } else {
            width = 70;
            height = (length + width - 1) / width;
            leftNumFn = i -> i * width;
            rightNumFn = i -> (i + 1) * width - 1;
        }
        this.title(formattedDisk.getBitmapLabels());
        this.header1(width);
        this.header2(width);
        this.header3(width);
        FormattedDisk.DiskUsage diskUsage = formattedDisk.getDiskUsage();
        for (int y = 0; y < height; ++y) {
            System.out.printf("%5d|", leftNumFn.apply(y));
            for (int x = 0; x < width; ++x) {
                if (diskUsage.hasNext()) {
                    diskUsage.next();
                    System.out.print(diskUsage.isUsed() ? (char)'*' : '.');
                    continue;
                }
                System.out.print(" ");
            }
            System.out.printf("|%d", rightNumFn.apply(y));
            System.out.println();
        }
        this.header3(width);
        this.header2(width);
        this.header1(width);
    }

    void title(String[] labels) {
        System.out.print("      ");
        if (labels.length == 2) {
            System.out.printf("X=%s, Y=%s", labels[1], labels[0]);
        } else {
            System.out.printf("By %s", String.join((CharSequence)", ", labels));
        }
        System.out.println();
    }

    void header1(int width) {
        System.out.print("      ");
        for (int i = 0; i < width; ++i) {
            System.out.print(i % 10 == 0 ? Character.forDigit(i % 10, 10) : (char)' ');
        }
        System.out.println();
    }

    void header2(int width) {
        System.out.print("      ");
        for (int i = 0; i < width; ++i) {
            System.out.print(i % 10);
        }
        System.out.println();
    }

    void header3(int width) {
        System.out.print("      ");
        for (int i = 0; i < width; ++i) {
            System.out.print(i % 5 == 0 ? (char)'+' : '-');
        }
        System.out.println();
    }
}

