/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import io.github.applecommander.acx.command.ExportCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export file(s) from a disk image."}, aliases={"x", "get"})
public class ExportCommand
extends ReadOnlyDiskImageCommandOptions {
    private static Logger LOG = Logger.getLogger(ExportCommand.class.getName());
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.ArgGroup(exclusive=true, heading="%nFile extract methods:%n")
    private FileExtractMethods extraction = new FileExtractMethods();
    @CommandLine.Option(names={"--deleted"}, description={"Include deleted files (use at your own risk!)"})
    private boolean deletedFlag;
    @CommandLine.Option(names={"-o", "--output"}, description={"Extract to file or to directory (default is stdout)."})
    private File outputFile;
    @CommandLine.Parameters(arity="*", description={"File glob(s) to extract (default = '*') - be cautious of quoting!"})
    private List<String> globs = Arrays.asList("*");

    public void validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.isMultipleFiles()) {
            if (this.outputFile == null) {
                errors.add("--output directory must be specified with multiple files");
            } else if (!this.outputFile.isDirectory()) {
                errors.add("--output must be a directory");
            }
        }
        if (!errors.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.join((CharSequence)", ", errors));
        }
    }

    public int handleCommand() throws Exception {
        this.validate();
        Consumer<FileTuple> fileHandler = this.outputFile == null ? arg_0 -> this.writeToStdout(arg_0) : arg_0 -> this.writeToOutput(arg_0);
        FileStreamer.forDisk((Disk)this.disk).ignoreErrors(true).includeDeleted(this.deletedFlag).includeTypeOfFile(TypeOfFile.FILE).matchGlobs(this.globs).stream().forEach(fileHandler);
        return 0;
    }

    public boolean hasFiles() {
        return this.globs != null && this.globs.size() > 1;
    }

    public boolean isAllFiles() {
        return this.globs == null || this.globs.isEmpty();
    }

    public boolean isMultipleFiles() {
        return this.hasFiles() || this.isAllFiles();
    }

    public void writeToStdout(FileTuple tuple) {
        try {
            FileFilter ff = (FileFilter)this.extraction.extractFunction.apply(tuple.fileEntry);
            System.out.write(ff.filter(tuple.fileEntry));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeToOutput(FileTuple tuple) {
        File file = this.outputFile;
        FileFilter ff = (FileFilter)this.extraction.extractFunction.apply(tuple.fileEntry);
        if (file.isDirectory()) {
            boolean created;
            if (!tuple.paths.isEmpty() && (created = (file = new File(this.outputFile, String.join((CharSequence)File.pathSeparator, tuple.paths))).mkdirs())) {
                LOG.info(String.format("Directory created: %s", file.getPath()));
            }
            file = new File(file, ff.getSuggestedFileName(tuple.fileEntry));
        }
        LOG.info(String.format("Writing to '%s'", file.getPath()));
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(ff.filter(tuple.fileEntry));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

