/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="dups", description={"Find duplicate files."})
public class FindDuplicateFilesCommand
extends ReadOnlyDiskImageCommandOptions {
    @CommandLine.Option(names={"-a", "--all"}, description={"Compare all files across all volumes; useful for formats like UniDOS."})
    private boolean compareAcrossVolumes;

    public int handleCommand() throws Exception {
        HashMap content = new HashMap();
        Supplier<Map> supplier = () -> content;
        int dupsFound = 0;
        for (FormattedDisk formattedDisk : this.disk.getFormattedDisks()) {
            FileStreamer.forDisk((Disk)formattedDisk).includeTypeOfFile(TypeOfFile.FILE).recursive(true).stream().collect(Collectors.groupingBy(arg_0 -> this.contentHash(arg_0), supplier, Collectors.toList()));
            if (!this.compareAcrossVolumes || content.isEmpty()) continue;
            System.out.printf("Differences in: %s\n", formattedDisk.getDiskName());
            dupsFound += this.report(content);
            content.clear();
        }
        if (!content.isEmpty()) {
            System.out.println("Differences:");
            dupsFound += this.report(content);
        }
        if (dupsFound == 0) {
            System.out.println("There are no duplicate files.");
        }
        return 0;
    }

    private String contentHash(FileTuple tuple) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] digest = messageDigest.digest(tuple.fileEntry.getFileData());
            return String.format("%032X", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private int report(Map<String, List<FileTuple>> content) {
        int dups = 0;
        for (Map.Entry<String, List<FileTuple>> entry : content.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            ++dups;
            boolean first = true;
            for (FileTuple tuple : entry.getValue()) {
                if (first) {
                    System.out.printf("%s has the following duplicates:\n", tuple.fullPath());
                    first = false;
                    continue;
                }
                System.out.printf("    - %s\n", tuple.fullPath());
            }
        }
        return dups;
    }
}

