/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.OverrideFileEntryReader;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import io.github.applecommander.acx.command.ImportCommand;
import io.github.applecommander.acx.fileutil.FileUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import file onto disk."}, aliases={"put"})
public class ImportCommand
extends ReadWriteDiskCommandOptions {
    private static Logger LOG = Logger.getLogger(ImportCommand.class.getName());
    @CommandLine.ArgGroup(heading="%nInput source:%n", multiplicity="1")
    private InputData inputData;
    @CommandLine.ArgGroup(heading="%nProcessing options:%n")
    private Processor processor = new Processor();
    @CommandLine.ArgGroup(heading="%nGeneral overrides:%n", exclusive=false)
    private Overrides overrides = new Overrides();
    @CommandLine.Option(names={"--dir"}, description={"Write file(s) to directory."})
    private Optional<String> directoryName;
    @CommandLine.Option(names={"-f", "--force"}, description={"Over-write existing files."})
    private boolean overwriteFlag;

    public int handleCommand() throws Exception {
        int auxType;
        int fileAddress;
        int MAX_ADDRESS = 65535;
        int MAX_AUXTYPE = 65535;
        if (this.overrides.fileAddress.isPresent() && ((fileAddress = ((Integer)this.overrides.fileAddress.get()).intValue()) < 0 || fileAddress > 65535)) {
            String errormsg = String.format("address(%d) is out of range(0-%d).", fileAddress, 65535);
            throw new IllegalArgumentException(errormsg);
        }
        if (this.overrides.auxType.isPresent() && ((auxType = ((Integer)this.overrides.auxType.get()).intValue()) < 0 || auxType > 65535)) {
            String errormsg = String.format("auxiliary type(%d) is out of range(0-%d).", auxType, 65535);
            throw new IllegalArgumentException(errormsg);
        }
        FormattedDisk directory = this.disk.getFormattedDisks()[0];
        if (this.directoryName.isPresent()) {
            String[] dirs;
            for (String dir : dirs = ((String)this.directoryName.get()).split("/")) {
                Optional<FileEntry> fileEntry = directory.getFiles().stream().filter(f -> dir.equalsIgnoreCase(f.getFilename())).filter(f -> !f.isDeleted()).findFirst();
                Optional<DirectoryEntry> dirEntry = fileEntry.filter(FileEntry::isDirectory).map(DirectoryEntry.class::cast);
                directory = dirEntry.orElseThrow(() -> new IOException(String.format("Directory '%s' not found.", dir)));
            }
        }
        FileUtils copier = new FileUtils(this.overwriteFlag);
        FileEntryReader inputReader = this.inputData.get();
        for (FileEntryReader processorReader : this.processor.apply(inputReader)) {
            FileEntryReader reader = OverrideFileEntryReader.builder().filename(this.overrides.fileName).prodosFiletype(this.overrides.fileType).binaryAddress(this.overrides.fileAddress).auxiliaryType(this.overrides.auxType).build(processorReader);
            copier.copyFile((DirectoryEntry)directory, reader);
        }
        return 0;
    }
}

