/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.FormattedDisk;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show information on a disk image(s)."}, aliases={"i"})
public class InfoCommand
extends ReadOnlyDiskImageCommandOptions {
    private static Logger LOG = Logger.getLogger(InfoCommand.class.getName());

    public int handleCommand() throws Exception {
        LOG.info(() -> "Path: " + this.disk.getFilename());
        FormattedDisk[] formattedDisks = this.disk.getFormattedDisks();
        for (int i = 0; i < formattedDisks.length; ++i) {
            FormattedDisk formattedDisk = formattedDisks[i];
            LOG.info(() -> String.format("Disk: %s (%s)", formattedDisk.getDiskName(), formattedDisk.getFormat()));
            for (FormattedDisk.DiskInformation diskinfo : formattedDisk.getDiskInformation()) {
                System.out.printf("%s: %s\n", diskinfo.getLabel(), diskinfo.getValue());
            }
            System.out.println();
        }
        return 0;
    }
}

