/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.ui.DirectoryLister;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import io.github.applecommander.acx.command.ListCommand;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List directory of disk image(s)."}, aliases={"ls"})
public class ListCommand
extends ReadOnlyDiskImageCommandOptions {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1", heading="%nFile display formatting:%n")
    private FileDisplay fileDisplay = new FileDisplay();
    @CommandLine.Option(names={"-r", "--recursive"}, description={"Display directory recursively."}, negatable=true, defaultValue="false")
    private boolean recursiveFlag;
    @CommandLine.Option(names={"--deleted"}, description={"Show deleted files."})
    private boolean deletedFlag;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    private TypeOfFileSelection typeOfFile = new TypeOfFileSelection();
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1", heading="%nOutput format:%n")
    private OutputType outputType = new OutputType();
    @CommandLine.Option(names={"--header"}, negatable=true, description={"Show header."})
    private boolean headerFlag = true;
    @CommandLine.Option(names={"--column"}, negatable=true, description={"Show column headers."})
    private boolean columnFlag = true;
    @CommandLine.Option(names={"--footer"}, negatable=true, description={"Show footer."})
    private boolean footerFlag = true;
    @CommandLine.Option(names={"--globs"}, defaultValue="*", split=",", description={"File glob(s) to match."})
    private List<String> globs = new ArrayList();

    public int handleCommand() throws Exception {
        int display = this.fileDisplay.format();
        DirectoryLister.ListingStrategy listingStrategy = this.outputType.create(display);
        listingStrategy.first(this.disk);
        FileStreamer.forDisk((Disk)this.disk).ignoreErrors(true).includeDeleted(this.deletedFlag).recursive(this.recursiveFlag).includeTypeOfFile(this.typeOfFile.typeOfFile()).matchGlobs(this.globs).beforeDisk(arg_0 -> ((DirectoryLister.ListingStrategy)listingStrategy).beforeDisk(arg_0)).afterDisk(arg_0 -> ((DirectoryLister.ListingStrategy)listingStrategy).afterDisk(arg_0)).stream().forEach(arg_0 -> ((DirectoryLister.ListingStrategy)listingStrategy).forEach(arg_0));
        listingStrategy.last(this.disk);
        return 0;
    }
}

