/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import io.github.applecommander.acx.base.ReadWriteDiskCommandWithGlobOptions;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="lock", description={"Lock file(s) on a disk image."})
public class LockCommand
extends ReadWriteDiskCommandWithGlobOptions {
    private static Logger LOG = Logger.getLogger(LockCommand.class.getName());
    @CommandLine.Parameters(arity="1..*", description={"File glob(s) to lock (default = '*') - be cautious of quoting!"})
    private List<String> globs = Arrays.asList("*");

    protected List<String> getGlobs() {
        return this.globs;
    }

    public void fileHandler(FileTuple tuple) {
        tuple.fileEntry.setLocked(true);
        LOG.info(() -> String.format("File '%s' locked.", tuple.fileEntry.getFilename()));
    }
}

