/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="mkdir", description={"Create a directory on disk."}, aliases={"md"})
public class MkdirCommand
extends ReadWriteDiskCommandOptions {
    @CommandLine.Option(names={"-p"}, description={"Create intermediate subdirectories."})
    private boolean prefixFlag;
    @CommandLine.Parameters(description={"Directory name to create (use '/' as divider)."})
    private String fullPath;

    public int handleCommand() throws Exception {
        FormattedDisk formattedDisk;
        FormattedDisk directory = formattedDisk = this.disk.getFormattedDisks()[0];
        String[] paths = this.fullPath.split("/");
        for (int i = 0; i < paths.length; ++i) {
            String pathName = formattedDisk.getSuggestedFilename(paths[i]);
            Optional<FileEntry> optEntry = directory.getFiles().stream().filter(entry -> entry.getFilename().equalsIgnoreCase(pathName)).filter(entry -> !entry.isDeleted()).findFirst();
            if (optEntry.isPresent()) {
                FileEntry fileEntry = optEntry.get();
                if (fileEntry instanceof DirectoryEntry) {
                    directory = (DirectoryEntry)fileEntry;
                    continue;
                }
                throw new RuntimeException(String.format("Not a directory: '%s'", pathName));
            }
            if (this.prefixFlag || i == paths.length - 1) {
                directory = directory.createDirectory(pathName);
                continue;
            }
            throw new RuntimeException(String.format("Directory does not exist: '%s'", pathName));
        }
        return 0;
    }
}

