/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import io.github.applecommander.acx.arggroup.CoordinateSelection;
import io.github.applecommander.acx.base.ReadOnlyDiskImageCommandOptions;
import io.github.applecommander.acx.command.ReadCommand;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import picocli.CommandLine;

@CommandLine.Command(name="read", description={"Read a block or sector."})
public class ReadCommand
extends ReadOnlyDiskImageCommandOptions {
    @CommandLine.ArgGroup(multiplicity="1", heading="%nCoordinate Selection:%n")
    private CoordinateSelection coordinate = new CoordinateSelection();
    @CommandLine.ArgGroup(heading="%nOutput Selection:%n")
    private OutputSelection output = new OutputSelection();
    private static OpenOption[] openOptions = new OpenOption[]{StandardOpenOption.CREATE_NEW};

    @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing file (combine with '-o')."})
    private void selectForceFile(boolean flag) {
        openOptions = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
    }

    public int handleCommand() throws Exception {
        byte[] data = this.coordinate.read(this.disk);
        this.output.write(data);
        return 0;
    }
}

