/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="rename-disk", description={"Rename volume of a disk image."})
public class RenameDiskCommand
extends ReadWriteDiskCommandOptions {
    private static Logger LOG = Logger.getLogger(RenameDiskCommand.class.getName());
    @CommandLine.Parameters(description={"Disk name."})
    private String diskName;

    public int handleCommand() throws Exception {
        FormattedDisk[] formattedDisks = this.disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDisks[0];
        if (formattedDisk instanceof ProdosFormatDisk || formattedDisk instanceof PascalFormatDisk) {
            formattedDisk.setDiskName(this.diskName);
            return 0;
        }
        LOG.warning("Disk must be ProDOS or Pascal.");
        return 1;
    }
}

