/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="rename", description={"Rename file on a disk image."}, aliases={"ren"})
public class RenameFileCommand
extends ReadWriteDiskCommandOptions {
    private static Logger LOG = Logger.getLogger(RenameFileCommand.class.getName());
    @CommandLine.Option(names={"-m", "--multiple"}, description={"Force rename when multiple files found."})
    private boolean multipleOverride;
    @CommandLine.Option(names={"-f", "--force"}, description={"Rename locked files."})
    private boolean lockOverride;
    @CommandLine.Parameters(index="0", description={"Original file name (include path)."})
    private String originalFilename;
    @CommandLine.Parameters(index="1", description={"New file name (just the new filename)."})
    private String newFilename;

    public int handleCommand() throws Exception {
        List<FileTuple> files = FileStreamer.forDisk((Disk)this.disk).ignoreErrors(true).includeTypeOfFile(TypeOfFile.FILE).matchGlobs(new String[]{this.originalFilename}).stream().collect(Collectors.toList());
        if (files.isEmpty()) {
            LOG.warning(() -> String.format("File not found for %s.", this.originalFilename));
        } else if (!this.multipleOverride && files.size() > 1) {
            LOG.severe(() -> String.format("Multile files with %s found (count = %d).", this.originalFilename, files.size()));
        } else {
            files.forEach(arg_0 -> this.fileHandler(arg_0));
        }
        return 0;
    }

    public void fileHandler(FileTuple tuple) {
        if (tuple.fileEntry.isLocked()) {
            if (this.lockOverride) {
                LOG.info(() -> String.format("File '%s' is locked, but 'force' specified; ignoring lock.", tuple.fileEntry.getFilename()));
            } else {
                LOG.warning(() -> String.format("File '%s' is locked.", tuple.fileEntry.getFilename()));
                return;
            }
        }
        tuple.fileEntry.setFilename(this.newFilename);
        LOG.info(() -> String.format("File '%s' renamed to '%s'.", this.originalFilename, this.newFilename));
    }
}

