/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.command;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import io.github.applecommander.acx.base.ReadWriteDiskCommandOptions;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="rmdir", description={"Remove a directory on disk."}, aliases={"rd"})
public class RmdirCommand
extends ReadWriteDiskCommandOptions {
    @CommandLine.Option(names={"-r", "--recursive"}, description={"Recursively delete subdirectories."})
    private boolean recursiveFlag;
    @CommandLine.Option(names={"-f", "--force"}, description={"Force files to be deleted as well."})
    private boolean forceFlag;
    @CommandLine.Parameters(description={"Directory name to delete (use '/' as divider)."})
    private String fullPath;

    public int handleCommand() throws Exception {
        FormattedDisk formattedDisk;
        FormattedDisk directory = formattedDisk = this.disk.getFormattedDisks()[0];
        String[] paths = this.fullPath.split("/");
        for (int i = 0; i < paths.length; ++i) {
            FileEntry fileEntry;
            String pathName = formattedDisk.getSuggestedFilename(paths[i]);
            Optional<FileEntry> optEntry = directory.getFiles().stream().filter(entry -> entry.getFilename().equalsIgnoreCase(pathName)).filter(entry -> !entry.isDeleted()).findFirst();
            if (optEntry.isPresent()) {
                fileEntry = optEntry.get();
                if (!(fileEntry instanceof DirectoryEntry)) {
                    throw new RuntimeException(String.format("Not a directory: '%s'", pathName));
                }
            } else {
                throw new RuntimeException(String.format("Directory does not exist: '%s'", pathName));
            }
            directory = (DirectoryEntry)fileEntry;
        }
        this.deleteDirectory((DirectoryEntry)directory);
        return 0;
    }

    public void deleteDirectory(DirectoryEntry directory) throws DiskException {
        for (FileEntry file : directory.getFiles()) {
            if (file.isDeleted()) continue;
            if (this.recursiveFlag && file.isDirectory()) {
                this.deleteDirectory((DirectoryEntry)file);
                continue;
            }
            if (this.forceFlag && !file.isDirectory()) {
                file.delete();
                continue;
            }
            String message = String.format("Encountered %s '%s'", file.isDirectory() ? "directory" : "file", file.getFilename());
            throw new RuntimeException(message);
        }
        FileEntry file = (FileEntry)directory;
        file.delete();
    }
}

