/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;

public class DataSizeConverter
implements CommandLine.ITypeConverter<Integer> {
    public static final int KB = 1024;
    public static final int MB = 0x100000;

    public Integer convert(String value) throws Exception {
        Pattern pattern = Pattern.compile("([0-9]+)([km]b?)?", 2);
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            String number = matcher.group(1);
            String kmb = matcher.group(2);
            if (kmb != null) {
                kmb = kmb.toLowerCase();
            }
            int bytes = Integer.parseInt(number);
            if (kmb.startsWith("k")) {
                bytes *= 1024;
            } else if (kmb.startsWith("m")) {
                bytes *= 0x100000;
            } else {
                throw new CommandLine.TypeConversionException(String.format("Unexpected data size '%s'", kmb));
            }
            return bytes;
        }
        throw new CommandLine.TypeConversionException("Expecting format like '140kb' or '5mb'");
    }

    public static String format(int value) {
        if (value < 1024) {
            return String.format("%,dB", value);
        }
        if (value < 0x100000) {
            return String.format("%,dKB", value / 1024);
        }
        return String.format("%,dMB", value / 0x100000);
    }
}

