/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.converter;

import com.webcodepro.applecommander.util.Host;
import picocli.CommandLine;

public class IntegerTypeConverter
implements CommandLine.ITypeConverter<Integer> {
    public Integer convert(String value) {
        try {
            if (value == null) {
                return null;
            }
            if (value.startsWith("$")) {
                return Integer.valueOf(value.substring(1), 16);
            }
            if (value.startsWith("0x") || value.startsWith("0X")) {
                return Integer.valueOf(value.substring(2), 16);
            }
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            Object msg = ex.getMessage();
            if (Host.isLinux() || Host.isMacosx()) {
                msg = (String)msg + " (check shell quoting if using '$')";
            }
            throw new NumberFormatException((String)msg);
        }
    }
}

