/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.acx.fileutil;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.FileEntryWriter;
import io.github.applecommander.acx.command.CopyFileCommand;
import java.util.Optional;
import java.util.logging.Logger;

public class FileUtils {
    private static Logger LOG = Logger.getLogger(CopyFileCommand.class.getName());
    private boolean overwrite;

    public FileUtils(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void copy(DirectoryEntry directory, FileEntry file) throws DiskException {
        LOG.fine(() -> String.format("Copying '%s' into directory '%s'", file.getFilename(), directory.getDirname()));
        if (!file.isDeleted()) {
            if (file.isDirectory()) {
                this.copyDirectory(directory, (DirectoryEntry)file, file.getFilename());
            } else {
                this.copyFile(directory, file);
            }
        }
    }

    void copyDirectory(DirectoryEntry targetParent, DirectoryEntry sourceDir, String name) throws DiskException {
        Optional<FileEntry> targetFile = targetParent.getFiles().stream().filter(fileEntry -> name.equals(fileEntry.getFilename())).filter(fileEntry -> !fileEntry.isDeleted()).findFirst();
        Optional<DirectoryEntry> targetDir = targetFile.filter(FileEntry::isDirectory).map(DirectoryEntry.class::cast);
        if (!targetDir.isPresent()) {
            if (targetFile.isPresent()) {
                throw new /* Unavailable Anonymous Inner Class!! */;
            }
            targetDir = Optional.of(targetParent.createDirectory(name));
        }
        for (FileEntry fileEntry2 : sourceDir.getFiles()) {
            this.copy(targetDir.get(), fileEntry2);
        }
    }

    void copyFile(DirectoryEntry directory, FileEntry sourceFile) throws DiskException {
        FileEntryReader source = FileEntryReader.get((FileEntry)sourceFile);
        this.copyFile(directory, source);
    }

    public void copyFile(DirectoryEntry directory, FileEntryReader source) throws DiskException {
        String sourceName = (String)source.getFilename().get();
        String sanitizedName = directory.getFormattedDisk().getSuggestedFilename(sourceName);
        Optional<FileEntry> fileEntry = directory.getFiles().stream().filter(entry -> entry.getFilename().equals(sanitizedName)).filter(entry -> !entry.isDeleted()).findFirst();
        FileEntry targetFile = fileEntry.isPresent() ? fileEntry.filter(entry -> this.overwrite).orElseThrow(() -> new RuntimeException(String.format("File '%s' exists.", source.getFilename().get()))) : directory.createFile();
        FileEntryWriter target = FileEntryWriter.get((FileEntry)targetFile);
        source.getFilename().ifPresent(arg_0 -> ((FileEntryWriter)target).setFilename(arg_0));
        source.getProdosFiletype().ifPresent(arg_0 -> ((FileEntryWriter)target).setProdosFiletype(arg_0));
        source.isLocked().ifPresent(arg_0 -> ((FileEntryWriter)target).setLocked(arg_0));
        source.getBinaryAddress().ifPresent(arg_0 -> ((FileEntryWriter)target).setBinaryAddress(arg_0));
        source.getBinaryLength().ifPresent(arg_0 -> ((FileEntryWriter)target).setBinaryLength(arg_0));
        source.getAuxiliaryType().ifPresent(arg_0 -> ((FileEntryWriter)target).setAuxiliaryType(arg_0));
        source.getCreationDate().ifPresent(arg_0 -> ((FileEntryWriter)target).setCreationDate(arg_0));
        if (source.getFileData().isPresent() && source.getResourceData().isPresent()) {
            target.setFileData((byte[])source.getFileData().get(), (byte[])source.getResourceData().get());
        } else {
            source.getFileData().ifPresent(arg_0 -> ((FileEntryWriter)target).setFileData(arg_0));
        }
        source.getLastModificationDate().ifPresent(arg_0 -> ((FileEntryWriter)target).setLastModificationDate(arg_0));
    }
}

