/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import io.github.applecommander.applesingle.AppleSingle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class AppleSingleFileFilter
implements FileFilter {
    public byte[] filter(FileEntry fileEntry) {
        try {
            AppleSingle.Builder builder = AppleSingle.builder().dataFork(fileEntry.getFileData()).realName(fileEntry.getFilename());
            if (fileEntry instanceof ProdosFileEntry) {
                this.handleProDOS(builder, (ProdosFileEntry)fileEntry);
            } else if (fileEntry instanceof DosFileEntry) {
                this.handleDOS(builder, (DosFileEntry)fileEntry);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            builder.build().save((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void handleProDOS(AppleSingle.Builder builder, ProdosFileEntry prodos) {
        int access = (prodos.canDestroy() ? 128 : 0) | (prodos.canRename() ? 64 : 0) | (prodos.canWrite() ? 2 : 0) | (prodos.canRead() ? 1 : 0);
        builder.access(access);
        builder.auxType(prodos.getAuxiliaryType());
        builder.creationDate(prodos.getCreationDate().toInstant());
        builder.fileType(prodos.getFiletypeByte());
        builder.modificationDate(prodos.getLastModificationDate().toInstant());
    }

    protected void handleDOS(AppleSingle.Builder builder, DosFileEntry dos) {
        switch (dos.getFiletype()) {
            case "T": {
                builder.fileType(4);
                break;
            }
            case "I": {
                builder.fileType(250);
                break;
            }
            case "A": {
                builder.fileType(252);
                break;
            }
            case "B": {
                builder.fileType(6);
                break;
            }
            default: {
                builder.fileType(241);
            }
        }
        builder.access(dos.isLocked() ? 1 : 195);
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        if (!((String)fileName).toLowerCase().endsWith(".as")) {
            fileName = (String)fileName + ".as";
        }
        return fileName;
    }
}

