/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.browserprefui;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BrowserPrefDialog
extends JDialog {
    private JList browserList = new JList();
    private String selectedBrowser = null;
    private static final String UI_BUNDLE = "edu.stanford.ejalbert.browserprefui.BrowserPrefs";

    public BrowserPrefDialog(Dialog owner, BrowserLauncher launcher) throws HeadlessException {
        super(owner, true);
        this.initDialog(launcher);
    }

    public BrowserPrefDialog(Frame owner, BrowserLauncher launcher) throws HeadlessException {
        super(owner, true);
        this.initDialog(launcher);
    }

    public String getSelectedBrowser() {
        return this.selectedBrowser;
    }

    private void initDialog(BrowserLauncher launcher) throws MissingResourceException {
        this.setDefaultCloseOperation(2);
        ResourceBundle rbundle = ResourceBundle.getBundle(UI_BUNDLE);
        this.setTitle(rbundle.getString("dialog.title"));
        List browsers = launcher.getBrowserList();
        this.browserList.setListData(browsers.toArray());
        this.browserList.setSelectionMode(0);
        String prefBrowser = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
        if (prefBrowser != null) {
            this.browserList.setSelectedValue(prefBrowser, true);
        }
        this.initGui(rbundle);
    }

    private void okButtonClicked() {
        this.selectedBrowser = (String)this.browserList.getSelectedValue();
        this.dispose();
    }

    private void cancelButtonClicked() {
        this.dispose();
    }

    private void initGui(ResourceBundle rbundle) throws MissingResourceException {
        JButton okButton = new JButton(rbundle.getString("dialog.bttn.ok"));
        JButton cancelButton = new JButton(rbundle.getString("dialog.bttn.cancel"));
        JScrollPane browserListScroll = new JScrollPane(this.browserList);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BrowserPrefDialog.this.okButtonClicked();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BrowserPrefDialog.this.cancelButtonClicked();
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout(0, 2));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        mainPanel.add((Component)browserListScroll, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add(mainPanel);
    }
}

