/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import edu.stanford.ejalbert.launching.utils.LaunchingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.wraplog.AbstractLogger;

class StandardUnixBrowser
implements UnixBrowser {
    private final String browserName;
    private final String browserArgName;
    private final String argsForOpenBrowser;
    private final String argsForStartBrowser;
    private final String argsForForcedBrowserWindow;

    StandardUnixBrowser(String configSep, String configStr) {
        String[] configItems = configStr.split(configSep, -2);
        this.browserName = configItems[0];
        this.browserArgName = configItems[1];
        this.argsForStartBrowser = configItems[2];
        this.argsForOpenBrowser = configItems[3];
        this.argsForForcedBrowserWindow = configItems.length == 5 ? configItems[4] : configItems[2];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("display name=");
        buf.append(this.browserName);
        buf.append(" executable name=");
        buf.append(this.browserArgName);
        buf.append(" argsForStartBrowser=");
        buf.append(this.argsForStartBrowser);
        buf.append(" argsForOpenBrowser=");
        buf.append(this.argsForOpenBrowser);
        return buf.toString();
    }

    private String[] getCommandLineArgs(String argsString, String urlString) {
        argsString = LaunchingUtils.replaceArgs(argsString, this.browserArgName, urlString);
        return argsString.split("[ ]");
    }

    @Override
    public String getBrowserDisplayName() {
        return this.browserName;
    }

    @Override
    public String getBrowserApplicationName() {
        return this.browserArgName;
    }

    @Override
    public String[] getArgsForOpenBrowser(String urlString) {
        String argsStartString = this.argsForOpenBrowser != null && this.argsForOpenBrowser.length() > 0 ? this.argsForOpenBrowser : this.argsForStartBrowser;
        return this.getCommandLineArgs(argsStartString, urlString);
    }

    @Override
    public String[] getArgsForStartingBrowser(String urlString) {
        return this.getCommandLineArgs(this.argsForStartBrowser, urlString);
    }

    @Override
    public String[] getArgsForForcingNewBrowserWindow(String urlString) {
        return this.getCommandLineArgs(this.argsForForcedBrowserWindow, urlString);
    }

    @Override
    public boolean isBrowserAvailable(AbstractLogger logger) {
        boolean isAvailable = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", this.browserArgName});
            InputStream errStream = process.getErrorStream();
            InputStream inStream = process.getInputStream();
            BufferedReader errIn = new BufferedReader(new InputStreamReader(errStream));
            BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
            String whichOutput = in.readLine();
            String whichErrOutput = errIn.readLine();
            in.close();
            errIn.close();
            if (whichOutput != null) {
                logger.debug(whichOutput);
            }
            if (whichErrOutput != null) {
                logger.debug(whichErrOutput);
            }
            isAvailable = whichOutput != null && whichOutput.startsWith("/");
        }
        catch (IOException ex) {
            logger.error("io error executing which command", ex);
        }
        return isAvailable;
    }
}

