/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixNetscapeBrowserLaunching;
import net.sf.wraplog.AbstractLogger;

public class SunOSBrowserLaunching
extends UnixNetscapeBrowserLaunching {
    public static final String CONFIGFILE_SUNOS = "/edu/stanford/ejalbert/launching/misc/sunOSConfig.properties";

    public SunOSBrowserLaunching(AbstractLogger logger) {
        super(logger, CONFIGFILE_SUNOS);
    }

    @Override
    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.logger.info(urlString);
            String browserId = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            StandardUnixBrowser defBrowser = this.getBrowser("Default");
            if (browserId != null) {
                this.logger.info("browser pref defined in system prop. Failing over to super.openUrl() method");
                super.openUrl(urlString);
            } else if (defBrowser == null) {
                this.logger.info("no default browser defined. Failing over to super.openUrl() method");
                super.openUrl(urlString);
            } else {
                this.logger.info(defBrowser.getBrowserDisplayName());
                int attemptId = this.browserEventCallback.getOpenAttemptId();
                Process process = Runtime.getRuntime().exec(defBrowser.getArgsForStartingBrowser(urlString));
                this.browserEventCallback.fireBrowserEvent(1, attemptId, process, defBrowser.getBrowserApplicationName(), urlString);
                process.waitFor();
            }
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }
}

