/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wraplog;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.wraplog.AbstractLogger;

public class SystemLogger
extends AbstractLogger {
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    @Override
    protected void reallyLog(int logLevel, String message, Throwable error) {
        PrintStream stream = logLevel < 2 ? System.out : System.err;
        if (message == null) {
            throw new NullPointerException("message must not be null");
        }
        if (stream == null) {
            throw new NullPointerException("stream must not be null");
        }
        String threadName = Thread.currentThread().getName();
        String dateAndTime = this.format.format(new Date());
        stream.println(dateAndTime + " [" + threadName + "] " + this.getLevelText(logLevel) + " " + message);
        if (error != null) {
            error.printStackTrace(stream);
        }
    }

    protected String getLevelText(int logLevel) {
        String result;
        if (logLevel == 0) {
            result = "DEBUG";
        } else if (logLevel == 1) {
            result = "INFO ";
        } else if (logLevel == 2) {
            result = "WARN ";
        } else if (logLevel == 3) {
            result = "ERROR";
        } else {
            throw new IllegalArgumentException("logLevel must be one of those defined in net.sf.warplog.Level, but is " + logLevel);
        }
        return result;
    }
}

