/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.util.List;
import net.sf.wraplog.AbstractLogger;

class BrowserLauncherRunner
implements Runnable {
    private final List targetBrowsers;
    private final String targetBrowser;
    private final String url;
    private final BrowserLauncherErrorHandler errorHandler;
    private final IBrowserLaunching launcher;
    private final AbstractLogger logger;

    BrowserLauncherRunner(IBrowserLaunching launcher, String url, AbstractLogger logger, BrowserLauncherErrorHandler errorHandler) {
        this(launcher, null, null, url, logger, errorHandler);
    }

    BrowserLauncherRunner(IBrowserLaunching launcher, String browserName, String url, AbstractLogger logger, BrowserLauncherErrorHandler errorHandler) {
        this(launcher, browserName, null, url, logger, errorHandler);
    }

    BrowserLauncherRunner(IBrowserLaunching launcher, List browserList, String url, AbstractLogger logger, BrowserLauncherErrorHandler errorHandler) {
        this(launcher, null, browserList, url, logger, errorHandler);
    }

    private BrowserLauncherRunner(IBrowserLaunching launcher, String browserName, List browserList, String url, AbstractLogger logger, BrowserLauncherErrorHandler errorHandler) {
        if (launcher == null) {
            throw new IllegalArgumentException("launcher cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException("errorHandler cannot be null.");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger cannot be null");
        }
        this.targetBrowsers = browserList;
        this.launcher = launcher;
        this.url = url;
        this.targetBrowser = browserName;
        this.errorHandler = errorHandler;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            if (this.targetBrowser != null) {
                this.launcher.openUrl(this.targetBrowser, this.url);
            } else if (this.targetBrowsers != null) {
                this.launcher.openUrl(this.targetBrowsers, this.url);
            } else {
                this.launcher.openUrl(this.url);
            }
        }
        catch (Exception ex) {
            this.logger.error("fatal error opening url", ex);
            this.errorHandler.handleException(ex);
        }
    }
}

